/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasureScoring {
    PROPORTION,
    RATIO,
    CONTINUOUSVARIABLE,
    COHORT,
    NULL;


    public static MeasureScoring fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proportion".equals(codeString)) {
            return PROPORTION;
        }
        if ("ratio".equals(codeString)) {
            return RATIO;
        }
        if ("continuous-variable".equals(codeString)) {
            return CONTINUOUSVARIABLE;
        }
        if ("cohort".equals(codeString)) {
            return COHORT;
        }
        throw new FHIRException("Unknown MeasureScoring code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPORTION: {
                return "proportion";
            }
            case RATIO: {
                return "ratio";
            }
            case CONTINUOUSVARIABLE: {
                return "continuous-variable";
            }
            case COHORT: {
                return "cohort";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-scoring";
    }

    public String getDefinition() {
        switch (this) {
            case PROPORTION: {
                return "The measure score is defined using a proportion";
            }
            case RATIO: {
                return "The measure score is defined using a ratio";
            }
            case CONTINUOUSVARIABLE: {
                return "The score is defined by a calculation of some quantity";
            }
            case COHORT: {
                return "The measure is a cohort definition";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPORTION: {
                return "Proportion";
            }
            case RATIO: {
                return "Ratio";
            }
            case CONTINUOUSVARIABLE: {
                return "Continuous Variable";
            }
            case COHORT: {
                return "Cohort";
            }
        }
        return "?";
    }
}

