/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.DigitalMediaSubtype;

public class DigitalMediaSubtypeEnumFactory
implements EnumFactory<DigitalMediaSubtype> {
    @Override
    public DigitalMediaSubtype fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("diagram".equals(codeString)) {
            return DigitalMediaSubtype.DIAGRAM;
        }
        if ("fax".equals(codeString)) {
            return DigitalMediaSubtype.FAX;
        }
        if ("scan".equals(codeString)) {
            return DigitalMediaSubtype.SCAN;
        }
        if ("retina".equals(codeString)) {
            return DigitalMediaSubtype.RETINA;
        }
        if ("fingerprint".equals(codeString)) {
            return DigitalMediaSubtype.FINGERPRINT;
        }
        if ("iris".equals(codeString)) {
            return DigitalMediaSubtype.IRIS;
        }
        if ("palm".equals(codeString)) {
            return DigitalMediaSubtype.PALM;
        }
        if ("face".equals(codeString)) {
            return DigitalMediaSubtype.FACE;
        }
        throw new IllegalArgumentException("Unknown DigitalMediaSubtype code '" + codeString + "'");
    }

    @Override
    public String toCode(DigitalMediaSubtype code) {
        if (code == DigitalMediaSubtype.DIAGRAM) {
            return "diagram";
        }
        if (code == DigitalMediaSubtype.FAX) {
            return "fax";
        }
        if (code == DigitalMediaSubtype.SCAN) {
            return "scan";
        }
        if (code == DigitalMediaSubtype.RETINA) {
            return "retina";
        }
        if (code == DigitalMediaSubtype.FINGERPRINT) {
            return "fingerprint";
        }
        if (code == DigitalMediaSubtype.IRIS) {
            return "iris";
        }
        if (code == DigitalMediaSubtype.PALM) {
            return "palm";
        }
        if (code == DigitalMediaSubtype.FACE) {
            return "face";
        }
        return "?";
    }

    @Override
    public String toSystem(DigitalMediaSubtype code) {
        return code.getSystem();
    }
}

