/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Devicestatus {
    AVAILABLE,
    NOTAVAILABLE,
    ENTEREDINERROR,
    NULL;


    public static Devicestatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("available".equals(codeString)) {
            return AVAILABLE;
        }
        if ("not-available".equals(codeString)) {
            return NOTAVAILABLE;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown Devicestatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AVAILABLE: {
                return "available";
            }
            case NOTAVAILABLE: {
                return "not-available";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/devicestatus";
    }

    public String getDefinition() {
        switch (this) {
            case AVAILABLE: {
                return "The Device is available for use.";
            }
            case NOTAVAILABLE: {
                return "The Device is no longer available for use (e.g. lost, expired, damaged).";
            }
            case ENTEREDINERROR: {
                return "The Device was entered in error and voided.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AVAILABLE: {
                return "Available";
            }
            case NOTAVAILABLE: {
                return "Not Available";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

