/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.DeviceAction;

public class DeviceActionEnumFactory
implements EnumFactory<DeviceAction> {
    @Override
    public DeviceAction fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("implanted".equals(codeString)) {
            return DeviceAction.IMPLANTED;
        }
        if ("explanted".equals(codeString)) {
            return DeviceAction.EXPLANTED;
        }
        if ("manipulated".equals(codeString)) {
            return DeviceAction.MANIPULATED;
        }
        throw new IllegalArgumentException("Unknown DeviceAction code '" + codeString + "'");
    }

    @Override
    public String toCode(DeviceAction code) {
        if (code == DeviceAction.IMPLANTED) {
            return "implanted";
        }
        if (code == DeviceAction.EXPLANTED) {
            return "explanted";
        }
        if (code == DeviceAction.MANIPULATED) {
            return "manipulated";
        }
        return "?";
    }

    @Override
    public String toSystem(DeviceAction code) {
        return code.getSystem();
    }
}

