/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractSubtype {
    DISCLOSURECA,
    DISCLOSUREUS,
    NULL;


    public static ContractSubtype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("disclosure-CA".equals(codeString)) {
            return DISCLOSURECA;
        }
        if ("disclosure-US".equals(codeString)) {
            return DISCLOSUREUS;
        }
        throw new FHIRException("Unknown ContractSubtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DISCLOSURECA: {
                return "disclosure-CA";
            }
            case DISCLOSUREUS: {
                return "disclosure-US";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contractsubtypecodes";
    }

    public String getDefinition() {
        switch (this) {
            case DISCLOSURECA: {
                return "";
            }
            case DISCLOSUREUS: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DISCLOSURECA: {
                return "disclosure-CA";
            }
            case DISCLOSUREUS: {
                return "disclosure-US";
            }
        }
        return "?";
    }
}

