/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ConceptMapEquivalence;

public class ConceptMapEquivalenceEnumFactory
implements EnumFactory<ConceptMapEquivalence> {
    @Override
    public ConceptMapEquivalence fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("equivalent".equals(codeString)) {
            return ConceptMapEquivalence.EQUIVALENT;
        }
        if ("equal".equals(codeString)) {
            return ConceptMapEquivalence.EQUAL;
        }
        if ("wider".equals(codeString)) {
            return ConceptMapEquivalence.WIDER;
        }
        if ("subsumes".equals(codeString)) {
            return ConceptMapEquivalence.SUBSUMES;
        }
        if ("narrower".equals(codeString)) {
            return ConceptMapEquivalence.NARROWER;
        }
        if ("specializes".equals(codeString)) {
            return ConceptMapEquivalence.SPECIALIZES;
        }
        if ("inexact".equals(codeString)) {
            return ConceptMapEquivalence.INEXACT;
        }
        if ("unmatched".equals(codeString)) {
            return ConceptMapEquivalence.UNMATCHED;
        }
        if ("disjoint".equals(codeString)) {
            return ConceptMapEquivalence.DISJOINT;
        }
        throw new IllegalArgumentException("Unknown ConceptMapEquivalence code '" + codeString + "'");
    }

    @Override
    public String toCode(ConceptMapEquivalence code) {
        if (code == ConceptMapEquivalence.EQUIVALENT) {
            return "equivalent";
        }
        if (code == ConceptMapEquivalence.EQUAL) {
            return "equal";
        }
        if (code == ConceptMapEquivalence.WIDER) {
            return "wider";
        }
        if (code == ConceptMapEquivalence.SUBSUMES) {
            return "subsumes";
        }
        if (code == ConceptMapEquivalence.NARROWER) {
            return "narrower";
        }
        if (code == ConceptMapEquivalence.SPECIALIZES) {
            return "specializes";
        }
        if (code == ConceptMapEquivalence.INEXACT) {
            return "inexact";
        }
        if (code == ConceptMapEquivalence.UNMATCHED) {
            return "unmatched";
        }
        if (code == ConceptMapEquivalence.DISJOINT) {
            return "disjoint";
        }
        return "?";
    }

    @Override
    public String toSystem(ConceptMapEquivalence code) {
        return code.getSystem();
    }
}

