/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum BindingStrength {
    REQUIRED,
    EXTENSIBLE,
    PREFERRED,
    EXAMPLE,
    NULL;


    public static BindingStrength fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("required".equals(codeString)) {
            return REQUIRED;
        }
        if ("extensible".equals(codeString)) {
            return EXTENSIBLE;
        }
        if ("preferred".equals(codeString)) {
            return PREFERRED;
        }
        if ("example".equals(codeString)) {
            return EXAMPLE;
        }
        throw new FHIRException("Unknown BindingStrength code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REQUIRED: {
                return "required";
            }
            case EXTENSIBLE: {
                return "extensible";
            }
            case PREFERRED: {
                return "preferred";
            }
            case EXAMPLE: {
                return "example";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/binding-strength";
    }

    public String getDefinition() {
        switch (this) {
            case REQUIRED: {
                return "To be conformant, instances of this element SHALL include a code from the specified value set.";
            }
            case EXTENSIBLE: {
                return "To be conformant, instances of this element SHALL include a code from the specified value set if any of the codes within the value set can apply to the concept being communicated.  If the value set does not cover the concept (based on human review), alternate codings (or, data type allowing, text) may be included instead.";
            }
            case PREFERRED: {
                return "Instances are encouraged to draw from the specified codes for interoperability purposes but are not required to do so to be considered conformant.";
            }
            case EXAMPLE: {
                return "Instances are not expected or even encouraged to draw from the specified value set.  The value set merely provides examples of the types of concepts intended to be included.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REQUIRED: {
                return "Required";
            }
            case EXTENSIBLE: {
                return "Extensible";
            }
            case PREFERRED: {
                return "Preferred";
            }
            case EXAMPLE: {
                return "Example";
            }
        }
        return "?";
    }
}

