/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionRelationshipAnchor {
    START,
    END,
    NULL;


    public static ActionRelationshipAnchor fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("start".equals(codeString)) {
            return START;
        }
        if ("end".equals(codeString)) {
            return END;
        }
        throw new FHIRException("Unknown ActionRelationshipAnchor code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case START: {
                return "start";
            }
            case END: {
                return "end";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-relationship-anchor";
    }

    public String getDefinition() {
        switch (this) {
            case START: {
                return "The action relationship is anchored to the start of the related action";
            }
            case END: {
                return "The action relationship is anchored to the end of the related action";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case START: {
                return "Start";
            }
            case END: {
                return "End";
            }
        }
        return "?";
    }
}

