/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.ImagingStudy;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingObjectSelection", profile="http://hl7.org/fhir/Profile/ImagingObjectSelection")
public class ImagingObjectSelection
extends DomainResource {
    @Child(name="uid", type={OidType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Instance UID", formalDefinition="Instance UID of the DICOM KOS SOP Instances represented in this resource.")
    protected OidType uid;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient of the selected objects", formalDefinition="A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingObjectSelection.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="authoringTime", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time when the imaging object selection was created", formalDefinition="Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).")
    protected DateTimeType authoringTime;
    @Child(name="author", type={Practitioner.class, Device.class, Organization.class, Patient.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Author (human or machine)", formalDefinition="Author of ImagingObjectSelection. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="title", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for selection", formalDefinition="The reason for, or significance of, the selection of objects referenced in the resource.")
    protected CodeableConcept title;
    @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description text", formalDefinition="Text description of the DICOM SOP instances selected in the ImagingObjectSelection. This should be aligned with the content of the title element, and can provide further explanation of the SOP instances in the selection.")
    protected StringType description;
    @Child(name="study", type={}, order=6, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Study identity of the selected instances", formalDefinition="Study identity and locating information of the DICOM SOP instances in the selection.")
    protected List<StudyComponent> study;
    private static final long serialVersionUID = 1428713335L;
    @SearchParamDefinition(name="selected-study", path="ImagingObjectSelection.study.uid", description="Study selected in key DICOM object selection", type="uri")
    public static final String SP_SELECTED_STUDY = "selected-study";
    public static final UriClientParam SELECTED_STUDY = new UriClientParam("selected-study");
    @SearchParamDefinition(name="author", path="ImagingObjectSelection.author", description="Author of key DICOM object selection", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("ImagingObjectSelection:author").toLocked();
    @SearchParamDefinition(name="title", path="ImagingObjectSelection.title", description="Title of key DICOM object selection", type="token")
    public static final String SP_TITLE = "title";
    public static final TokenClientParam TITLE = new TokenClientParam("title");
    @SearchParamDefinition(name="patient", path="ImagingObjectSelection.patient", description="Subject of key DICOM object selection", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingObjectSelection:patient").toLocked();
    @SearchParamDefinition(name="authoring-time", path="ImagingObjectSelection.authoringTime", description="Time of key DICOM object selection authoring", type="date")
    public static final String SP_AUTHORING_TIME = "authoring-time";
    public static final DateClientParam AUTHORING_TIME = new DateClientParam("authoring-time");
    @SearchParamDefinition(name="identifier", path="ImagingObjectSelection.uid", description="UID of key DICOM object selection", type="uri")
    public static final String SP_IDENTIFIER = "identifier";
    public static final UriClientParam IDENTIFIER = new UriClientParam("identifier");

    public ImagingObjectSelection() {
    }

    public ImagingObjectSelection(OidType uid, Reference patient, CodeableConcept title) {
        this.uid = uid;
        this.patient = patient;
        this.title = title;
    }

    public OidType getUidElement() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new OidType();
            }
        }
        return this.uid;
    }

    public boolean hasUidElement() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public ImagingObjectSelection setUidElement(OidType value) {
        this.uid = value;
        return this;
    }

    public String getUid() {
        return this.uid == null ? null : (String)this.uid.getValue();
    }

    public ImagingObjectSelection setUid(String value) {
        if (this.uid == null) {
            this.uid = new OidType();
        }
        this.uid.setValue(value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImagingObjectSelection setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImagingObjectSelection setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getAuthoringTimeElement() {
        if (this.authoringTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.authoringTime");
            }
            if (Configuration.doAutoCreate()) {
                this.authoringTime = new DateTimeType();
            }
        }
        return this.authoringTime;
    }

    public boolean hasAuthoringTimeElement() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public boolean hasAuthoringTime() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public ImagingObjectSelection setAuthoringTimeElement(DateTimeType value) {
        this.authoringTime = value;
        return this;
    }

    public Date getAuthoringTime() {
        return this.authoringTime == null ? null : (Date)this.authoringTime.getValue();
    }

    public ImagingObjectSelection setAuthoringTime(Date value) {
        if (value == null) {
            this.authoringTime = null;
        } else {
            if (this.authoringTime == null) {
                this.authoringTime = new DateTimeType();
            }
            this.authoringTime.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public ImagingObjectSelection setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public ImagingObjectSelection setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public CodeableConcept getTitle() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new CodeableConcept();
            }
        }
        return this.title;
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ImagingObjectSelection setTitle(CodeableConcept value) {
        this.title = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImagingObjectSelection setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImagingObjectSelection setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<StudyComponent> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        return this.study;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (StudyComponent item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StudyComponent addStudy() {
        StudyComponent t = new StudyComponent();
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return t;
    }

    public ImagingObjectSelection addStudy(StudyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("uid", "oid", "Instance UID of the DICOM KOS SOP Instances represented in this resource.", 0, Integer.MAX_VALUE, this.uid));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingObjectSelection.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("authoringTime", "dateTime", "Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).", 0, Integer.MAX_VALUE, this.authoringTime));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner|Device|Organization|Patient|RelatedPerson)", "Author of ImagingObjectSelection. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_TITLE, "CodeableConcept", "The reason for, or significance of, the selection of objects referenced in the resource.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property("description", "string", "Text description of the DICOM SOP instances selected in the ImagingObjectSelection. This should be aligned with the content of the title element, and can provide further explanation of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("study", "", "Study identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.study));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.uid;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -1724532252: {
                Base[] baseArray;
                if (this.authoringTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.authoringTime;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.author;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case 109776329: {
                return this.study == null ? new Base[]{} : this.study.toArray(new Base[this.study.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 115792: {
                this.uid = this.castToOid(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -1724532252: {
                this.authoringTime = this.castToDateTime(value);
                break;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case 110371416: {
                this.title = this.castToCodeableConcept(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case 109776329: {
                this.getStudy().add((StudyComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = this.castToOid(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("authoringTime")) {
            this.authoringTime = this.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("study")) {
            this.getStudy().add((StudyComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                throw new FHIRException("Cannot make property uid as it is not a complex type");
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1724532252: {
                throw new FHIRException("Cannot make property authoringTime as it is not a complex type");
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 110371416: {
                return this.getTitle();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case 109776329: {
                return this.addStudy();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("uid")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("authoringTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.authoringTime");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_TITLE)) {
            this.title = new CodeableConcept();
            return this.title;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.description");
        }
        if (name.equals("study")) {
            return this.addStudy();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingObjectSelection";
    }

    @Override
    public ImagingObjectSelection copy() {
        ImagingObjectSelection dst = new ImagingObjectSelection();
        this.copyValues(dst);
        dst.uid = this.uid == null ? null : this.uid.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.authoringTime = this.authoringTime == null ? null : this.authoringTime.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.title = this.title == null ? null : this.title.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.study != null) {
            dst.study = new ArrayList<StudyComponent>();
            for (StudyComponent i : this.study) {
                dst.study.add(i.copy());
            }
        }
        return dst;
    }

    protected ImagingObjectSelection typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ImagingObjectSelection)) {
            return false;
        }
        ImagingObjectSelection o = (ImagingObjectSelection)other;
        return ImagingObjectSelection.compareDeep(this.uid, o.uid, true) && ImagingObjectSelection.compareDeep(this.patient, o.patient, true) && ImagingObjectSelection.compareDeep(this.authoringTime, o.authoringTime, true) && ImagingObjectSelection.compareDeep(this.author, o.author, true) && ImagingObjectSelection.compareDeep(this.title, o.title, true) && ImagingObjectSelection.compareDeep(this.description, o.description, true) && ImagingObjectSelection.compareDeep(this.study, o.study, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ImagingObjectSelection)) {
            return false;
        }
        ImagingObjectSelection o = (ImagingObjectSelection)other;
        return ImagingObjectSelection.compareValues(this.uid, o.uid, true) && ImagingObjectSelection.compareValues(this.authoringTime, o.authoringTime, true) && ImagingObjectSelection.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.authoringTime != null && !this.authoringTime.isEmpty() || this.author != null && !this.author.isEmpty() || this.title != null && !this.title.isEmpty() || this.description != null && !this.description.isEmpty() || this.study != null && !this.study.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingObjectSelection;
    }

    @Block
    public static class FramesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={UnsignedIntType.class}, order=1, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Frame reference number", formalDefinition="The specific frame reference within a multi-frame object.")
        protected List<UnsignedIntType> number;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve frame URL", formalDefinition="WADO-RS URL to retrieve the DICOM frames.")
        protected UriType url;
        private static final long serialVersionUID = 236505178L;

        public FramesComponent() {
        }

        public FramesComponent(UriType url) {
            this.url = url;
        }

        public List<UnsignedIntType> getNumber() {
            if (this.number == null) {
                this.number = new ArrayList<UnsignedIntType>();
            }
            return this.number;
        }

        public boolean hasNumber() {
            if (this.number == null) {
                return false;
            }
            for (UnsignedIntType item : this.number) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addNumberElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.number == null) {
                this.number = new ArrayList<UnsignedIntType>();
            }
            this.number.add(t);
            return t;
        }

        public FramesComponent addNumber(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.number == null) {
                this.number = new ArrayList<UnsignedIntType>();
            }
            this.number.add(t);
            return this;
        }

        public boolean hasNumber(int value) {
            if (this.number == null) {
                return false;
            }
            for (UnsignedIntType v : this.number) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FramesComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public FramesComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public FramesComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("number", "unsignedInt", "The specific frame reference within a multi-frame object.", 0, Integer.MAX_VALUE, this.number));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the DICOM frames.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.number == null ? new Base[]{} : this.number.toArray(new Base[this.number.size()]);
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.getNumber().add(this.castToUnsignedInt(value));
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.getNumber().add(this.castToUnsignedInt(value));
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    throw new FHIRException("Cannot make property number as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.number");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            return super.addChild(name);
        }

        @Override
        public FramesComponent copy() {
            FramesComponent dst = new FramesComponent();
            this.copyValues(dst);
            if (this.number != null) {
                dst.number = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType i : this.number) {
                    dst.number.add(i.copy());
                }
            }
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof FramesComponent)) {
                return false;
            }
            FramesComponent o = (FramesComponent)other;
            return FramesComponent.compareDeep(this.number, o.number, true) && FramesComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof FramesComponent)) {
                return false;
            }
            FramesComponent o = (FramesComponent)other;
            return FramesComponent.compareValues(this.number, o.number, true) && FramesComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.number != null && !this.number.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study.series.instance.frame";
        }
    }

    @Block
    public static class InstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sopClass", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="SOP class UID of instance", formalDefinition="SOP class UID of the selected instance.")
        protected OidType sopClass;
        @Child(name="uid", type={OidType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Selected instance UID", formalDefinition="SOP Instance UID of the selected instance.")
        protected OidType uid;
        @Child(name="url", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve instance URL", formalDefinition="WADO-RS URL to retrieve the DICOM SOP Instance.")
        protected UriType url;
        @Child(name="frame", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The frame set", formalDefinition="Identity and location information of the frames in the selected instance.")
        protected List<FramesComponent> frame;
        private static final long serialVersionUID = -1609681911L;

        public InstanceComponent() {
        }

        public InstanceComponent(OidType sopClass, OidType uid, UriType url) {
            this.sopClass = sopClass;
            this.uid = uid;
            this.url = url;
        }

        public OidType getSopClassElement() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new OidType();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClassElement() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public InstanceComponent setSopClassElement(OidType value) {
            this.sopClass = value;
            return this;
        }

        public String getSopClass() {
            return this.sopClass == null ? null : (String)this.sopClass.getValue();
        }

        public InstanceComponent setSopClass(String value) {
            if (this.sopClass == null) {
                this.sopClass = new OidType();
            }
            this.sopClass.setValue(value);
            return this;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public InstanceComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public InstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public InstanceComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public InstanceComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public List<FramesComponent> getFrame() {
            if (this.frame == null) {
                this.frame = new ArrayList<FramesComponent>();
            }
            return this.frame;
        }

        public boolean hasFrame() {
            if (this.frame == null) {
                return false;
            }
            for (FramesComponent item : this.frame) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public FramesComponent addFrame() {
            FramesComponent t = new FramesComponent();
            if (this.frame == null) {
                this.frame = new ArrayList<FramesComponent>();
            }
            this.frame.add(t);
            return t;
        }

        public InstanceComponent addFrame(FramesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.frame == null) {
                this.frame = new ArrayList<FramesComponent>();
            }
            this.frame.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sopClass", "oid", "SOP class UID of the selected instance.", 0, Integer.MAX_VALUE, this.sopClass));
            childrenList.add(new Property("uid", "oid", "SOP Instance UID of the selected instance.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the DICOM SOP Instance.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("frame", "", "Identity and location information of the frames in the selected instance.", 0, Integer.MAX_VALUE, this.frame));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uid;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.url;
                    }
                    return baseArray;
                }
                case 97692013: {
                    return this.frame == null ? new Base[]{} : this.frame.toArray(new Base[this.frame.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    this.sopClass = this.castToOid(value);
                    break;
                }
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case 97692013: {
                    this.getFrame().add((FramesComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sopClass")) {
                this.sopClass = this.castToOid(value);
            } else if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("frame")) {
                this.getFrame().add((FramesComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    throw new FHIRException("Cannot make property sopClass as it is not a complex type");
                }
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case 97692013: {
                    return this.addFrame();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sopClass")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.sopClass");
            }
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            if (name.equals("frame")) {
                return this.addFrame();
            }
            return super.addChild(name);
        }

        @Override
        public InstanceComponent copy() {
            InstanceComponent dst = new InstanceComponent();
            this.copyValues(dst);
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            dst.uid = this.uid == null ? null : this.uid.copy();
            UriType uriType = dst.url = this.url == null ? null : this.url.copy();
            if (this.frame != null) {
                dst.frame = new ArrayList<FramesComponent>();
                for (FramesComponent i : this.frame) {
                    dst.frame.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other;
            return InstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && InstanceComponent.compareDeep(this.uid, o.uid, true) && InstanceComponent.compareDeep(this.url, o.url, true) && InstanceComponent.compareDeep(this.frame, o.frame, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other;
            return InstanceComponent.compareValues(this.sopClass, o.sopClass, true) && InstanceComponent.compareValues(this.uid, o.uid, true) && InstanceComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sopClass != null && !this.sopClass.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.url != null && !this.url.isEmpty() || this.frame != null && !this.frame.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study.series.instance";
        }
    }

    @Block
    public static class SeriesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Series instance UID", formalDefinition="Series instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve series URL", formalDefinition="WADO-RS URL to retrieve the series. Note that this URL retrieves all SOP instances of the series not only those in the selection.")
        protected UriType url;
        @Child(name="instance", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The selected instance", formalDefinition="Identity and locating information of the selected DICOM SOP instances.")
        protected List<InstanceComponent> instance;
        private static final long serialVersionUID = 229247770L;

        public SeriesComponent() {
        }

        public SeriesComponent(OidType uid) {
            this.uid = uid;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public SeriesComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public SeriesComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public SeriesComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public SeriesComponent setUrl(String value) {
            if (Utilities.noString(value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public List<InstanceComponent> getInstance() {
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            return this.instance;
        }

        public boolean hasInstance() {
            if (this.instance == null) {
                return false;
            }
            for (InstanceComponent item : this.instance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InstanceComponent addInstance() {
            InstanceComponent t = new InstanceComponent();
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return t;
        }

        public SeriesComponent addInstance(InstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("uid", "oid", "Series instance UID of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the series. Note that this URL retrieves all SOP instances of the series not only those in the selection.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("instance", "", "Identity and locating information of the selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 555127957: {
                    return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case 555127957: {
                    this.getInstance().add((InstanceComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("instance")) {
                this.getInstance().add((InstanceComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case 555127957: {
                    return this.addInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            if (name.equals("instance")) {
                return this.addInstance();
            }
            return super.addChild(name);
        }

        @Override
        public SeriesComponent copy() {
            SeriesComponent dst = new SeriesComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            UriType uriType = dst.url = this.url == null ? null : this.url.copy();
            if (this.instance != null) {
                dst.instance = new ArrayList<InstanceComponent>();
                for (InstanceComponent i : this.instance) {
                    dst.instance.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other;
            return SeriesComponent.compareDeep(this.uid, o.uid, true) && SeriesComponent.compareDeep(this.url, o.url, true) && SeriesComponent.compareDeep(this.instance, o.instance, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other;
            return SeriesComponent.compareValues(this.uid, o.uid, true) && SeriesComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.url != null && !this.url.isEmpty() || this.instance != null && !this.instance.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study.series";
        }
    }

    @Block
    public static class StudyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Study instance UID", formalDefinition="Study instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve study URL", formalDefinition="WADO-RS URL to retrieve the study. Note that this URL retrieves all SOP instances of the study, not only those in the selection.")
        protected UriType url;
        @Child(name="imagingStudy", type={ImagingStudy.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to ImagingStudy", formalDefinition="Reference to the Imaging Study in FHIR form.")
        protected Reference imagingStudy;
        protected ImagingStudy imagingStudyTarget;
        @Child(name="series", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Series identity of the selected instances", formalDefinition="Series identity and locating information of the DICOM SOP instances in the selection.")
        protected List<SeriesComponent> series;
        private static final long serialVersionUID = 341246743L;

        public StudyComponent() {
        }

        public StudyComponent(OidType uid) {
            this.uid = uid;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public StudyComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public StudyComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public StudyComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public StudyComponent setUrl(String value) {
            if (Utilities.noString(value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public Reference getImagingStudy() {
            if (this.imagingStudy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudy = new Reference();
                }
            }
            return this.imagingStudy;
        }

        public boolean hasImagingStudy() {
            return this.imagingStudy != null && !this.imagingStudy.isEmpty();
        }

        public StudyComponent setImagingStudy(Reference value) {
            this.imagingStudy = value;
            return this;
        }

        public ImagingStudy getImagingStudyTarget() {
            if (this.imagingStudyTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudyTarget = new ImagingStudy();
                }
            }
            return this.imagingStudyTarget;
        }

        public StudyComponent setImagingStudyTarget(ImagingStudy value) {
            this.imagingStudyTarget = value;
            return this;
        }

        public List<SeriesComponent> getSeries() {
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            return this.series;
        }

        public boolean hasSeries() {
            if (this.series == null) {
                return false;
            }
            for (SeriesComponent item : this.series) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SeriesComponent addSeries() {
            SeriesComponent t = new SeriesComponent();
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return t;
        }

        public StudyComponent addSeries(SeriesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("uid", "oid", "Study instance UID of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the study. Note that this URL retrieves all SOP instances of the study, not only those in the selection.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("imagingStudy", "Reference(ImagingStudy)", "Reference to the Imaging Study in FHIR form.", 0, Integer.MAX_VALUE, this.imagingStudy));
            childrenList.add(new Property("series", "", "Series identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.series));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case -814900911: {
                    Base[] baseArray;
                    if (this.imagingStudy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.imagingStudy;
                    }
                    return baseArray;
                }
                case -905838985: {
                    return this.series == null ? new Base[]{} : this.series.toArray(new Base[this.series.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case -814900911: {
                    this.imagingStudy = this.castToReference(value);
                    break;
                }
                case -905838985: {
                    this.getSeries().add((SeriesComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("imagingStudy")) {
                this.imagingStudy = this.castToReference(value);
            } else if (name.equals("series")) {
                this.getSeries().add((SeriesComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case -814900911: {
                    return this.getImagingStudy();
                }
                case -905838985: {
                    return this.addSeries();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            if (name.equals("imagingStudy")) {
                this.imagingStudy = new Reference();
                return this.imagingStudy;
            }
            if (name.equals("series")) {
                return this.addSeries();
            }
            return super.addChild(name);
        }

        @Override
        public StudyComponent copy() {
            StudyComponent dst = new StudyComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.url = this.url == null ? null : this.url.copy();
            Reference reference = dst.imagingStudy = this.imagingStudy == null ? null : this.imagingStudy.copy();
            if (this.series != null) {
                dst.series = new ArrayList<SeriesComponent>();
                for (SeriesComponent i : this.series) {
                    dst.series.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other;
            return StudyComponent.compareDeep(this.uid, o.uid, true) && StudyComponent.compareDeep(this.url, o.url, true) && StudyComponent.compareDeep(this.imagingStudy, o.imagingStudy, true) && StudyComponent.compareDeep(this.series, o.series, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other;
            return StudyComponent.compareValues(this.uid, o.uid, true) && StudyComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.url != null && !this.url.isEmpty() || this.imagingStudy != null && !this.imagingStudy.isEmpty() || this.series != null && !this.series.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study";
        }
    }
}

