/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.ImagingStudy;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingExcerpt", profile="http://hl7.org/fhir/Profile/ImagingExcerpt")
public class ImagingExcerpt
extends DomainResource {
    @Child(name="uid", type={OidType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Instance UID", formalDefinition="Unique identifier of the DICOM Key Object Selection (KOS) representation.")
    protected OidType uid;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient of the selected objects", formalDefinition="A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingExcerpt.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="authoringTime", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time when the imaging object selection was created", formalDefinition="Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).")
    protected DateTimeType authoringTime;
    @Child(name="author", type={Practitioner.class, Device.class, Organization.class, Patient.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Author (human or machine)", formalDefinition="Author of ImagingExcerpt. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="title", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for selection", formalDefinition="The reason for, or significance of, the selection of objects referenced in the resource.")
    protected CodeableConcept title;
    @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description text", formalDefinition="Text description of the DICOM SOP instances selected in the ImagingExcerpt. This should be aligned with the content of the title element, and can provide further explanation of the SOP instances in the selection.")
    protected StringType description;
    @Child(name="study", type={}, order=6, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Study identity of the selected instances", formalDefinition="Study identity and locating information of the DICOM SOP instances in the selection.")
    protected List<StudyComponent> study;
    private static final long serialVersionUID = 1428713335L;
    @SearchParamDefinition(name="selected-study", path="ImagingExcerpt.study.uid", description="Study selected in key DICOM object selection", type="uri")
    public static final String SP_SELECTED_STUDY = "selected-study";
    public static final UriClientParam SELECTED_STUDY = new UriClientParam("selected-study");
    @SearchParamDefinition(name="author", path="ImagingExcerpt.author", description="Author of key DICOM object selection", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("ImagingExcerpt:author").toLocked();
    @SearchParamDefinition(name="title", path="ImagingExcerpt.title", description="Title of key DICOM object selection", type="token")
    public static final String SP_TITLE = "title";
    public static final TokenClientParam TITLE = new TokenClientParam("title");
    @SearchParamDefinition(name="patient", path="ImagingExcerpt.patient", description="Subject of key DICOM object selection", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingExcerpt:patient").toLocked();
    @SearchParamDefinition(name="authoring-time", path="ImagingExcerpt.authoringTime", description="Time of key DICOM object selection authoring", type="date")
    public static final String SP_AUTHORING_TIME = "authoring-time";
    public static final DateClientParam AUTHORING_TIME = new DateClientParam("authoring-time");
    @SearchParamDefinition(name="identifier", path="ImagingExcerpt.uid", description="UID of key DICOM object selection", type="uri")
    public static final String SP_IDENTIFIER = "identifier";
    public static final UriClientParam IDENTIFIER = new UriClientParam("identifier");

    public ImagingExcerpt() {
    }

    public ImagingExcerpt(OidType uid, Reference patient, CodeableConcept title) {
        this.uid = uid;
        this.patient = patient;
        this.title = title;
    }

    public OidType getUidElement() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingExcerpt.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new OidType();
            }
        }
        return this.uid;
    }

    public boolean hasUidElement() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public ImagingExcerpt setUidElement(OidType value) {
        this.uid = value;
        return this;
    }

    public String getUid() {
        return this.uid == null ? null : (String)this.uid.getValue();
    }

    public ImagingExcerpt setUid(String value) {
        if (this.uid == null) {
            this.uid = new OidType();
        }
        this.uid.setValue(value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingExcerpt.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImagingExcerpt setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingExcerpt.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImagingExcerpt setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getAuthoringTimeElement() {
        if (this.authoringTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingExcerpt.authoringTime");
            }
            if (Configuration.doAutoCreate()) {
                this.authoringTime = new DateTimeType();
            }
        }
        return this.authoringTime;
    }

    public boolean hasAuthoringTimeElement() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public boolean hasAuthoringTime() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public ImagingExcerpt setAuthoringTimeElement(DateTimeType value) {
        this.authoringTime = value;
        return this;
    }

    public Date getAuthoringTime() {
        return this.authoringTime == null ? null : (Date)this.authoringTime.getValue();
    }

    public ImagingExcerpt setAuthoringTime(Date value) {
        if (value == null) {
            this.authoringTime = null;
        } else {
            if (this.authoringTime == null) {
                this.authoringTime = new DateTimeType();
            }
            this.authoringTime.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingExcerpt.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public ImagingExcerpt setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public ImagingExcerpt setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public CodeableConcept getTitle() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingExcerpt.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new CodeableConcept();
            }
        }
        return this.title;
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ImagingExcerpt setTitle(CodeableConcept value) {
        this.title = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingExcerpt.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImagingExcerpt setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImagingExcerpt setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<StudyComponent> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        return this.study;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (StudyComponent item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StudyComponent addStudy() {
        StudyComponent t = new StudyComponent();
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return t;
    }

    public ImagingExcerpt addStudy(StudyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("uid", "oid", "Unique identifier of the DICOM Key Object Selection (KOS) representation.", 0, Integer.MAX_VALUE, this.uid));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingExcerpt.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("authoringTime", "dateTime", "Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).", 0, Integer.MAX_VALUE, this.authoringTime));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner|Device|Organization|Patient|RelatedPerson)", "Author of ImagingExcerpt. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_TITLE, "CodeableConcept", "The reason for, or significance of, the selection of objects referenced in the resource.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property("description", "string", "Text description of the DICOM SOP instances selected in the ImagingExcerpt. This should be aligned with the content of the title element, and can provide further explanation of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("study", "", "Study identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.study));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.uid;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -1724532252: {
                Base[] baseArray;
                if (this.authoringTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.authoringTime;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.author;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case 109776329: {
                return this.study == null ? new Base[]{} : this.study.toArray(new Base[this.study.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 115792: {
                this.uid = this.castToOid(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -1724532252: {
                this.authoringTime = this.castToDateTime(value);
                break;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case 110371416: {
                this.title = this.castToCodeableConcept(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case 109776329: {
                this.getStudy().add((StudyComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = this.castToOid(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("authoringTime")) {
            this.authoringTime = this.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("study")) {
            this.getStudy().add((StudyComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                throw new FHIRException("Cannot make property uid as it is not a complex type");
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1724532252: {
                throw new FHIRException("Cannot make property authoringTime as it is not a complex type");
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 110371416: {
                return this.getTitle();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case 109776329: {
                return this.addStudy();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("uid")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.uid");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("authoringTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.authoringTime");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_TITLE)) {
            this.title = new CodeableConcept();
            return this.title;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.description");
        }
        if (name.equals("study")) {
            return this.addStudy();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingExcerpt";
    }

    @Override
    public ImagingExcerpt copy() {
        ImagingExcerpt dst = new ImagingExcerpt();
        this.copyValues(dst);
        dst.uid = this.uid == null ? null : this.uid.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.authoringTime = this.authoringTime == null ? null : this.authoringTime.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.title = this.title == null ? null : this.title.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.study != null) {
            dst.study = new ArrayList<StudyComponent>();
            for (StudyComponent i : this.study) {
                dst.study.add(i.copy());
            }
        }
        return dst;
    }

    protected ImagingExcerpt typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ImagingExcerpt)) {
            return false;
        }
        ImagingExcerpt o = (ImagingExcerpt)other;
        return ImagingExcerpt.compareDeep(this.uid, o.uid, true) && ImagingExcerpt.compareDeep(this.patient, o.patient, true) && ImagingExcerpt.compareDeep(this.authoringTime, o.authoringTime, true) && ImagingExcerpt.compareDeep(this.author, o.author, true) && ImagingExcerpt.compareDeep(this.title, o.title, true) && ImagingExcerpt.compareDeep(this.description, o.description, true) && ImagingExcerpt.compareDeep(this.study, o.study, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ImagingExcerpt)) {
            return false;
        }
        ImagingExcerpt o = (ImagingExcerpt)other;
        return ImagingExcerpt.compareValues(this.uid, o.uid, true) && ImagingExcerpt.compareValues(this.authoringTime, o.authoringTime, true) && ImagingExcerpt.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.authoringTime != null && !this.authoringTime.isEmpty() || this.author != null && !this.author.isEmpty() || this.title != null && !this.title.isEmpty() || this.description != null && !this.description.isEmpty() || this.study != null && !this.study.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingExcerpt;
    }

    @Block
    public static class InstanceDicomComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="WADO-RS | WADO-URI | IID | WADO-WS", formalDefinition="Access type for DICOM web.")
        protected Enumeration<DWebType> type;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Retrieve study URL", formalDefinition="The source system root URL / base URL, from which all content can be retrieved using the specified DICOM protocol.")
        protected UriType url;
        private static final long serialVersionUID = 1661664416L;

        public InstanceDicomComponent() {
        }

        public InstanceDicomComponent(Enumeration<DWebType> type, UriType url) {
            this.type = type;
            this.url = url;
        }

        public Enumeration<DWebType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceDicomComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DWebType>(new DWebTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public InstanceDicomComponent setTypeElement(Enumeration<DWebType> value) {
            this.type = value;
            return this;
        }

        public DWebType getType() {
            return this.type == null ? null : (DWebType)((Object)this.type.getValue());
        }

        public InstanceDicomComponent setType(DWebType value) {
            if (this.type == null) {
                this.type = new Enumeration<DWebType>(new DWebTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceDicomComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public InstanceDicomComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public InstanceDicomComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "Access type for DICOM web.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("url", "uri", "The source system root URL / base URL, from which all content can be retrieved using the specified DICOM protocol.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new DWebTypeEnumFactory().fromType(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new DWebTypeEnumFactory().fromType(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.type");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.url");
            }
            return super.addChild(name);
        }

        @Override
        public InstanceDicomComponent copy() {
            InstanceDicomComponent dst = new InstanceDicomComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof InstanceDicomComponent)) {
                return false;
            }
            InstanceDicomComponent o = (InstanceDicomComponent)other;
            return InstanceDicomComponent.compareDeep(this.type, o.type, true) && InstanceDicomComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof InstanceDicomComponent)) {
                return false;
            }
            InstanceDicomComponent o = (InstanceDicomComponent)other;
            return InstanceDicomComponent.compareValues(this.type, o.type, true) && InstanceDicomComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingExcerpt.study.series.instance.dicom";
        }
    }

    @Block
    public static class InstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sopClass", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="SOP class UID of instance", formalDefinition="SOP class UID of the selected instance.")
        protected OidType sopClass;
        @Child(name="uid", type={OidType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Selected instance UID", formalDefinition="SOP Instance UID of the selected instance.")
        protected OidType uid;
        @Child(name="dicom", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dicom web access", formalDefinition="Methods of accessing using DICOM web technologies.")
        protected List<InstanceDicomComponent> dicom;
        @Child(name="frameNumbers", type={UnsignedIntType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Frame reference number", formalDefinition="The specific frame reference within a multi-frame object.")
        protected List<UnsignedIntType> frameNumbers;
        private static final long serialVersionUID = 1372440557L;

        public InstanceComponent() {
        }

        public InstanceComponent(OidType sopClass, OidType uid) {
            this.sopClass = sopClass;
            this.uid = uid;
        }

        public OidType getSopClassElement() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new OidType();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClassElement() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public InstanceComponent setSopClassElement(OidType value) {
            this.sopClass = value;
            return this;
        }

        public String getSopClass() {
            return this.sopClass == null ? null : (String)this.sopClass.getValue();
        }

        public InstanceComponent setSopClass(String value) {
            if (this.sopClass == null) {
                this.sopClass = new OidType();
            }
            this.sopClass.setValue(value);
            return this;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public InstanceComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public InstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public List<InstanceDicomComponent> getDicom() {
            if (this.dicom == null) {
                this.dicom = new ArrayList<InstanceDicomComponent>();
            }
            return this.dicom;
        }

        public boolean hasDicom() {
            if (this.dicom == null) {
                return false;
            }
            for (InstanceDicomComponent item : this.dicom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InstanceDicomComponent addDicom() {
            InstanceDicomComponent t = new InstanceDicomComponent();
            if (this.dicom == null) {
                this.dicom = new ArrayList<InstanceDicomComponent>();
            }
            this.dicom.add(t);
            return t;
        }

        public InstanceComponent addDicom(InstanceDicomComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dicom == null) {
                this.dicom = new ArrayList<InstanceDicomComponent>();
            }
            this.dicom.add(t);
            return this;
        }

        public List<UnsignedIntType> getFrameNumbers() {
            if (this.frameNumbers == null) {
                this.frameNumbers = new ArrayList<UnsignedIntType>();
            }
            return this.frameNumbers;
        }

        public boolean hasFrameNumbers() {
            if (this.frameNumbers == null) {
                return false;
            }
            for (UnsignedIntType item : this.frameNumbers) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addFrameNumbersElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.frameNumbers == null) {
                this.frameNumbers = new ArrayList<UnsignedIntType>();
            }
            this.frameNumbers.add(t);
            return t;
        }

        public InstanceComponent addFrameNumbers(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.frameNumbers == null) {
                this.frameNumbers = new ArrayList<UnsignedIntType>();
            }
            this.frameNumbers.add(t);
            return this;
        }

        public boolean hasFrameNumbers(int value) {
            if (this.frameNumbers == null) {
                return false;
            }
            for (UnsignedIntType v : this.frameNumbers) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sopClass", "oid", "SOP class UID of the selected instance.", 0, Integer.MAX_VALUE, this.sopClass));
            childrenList.add(new Property("uid", "oid", "SOP Instance UID of the selected instance.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("dicom", "", "Methods of accessing using DICOM web technologies.", 0, Integer.MAX_VALUE, this.dicom));
            childrenList.add(new Property("frameNumbers", "unsignedInt", "The specific frame reference within a multi-frame object.", 0, Integer.MAX_VALUE, this.frameNumbers));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uid;
                    }
                    return baseArray;
                }
                case 95578844: {
                    return this.dicom == null ? new Base[]{} : this.dicom.toArray(new Base[this.dicom.size()]);
                }
                case -144148451: {
                    return this.frameNumbers == null ? new Base[]{} : this.frameNumbers.toArray(new Base[this.frameNumbers.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    this.sopClass = this.castToOid(value);
                    break;
                }
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case 95578844: {
                    this.getDicom().add((InstanceDicomComponent)value);
                    break;
                }
                case -144148451: {
                    this.getFrameNumbers().add(this.castToUnsignedInt(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sopClass")) {
                this.sopClass = this.castToOid(value);
            } else if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("dicom")) {
                this.getDicom().add((InstanceDicomComponent)value);
            } else if (name.equals("frameNumbers")) {
                this.getFrameNumbers().add(this.castToUnsignedInt(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1560041540: {
                    throw new FHIRException("Cannot make property sopClass as it is not a complex type");
                }
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case 95578844: {
                    return this.addDicom();
                }
                case -144148451: {
                    throw new FHIRException("Cannot make property frameNumbers as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sopClass")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.sopClass");
            }
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.uid");
            }
            if (name.equals("dicom")) {
                return this.addDicom();
            }
            if (name.equals("frameNumbers")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.frameNumbers");
            }
            return super.addChild(name);
        }

        @Override
        public InstanceComponent copy() {
            InstanceComponent dst = new InstanceComponent();
            this.copyValues(dst);
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            OidType oidType = dst.uid = this.uid == null ? null : this.uid.copy();
            if (this.dicom != null) {
                dst.dicom = new ArrayList<InstanceDicomComponent>();
                for (InstanceDicomComponent instanceDicomComponent : this.dicom) {
                    dst.dicom.add(instanceDicomComponent.copy());
                }
            }
            if (this.frameNumbers != null) {
                dst.frameNumbers = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType unsignedIntType : this.frameNumbers) {
                    dst.frameNumbers.add(unsignedIntType.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other;
            return InstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && InstanceComponent.compareDeep(this.uid, o.uid, true) && InstanceComponent.compareDeep(this.dicom, o.dicom, true) && InstanceComponent.compareDeep(this.frameNumbers, o.frameNumbers, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other;
            return InstanceComponent.compareValues(this.sopClass, o.sopClass, true) && InstanceComponent.compareValues(this.uid, o.uid, true) && InstanceComponent.compareValues(this.frameNumbers, o.frameNumbers, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sopClass != null && !this.sopClass.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.dicom != null && !this.dicom.isEmpty() || this.frameNumbers != null && !this.frameNumbers.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingExcerpt.study.series.instance";
        }
    }

    @Block
    public static class SeriesDicomComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="WADO-RS | WADO-URI | IID | WADO-WS", formalDefinition="Access type for DICOM web.")
        protected Enumeration<DWebType> type;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Retrieve study URL", formalDefinition="The source system root URL / base URL, from which all content can be retrieved using the specified DICOM protocol.")
        protected UriType url;
        private static final long serialVersionUID = 1661664416L;

        public SeriesDicomComponent() {
        }

        public SeriesDicomComponent(Enumeration<DWebType> type, UriType url) {
            this.type = type;
            this.url = url;
        }

        public Enumeration<DWebType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesDicomComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DWebType>(new DWebTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SeriesDicomComponent setTypeElement(Enumeration<DWebType> value) {
            this.type = value;
            return this;
        }

        public DWebType getType() {
            return this.type == null ? null : (DWebType)((Object)this.type.getValue());
        }

        public SeriesDicomComponent setType(DWebType value) {
            if (this.type == null) {
                this.type = new Enumeration<DWebType>(new DWebTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesDicomComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public SeriesDicomComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public SeriesDicomComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "Access type for DICOM web.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("url", "uri", "The source system root URL / base URL, from which all content can be retrieved using the specified DICOM protocol.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new DWebTypeEnumFactory().fromType(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new DWebTypeEnumFactory().fromType(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.type");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.url");
            }
            return super.addChild(name);
        }

        @Override
        public SeriesDicomComponent copy() {
            SeriesDicomComponent dst = new SeriesDicomComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SeriesDicomComponent)) {
                return false;
            }
            SeriesDicomComponent o = (SeriesDicomComponent)other;
            return SeriesDicomComponent.compareDeep(this.type, o.type, true) && SeriesDicomComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SeriesDicomComponent)) {
                return false;
            }
            SeriesDicomComponent o = (SeriesDicomComponent)other;
            return SeriesDicomComponent.compareValues(this.type, o.type, true) && SeriesDicomComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingExcerpt.study.series.dicom";
        }
    }

    @Block
    public static class SeriesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Series instance UID", formalDefinition="Series instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="dicom", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dicom web access", formalDefinition="Methods of accessing using DICOM web technologies.")
        protected List<SeriesDicomComponent> dicom;
        @Child(name="instance", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The selected instance", formalDefinition="Identity and locating information of the selected DICOM SOP instances.")
        protected List<InstanceComponent> instance;
        private static final long serialVersionUID = 1845643577L;

        public SeriesComponent() {
        }

        public SeriesComponent(OidType uid) {
            this.uid = uid;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public SeriesComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public SeriesComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public List<SeriesDicomComponent> getDicom() {
            if (this.dicom == null) {
                this.dicom = new ArrayList<SeriesDicomComponent>();
            }
            return this.dicom;
        }

        public boolean hasDicom() {
            if (this.dicom == null) {
                return false;
            }
            for (SeriesDicomComponent item : this.dicom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SeriesDicomComponent addDicom() {
            SeriesDicomComponent t = new SeriesDicomComponent();
            if (this.dicom == null) {
                this.dicom = new ArrayList<SeriesDicomComponent>();
            }
            this.dicom.add(t);
            return t;
        }

        public SeriesComponent addDicom(SeriesDicomComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dicom == null) {
                this.dicom = new ArrayList<SeriesDicomComponent>();
            }
            this.dicom.add(t);
            return this;
        }

        public List<InstanceComponent> getInstance() {
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            return this.instance;
        }

        public boolean hasInstance() {
            if (this.instance == null) {
                return false;
            }
            for (InstanceComponent item : this.instance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InstanceComponent addInstance() {
            InstanceComponent t = new InstanceComponent();
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return t;
        }

        public SeriesComponent addInstance(InstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("uid", "oid", "Series instance UID of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("dicom", "", "Methods of accessing using DICOM web technologies.", 0, Integer.MAX_VALUE, this.dicom));
            childrenList.add(new Property("instance", "", "Identity and locating information of the selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case 95578844: {
                    return this.dicom == null ? new Base[]{} : this.dicom.toArray(new Base[this.dicom.size()]);
                }
                case 555127957: {
                    return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case 95578844: {
                    this.getDicom().add((SeriesDicomComponent)value);
                    break;
                }
                case 555127957: {
                    this.getInstance().add((InstanceComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("dicom")) {
                this.getDicom().add((SeriesDicomComponent)value);
            } else if (name.equals("instance")) {
                this.getInstance().add((InstanceComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case 95578844: {
                    return this.addDicom();
                }
                case 555127957: {
                    return this.addInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.uid");
            }
            if (name.equals("dicom")) {
                return this.addDicom();
            }
            if (name.equals("instance")) {
                return this.addInstance();
            }
            return super.addChild(name);
        }

        @Override
        public SeriesComponent copy() {
            SeriesComponent dst = new SeriesComponent();
            this.copyValues(dst);
            OidType oidType = dst.uid = this.uid == null ? null : this.uid.copy();
            if (this.dicom != null) {
                dst.dicom = new ArrayList<SeriesDicomComponent>();
                for (SeriesDicomComponent seriesDicomComponent : this.dicom) {
                    dst.dicom.add(seriesDicomComponent.copy());
                }
            }
            if (this.instance != null) {
                dst.instance = new ArrayList<InstanceComponent>();
                for (InstanceComponent instanceComponent : this.instance) {
                    dst.instance.add(instanceComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other;
            return SeriesComponent.compareDeep(this.uid, o.uid, true) && SeriesComponent.compareDeep(this.dicom, o.dicom, true) && SeriesComponent.compareDeep(this.instance, o.instance, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other;
            return SeriesComponent.compareValues(this.uid, o.uid, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.dicom != null && !this.dicom.isEmpty() || this.instance != null && !this.instance.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingExcerpt.study.series";
        }
    }

    @Block
    public static class StudyViewableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="contentType", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Mime type of the content, with charset etc.", formalDefinition="Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate.")
        protected CodeType contentType;
        @Child(name="height", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Height of the image in pixels (photo/video)", formalDefinition="Height of the image in pixels (photo/video).")
        protected PositiveIntType height;
        @Child(name="width", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Width of the image in pixels (photo/video)", formalDefinition="Width of the image in pixels (photo/video).")
        protected PositiveIntType width;
        @Child(name="frames", type={PositiveIntType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of frames if > 1 (photo)", formalDefinition="The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif.")
        protected PositiveIntType frames;
        @Child(name="duration", type={UnsignedIntType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Length in seconds (audio / video)", formalDefinition="The duration of the recording in seconds - for audio and video.")
        protected UnsignedIntType duration;
        @Child(name="size", type={UnsignedIntType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of bytes of content (if url provided)", formalDefinition="The number of bytes of data that make up this attachment.")
        protected UnsignedIntType size;
        @Child(name="title", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label to display in place of the data", formalDefinition="A label or set of text to display in place of the data.")
        protected StringType title;
        @Child(name="url", type={UriType.class}, order=8, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Uri where the data can be found", formalDefinition="A location where the data can be accessed.")
        protected UriType url;
        private static final long serialVersionUID = -2135689428L;

        public StudyViewableComponent() {
        }

        public StudyViewableComponent(CodeType contentType, UriType url) {
            this.contentType = contentType;
            this.url = url;
        }

        public CodeType getContentTypeElement() {
            if (this.contentType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.contentType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contentType = new CodeType();
                }
            }
            return this.contentType;
        }

        public boolean hasContentTypeElement() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public boolean hasContentType() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public StudyViewableComponent setContentTypeElement(CodeType value) {
            this.contentType = value;
            return this;
        }

        public String getContentType() {
            return this.contentType == null ? null : (String)this.contentType.getValue();
        }

        public StudyViewableComponent setContentType(String value) {
            if (this.contentType == null) {
                this.contentType = new CodeType();
            }
            this.contentType.setValue(value);
            return this;
        }

        public PositiveIntType getHeightElement() {
            if (this.height == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.height");
                }
                if (Configuration.doAutoCreate()) {
                    this.height = new PositiveIntType();
                }
            }
            return this.height;
        }

        public boolean hasHeightElement() {
            return this.height != null && !this.height.isEmpty();
        }

        public boolean hasHeight() {
            return this.height != null && !this.height.isEmpty();
        }

        public StudyViewableComponent setHeightElement(PositiveIntType value) {
            this.height = value;
            return this;
        }

        public int getHeight() {
            return this.height == null || this.height.isEmpty() ? 0 : (Integer)this.height.getValue();
        }

        public StudyViewableComponent setHeight(int value) {
            if (this.height == null) {
                this.height = new PositiveIntType();
            }
            this.height.setValue((Object)value);
            return this;
        }

        public PositiveIntType getWidthElement() {
            if (this.width == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.width");
                }
                if (Configuration.doAutoCreate()) {
                    this.width = new PositiveIntType();
                }
            }
            return this.width;
        }

        public boolean hasWidthElement() {
            return this.width != null && !this.width.isEmpty();
        }

        public boolean hasWidth() {
            return this.width != null && !this.width.isEmpty();
        }

        public StudyViewableComponent setWidthElement(PositiveIntType value) {
            this.width = value;
            return this;
        }

        public int getWidth() {
            return this.width == null || this.width.isEmpty() ? 0 : (Integer)this.width.getValue();
        }

        public StudyViewableComponent setWidth(int value) {
            if (this.width == null) {
                this.width = new PositiveIntType();
            }
            this.width.setValue((Object)value);
            return this;
        }

        public PositiveIntType getFramesElement() {
            if (this.frames == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.frames");
                }
                if (Configuration.doAutoCreate()) {
                    this.frames = new PositiveIntType();
                }
            }
            return this.frames;
        }

        public boolean hasFramesElement() {
            return this.frames != null && !this.frames.isEmpty();
        }

        public boolean hasFrames() {
            return this.frames != null && !this.frames.isEmpty();
        }

        public StudyViewableComponent setFramesElement(PositiveIntType value) {
            this.frames = value;
            return this;
        }

        public int getFrames() {
            return this.frames == null || this.frames.isEmpty() ? 0 : (Integer)this.frames.getValue();
        }

        public StudyViewableComponent setFrames(int value) {
            if (this.frames == null) {
                this.frames = new PositiveIntType();
            }
            this.frames.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getDurationElement() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new UnsignedIntType();
                }
            }
            return this.duration;
        }

        public boolean hasDurationElement() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public StudyViewableComponent setDurationElement(UnsignedIntType value) {
            this.duration = value;
            return this;
        }

        public int getDuration() {
            return this.duration == null || this.duration.isEmpty() ? 0 : (Integer)this.duration.getValue();
        }

        public StudyViewableComponent setDuration(int value) {
            if (this.duration == null) {
                this.duration = new UnsignedIntType();
            }
            this.duration.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getSizeElement() {
            if (this.size == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.size");
                }
                if (Configuration.doAutoCreate()) {
                    this.size = new UnsignedIntType();
                }
            }
            return this.size;
        }

        public boolean hasSizeElement() {
            return this.size != null && !this.size.isEmpty();
        }

        public boolean hasSize() {
            return this.size != null && !this.size.isEmpty();
        }

        public StudyViewableComponent setSizeElement(UnsignedIntType value) {
            this.size = value;
            return this;
        }

        public int getSize() {
            return this.size == null || this.size.isEmpty() ? 0 : (Integer)this.size.getValue();
        }

        public StudyViewableComponent setSize(int value) {
            if (this.size == null) {
                this.size = new UnsignedIntType();
            }
            this.size.setValue((Object)value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public StudyViewableComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public StudyViewableComponent setTitle(String value) {
            if (Utilities.noString(value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyViewableComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public StudyViewableComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public StudyViewableComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("contentType", "code", "Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate.", 0, Integer.MAX_VALUE, this.contentType));
            childrenList.add(new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, Integer.MAX_VALUE, this.height));
            childrenList.add(new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, Integer.MAX_VALUE, this.width));
            childrenList.add(new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif.", 0, Integer.MAX_VALUE, this.frames));
            childrenList.add(new Property("duration", "unsignedInt", "The duration of the recording in seconds - for audio and video.", 0, Integer.MAX_VALUE, this.duration));
            childrenList.add(new Property("size", "unsignedInt", "The number of bytes of data that make up this attachment.", 0, Integer.MAX_VALUE, this.size));
            childrenList.add(new Property(ImagingExcerpt.SP_TITLE, "string", "A label or set of text to display in place of the data.", 0, Integer.MAX_VALUE, this.title));
            childrenList.add(new Property("url", "uri", "A location where the data can be accessed.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -389131437: {
                    Base[] baseArray;
                    if (this.contentType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.contentType;
                    }
                    return baseArray;
                }
                case -1221029593: {
                    Base[] baseArray;
                    if (this.height == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.height;
                    }
                    return baseArray;
                }
                case 113126854: {
                    Base[] baseArray;
                    if (this.width == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.width;
                    }
                    return baseArray;
                }
                case -1266514778: {
                    Base[] baseArray;
                    if (this.frames == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.frames;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.duration;
                    }
                    return baseArray;
                }
                case 3530753: {
                    Base[] baseArray;
                    if (this.size == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.size;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.title;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -389131437: {
                    this.contentType = this.castToCode(value);
                    break;
                }
                case -1221029593: {
                    this.height = this.castToPositiveInt(value);
                    break;
                }
                case 113126854: {
                    this.width = this.castToPositiveInt(value);
                    break;
                }
                case -1266514778: {
                    this.frames = this.castToPositiveInt(value);
                    break;
                }
                case -1992012396: {
                    this.duration = this.castToUnsignedInt(value);
                    break;
                }
                case 3530753: {
                    this.size = this.castToUnsignedInt(value);
                    break;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("contentType")) {
                this.contentType = this.castToCode(value);
            } else if (name.equals("height")) {
                this.height = this.castToPositiveInt(value);
            } else if (name.equals("width")) {
                this.width = this.castToPositiveInt(value);
            } else if (name.equals("frames")) {
                this.frames = this.castToPositiveInt(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToUnsignedInt(value);
            } else if (name.equals("size")) {
                this.size = this.castToUnsignedInt(value);
            } else if (name.equals(ImagingExcerpt.SP_TITLE)) {
                this.title = this.castToString(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -389131437: {
                    throw new FHIRException("Cannot make property contentType as it is not a complex type");
                }
                case -1221029593: {
                    throw new FHIRException("Cannot make property height as it is not a complex type");
                }
                case 113126854: {
                    throw new FHIRException("Cannot make property width as it is not a complex type");
                }
                case -1266514778: {
                    throw new FHIRException("Cannot make property frames as it is not a complex type");
                }
                case -1992012396: {
                    throw new FHIRException("Cannot make property duration as it is not a complex type");
                }
                case 3530753: {
                    throw new FHIRException("Cannot make property size as it is not a complex type");
                }
                case 110371416: {
                    throw new FHIRException("Cannot make property title as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentType")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.contentType");
            }
            if (name.equals("height")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.height");
            }
            if (name.equals("width")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.width");
            }
            if (name.equals("frames")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.frames");
            }
            if (name.equals("duration")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.duration");
            }
            if (name.equals("size")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.size");
            }
            if (name.equals(ImagingExcerpt.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.title");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.url");
            }
            return super.addChild(name);
        }

        @Override
        public StudyViewableComponent copy() {
            StudyViewableComponent dst = new StudyViewableComponent();
            this.copyValues(dst);
            dst.contentType = this.contentType == null ? null : this.contentType.copy();
            dst.height = this.height == null ? null : this.height.copy();
            dst.width = this.width == null ? null : this.width.copy();
            dst.frames = this.frames == null ? null : this.frames.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.size = this.size == null ? null : this.size.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StudyViewableComponent)) {
                return false;
            }
            StudyViewableComponent o = (StudyViewableComponent)other;
            return StudyViewableComponent.compareDeep(this.contentType, o.contentType, true) && StudyViewableComponent.compareDeep(this.height, o.height, true) && StudyViewableComponent.compareDeep(this.width, o.width, true) && StudyViewableComponent.compareDeep(this.frames, o.frames, true) && StudyViewableComponent.compareDeep(this.duration, o.duration, true) && StudyViewableComponent.compareDeep(this.size, o.size, true) && StudyViewableComponent.compareDeep(this.title, o.title, true) && StudyViewableComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StudyViewableComponent)) {
                return false;
            }
            StudyViewableComponent o = (StudyViewableComponent)other;
            return StudyViewableComponent.compareValues(this.contentType, o.contentType, true) && StudyViewableComponent.compareValues(this.height, o.height, true) && StudyViewableComponent.compareValues(this.width, o.width, true) && StudyViewableComponent.compareValues(this.frames, o.frames, true) && StudyViewableComponent.compareValues(this.duration, o.duration, true) && StudyViewableComponent.compareValues(this.size, o.size, true) && StudyViewableComponent.compareValues(this.title, o.title, true) && StudyViewableComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.contentType != null && !this.contentType.isEmpty() || this.height != null && !this.height.isEmpty() || this.width != null && !this.width.isEmpty() || this.frames != null && !this.frames.isEmpty() || this.duration != null && !this.duration.isEmpty() || this.size != null && !this.size.isEmpty() || this.title != null && !this.title.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingExcerpt.study.viewable";
        }
    }

    @Block
    public static class StudyDicomComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="WADO-RS | WADO-URI | IID | WADO-WS", formalDefinition="Access type for DICOM web.")
        protected Enumeration<DWebType> type;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Retrieve study URL", formalDefinition="The source system root URL / base URL, from which all content can be retrieved using the specified DICOM protocol.")
        protected UriType url;
        private static final long serialVersionUID = 1661664416L;

        public StudyDicomComponent() {
        }

        public StudyDicomComponent(Enumeration<DWebType> type, UriType url) {
            this.type = type;
            this.url = url;
        }

        public Enumeration<DWebType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyDicomComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DWebType>(new DWebTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StudyDicomComponent setTypeElement(Enumeration<DWebType> value) {
            this.type = value;
            return this;
        }

        public DWebType getType() {
            return this.type == null ? null : (DWebType)((Object)this.type.getValue());
        }

        public StudyDicomComponent setType(DWebType value) {
            if (this.type == null) {
                this.type = new Enumeration<DWebType>(new DWebTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyDicomComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public StudyDicomComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public StudyDicomComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "Access type for DICOM web.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("url", "uri", "The source system root URL / base URL, from which all content can be retrieved using the specified DICOM protocol.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new DWebTypeEnumFactory().fromType(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new DWebTypeEnumFactory().fromType(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.type");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.url");
            }
            return super.addChild(name);
        }

        @Override
        public StudyDicomComponent copy() {
            StudyDicomComponent dst = new StudyDicomComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StudyDicomComponent)) {
                return false;
            }
            StudyDicomComponent o = (StudyDicomComponent)other;
            return StudyDicomComponent.compareDeep(this.type, o.type, true) && StudyDicomComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StudyDicomComponent)) {
                return false;
            }
            StudyDicomComponent o = (StudyDicomComponent)other;
            return StudyDicomComponent.compareValues(this.type, o.type, true) && StudyDicomComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingExcerpt.study.dicom";
        }
    }

    @Block
    public static class StudyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Study instance UID", formalDefinition="Study instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="imagingStudy", type={ImagingStudy.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to ImagingStudy", formalDefinition="Reference to the Imaging Study in FHIR form.")
        protected Reference imagingStudy;
        protected ImagingStudy imagingStudyTarget;
        @Child(name="dicom", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dicom web access", formalDefinition="Methods of accessing using DICOM web technologies.")
        protected List<StudyDicomComponent> dicom;
        @Child(name="viewable", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Viewable format", formalDefinition="A set of viewable reference images of various  types.")
        protected List<StudyViewableComponent> viewable;
        @Child(name="series", type={}, order=5, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Series identity of the selected instances", formalDefinition="Series identity and locating information of the DICOM SOP instances in the selection.")
        protected List<SeriesComponent> series;
        private static final long serialVersionUID = 1674060080L;

        public StudyComponent() {
        }

        public StudyComponent(OidType uid) {
            this.uid = uid;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public StudyComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public StudyComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public Reference getImagingStudy() {
            if (this.imagingStudy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudy = new Reference();
                }
            }
            return this.imagingStudy;
        }

        public boolean hasImagingStudy() {
            return this.imagingStudy != null && !this.imagingStudy.isEmpty();
        }

        public StudyComponent setImagingStudy(Reference value) {
            this.imagingStudy = value;
            return this;
        }

        public ImagingStudy getImagingStudyTarget() {
            if (this.imagingStudyTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudyTarget = new ImagingStudy();
                }
            }
            return this.imagingStudyTarget;
        }

        public StudyComponent setImagingStudyTarget(ImagingStudy value) {
            this.imagingStudyTarget = value;
            return this;
        }

        public List<StudyDicomComponent> getDicom() {
            if (this.dicom == null) {
                this.dicom = new ArrayList<StudyDicomComponent>();
            }
            return this.dicom;
        }

        public boolean hasDicom() {
            if (this.dicom == null) {
                return false;
            }
            for (StudyDicomComponent item : this.dicom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StudyDicomComponent addDicom() {
            StudyDicomComponent t = new StudyDicomComponent();
            if (this.dicom == null) {
                this.dicom = new ArrayList<StudyDicomComponent>();
            }
            this.dicom.add(t);
            return t;
        }

        public StudyComponent addDicom(StudyDicomComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dicom == null) {
                this.dicom = new ArrayList<StudyDicomComponent>();
            }
            this.dicom.add(t);
            return this;
        }

        public List<StudyViewableComponent> getViewable() {
            if (this.viewable == null) {
                this.viewable = new ArrayList<StudyViewableComponent>();
            }
            return this.viewable;
        }

        public boolean hasViewable() {
            if (this.viewable == null) {
                return false;
            }
            for (StudyViewableComponent item : this.viewable) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StudyViewableComponent addViewable() {
            StudyViewableComponent t = new StudyViewableComponent();
            if (this.viewable == null) {
                this.viewable = new ArrayList<StudyViewableComponent>();
            }
            this.viewable.add(t);
            return t;
        }

        public StudyComponent addViewable(StudyViewableComponent t) {
            if (t == null) {
                return this;
            }
            if (this.viewable == null) {
                this.viewable = new ArrayList<StudyViewableComponent>();
            }
            this.viewable.add(t);
            return this;
        }

        public List<SeriesComponent> getSeries() {
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            return this.series;
        }

        public boolean hasSeries() {
            if (this.series == null) {
                return false;
            }
            for (SeriesComponent item : this.series) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SeriesComponent addSeries() {
            SeriesComponent t = new SeriesComponent();
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return t;
        }

        public StudyComponent addSeries(SeriesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("uid", "oid", "Study instance UID of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("imagingStudy", "Reference(ImagingStudy)", "Reference to the Imaging Study in FHIR form.", 0, Integer.MAX_VALUE, this.imagingStudy));
            childrenList.add(new Property("dicom", "", "Methods of accessing using DICOM web technologies.", 0, Integer.MAX_VALUE, this.dicom));
            childrenList.add(new Property("viewable", "", "A set of viewable reference images of various  types.", 0, Integer.MAX_VALUE, this.viewable));
            childrenList.add(new Property("series", "", "Series identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.series));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -814900911: {
                    Base[] baseArray;
                    if (this.imagingStudy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.imagingStudy;
                    }
                    return baseArray;
                }
                case 95578844: {
                    return this.dicom == null ? new Base[]{} : this.dicom.toArray(new Base[this.dicom.size()]);
                }
                case 1196225919: {
                    return this.viewable == null ? new Base[]{} : this.viewable.toArray(new Base[this.viewable.size()]);
                }
                case -905838985: {
                    return this.series == null ? new Base[]{} : this.series.toArray(new Base[this.series.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case -814900911: {
                    this.imagingStudy = this.castToReference(value);
                    break;
                }
                case 95578844: {
                    this.getDicom().add((StudyDicomComponent)value);
                    break;
                }
                case 1196225919: {
                    this.getViewable().add((StudyViewableComponent)value);
                    break;
                }
                case -905838985: {
                    this.getSeries().add((SeriesComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("imagingStudy")) {
                this.imagingStudy = this.castToReference(value);
            } else if (name.equals("dicom")) {
                this.getDicom().add((StudyDicomComponent)value);
            } else if (name.equals("viewable")) {
                this.getViewable().add((StudyViewableComponent)value);
            } else if (name.equals("series")) {
                this.getSeries().add((SeriesComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case -814900911: {
                    return this.getImagingStudy();
                }
                case 95578844: {
                    return this.addDicom();
                }
                case 1196225919: {
                    return this.addViewable();
                }
                case -905838985: {
                    return this.addSeries();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingExcerpt.uid");
            }
            if (name.equals("imagingStudy")) {
                this.imagingStudy = new Reference();
                return this.imagingStudy;
            }
            if (name.equals("dicom")) {
                return this.addDicom();
            }
            if (name.equals("viewable")) {
                return this.addViewable();
            }
            if (name.equals("series")) {
                return this.addSeries();
            }
            return super.addChild(name);
        }

        @Override
        public StudyComponent copy() {
            StudyComponent dst = new StudyComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            Reference reference = dst.imagingStudy = this.imagingStudy == null ? null : this.imagingStudy.copy();
            if (this.dicom != null) {
                dst.dicom = new ArrayList<StudyDicomComponent>();
                for (StudyDicomComponent studyDicomComponent : this.dicom) {
                    dst.dicom.add(studyDicomComponent.copy());
                }
            }
            if (this.viewable != null) {
                dst.viewable = new ArrayList<StudyViewableComponent>();
                for (StudyViewableComponent studyViewableComponent : this.viewable) {
                    dst.viewable.add(studyViewableComponent.copy());
                }
            }
            if (this.series != null) {
                dst.series = new ArrayList<SeriesComponent>();
                for (SeriesComponent seriesComponent : this.series) {
                    dst.series.add(seriesComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other;
            return StudyComponent.compareDeep(this.uid, o.uid, true) && StudyComponent.compareDeep(this.imagingStudy, o.imagingStudy, true) && StudyComponent.compareDeep(this.dicom, o.dicom, true) && StudyComponent.compareDeep(this.viewable, o.viewable, true) && StudyComponent.compareDeep(this.series, o.series, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other;
            return StudyComponent.compareValues(this.uid, o.uid, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.imagingStudy != null && !this.imagingStudy.isEmpty() || this.dicom != null && !this.dicom.isEmpty() || this.viewable != null && !this.viewable.isEmpty() || this.series != null && !this.series.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingExcerpt.study";
        }
    }

    public static class DWebTypeEnumFactory
    implements EnumFactory<DWebType> {
        @Override
        public DWebType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("WADO-RS".equals(codeString)) {
                return DWebType.WADORS;
            }
            if ("WADO-URI".equals(codeString)) {
                return DWebType.WADOURI;
            }
            if ("IID".equals(codeString)) {
                return DWebType.IID;
            }
            if ("WADO-WS".equals(codeString)) {
                return DWebType.WADOWS;
            }
            throw new IllegalArgumentException("Unknown DWebType code '" + codeString + "'");
        }

        public Enumeration<DWebType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("WADO-RS".equals(codeString)) {
                return new Enumeration<DWebType>(this, DWebType.WADORS);
            }
            if ("WADO-URI".equals(codeString)) {
                return new Enumeration<DWebType>(this, DWebType.WADOURI);
            }
            if ("IID".equals(codeString)) {
                return new Enumeration<DWebType>(this, DWebType.IID);
            }
            if ("WADO-WS".equals(codeString)) {
                return new Enumeration<DWebType>(this, DWebType.WADOWS);
            }
            throw new FHIRException("Unknown DWebType code '" + codeString + "'");
        }

        @Override
        public String toCode(DWebType code) {
            if (code == DWebType.WADORS) {
                return "WADO-RS";
            }
            if (code == DWebType.WADOURI) {
                return "WADO-URI";
            }
            if (code == DWebType.IID) {
                return "IID";
            }
            if (code == DWebType.WADOWS) {
                return "WADO-WS";
            }
            return "?";
        }

        @Override
        public String toSystem(DWebType code) {
            return code.getSystem();
        }
    }

    public static enum DWebType {
        WADORS,
        WADOURI,
        IID,
        WADOWS,
        NULL;


        public static DWebType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("WADO-RS".equals(codeString)) {
                return WADORS;
            }
            if ("WADO-URI".equals(codeString)) {
                return WADOURI;
            }
            if ("IID".equals(codeString)) {
                return IID;
            }
            if ("WADO-WS".equals(codeString)) {
                return WADOWS;
            }
            throw new FHIRException("Unknown DWebType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case WADORS: {
                    return "WADO-RS";
                }
                case WADOURI: {
                    return "WADO-URI";
                }
                case IID: {
                    return "IID";
                }
                case WADOWS: {
                    return "WADO-WS";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case WADORS: {
                    return "http://hl7.org/fhir/dWebType";
                }
                case WADOURI: {
                    return "http://hl7.org/fhir/dWebType";
                }
                case IID: {
                    return "http://hl7.org/fhir/dWebType";
                }
                case WADOWS: {
                    return "http://hl7.org/fhir/dWebType";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case WADORS: {
                    return "Web Access to DICOM Persistent Objects - RESTful Services";
                }
                case WADOURI: {
                    return "Web Access to DICOM Persistent Objects - URI";
                }
                case IID: {
                    return "IHE - Invoke Image Display Profile";
                }
                case WADOWS: {
                    return "Web Access to DICOM Persistent Objects - Web Services";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case WADORS: {
                    return "WADO-RS";
                }
                case WADOURI: {
                    return "WADO-URI";
                }
                case IID: {
                    return "IID";
                }
                case WADOWS: {
                    return "WADO-WS";
                }
            }
            return "?";
        }
    }
}

