/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Appointment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.EpisodeOfCare;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Procedure;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Encounter", profile="http://hl7.org/fhir/Profile/Encounter")
public class Encounter
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) by which this encounter is known", formalDefinition="Identifier(s) by which this encounter is known.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | arrived | in-progress | onleave | finished | cancelled", formalDefinition="planned | arrived | in-progress | onleave | finished | cancelled.")
    protected Enumeration<EncounterState> status;
    @Child(name="statusHistory", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of past encounter statuses", formalDefinition="The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.")
    protected List<EncounterStatusHistoryComponent> statusHistory;
    @Child(name="class", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="inpatient | outpatient | ambulatory | emergency +", formalDefinition="inpatient | outpatient | ambulatory | emergency +.")
    protected Enumeration<EncounterClass> class_;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of encounter", formalDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).")
    protected List<CodeableConcept> type;
    @Child(name="priority", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates the urgency of the encounter", formalDefinition="Indicates the urgency of the encounter.")
    protected CodeableConcept priority;
    @Child(name="patient", type={Patient.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient present at the encounter", formalDefinition="The patient present at the encounter.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="episodeOfCare", type={EpisodeOfCare.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Episode(s) of care that this encounter should be recorded against", formalDefinition="Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care, and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).")
    protected List<Reference> episodeOfCare;
    protected List<EpisodeOfCare> episodeOfCareTarget;
    @Child(name="incomingReferral", type={ReferralRequest.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The ReferralRequest that initiated this encounter", formalDefinition="The referral request this encounter satisfies (incoming referral).")
    protected List<Reference> incomingReferral;
    protected List<ReferralRequest> incomingReferralTarget;
    @Child(name="participant", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="List of participants involved in the encounter", formalDefinition="The\u00a0list of\u00a0people\u00a0responsible for providing the service.")
    protected List<EncounterParticipantComponent> participant;
    @Child(name="appointment", type={Appointment.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The appointment that scheduled this encounter", formalDefinition="The appointment that scheduled this encounter.")
    protected Reference appointment;
    protected Appointment appointmentTarget;
    @Child(name="period", type={Period.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The start and end time of the encounter", formalDefinition="The start and end time of the encounter.")
    protected Period period;
    @Child(name="length", type={Duration.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Quantity of time the encounter lasted (less time absent)", formalDefinition="Quantity of time the encounter lasted. This excludes the time during leaves of absence.")
    protected Duration length;
    @Child(name="reason", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason the encounter takes place (code)", formalDefinition="Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.")
    protected List<CodeableConcept> reason;
    @Child(name="indication", type={Condition.class, Procedure.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason the encounter takes place (resource)", formalDefinition="Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.")
    protected List<Reference> indication;
    protected List<Resource> indicationTarget;
    @Child(name="hospitalization", type={}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about the admission to a healthcare service", formalDefinition="Details about the admission to a healthcare service.")
    protected EncounterHospitalizationComponent hospitalization;
    @Child(name="location", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of locations where the patient has been", formalDefinition="List of locations where  the patient has been during this encounter.")
    protected List<EncounterLocationComponent> location;
    @Child(name="serviceProvider", type={Organization.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The custodian organization of this Encounter record", formalDefinition="An organization that is in charge of maintaining the information of this Encounter (e.g. who maintains the report or the master service catalog item, etc.). This MAY be the same as the organization on the Patient record, however it could be different. This MAY not be not the Service Delivery Location's Organization.")
    protected Reference serviceProvider;
    protected Organization serviceProviderTarget;
    @Child(name="partOf", type={Encounter.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Another Encounter this encounter is part of", formalDefinition="Another Encounter of which this encounter is a part of (administratively or in time).")
    protected Reference partOf;
    protected Encounter partOfTarget;
    private static final long serialVersionUID = 929562300L;
    @SearchParamDefinition(name="participant-type", path="Encounter.participant.type", description="Role of participant in encounter", type="token")
    public static final String SP_PARTICIPANT_TYPE = "participant-type";
    public static final TokenClientParam PARTICIPANT_TYPE = new TokenClientParam("participant-type");
    @SearchParamDefinition(name="episodeofcare", path="Encounter.episodeOfCare", description="Episode(s) of care that this encounter should be recorded against", type="reference")
    public static final String SP_EPISODEOFCARE = "episodeofcare";
    public static final ReferenceClientParam EPISODEOFCARE = new ReferenceClientParam("episodeofcare");
    public static final Include INCLUDE_EPISODEOFCARE = new Include("Encounter:episodeofcare").toLocked();
    @SearchParamDefinition(name="status", path="Encounter.status", description="planned | arrived | in-progress | onleave | finished | cancelled", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="reason", path="Encounter.reason", description="Reason the encounter takes place (code)", type="token")
    public static final String SP_REASON = "reason";
    public static final TokenClientParam REASON = new TokenClientParam("reason");
    @SearchParamDefinition(name="condition", path="Encounter.indication", description="Reason the encounter takes place (resource)", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("Encounter:condition").toLocked();
    @SearchParamDefinition(name="location", path="Encounter.location.location", description="Location the encounter takes place", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Encounter:location").toLocked();
    @SearchParamDefinition(name="indication", path="Encounter.indication", description="Reason the encounter takes place (resource)", type="reference")
    public static final String SP_INDICATION = "indication";
    public static final ReferenceClientParam INDICATION = new ReferenceClientParam("indication");
    public static final Include INCLUDE_INDICATION = new Include("Encounter:indication").toLocked();
    @SearchParamDefinition(name="type", path="Encounter.type", description="Specific type of encounter", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="date", path="Encounter.period", description="A date within the period the Encounter lasted", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="special-arrangement", path="Encounter.hospitalization.specialArrangement", description="Wheelchair, translator, stretcher, etc.", type="token")
    public static final String SP_SPECIAL_ARRANGEMENT = "special-arrangement";
    public static final TokenClientParam SPECIAL_ARRANGEMENT = new TokenClientParam("special-arrangement");
    @SearchParamDefinition(name="part-of", path="Encounter.partOf", description="Another Encounter this encounter is part of", type="reference")
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Encounter:part-of").toLocked();
    @SearchParamDefinition(name="appointment", path="Encounter.appointment", description="The appointment that scheduled this encounter", type="reference")
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("Encounter:appointment").toLocked();
    @SearchParamDefinition(name="patient", path="Encounter.patient", description="The patient present at the encounter", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Encounter:patient").toLocked();
    @SearchParamDefinition(name="practitioner", path="Encounter.participant.individual", description="Persons involved in the encounter other than the patient", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("Encounter:practitioner").toLocked();
    @SearchParamDefinition(name="length", path="Encounter.length", description="Length of encounter in days", type="number")
    public static final String SP_LENGTH = "length";
    public static final NumberClientParam LENGTH = new NumberClientParam("length");
    @SearchParamDefinition(name="participant", path="Encounter.participant.individual", description="Persons involved in the encounter other than the patient", type="reference")
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("Encounter:participant").toLocked();
    @SearchParamDefinition(name="incomingreferral", path="Encounter.incomingReferral", description="The ReferralRequest that initiated this encounter", type="reference")
    public static final String SP_INCOMINGREFERRAL = "incomingreferral";
    public static final ReferenceClientParam INCOMINGREFERRAL = new ReferenceClientParam("incomingreferral");
    public static final Include INCLUDE_INCOMINGREFERRAL = new Include("Encounter:incomingreferral").toLocked();
    @SearchParamDefinition(name="identifier", path="Encounter.identifier", description="Identifier(s) by which this encounter is known", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="procedure", path="Encounter.indication", description="Reason the encounter takes place (resource)", type="reference")
    public static final String SP_PROCEDURE = "procedure";
    public static final ReferenceClientParam PROCEDURE = new ReferenceClientParam("procedure");
    public static final Include INCLUDE_PROCEDURE = new Include("Encounter:procedure").toLocked();
    @SearchParamDefinition(name="location-period", path="Encounter.location.period", description="Time period during which the patient was present at the location", type="date")
    public static final String SP_LOCATION_PERIOD = "location-period";
    public static final DateClientParam LOCATION_PERIOD = new DateClientParam("location-period");

    public Encounter() {
    }

    public Encounter(Enumeration<EncounterState> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Encounter addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<EncounterState> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EncounterState>(new EncounterStateEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Encounter setStatusElement(Enumeration<EncounterState> value) {
        this.status = value;
        return this;
    }

    public EncounterState getStatus() {
        return this.status == null ? null : (EncounterState)((Object)this.status.getValue());
    }

    public Encounter setStatus(EncounterState value) {
        if (this.status == null) {
            this.status = new Enumeration<EncounterState>(new EncounterStateEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<EncounterStatusHistoryComponent> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EncounterStatusHistoryComponent>();
        }
        return this.statusHistory;
    }

    public boolean hasStatusHistory() {
        if (this.statusHistory == null) {
            return false;
        }
        for (EncounterStatusHistoryComponent item : this.statusHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterStatusHistoryComponent addStatusHistory() {
        EncounterStatusHistoryComponent t = new EncounterStatusHistoryComponent();
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EncounterStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return t;
    }

    public Encounter addStatusHistory(EncounterStatusHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EncounterStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return this;
    }

    public Enumeration<EncounterClass> getClass_Element() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new Enumeration<EncounterClass>(new EncounterClassEnumFactory());
            }
        }
        return this.class_;
    }

    public boolean hasClass_Element() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public Encounter setClass_Element(Enumeration<EncounterClass> value) {
        this.class_ = value;
        return this;
    }

    public EncounterClass getClass_() {
        return this.class_ == null ? null : (EncounterClass)((Object)this.class_.getValue());
    }

    public Encounter setClass_(EncounterClass value) {
        if (value == null) {
            this.class_ = null;
        } else {
            if (this.class_ == null) {
                this.class_ = new Enumeration<EncounterClass>(new EncounterClassEnumFactory());
            }
            this.class_.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Encounter addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Encounter setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Encounter setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Encounter setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public List<Reference> getEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        return this.episodeOfCare;
    }

    public boolean hasEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            return false;
        }
        for (Reference item : this.episodeOfCare) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEpisodeOfCare() {
        Reference t = new Reference();
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return t;
    }

    public Encounter addEpisodeOfCare(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return this;
    }

    public List<EpisodeOfCare> getEpisodeOfCareTarget() {
        if (this.episodeOfCareTarget == null) {
            this.episodeOfCareTarget = new ArrayList<EpisodeOfCare>();
        }
        return this.episodeOfCareTarget;
    }

    public EpisodeOfCare addEpisodeOfCareTarget() {
        EpisodeOfCare r = new EpisodeOfCare();
        if (this.episodeOfCareTarget == null) {
            this.episodeOfCareTarget = new ArrayList<EpisodeOfCare>();
        }
        this.episodeOfCareTarget.add(r);
        return r;
    }

    public List<Reference> getIncomingReferral() {
        if (this.incomingReferral == null) {
            this.incomingReferral = new ArrayList<Reference>();
        }
        return this.incomingReferral;
    }

    public boolean hasIncomingReferral() {
        if (this.incomingReferral == null) {
            return false;
        }
        for (Reference item : this.incomingReferral) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIncomingReferral() {
        Reference t = new Reference();
        if (this.incomingReferral == null) {
            this.incomingReferral = new ArrayList<Reference>();
        }
        this.incomingReferral.add(t);
        return t;
    }

    public Encounter addIncomingReferral(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.incomingReferral == null) {
            this.incomingReferral = new ArrayList<Reference>();
        }
        this.incomingReferral.add(t);
        return this;
    }

    public List<ReferralRequest> getIncomingReferralTarget() {
        if (this.incomingReferralTarget == null) {
            this.incomingReferralTarget = new ArrayList<ReferralRequest>();
        }
        return this.incomingReferralTarget;
    }

    public ReferralRequest addIncomingReferralTarget() {
        ReferralRequest r = new ReferralRequest();
        if (this.incomingReferralTarget == null) {
            this.incomingReferralTarget = new ArrayList<ReferralRequest>();
        }
        this.incomingReferralTarget.add(r);
        return r;
    }

    public List<EncounterParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        return this.participant;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (EncounterParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterParticipantComponent addParticipant() {
        EncounterParticipantComponent t = new EncounterParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Encounter addParticipant(EncounterParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public Reference getAppointment() {
        if (this.appointment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointment = new Reference();
            }
        }
        return this.appointment;
    }

    public boolean hasAppointment() {
        return this.appointment != null && !this.appointment.isEmpty();
    }

    public Encounter setAppointment(Reference value) {
        this.appointment = value;
        return this;
    }

    public Appointment getAppointmentTarget() {
        if (this.appointmentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentTarget = new Appointment();
            }
        }
        return this.appointmentTarget;
    }

    public Encounter setAppointmentTarget(Appointment value) {
        this.appointmentTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Encounter setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Duration getLength() {
        if (this.length == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.length");
            }
            if (Configuration.doAutoCreate()) {
                this.length = new Duration();
            }
        }
        return this.length;
    }

    public boolean hasLength() {
        return this.length != null && !this.length.isEmpty();
    }

    public Encounter setLength(Duration value) {
        this.length = value;
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public Encounter addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public List<Reference> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<Reference>();
        }
        return this.indication;
    }

    public boolean hasIndication() {
        if (this.indication == null) {
            return false;
        }
        for (Reference item : this.indication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIndication() {
        Reference t = new Reference();
        if (this.indication == null) {
            this.indication = new ArrayList<Reference>();
        }
        this.indication.add(t);
        return t;
    }

    public Encounter addIndication(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.indication == null) {
            this.indication = new ArrayList<Reference>();
        }
        this.indication.add(t);
        return this;
    }

    public List<Resource> getIndicationTarget() {
        if (this.indicationTarget == null) {
            this.indicationTarget = new ArrayList<Resource>();
        }
        return this.indicationTarget;
    }

    public EncounterHospitalizationComponent getHospitalization() {
        if (this.hospitalization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.hospitalization");
            }
            if (Configuration.doAutoCreate()) {
                this.hospitalization = new EncounterHospitalizationComponent();
            }
        }
        return this.hospitalization;
    }

    public boolean hasHospitalization() {
        return this.hospitalization != null && !this.hospitalization.isEmpty();
    }

    public Encounter setHospitalization(EncounterHospitalizationComponent value) {
        this.hospitalization = value;
        return this;
    }

    public List<EncounterLocationComponent> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        return this.location;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (EncounterLocationComponent item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterLocationComponent addLocation() {
        EncounterLocationComponent t = new EncounterLocationComponent();
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return t;
    }

    public Encounter addLocation(EncounterLocationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return this;
    }

    public Reference getServiceProvider() {
        if (this.serviceProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.serviceProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceProvider = new Reference();
            }
        }
        return this.serviceProvider;
    }

    public boolean hasServiceProvider() {
        return this.serviceProvider != null && !this.serviceProvider.isEmpty();
    }

    public Encounter setServiceProvider(Reference value) {
        this.serviceProvider = value;
        return this;
    }

    public Organization getServiceProviderTarget() {
        if (this.serviceProviderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.serviceProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceProviderTarget = new Organization();
            }
        }
        return this.serviceProviderTarget;
    }

    public Encounter setServiceProviderTarget(Organization value) {
        this.serviceProviderTarget = value;
        return this;
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Encounter setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public Encounter getPartOfTarget() {
        if (this.partOfTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOfTarget = new Encounter();
            }
        }
        return this.partOfTarget;
    }

    public Encounter setPartOfTarget(Encounter value) {
        this.partOfTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "planned | arrived | in-progress | onleave | finished | cancelled.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("statusHistory", "", "The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.", 0, Integer.MAX_VALUE, this.statusHistory));
        childrenList.add(new Property("class", "code", "inpatient | outpatient | ambulatory | emergency +.", 0, Integer.MAX_VALUE, this.class_));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient present at the encounter.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("episodeOfCare", "Reference(EpisodeOfCare)", "Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care, and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).", 0, Integer.MAX_VALUE, this.episodeOfCare));
        childrenList.add(new Property("incomingReferral", "Reference(ReferralRequest)", "The referral request this encounter satisfies (incoming referral).", 0, Integer.MAX_VALUE, this.incomingReferral));
        childrenList.add(new Property(SP_PARTICIPANT, "", "The\u00a0list of\u00a0people\u00a0responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant));
        childrenList.add(new Property(SP_APPOINTMENT, "Reference(Appointment)", "The appointment that scheduled this encounter.", 0, Integer.MAX_VALUE, this.appointment));
        childrenList.add(new Property("period", "Period", "The start and end time of the encounter.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property(SP_LENGTH, "Duration", "Quantity of time the encounter lasted. This excludes the time during leaves of absence.", 0, Integer.MAX_VALUE, this.length));
        childrenList.add(new Property(SP_REASON, "CodeableConcept", "Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property(SP_INDICATION, "Reference(Condition|Procedure)", "Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, Integer.MAX_VALUE, this.indication));
        childrenList.add(new Property("hospitalization", "", "Details about the admission to a healthcare service.", 0, Integer.MAX_VALUE, this.hospitalization));
        childrenList.add(new Property(SP_LOCATION, "", "List of locations where  the patient has been during this encounter.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property("serviceProvider", "Reference(Organization)", "An organization that is in charge of maintaining the information of this Encounter (e.g. who maintains the report or the master service catalog item, etc.). This MAY be the same as the organization on the Patient record, however it could be different. This MAY not be not the Service Delivery Location's Organization.", 0, Integer.MAX_VALUE, this.serviceProvider));
        childrenList.add(new Property("partOf", "Reference(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, Integer.MAX_VALUE, this.partOf));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -986695614: {
                return this.statusHistory == null ? new Base[]{} : this.statusHistory.toArray(new Base[this.statusHistory.size()]);
            }
            case 94742904: {
                Base[] baseArray;
                if (this.class_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.class_;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.priority;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
            case -1892140189: {
                return this.episodeOfCare == null ? new Base[]{} : this.episodeOfCare.toArray(new Base[this.episodeOfCare.size()]);
            }
            case -1258204701: {
                return this.incomingReferral == null ? new Base[]{} : this.incomingReferral.toArray(new Base[this.incomingReferral.size()]);
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -1474995297: {
                Base[] baseArray;
                if (this.appointment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.appointment;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.period;
                }
                return baseArray;
            }
            case -1106363674: {
                Base[] baseArray;
                if (this.length == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.length;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case -597168804: {
                return this.indication == null ? new Base[]{} : this.indication.toArray(new Base[this.indication.size()]);
            }
            case 1057894634: {
                Base[] baseArray;
                if (this.hospitalization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.hospitalization;
                }
                return baseArray;
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 243182534: {
                Base[] baseArray;
                if (this.serviceProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.serviceProvider;
                }
                return baseArray;
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.partOf;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -892481550: {
                this.status = new EncounterStateEnumFactory().fromType(value);
                break;
            }
            case -986695614: {
                this.getStatusHistory().add((EncounterStatusHistoryComponent)value);
                break;
            }
            case 94742904: {
                this.class_ = new EncounterClassEnumFactory().fromType(value);
                break;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                break;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -1892140189: {
                this.getEpisodeOfCare().add(this.castToReference(value));
                break;
            }
            case -1258204701: {
                this.getIncomingReferral().add(this.castToReference(value));
                break;
            }
            case 767422259: {
                this.getParticipant().add((EncounterParticipantComponent)value);
                break;
            }
            case -1474995297: {
                this.appointment = this.castToReference(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case -1106363674: {
                this.length = this.castToDuration(value);
                break;
            }
            case -934964668: {
                this.getReason().add(this.castToCodeableConcept(value));
                break;
            }
            case -597168804: {
                this.getIndication().add(this.castToReference(value));
                break;
            }
            case 1057894634: {
                this.hospitalization = (EncounterHospitalizationComponent)value;
                break;
            }
            case 1901043637: {
                this.getLocation().add((EncounterLocationComponent)value);
                break;
            }
            case 243182534: {
                this.serviceProvider = this.castToReference(value);
                break;
            }
            case -995410646: {
                this.partOf = this.castToReference(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new EncounterStateEnumFactory().fromType(value);
        } else if (name.equals("statusHistory")) {
            this.getStatusHistory().add((EncounterStatusHistoryComponent)value);
        } else if (name.equals("class")) {
            this.class_ = new EncounterClassEnumFactory().fromType(value);
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals("priority")) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("episodeOfCare")) {
            this.getEpisodeOfCare().add(this.castToReference(value));
        } else if (name.equals("incomingReferral")) {
            this.getIncomingReferral().add(this.castToReference(value));
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((EncounterParticipantComponent)value);
        } else if (name.equals(SP_APPOINTMENT)) {
            this.appointment = this.castToReference(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_LENGTH)) {
            this.length = this.castToDuration(value);
        } else if (name.equals(SP_REASON)) {
            this.getReason().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_INDICATION)) {
            this.getIndication().add(this.castToReference(value));
        } else if (name.equals("hospitalization")) {
            this.hospitalization = (EncounterHospitalizationComponent)value;
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add((EncounterLocationComponent)value);
        } else if (name.equals("serviceProvider")) {
            this.serviceProvider = this.castToReference(value);
        } else if (name.equals("partOf")) {
            this.partOf = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -986695614: {
                return this.addStatusHistory();
            }
            case 94742904: {
                throw new FHIRException("Cannot make property class as it is not a complex type");
            }
            case 3575610: {
                return this.addType();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1892140189: {
                return this.addEpisodeOfCare();
            }
            case -1258204701: {
                return this.addIncomingReferral();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -1474995297: {
                return this.getAppointment();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1106363674: {
                return this.getLength();
            }
            case -934964668: {
                return this.addReason();
            }
            case -597168804: {
                return this.addIndication();
            }
            case 1057894634: {
                return this.getHospitalization();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 243182534: {
                return this.getServiceProvider();
            }
            case -995410646: {
                return this.getPartOf();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Encounter.status");
        }
        if (name.equals("statusHistory")) {
            return this.addStatusHistory();
        }
        if (name.equals("class")) {
            throw new FHIRException("Cannot call addChild on a primitive type Encounter.class");
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("episodeOfCare")) {
            return this.addEpisodeOfCare();
        }
        if (name.equals("incomingReferral")) {
            return this.addIncomingReferral();
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_APPOINTMENT)) {
            this.appointment = new Reference();
            return this.appointment;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_LENGTH)) {
            this.length = new Duration();
            return this.length;
        }
        if (name.equals(SP_REASON)) {
            return this.addReason();
        }
        if (name.equals(SP_INDICATION)) {
            return this.addIndication();
        }
        if (name.equals("hospitalization")) {
            this.hospitalization = new EncounterHospitalizationComponent();
            return this.hospitalization;
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("serviceProvider")) {
            this.serviceProvider = new Reference();
            return this.serviceProvider;
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Encounter";
    }

    @Override
    public Encounter copy() {
        Encounter dst = new Encounter();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<EncounterState> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusHistory != null) {
            dst.statusHistory = new ArrayList<EncounterStatusHistoryComponent>();
            for (EncounterStatusHistoryComponent encounterStatusHistoryComponent : this.statusHistory) {
                dst.statusHistory.add(encounterStatusHistoryComponent.copy());
            }
        }
        Enumeration<EncounterClass> enumeration2 = dst.class_ = this.class_ == null ? null : this.class_.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        dst.priority = this.priority == null ? null : this.priority.copy();
        Reference reference = dst.patient = this.patient == null ? null : this.patient.copy();
        if (this.episodeOfCare != null) {
            dst.episodeOfCare = new ArrayList<Reference>();
            for (Reference reference2 : this.episodeOfCare) {
                dst.episodeOfCare.add(reference2.copy());
            }
        }
        if (this.incomingReferral != null) {
            dst.incomingReferral = new ArrayList<Reference>();
            for (Reference reference3 : this.incomingReferral) {
                dst.incomingReferral.add(reference3.copy());
            }
        }
        if (this.participant != null) {
            dst.participant = new ArrayList<EncounterParticipantComponent>();
            for (EncounterParticipantComponent encounterParticipantComponent : this.participant) {
                dst.participant.add(encounterParticipantComponent.copy());
            }
        }
        dst.appointment = this.appointment == null ? null : this.appointment.copy();
        dst.period = this.period == null ? null : this.period.copy();
        Duration duration = dst.length = this.length == null ? null : this.length.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        if (this.indication != null) {
            dst.indication = new ArrayList<Reference>();
            for (Reference reference4 : this.indication) {
                dst.indication.add(reference4.copy());
            }
        }
        EncounterHospitalizationComponent encounterHospitalizationComponent = dst.hospitalization = this.hospitalization == null ? null : this.hospitalization.copy();
        if (this.location != null) {
            dst.location = new ArrayList<EncounterLocationComponent>();
            for (EncounterLocationComponent encounterLocationComponent : this.location) {
                dst.location.add(encounterLocationComponent.copy());
            }
        }
        dst.serviceProvider = this.serviceProvider == null ? null : this.serviceProvider.copy();
        dst.partOf = this.partOf == null ? null : this.partOf.copy();
        return dst;
    }

    protected Encounter typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other;
        return Encounter.compareDeep(this.identifier, o.identifier, true) && Encounter.compareDeep(this.status, o.status, true) && Encounter.compareDeep(this.statusHistory, o.statusHistory, true) && Encounter.compareDeep(this.class_, o.class_, true) && Encounter.compareDeep(this.type, o.type, true) && Encounter.compareDeep(this.priority, o.priority, true) && Encounter.compareDeep(this.patient, o.patient, true) && Encounter.compareDeep(this.episodeOfCare, o.episodeOfCare, true) && Encounter.compareDeep(this.incomingReferral, o.incomingReferral, true) && Encounter.compareDeep(this.participant, o.participant, true) && Encounter.compareDeep(this.appointment, o.appointment, true) && Encounter.compareDeep(this.period, o.period, true) && Encounter.compareDeep(this.length, o.length, true) && Encounter.compareDeep(this.reason, o.reason, true) && Encounter.compareDeep(this.indication, o.indication, true) && Encounter.compareDeep(this.hospitalization, o.hospitalization, true) && Encounter.compareDeep(this.location, o.location, true) && Encounter.compareDeep(this.serviceProvider, o.serviceProvider, true) && Encounter.compareDeep(this.partOf, o.partOf, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other;
        return Encounter.compareValues(this.status, o.status, true) && Encounter.compareValues(this.class_, o.class_, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.statusHistory != null && !this.statusHistory.isEmpty() || this.class_ != null && !this.class_.isEmpty() || this.type != null && !this.type.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.episodeOfCare != null && !this.episodeOfCare.isEmpty() || this.incomingReferral != null && !this.incomingReferral.isEmpty() || this.participant != null && !this.participant.isEmpty() || this.appointment != null && !this.appointment.isEmpty() || this.period != null && !this.period.isEmpty() || this.length != null && !this.length.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.indication != null && !this.indication.isEmpty() || this.hospitalization != null && !this.hospitalization.isEmpty() || this.location != null && !this.location.isEmpty() || this.serviceProvider != null && !this.serviceProvider.isEmpty() || this.partOf != null && !this.partOf.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Encounter;
    }

    @Block
    public static class EncounterLocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="location", type={Location.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location the encounter takes place", formalDefinition="The location where the encounter takes place.")
        protected Reference location;
        protected Location locationTarget;
        @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | active | reserved | completed", formalDefinition="The status of the participants' presence at the specified location during the period specified. If the participant is is no longer at the location, then the period will have an end date/time.")
        protected Enumeration<EncounterLocationStatus> status;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time period during which the patient was present at the location", formalDefinition="Time period during which the patient was present at the location.")
        protected Period period;
        private static final long serialVersionUID = -322984880L;

        public EncounterLocationComponent() {
        }

        public EncounterLocationComponent(Reference location) {
            this.location = location;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public EncounterLocationComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Location getLocationTarget() {
            if (this.locationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.locationTarget = new Location();
                }
            }
            return this.locationTarget;
        }

        public EncounterLocationComponent setLocationTarget(Location value) {
            this.locationTarget = value;
            return this;
        }

        public Enumeration<EncounterLocationStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EncounterLocationComponent setStatusElement(Enumeration<EncounterLocationStatus> value) {
            this.status = value;
            return this;
        }

        public EncounterLocationStatus getStatus() {
            return this.status == null ? null : (EncounterLocationStatus)((Object)this.status.getValue());
        }

        public EncounterLocationComponent setStatus(EncounterLocationStatus value) {
            if (value == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
                this.status.setValue((Object)value);
            }
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterLocationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Encounter.SP_LOCATION, "Reference(Location)", "The location where the encounter takes place.", 0, Integer.MAX_VALUE, this.location));
            childrenList.add(new Property(Encounter.SP_STATUS, "code", "The status of the participants' presence at the specified location during the period specified. If the participant is is no longer at the location, then the period will have an end date/time.", 0, Integer.MAX_VALUE, this.status));
            childrenList.add(new Property("period", "Period", "Time period during which the patient was present at the location.", 0, Integer.MAX_VALUE, this.period));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.location;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    this.location = this.castToReference(value);
                    break;
                }
                case -892481550: {
                    this.status = new EncounterLocationStatusEnumFactory().fromType(value);
                    break;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = this.castToReference(value);
            } else if (name.equals(Encounter.SP_STATUS)) {
                this.status = new EncounterLocationStatusEnumFactory().fromType(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return this.getLocation();
                }
                case -892481550: {
                    throw new FHIRException("Cannot make property status as it is not a complex type");
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(Encounter.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterLocationComponent copy() {
            EncounterLocationComponent dst = new EncounterLocationComponent();
            this.copyValues(dst);
            dst.location = this.location == null ? null : this.location.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other;
            return EncounterLocationComponent.compareDeep(this.location, o.location, true) && EncounterLocationComponent.compareDeep(this.status, o.status, true) && EncounterLocationComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other;
            return EncounterLocationComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.location != null && !this.location.isEmpty() || this.status != null && !this.status.isEmpty() || this.period != null && !this.period.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Encounter.location";
        }
    }

    @Block
    public static class EncounterHospitalizationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="preAdmissionIdentifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pre-admission identifier", formalDefinition="Pre-admission identifier.")
        protected Identifier preAdmissionIdentifier;
        @Child(name="origin", type={Location.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The location from which the patient came before admission", formalDefinition="The location from which the patient came before admission.")
        protected Reference origin;
        protected Location originTarget;
        @Child(name="admitSource", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="From where patient was admitted (physician referral, transfer)", formalDefinition="From where patient was admitted (physician referral, transfer).")
        protected CodeableConcept admitSource;
        @Child(name="admittingDiagnosis", type={Condition.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The admitting diagnosis as reported by admitting practitioner", formalDefinition="The admitting diagnosis field is used to record the diagnosis codes as reported by admitting practitioner. This could be different or in addition to the conditions reported as reason-condition(s) for the encounter.")
        protected List<Reference> admittingDiagnosis;
        protected List<Condition> admittingDiagnosisTarget;
        @Child(name="reAdmission", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of hospital re-admission that has occurred (if any). If the value is absent, then this is not identified as a readmission", formalDefinition="Whether this hospitalization is a readmission and why if known.")
        protected CodeableConcept reAdmission;
        @Child(name="dietPreference", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Diet preferences reported by the patient", formalDefinition="Diet preferences reported by the patient.")
        protected List<CodeableConcept> dietPreference;
        @Child(name="specialCourtesy", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Special courtesies (VIP, board member)", formalDefinition="Special courtesies (VIP, board member).")
        protected List<CodeableConcept> specialCourtesy;
        @Child(name="specialArrangement", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Wheelchair, translator, stretcher, etc.", formalDefinition="Wheelchair, translator, stretcher, etc.")
        protected List<CodeableConcept> specialArrangement;
        @Child(name="destination", type={Location.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location to which the patient is discharged", formalDefinition="Location to which the patient is discharged.")
        protected Reference destination;
        protected Location destinationTarget;
        @Child(name="dischargeDisposition", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category or kind of location after discharge", formalDefinition="Category or kind of location after discharge.")
        protected CodeableConcept dischargeDisposition;
        @Child(name="dischargeDiagnosis", type={Condition.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The final diagnosis given a patient before release from the hospital after all testing, surgery, and workup are complete", formalDefinition="The final diagnosis given a patient before release from the hospital after all testing, surgery, and workup are complete.")
        protected List<Reference> dischargeDiagnosis;
        protected List<Condition> dischargeDiagnosisTarget;
        private static final long serialVersionUID = 164618034L;

        public Identifier getPreAdmissionIdentifier() {
            if (this.preAdmissionIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.preAdmissionIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.preAdmissionIdentifier = new Identifier();
                }
            }
            return this.preAdmissionIdentifier;
        }

        public boolean hasPreAdmissionIdentifier() {
            return this.preAdmissionIdentifier != null && !this.preAdmissionIdentifier.isEmpty();
        }

        public EncounterHospitalizationComponent setPreAdmissionIdentifier(Identifier value) {
            this.preAdmissionIdentifier = value;
            return this;
        }

        public Reference getOrigin() {
            if (this.origin == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.origin = new Reference();
                }
            }
            return this.origin;
        }

        public boolean hasOrigin() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public EncounterHospitalizationComponent setOrigin(Reference value) {
            this.origin = value;
            return this;
        }

        public Location getOriginTarget() {
            if (this.originTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.originTarget = new Location();
                }
            }
            return this.originTarget;
        }

        public EncounterHospitalizationComponent setOriginTarget(Location value) {
            this.originTarget = value;
            return this;
        }

        public CodeableConcept getAdmitSource() {
            if (this.admitSource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.admitSource");
                }
                if (Configuration.doAutoCreate()) {
                    this.admitSource = new CodeableConcept();
                }
            }
            return this.admitSource;
        }

        public boolean hasAdmitSource() {
            return this.admitSource != null && !this.admitSource.isEmpty();
        }

        public EncounterHospitalizationComponent setAdmitSource(CodeableConcept value) {
            this.admitSource = value;
            return this;
        }

        public List<Reference> getAdmittingDiagnosis() {
            if (this.admittingDiagnosis == null) {
                this.admittingDiagnosis = new ArrayList<Reference>();
            }
            return this.admittingDiagnosis;
        }

        public boolean hasAdmittingDiagnosis() {
            if (this.admittingDiagnosis == null) {
                return false;
            }
            for (Reference item : this.admittingDiagnosis) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAdmittingDiagnosis() {
            Reference t = new Reference();
            if (this.admittingDiagnosis == null) {
                this.admittingDiagnosis = new ArrayList<Reference>();
            }
            this.admittingDiagnosis.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addAdmittingDiagnosis(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.admittingDiagnosis == null) {
                this.admittingDiagnosis = new ArrayList<Reference>();
            }
            this.admittingDiagnosis.add(t);
            return this;
        }

        public List<Condition> getAdmittingDiagnosisTarget() {
            if (this.admittingDiagnosisTarget == null) {
                this.admittingDiagnosisTarget = new ArrayList<Condition>();
            }
            return this.admittingDiagnosisTarget;
        }

        public Condition addAdmittingDiagnosisTarget() {
            Condition r = new Condition();
            if (this.admittingDiagnosisTarget == null) {
                this.admittingDiagnosisTarget = new ArrayList<Condition>();
            }
            this.admittingDiagnosisTarget.add(r);
            return r;
        }

        public CodeableConcept getReAdmission() {
            if (this.reAdmission == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.reAdmission");
                }
                if (Configuration.doAutoCreate()) {
                    this.reAdmission = new CodeableConcept();
                }
            }
            return this.reAdmission;
        }

        public boolean hasReAdmission() {
            return this.reAdmission != null && !this.reAdmission.isEmpty();
        }

        public EncounterHospitalizationComponent setReAdmission(CodeableConcept value) {
            this.reAdmission = value;
            return this;
        }

        public List<CodeableConcept> getDietPreference() {
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            return this.dietPreference;
        }

        public boolean hasDietPreference() {
            if (this.dietPreference == null) {
                return false;
            }
            for (CodeableConcept item : this.dietPreference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDietPreference() {
            CodeableConcept t = new CodeableConcept();
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            this.dietPreference.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addDietPreference(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            this.dietPreference.add(t);
            return this;
        }

        public List<CodeableConcept> getSpecialCourtesy() {
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            return this.specialCourtesy;
        }

        public boolean hasSpecialCourtesy() {
            if (this.specialCourtesy == null) {
                return false;
            }
            for (CodeableConcept item : this.specialCourtesy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialCourtesy() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            this.specialCourtesy.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addSpecialCourtesy(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            this.specialCourtesy.add(t);
            return this;
        }

        public List<CodeableConcept> getSpecialArrangement() {
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            return this.specialArrangement;
        }

        public boolean hasSpecialArrangement() {
            if (this.specialArrangement == null) {
                return false;
            }
            for (CodeableConcept item : this.specialArrangement) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialArrangement() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            this.specialArrangement.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addSpecialArrangement(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            this.specialArrangement.add(t);
            return this;
        }

        public Reference getDestination() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new Reference();
                }
            }
            return this.destination;
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public EncounterHospitalizationComponent setDestination(Reference value) {
            this.destination = value;
            return this;
        }

        public Location getDestinationTarget() {
            if (this.destinationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destinationTarget = new Location();
                }
            }
            return this.destinationTarget;
        }

        public EncounterHospitalizationComponent setDestinationTarget(Location value) {
            this.destinationTarget = value;
            return this;
        }

        public CodeableConcept getDischargeDisposition() {
            if (this.dischargeDisposition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.dischargeDisposition");
                }
                if (Configuration.doAutoCreate()) {
                    this.dischargeDisposition = new CodeableConcept();
                }
            }
            return this.dischargeDisposition;
        }

        public boolean hasDischargeDisposition() {
            return this.dischargeDisposition != null && !this.dischargeDisposition.isEmpty();
        }

        public EncounterHospitalizationComponent setDischargeDisposition(CodeableConcept value) {
            this.dischargeDisposition = value;
            return this;
        }

        public List<Reference> getDischargeDiagnosis() {
            if (this.dischargeDiagnosis == null) {
                this.dischargeDiagnosis = new ArrayList<Reference>();
            }
            return this.dischargeDiagnosis;
        }

        public boolean hasDischargeDiagnosis() {
            if (this.dischargeDiagnosis == null) {
                return false;
            }
            for (Reference item : this.dischargeDiagnosis) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDischargeDiagnosis() {
            Reference t = new Reference();
            if (this.dischargeDiagnosis == null) {
                this.dischargeDiagnosis = new ArrayList<Reference>();
            }
            this.dischargeDiagnosis.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addDischargeDiagnosis(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.dischargeDiagnosis == null) {
                this.dischargeDiagnosis = new ArrayList<Reference>();
            }
            this.dischargeDiagnosis.add(t);
            return this;
        }

        public List<Condition> getDischargeDiagnosisTarget() {
            if (this.dischargeDiagnosisTarget == null) {
                this.dischargeDiagnosisTarget = new ArrayList<Condition>();
            }
            return this.dischargeDiagnosisTarget;
        }

        public Condition addDischargeDiagnosisTarget() {
            Condition r = new Condition();
            if (this.dischargeDiagnosisTarget == null) {
                this.dischargeDiagnosisTarget = new ArrayList<Condition>();
            }
            this.dischargeDiagnosisTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, Integer.MAX_VALUE, this.preAdmissionIdentifier));
            childrenList.add(new Property("origin", "Reference(Location)", "The location from which the patient came before admission.", 0, Integer.MAX_VALUE, this.origin));
            childrenList.add(new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, Integer.MAX_VALUE, this.admitSource));
            childrenList.add(new Property("admittingDiagnosis", "Reference(Condition)", "The admitting diagnosis field is used to record the diagnosis codes as reported by admitting practitioner. This could be different or in addition to the conditions reported as reason-condition(s) for the encounter.", 0, Integer.MAX_VALUE, this.admittingDiagnosis));
            childrenList.add(new Property("reAdmission", "CodeableConcept", "Whether this hospitalization is a readmission and why if known.", 0, Integer.MAX_VALUE, this.reAdmission));
            childrenList.add(new Property("dietPreference", "CodeableConcept", "Diet preferences reported by the patient.", 0, Integer.MAX_VALUE, this.dietPreference));
            childrenList.add(new Property("specialCourtesy", "CodeableConcept", "Special courtesies (VIP, board member).", 0, Integer.MAX_VALUE, this.specialCourtesy));
            childrenList.add(new Property("specialArrangement", "CodeableConcept", "Wheelchair, translator, stretcher, etc.", 0, Integer.MAX_VALUE, this.specialArrangement));
            childrenList.add(new Property("destination", "Reference(Location)", "Location to which the patient is discharged.", 0, Integer.MAX_VALUE, this.destination));
            childrenList.add(new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, Integer.MAX_VALUE, this.dischargeDisposition));
            childrenList.add(new Property("dischargeDiagnosis", "Reference(Condition)", "The final diagnosis given a patient before release from the hospital after all testing, surgery, and workup are complete.", 0, Integer.MAX_VALUE, this.dischargeDiagnosis));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    Base[] baseArray;
                    if (this.preAdmissionIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.preAdmissionIdentifier;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    Base[] baseArray;
                    if (this.origin == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.origin;
                    }
                    return baseArray;
                }
                case 538887120: {
                    Base[] baseArray;
                    if (this.admitSource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.admitSource;
                    }
                    return baseArray;
                }
                case 2048045678: {
                    return this.admittingDiagnosis == null ? new Base[]{} : this.admittingDiagnosis.toArray(new Base[this.admittingDiagnosis.size()]);
                }
                case 669348630: {
                    Base[] baseArray;
                    if (this.reAdmission == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.reAdmission;
                    }
                    return baseArray;
                }
                case -1360641041: {
                    return this.dietPreference == null ? new Base[]{} : this.dietPreference.toArray(new Base[this.dietPreference.size()]);
                }
                case 1583588345: {
                    return this.specialCourtesy == null ? new Base[]{} : this.specialCourtesy.toArray(new Base[this.specialCourtesy.size()]);
                }
                case 47410321: {
                    return this.specialArrangement == null ? new Base[]{} : this.specialArrangement.toArray(new Base[this.specialArrangement.size()]);
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.destination;
                    }
                    return baseArray;
                }
                case 528065941: {
                    Base[] baseArray;
                    if (this.dischargeDisposition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.dischargeDisposition;
                    }
                    return baseArray;
                }
                case -1985183665: {
                    return this.dischargeDiagnosis == null ? new Base[]{} : this.dischargeDiagnosis.toArray(new Base[this.dischargeDiagnosis.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    this.preAdmissionIdentifier = this.castToIdentifier(value);
                    break;
                }
                case -1008619738: {
                    this.origin = this.castToReference(value);
                    break;
                }
                case 538887120: {
                    this.admitSource = this.castToCodeableConcept(value);
                    break;
                }
                case 2048045678: {
                    this.getAdmittingDiagnosis().add(this.castToReference(value));
                    break;
                }
                case 669348630: {
                    this.reAdmission = this.castToCodeableConcept(value);
                    break;
                }
                case -1360641041: {
                    this.getDietPreference().add(this.castToCodeableConcept(value));
                    break;
                }
                case 1583588345: {
                    this.getSpecialCourtesy().add(this.castToCodeableConcept(value));
                    break;
                }
                case 47410321: {
                    this.getSpecialArrangement().add(this.castToCodeableConcept(value));
                    break;
                }
                case -1429847026: {
                    this.destination = this.castToReference(value);
                    break;
                }
                case 528065941: {
                    this.dischargeDisposition = this.castToCodeableConcept(value);
                    break;
                }
                case -1985183665: {
                    this.getDischargeDiagnosis().add(this.castToReference(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = this.castToIdentifier(value);
            } else if (name.equals("origin")) {
                this.origin = this.castToReference(value);
            } else if (name.equals("admitSource")) {
                this.admitSource = this.castToCodeableConcept(value);
            } else if (name.equals("admittingDiagnosis")) {
                this.getAdmittingDiagnosis().add(this.castToReference(value));
            } else if (name.equals("reAdmission")) {
                this.reAdmission = this.castToCodeableConcept(value);
            } else if (name.equals("dietPreference")) {
                this.getDietPreference().add(this.castToCodeableConcept(value));
            } else if (name.equals("specialCourtesy")) {
                this.getSpecialCourtesy().add(this.castToCodeableConcept(value));
            } else if (name.equals("specialArrangement")) {
                this.getSpecialArrangement().add(this.castToCodeableConcept(value));
            } else if (name.equals("destination")) {
                this.destination = this.castToReference(value);
            } else if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = this.castToCodeableConcept(value);
            } else if (name.equals("dischargeDiagnosis")) {
                this.getDischargeDiagnosis().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    return this.getPreAdmissionIdentifier();
                }
                case -1008619738: {
                    return this.getOrigin();
                }
                case 538887120: {
                    return this.getAdmitSource();
                }
                case 2048045678: {
                    return this.addAdmittingDiagnosis();
                }
                case 669348630: {
                    return this.getReAdmission();
                }
                case -1360641041: {
                    return this.addDietPreference();
                }
                case 1583588345: {
                    return this.addSpecialCourtesy();
                }
                case 47410321: {
                    return this.addSpecialArrangement();
                }
                case -1429847026: {
                    return this.getDestination();
                }
                case 528065941: {
                    return this.getDischargeDisposition();
                }
                case -1985183665: {
                    return this.addDischargeDiagnosis();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = new Identifier();
                return this.preAdmissionIdentifier;
            }
            if (name.equals("origin")) {
                this.origin = new Reference();
                return this.origin;
            }
            if (name.equals("admitSource")) {
                this.admitSource = new CodeableConcept();
                return this.admitSource;
            }
            if (name.equals("admittingDiagnosis")) {
                return this.addAdmittingDiagnosis();
            }
            if (name.equals("reAdmission")) {
                this.reAdmission = new CodeableConcept();
                return this.reAdmission;
            }
            if (name.equals("dietPreference")) {
                return this.addDietPreference();
            }
            if (name.equals("specialCourtesy")) {
                return this.addSpecialCourtesy();
            }
            if (name.equals("specialArrangement")) {
                return this.addSpecialArrangement();
            }
            if (name.equals("destination")) {
                this.destination = new Reference();
                return this.destination;
            }
            if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = new CodeableConcept();
                return this.dischargeDisposition;
            }
            if (name.equals("dischargeDiagnosis")) {
                return this.addDischargeDiagnosis();
            }
            return super.addChild(name);
        }

        @Override
        public EncounterHospitalizationComponent copy() {
            EncounterHospitalizationComponent dst = new EncounterHospitalizationComponent();
            this.copyValues(dst);
            dst.preAdmissionIdentifier = this.preAdmissionIdentifier == null ? null : this.preAdmissionIdentifier.copy();
            dst.origin = this.origin == null ? null : this.origin.copy();
            CodeableConcept codeableConcept = dst.admitSource = this.admitSource == null ? null : this.admitSource.copy();
            if (this.admittingDiagnosis != null) {
                dst.admittingDiagnosis = new ArrayList<Reference>();
                for (Reference reference : this.admittingDiagnosis) {
                    dst.admittingDiagnosis.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept2 = dst.reAdmission = this.reAdmission == null ? null : this.reAdmission.copy();
            if (this.dietPreference != null) {
                dst.dietPreference = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.dietPreference) {
                    dst.dietPreference.add(codeableConcept3.copy());
                }
            }
            if (this.specialCourtesy != null) {
                dst.specialCourtesy = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept4 : this.specialCourtesy) {
                    dst.specialCourtesy.add(codeableConcept4.copy());
                }
            }
            if (this.specialArrangement != null) {
                dst.specialArrangement = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept5 : this.specialArrangement) {
                    dst.specialArrangement.add(codeableConcept5.copy());
                }
            }
            dst.destination = this.destination == null ? null : this.destination.copy();
            CodeableConcept codeableConcept6 = dst.dischargeDisposition = this.dischargeDisposition == null ? null : this.dischargeDisposition.copy();
            if (this.dischargeDiagnosis != null) {
                dst.dischargeDiagnosis = new ArrayList<Reference>();
                for (Reference reference : this.dischargeDiagnosis) {
                    dst.dischargeDiagnosis.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof EncounterHospitalizationComponent)) {
                return false;
            }
            EncounterHospitalizationComponent o = (EncounterHospitalizationComponent)other;
            return EncounterHospitalizationComponent.compareDeep(this.preAdmissionIdentifier, o.preAdmissionIdentifier, true) && EncounterHospitalizationComponent.compareDeep(this.origin, o.origin, true) && EncounterHospitalizationComponent.compareDeep(this.admitSource, o.admitSource, true) && EncounterHospitalizationComponent.compareDeep(this.admittingDiagnosis, o.admittingDiagnosis, true) && EncounterHospitalizationComponent.compareDeep(this.reAdmission, o.reAdmission, true) && EncounterHospitalizationComponent.compareDeep(this.dietPreference, o.dietPreference, true) && EncounterHospitalizationComponent.compareDeep(this.specialCourtesy, o.specialCourtesy, true) && EncounterHospitalizationComponent.compareDeep(this.specialArrangement, o.specialArrangement, true) && EncounterHospitalizationComponent.compareDeep(this.destination, o.destination, true) && EncounterHospitalizationComponent.compareDeep(this.dischargeDisposition, o.dischargeDisposition, true) && EncounterHospitalizationComponent.compareDeep(this.dischargeDiagnosis, o.dischargeDiagnosis, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof EncounterHospitalizationComponent)) {
                return false;
            }
            EncounterHospitalizationComponent o = (EncounterHospitalizationComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.preAdmissionIdentifier != null && !this.preAdmissionIdentifier.isEmpty() || this.origin != null && !this.origin.isEmpty() || this.admitSource != null && !this.admitSource.isEmpty() || this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty() || this.reAdmission != null && !this.reAdmission.isEmpty() || this.dietPreference != null && !this.dietPreference.isEmpty() || this.specialCourtesy != null && !this.specialCourtesy.isEmpty() || this.specialArrangement != null && !this.specialArrangement.isEmpty() || this.destination != null && !this.destination.isEmpty() || this.dischargeDisposition != null && !this.dischargeDisposition.isEmpty() || this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Encounter.hospitalization";
        }
    }

    @Block
    public static class EncounterParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Role of participant in encounter", formalDefinition="Role of participant in encounter.")
        protected List<CodeableConcept> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period of time during the encounter participant was present", formalDefinition="The period of time that the specified participant was present during the encounter. These can overlap or be sub-sets of the overall encounters period.")
        protected Period period;
        @Child(name="individual", type={Practitioner.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Persons involved in the encounter other than the patient", formalDefinition="Persons involved in the encounter other than the patient.")
        protected Reference individual;
        protected Resource individualTarget;
        private static final long serialVersionUID = 317095765L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public EncounterParticipantComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterParticipantComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getIndividual() {
            if (this.individual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.individual");
                }
                if (Configuration.doAutoCreate()) {
                    this.individual = new Reference();
                }
            }
            return this.individual;
        }

        public boolean hasIndividual() {
            return this.individual != null && !this.individual.isEmpty();
        }

        public EncounterParticipantComponent setIndividual(Reference value) {
            this.individual = value;
            return this;
        }

        public Resource getIndividualTarget() {
            return this.individualTarget;
        }

        public EncounterParticipantComponent setIndividualTarget(Resource value) {
            this.individualTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Encounter.SP_TYPE, "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("period", "Period", "The period of time that the specified participant was present during the encounter. These can overlap or be sub-sets of the overall encounters period.", 0, Integer.MAX_VALUE, this.period));
            childrenList.add(new Property("individual", "Reference(Practitioner|RelatedPerson)", "Persons involved in the encounter other than the patient.", 0, Integer.MAX_VALUE, this.individual));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.period;
                    }
                    return baseArray;
                }
                case -46292327: {
                    Base[] baseArray;
                    if (this.individual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.individual;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    break;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    break;
                }
                case -46292327: {
                    this.individual = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("individual")) {
                this.individual = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -46292327: {
                    return this.getIndividual();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                return this.addType();
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("individual")) {
                this.individual = new Reference();
                return this.individual;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterParticipantComponent copy() {
            EncounterParticipantComponent dst = new EncounterParticipantComponent();
            this.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.period = this.period == null ? null : this.period.copy();
            dst.individual = this.individual == null ? null : this.individual.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other;
            return EncounterParticipantComponent.compareDeep(this.type, o.type, true) && EncounterParticipantComponent.compareDeep(this.period, o.period, true) && EncounterParticipantComponent.compareDeep(this.individual, o.individual, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.period != null && !this.period.isEmpty() || this.individual != null && !this.individual.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Encounter.participant";
        }
    }

    @Block
    public static class EncounterStatusHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | arrived | in-progress | onleave | finished | cancelled", formalDefinition="planned | arrived | in-progress | onleave | finished | cancelled.")
        protected Enumeration<EncounterState> status;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The time that the episode was in the specified status", formalDefinition="The time that the episode was in the specified status.")
        protected Period period;
        private static final long serialVersionUID = 919229161L;

        public EncounterStatusHistoryComponent() {
        }

        public EncounterStatusHistoryComponent(Enumeration<EncounterState> status, Period period) {
            this.status = status;
            this.period = period;
        }

        public Enumeration<EncounterState> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterStatusHistoryComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EncounterState>(new EncounterStateEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EncounterStatusHistoryComponent setStatusElement(Enumeration<EncounterState> value) {
            this.status = value;
            return this;
        }

        public EncounterState getStatus() {
            return this.status == null ? null : (EncounterState)((Object)this.status.getValue());
        }

        public EncounterStatusHistoryComponent setStatus(EncounterState value) {
            if (this.status == null) {
                this.status = new Enumeration<EncounterState>(new EncounterStateEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterStatusHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterStatusHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Encounter.SP_STATUS, "code", "planned | arrived | in-progress | onleave | finished | cancelled.", 0, Integer.MAX_VALUE, this.status));
            childrenList.add(new Property("period", "Period", "The time that the episode was in the specified status.", 0, Integer.MAX_VALUE, this.period));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = new EncounterStateEnumFactory().fromType(value);
                    break;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_STATUS)) {
                this.status = new EncounterStateEnumFactory().fromType(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    throw new FHIRException("Cannot make property status as it is not a complex type");
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterStatusHistoryComponent copy() {
            EncounterStatusHistoryComponent dst = new EncounterStatusHistoryComponent();
            this.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof EncounterStatusHistoryComponent)) {
                return false;
            }
            EncounterStatusHistoryComponent o = (EncounterStatusHistoryComponent)other;
            return EncounterStatusHistoryComponent.compareDeep(this.status, o.status, true) && EncounterStatusHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof EncounterStatusHistoryComponent)) {
                return false;
            }
            EncounterStatusHistoryComponent o = (EncounterStatusHistoryComponent)other;
            return EncounterStatusHistoryComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.status != null && !this.status.isEmpty() || this.period != null && !this.period.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Encounter.statusHistory";
        }
    }

    public static class EncounterLocationStatusEnumFactory
    implements EnumFactory<EncounterLocationStatus> {
        @Override
        public EncounterLocationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EncounterLocationStatus.PLANNED;
            }
            if ("active".equals(codeString)) {
                return EncounterLocationStatus.ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return EncounterLocationStatus.RESERVED;
            }
            if ("completed".equals(codeString)) {
                return EncounterLocationStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public Enumeration<EncounterLocationStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.PLANNED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.ACTIVE);
            }
            if ("reserved".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.RESERVED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.COMPLETED);
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterLocationStatus code) {
            if (code == EncounterLocationStatus.PLANNED) {
                return "planned";
            }
            if (code == EncounterLocationStatus.ACTIVE) {
                return "active";
            }
            if (code == EncounterLocationStatus.RESERVED) {
                return "reserved";
            }
            if (code == EncounterLocationStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterLocationStatus code) {
            return code.getSystem();
        }
    }

    public static enum EncounterLocationStatus {
        PLANNED,
        ACTIVE,
        RESERVED,
        COMPLETED,
        NULL;


        public static EncounterLocationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return RESERVED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case ACTIVE: {
                    return "active";
                }
                case RESERVED: {
                    return "reserved";
                }
                case COMPLETED: {
                    return "completed";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case RESERVED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The patient is planned to be moved to this location at some point in the future.";
                }
                case ACTIVE: {
                    return "The patient is currently at this location, or was between the period specified.\n\nA system may update these records when the patient leaves the location to either reserved, or completed";
                }
                case RESERVED: {
                    return "This location is held empty for this patient.";
                }
                case COMPLETED: {
                    return "The patient was at this location during the period specified.\n\nNot to be used when the patient is currently at the location";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case ACTIVE: {
                    return "Active";
                }
                case RESERVED: {
                    return "Reserved";
                }
                case COMPLETED: {
                    return "Completed";
                }
            }
            return "?";
        }
    }

    public static class EncounterClassEnumFactory
    implements EnumFactory<EncounterClass> {
        @Override
        public EncounterClass fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("inpatient".equals(codeString)) {
                return EncounterClass.INPATIENT;
            }
            if ("outpatient".equals(codeString)) {
                return EncounterClass.OUTPATIENT;
            }
            if ("ambulatory".equals(codeString)) {
                return EncounterClass.AMBULATORY;
            }
            if ("emergency".equals(codeString)) {
                return EncounterClass.EMERGENCY;
            }
            if ("home".equals(codeString)) {
                return EncounterClass.HOME;
            }
            if ("field".equals(codeString)) {
                return EncounterClass.FIELD;
            }
            if ("daytime".equals(codeString)) {
                return EncounterClass.DAYTIME;
            }
            if ("virtual".equals(codeString)) {
                return EncounterClass.VIRTUAL;
            }
            if ("other".equals(codeString)) {
                return EncounterClass.OTHER;
            }
            throw new IllegalArgumentException("Unknown EncounterClass code '" + codeString + "'");
        }

        public Enumeration<EncounterClass> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("inpatient".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.INPATIENT);
            }
            if ("outpatient".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.OUTPATIENT);
            }
            if ("ambulatory".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.AMBULATORY);
            }
            if ("emergency".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.EMERGENCY);
            }
            if ("home".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.HOME);
            }
            if ("field".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.FIELD);
            }
            if ("daytime".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.DAYTIME);
            }
            if ("virtual".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.VIRTUAL);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<EncounterClass>(this, EncounterClass.OTHER);
            }
            throw new FHIRException("Unknown EncounterClass code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterClass code) {
            if (code == EncounterClass.INPATIENT) {
                return "inpatient";
            }
            if (code == EncounterClass.OUTPATIENT) {
                return "outpatient";
            }
            if (code == EncounterClass.AMBULATORY) {
                return "ambulatory";
            }
            if (code == EncounterClass.EMERGENCY) {
                return "emergency";
            }
            if (code == EncounterClass.HOME) {
                return "home";
            }
            if (code == EncounterClass.FIELD) {
                return "field";
            }
            if (code == EncounterClass.DAYTIME) {
                return "daytime";
            }
            if (code == EncounterClass.VIRTUAL) {
                return "virtual";
            }
            if (code == EncounterClass.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterClass code) {
            return code.getSystem();
        }
    }

    public static enum EncounterClass {
        INPATIENT,
        OUTPATIENT,
        AMBULATORY,
        EMERGENCY,
        HOME,
        FIELD,
        DAYTIME,
        VIRTUAL,
        OTHER,
        NULL;


        public static EncounterClass fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("inpatient".equals(codeString)) {
                return INPATIENT;
            }
            if ("outpatient".equals(codeString)) {
                return OUTPATIENT;
            }
            if ("ambulatory".equals(codeString)) {
                return AMBULATORY;
            }
            if ("emergency".equals(codeString)) {
                return EMERGENCY;
            }
            if ("home".equals(codeString)) {
                return HOME;
            }
            if ("field".equals(codeString)) {
                return FIELD;
            }
            if ("daytime".equals(codeString)) {
                return DAYTIME;
            }
            if ("virtual".equals(codeString)) {
                return VIRTUAL;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            throw new FHIRException("Unknown EncounterClass code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPATIENT: {
                    return "inpatient";
                }
                case OUTPATIENT: {
                    return "outpatient";
                }
                case AMBULATORY: {
                    return "ambulatory";
                }
                case EMERGENCY: {
                    return "emergency";
                }
                case HOME: {
                    return "home";
                }
                case FIELD: {
                    return "field";
                }
                case DAYTIME: {
                    return "daytime";
                }
                case VIRTUAL: {
                    return "virtual";
                }
                case OTHER: {
                    return "other";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPATIENT: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case OUTPATIENT: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case AMBULATORY: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case EMERGENCY: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case HOME: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case FIELD: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case DAYTIME: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case VIRTUAL: {
                    return "http://hl7.org/fhir/encounter-class";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/encounter-class";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPATIENT: {
                    return "An encounter during which the patient is hospitalized and stays overnight.";
                }
                case OUTPATIENT: {
                    return "An encounter during which the patient is not hospitalized overnight.";
                }
                case AMBULATORY: {
                    return "An encounter where the patient visits the practitioner in his/her office, e.g. a G.P. visit.";
                }
                case EMERGENCY: {
                    return "An encounter in the Emergency Care Department.";
                }
                case HOME: {
                    return "An encounter where the practitioner visits the patient at his/her home.";
                }
                case FIELD: {
                    return "An encounter taking place outside the regular environment for giving care.";
                }
                case DAYTIME: {
                    return "An encounter where the patient needs more prolonged treatment or investigations than outpatients, but who do not need to stay in the hospital overnight.";
                }
                case VIRTUAL: {
                    return "An encounter that takes place where the patient and practitioner do not physically meet but use electronic means for contact.";
                }
                case OTHER: {
                    return "Any other encounter type that is not described by one of the other values. Where this is used it is expected that an implementer will include an extension value to define what the actual other type is.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPATIENT: {
                    return "Inpatient";
                }
                case OUTPATIENT: {
                    return "Outpatient";
                }
                case AMBULATORY: {
                    return "Ambulatory";
                }
                case EMERGENCY: {
                    return "Emergency";
                }
                case HOME: {
                    return "Home";
                }
                case FIELD: {
                    return "Field";
                }
                case DAYTIME: {
                    return "Daytime";
                }
                case VIRTUAL: {
                    return "Virtual";
                }
                case OTHER: {
                    return "Other";
                }
            }
            return "?";
        }
    }

    public static class EncounterStateEnumFactory
    implements EnumFactory<EncounterState> {
        @Override
        public EncounterState fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EncounterState.PLANNED;
            }
            if ("arrived".equals(codeString)) {
                return EncounterState.ARRIVED;
            }
            if ("in-progress".equals(codeString)) {
                return EncounterState.INPROGRESS;
            }
            if ("onleave".equals(codeString)) {
                return EncounterState.ONLEAVE;
            }
            if ("finished".equals(codeString)) {
                return EncounterState.FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return EncounterState.CANCELLED;
            }
            throw new IllegalArgumentException("Unknown EncounterState code '" + codeString + "'");
        }

        public Enumeration<EncounterState> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EncounterState>(this, EncounterState.PLANNED);
            }
            if ("arrived".equals(codeString)) {
                return new Enumeration<EncounterState>(this, EncounterState.ARRIVED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<EncounterState>(this, EncounterState.INPROGRESS);
            }
            if ("onleave".equals(codeString)) {
                return new Enumeration<EncounterState>(this, EncounterState.ONLEAVE);
            }
            if ("finished".equals(codeString)) {
                return new Enumeration<EncounterState>(this, EncounterState.FINISHED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EncounterState>(this, EncounterState.CANCELLED);
            }
            throw new FHIRException("Unknown EncounterState code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterState code) {
            if (code == EncounterState.PLANNED) {
                return "planned";
            }
            if (code == EncounterState.ARRIVED) {
                return "arrived";
            }
            if (code == EncounterState.INPROGRESS) {
                return "in-progress";
            }
            if (code == EncounterState.ONLEAVE) {
                return "onleave";
            }
            if (code == EncounterState.FINISHED) {
                return "finished";
            }
            if (code == EncounterState.CANCELLED) {
                return "cancelled";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterState code) {
            return code.getSystem();
        }
    }

    public static enum EncounterState {
        PLANNED,
        ARRIVED,
        INPROGRESS,
        ONLEAVE,
        FINISHED,
        CANCELLED,
        NULL;


        public static EncounterState fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("arrived".equals(codeString)) {
                return ARRIVED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("onleave".equals(codeString)) {
                return ONLEAVE;
            }
            if ("finished".equals(codeString)) {
                return FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            throw new FHIRException("Unknown EncounterState code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case ARRIVED: {
                    return "arrived";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONLEAVE: {
                    return "onleave";
                }
                case FINISHED: {
                    return "finished";
                }
                case CANCELLED: {
                    return "cancelled";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/encounter-state";
                }
                case ARRIVED: {
                    return "http://hl7.org/fhir/encounter-state";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/encounter-state";
                }
                case ONLEAVE: {
                    return "http://hl7.org/fhir/encounter-state";
                }
                case FINISHED: {
                    return "http://hl7.org/fhir/encounter-state";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/encounter-state";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The Encounter has not yet started.";
                }
                case ARRIVED: {
                    return "The Patient is present for the encounter, however is not currently meeting with a practitioner.";
                }
                case INPROGRESS: {
                    return "The Encounter has begun and the patient is present / the practitioner and the patient are meeting.";
                }
                case ONLEAVE: {
                    return "The Encounter has begun, but the patient is temporarily on leave.";
                }
                case FINISHED: {
                    return "The Encounter has ended.";
                }
                case CANCELLED: {
                    return "The Encounter has ended before it has begun.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case ARRIVED: {
                    return "Arrived";
                }
                case INPROGRESS: {
                    return "in Progress";
                }
                case ONLEAVE: {
                    return "On Leave";
                }
                case FINISHED: {
                    return "Finished";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
            }
            return "?";
        }
    }
}

