/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DataElement", profile="http://hl7.org/fhir/Profile/DataElement")
public class DataElement
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Globally unique logical id for data element", formalDefinition="An absolute URL that is used to identify this data element when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this data element is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id to reference this data element", formalDefinition="Formal identifier that is used to identify this data element when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id for this version of the data element", formalDefinition="The identifier that is used to identify this version of the data element when it is referenced in a StructureDefinition, Questionnaire or instance. This is an arbitrary value managed by the definition author manually.")
    protected StringType version;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the data element.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this search data element definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the data element.")
    protected StringType publisher;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for this version of the data element", formalDefinition="The date this version of the data element was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the data element  changes.")
    protected DateTimeType date;
    @Child(name="name", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Descriptive label for this element definition", formalDefinition="The term used by humans to refer to the data element.  Should ideally be unique within the context in which the data element is expected to be used.")
    protected StringType name;
    @Child(name="contact", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<DataElementContactComponent> contact;
    @Child(name="useContext", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of data element definitions.")
    protected List<CodeableConcept> useContext;
    @Child(name="copyright", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the definition of the data element. Copyright statements are generally legal restrictions on the use and publishing of the details of the definition of the data element.")
    protected StringType copyright;
    @Child(name="stringency", type={CodeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="comparable | fully-specified | equivalent | convertable | scaleable | flexible", formalDefinition="Identifies how precise the data element is in its definition.")
    protected Enumeration<DataElementStringency> stringency;
    @Child(name="mapping", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External specification mapped to", formalDefinition="Identifies a specification (other than a terminology) that the elements which make up the DataElement have some correspondence with.")
    protected List<DataElementMappingComponent> mapping;
    @Child(name="element", type={ElementDefinition.class}, order=13, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Definition of element", formalDefinition="Defines the structure, type, allowed values and other constraining characteristics of the data element.")
    protected List<ElementDefinition> element;
    private static final long serialVersionUID = 411433995L;
    @SearchParamDefinition(name="stringency", path="DataElement.stringency", description="The stringency of the data element definition", type="token")
    public static final String SP_STRINGENCY = "stringency";
    public static final TokenClientParam STRINGENCY = new TokenClientParam("stringency");
    @SearchParamDefinition(name="status", path="DataElement.status", description="The current status of the data element", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="DataElement.element.definition", description="Text search in the description of the data element.  This corresponds to the definition of the first DataElement.element.", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="DataElement.name", description="Name of the data element", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="DataElement.useContext", description="A use context assigned to the data element", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="code", path="DataElement.element.code", description="A code for the data element (server may choose to do subsumption)", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="DataElement.date", description="The data element publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="DataElement.identifier", description="The identifier of the data element", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="url", path="DataElement.url", description="The official URL for the data element", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="publisher", path="DataElement.publisher", description="Name of the publisher of the data element", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="version", path="DataElement.version", description="The version identifier of the data element", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");

    public DataElement() {
    }

    public DataElement(Enumeration<Enumerations.ConformanceResourceStatus> status) {
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public DataElement setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public DataElement setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DataElement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public DataElement setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public DataElement setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DataElement setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public DataElement setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public DataElement setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public DataElement setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public DataElement setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public DataElement setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public DataElement setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public DataElement setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public DataElement setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public DataElement setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<DataElementContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<DataElementContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (DataElementContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataElementContactComponent addContact() {
        DataElementContactComponent t = new DataElementContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<DataElementContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public DataElement addContact(DataElementContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<DataElementContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public DataElement addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public DataElement setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public DataElement setCopyright(String value) {
        if (Utilities.noString(value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Enumeration<DataElementStringency> getStringencyElement() {
        if (this.stringency == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.stringency");
            }
            if (Configuration.doAutoCreate()) {
                this.stringency = new Enumeration<DataElementStringency>(new DataElementStringencyEnumFactory());
            }
        }
        return this.stringency;
    }

    public boolean hasStringencyElement() {
        return this.stringency != null && !this.stringency.isEmpty();
    }

    public boolean hasStringency() {
        return this.stringency != null && !this.stringency.isEmpty();
    }

    public DataElement setStringencyElement(Enumeration<DataElementStringency> value) {
        this.stringency = value;
        return this;
    }

    public DataElementStringency getStringency() {
        return this.stringency == null ? null : (DataElementStringency)((Object)this.stringency.getValue());
    }

    public DataElement setStringency(DataElementStringency value) {
        if (value == null) {
            this.stringency = null;
        } else {
            if (this.stringency == null) {
                this.stringency = new Enumeration<DataElementStringency>(new DataElementStringencyEnumFactory());
            }
            this.stringency.setValue((Object)value);
        }
        return this;
    }

    public List<DataElementMappingComponent> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<DataElementMappingComponent>();
        }
        return this.mapping;
    }

    public boolean hasMapping() {
        if (this.mapping == null) {
            return false;
        }
        for (DataElementMappingComponent item : this.mapping) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataElementMappingComponent addMapping() {
        DataElementMappingComponent t = new DataElementMappingComponent();
        if (this.mapping == null) {
            this.mapping = new ArrayList<DataElementMappingComponent>();
        }
        this.mapping.add(t);
        return t;
    }

    public DataElement addMapping(DataElementMappingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mapping == null) {
            this.mapping = new ArrayList<DataElementMappingComponent>();
        }
        this.mapping.add(t);
        return this;
    }

    public List<ElementDefinition> getElement() {
        if (this.element == null) {
            this.element = new ArrayList<ElementDefinition>();
        }
        return this.element;
    }

    public boolean hasElement() {
        if (this.element == null) {
            return false;
        }
        for (ElementDefinition item : this.element) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinition addElement() {
        ElementDefinition t = new ElementDefinition();
        if (this.element == null) {
            this.element = new ArrayList<ElementDefinition>();
        }
        this.element.add(t);
        return t;
    }

    public DataElement addElement(ElementDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.element == null) {
            this.element = new ArrayList<ElementDefinition>();
        }
        this.element.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this data element when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this data element is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Formal identifier that is used to identify this data element when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the data element when it is referenced in a StructureDefinition, Questionnaire or instance. This is an arbitrary value managed by the definition author manually.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the data element.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "A flag to indicate that this search data element definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the data element.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date this version of the data element was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the data element  changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_NAME, "string", "The term used by humans to refer to the data element.  Should ideally be unique within the context in which the data element is expected to be used.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of data element definitions.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the definition of the data element. Copyright statements are generally legal restrictions on the use and publishing of the details of the definition of the data element.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property(SP_STRINGENCY, SP_CODE, "Identifies how precise the data element is in its definition.", 0, Integer.MAX_VALUE, this.stringency));
        childrenList.add(new Property("mapping", "", "Identifies a specification (other than a terminology) that the elements which make up the DataElement have some correspondence with.", 0, Integer.MAX_VALUE, this.mapping));
        childrenList.add(new Property("element", "ElementDefinition", "Defines the structure, type, allowed values and other constraining characteristics of the data element.", 0, Integer.MAX_VALUE, this.element));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.publisher;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.name;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.copyright;
                }
                return baseArray;
            }
            case -1572568464: {
                Base[] baseArray;
                if (this.stringency == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.stringency;
                }
                return baseArray;
            }
            case 837556430: {
                return this.mapping == null ? new Base[]{} : this.mapping.toArray(new Base[this.mapping.size()]);
            }
            case -1662836996: {
                return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((DataElementContactComponent)value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case 1522889671: {
                this.copyright = this.castToString(value);
                break;
            }
            case -1572568464: {
                this.stringency = new DataElementStringencyEnumFactory().fromType(value);
                break;
            }
            case 837556430: {
                this.getMapping().add((DataElementMappingComponent)value);
                break;
            }
            case -1662836996: {
                this.getElement().add(this.castToElementDefinition(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((DataElementContactComponent)value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals(SP_STRINGENCY)) {
            this.stringency = new DataElementStringencyEnumFactory().fromType(value);
        } else if (name.equals("mapping")) {
            this.getMapping().add((DataElementMappingComponent)value);
        } else if (name.equals("element")) {
            this.getElement().add(this.castToElementDefinition(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case 1522889671: {
                throw new FHIRException("Cannot make property copyright as it is not a complex type");
            }
            case -1572568464: {
                throw new FHIRException("Cannot make property stringency as it is not a complex type");
            }
            case 837556430: {
                return this.addMapping();
            }
            case -1662836996: {
                return this.addElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.version");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.publisher");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.date");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.name");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.copyright");
        }
        if (name.equals(SP_STRINGENCY)) {
            throw new FHIRException("Cannot call addChild on a primitive type DataElement.stringency");
        }
        if (name.equals("mapping")) {
            return this.addMapping();
        }
        if (name.equals("element")) {
            return this.addElement();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DataElement";
    }

    @Override
    public DataElement copy() {
        DataElement dst = new DataElement();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.publisher = this.publisher == null ? null : this.publisher.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<DataElementContactComponent>();
            for (DataElementContactComponent dataElementContactComponent : this.contact) {
                dst.contact.add(dataElementContactComponent.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        Enumeration<DataElementStringency> enumeration = dst.stringency = this.stringency == null ? null : this.stringency.copy();
        if (this.mapping != null) {
            dst.mapping = new ArrayList<DataElementMappingComponent>();
            for (DataElementMappingComponent dataElementMappingComponent : this.mapping) {
                dst.mapping.add(dataElementMappingComponent.copy());
            }
        }
        if (this.element != null) {
            dst.element = new ArrayList<ElementDefinition>();
            for (ElementDefinition elementDefinition : this.element) {
                dst.element.add(elementDefinition.copy());
            }
        }
        return dst;
    }

    protected DataElement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DataElement)) {
            return false;
        }
        DataElement o = (DataElement)other;
        return DataElement.compareDeep(this.url, o.url, true) && DataElement.compareDeep(this.identifier, o.identifier, true) && DataElement.compareDeep(this.version, o.version, true) && DataElement.compareDeep(this.status, o.status, true) && DataElement.compareDeep(this.experimental, o.experimental, true) && DataElement.compareDeep(this.publisher, o.publisher, true) && DataElement.compareDeep(this.date, o.date, true) && DataElement.compareDeep(this.name, o.name, true) && DataElement.compareDeep(this.contact, o.contact, true) && DataElement.compareDeep(this.useContext, o.useContext, true) && DataElement.compareDeep(this.copyright, o.copyright, true) && DataElement.compareDeep(this.stringency, o.stringency, true) && DataElement.compareDeep(this.mapping, o.mapping, true) && DataElement.compareDeep(this.element, o.element, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DataElement)) {
            return false;
        }
        DataElement o = (DataElement)other;
        return DataElement.compareValues(this.url, o.url, true) && DataElement.compareValues(this.version, o.version, true) && DataElement.compareValues(this.status, o.status, true) && DataElement.compareValues(this.experimental, o.experimental, true) && DataElement.compareValues(this.publisher, o.publisher, true) && DataElement.compareValues(this.date, o.date, true) && DataElement.compareValues(this.name, o.name, true) && DataElement.compareValues(this.copyright, o.copyright, true) && DataElement.compareValues(this.stringency, o.stringency, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.date != null && !this.date.isEmpty() || this.name != null && !this.name.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.stringency != null && !this.stringency.isEmpty() || this.mapping != null && !this.mapping.isEmpty() || this.element != null && !this.element.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DataElement;
    }

    @Block
    public static class DataElementMappingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identity", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Internal id when this mapping is used", formalDefinition="An internal id that is used to identify this mapping set when specific mappings are made on a per-element basis.")
        protected IdType identity;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies what this mapping refers to", formalDefinition="An absolute URI that identifies the specification that this mapping is expressed to.")
        protected UriType uri;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Names what this mapping refers to", formalDefinition="A name for the specification that is being mapped to.")
        protected StringType name;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Versions, Issues, Scope limitations etc.", formalDefinition="Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.")
        protected StringType comment;
        private static final long serialVersionUID = 9610265L;

        public DataElementMappingComponent() {
        }

        public DataElementMappingComponent(IdType identity) {
            this.identity = identity;
        }

        public IdType getIdentityElement() {
            if (this.identity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.identity");
                }
                if (Configuration.doAutoCreate()) {
                    this.identity = new IdType();
                }
            }
            return this.identity;
        }

        public boolean hasIdentityElement() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public boolean hasIdentity() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public DataElementMappingComponent setIdentityElement(IdType value) {
            this.identity = value;
            return this;
        }

        public String getIdentity() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public DataElementMappingComponent setIdentity(String value) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public DataElementMappingComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public DataElementMappingComponent setUri(String value) {
            if (Utilities.noString(value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DataElementMappingComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DataElementMappingComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public DataElementMappingComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public DataElementMappingComponent setComment(String value) {
            if (Utilities.noString(value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identity", "id", "An internal id that is used to identify this mapping set when specific mappings are made on a per-element basis.", 0, Integer.MAX_VALUE, this.identity));
            childrenList.add(new Property("uri", "uri", "An absolute URI that identifies the specification that this mapping is expressed to.", 0, Integer.MAX_VALUE, this.uri));
            childrenList.add(new Property(DataElement.SP_NAME, "string", "A name for the specification that is being mapped to.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("comment", "string", "Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.", 0, Integer.MAX_VALUE, this.comment));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    Base[] baseArray;
                    if (this.identity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identity;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    this.identity = this.castToId(value);
                    break;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identity")) {
                this.identity = this.castToId(value);
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else if (name.equals(DataElement.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    throw new FHIRException("Cannot make property identity as it is not a complex type");
                }
                case 116076: {
                    throw new FHIRException("Cannot make property uri as it is not a complex type");
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 950398559: {
                    throw new FHIRException("Cannot make property comment as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identity")) {
                throw new FHIRException("Cannot call addChild on a primitive type DataElement.identity");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type DataElement.uri");
            }
            if (name.equals(DataElement.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type DataElement.name");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type DataElement.comment");
            }
            return super.addChild(name);
        }

        @Override
        public DataElementMappingComponent copy() {
            DataElementMappingComponent dst = new DataElementMappingComponent();
            this.copyValues(dst);
            dst.identity = this.identity == null ? null : this.identity.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DataElementMappingComponent)) {
                return false;
            }
            DataElementMappingComponent o = (DataElementMappingComponent)other;
            return DataElementMappingComponent.compareDeep(this.identity, o.identity, true) && DataElementMappingComponent.compareDeep(this.uri, o.uri, true) && DataElementMappingComponent.compareDeep(this.name, o.name, true) && DataElementMappingComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DataElementMappingComponent)) {
                return false;
            }
            DataElementMappingComponent o = (DataElementMappingComponent)other;
            return DataElementMappingComponent.compareValues(this.identity, o.identity, true) && DataElementMappingComponent.compareValues(this.uri, o.uri, true) && DataElementMappingComponent.compareValues(this.name, o.name, true) && DataElementMappingComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identity != null && !this.identity.isEmpty() || this.uri != null && !this.uri.isEmpty() || this.name != null && !this.name.isEmpty() || this.comment != null && !this.comment.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DataElement.mapping";
        }
    }

    @Block
    public static class DataElementContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the data element.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DataElementContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DataElementContactComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public DataElementContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(DataElement.SP_NAME, "string", "The name of an individual to contact regarding the data element.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DataElement.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DataElement.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type DataElement.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public DataElementContactComponent copy() {
            DataElementContactComponent dst = new DataElementContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DataElementContactComponent)) {
                return false;
            }
            DataElementContactComponent o = (DataElementContactComponent)other;
            return DataElementContactComponent.compareDeep(this.name, o.name, true) && DataElementContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DataElementContactComponent)) {
                return false;
            }
            DataElementContactComponent o = (DataElementContactComponent)other;
            return DataElementContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DataElement.contact";
        }
    }

    public static class DataElementStringencyEnumFactory
    implements EnumFactory<DataElementStringency> {
        @Override
        public DataElementStringency fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("comparable".equals(codeString)) {
                return DataElementStringency.COMPARABLE;
            }
            if ("fully-specified".equals(codeString)) {
                return DataElementStringency.FULLYSPECIFIED;
            }
            if ("equivalent".equals(codeString)) {
                return DataElementStringency.EQUIVALENT;
            }
            if ("convertable".equals(codeString)) {
                return DataElementStringency.CONVERTABLE;
            }
            if ("scaleable".equals(codeString)) {
                return DataElementStringency.SCALEABLE;
            }
            if ("flexible".equals(codeString)) {
                return DataElementStringency.FLEXIBLE;
            }
            throw new IllegalArgumentException("Unknown DataElementStringency code '" + codeString + "'");
        }

        public Enumeration<DataElementStringency> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("comparable".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.COMPARABLE);
            }
            if ("fully-specified".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.FULLYSPECIFIED);
            }
            if ("equivalent".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.EQUIVALENT);
            }
            if ("convertable".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.CONVERTABLE);
            }
            if ("scaleable".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.SCALEABLE);
            }
            if ("flexible".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.FLEXIBLE);
            }
            throw new FHIRException("Unknown DataElementStringency code '" + codeString + "'");
        }

        @Override
        public String toCode(DataElementStringency code) {
            if (code == DataElementStringency.COMPARABLE) {
                return "comparable";
            }
            if (code == DataElementStringency.FULLYSPECIFIED) {
                return "fully-specified";
            }
            if (code == DataElementStringency.EQUIVALENT) {
                return "equivalent";
            }
            if (code == DataElementStringency.CONVERTABLE) {
                return "convertable";
            }
            if (code == DataElementStringency.SCALEABLE) {
                return "scaleable";
            }
            if (code == DataElementStringency.FLEXIBLE) {
                return "flexible";
            }
            return "?";
        }

        @Override
        public String toSystem(DataElementStringency code) {
            return code.getSystem();
        }
    }

    public static enum DataElementStringency {
        COMPARABLE,
        FULLYSPECIFIED,
        EQUIVALENT,
        CONVERTABLE,
        SCALEABLE,
        FLEXIBLE,
        NULL;


        public static DataElementStringency fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("comparable".equals(codeString)) {
                return COMPARABLE;
            }
            if ("fully-specified".equals(codeString)) {
                return FULLYSPECIFIED;
            }
            if ("equivalent".equals(codeString)) {
                return EQUIVALENT;
            }
            if ("convertable".equals(codeString)) {
                return CONVERTABLE;
            }
            if ("scaleable".equals(codeString)) {
                return SCALEABLE;
            }
            if ("flexible".equals(codeString)) {
                return FLEXIBLE;
            }
            throw new FHIRException("Unknown DataElementStringency code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPARABLE: {
                    return "comparable";
                }
                case FULLYSPECIFIED: {
                    return "fully-specified";
                }
                case EQUIVALENT: {
                    return "equivalent";
                }
                case CONVERTABLE: {
                    return "convertable";
                }
                case SCALEABLE: {
                    return "scaleable";
                }
                case FLEXIBLE: {
                    return "flexible";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPARABLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case FULLYSPECIFIED: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case EQUIVALENT: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case CONVERTABLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case SCALEABLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case FLEXIBLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPARABLE: {
                    return "The data element is sufficiently well-constrained that multiple pieces of data captured according to the constraints of the data element will be comparable (though in some cases, a degree of automated conversion/normalization may be required).";
                }
                case FULLYSPECIFIED: {
                    return "The data element is fully specified down to a single value set, single unit of measure, single data type, etc.  Multiple pieces of data associated with this data element are fully comparable.";
                }
                case EQUIVALENT: {
                    return "The data element allows multiple units of measure having equivalent meaning; e.g. \"cc\" (cubic centimeter) and \"mL\" (milliliter).";
                }
                case CONVERTABLE: {
                    return "The data element allows multiple units of measure that are convertable between each other (e.g. inches and centimeters) and/or allows data to be captured in multiple value sets for which a known mapping exists allowing conversion of meaning.";
                }
                case SCALEABLE: {
                    return "A convertable data element where unit conversions are different only by a power of 10; e.g. g, mg, kg.";
                }
                case FLEXIBLE: {
                    return "The data element is unconstrained in units, choice of data types and/or choice of vocabulary such that automated comparison of data captured using the data element is not possible.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPARABLE: {
                    return "Comparable";
                }
                case FULLYSPECIFIED: {
                    return "Fully Specified";
                }
                case EQUIVALENT: {
                    return "Equivalent";
                }
                case CONVERTABLE: {
                    return "Convertable";
                }
                case SCALEABLE: {
                    return "Scaleable";
                }
                case FLEXIBLE: {
                    return "Flexible";
                }
            }
            return "?";
        }
    }
}

