/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CompartmentDefinition", profile="http://hl7.org/fhir/Profile/CompartmentDefinition")
public class CompartmentDefinition
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Absolute URL used to reference this compartment definition", formalDefinition="An absolute URL that is used to identify this compartment definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this compartment definition is (or will be) published.")
    protected UriType url;
    @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this compartment definition", formalDefinition="A free text natural language name identifying the compartment definition.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of this compartment definition definition.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this compartment definition definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the compartment definition.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<CompartmentDefinitionContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Publication Date(/time)", formalDefinition="The date  (and optionally time) when the compartment definition definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the compartment definition changes.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the CompartmentDefinition", formalDefinition="A free text natural language description of the CompartmentDefinition and its use.")
    protected StringType description;
    @Child(name="requirements", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this compartment definition is defined", formalDefinition="The Scope and Usage that this compartment definition was created to meet.")
    protected StringType requirements;
    @Child(name="code", type={CodeType.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient | Encounter | RelatedPerson | Practitioner | Device", formalDefinition="Which compartment this definition describes.")
    protected Enumeration<CompartmentType> code;
    @Child(name="search", type={BooleanType.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the search syntax is supported", formalDefinition="Whether the search syntax is supported.")
    protected BooleanType search;
    @Child(name="resource", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="How resource is related to the compartment", formalDefinition="Information about how a resource it related to the compartment.")
    protected List<CompartmentDefinitionResourceComponent> resource;
    private static final long serialVersionUID = -1431357313L;
    @SearchParamDefinition(name="status", path="CompartmentDefinition.status", description="draft | active | retired", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="name", path="CompartmentDefinition.name", description="Informal name for this compartment definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="resource", path="CompartmentDefinition.resource.code", description="Name of resource type", type="token")
    public static final String SP_RESOURCE = "resource";
    public static final TokenClientParam RESOURCE = new TokenClientParam("resource");
    @SearchParamDefinition(name="code", path="CompartmentDefinition.code", description="Patient | Encounter | RelatedPerson | Practitioner | Device", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="CompartmentDefinition.date", description="Publication Date(/time)", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="url", path="CompartmentDefinition.url", description="Absolute URL used to reference this compartment definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");

    public CompartmentDefinition() {
    }

    public CompartmentDefinition(UriType url, StringType name, Enumeration<CompartmentType> code, BooleanType search) {
        this.url = url;
        this.name = name;
        this.code = code;
        this.search = search;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public CompartmentDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public CompartmentDefinition setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public CompartmentDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public CompartmentDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CompartmentDefinition setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public CompartmentDefinition setStatus(Enumerations.ConformanceResourceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public CompartmentDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public CompartmentDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public CompartmentDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public CompartmentDefinition setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<CompartmentDefinitionContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<CompartmentDefinitionContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (CompartmentDefinitionContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompartmentDefinitionContactComponent addContact() {
        CompartmentDefinitionContactComponent t = new CompartmentDefinitionContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<CompartmentDefinitionContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public CompartmentDefinition addContact(CompartmentDefinitionContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<CompartmentDefinitionContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public CompartmentDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public CompartmentDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public CompartmentDefinition setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public CompartmentDefinition setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public CompartmentDefinition setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public CompartmentDefinition setRequirements(String value) {
        if (Utilities.noString(value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public Enumeration<CompartmentType> getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new Enumeration<CompartmentType>(new CompartmentTypeEnumFactory());
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public CompartmentDefinition setCodeElement(Enumeration<CompartmentType> value) {
        this.code = value;
        return this;
    }

    public CompartmentType getCode() {
        return this.code == null ? null : (CompartmentType)((Object)this.code.getValue());
    }

    public CompartmentDefinition setCode(CompartmentType value) {
        if (this.code == null) {
            this.code = new Enumeration<CompartmentType>(new CompartmentTypeEnumFactory());
        }
        this.code.setValue((Object)value);
        return this;
    }

    public BooleanType getSearchElement() {
        if (this.search == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CompartmentDefinition.search");
            }
            if (Configuration.doAutoCreate()) {
                this.search = new BooleanType();
            }
        }
        return this.search;
    }

    public boolean hasSearchElement() {
        return this.search != null && !this.search.isEmpty();
    }

    public boolean hasSearch() {
        return this.search != null && !this.search.isEmpty();
    }

    public CompartmentDefinition setSearchElement(BooleanType value) {
        this.search = value;
        return this;
    }

    public boolean getSearch() {
        return this.search == null || this.search.isEmpty() ? false : (Boolean)this.search.getValue();
    }

    public CompartmentDefinition setSearch(boolean value) {
        if (this.search == null) {
            this.search = new BooleanType();
        }
        this.search.setValue((Object)value);
        return this;
    }

    public List<CompartmentDefinitionResourceComponent> getResource() {
        if (this.resource == null) {
            this.resource = new ArrayList<CompartmentDefinitionResourceComponent>();
        }
        return this.resource;
    }

    public boolean hasResource() {
        if (this.resource == null) {
            return false;
        }
        for (CompartmentDefinitionResourceComponent item : this.resource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompartmentDefinitionResourceComponent addResource() {
        CompartmentDefinitionResourceComponent t = new CompartmentDefinitionResourceComponent();
        if (this.resource == null) {
            this.resource = new ArrayList<CompartmentDefinitionResourceComponent>();
        }
        this.resource.add(t);
        return t;
    }

    public CompartmentDefinition addResource(CompartmentDefinitionResourceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.resource == null) {
            this.resource = new ArrayList<CompartmentDefinitionResourceComponent>();
        }
        this.resource.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this compartment definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this compartment definition is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the compartment definition.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of this compartment definition definition.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "A flag to indicate that this compartment definition definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property("publisher", "string", "The name of the individual or organization that published the compartment definition.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the compartment definition definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the compartment definition changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property("description", "string", "A free text natural language description of the CompartmentDefinition and its use.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("requirements", "string", "The Scope and Usage that this compartment definition was created to meet.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property(SP_CODE, SP_CODE, "Which compartment this definition describes.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("search", "boolean", "Whether the search syntax is supported.", 0, Integer.MAX_VALUE, this.search));
        childrenList.add(new Property(SP_RESOURCE, "", "Information about how a resource it related to the compartment.", 0, Integer.MAX_VALUE, this.resource));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.description;
                }
                return baseArray;
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requirements;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.code;
                }
                return baseArray;
            }
            case -906336856: {
                Base[] baseArray;
                if (this.search == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.search;
                }
                return baseArray;
            }
            case -341064690: {
                return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((CompartmentDefinitionContactComponent)value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -1619874672: {
                this.requirements = this.castToString(value);
                break;
            }
            case 3059181: {
                this.code = new CompartmentTypeEnumFactory().fromType(value);
                break;
            }
            case -906336856: {
                this.search = this.castToBoolean(value);
                break;
            }
            case -341064690: {
                this.getResource().add((CompartmentDefinitionResourceComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals("publisher")) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((CompartmentDefinitionContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals(SP_CODE)) {
            this.code = new CompartmentTypeEnumFactory().fromType(value);
        } else if (name.equals("search")) {
            this.search = this.castToBoolean(value);
        } else if (name.equals(SP_RESOURCE)) {
            this.getResource().add((CompartmentDefinitionResourceComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -1619874672: {
                throw new FHIRException("Cannot make property requirements as it is not a complex type");
            }
            case 3059181: {
                throw new FHIRException("Cannot make property code as it is not a complex type");
            }
            case -906336856: {
                throw new FHIRException("Cannot make property search as it is not a complex type");
            }
            case -341064690: {
                return this.addResource();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.url");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.experimental");
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.date");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.description");
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.requirements");
        }
        if (name.equals(SP_CODE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.code");
        }
        if (name.equals("search")) {
            throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.search");
        }
        if (name.equals(SP_RESOURCE)) {
            return this.addResource();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CompartmentDefinition";
    }

    @Override
    public CompartmentDefinition copy() {
        CompartmentDefinition dst = new CompartmentDefinition();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<CompartmentDefinitionContactComponent>();
            for (CompartmentDefinitionContactComponent compartmentDefinitionContactComponent : this.contact) {
                dst.contact.add(compartmentDefinitionContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        dst.code = this.code == null ? null : this.code.copy();
        BooleanType booleanType = dst.search = this.search == null ? null : this.search.copy();
        if (this.resource != null) {
            dst.resource = new ArrayList<CompartmentDefinitionResourceComponent>();
            for (CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : this.resource) {
                dst.resource.add(compartmentDefinitionResourceComponent.copy());
            }
        }
        return dst;
    }

    protected CompartmentDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof CompartmentDefinition)) {
            return false;
        }
        CompartmentDefinition o = (CompartmentDefinition)other;
        return CompartmentDefinition.compareDeep(this.url, o.url, true) && CompartmentDefinition.compareDeep(this.name, o.name, true) && CompartmentDefinition.compareDeep(this.status, o.status, true) && CompartmentDefinition.compareDeep(this.experimental, o.experimental, true) && CompartmentDefinition.compareDeep(this.publisher, o.publisher, true) && CompartmentDefinition.compareDeep(this.contact, o.contact, true) && CompartmentDefinition.compareDeep(this.date, o.date, true) && CompartmentDefinition.compareDeep(this.description, o.description, true) && CompartmentDefinition.compareDeep(this.requirements, o.requirements, true) && CompartmentDefinition.compareDeep(this.code, o.code, true) && CompartmentDefinition.compareDeep(this.search, o.search, true) && CompartmentDefinition.compareDeep(this.resource, o.resource, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof CompartmentDefinition)) {
            return false;
        }
        CompartmentDefinition o = (CompartmentDefinition)other;
        return CompartmentDefinition.compareValues(this.url, o.url, true) && CompartmentDefinition.compareValues(this.name, o.name, true) && CompartmentDefinition.compareValues(this.status, o.status, true) && CompartmentDefinition.compareValues(this.experimental, o.experimental, true) && CompartmentDefinition.compareValues(this.publisher, o.publisher, true) && CompartmentDefinition.compareValues(this.date, o.date, true) && CompartmentDefinition.compareValues(this.description, o.description, true) && CompartmentDefinition.compareValues(this.requirements, o.requirements, true) && CompartmentDefinition.compareValues(this.code, o.code, true) && CompartmentDefinition.compareValues(this.search, o.search, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.code != null && !this.code.isEmpty() || this.search != null && !this.search.isEmpty() || this.resource != null && !this.resource.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CompartmentDefinition;
    }

    @Block
    public static class CompartmentDefinitionResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of resource type", formalDefinition="The name of a resource supported by the server.")
        protected CodeType code;
        @Child(name="param", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Search Parameter Name, or chained params", formalDefinition="The name of a search parameter that represents the link to the compartment. More than one may be listed because a resource may be linked to a compartment more than one way.")
        protected List<StringType> param;
        @Child(name="documentation", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional doco about the resource and compartment", formalDefinition="Additional doco about the resource and compartment.")
        protected StringType documentation;
        private static final long serialVersionUID = 988080897L;

        public CompartmentDefinitionResourceComponent() {
        }

        public CompartmentDefinitionResourceComponent(CodeType code) {
            this.code = code;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompartmentDefinitionResourceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CompartmentDefinitionResourceComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public CompartmentDefinitionResourceComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public List<StringType> getParam() {
            if (this.param == null) {
                this.param = new ArrayList<StringType>();
            }
            return this.param;
        }

        public boolean hasParam() {
            if (this.param == null) {
                return false;
            }
            for (StringType item : this.param) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addParamElement() {
            StringType t = new StringType();
            if (this.param == null) {
                this.param = new ArrayList<StringType>();
            }
            this.param.add(t);
            return t;
        }

        public CompartmentDefinitionResourceComponent addParam(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.param == null) {
                this.param = new ArrayList<StringType>();
            }
            this.param.add(t);
            return this;
        }

        public boolean hasParam(String value) {
            if (this.param == null) {
                return false;
            }
            for (StringType v : this.param) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompartmentDefinitionResourceComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CompartmentDefinitionResourceComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CompartmentDefinitionResourceComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CompartmentDefinition.SP_CODE, CompartmentDefinition.SP_CODE, "The name of a resource supported by the server.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("param", "string", "The name of a search parameter that represents the link to the compartment. More than one may be listed because a resource may be linked to a compartment more than one way.", 0, Integer.MAX_VALUE, this.param));
            childrenList.add(new Property("documentation", "string", "Additional doco about the resource and compartment.", 0, Integer.MAX_VALUE, this.documentation));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 106436749: {
                    return this.param == null ? new Base[]{} : this.param.toArray(new Base[this.param.size()]);
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    break;
                }
                case 106436749: {
                    this.getParam().add(this.castToString(value));
                    break;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CompartmentDefinition.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("param")) {
                this.getParam().add(this.castToString(value));
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    throw new FHIRException("Cannot make property code as it is not a complex type");
                }
                case 106436749: {
                    throw new FHIRException("Cannot make property param as it is not a complex type");
                }
                case 1587405498: {
                    throw new FHIRException("Cannot make property documentation as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CompartmentDefinition.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.code");
            }
            if (name.equals("param")) {
                throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.param");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public CompartmentDefinitionResourceComponent copy() {
            CompartmentDefinitionResourceComponent dst = new CompartmentDefinitionResourceComponent();
            this.copyValues(dst);
            CodeType codeType = dst.code = this.code == null ? null : this.code.copy();
            if (this.param != null) {
                dst.param = new ArrayList<StringType>();
                for (StringType i : this.param) {
                    dst.param.add(i.copy());
                }
            }
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CompartmentDefinitionResourceComponent)) {
                return false;
            }
            CompartmentDefinitionResourceComponent o = (CompartmentDefinitionResourceComponent)other;
            return CompartmentDefinitionResourceComponent.compareDeep(this.code, o.code, true) && CompartmentDefinitionResourceComponent.compareDeep(this.param, o.param, true) && CompartmentDefinitionResourceComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CompartmentDefinitionResourceComponent)) {
                return false;
            }
            CompartmentDefinitionResourceComponent o = (CompartmentDefinitionResourceComponent)other;
            return CompartmentDefinitionResourceComponent.compareValues(this.code, o.code, true) && CompartmentDefinitionResourceComponent.compareValues(this.param, o.param, true) && CompartmentDefinitionResourceComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.param != null && !this.param.isEmpty() || this.documentation != null && !this.documentation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CompartmentDefinition.resource";
        }
    }

    @Block
    public static class CompartmentDefinitionContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the compartment definition.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompartmentDefinitionContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CompartmentDefinitionContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CompartmentDefinitionContactComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public CompartmentDefinitionContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CompartmentDefinition.SP_NAME, "string", "The name of an individual to contact regarding the compartment definition.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CompartmentDefinition.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CompartmentDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CompartmentDefinition.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public CompartmentDefinitionContactComponent copy() {
            CompartmentDefinitionContactComponent dst = new CompartmentDefinitionContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CompartmentDefinitionContactComponent)) {
                return false;
            }
            CompartmentDefinitionContactComponent o = (CompartmentDefinitionContactComponent)other;
            return CompartmentDefinitionContactComponent.compareDeep(this.name, o.name, true) && CompartmentDefinitionContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CompartmentDefinitionContactComponent)) {
                return false;
            }
            CompartmentDefinitionContactComponent o = (CompartmentDefinitionContactComponent)other;
            return CompartmentDefinitionContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CompartmentDefinition.contact";
        }
    }

    public static class CompartmentTypeEnumFactory
    implements EnumFactory<CompartmentType> {
        @Override
        public CompartmentType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Patient".equals(codeString)) {
                return CompartmentType.PATIENT;
            }
            if ("Encounter".equals(codeString)) {
                return CompartmentType.ENCOUNTER;
            }
            if ("RelatedPerson".equals(codeString)) {
                return CompartmentType.RELATEDPERSON;
            }
            if ("Practitioner".equals(codeString)) {
                return CompartmentType.PRACTITIONER;
            }
            if ("Device".equals(codeString)) {
                return CompartmentType.DEVICE;
            }
            throw new IllegalArgumentException("Unknown CompartmentType code '" + codeString + "'");
        }

        public Enumeration<CompartmentType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Patient".equals(codeString)) {
                return new Enumeration<CompartmentType>(this, CompartmentType.PATIENT);
            }
            if ("Encounter".equals(codeString)) {
                return new Enumeration<CompartmentType>(this, CompartmentType.ENCOUNTER);
            }
            if ("RelatedPerson".equals(codeString)) {
                return new Enumeration<CompartmentType>(this, CompartmentType.RELATEDPERSON);
            }
            if ("Practitioner".equals(codeString)) {
                return new Enumeration<CompartmentType>(this, CompartmentType.PRACTITIONER);
            }
            if ("Device".equals(codeString)) {
                return new Enumeration<CompartmentType>(this, CompartmentType.DEVICE);
            }
            throw new FHIRException("Unknown CompartmentType code '" + codeString + "'");
        }

        @Override
        public String toCode(CompartmentType code) {
            if (code == CompartmentType.PATIENT) {
                return "Patient";
            }
            if (code == CompartmentType.ENCOUNTER) {
                return "Encounter";
            }
            if (code == CompartmentType.RELATEDPERSON) {
                return "RelatedPerson";
            }
            if (code == CompartmentType.PRACTITIONER) {
                return "Practitioner";
            }
            if (code == CompartmentType.DEVICE) {
                return "Device";
            }
            return "?";
        }

        @Override
        public String toSystem(CompartmentType code) {
            return code.getSystem();
        }
    }

    public static enum CompartmentType {
        PATIENT,
        ENCOUNTER,
        RELATEDPERSON,
        PRACTITIONER,
        DEVICE,
        NULL;


        public static CompartmentType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Patient".equals(codeString)) {
                return PATIENT;
            }
            if ("Encounter".equals(codeString)) {
                return ENCOUNTER;
            }
            if ("RelatedPerson".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("Practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("Device".equals(codeString)) {
                return DEVICE;
            }
            throw new FHIRException("Unknown CompartmentType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case DEVICE: {
                    return "Device";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PATIENT: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case ENCOUNTER: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/compartment-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PATIENT: {
                    return "The compartment definition is for the patient compartment";
                }
                case ENCOUNTER: {
                    return "The compartment definition is for the encounter compartment";
                }
                case RELATEDPERSON: {
                    return "The compartment definition is for the related-person compartment";
                }
                case PRACTITIONER: {
                    return "The compartment definition is for the practitioner compartment";
                }
                case DEVICE: {
                    return "The compartment definition is for the device compartment";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case DEVICE: {
                    return "Device";
                }
            }
            return "?";
        }
    }
}

