/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.formats;

import java.io.IOException;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.XmlParserBase;
import org.hl7.fhir.dstu2016may.model.Account;
import org.hl7.fhir.dstu2016may.model.ActionDefinition;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Age;
import org.hl7.fhir.dstu2016may.model.AllergyIntolerance;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Appointment;
import org.hl7.fhir.dstu2016may.model.AppointmentResponse;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.AuditEvent;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.Basic;
import org.hl7.fhir.dstu2016may.model.Binary;
import org.hl7.fhir.dstu2016may.model.BodySite;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CarePlan;
import org.hl7.fhir.dstu2016may.model.CareTeam;
import org.hl7.fhir.dstu2016may.model.Claim;
import org.hl7.fhir.dstu2016may.model.ClaimResponse;
import org.hl7.fhir.dstu2016may.model.ClinicalImpression;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Communication;
import org.hl7.fhir.dstu2016may.model.CommunicationRequest;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.Composition;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Contract;
import org.hl7.fhir.dstu2016may.model.Count;
import org.hl7.fhir.dstu2016may.model.Coverage;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.DataRequirement;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DecisionSupportRule;
import org.hl7.fhir.dstu2016may.model.DecisionSupportServiceModule;
import org.hl7.fhir.dstu2016may.model.DetectedIssue;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DeviceComponent;
import org.hl7.fhir.dstu2016may.model.DeviceMetric;
import org.hl7.fhir.dstu2016may.model.DeviceUseRequest;
import org.hl7.fhir.dstu2016may.model.DeviceUseStatement;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DiagnosticReport;
import org.hl7.fhir.dstu2016may.model.Distance;
import org.hl7.fhir.dstu2016may.model.DocumentManifest;
import org.hl7.fhir.dstu2016may.model.DocumentReference;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.EligibilityRequest;
import org.hl7.fhir.dstu2016may.model.EligibilityResponse;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnrollmentRequest;
import org.hl7.fhir.dstu2016may.model.EnrollmentResponse;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.EpisodeOfCare;
import org.hl7.fhir.dstu2016may.model.ExpansionProfile;
import org.hl7.fhir.dstu2016may.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.ExtensionHelper;
import org.hl7.fhir.dstu2016may.model.FamilyMemberHistory;
import org.hl7.fhir.dstu2016may.model.Flag;
import org.hl7.fhir.dstu2016may.model.Goal;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.GuidanceResponse;
import org.hl7.fhir.dstu2016may.model.HealthcareService;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.ImagingExcerpt;
import org.hl7.fhir.dstu2016may.model.ImagingObjectSelection;
import org.hl7.fhir.dstu2016may.model.ImagingStudy;
import org.hl7.fhir.dstu2016may.model.Immunization;
import org.hl7.fhir.dstu2016may.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Library;
import org.hl7.fhir.dstu2016may.model.Linkage;
import org.hl7.fhir.dstu2016may.model.ListResource;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.Measure;
import org.hl7.fhir.dstu2016may.model.MeasureReport;
import org.hl7.fhir.dstu2016may.model.Media;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.MedicationAdministration;
import org.hl7.fhir.dstu2016may.model.MedicationDispense;
import org.hl7.fhir.dstu2016may.model.MedicationOrder;
import org.hl7.fhir.dstu2016may.model.MedicationStatement;
import org.hl7.fhir.dstu2016may.model.MessageHeader;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.ModuleDefinition;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.dstu2016may.model.Narrative;
import org.hl7.fhir.dstu2016may.model.NutritionOrder;
import org.hl7.fhir.dstu2016may.model.Observation;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Order;
import org.hl7.fhir.dstu2016may.model.OrderResponse;
import org.hl7.fhir.dstu2016may.model.OrderSet;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.ParameterDefinition;
import org.hl7.fhir.dstu2016may.model.Parameters;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.PaymentNotice;
import org.hl7.fhir.dstu2016may.model.PaymentReconciliation;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Person;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PractitionerRole;
import org.hl7.fhir.dstu2016may.model.Procedure;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.ProcessRequest;
import org.hl7.fhir.dstu2016may.model.ProcessResponse;
import org.hl7.fhir.dstu2016may.model.Protocol;
import org.hl7.fhir.dstu2016may.model.Provenance;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.RiskAssessment;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.Schedule;
import org.hl7.fhir.dstu2016may.model.SearchParameter;
import org.hl7.fhir.dstu2016may.model.Sequence;
import org.hl7.fhir.dstu2016may.model.Signature;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.Slot;
import org.hl7.fhir.dstu2016may.model.Specimen;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.StructureMap;
import org.hl7.fhir.dstu2016may.model.Subscription;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.SupplyDelivery;
import org.hl7.fhir.dstu2016may.model.SupplyRequest;
import org.hl7.fhir.dstu2016may.model.Task;
import org.hl7.fhir.dstu2016may.model.TestScript;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.TriggerDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.UuidType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser
extends XmlParserBase {
    public XmlParser() {
    }

    public XmlParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("extension")) {
            return false;
        }
        res.getExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected boolean parseBackboneContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("modifierExtension")) {
            return this.parseElementContent(eventType, xpp, res);
        }
        res.getModifierExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        this.parseElementAttributes(xpp, res);
        res.setValue(e.fromCode(xpp.getAttributeValue(null, "value")));
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateType res = new DateType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UriType res = new UriType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IdType res = new IdType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OidType res = new OidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StringType res = new StringType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseElementAttributes(xpp, res);
        if (xpp.getAttributeValue(null, "url") != null) {
            res.setUrl(xpp.getAttributeValue(null, "url"));
        }
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("div")) {
                res.setDiv(this.parseXhtml(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Period res = new Period();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseDateTime(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("userSelected")) {
                res.setUserSelectedElement(this.parseBoolean(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Range res = new Range();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("low")) {
                res.setLow(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("high")) {
                res.setHigh(this.parseSimpleQuantity(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("data")) {
                res.setDataElement(this.parseBase64Binary(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("size")) {
                res.setSizeElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("hash")) {
                res.setHashElement(this.parseBase64Binary(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("creation")) {
                res.setCreationElement(this.parseDateTime(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("numerator")) {
                res.setNumerator(this.parseQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("denominator")) {
                res.setDenominator(this.parseQuantity(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "author")) {
                res.setAuthor(this.parseType("author", xpp));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("origin")) {
                res.setOrigin(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriodElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lowerLimit")) {
                res.setLowerLimitElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("upperLimit")) {
                res.setUpperLimitElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dimensions")) {
                res.setDimensionsElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("data")) {
                res.setDataElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("coding")) {
                res.getCoding().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assigner")) {
                res.setAssigner(this.parseReference(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhenElement(this.parseInstant(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "who")) {
                res.setWho(this.parseType("who", xpp));
            } else if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("blob")) {
                res.setBlobElement(this.parseBase64Binary(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Age res = new Age();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Count res = new Count();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Money res = new Money();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SimpleQuantity parseSimpleQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SimpleQuantity res = new SimpleQuantity();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TriggerDefinition parseTriggerDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TriggerDefinition res = new TriggerDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("eventName")) {
                res.setEventNameElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "eventTiming")) {
                res.setEventTiming(this.parseType("eventTiming", xpp));
            } else if (eventType == 2 && xpp.getName().equals("eventData")) {
                res.setEventData(this.parseDataRequirement(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("representation")) {
                res.getRepresentation().add(this.parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.getCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("slicing")) {
                res.setSlicing(this.parseElementDefinitionElementDefinitionSlicingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("short")) {
                res.setShortElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("alias")) {
                res.getAlias().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("min")) {
                res.setMinElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("max")) {
                res.setMaxElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBase(this.parseElementDefinitionElementDefinitionBaseComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("contentReference")) {
                res.setContentReferenceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseElementDefinitionTypeRefComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "defaultValue")) {
                res.setDefaultValue(this.parseType("defaultValue", xpp));
            } else if (eventType == 2 && xpp.getName().equals("meaningWhenMissing")) {
                res.setMeaningWhenMissingElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "fixed")) {
                res.setFixed(this.parseType("fixed", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "pattern")) {
                res.setPattern(this.parseType("pattern", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "example")) {
                res.setExample(this.parseType("example", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "minValue")) {
                res.setMinValue(this.parseType("minValue", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "maxValue")) {
                res.setMaxValue(this.parseType("maxValue", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxLength")) {
                res.setMaxLengthElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.getCondition().add(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("constraint")) {
                res.getConstraint().add(this.parseElementDefinitionElementDefinitionConstraintComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
                res.setMustSupportElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("isModifier")) {
                res.setIsModifierElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("isSummary")) {
                res.setIsSummaryElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("binding")) {
                res.setBinding(this.parseElementDefinitionElementDefinitionBindingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("mapping")) {
                res.getMapping().add(this.parseElementDefinitionElementDefinitionMappingComponent(xpp, res));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("discriminator")) {
                res.getDiscriminator().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ordered")) {
                res.setOrderedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rules")) {
                res.setRulesElement(this.parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("min")) {
                res.setMinElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("max")) {
                res.setMaxElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("aggregation")) {
                res.getAggregation().add(this.parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("versioning")) {
                res.setVersioningElement(this.parseEnumeration(xpp, ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("key")) {
                res.setKeyElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("human")) {
                res.setHumanElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expression")) {
                res.setExpressionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("xpath")) {
                res.setXpathElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("strength")) {
                res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
                res.setValueSet(this.parseType("valueSet", xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identity")) {
                res.setIdentityElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("map")) {
                res.setMapElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("repeat")) {
                res.setRepeat(this.parseTimingTimingRepeatComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(XmlPullParser xpp, Timing owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "bounds")) {
                res.setBounds(this.parseType("bounds", xpp));
            } else if (eventType == 2 && xpp.getName().equals("count")) {
                res.setCountElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("countMax")) {
                res.setCountMaxElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDurationElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("durationMax")) {
                res.setDurationMaxElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("durationUnit")) {
                res.setDurationUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("frequency")) {
                res.setFrequencyElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("frequencyMax")) {
                res.setFrequencyMaxElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriodElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("periodMax")) {
                res.setPeriodMaxElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("periodUnit")) {
                res.setPeriodUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhenElement(this.parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("offset")) {
                res.setOffsetElement(this.parseUnsignedInt(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleMetadata parseModuleMetadata(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleMetadata res = new ModuleMetadata();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ModuleMetadata.ModuleMetadataType.NULL, new ModuleMetadata.ModuleMetadataTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ModuleMetadata.ModuleMetadataStatus.NULL, new ModuleMetadata.ModuleMetadataStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("purpose")) {
                res.setPurposeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("usage")) {
                res.setUsageElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publicationDate")) {
                res.setPublicationDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
                res.setLastReviewDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
                res.setEffectivePeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.getCoverage().add(this.parseModuleMetadataModuleMetadataCoverageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("topic")) {
                res.getTopic().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contributor")) {
                res.getContributor().add(this.parseModuleMetadataModuleMetadataContributorComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseModuleMetadataModuleMetadataContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatedResource")) {
                res.getRelatedResource().add(this.parseModuleMetadataModuleMetadataRelatedResourceComponent(xpp, res));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleMetadata.ModuleMetadataCoverageComponent parseModuleMetadataModuleMetadataCoverageComponent(XmlPullParser xpp, ModuleMetadata owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataCoverageComponent res = new ModuleMetadata.ModuleMetadataCoverageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("focus")) {
                res.setFocus(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValue(this.parseCodeableConcept(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleMetadata.ModuleMetadataContributorComponent parseModuleMetadataModuleMetadataContributorComponent(XmlPullParser xpp, ModuleMetadata owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataContributorComponent res = new ModuleMetadata.ModuleMetadataContributorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ModuleMetadata.ModuleMetadataContributorType.NULL, new ModuleMetadata.ModuleMetadataContributorTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseModuleMetadataModuleMetadataContributorContactComponent(xpp, owner));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleMetadata.ModuleMetadataContributorContactComponent parseModuleMetadataModuleMetadataContributorContactComponent(XmlPullParser xpp, ModuleMetadata owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataContributorContactComponent res = new ModuleMetadata.ModuleMetadataContributorContactComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleMetadata.ModuleMetadataContactComponent parseModuleMetadataModuleMetadataContactComponent(XmlPullParser xpp, ModuleMetadata owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataContactComponent res = new ModuleMetadata.ModuleMetadataContactComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleMetadata.ModuleMetadataRelatedResourceComponent parseModuleMetadataModuleMetadataRelatedResourceComponent(XmlPullParser xpp, ModuleMetadata owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataRelatedResourceComponent res = new ModuleMetadata.ModuleMetadataRelatedResourceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ModuleMetadata.ModuleMetadataResourceType.NULL, new ModuleMetadata.ModuleMetadataResourceTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("document")) {
                res.setDocument(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ActionDefinition parseActionDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ActionDefinition res = new ActionDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actionIdentifier")) {
                res.setActionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("textEquivalent")) {
                res.setTextEquivalentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingEvidence")) {
                res.getSupportingEvidence().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.getDocumentation().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatedAction")) {
                res.setRelatedAction(this.parseActionDefinitionActionDefinitionRelatedActionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("participantType")) {
                res.getParticipantType().add(this.parseEnumeration(xpp, ActionDefinition.ParticipantType.NULL, new ActionDefinition.ParticipantTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ActionDefinition.ActionType.NULL, new ActionDefinition.ActionTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("behavior")) {
                res.getBehavior().add(this.parseActionDefinitionActionDefinitionBehaviorComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("customization")) {
                res.getCustomization().add(this.parseActionDefinitionActionDefinitionCustomizationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseActionDefinition(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ActionDefinition.ActionDefinitionRelatedActionComponent parseActionDefinitionActionDefinitionRelatedActionComponent(XmlPullParser xpp, ActionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ActionDefinition.ActionDefinitionRelatedActionComponent res = new ActionDefinition.ActionDefinitionRelatedActionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actionIdentifier")) {
                res.setActionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationshipElement(this.parseEnumeration(xpp, ActionDefinition.ActionRelationshipType.NULL, new ActionDefinition.ActionRelationshipTypeEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "offset")) {
                res.setOffset(this.parseType("offset", xpp));
            } else if (eventType == 2 && xpp.getName().equals("anchor")) {
                res.setAnchorElement(this.parseEnumeration(xpp, ActionDefinition.ActionRelationshipAnchor.NULL, new ActionDefinition.ActionRelationshipAnchorEnumFactory()));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ActionDefinition.ActionDefinitionBehaviorComponent parseActionDefinitionActionDefinitionBehaviorComponent(XmlPullParser xpp, ActionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ActionDefinition.ActionDefinitionBehaviorComponent res = new ActionDefinition.ActionDefinitionBehaviorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValue(this.parseCoding(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ActionDefinition.ActionDefinitionCustomizationComponent parseActionDefinitionActionDefinitionCustomizationComponent(XmlPullParser xpp, ActionDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ActionDefinition.ActionDefinitionCustomizationComponent res = new ActionDefinition.ActionDefinitionCustomizationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expression")) {
                res.setExpressionElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Address res = new Address();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("line")) {
                res.getLine().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("city")) {
                res.setCityElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("district")) {
                res.setDistrictElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("state")) {
                res.setStateElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("postalCode")) {
                res.setPostalCodeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("country")) {
                res.setCountryElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("family")) {
                res.getFamily().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("given")) {
                res.getGiven().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prefix")) {
                res.getPrefix().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("suffix")) {
                res.getSuffix().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataRequirement parseDataRequirement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement res = new DataRequirement();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
                res.getMustSupport().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeFilter")) {
                res.getCodeFilter().add(this.parseDataRequirementDataRequirementCodeFilterComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("dateFilter")) {
                res.getDateFilter().add(this.parseDataRequirementDataRequirementDateFilterComponent(xpp, res));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
                res.setValueSet(this.parseType("valueSet", xpp));
            } else if (eventType == 2 && xpp.getName().equals("valueCode")) {
                res.getValueCode().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("valueCoding")) {
                res.getValueCoding().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("valueCodeableConcept")) {
                res.getValueCodeableConcept().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("versionId")) {
                res.setVersionIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastUpdated")) {
                res.setLastUpdatedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("security")) {
                res.getSecurity().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("tag")) {
                res.getTag().add(this.parseCoding(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ParameterDefinition parseParameterDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("min")) {
                res.setMinElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("max")) {
                res.setMaxElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("rank")) {
                res.setRankElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Parameters parseParameters(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters res = new Parameters();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseParametersParametersParameterComponent(xpp, res));
            } else if (!this.parseResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(XmlPullParser xpp, Parameters owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseResourceContained(xpp));
            } else if (eventType == 2 && xpp.getName().equals("part")) {
                res.getPart().add(this.parseParametersParametersParameterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected void parseResourceAttributes(XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (!this.comments.isEmpty()) {
            res.getFormatCommentsPre().addAll(this.comments);
            this.comments.clear();
        }
    }

    protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("meta")) {
            res.setMeta(this.parseMeta(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else {
            return false;
        }
        return true;
    }

    protected void parseDomainResourceAttributes(XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        this.parseResourceAttributes(xpp, res);
    }

    protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contained")) {
            res.getContained().add(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extension")) {
            res.getExtension().add(this.parseExtension(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifierExtension")) {
            res.getModifierExtension().add(this.parseExtension(xpp));
        } else {
            return this.parseResourceContent(eventType, xpp, res);
        }
        return true;
    }

    protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account res = new Account();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("activePeriod")) {
                res.setActivePeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("currency")) {
                res.setCurrency(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("balance")) {
                res.setBalance(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coveragePeriod")) {
                res.setCoveragePeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("owner")) {
                res.setOwner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceStatus.NULL, new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("criticality")) {
                res.setCriticalityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("substance")) {
                res.setSubstance(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
                res.setRecordedDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recorder")) {
                res.setRecorder(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reporter")) {
                res.setReporter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("onset")) {
                res.setOnsetElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastOccurence")) {
                res.setLastOccurenceElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reaction")) {
                res.getReaction().add(this.parseAllergyIntoleranceAllergyIntoleranceReactionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(XmlPullParser xpp, AllergyIntolerance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("substance")) {
                res.setSubstance(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("certainty")) {
                res.setCertaintyElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCertainty.NULL, new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("manifestation")) {
                res.getManifestation().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("onset")) {
                res.setOnsetElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("exposureRoute")) {
                res.setExposureRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
                res.setServiceCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
                res.getServiceType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("appointmentType")) {
                res.setAppointmentType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("minutesDuration")) {
                res.setMinutesDurationElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("slot")) {
                res.getSlot().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseAppointmentAppointmentParticipantComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(XmlPullParser xpp, Appointment owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseEnumeration(xpp, Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("appointment")) {
                res.setAppointment(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participantType")) {
                res.getParticipantType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participantStatus")) {
                res.setParticipantStatusElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subtype")) {
                res.getSubtype().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.setActionElement(this.parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("recorded")) {
                res.setRecordedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("outcomeDesc")) {
                res.setOutcomeDescElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("purposeOfEvent")) {
                res.getPurposeOfEvent().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("agent")) {
                res.getAgent().add(this.parseAuditEventAuditEventAgentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseAuditEventAuditEventSourceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("entity")) {
                res.getEntity().add(this.parseAuditEventAuditEventEntityComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("userId")) {
                res.setUserId(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("altId")) {
                res.setAltIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestor")) {
                res.setRequestorElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("policy")) {
                res.getPolicy().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("media")) {
                res.setMedia(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("network")) {
                res.setNetwork(this.parseAuditEventAuditEventAgentNetworkComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("purposeOfUse")) {
                res.getPurposeOfUse().add(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddressElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventParticipantNetworkType.NULL, new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("site")) {
                res.setSiteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lifecycle")) {
                res.setLifecycle(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
                res.getSecurityLabel().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("query")) {
                res.setQueryElement(this.parseBase64Binary(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseAuditEventAuditEventEntityDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseBase64Binary(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.setContentElement(this.parseBase64Binary(xpp));
            } else if (!this.parseResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected BodySite parseBodySite(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BodySite res = new BodySite();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.getModifier().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("image")) {
                res.getImage().add(this.parseAttachment(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("total")) {
                res.setTotalElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseBundleBundleLinkComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("entry")) {
                res.getEntry().add(this.parseBundleBundleEntryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("signature")) {
                res.setSignature(this.parseSignature(xpp));
            } else if (!this.parseResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("relation")) {
                res.setRelationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseBundleBundleLinkComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("fullUrl")) {
                res.setFullUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseResourceContained(xpp));
            } else if (eventType == 2 && xpp.getName().equals("search")) {
                res.setSearch(this.parseBundleBundleEntrySearchComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseBundleBundleEntryRequestComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseBundleBundleEntryResponseComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("score")) {
                res.setScoreElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethodElement(this.parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifNoneMatch")) {
                res.setIfNoneMatchElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifModifiedSince")) {
                res.setIfModifiedSinceElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifMatch")) {
                res.setIfMatchElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifNoneExist")) {
                res.setIfNoneExistElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocationElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("etag")) {
                res.setEtagElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastModified")) {
                res.setLastModifiedElement(this.parseInstant(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.setContext(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modified")) {
                res.setModifiedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.getCategory().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("addresses")) {
                res.getAddresses().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("support")) {
                res.getSupport().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatedPlan")) {
                res.getRelatedPlan().add(this.parseCarePlanCarePlanRelatedPlanComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseCarePlanCarePlanParticipantComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("goal")) {
                res.getGoal().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("activity")) {
                res.getActivity().add(this.parseCarePlanCarePlanActivityComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanRelatedPlanComponent parseCarePlanCarePlanRelatedPlanComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanRelatedPlanComponent res = new CarePlan.CarePlanRelatedPlanComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, CarePlan.CarePlanRelationship.NULL, new CarePlan.CarePlanRelationshipEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("plan")) {
                res.setPlan(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanParticipantComponent parseCarePlanCarePlanParticipantComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanParticipantComponent res = new CarePlan.CarePlanParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("member")) {
                res.setMember(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actionResulting")) {
                res.getActionResulting().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("progress")) {
                res.getProgress().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.setDetail(this.parseCarePlanCarePlanActivityDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
                res.getReasonCode().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
                res.getReasonReference().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("goal")) {
                res.getGoal().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
                res.setStatusReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prohibited")) {
                res.setProhibitedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
                res.setScheduled(this.parseType("scheduled", xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.getPerformer().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
                res.setProduct(this.parseType("product", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dailyAmount")) {
                res.setDailyAmount(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CareTeam parseCareTeam(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam res = new CareTeam();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseCareTeamCareTeamParticipantComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(XmlPullParser xpp, CareTeam owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("member")) {
                res.setMember(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Claim.ClaimType.NULL, new Claim.ClaimTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("subType")) {
                res.getSubType().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
                res.setBillablePeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "provider")) {
                res.setProvider(this.parseType("provider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, Claim.Use.NULL, new Claim.UseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
                res.setFundsReserve(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "enterer")) {
                res.setEnterer(this.parseType("enterer", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "facility")) {
                res.setFacility(this.parseType("facility", xpp));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseClaimRelatedClaimsComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "prescription")) {
                res.setPrescription(this.parseType("prescription", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "originalPrescription")) {
                res.setOriginalPrescription(this.parseType("originalPrescription", xpp));
            } else if (eventType == 2 && xpp.getName().equals("payee")) {
                res.setPayee(this.parseClaimPayeeComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "referral")) {
                res.setReferral(this.parseType("referral", xpp));
            } else if (eventType == 2 && xpp.getName().equals("occurrenceCode")) {
                res.getOccurrenceCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("occurenceSpanCode")) {
                res.getOccurenceSpanCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("valueCode")) {
                res.getValueCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
                res.getDiagnosis().add(this.parseClaimDiagnosisComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("procedure")) {
                res.getProcedure().add(this.parseClaimProcedureComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("specialCondition")) {
                res.getSpecialCondition().add(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "patient")) {
                res.setPatient(this.parseType("patient", xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.getCoverage().add(this.parseClaimCoverageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("accidentDate")) {
                res.setAccidentDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accidentType")) {
                res.setAccidentType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "accidentLocation")) {
                res.setAccidentLocation(this.parseType("accidentLocation", xpp));
            } else if (eventType == 2 && xpp.getName().equals("interventionException")) {
                res.getInterventionException().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("onset")) {
                res.getOnset().add(this.parseClaimOnsetComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("employmentImpacted")) {
                res.setEmploymentImpacted(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
                res.setHospitalization(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseClaimItemsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("total")) {
                res.setTotal(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additionalMaterial")) {
                res.getAdditionalMaterial().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("missingTeeth")) {
                res.getMissingTeeth().add(this.parseClaimMissingTeethComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.RelatedClaimsComponent parseClaimRelatedClaimsComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.RelatedClaimsComponent res = new Claim.RelatedClaimsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "claim")) {
                res.setClaim(this.parseType("claim", xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseIdentifier(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "party")) {
                res.setParty(this.parseType("party", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
                res.setDiagnosis(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
                res.setProcedure(this.parseType("procedure", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.CoverageComponent parseClaimCoverageComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.CoverageComponent res = new Claim.CoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("focal")) {
                res.setFocalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "coverage")) {
                res.setCoverage(this.parseType("coverage", xpp));
            } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
                res.setBusinessArrangementElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
                res.getPreAuthRef().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
                res.setClaimResponse(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.OnsetComponent parseClaimOnsetComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.OnsetComponent res = new Claim.OnsetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "time")) {
                res.setTime(this.parseType("time", xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.ItemsComponent parseClaimItemsComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ItemsComponent res = new Claim.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "provider")) {
                res.setProvider(this.parseType("provider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "supervisor")) {
                res.setSupervisor(this.parseType("supervisor", xpp));
            } else if (eventType == 2 && xpp.getName().equals("providerQualification")) {
                res.setProviderQualification(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosisLinkId")) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceModifier")) {
                res.getServiceModifier().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.getModifier().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programCode")) {
                res.getProgramCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
                res.setServiced(this.parseType("serviced", xpp));
            } else if (eventType == 2 && xpp.getName().equals("place")) {
                res.setPlace(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.getUdi().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subSite")) {
                res.getSubSite().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseClaimDetailComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("prosthesis")) {
                res.setProsthesis(this.parseClaimProsthesisComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programCode")) {
                res.getProgramCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.getUdi().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
                res.getSubDetail().add(this.parseClaimSubDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programCode")) {
                res.getProgramCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.getUdi().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.ProsthesisComponent parseClaimProsthesisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ProsthesisComponent res = new Claim.ProsthesisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("initial")) {
                res.setInitialElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priorDate")) {
                res.setPriorDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priorMaterial")) {
                res.setPriorMaterial(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.MissingTeethComponent parseClaimMissingTeethComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.MissingTeethComponent res = new Claim.MissingTeethComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("tooth")) {
                res.setTooth(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extractionDate")) {
                res.setExtractionDateElement(this.parseDate(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "request")) {
                res.setRequest(this.parseType("request", xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestProvider")) {
                res.setRequestProvider(this.parseType("requestProvider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestOrganization")) {
                res.setRequestOrganization(this.parseType("requestOrganization", xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payeeType")) {
                res.setPayeeType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseClaimResponseItemsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("addItem")) {
                res.getAddItem().add(this.parseClaimResponseAddedItemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("error")) {
                res.getError().add(this.parseClaimResponseErrorsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("totalCost")) {
                res.setTotalCost(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unallocDeductable")) {
                res.setUnallocDeductable(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("totalBenefit")) {
                res.setTotalBenefit(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAdjustment")) {
                res.setPaymentAdjustment(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAdjustmentReason")) {
                res.setPaymentAdjustmentReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentDate")) {
                res.setPaymentDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAmount")) {
                res.setPaymentAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentRef")) {
                res.setPaymentRef(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reserved")) {
                res.setReserved(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseClaimResponseNotesComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.getCoverage().add(this.parseClaimResponseCoverageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ItemsComponent parseClaimResponseItemsComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemsComponent res = new ClaimResponse.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
                res.getNoteNumber().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseItemAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseClaimResponseItemDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ItemAdjudicationComponent parseClaimResponseItemAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemAdjudicationComponent res = new ClaimResponse.ItemAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseDetailAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
                res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.DetailAdjudicationComponent parseClaimResponseDetailAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.DetailAdjudicationComponent res = new ClaimResponse.DetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseSubdetailAdjudicationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.SubdetailAdjudicationComponent parseClaimResponseSubdetailAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.SubdetailAdjudicationComponent res = new ClaimResponse.SubdetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.getSequenceLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fee")) {
                res.setFee(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("noteNumberLinkId")) {
                res.getNoteNumberLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseClaimResponseAddedItemsDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemAdjudicationComponent parseClaimResponseAddedItemAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemAdjudicationComponent res = new ClaimResponse.AddedItemAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fee")) {
                res.setFee(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemDetailAdjudicationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemDetailAdjudicationComponent parseClaimResponseAddedItemDetailAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailAdjudicationComponent res = new ClaimResponse.AddedItemDetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ErrorsComponent parseClaimResponseErrorsComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ErrorsComponent res = new ClaimResponse.ErrorsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detailSequenceLinkId")) {
                res.setDetailSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subdetailSequenceLinkId")) {
                res.setSubdetailSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.NotesComponent parseClaimResponseNotesComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.NotesComponent res = new ClaimResponse.NotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("number")) {
                res.setNumberElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.CoverageComponent parseClaimResponseCoverageComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.CoverageComponent res = new ClaimResponse.CoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("focal")) {
                res.setFocalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "coverage")) {
                res.setCoverage(this.parseType("coverage", xpp));
            } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
                res.setBusinessArrangementElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
                res.getPreAuthRef().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
                res.setClaimResponse(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assessor")) {
                res.setAssessor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("previous")) {
                res.setPrevious(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("problem")) {
                res.getProblem().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "trigger")) {
                res.setTrigger(this.parseType("trigger", xpp));
            } else if (eventType == 2 && xpp.getName().equals("investigations")) {
                res.getInvestigations().add(this.parseClinicalImpressionClinicalImpressionInvestigationsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("protocol")) {
                res.setProtocolElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("summary")) {
                res.setSummaryElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("finding")) {
                res.getFinding().add(this.parseClinicalImpressionClinicalImpressionFindingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("resolved")) {
                res.getResolved().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruledOut")) {
                res.getRuledOut().add(this.parseClinicalImpressionClinicalImpressionRuledOutComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("prognosis")) {
                res.setPrognosisElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("plan")) {
                res.getPlan().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionInvestigationsComponent parseClinicalImpressionClinicalImpressionInvestigationsComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionInvestigationsComponent res = new ClinicalImpression.ClinicalImpressionInvestigationsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("cause")) {
                res.setCauseElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionRuledOutComponent parseClinicalImpressionClinicalImpressionRuledOutComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionRuledOutComponent res = new ClinicalImpression.ClinicalImpressionRuledOutComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReasonElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeSystem parseCodeSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem res = new CodeSystem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseCodeSystemCodeSystemContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("caseSensitive")) {
                res.setCaseSensitiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
                res.setValueSetElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("compositional")) {
                res.setCompositionalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("versionNeeded")) {
                res.setVersionNeededElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.setContentElement(this.parseEnumeration(xpp, CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("count")) {
                res.setCountElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("filter")) {
                res.getFilter().add(this.parseCodeSystemCodeSystemFilterComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("property")) {
                res.getProperty().add(this.parseCodeSystemCodeSystemPropertyComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeSystem.CodeSystemContactComponent parseCodeSystemCodeSystemContactComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.CodeSystemContactComponent res = new CodeSystem.CodeSystemContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operator")) {
                res.getOperator().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeSystem.CodeSystemPropertyComponent parseCodeSystemCodeSystemPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.CodeSystemPropertyComponent res = new CodeSystem.CodeSystemPropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("designation")) {
                res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("property")) {
                res.getProperty().add(this.parseCodeSystemConceptDefinitionPropertyComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUse(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeSystem.ConceptDefinitionPropertyComponent parseCodeSystemConceptDefinitionPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionPropertyComponent res = new CodeSystem.ConceptDefinitionPropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sender")) {
                res.setSender(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payload")) {
                res.getPayload().add(this.parseCommunicationCommunicationPayloadComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("medium")) {
                res.getMedium().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sent")) {
                res.setSentElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("received")) {
                res.setReceivedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestDetail")) {
                res.setRequestDetail(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(XmlPullParser xpp, Communication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sender")) {
                res.setSender(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payload")) {
                res.getPayload().add(this.parseCommunicationRequestCommunicationRequestPayloadComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("medium")) {
                res.getMedium().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requester")) {
                res.setRequester(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
                res.setScheduled(this.parseType("scheduled", xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestedOn")) {
                res.setRequestedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CompartmentDefinition parseCompartmentDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseCompartmentDefinitionCompartmentDefinitionContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("search")) {
                res.setSearchElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.getResource().add(this.parseCompartmentDefinitionCompartmentDefinitionResourceComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CompartmentDefinition.CompartmentDefinitionContactComponent parseCompartmentDefinitionCompartmentDefinitionContactComponent(XmlPullParser xpp, CompartmentDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionContactComponent res = new CompartmentDefinition.CompartmentDefinitionContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(XmlPullParser xpp, CompartmentDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("param")) {
                res.getParam().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("class")) {
                res.setClass_(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("confidentiality")) {
                res.setConfidentialityElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("attester")) {
                res.getAttester().add(this.parseCompositionCompositionAttesterComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("custodian")) {
                res.setCustodian(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseCompositionCompositionEventComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("section")) {
                res.getSection().add(this.parseCompositionSectionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.getMode().add(this.parseEnumeration(xpp, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("party")) {
                res.setParty(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.getCode().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setText(this.parseNarrative(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
                res.setOrderedBy(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("entry")) {
                res.getEntry().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
                res.setEmptyReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("section")) {
                res.getSection().add(this.parseCompositionSectionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseConceptMapConceptMapContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
                res.setSource(this.parseType("source", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseConceptMapSourceElementComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.ConceptMapContactComponent parseConceptMapConceptMapContactComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapContactComponent res = new ConceptMap.ConceptMapContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseConceptMapTargetElementComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("equivalence")) {
                res.setEquivalenceElement(this.parseEnumeration(xpp, Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
                res.getDependsOn().add(this.parseConceptMapOtherElementComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("product")) {
                res.getProduct().add(this.parseConceptMapOtherElementComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("element")) {
                res.setElementElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("asserter")) {
                res.setAsserter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateRecorded")) {
                res.setDateRecordedElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
                res.setClinicalStatusElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
                res.setVerificationStatusElement(this.parseEnumeration(xpp, Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverity(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
                res.setOnset(this.parseType("onset", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "abatement")) {
                res.setAbatement(this.parseType("abatement", xpp));
            } else if (eventType == 2 && xpp.getName().equals("stage")) {
                res.setStage(this.parseConditionConditionStageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("evidence")) {
                res.getEvidence().add(this.parseConditionConditionEvidenceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.getBodySite().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.setNotesElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Condition.ConditionStageComponent parseConditionConditionStageComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("summary")) {
                res.setSummary(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assessment")) {
                res.getAssessment().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance parseConformance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance res = new Conformance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseConformanceConformanceContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, Conformance.ConformanceStatementKind.NULL, new Conformance.ConformanceStatementKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("software")) {
                res.setSoftware(this.parseConformanceConformanceSoftwareComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("implementation")) {
                res.setImplementation(this.parseConformanceConformanceImplementationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
                res.setFhirVersionElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("acceptUnknown")) {
                res.setAcceptUnknownElement(this.parseEnumeration(xpp, Conformance.UnknownContentCode.NULL, new Conformance.UnknownContentCodeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("format")) {
                res.getFormat().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rest")) {
                res.getRest().add(this.parseConformanceConformanceRestComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("messaging")) {
                res.getMessaging().add(this.parseConformanceConformanceMessagingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("document")) {
                res.getDocument().add(this.parseConformanceConformanceDocumentComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceContactComponent parseConformanceConformanceContactComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceContactComponent res = new Conformance.ConformanceContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceSoftwareComponent parseConformanceConformanceSoftwareComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceSoftwareComponent res = new Conformance.ConformanceSoftwareComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("releaseDate")) {
                res.setReleaseDateElement(this.parseDateTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceImplementationComponent parseConformanceConformanceImplementationComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceImplementationComponent res = new Conformance.ConformanceImplementationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestComponent parseConformanceConformanceRestComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestComponent res = new Conformance.ConformanceRestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Conformance.RestfulConformanceMode.NULL, new Conformance.RestfulConformanceModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("security")) {
                res.setSecurity(this.parseConformanceConformanceRestSecurityComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.getResource().add(this.parseConformanceConformanceRestResourceComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("interaction")) {
                res.getInteraction().add(this.parseConformanceSystemInteractionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("transactionMode")) {
                res.setTransactionModeElement(this.parseEnumeration(xpp, Conformance.TransactionMode.NULL, new Conformance.TransactionModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("operation")) {
                res.getOperation().add(this.parseConformanceConformanceRestOperationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("compartment")) {
                res.getCompartment().add(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestSecurityComponent parseConformanceConformanceRestSecurityComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestSecurityComponent res = new Conformance.ConformanceRestSecurityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("cors")) {
                res.setCorsElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.getService().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("certificate")) {
                res.getCertificate().add(this.parseConformanceConformanceRestSecurityCertificateComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestSecurityCertificateComponent parseConformanceConformanceRestSecurityCertificateComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestSecurityCertificateComponent res = new Conformance.ConformanceRestSecurityCertificateComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("blob")) {
                res.setBlobElement(this.parseBase64Binary(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestResourceComponent parseConformanceConformanceRestResourceComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestResourceComponent res = new Conformance.ConformanceRestResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("interaction")) {
                res.getInteraction().add(this.parseConformanceResourceInteractionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("versioning")) {
                res.setVersioningElement(this.parseEnumeration(xpp, Conformance.ResourceVersionPolicy.NULL, new Conformance.ResourceVersionPolicyEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("readHistory")) {
                res.setReadHistoryElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("updateCreate")) {
                res.setUpdateCreateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conditionalCreate")) {
                res.setConditionalCreateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conditionalUpdate")) {
                res.setConditionalUpdateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conditionalDelete")) {
                res.setConditionalDeleteElement(this.parseEnumeration(xpp, Conformance.ConditionalDeleteStatus.NULL, new Conformance.ConditionalDeleteStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("searchInclude")) {
                res.getSearchInclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("searchRevInclude")) {
                res.getSearchRevInclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ResourceInteractionComponent parseConformanceResourceInteractionComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ResourceInteractionComponent res = new Conformance.ResourceInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, Conformance.TypeRestfulInteraction.NULL, new Conformance.TypeRestfulInteractionEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestResourceSearchParamComponent parseConformanceConformanceRestResourceSearchParamComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestResourceSearchParamComponent res = new Conformance.ConformanceRestResourceSearchParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.getModifier().add(this.parseEnumeration(xpp, Conformance.SearchModifierCode.NULL, new Conformance.SearchModifierCodeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("chain")) {
                res.getChain().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.SystemInteractionComponent parseConformanceSystemInteractionComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.SystemInteractionComponent res = new Conformance.SystemInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, Conformance.SystemRestfulInteraction.NULL, new Conformance.SystemRestfulInteractionEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestOperationComponent parseConformanceConformanceRestOperationComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestOperationComponent res = new Conformance.ConformanceRestOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinition(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceMessagingComponent parseConformanceConformanceMessagingComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceMessagingComponent res = new Conformance.ConformanceMessagingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.getEndpoint().add(this.parseConformanceConformanceMessagingEndpointComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("reliableCache")) {
                res.setReliableCacheElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseConformanceConformanceMessagingEventComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceMessagingEndpointComponent parseConformanceConformanceMessagingEndpointComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEndpointComponent res = new Conformance.ConformanceMessagingEndpointComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("protocol")) {
                res.setProtocol(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddressElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceMessagingEventComponent parseConformanceConformanceMessagingEventComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEventComponent res = new Conformance.ConformanceMessagingEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, Conformance.MessageSignificanceCategory.NULL, new Conformance.MessageSignificanceCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Conformance.ConformanceEventMode.NULL, new Conformance.ConformanceEventModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("focus")) {
                res.setFocusElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceDocumentComponent parseConformanceConformanceDocumentComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceDocumentComponent res = new Conformance.ConformanceDocumentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Conformance.DocumentMode.NULL, new Conformance.DocumentModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("applies")) {
                res.setApplies(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.getSubject().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("topic")) {
                res.getTopic().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authority")) {
                res.getAuthority().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("domain")) {
                res.getDomain().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subType")) {
                res.getSubType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actionReason")) {
                res.getActionReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("agent")) {
                res.getAgent().add(this.parseContractAgentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("signer")) {
                res.getSigner().add(this.parseContractSignatoryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
                res.getValuedItem().add(this.parseContractValuedItemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("term")) {
                res.getTerm().add(this.parseContractTermComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "binding")) {
                res.setBinding(this.parseType("binding", xpp));
            } else if (eventType == 2 && xpp.getName().equals("friendly")) {
                res.getFriendly().add(this.parseContractFriendlyLanguageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("legal")) {
                res.getLegal().add(this.parseContractLegalLanguageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.getRule().add(this.parseContractComputableLanguageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.AgentComponent parseContractAgentComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.AgentComponent res = new Contract.AgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("party")) {
                res.setParty(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("signature")) {
                res.getSignature().add(this.parseSignature(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
                res.setEntity(this.parseType("entity", xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
                res.setEffectiveTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("applies")) {
                res.setApplies(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subType")) {
                res.setSubType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("topic")) {
                res.getTopic().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actionReason")) {
                res.getActionReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("agent")) {
                res.getAgent().add(this.parseContractTermAgentComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
                res.getValuedItem().add(this.parseContractTermValuedItemComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseContractTermComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.TermAgentComponent parseContractTermAgentComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermAgentComponent res = new Contract.TermAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
                res.setEntity(this.parseType("entity", xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
                res.setEffectiveTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "issuer")) {
                res.setIssuer(this.parseType("issuer", xpp));
            } else if (eventType == 2 && xpp.getName().equals("bin")) {
                res.setBinElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "planholder")) {
                res.setPlanholder(this.parseType("planholder", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "beneficiary")) {
                res.setBeneficiary(this.parseType("beneficiary", xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.setGroupElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("plan")) {
                res.setPlanElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subPlan")) {
                res.setSubPlanElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dependent")) {
                res.setDependentElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("exception")) {
                res.getException().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("school")) {
                res.setSchoolElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("network")) {
                res.setNetworkElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contract")) {
                res.getContract().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataElement parseDataElement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement res = new DataElement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseDataElementDataElementContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("stringency")) {
                res.setStringencyElement(this.parseEnumeration(xpp, DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("mapping")) {
                res.getMapping().add(this.parseDataElementDataElementMappingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseElementDefinition(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataElement.DataElementContactComponent parseDataElementDataElementContactComponent(XmlPullParser xpp, DataElement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement.DataElementContactComponent res = new DataElement.DataElementContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(XmlPullParser xpp, DataElement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identity")) {
                res.setIdentityElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uri")) {
                res.setUriElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DecisionSupportRule parseDecisionSupportRule(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DecisionSupportRule res = new DecisionSupportRule();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("moduleMetadata")) {
                res.setModuleMetadata(this.parseModuleMetadata(xpp));
            } else if (eventType == 2 && xpp.getName().equals("library")) {
                res.getLibrary().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("trigger")) {
                res.getTrigger().add(this.parseTriggerDefinition(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.setConditionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseActionDefinition(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DecisionSupportServiceModule parseDecisionSupportServiceModule(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DecisionSupportServiceModule res = new DecisionSupportServiceModule();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("moduleMetadata")) {
                res.setModuleMetadata(this.parseModuleMetadata(xpp));
            } else if (eventType == 2 && xpp.getName().equals("trigger")) {
                res.getTrigger().add(this.parseTriggerDefinition(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseParameterDefinition(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
                res.getDataRequirement().add(this.parseDataRequirement(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("implicated")) {
                res.getImplicated().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.setDetailElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
                res.getMitigation().add(this.parseDetectedIssueDetectedIssueMitigationComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.setAction(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device res = new Device();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udiCarrier")) {
                res.setUdiCarrier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Device.DeviceStatus.NULL, new Device.DeviceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
                res.setLotNumberElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
                res.setManufacturerElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manufactureDate")) {
                res.setManufactureDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
                res.setExpirationDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("model")) {
                res.setModelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("owner")) {
                res.setOwner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceComponent parseDeviceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceComponent res = new DeviceComponent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastSystemChange")) {
                res.setLastSystemChangeElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.setParent(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
                res.getOperationalStatus().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parameterGroup")) {
                res.setParameterGroup(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("measurementPrinciple")) {
                res.setMeasurementPrincipleElement(this.parseEnumeration(xpp, DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("productionSpecification")) {
                res.getProductionSpecification().add(this.parseDeviceComponentDeviceComponentProductionSpecificationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("languageCode")) {
                res.setLanguageCode(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(XmlPullParser xpp, DeviceComponent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("specType")) {
                res.setSpecType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("componentId")) {
                res.setComponentId(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("productionSpec")) {
                res.setProductionSpecElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnit(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.setParent(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
                res.setOperationalStatusElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("color")) {
                res.setColorElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("measurementPeriod")) {
                res.setMeasurementPeriod(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("calibration")) {
                res.getCalibration().add(this.parseDeviceMetricDeviceMetricCalibrationComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(XmlPullParser xpp, DeviceMetric owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("state")) {
                res.setStateElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseInstant(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceUseRequest parseDeviceUseRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUseRequest res = new DeviceUseRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "bodySite")) {
                res.setBodySite(this.parseType("bodySite", xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DeviceUseRequest.DeviceUseRequestStatus.NULL, new DeviceUseRequest.DeviceUseRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.setDevice(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indication")) {
                res.getIndication().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prnReason")) {
                res.getPrnReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedOn")) {
                res.setOrderedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recordedOn")) {
                res.setRecordedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
                res.setTiming(this.parseType("timing", xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseEnumeration(xpp, DeviceUseRequest.DeviceUseRequestPriority.NULL, new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory()));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceUseStatement parseDeviceUseStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "bodySite")) {
                res.setBodySite(this.parseType("bodySite", xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenUsed")) {
                res.setWhenUsed(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.setDevice(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indication")) {
                res.getIndication().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recordedOn")) {
                res.setRecordedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
                res.setTiming(this.parseType("timing", xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticOrder parseDiagnosticOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticOrder res = new DiagnosticOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderPriority.NULL, new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderer")) {
                res.setOrderer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
                res.getSupportingInformation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.getSpecimen().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseDiagnosticOrderDiagnosticOrderItemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderEventComponent parseDiagnosticOrderDiagnosticOrderEventComponent(XmlPullParser xpp, DiagnosticOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticOrder.DiagnosticOrderEventComponent res = new DiagnosticOrder.DiagnosticOrderEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescription(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
                res.setDateTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderItemComponent parseDiagnosticOrderDiagnosticOrderItemComponent(XmlPullParser xpp, DiagnosticOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticOrder.DiagnosticOrderItemComponent res = new DiagnosticOrder.DiagnosticOrderItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.getSpecimen().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
                res.setEffective(this.parseType("effective", xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.getRequest().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.getSpecimen().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("result")) {
                res.getResult().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
                res.getImagingStudy().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("image")) {
                res.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("conclusion")) {
                res.setConclusionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codedDiagnosis")) {
                res.getCodedDiagnosis().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("presentedForm")) {
                res.getPresentedForm().add(this.parseAttachment(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(XmlPullParser xpp, DiagnosticReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.setLink(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest res = new DocumentManifest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
                res.setMasterIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSourceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseDocumentManifestDocumentManifestContentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseDocumentManifestDocumentManifestRelatedComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "p")) {
                res.setP(this.parseType("p", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ref")) {
                res.setRef(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
                res.setMasterIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("class")) {
                res.setClass_(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("custodian")) {
                res.setCustodian(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authenticator")) {
                res.setAuthenticator(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indexed")) {
                res.setIndexedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("docStatus")) {
                res.setDocStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
                res.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
                res.getSecurityLabel().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseDocumentReferenceDocumentReferenceContentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("attachment")) {
                res.setAttachment(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("format")) {
                res.getFormat().add(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("facilityType")) {
                res.setFacilityType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("practiceSetting")) {
                res.setPracticeSetting(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sourcePatientInfo")) {
                res.setSourcePatientInfo(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseDocumentReferenceDocumentReferenceContextRelatedComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ref")) {
                res.setRef(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EligibilityRequest parseEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityRequest res = new EligibilityRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "provider")) {
                res.setProvider(this.parseType("provider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "enterer")) {
                res.setEnterer(this.parseType("enterer", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "facility")) {
                res.setFacility(this.parseType("facility", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "patient")) {
                res.setPatient(this.parseType("patient", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "coverage")) {
                res.setCoverage(this.parseType("coverage", xpp));
            } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
                res.setBusinessArrangementElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
                res.setServiced(this.parseType("serviced", xpp));
            } else if (eventType == 2 && xpp.getName().equals("benefitCategory")) {
                res.setBenefitCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("benefitSubCategory")) {
                res.setBenefitSubCategory(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EligibilityResponse parseEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse res = new EligibilityResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "request")) {
                res.setRequest(this.parseType("request", xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestProvider")) {
                res.setRequestProvider(this.parseType("requestProvider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestOrganization")) {
                res.setRequestOrganization(this.parseType("requestOrganization", xpp));
            } else if (eventType == 2 && xpp.getName().equals("inforce")) {
                res.setInforceElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contract")) {
                res.setContract(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("benefitBalance")) {
                res.getBenefitBalance().add(this.parseEligibilityResponseBenefitsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("error")) {
                res.getError().add(this.parseEligibilityResponseErrorsComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EligibilityResponse.BenefitsComponent parseEligibilityResponseBenefitsComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse.BenefitsComponent res = new EligibilityResponse.BenefitsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subCategory")) {
                res.setSubCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("network")) {
                res.setNetwork(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnit(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("term")) {
                res.setTerm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("financial")) {
                res.getFinancial().add(this.parseEligibilityResponseBenefitComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EligibilityResponse.BenefitComponent parseEligibilityResponseBenefitComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse.BenefitComponent res = new EligibilityResponse.BenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "benefit")) {
                res.setBenefit(this.parseType("benefit", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "benefitUsed")) {
                res.setBenefitUsed(this.parseType("benefitUsed", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EligibilityResponse.ErrorsComponent parseEligibilityResponseErrorsComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse.ErrorsComponent res = new EligibilityResponse.ErrorsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
                res.getStatusHistory().add(this.parseEncounterEncounterStatusHistoryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("class")) {
                res.setClass_Element(this.parseEnumeration(xpp, Encounter.EncounterClass.NULL, new Encounter.EncounterClassEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("episodeOfCare")) {
                res.getEpisodeOfCare().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("incomingReferral")) {
                res.getIncomingReferral().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseEncounterEncounterParticipantComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("appointment")) {
                res.setAppointment(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("length")) {
                res.setLength(this.parseDuration(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indication")) {
                res.getIndication().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
                res.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseEncounterEncounterLocationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("serviceProvider")) {
                res.setServiceProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("partOf")) {
                res.setPartOf(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterStatusHistoryComponent parseEncounterEncounterStatusHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterStatusHistoryComponent res = new Encounter.EncounterStatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("individual")) {
                res.setIndividual(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("preAdmissionIdentifier")) {
                res.setPreAdmissionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("origin")) {
                res.setOrigin(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("admitSource")) {
                res.setAdmitSource(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("admittingDiagnosis")) {
                res.getAdmittingDiagnosis().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reAdmission")) {
                res.setReAdmission(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dietPreference")) {
                res.getDietPreference().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialCourtesy")) {
                res.getSpecialCourtesy().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialArrangement")) {
                res.getSpecialArrangement().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestination(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dischargeDisposition")) {
                res.setDischargeDisposition(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dischargeDiagnosis")) {
                res.getDischargeDiagnosis().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.setCoverage(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
                res.setRequestProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
                res.setRequestOrganization(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
                res.getStatusHistory().add(this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.getCondition().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referralRequest")) {
                res.getReferralRequest().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("careManager")) {
                res.setCareManager(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("team")) {
                res.getTeam().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile parseExpansionProfile(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile res = new ExpansionProfile();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseExpansionProfileExpansionProfileContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.setCodeSystem(this.parseExpansionProfileExpansionProfileCodeSystemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("includeDesignations")) {
                res.setIncludeDesignationsElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("designation")) {
                res.setDesignation(this.parseExpansionProfileExpansionProfileDesignationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("includeDefinition")) {
                res.setIncludeDefinitionElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("includeInactive")) {
                res.setIncludeInactiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("excludeNested")) {
                res.setExcludeNestedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("excludeNotForUI")) {
                res.setExcludeNotForUIElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("excludePostCoordinated")) {
                res.setExcludePostCoordinatedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("displayLanguage")) {
                res.setDisplayLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("limitedExpansion")) {
                res.setLimitedExpansionElement(this.parseBoolean(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.ExpansionProfileContactComponent parseExpansionProfileExpansionProfileContactComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileContactComponent res = new ExpansionProfile.ExpansionProfileContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.ExpansionProfileCodeSystemComponent parseExpansionProfileExpansionProfileCodeSystemComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileCodeSystemComponent res = new ExpansionProfile.ExpansionProfileCodeSystemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("include")) {
                res.setInclude(this.parseExpansionProfileCodeSystemIncludeComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.setExclude(this.parseExpansionProfileCodeSystemExcludeComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.CodeSystemIncludeComponent parseExpansionProfileCodeSystemIncludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemIncludeComponent res = new ExpansionProfile.CodeSystemIncludeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.getCodeSystem().add(this.parseExpansionProfileCodeSystemIncludeCodeSystemComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.CodeSystemIncludeCodeSystemComponent parseExpansionProfileCodeSystemIncludeCodeSystemComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemIncludeCodeSystemComponent res = new ExpansionProfile.CodeSystemIncludeCodeSystemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.CodeSystemExcludeComponent parseExpansionProfileCodeSystemExcludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemExcludeComponent res = new ExpansionProfile.CodeSystemExcludeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.getCodeSystem().add(this.parseExpansionProfileCodeSystemExcludeCodeSystemComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.CodeSystemExcludeCodeSystemComponent parseExpansionProfileCodeSystemExcludeCodeSystemComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemExcludeCodeSystemComponent res = new ExpansionProfile.CodeSystemExcludeCodeSystemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.ExpansionProfileDesignationComponent parseExpansionProfileExpansionProfileDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileDesignationComponent res = new ExpansionProfile.ExpansionProfileDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("include")) {
                res.setInclude(this.parseExpansionProfileDesignationIncludeComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.setExclude(this.parseExpansionProfileDesignationExcludeComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.DesignationIncludeComponent parseExpansionProfileDesignationIncludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeComponent res = new ExpansionProfile.DesignationIncludeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("designation")) {
                res.getDesignation().add(this.parseExpansionProfileDesignationIncludeDesignationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.DesignationIncludeDesignationComponent parseExpansionProfileDesignationIncludeDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeDesignationComponent res = new ExpansionProfile.DesignationIncludeDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUse(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.DesignationExcludeComponent parseExpansionProfileDesignationExcludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeComponent res = new ExpansionProfile.DesignationExcludeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("designation")) {
                res.getDesignation().add(this.parseExpansionProfileDesignationExcludeDesignationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExpansionProfile.DesignationExcludeDesignationComponent parseExpansionProfileDesignationExcludeDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeDesignationComponent res = new ExpansionProfile.DesignationExcludeDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUse(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "claim")) {
                res.setClaim(this.parseType("claim", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "claimResponse")) {
                res.setClaimResponse(this.parseType("claimResponse", xpp));
            } else if (eventType == 2 && xpp.getName().equals("subType")) {
                res.getSubType().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
                res.setBillablePeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "provider")) {
                res.setProvider(this.parseType("provider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "facility")) {
                res.setFacility(this.parseType("facility", xpp));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimsComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "prescription")) {
                res.setPrescription(this.parseType("prescription", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "originalPrescription")) {
                res.setOriginalPrescription(this.parseType("originalPrescription", xpp));
            } else if (eventType == 2 && xpp.getName().equals("payee")) {
                res.setPayee(this.parseExplanationOfBenefitPayeeComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "referral")) {
                res.setReferral(this.parseType("referral", xpp));
            } else if (eventType == 2 && xpp.getName().equals("occurrenceCode")) {
                res.getOccurrenceCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("occurenceSpanCode")) {
                res.getOccurenceSpanCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("valueCode")) {
                res.getValueCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
                res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("procedure")) {
                res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("specialCondition")) {
                res.getSpecialCondition().add(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "patient")) {
                res.setPatient(this.parseType("patient", xpp));
            } else if (eventType == 2 && xpp.getName().equals("precedence")) {
                res.setPrecedenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.setCoverage(this.parseExplanationOfBenefitCoverageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("accidentDate")) {
                res.setAccidentDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accidentType")) {
                res.setAccidentType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "accidentLocation")) {
                res.setAccidentLocation(this.parseType("accidentLocation", xpp));
            } else if (eventType == 2 && xpp.getName().equals("interventionException")) {
                res.getInterventionException().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("onset")) {
                res.getOnset().add(this.parseExplanationOfBenefitOnsetComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("employmentImpacted")) {
                res.setEmploymentImpacted(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
                res.setHospitalization(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseExplanationOfBenefitItemsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("addItem")) {
                res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("missingTeeth")) {
                res.getMissingTeeth().add(this.parseExplanationOfBenefitMissingTeethComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("totalCost")) {
                res.setTotalCost(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unallocDeductable")) {
                res.setUnallocDeductable(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("totalBenefit")) {
                res.setTotalBenefit(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAdjustment")) {
                res.setPaymentAdjustment(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAdjustmentReason")) {
                res.setPaymentAdjustmentReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentDate")) {
                res.setPaymentDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAmount")) {
                res.setPaymentAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentRef")) {
                res.setPaymentRef(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reserved")) {
                res.setReserved(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseExplanationOfBenefitNotesComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("benefitBalance")) {
                res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.RelatedClaimsComponent parseExplanationOfBenefitRelatedClaimsComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimsComponent res = new ExplanationOfBenefit.RelatedClaimsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "claim")) {
                res.setClaim(this.parseType("claim", xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseIdentifier(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "party")) {
                res.setParty(this.parseType("party", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
                res.setDiagnosis(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
                res.setProcedure(this.parseType("procedure", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.CoverageComponent parseExplanationOfBenefitCoverageComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.CoverageComponent res = new ExplanationOfBenefit.CoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "coverage")) {
                res.setCoverage(this.parseType("coverage", xpp));
            } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
                res.getPreAuthRef().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.OnsetComponent parseExplanationOfBenefitOnsetComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.OnsetComponent res = new ExplanationOfBenefit.OnsetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "time")) {
                res.setTime(this.parseType("time", xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.ItemsComponent parseExplanationOfBenefitItemsComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemsComponent res = new ExplanationOfBenefit.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "provider")) {
                res.setProvider(this.parseType("provider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "supervisor")) {
                res.setSupervisor(this.parseType("supervisor", xpp));
            } else if (eventType == 2 && xpp.getName().equals("providerQualification")) {
                res.setProviderQualification(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosisLinkId")) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceModifier")) {
                res.getServiceModifier().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.getModifier().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programCode")) {
                res.getProgramCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
                res.setServiced(this.parseType("serviced", xpp));
            } else if (eventType == 2 && xpp.getName().equals("place")) {
                res.setPlace(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.getUdi().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subSite")) {
                res.getSubSite().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
                res.getNoteNumber().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseExplanationOfBenefitItemAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("prosthesis")) {
                res.setProsthesis(this.parseExplanationOfBenefitProsthesisComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.ItemAdjudicationComponent parseExplanationOfBenefitItemAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemAdjudicationComponent res = new ExplanationOfBenefit.ItemAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programCode")) {
                res.getProgramCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.getUdi().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseExplanationOfBenefitDetailAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
                res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.DetailAdjudicationComponent parseExplanationOfBenefitDetailAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailAdjudicationComponent res = new ExplanationOfBenefit.DetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programCode")) {
                res.getProgramCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.getUdi().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseExplanationOfBenefitSubDetailAdjudicationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.SubDetailAdjudicationComponent parseExplanationOfBenefitSubDetailAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailAdjudicationComponent res = new ExplanationOfBenefit.SubDetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.ProsthesisComponent parseExplanationOfBenefitProsthesisComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ProsthesisComponent res = new ExplanationOfBenefit.ProsthesisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("initial")) {
                res.setInitialElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priorDate")) {
                res.setPriorDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priorMaterial")) {
                res.setPriorMaterial(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.getSequenceLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fee")) {
                res.setFee(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("noteNumberLinkId")) {
                res.getNoteNumberLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAddedItemAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseExplanationOfBenefitAddedItemsDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.AddedItemAdjudicationComponent parseExplanationOfBenefitAddedItemAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemAdjudicationComponent res = new ExplanationOfBenefit.AddedItemAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.AddedItemsDetailComponent parseExplanationOfBenefitAddedItemsDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemsDetailComponent res = new ExplanationOfBenefit.AddedItemsDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fee")) {
                res.setFee(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAddedItemDetailAdjudicationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.AddedItemDetailAdjudicationComponent parseExplanationOfBenefitAddedItemDetailAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailAdjudicationComponent res = new ExplanationOfBenefit.AddedItemDetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.MissingTeethComponent parseExplanationOfBenefitMissingTeethComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.MissingTeethComponent res = new ExplanationOfBenefit.MissingTeethComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("tooth")) {
                res.setTooth(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extractionDate")) {
                res.setExtractionDateElement(this.parseDate(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.NotesComponent parseExplanationOfBenefitNotesComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.NotesComponent res = new ExplanationOfBenefit.NotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("number")) {
                res.setNumberElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subCategory")) {
                res.setSubCategory(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("network")) {
                res.setNetwork(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnit(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("term")) {
                res.setTerm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("financial")) {
                res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "benefit")) {
                res.setBenefit(this.parseType("benefit", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "benefitUsed")) {
                res.setBenefitUsed(this.parseType("benefitUsed", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "born")) {
                res.setBorn(this.parseType("born", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "age")) {
                res.setAge(this.parseType("age", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
                res.setDeceased(this.parseType("deceased", xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.getCondition().add(this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(XmlPullParser xpp, FamilyMemberHistory owner) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
                res.setOnset(this.parseType("onset", xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal res = new Goal();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "start")) {
                res.setStart(this.parseType("start", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.getCategory().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
                res.setStatusDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
                res.setStatusReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("addresses")) {
                res.getAddresses().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.getOutcome().add(this.parseGoalGoalOutcomeComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Goal.GoalOutcomeComponent parseGoalGoalOutcomeComponent(XmlPullParser xpp, Goal owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal.GoalOutcomeComponent res = new Goal.GoalOutcomeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "result")) {
                res.setResult(this.parseType("result", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Group res = new Group();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("actual")) {
                res.setActualElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantityElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
                res.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("member")) {
                res.getMember().add(this.parseGroupGroupMemberComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.setExcludeElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Group.GroupMemberComponent parseGroupGroupMemberComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("entity")) {
                res.setEntity(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("inactive")) {
                res.setInactiveElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected GuidanceResponse parseGuidanceResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GuidanceResponse res = new GuidanceResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("requestId")) {
                res.setRequestIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("module")) {
                res.setModule(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("evaluationMessage")) {
                res.getEvaluationMessage().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outputParameters")) {
                res.setOutputParameters(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseGuidanceResponseGuidanceResponseActionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
                res.getDataRequirement().add(this.parseDataRequirement(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected GuidanceResponse.GuidanceResponseActionComponent parseGuidanceResponseGuidanceResponseActionComponent(XmlPullParser xpp, GuidanceResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GuidanceResponse.GuidanceResponseActionComponent res = new GuidanceResponse.GuidanceResponseActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actionIdentifier")) {
                res.setActionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("textEquivalent")) {
                res.setTextEquivalentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingEvidence")) {
                res.getSupportingEvidence().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatedAction")) {
                res.setRelatedAction(this.parseGuidanceResponseGuidanceResponseActionRelatedActionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.getDocumentation().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("behavior")) {
                res.getBehavior().add(this.parseGuidanceResponseGuidanceResponseActionBehaviorComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseGuidanceResponseGuidanceResponseActionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected GuidanceResponse.GuidanceResponseActionRelatedActionComponent parseGuidanceResponseGuidanceResponseActionRelatedActionComponent(XmlPullParser xpp, GuidanceResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GuidanceResponse.GuidanceResponseActionRelatedActionComponent res = new GuidanceResponse.GuidanceResponseActionRelatedActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actionIdentifier")) {
                res.setActionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationshipElement(this.parseCode(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "offset")) {
                res.setOffset(this.parseType("offset", xpp));
            } else if (eventType == 2 && xpp.getName().equals("anchor")) {
                res.setAnchorElement(this.parseCode(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected GuidanceResponse.GuidanceResponseActionBehaviorComponent parseGuidanceResponseGuidanceResponseActionBehaviorComponent(XmlPullParser xpp, GuidanceResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GuidanceResponse.GuidanceResponseActionBehaviorComponent res = new GuidanceResponse.GuidanceResponseActionBehaviorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValue(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService res = new HealthcareService();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("providedBy")) {
                res.setProvidedBy(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
                res.setServiceCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
                res.getServiceType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceName")) {
                res.setServiceNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extraDetails")) {
                res.setExtraDetailsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.setPhoto(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
                res.getCoverageArea().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceProvisionCode")) {
                res.getServiceProvisionCode().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("eligibility")) {
                res.setEligibility(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("eligibilityNote")) {
                res.setEligibilityNoteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programName")) {
                res.getProgramName().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
                res.getCharacteristic().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referralMethod")) {
                res.getReferralMethod().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publicKey")) {
                res.setPublicKeyElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("appointmentRequired")) {
                res.setAppointmentRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableTime")) {
                res.getAvailableTime().add(this.parseHealthcareServiceHealthcareServiceAvailableTimeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("notAvailable")) {
                res.getNotAvailable().add(this.parseHealthcareServiceHealthcareServiceNotAvailableComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("availabilityExceptions")) {
                res.setAvailabilityExceptionsElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
                res.getDaysOfWeek().add(this.parseEnumeration(xpp, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("allDay")) {
                res.setAllDayElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableStartTime")) {
                res.setAvailableStartTimeElement(this.parseTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableEndTime")) {
                res.setAvailableEndTimeElement(this.parseTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("during")) {
                res.setDuring(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt parseImagingExcerpt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt res = new ImagingExcerpt();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authoringTime")) {
                res.setAuthoringTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitle(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("study")) {
                res.getStudy().add(this.parseImagingExcerptStudyComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt.StudyComponent parseImagingExcerptStudyComponent(XmlPullParser xpp, ImagingExcerpt owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt.StudyComponent res = new ImagingExcerpt.StudyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
                res.setImagingStudy(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dicom")) {
                res.getDicom().add(this.parseImagingExcerptStudyDicomComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("viewable")) {
                res.getViewable().add(this.parseImagingExcerptStudyViewableComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.getSeries().add(this.parseImagingExcerptSeriesComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt.StudyDicomComponent parseImagingExcerptStudyDicomComponent(XmlPullParser xpp, ImagingExcerpt owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt.StudyDicomComponent res = new ImagingExcerpt.StudyDicomComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ImagingExcerpt.DWebType.NULL, new ImagingExcerpt.DWebTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt.StudyViewableComponent parseImagingExcerptStudyViewableComponent(XmlPullParser xpp, ImagingExcerpt owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt.StudyViewableComponent res = new ImagingExcerpt.StudyViewableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("height")) {
                res.setHeightElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("width")) {
                res.setWidthElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("frames")) {
                res.setFramesElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDurationElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("size")) {
                res.setSizeElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt.SeriesComponent parseImagingExcerptSeriesComponent(XmlPullParser xpp, ImagingExcerpt owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt.SeriesComponent res = new ImagingExcerpt.SeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dicom")) {
                res.getDicom().add(this.parseImagingExcerptSeriesDicomComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.getInstance().add(this.parseImagingExcerptInstanceComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt.SeriesDicomComponent parseImagingExcerptSeriesDicomComponent(XmlPullParser xpp, ImagingExcerpt owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt.SeriesDicomComponent res = new ImagingExcerpt.SeriesDicomComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ImagingExcerpt.DWebType.NULL, new ImagingExcerpt.DWebTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt.InstanceComponent parseImagingExcerptInstanceComponent(XmlPullParser xpp, ImagingExcerpt owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt.InstanceComponent res = new ImagingExcerpt.InstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sopClass")) {
                res.setSopClassElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dicom")) {
                res.getDicom().add(this.parseImagingExcerptInstanceDicomComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("frameNumbers")) {
                res.getFrameNumbers().add(this.parseUnsignedInt(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingExcerpt.InstanceDicomComponent parseImagingExcerptInstanceDicomComponent(XmlPullParser xpp, ImagingExcerpt owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingExcerpt.InstanceDicomComponent res = new ImagingExcerpt.InstanceDicomComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ImagingExcerpt.DWebType.NULL, new ImagingExcerpt.DWebTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection parseImagingObjectSelection(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection res = new ImagingObjectSelection();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authoringTime")) {
                res.setAuthoringTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitle(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("study")) {
                res.getStudy().add(this.parseImagingObjectSelectionStudyComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.StudyComponent parseImagingObjectSelectionStudyComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.StudyComponent res = new ImagingObjectSelection.StudyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
                res.setImagingStudy(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.getSeries().add(this.parseImagingObjectSelectionSeriesComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.SeriesComponent parseImagingObjectSelectionSeriesComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.SeriesComponent res = new ImagingObjectSelection.SeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.getInstance().add(this.parseImagingObjectSelectionInstanceComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.InstanceComponent parseImagingObjectSelectionInstanceComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.InstanceComponent res = new ImagingObjectSelection.InstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sopClass")) {
                res.setSopClassElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("frame")) {
                res.getFrame().add(this.parseImagingObjectSelectionFramesComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.FramesComponent parseImagingObjectSelectionFramesComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.FramesComponent res = new ImagingObjectSelection.FramesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("number")) {
                res.getNumber().add(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy res = new ImagingStudy();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accession")) {
                res.setAccession(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availability")) {
                res.setAvailabilityElement(this.parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("modalityList")) {
                res.getModalityList().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("started")) {
                res.setStartedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("order")) {
                res.getOrder().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referrer")) {
                res.setReferrer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("interpreter")) {
                res.setInterpreter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfSeries")) {
                res.setNumberOfSeriesElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
                res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("procedure")) {
                res.getProcedure().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("number")) {
                res.setNumberElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modality")) {
                res.setModality(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
                res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availability")) {
                res.setAvailabilityElement(this.parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("laterality")) {
                res.setLaterality(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("started")) {
                res.setStartedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("number")) {
                res.setNumberElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sopClass")) {
                res.setSopClassElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseAttachment(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization res = new Immunization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
                res.setVaccineCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("wasNotGiven")) {
                res.setWasNotGivenElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reported")) {
                res.setReportedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requester")) {
                res.setRequester(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
                res.setManufacturer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
                res.setLotNumberElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
                res.setExpirationDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("site")) {
                res.setSite(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseQuantity")) {
                res.setDoseQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("explanation")) {
                res.setExplanation(this.parseImmunizationImmunizationExplanationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("reaction")) {
                res.getReaction().add(this.parseImmunizationImmunizationReactionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("vaccinationProtocol")) {
                res.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotGiven")) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.setDetail(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reported")) {
                res.setReportedElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("doseSequence")) {
                res.setDoseSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authority")) {
                res.setAuthority(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.setSeriesElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("seriesDoses")) {
                res.setSeriesDosesElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
                res.getTargetDisease().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseStatus")) {
                res.setDoseStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseStatusReason")) {
                res.setDoseStatusReason(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recommendation")) {
                res.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
                res.setVaccineCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseNumber")) {
                res.setDoseNumberElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("forecastStatus")) {
                res.setForecastStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateCriterion")) {
                res.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("protocol")) {
                res.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("supportingImmunization")) {
                res.getSupportingImmunization().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingPatientInformation")) {
                res.getSupportingPatientInformation().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDateTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("doseSequence")) {
                res.setDoseSequenceElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authority")) {
                res.setAuthority(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.setSeriesElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide res = new ImplementationGuide();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseImplementationGuideImplementationGuideContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
                res.setFhirVersionElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dependency")) {
                res.getDependency().add(this.parseImplementationGuideImplementationGuideDependencyComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("package")) {
                res.getPackage().add(this.parseImplementationGuideImplementationGuidePackageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("global")) {
                res.getGlobal().add(this.parseImplementationGuideImplementationGuideGlobalComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("binary")) {
                res.getBinary().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("page")) {
                res.setPage(this.parseImplementationGuideImplementationGuidePageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuideContactComponent parseImplementationGuideImplementationGuideContactComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideContactComponent res = new ImplementationGuide.ImplementationGuideContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("uri")) {
                res.setUriElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.getResource().add(this.parseImplementationGuideImplementationGuidePackageResourceComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("example")) {
                res.setExampleElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("acronym")) {
                res.setAcronymElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
                res.setSource(this.parseType("source", xpp));
            } else if (eventType == 2 && xpp.getName().equals("exampleFor")) {
                res.setExampleFor(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSourceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("package")) {
                res.getPackage().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("format")) {
                res.setFormatElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("page")) {
                res.getPage().add(this.parseImplementationGuideImplementationGuidePageComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Library parseLibrary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Library res = new Library();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("moduleMetadata")) {
                res.setModuleMetadata(this.parseModuleMetadata(xpp));
            } else if (eventType == 2 && xpp.getName().equals("model")) {
                res.getModel().add(this.parseLibraryLibraryModelComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("library")) {
                res.getLibrary().add(this.parseLibraryLibraryLibraryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.getCodeSystem().add(this.parseLibraryLibraryCodeSystemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
                res.getValueSet().add(this.parseLibraryLibraryValueSetComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseParameterDefinition(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
                res.getDataRequirement().add(this.parseDataRequirement(xpp));
            } else if (eventType == 2 && xpp.getName().equals("document")) {
                res.setDocument(this.parseAttachment(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Library.LibraryModelComponent parseLibraryLibraryModelComponent(XmlPullParser xpp, Library owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Library.LibraryModelComponent res = new Library.LibraryModelComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Library.LibraryLibraryComponent parseLibraryLibraryLibraryComponent(XmlPullParser xpp, Library owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Library.LibraryLibraryComponent res = new Library.LibraryLibraryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "document")) {
                res.setDocument(this.parseType("document", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Library.LibraryCodeSystemComponent parseLibraryLibraryCodeSystemComponent(XmlPullParser xpp, Library owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Library.LibraryCodeSystemComponent res = new Library.LibraryCodeSystemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Library.LibraryValueSetComponent parseLibraryLibraryValueSetComponent(XmlPullParser xpp, Library owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Library.LibraryValueSetComponent res = new Library.LibraryValueSetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.getCodeSystem().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Linkage parseLinkage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage res = new Linkage();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseLinkageLinkageItemComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(XmlPullParser xpp, Linkage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ListResource parseListResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource res = new ListResource();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
                res.setOrderedBy(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("entry")) {
                res.getEntry().add(this.parseListResourceListEntryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
                res.setEmptyReason(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ListResource.ListEntryComponent parseListResourceListEntryComponent(XmlPullParser xpp, ListResource owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("flag")) {
                res.setFlag(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("deleted")) {
                res.setDeletedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Location res = new Location();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddress(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("physicalType")) {
                res.setPhysicalType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("position")) {
                res.setPosition(this.parseLocationLocationPositionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("partOf")) {
                res.setPartOf(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Location.LocationPositionComponent parseLocationLocationPositionComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("longitude")) {
                res.setLongitudeElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("latitude")) {
                res.setLatitudeElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("altitude")) {
                res.setAltitudeElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Measure parseMeasure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure res = new Measure();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("moduleMetadata")) {
                res.setModuleMetadata(this.parseModuleMetadata(xpp));
            } else if (eventType == 2 && xpp.getName().equals("library")) {
                res.getLibrary().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("disclaimer")) {
                res.setDisclaimerElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("scoring")) {
                res.setScoringElement(this.parseEnumeration(xpp, Measure.MeasureScoring.NULL, new Measure.MeasureScoringEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseEnumeration(xpp, Measure.MeasureType.NULL, new Measure.MeasureTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("riskAdjustment")) {
                res.setRiskAdjustmentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rateAggregation")) {
                res.setRateAggregationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rationale")) {
                res.setRationaleElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("clinicalRecommendationStatement")) {
                res.setClinicalRecommendationStatementElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("improvementNotation")) {
                res.setImprovementNotationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("guidance")) {
                res.setGuidanceElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("set")) {
                res.setSetElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseMeasureMeasureGroupComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("supplementalData")) {
                res.getSupplementalData().add(this.parseMeasureMeasureSupplementalDataComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("population")) {
                res.getPopulation().add(this.parseMeasureMeasureGroupPopulationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("stratifier")) {
                res.getStratifier().add(this.parseMeasureMeasureGroupStratifierComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Measure.MeasurePopulationType.NULL, new Measure.MeasurePopulationTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("criteria")) {
                res.setCriteriaElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("criteria")) {
                res.setCriteriaElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("usage")) {
                res.getUsage().add(this.parseEnumeration(xpp, Measure.MeasureDataUsage.NULL, new Measure.MeasureDataUsageEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("criteria")) {
                res.setCriteriaElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport parseMeasureReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport res = new MeasureReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("measure")) {
                res.setMeasure(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reportingOrganization")) {
                res.setReportingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseMeasureReportMeasureReportGroupComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("evaluatedResources")) {
                res.setEvaluatedResources(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("population")) {
                res.getPopulation().add(this.parseMeasureReportMeasureReportGroupPopulationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("measureScore")) {
                res.setMeasureScoreElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("stratifier")) {
                res.getStratifier().add(this.parseMeasureReportMeasureReportGroupStratifierComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("supplementalData")) {
                res.getSupplementalData().add(this.parseMeasureReportMeasureReportGroupSupplementalDataComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("count")) {
                res.setCountElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patients")) {
                res.setPatients(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseMeasureReportMeasureReportGroupStratifierGroupComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport.MeasureReportGroupStratifierGroupComponent parseMeasureReportMeasureReportGroupStratifierGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierGroupComponent res = new MeasureReport.MeasureReportGroupStratifierGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("population")) {
                res.getPopulation().add(this.parseMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("measureScore")) {
                res.setMeasureScoreElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent parseMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent res = new MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("count")) {
                res.setCountElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patients")) {
                res.setPatients(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport.MeasureReportGroupSupplementalDataComponent parseMeasureReportMeasureReportGroupSupplementalDataComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupSupplementalDataComponent res = new MeasureReport.MeasureReportGroupSupplementalDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseMeasureReportMeasureReportGroupSupplementalDataGroupComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MeasureReport.MeasureReportGroupSupplementalDataGroupComponent parseMeasureReportMeasureReportGroupSupplementalDataGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupSupplementalDataGroupComponent res = new MeasureReport.MeasureReportGroupSupplementalDataGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("count")) {
                res.setCountElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patients")) {
                res.setPatients(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Media parseMedia(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Media res = new Media();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("subtype")) {
                res.setSubtype(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("view")) {
                res.setView(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operator")) {
                res.setOperator(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("deviceName")) {
                res.setDeviceNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("height")) {
                res.setHeightElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("width")) {
                res.setWidthElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("frames")) {
                res.setFramesElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDurationElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.setContent(this.parseAttachment(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication parseMedication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication res = new Medication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("isBrand")) {
                res.setIsBrandElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
                res.setManufacturer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("product")) {
                res.setProduct(this.parseMedicationMedicationProductComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("package")) {
                res.setPackage(this.parseMedicationMedicationPackageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationProductComponent parseMedicationMedicationProductComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationProductComponent res = new Medication.MedicationProductComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
                res.getIngredient().add(this.parseMedicationMedicationProductIngredientComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("batch")) {
                res.getBatch().add(this.parseMedicationMedicationProductBatchComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationProductIngredientComponent parseMedicationMedicationProductIngredientComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationProductIngredientComponent res = new Medication.MedicationProductIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
                res.setItem(this.parseType("item", xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationProductBatchComponent parseMedicationMedicationProductBatchComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationProductBatchComponent res = new Medication.MedicationProductBatchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("lotNumber")) {
                res.setLotNumberElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
                res.setExpirationDateElement(this.parseDateTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("container")) {
                res.setContainer(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseMedicationMedicationPackageContentComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
                res.setItem(this.parseType("item", xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseSimpleQuantity(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationAdministration parseMedicationAdministration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration res = new MedicationAdministration();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effectiveTime")) {
                res.setEffectiveTime(this.parseType("effectiveTime", xpp));
            } else if (eventType == 2 && xpp.getName().equals("practitioner")) {
                res.setPractitioner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prescription")) {
                res.setPrescription(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("wasNotGiven")) {
                res.setWasNotGivenElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotGiven")) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonGiven")) {
                res.getReasonGiven().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.getDevice().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosage")) {
                res.setDosage(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationDispense parseMedicationDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense res = new MedicationDispense();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dispenser")) {
                res.setDispenser(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authorizingPrescription")) {
                res.getAuthorizingPrescription().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("daysSupply")) {
                res.setDaysSupply(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenPrepared")) {
                res.setWhenPreparedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenHandedOver")) {
                res.setWhenHandedOverElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestination(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receiver")) {
                res.getReceiver().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
                res.getDosageInstruction().add(this.parseMedicationDispenseMedicationDispenseDosageInstructionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("substitution")) {
                res.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationDispense.MedicationDispenseDosageInstructionComponent parseMedicationDispenseMedicationDispenseDosageInstructionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispenseDosageInstructionComponent res = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additionalInstructions")) {
                res.setAdditionalInstructions(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timing")) {
                res.setTiming(this.parseTiming(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "dose")) {
                res.setDose(this.parseType("dose", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
                res.setMaxDosePerPeriod(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("responsibleParty")) {
                res.getResponsibleParty().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder parseMedicationOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder res = new MedicationOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationOrder.MedicationOrderStatus.NULL, new MedicationOrder.MedicationOrderStatusEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateWritten")) {
                res.setDateWrittenElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prescriber")) {
                res.setPrescriber(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
                res.getReasonCode().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
                res.getReasonReference().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateEnded")) {
                res.setDateEndedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonEnded")) {
                res.setReasonEnded(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
                res.getDosageInstruction().add(this.parseMedicationOrderMedicationOrderDosageInstructionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("dispenseRequest")) {
                res.setDispenseRequest(this.parseMedicationOrderMedicationOrderDispenseRequestComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("substitution")) {
                res.setSubstitution(this.parseMedicationOrderMedicationOrderSubstitutionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("priorPrescription")) {
                res.setPriorPrescription(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder.MedicationOrderDosageInstructionComponent parseMedicationOrderMedicationOrderDosageInstructionComponent(XmlPullParser xpp, MedicationOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderDosageInstructionComponent res = new MedicationOrder.MedicationOrderDosageInstructionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additionalInstructions")) {
                res.setAdditionalInstructions(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timing")) {
                res.setTiming(this.parseTiming(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "dose")) {
                res.setDose(this.parseType("dose", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
                res.setMaxDosePerPeriod(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder.MedicationOrderDispenseRequestComponent parseMedicationOrderMedicationOrderDispenseRequestComponent(XmlPullParser xpp, MedicationOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderDispenseRequestComponent res = new MedicationOrder.MedicationOrderDispenseRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("validityPeriod")) {
                res.setValidityPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfRepeatsAllowed")) {
                res.setNumberOfRepeatsAllowedElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expectedSupplyDuration")) {
                res.setExpectedSupplyDuration(this.parseDuration(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder.MedicationOrderSubstitutionComponent parseMedicationOrderMedicationOrderSubstitutionComponent(XmlPullParser xpp, MedicationOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderSubstitutionComponent res = new MedicationOrder.MedicationOrderSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationStatement parseMedicationStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationStatement res = new MedicationStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
                res.setEffective(this.parseType("effective", xpp));
            } else if (eventType == 2 && xpp.getName().equals("informationSource")) {
                res.setInformationSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
                res.getSupportingInformation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateAsserted")) {
                res.setDateAssertedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("wasNotTaken")) {
                res.setWasNotTakenElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotTaken")) {
                res.getReasonNotTaken().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reasonForUse")) {
                res.setReasonForUse(this.parseType("reasonForUse", xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosage")) {
                res.getDosage().add(this.parseMedicationStatementMedicationStatementDosageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationStatement.MedicationStatementDosageComponent parseMedicationStatementMedicationStatementDosageComponent(XmlPullParser xpp, MedicationStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationStatement.MedicationStatementDosageComponent res = new MedicationStatement.MedicationStatementDosageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timing")) {
                res.setTiming(this.parseTiming(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "quantity")) {
                res.setQuantity(this.parseType("quantity", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
                res.setMaxDosePerPeriod(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader parseMessageHeader(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader res = new MessageHeader();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("timestamp")) {
                res.setTimestampElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.setEvent(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseMessageHeaderMessageSourceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("enterer")) {
                res.setEnterer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receiver")) {
                res.setReceiver(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("responsible")) {
                res.setResponsible(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("data")) {
                res.getData().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("details")) {
                res.setDetails(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("software")) {
                res.setSoftwareElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.setContact(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.setEndpointElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.setEndpointElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition parseModuleDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition res = new ModuleDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("model")) {
                res.getModel().add(this.parseModuleDefinitionModuleDefinitionModelComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("library")) {
                res.getLibrary().add(this.parseModuleDefinitionModuleDefinitionLibraryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.getCodeSystem().add(this.parseModuleDefinitionModuleDefinitionCodeSystemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
                res.getValueSet().add(this.parseModuleDefinitionModuleDefinitionValueSetComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseModuleDefinitionModuleDefinitionParameterComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("data")) {
                res.getData().add(this.parseModuleDefinitionModuleDefinitionDataComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionModelComponent parseModuleDefinitionModuleDefinitionModelComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionModelComponent res = new ModuleDefinition.ModuleDefinitionModelComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionLibraryComponent parseModuleDefinitionModuleDefinitionLibraryComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionLibraryComponent res = new ModuleDefinition.ModuleDefinitionLibraryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "document")) {
                res.setDocument(this.parseType("document", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionCodeSystemComponent parseModuleDefinitionModuleDefinitionCodeSystemComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionCodeSystemComponent res = new ModuleDefinition.ModuleDefinitionCodeSystemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionValueSetComponent parseModuleDefinitionModuleDefinitionValueSetComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionValueSetComponent res = new ModuleDefinition.ModuleDefinitionValueSetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.getCodeSystem().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionParameterComponent parseModuleDefinitionModuleDefinitionParameterComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionParameterComponent res = new ModuleDefinition.ModuleDefinitionParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionDataComponent parseModuleDefinitionModuleDefinitionDataComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionDataComponent res = new ModuleDefinition.ModuleDefinitionDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
                res.getMustSupport().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeFilter")) {
                res.getCodeFilter().add(this.parseModuleDefinitionModuleDefinitionDataCodeFilterComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("dateFilter")) {
                res.getDateFilter().add(this.parseModuleDefinitionModuleDefinitionDataDateFilterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionDataCodeFilterComponent parseModuleDefinitionModuleDefinitionDataCodeFilterComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionDataCodeFilterComponent res = new ModuleDefinition.ModuleDefinitionDataCodeFilterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
                res.setValueSet(this.parseType("valueSet", xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeableConcept")) {
                res.getCodeableConcept().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionDataDateFilterComponent parseModuleDefinitionModuleDefinitionDataDateFilterComponent(XmlPullParser xpp, ModuleDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionDataDateFilterComponent res = new ModuleDefinition.ModuleDefinitionDataDateFilterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NamingSystem parseNamingSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem res = new NamingSystem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseNamingSystemNamingSystemContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("responsible")) {
                res.setResponsibleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("usage")) {
                res.setUsageElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uniqueId")) {
                res.getUniqueId().add(this.parseNamingSystemNamingSystemUniqueIdComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("replacedBy")) {
                res.setReplacedBy(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NamingSystem.NamingSystemContactComponent parseNamingSystemNamingSystemContactComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem.NamingSystemContactComponent res = new NamingSystem.NamingSystemContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preferred")) {
                res.setPreferredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder parseNutritionOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder res = new NutritionOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
                res.setDateTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderer")) {
                res.setOrderer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("allergyIntolerance")) {
                res.getAllergyIntolerance().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("foodPreferenceModifier")) {
                res.getFoodPreferenceModifier().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("excludeFoodModifier")) {
                res.getExcludeFoodModifier().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("oralDiet")) {
                res.setOralDiet(this.parseNutritionOrderNutritionOrderOralDietComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("supplement")) {
                res.getSupplement().add(this.parseNutritionOrderNutritionOrderSupplementComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("enteralFormula")) {
                res.setEnteralFormula(this.parseNutritionOrderNutritionOrderEnteralFormulaComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.getSchedule().add(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("nutrient")) {
                res.getNutrient().add(this.parseNutritionOrderNutritionOrderOralDietNutrientComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("texture")) {
                res.getTexture().add(this.parseNutritionOrderNutritionOrderOralDietTextureComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("fluidConsistencyType")) {
                res.getFluidConsistencyType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instruction")) {
                res.setInstructionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.setModifier(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseSimpleQuantity(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.setModifier(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("foodType")) {
                res.setFoodType(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("productName")) {
                res.setProductNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.getSchedule().add(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instruction")) {
                res.setInstructionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("baseFormulaType")) {
                res.setBaseFormulaType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("baseFormulaProductName")) {
                res.setBaseFormulaProductNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additiveType")) {
                res.setAdditiveType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additiveProductName")) {
                res.setAdditiveProductNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("caloricDensity")) {
                res.setCaloricDensity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("routeofAdministration")) {
                res.setRouteofAdministration(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("administration")) {
                res.getAdministration().add(this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("maxVolumeToDeliver")) {
                res.setMaxVolumeToDeliver(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("administrationInstruction")) {
                res.setAdministrationInstructionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation parseObservation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation res = new Observation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
                res.setEffective(this.parseType("effective", xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.getPerformer().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
                res.setDataAbsentReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("interpretation")) {
                res.setInterpretation(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.setSpecimen(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.setDevice(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceRange")) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseObservationObservationRelatedComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("component")) {
                res.getComponent().add(this.parseObservationObservationComponentComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("low")) {
                res.setLow(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("high")) {
                res.setHigh(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("meaning")) {
                res.setMeaning(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("age")) {
                res.setAge(this.parseRange(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
                res.setDataAbsentReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceRange")) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition parseOperationDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition res = new OperationDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseOperationDefinitionOperationDefinitionContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("idempotent")) {
                res.setIdempotentElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBase(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.setInstanceElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition.OperationDefinitionContactComponent parseOperationDefinitionOperationDefinitionContactComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionContactComponent res = new OperationDefinition.OperationDefinitionContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("min")) {
                res.setMinElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("max")) {
                res.setMaxElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("searchType")) {
                res.setSearchTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("binding")) {
                res.setBinding(this.parseOperationDefinitionOperationDefinitionParameterBindingComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("part")) {
                res.getPart().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("strength")) {
                res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
                res.setValueSet(this.parseType("valueSet", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationOutcome parseOperationOutcome(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationOutcome res = new OperationOutcome();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("issue")) {
                res.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(XmlPullParser xpp, OperationOutcome owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("details")) {
                res.setDetails(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnostics")) {
                res.setDiagnosticsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expression")) {
                res.getExpression().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Order parseOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Order res = new Order();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhen(this.parseOrderOrderWhenComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Order.OrderWhenComponent parseOrderOrderWhenComponent(XmlPullParser xpp, Order owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Order.OrderWhenComponent res = new Order.OrderWhenComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseTiming(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OrderResponse parseOrderResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OrderResponse res = new OrderResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("who")) {
                res.setWho(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderStatus")) {
                res.setOrderStatusElement(this.parseEnumeration(xpp, OrderResponse.OrderStatus.NULL, new OrderResponse.OrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fulfillment")) {
                res.getFulfillment().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OrderSet parseOrderSet(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OrderSet res = new OrderSet();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("moduleMetadata")) {
                res.setModuleMetadata(this.parseModuleMetadata(xpp));
            } else if (eventType == 2 && xpp.getName().equals("library")) {
                res.getLibrary().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseActionDefinition(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Organization parseOrganization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Organization res = new Organization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("partOf")) {
                res.setPartOf(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseOrganizationOrganizationContactComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(XmlPullParser xpp, Organization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("purpose")) {
                res.setPurpose(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setName(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddress(this.parseAddress(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient parsePatient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient res = new Patient();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.getName().add(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
                res.setDeceased(this.parseType("deceased", xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("maritalStatus")) {
                res.setMaritalStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "multipleBirth")) {
                res.setMultipleBirth(this.parseType("multipleBirth", xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.getPhoto().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parsePatientContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("animal")) {
                res.setAnimal(this.parsePatientAnimalComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("communication")) {
                res.getCommunication().add(this.parsePatientPatientCommunicationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("careProvider")) {
                res.getCareProvider().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parsePatientPatientLinkComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.ContactComponent parsePatientContactComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.ContactComponent res = new Patient.ContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.getRelationship().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setName(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddress(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.AnimalComponent parsePatientAnimalComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.AnimalComponent res = new Patient.AnimalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("species")) {
                res.setSpecies(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("breed")) {
                res.setBreed(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("genderStatus")) {
                res.setGenderStatus(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguage(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preferred")) {
                res.setPreferredElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("other")) {
                res.setOther(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentNotice parsePaymentNotice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentNotice res = new PaymentNotice();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "provider")) {
                res.setProvider(this.parseType("provider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "request")) {
                res.setRequest(this.parseType("request", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "response")) {
                res.setResponse(this.parseType("response", xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentStatus")) {
                res.setPaymentStatus(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
                res.setStatusDateElement(this.parseDate(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentReconciliation parsePaymentReconciliation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation res = new PaymentReconciliation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "request")) {
                res.setRequest(this.parseType("request", xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestProvider")) {
                res.setRequestProvider(this.parseType("requestProvider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestOrganization")) {
                res.setRequestOrganization(this.parseType("requestOrganization", xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parsePaymentReconciliationDetailsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("total")) {
                res.setTotal(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parsePaymentReconciliationNotesComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "request")) {
                res.setRequest(this.parseType("request", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "responce")) {
                res.setResponce(this.parseType("responce", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "submitter")) {
                res.setSubmitter(this.parseType("submitter", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "payee")) {
                res.setPayee(this.parseType("payee", xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Person parsePerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Person res = new Person();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.getName().add(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.setPhoto(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parsePersonPersonLinkComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Person.PersonLinkComponent parsePersonPersonLinkComponent(XmlPullParser xpp, Person owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Person.PersonLinkComponent res = new Person.PersonLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assurance")) {
                res.setAssuranceElement(this.parseEnumeration(xpp, Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Practitioner parsePractitioner(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner res = new Practitioner();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.getName().add(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.getPhoto().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("practitionerRole")) {
                res.getPractitionerRole().add(this.parsePractitionerPractitionerPractitionerRoleComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("qualification")) {
                res.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("communication")) {
                res.getCommunication().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Practitioner.PractitionerPractitionerRoleComponent parsePractitionerPractitionerPractitionerRoleComponent(XmlPullParser xpp, Practitioner owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner.PractitionerPractitionerRoleComponent res = new Practitioner.PractitionerPractitionerRoleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("healthcareService")) {
                res.getHealthcareService().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(XmlPullParser xpp, Practitioner owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("issuer")) {
                res.setIssuer(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PractitionerRole parsePractitionerRole(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PractitionerRole res = new PractitionerRole();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("practitioner")) {
                res.setPractitioner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("healthcareService")) {
                res.getHealthcareService().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableTime")) {
                res.getAvailableTime().add(this.parsePractitionerRolePractitionerRoleAvailableTimeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("notAvailable")) {
                res.getNotAvailable().add(this.parsePractitionerRolePractitionerRoleNotAvailableComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("availabilityExceptions")) {
                res.setAvailabilityExceptionsElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PractitionerRole.PractitionerRoleAvailableTimeComponent parsePractitionerRolePractitionerRoleAvailableTimeComponent(XmlPullParser xpp, PractitionerRole owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PractitionerRole.PractitionerRoleAvailableTimeComponent res = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
                res.getDaysOfWeek().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("allDay")) {
                res.setAllDayElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableStartTime")) {
                res.setAvailableStartTimeElement(this.parseTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableEndTime")) {
                res.setAvailableEndTimeElement(this.parseTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PractitionerRole.PractitionerRoleNotAvailableComponent parsePractitionerRolePractitionerRoleNotAvailableComponent(XmlPullParser xpp, PractitionerRole owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PractitionerRole.PractitionerRoleNotAvailableComponent res = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("during")) {
                res.setDuring(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Procedure parseProcedure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure res = new Procedure();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notPerformed")) {
                res.setNotPerformedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotPerformed")) {
                res.getReasonNotPerformed().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.getBodySite().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.getPerformer().add(this.parseProcedureProcedurePerformerComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "performed")) {
                res.setPerformed(this.parseType("performed", xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("report")) {
                res.getReport().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("complication")) {
                res.getComplication().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("followUp")) {
                res.getFollowUp().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("focalDevice")) {
                res.getFocalDevice().add(this.parseProcedureProcedureFocalDeviceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("used")) {
                res.getUsed().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.setAction(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manipulated")) {
                res.setManipulated(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcedureRequest parseProcedureRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcedureRequest res = new ProcedureRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.getBodySite().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
                res.setScheduled(this.parseType("scheduled", xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedOn")) {
                res.setOrderedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderer")) {
                res.setOrderer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseEnumeration(xpp, ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessRequest parseProcessRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessRequest res = new ProcessRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.setActionElement(this.parseEnumeration(xpp, ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "provider")) {
                res.setProvider(this.parseType("provider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "request")) {
                res.setRequest(this.parseType("request", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "response")) {
                res.setResponse(this.parseType("response", xpp));
            } else if (eventType == 2 && xpp.getName().equals("nullify")) {
                res.setNullifyElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseProcessRequestItemsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("include")) {
                res.getInclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.getExclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(XmlPullParser xpp, ProcessRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parseInteger(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessResponse parseProcessResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessResponse res = new ProcessResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "request")) {
                res.setRequest(this.parseType("request", xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "organization")) {
                res.setOrganization(this.parseType("organization", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestProvider")) {
                res.setRequestProvider(this.parseType("requestProvider", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "requestOrganization")) {
                res.setRequestOrganization(this.parseType("requestOrganization", xpp));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseProcessResponseProcessResponseNotesComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("error")) {
                res.getError().add(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessResponse.ProcessResponseNotesComponent parseProcessResponseProcessResponseNotesComponent(XmlPullParser xpp, ProcessResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessResponse.ProcessResponseNotesComponent res = new ProcessResponse.ProcessResponseNotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol parseProtocol(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol res = new Protocol();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Protocol.ProtocolStatus.NULL, new Protocol.ProtocolStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Protocol.ProtocolType.NULL, new Protocol.ProtocolTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.setGroup(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("purpose")) {
                res.setPurposeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("step")) {
                res.getStep().add(this.parseProtocolProtocolStepComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol.ProtocolStepComponent parseProtocolProtocolStepComponent(XmlPullParser xpp, Protocol owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol.ProtocolStepComponent res = new Protocol.ProtocolStepComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDuration(this.parseDuration(xpp));
            } else if (eventType == 2 && xpp.getName().equals("precondition")) {
                res.setPrecondition(this.parseProtocolProtocolStepPreconditionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("exit")) {
                res.setExit(this.parseProtocolProtocolStepPreconditionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("firstActivity")) {
                res.setFirstActivityElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("activity")) {
                res.getActivity().add(this.parseProtocolProtocolStepActivityComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("next")) {
                res.getNext().add(this.parseProtocolProtocolStepNextComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol.ProtocolStepPreconditionComponent parseProtocolProtocolStepPreconditionComponent(XmlPullParser xpp, Protocol owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol.ProtocolStepPreconditionComponent res = new Protocol.ProtocolStepPreconditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.setCondition(this.parseProtocolProtocolStepPreconditionConditionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("intersection")) {
                res.getIntersection().add(this.parseProtocolProtocolStepPreconditionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("union")) {
                res.getUnion().add(this.parseProtocolProtocolStepPreconditionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.getExclude().add(this.parseProtocolProtocolStepPreconditionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol.ProtocolStepPreconditionConditionComponent parseProtocolProtocolStepPreconditionConditionComponent(XmlPullParser xpp, Protocol owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol.ProtocolStepPreconditionConditionComponent res = new Protocol.ProtocolStepPreconditionConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol.ProtocolStepActivityComponent parseProtocolProtocolStepActivityComponent(XmlPullParser xpp, Protocol owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol.ProtocolStepActivityComponent res = new Protocol.ProtocolStepActivityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("alternative")) {
                res.getAlternative().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("component")) {
                res.getComponent().add(this.parseProtocolProtocolStepActivityComponentComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("following")) {
                res.getFollowing().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("wait")) {
                res.setWait(this.parseDuration(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.setDetail(this.parseProtocolProtocolStepActivityDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol.ProtocolStepActivityComponentComponent parseProtocolProtocolStepActivityComponentComponent(XmlPullParser xpp, Protocol owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol.ProtocolStepActivityComponentComponent res = new Protocol.ProtocolStepActivityComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("activity")) {
                res.setActivityElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol.ProtocolStepActivityDetailComponent parseProtocolProtocolStepActivityDetailComponent(XmlPullParser xpp, Protocol owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol.ProtocolStepActivityDetailComponent res = new Protocol.ProtocolStepActivityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, Protocol.ActivityDefinitionCategory.NULL, new Protocol.ActivityDefinitionCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
                res.setTiming(this.parseType("timing", xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.getPerformer().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("product")) {
                res.setProduct(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Protocol.ProtocolStepNextComponent parseProtocolProtocolStepNextComponent(XmlPullParser xpp, Protocol owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Protocol.ProtocolStepNextComponent res = new Protocol.ProtocolStepNextComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.setCondition(this.parseProtocolProtocolStepPreconditionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance parseProvenance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance res = new Provenance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recorded")) {
                res.setRecordedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("activity")) {
                res.setActivity(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("policy")) {
                res.getPolicy().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("agent")) {
                res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("entity")) {
                res.getEntity().add(this.parseProvenanceProvenanceEntityComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("signature")) {
                res.getSignature().add(this.parseSignature(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("userId")) {
                res.setUserId(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatedAgent")) {
                res.getRelatedAgent().add(this.parseProvenanceProvenanceAgentRelatedAgentComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance.ProvenanceAgentRelatedAgentComponent parseProvenanceProvenanceAgentRelatedAgentComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceAgentRelatedAgentComponent res = new Provenance.ProvenanceAgentRelatedAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTargetElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRoleElement(this.parseEnumeration(xpp, Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("agent")) {
                res.setAgent(this.parseProvenanceProvenanceAgentComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Questionnaire parseQuestionnaire(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire res = new Questionnaire();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Questionnaire.QuestionnaireStatus.NULL, new Questionnaire.QuestionnaireStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subjectType")) {
                res.getSubjectType().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Questionnaire.QuestionnaireItemComponent parseQuestionnaireQuestionnaireItemComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemComponent res = new Questionnaire.QuestionnaireItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("linkId")) {
                res.setLinkIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prefix")) {
                res.setPrefixElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Questionnaire.QuestionnaireItemType.NULL, new Questionnaire.QuestionnaireItemTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("enableWhen")) {
                res.getEnableWhen().add(this.parseQuestionnaireQuestionnaireItemEnableWhenComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("repeats")) {
                res.setRepeatsElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("readOnly")) {
                res.setReadOnlyElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxLength")) {
                res.setMaxLengthElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("options")) {
                res.setOptions(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("option")) {
                res.getOption().add(this.parseQuestionnaireQuestionnaireItemOptionComponent(xpp, owner));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "initial")) {
                res.setInitial(this.parseType("initial", xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Questionnaire.QuestionnaireItemEnableWhenComponent parseQuestionnaireQuestionnaireItemEnableWhenComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemEnableWhenComponent res = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("question")) {
                res.setQuestionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("answered")) {
                res.setAnsweredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "answer")) {
                res.setAnswer(this.parseType("answer", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Questionnaire.QuestionnaireItemOptionComponent parseQuestionnaireQuestionnaireItemOptionComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemOptionComponent res = new Questionnaire.QuestionnaireItemOptionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected QuestionnaireResponse parseQuestionnaireResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse res = new QuestionnaireResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("questionnaire")) {
                res.setQuestionnaire(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authored")) {
                res.setAuthoredElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemComponent parseQuestionnaireResponseQuestionnaireResponseItemComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionnaireResponseItemComponent res = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("linkId")) {
                res.setLinkIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("answer")) {
                res.getAnswer().add(this.parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ReferralRequest parseReferralRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ReferralRequest res = new ReferralRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
                res.getBasedOn().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.setParent(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ReferralRequest.ReferralStatus.NULL, new ReferralRequest.ReferralStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, ReferralRequest.ReferralCategory.NULL, new ReferralRequest.ReferralCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.setContext(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fulfillmentTime")) {
                res.setFulfillmentTime(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authored")) {
                res.setAuthoredElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requester")) {
                res.setRequester(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.setSpecialty(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceRequested")) {
                res.getServiceRequested().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
                res.getSupportingInformation().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected RelatedPerson parseRelatedPerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RelatedPerson res = new RelatedPerson();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setName(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.getPhoto().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected RiskAssessment parseRiskAssessment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RiskAssessment res = new RiskAssessment();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.setCondition(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("basis")) {
                res.getBasis().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prediction")) {
                res.getPrediction().add(this.parseRiskAssessmentRiskAssessmentPredictionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
                res.setMitigationElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(XmlPullParser xpp, RiskAssessment owner) throws XmlPullParserException, IOException, FHIRFormatError {
        RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "probability")) {
                res.setProbability(this.parseType("probability", xpp));
            } else if (eventType == 2 && xpp.getName().equals("relativeRisk")) {
                res.setRelativeRiskElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "when")) {
                res.setWhen(this.parseType("when", xpp));
            } else if (eventType == 2 && xpp.getName().equals("rationale")) {
                res.setRationaleElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Schedule parseSchedule(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Schedule res = new Schedule();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
                res.setServiceCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
                res.getServiceType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("planningHorizon")) {
                res.setPlanningHorizon(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SearchParameter parseSearchParameter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SearchParameter res = new SearchParameter();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseSearchParameterSearchParameterContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBaseElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expression")) {
                res.setExpressionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("xpath")) {
                res.setXpathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("xpathUsage")) {
                res.setXpathUsageElement(this.parseEnumeration(xpp, SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseCode(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SearchParameter.SearchParameterContactComponent parseSearchParameterSearchParameterContactComponent(XmlPullParser xpp, SearchParameter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SearchParameter.SearchParameterContactComponent res = new SearchParameter.SearchParameterContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence parseSequence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence res = new Sequence();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Sequence.SequenceType.NULL, new Sequence.SequenceTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.setSpecimen(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.setDevice(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("species")) {
                res.setSpecies(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceSeq")) {
                res.getReferenceSeq().add(this.parseSequenceSequenceReferenceSeqComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("variation")) {
                res.setVariation(this.parseSequenceSequenceVariationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("quality")) {
                res.getQuality().add(this.parseSequenceSequenceQualityComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("allelicState")) {
                res.setAllelicState(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("allelicFrequency")) {
                res.setAllelicFrequencyElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyNumberEvent")) {
                res.setCopyNumberEvent(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("readCoverage")) {
                res.setReadCoverageElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("repository")) {
                res.getRepository().add(this.parseSequenceSequenceRepositoryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("pointer")) {
                res.getPointer().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("observedSeq")) {
                res.setObservedSeqElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("observation")) {
                res.setObservation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("structureVariation")) {
                res.setStructureVariation(this.parseSequenceSequenceStructureVariationComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence.SequenceReferenceSeqComponent parseSequenceSequenceReferenceSeqComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceReferenceSeqComponent res = new Sequence.SequenceReferenceSeqComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("chromosome")) {
                res.setChromosome(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("genomeBuild")) {
                res.setGenomeBuildElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceSeqId")) {
                res.setReferenceSeqId(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceSeqPointer")) {
                res.setReferenceSeqPointer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceSeqString")) {
                res.setReferenceSeqStringElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("windowStart")) {
                res.setWindowStartElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("windowEnd")) {
                res.setWindowEndElement(this.parseInteger(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence.SequenceVariationComponent parseSequenceSequenceVariationComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceVariationComponent res = new Sequence.SequenceVariationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("observedAllele")) {
                res.setObservedAlleleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceAllele")) {
                res.setReferenceAlleleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("cigar")) {
                res.setCigarElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence.SequenceQualityComponent parseSequenceSequenceQualityComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceQualityComponent res = new Sequence.SequenceQualityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("score")) {
                res.setScore(this.parseQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethodElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence.SequenceRepositoryComponent parseSequenceSequenceRepositoryComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceRepositoryComponent res = new Sequence.SequenceRepositoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("variantId")) {
                res.setVariantIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("readId")) {
                res.setReadIdElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence.SequenceStructureVariationComponent parseSequenceSequenceStructureVariationComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceStructureVariationComponent res = new Sequence.SequenceStructureVariationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("precisionOfBoundaries")) {
                res.setPrecisionOfBoundariesElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reportedaCGHRatio")) {
                res.setReportedaCGHRatioElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("length")) {
                res.setLengthElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outer")) {
                res.setOuter(this.parseSequenceSequenceStructureVariationOuterComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("inner")) {
                res.setInner(this.parseSequenceSequenceStructureVariationInnerComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence.SequenceStructureVariationOuterComponent parseSequenceSequenceStructureVariationOuterComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceStructureVariationOuterComponent res = new Sequence.SequenceStructureVariationOuterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInteger(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Sequence.SequenceStructureVariationInnerComponent parseSequenceSequenceStructureVariationInnerComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceStructureVariationInnerComponent res = new Sequence.SequenceStructureVariationInnerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInteger(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Slot parseSlot(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Slot res = new Slot();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
                res.setServiceCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
                res.getServiceType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("appointmentType")) {
                res.setAppointmentType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("overbooked")) {
                res.setOverbookedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen parseSpecimen(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen res = new Specimen();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accessionIdentifier")) {
                res.setAccessionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Specimen.SpecimenStatus.NULL, new Specimen.SpecimenStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receivedTime")) {
                res.setReceivedTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.getParent().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("collection")) {
                res.setCollection(this.parseSpecimenSpecimenCollectionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("treatment")) {
                res.getTreatment().add(this.parseSpecimenSpecimenTreatmentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("container")) {
                res.getContainer().add(this.parseSpecimenSpecimenContainerComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("collector")) {
                res.setCollector(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "collected")) {
                res.setCollected(this.parseType("collected", xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen.SpecimenTreatmentComponent parseSpecimenSpecimenTreatmentComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenTreatmentComponent res = new Specimen.SpecimenTreatmentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("procedure")) {
                res.setProcedure(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additive")) {
                res.getAdditive().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("capacity")) {
                res.setCapacity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimenQuantity")) {
                res.setSpecimenQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "additive")) {
                res.setAdditive(this.parseType("additive", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition parseStructureDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition res = new StructureDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseStructureDefinitionStructureDefinitionContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.getCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
                res.setFhirVersionElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mapping")) {
                res.getMapping().add(this.parseStructureDefinitionStructureDefinitionMappingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, StructureDefinition.StructureDefinitionKind.NULL, new StructureDefinition.StructureDefinitionKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("abstract")) {
                res.setAbstractElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contextType")) {
                res.setContextTypeElement(this.parseEnumeration(xpp, StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.getContext().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("baseType")) {
                res.setBaseTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("baseDefinition")) {
                res.setBaseDefinitionElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("derivation")) {
                res.setDerivationElement(this.parseEnumeration(xpp, StructureDefinition.TypeDerivationRule.NULL, new StructureDefinition.TypeDerivationRuleEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("snapshot")) {
                res.setSnapshot(this.parseStructureDefinitionStructureDefinitionSnapshotComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("differential")) {
                res.setDifferential(this.parseStructureDefinitionStructureDefinitionDifferentialComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionContactComponent parseStructureDefinitionStructureDefinitionContactComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionContactComponent res = new StructureDefinition.StructureDefinitionContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identity")) {
                res.setIdentityElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uri")) {
                res.setUriElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseElementDefinition(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseElementDefinition(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap parseStructureMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap res = new StructureMap();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseStructureMapStructureMapContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("structure")) {
                res.getStructure().add(this.parseStructureMapStructureMapStructureComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("import")) {
                res.getImport().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseStructureMapStructureMapGroupComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapContactComponent parseStructureMapStructureMapContactComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapContactComponent res = new StructureMap.StructureMapContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapStructureComponent parseStructureMapStructureMapStructureComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapStructureComponent res = new StructureMap.StructureMapStructureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, StructureMap.StructureMapModelMode.NULL, new StructureMap.StructureMapModelModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapGroupComponent parseStructureMapStructureMapGroupComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupComponent res = new StructureMap.StructureMapGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extends")) {
                res.setExtendsElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("input")) {
                res.getInput().add(this.parseStructureMapStructureMapGroupInputComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.getRule().add(this.parseStructureMapStructureMapGroupRuleComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapGroupInputComponent parseStructureMapStructureMapGroupInputComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupInputComponent res = new StructureMap.StructureMapGroupInputComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, StructureMap.StructureMapInputMode.NULL, new StructureMap.StructureMapInputModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapGroupRuleComponent parseStructureMapStructureMapGroupRuleComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleComponent res = new StructureMap.StructureMapGroupRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.getSource().add(this.parseStructureMapStructureMapGroupRuleSourceComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseStructureMapStructureMapGroupRuleTargetComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.getRule().add(this.parseStructureMapStructureMapGroupRuleComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("dependent")) {
                res.getDependent().add(this.parseStructureMapStructureMapGroupRuleDependentComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapGroupRuleSourceComponent parseStructureMapStructureMapGroupRuleSourceComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleSourceComponent res = new StructureMap.StructureMapGroupRuleSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.setContextElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contextType")) {
                res.setContextTypeElement(this.parseEnumeration(xpp, StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("element")) {
                res.setElementElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("listMode")) {
                res.setListModeElement(this.parseEnumeration(xpp, StructureMap.StructureMapListMode.NULL, new StructureMap.StructureMapListModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("variable")) {
                res.setVariableElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.setConditionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("check")) {
                res.setCheckElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapGroupRuleTargetComponent parseStructureMapStructureMapGroupRuleTargetComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleTargetComponent res = new StructureMap.StructureMapGroupRuleTargetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("context")) {
                res.setContextElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contextType")) {
                res.setContextTypeElement(this.parseEnumeration(xpp, StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("element")) {
                res.setElementElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("variable")) {
                res.setVariableElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("listMode")) {
                res.getListMode().add(this.parseEnumeration(xpp, StructureMap.StructureMapListMode.NULL, new StructureMap.StructureMapListModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("listRuleId")) {
                res.setListRuleIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("transform")) {
                res.setTransformElement(this.parseEnumeration(xpp, StructureMap.StructureMapTransform.NULL, new StructureMap.StructureMapTransformEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseStructureMapStructureMapGroupRuleTargetParameterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapGroupRuleTargetParameterComponent parseStructureMapStructureMapGroupRuleTargetParameterComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleTargetParameterComponent res = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureMap.StructureMapGroupRuleDependentComponent parseStructureMapStructureMapGroupRuleDependentComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleDependentComponent res = new StructureMap.StructureMapGroupRuleDependentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("variable")) {
                res.getVariable().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Subscription parseSubscription(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Subscription res = new Subscription();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("criteria")) {
                res.setCriteriaElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReasonElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Subscription.SubscriptionStatus.NULL, new Subscription.SubscriptionStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("error")) {
                res.setErrorElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("channel")) {
                res.setChannel(this.parseSubscriptionSubscriptionChannelComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("tag")) {
                res.getTag().add(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(XmlPullParser xpp, Subscription owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Subscription.SubscriptionChannelType.NULL, new Subscription.SubscriptionChannelTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.setEndpointElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payload")) {
                res.setPayloadElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("header")) {
                res.setHeaderElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Substance parseSubstance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance res = new Substance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.getCategory().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.getInstance().add(this.parseSubstanceSubstanceInstanceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
                res.getIngredient().add(this.parseSubstanceSubstanceIngredientComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expiry")) {
                res.setExpiryElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseRatio(xpp));
            } else if (eventType == 2 && xpp.getName().equals("substance")) {
                res.setSubstance(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SupplyDelivery parseSupplyDelivery(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyDelivery res = new SupplyDelivery();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, SupplyDelivery.SupplyDeliveryStatus.NULL, new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("suppliedItem")) {
                res.setSuppliedItem(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supplier")) {
                res.setSupplier(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenPrepared")) {
                res.setWhenPrepared(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestination(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receiver")) {
                res.getReceiver().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SupplyRequest parseSupplyRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyRequest res = new SupplyRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, SupplyRequest.SupplyRequestStatus.NULL, new SupplyRequest.SupplyRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKind(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedItem")) {
                res.setOrderedItem(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supplier")) {
                res.getSupplier().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhen(this.parseSupplyRequestSupplyRequestWhenComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SupplyRequest.SupplyRequestWhenComponent parseSupplyRequestSupplyRequestWhenComponent(XmlPullParser xpp, SupplyRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyRequest.SupplyRequestWhenComponent res = new SupplyRequest.SupplyRequestWhenComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseTiming(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Task parseTask(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Task res = new Task();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performerType")) {
                res.getPerformerType().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseEnumeration(xpp, Task.TaskPriority.NULL, new Task.TaskPriorityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Task.TaskStatus.NULL, new Task.TaskStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("failureReason")) {
                res.setFailureReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("for")) {
                res.setFor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastModified")) {
                res.setLastModifiedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("creator")) {
                res.setCreator(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("owner")) {
                res.setOwner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.setParent(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("input")) {
                res.getInput().add(this.parseTaskParameterComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("output")) {
                res.getOutput().add(this.parseTaskTaskOutputComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Task.ParameterComponent parseTaskParameterComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Task.ParameterComponent res = new Task.ParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Task.TaskOutputComponent parseTaskTaskOutputComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Task.TaskOutputComponent res = new Task.TaskOutputComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript parseTestScript(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript res = new TestScript();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseTestScriptTestScriptContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("origin")) {
                res.getOrigin().add(this.parseTestScriptTestScriptOriginComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.getDestination().add(this.parseTestScriptTestScriptDestinationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("metadata")) {
                res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("fixture")) {
                res.getFixture().add(this.parseTestScriptTestScriptFixtureComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("variable")) {
                res.getVariable().add(this.parseTestScriptTestScriptVariableComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.getRule().add(this.parseTestScriptTestScriptRuleComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.getRuleset().add(this.parseTestScriptTestScriptRulesetComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("setup")) {
                res.setSetup(this.parseTestScriptTestScriptSetupComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("test")) {
                res.getTest().add(this.parseTestScriptTestScriptTestComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("teardown")) {
                res.setTeardown(this.parseTestScriptTestScriptTeardownComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptContactComponent parseTestScriptTestScriptContactComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptContactComponent res = new TestScript.TestScriptContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptOriginComponent parseTestScriptTestScriptOriginComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptOriginComponent res = new TestScript.TestScriptOriginComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("index")) {
                res.setIndexElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptDestinationComponent parseTestScriptTestScriptDestinationComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptDestinationComponent res = new TestScript.TestScriptDestinationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("index")) {
                res.setIndexElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseTestScriptTestScriptMetadataLinkComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("capability")) {
                res.getCapability().add(this.parseTestScriptTestScriptMetadataCapabilityComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("validated")) {
                res.setValidatedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("origin")) {
                res.getOrigin().add(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestinationElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conformance")) {
                res.setConformance(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("autocreate")) {
                res.setAutocreateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("autodelete")) {
                res.setAutodeleteElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("defaultValue")) {
                res.setDefaultValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("headerField")) {
                res.setHeaderFieldElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
                res.setSourceIdElement(this.parseId(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptRuleComponent parseTestScriptTestScriptRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptRuleComponent res = new TestScript.TestScriptRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("param")) {
                res.getParam().add(this.parseTestScriptTestScriptRuleParamComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptRuleParamComponent parseTestScriptTestScriptRuleParamComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptRuleParamComponent res = new TestScript.TestScriptRuleParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptRulesetComponent parseTestScriptTestScriptRulesetComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptRulesetComponent res = new TestScript.TestScriptRulesetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.getRule().add(this.parseTestScriptTestScriptRulesetRuleComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptRulesetRuleComponent parseTestScriptTestScriptRulesetRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptRulesetRuleComponent res = new TestScript.TestScriptRulesetRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("ruleId")) {
                res.setRuleIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("param")) {
                res.getParam().add(this.parseTestScriptTestScriptRulesetRuleParamComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptRulesetRuleParamComponent parseTestScriptTestScriptRulesetRuleParamComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptRulesetRuleParamComponent res = new TestScript.TestScriptRulesetRuleParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptSetupComponent parseTestScriptTestScriptSetupComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptSetupComponent res = new TestScript.TestScriptSetupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("metadata")) {
                res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseTestScriptSetupActionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionComponent parseTestScriptSetupActionComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionComponent res = new TestScript.SetupActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("operation")) {
                res.setOperation(this.parseTestScriptSetupActionOperationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("assert")) {
                res.setAssert(this.parseTestScriptSetupActionAssertComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionOperationComponent parseTestScriptSetupActionOperationComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionOperationComponent res = new TestScript.SetupActionOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResourceElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accept")) {
                res.setAcceptElement(this.parseEnumeration(xpp, TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseEnumeration(xpp, TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestinationElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encodeRequestUrl")) {
                res.setEncodeRequestUrlElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("origin")) {
                res.setOriginElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("params")) {
                res.setParamsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestHeader")) {
                res.getRequestHeader().add(this.parseTestScriptSetupActionOperationRequestHeaderComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("responseId")) {
                res.setResponseIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
                res.setSourceIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("targetId")) {
                res.setTargetIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionOperationRequestHeaderComponent parseTestScriptSetupActionOperationRequestHeaderComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionOperationRequestHeaderComponent res = new TestScript.SetupActionOperationRequestHeaderComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("field")) {
                res.setFieldElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionAssertComponent parseTestScriptSetupActionAssertComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionAssertComponent res = new TestScript.SetupActionAssertComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("direction")) {
                res.setDirectionElement(this.parseEnumeration(xpp, TestScript.AssertionDirectionType.NULL, new TestScript.AssertionDirectionTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("compareToSourceId")) {
                res.setCompareToSourceIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("compareToSourcePath")) {
                res.setCompareToSourcePathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseEnumeration(xpp, TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("headerField")) {
                res.setHeaderFieldElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("minimumId")) {
                res.setMinimumIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("navigationLinks")) {
                res.setNavigationLinksElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operator")) {
                res.setOperatorElement(this.parseEnumeration(xpp, TestScript.AssertionOperatorType.NULL, new TestScript.AssertionOperatorTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResourceElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponseElement(this.parseEnumeration(xpp, TestScript.AssertionResponseTypes.NULL, new TestScript.AssertionResponseTypesEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("responseCode")) {
                res.setResponseCodeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.setRule(this.parseTestScriptSetupActionAssertRuleComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseTestScriptSetupActionAssertRulesetComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
                res.setSourceIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("validateProfileId")) {
                res.setValidateProfileIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("warningOnly")) {
                res.setWarningOnlyElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionAssertRuleComponent parseTestScriptSetupActionAssertRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionAssertRuleComponent res = new TestScript.SetupActionAssertRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("ruleId")) {
                res.setRuleIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("param")) {
                res.getParam().add(this.parseTestScriptSetupActionAssertRuleParamComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionAssertRuleParamComponent parseTestScriptSetupActionAssertRuleParamComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionAssertRuleParamComponent res = new TestScript.SetupActionAssertRuleParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionAssertRulesetComponent parseTestScriptSetupActionAssertRulesetComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionAssertRulesetComponent res = new TestScript.SetupActionAssertRulesetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("rulesetId")) {
                res.setRulesetIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.getRule().add(this.parseTestScriptSetupActionAssertRulesetRuleComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionAssertRulesetRuleComponent parseTestScriptSetupActionAssertRulesetRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionAssertRulesetRuleComponent res = new TestScript.SetupActionAssertRulesetRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("ruleId")) {
                res.setRuleIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("param")) {
                res.getParam().add(this.parseTestScriptSetupActionAssertRulesetRuleParamComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.SetupActionAssertRulesetRuleParamComponent parseTestScriptSetupActionAssertRulesetRuleParamComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionAssertRulesetRuleParamComponent res = new TestScript.SetupActionAssertRulesetRuleParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptTestComponent parseTestScriptTestScriptTestComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptTestComponent res = new TestScript.TestScriptTestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("metadata")) {
                res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseTestScriptTestActionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestActionComponent parseTestScriptTestActionComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestActionComponent res = new TestScript.TestActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("operation")) {
                res.setOperation(this.parseTestScriptSetupActionOperationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("assert")) {
                res.setAssert(this.parseTestScriptSetupActionAssertComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptTeardownComponent parseTestScriptTestScriptTeardownComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptTeardownComponent res = new TestScript.TestScriptTeardownComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseTestScriptTeardownActionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TeardownActionComponent parseTestScriptTeardownActionComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TeardownActionComponent res = new TestScript.TeardownActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("operation")) {
                res.setOperation(this.parseTestScriptSetupActionOperationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet parseValueSet(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet res = new ValueSet();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseValueSetValueSetContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lockedDate")) {
                res.setLockedDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("immutable")) {
                res.setImmutableElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extensible")) {
                res.setExtensibleElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("compose")) {
                res.setCompose(this.parseValueSetValueSetComposeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("expansion")) {
                res.setExpansion(this.parseValueSetValueSetExpansionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetContactComponent parseValueSetValueSetContactComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetContactComponent res = new ValueSet.ValueSetContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetComposeComponent res = new ValueSet.ValueSetComposeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("import")) {
                res.getImport().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("include")) {
                res.getInclude().add(this.parseValueSetConceptSetComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.getExclude().add(this.parseValueSetConceptSetComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptSetComponent res = new ValueSet.ConceptSetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseValueSetConceptReferenceComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("filter")) {
                res.getFilter().add(this.parseValueSetConceptSetFilterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptReferenceComponent parseValueSetConceptReferenceComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptReferenceComponent res = new ValueSet.ConceptReferenceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("designation")) {
                res.getDesignation().add(this.parseValueSetConceptReferenceDesignationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptReferenceDesignationComponent parseValueSetConceptReferenceDesignationComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptReferenceDesignationComponent res = new ValueSet.ConceptReferenceDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUse(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptSetFilterComponent res = new ValueSet.ConceptSetFilterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("property")) {
                res.setPropertyElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("op")) {
                res.setOpElement(this.parseEnumeration(xpp, ValueSet.FilterOperator.NULL, new ValueSet.FilterOperatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseCode(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionComponent res = new ValueSet.ValueSetExpansionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timestamp")) {
                res.setTimestampElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("total")) {
                res.setTotalElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("offset")) {
                res.setOffsetElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseValueSetValueSetExpansionParameterComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("contains")) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetExpansionParameterComponent parseValueSetValueSetExpansionParameterComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionParameterComponent res = new ValueSet.ValueSetExpansionParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("abstract")) {
                res.setAbstractElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contains")) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected VisionPrescription parseVisionPrescription(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VisionPrescription res = new VisionPrescription();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateWritten")) {
                res.setDateWrittenElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prescriber")) {
                res.setPrescriber(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dispense")) {
                res.getDispense().add(this.parseVisionPrescriptionVisionPrescriptionDispenseComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected VisionPrescription.VisionPrescriptionDispenseComponent parseVisionPrescriptionVisionPrescriptionDispenseComponent(XmlPullParser xpp, VisionPrescription owner) throws XmlPullParserException, IOException, FHIRFormatError {
        VisionPrescription.VisionPrescriptionDispenseComponent res = new VisionPrescription.VisionPrescriptionDispenseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("product")) {
                res.setProduct(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("eye")) {
                res.setEyeElement(this.parseEnumeration(xpp, VisionPrescription.VisionEyes.NULL, new VisionPrescription.VisionEyesEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("sphere")) {
                res.setSphereElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("cylinder")) {
                res.setCylinderElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("axis")) {
                res.setAxisElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prism")) {
                res.setPrismElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBaseElement(this.parseEnumeration(xpp, VisionPrescription.VisionBase.NULL, new VisionPrescription.VisionBaseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("add")) {
                res.setAddElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("power")) {
                res.setPowerElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("backCurve")) {
                res.setBackCurveElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diameter")) {
                res.setDiameterElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDuration(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("color")) {
                res.setColorElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("brand")) {
                res.setBrandElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.setNotesElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    @Override
    protected Resource parseResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (xpp.getName().equals("Parameters")) {
            return this.parseParameters(xpp);
        }
        if (xpp.getName().equals("Account")) {
            return this.parseAccount(xpp);
        }
        if (xpp.getName().equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(xpp);
        }
        if (xpp.getName().equals("Appointment")) {
            return this.parseAppointment(xpp);
        }
        if (xpp.getName().equals("AppointmentResponse")) {
            return this.parseAppointmentResponse(xpp);
        }
        if (xpp.getName().equals("AuditEvent")) {
            return this.parseAuditEvent(xpp);
        }
        if (xpp.getName().equals("Basic")) {
            return this.parseBasic(xpp);
        }
        if (xpp.getName().equals("Binary")) {
            return this.parseBinary(xpp);
        }
        if (xpp.getName().equals("BodySite")) {
            return this.parseBodySite(xpp);
        }
        if (xpp.getName().equals("Bundle")) {
            return this.parseBundle(xpp);
        }
        if (xpp.getName().equals("CarePlan")) {
            return this.parseCarePlan(xpp);
        }
        if (xpp.getName().equals("CareTeam")) {
            return this.parseCareTeam(xpp);
        }
        if (xpp.getName().equals("Claim")) {
            return this.parseClaim(xpp);
        }
        if (xpp.getName().equals("ClaimResponse")) {
            return this.parseClaimResponse(xpp);
        }
        if (xpp.getName().equals("ClinicalImpression")) {
            return this.parseClinicalImpression(xpp);
        }
        if (xpp.getName().equals("CodeSystem")) {
            return this.parseCodeSystem(xpp);
        }
        if (xpp.getName().equals("Communication")) {
            return this.parseCommunication(xpp);
        }
        if (xpp.getName().equals("CommunicationRequest")) {
            return this.parseCommunicationRequest(xpp);
        }
        if (xpp.getName().equals("CompartmentDefinition")) {
            return this.parseCompartmentDefinition(xpp);
        }
        if (xpp.getName().equals("Composition")) {
            return this.parseComposition(xpp);
        }
        if (xpp.getName().equals("ConceptMap")) {
            return this.parseConceptMap(xpp);
        }
        if (xpp.getName().equals("Condition")) {
            return this.parseCondition(xpp);
        }
        if (xpp.getName().equals("Conformance")) {
            return this.parseConformance(xpp);
        }
        if (xpp.getName().equals("Contract")) {
            return this.parseContract(xpp);
        }
        if (xpp.getName().equals("Coverage")) {
            return this.parseCoverage(xpp);
        }
        if (xpp.getName().equals("DataElement")) {
            return this.parseDataElement(xpp);
        }
        if (xpp.getName().equals("DecisionSupportRule")) {
            return this.parseDecisionSupportRule(xpp);
        }
        if (xpp.getName().equals("DecisionSupportServiceModule")) {
            return this.parseDecisionSupportServiceModule(xpp);
        }
        if (xpp.getName().equals("DetectedIssue")) {
            return this.parseDetectedIssue(xpp);
        }
        if (xpp.getName().equals("Device")) {
            return this.parseDevice(xpp);
        }
        if (xpp.getName().equals("DeviceComponent")) {
            return this.parseDeviceComponent(xpp);
        }
        if (xpp.getName().equals("DeviceMetric")) {
            return this.parseDeviceMetric(xpp);
        }
        if (xpp.getName().equals("DeviceUseRequest")) {
            return this.parseDeviceUseRequest(xpp);
        }
        if (xpp.getName().equals("DeviceUseStatement")) {
            return this.parseDeviceUseStatement(xpp);
        }
        if (xpp.getName().equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(xpp);
        }
        if (xpp.getName().equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(xpp);
        }
        if (xpp.getName().equals("DocumentManifest")) {
            return this.parseDocumentManifest(xpp);
        }
        if (xpp.getName().equals("DocumentReference")) {
            return this.parseDocumentReference(xpp);
        }
        if (xpp.getName().equals("EligibilityRequest")) {
            return this.parseEligibilityRequest(xpp);
        }
        if (xpp.getName().equals("EligibilityResponse")) {
            return this.parseEligibilityResponse(xpp);
        }
        if (xpp.getName().equals("Encounter")) {
            return this.parseEncounter(xpp);
        }
        if (xpp.getName().equals("EnrollmentRequest")) {
            return this.parseEnrollmentRequest(xpp);
        }
        if (xpp.getName().equals("EnrollmentResponse")) {
            return this.parseEnrollmentResponse(xpp);
        }
        if (xpp.getName().equals("EpisodeOfCare")) {
            return this.parseEpisodeOfCare(xpp);
        }
        if (xpp.getName().equals("ExpansionProfile")) {
            return this.parseExpansionProfile(xpp);
        }
        if (xpp.getName().equals("ExplanationOfBenefit")) {
            return this.parseExplanationOfBenefit(xpp);
        }
        if (xpp.getName().equals("FamilyMemberHistory")) {
            return this.parseFamilyMemberHistory(xpp);
        }
        if (xpp.getName().equals("Flag")) {
            return this.parseFlag(xpp);
        }
        if (xpp.getName().equals("Goal")) {
            return this.parseGoal(xpp);
        }
        if (xpp.getName().equals("Group")) {
            return this.parseGroup(xpp);
        }
        if (xpp.getName().equals("GuidanceResponse")) {
            return this.parseGuidanceResponse(xpp);
        }
        if (xpp.getName().equals("HealthcareService")) {
            return this.parseHealthcareService(xpp);
        }
        if (xpp.getName().equals("ImagingExcerpt")) {
            return this.parseImagingExcerpt(xpp);
        }
        if (xpp.getName().equals("ImagingObjectSelection")) {
            return this.parseImagingObjectSelection(xpp);
        }
        if (xpp.getName().equals("ImagingStudy")) {
            return this.parseImagingStudy(xpp);
        }
        if (xpp.getName().equals("Immunization")) {
            return this.parseImmunization(xpp);
        }
        if (xpp.getName().equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(xpp);
        }
        if (xpp.getName().equals("ImplementationGuide")) {
            return this.parseImplementationGuide(xpp);
        }
        if (xpp.getName().equals("Library")) {
            return this.parseLibrary(xpp);
        }
        if (xpp.getName().equals("Linkage")) {
            return this.parseLinkage(xpp);
        }
        if (xpp.getName().equals("List")) {
            return this.parseListResource(xpp);
        }
        if (xpp.getName().equals("Location")) {
            return this.parseLocation(xpp);
        }
        if (xpp.getName().equals("Measure")) {
            return this.parseMeasure(xpp);
        }
        if (xpp.getName().equals("MeasureReport")) {
            return this.parseMeasureReport(xpp);
        }
        if (xpp.getName().equals("Media")) {
            return this.parseMedia(xpp);
        }
        if (xpp.getName().equals("Medication")) {
            return this.parseMedication(xpp);
        }
        if (xpp.getName().equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(xpp);
        }
        if (xpp.getName().equals("MedicationDispense")) {
            return this.parseMedicationDispense(xpp);
        }
        if (xpp.getName().equals("MedicationOrder")) {
            return this.parseMedicationOrder(xpp);
        }
        if (xpp.getName().equals("MedicationStatement")) {
            return this.parseMedicationStatement(xpp);
        }
        if (xpp.getName().equals("MessageHeader")) {
            return this.parseMessageHeader(xpp);
        }
        if (xpp.getName().equals("ModuleDefinition")) {
            return this.parseModuleDefinition(xpp);
        }
        if (xpp.getName().equals("NamingSystem")) {
            return this.parseNamingSystem(xpp);
        }
        if (xpp.getName().equals("NutritionOrder")) {
            return this.parseNutritionOrder(xpp);
        }
        if (xpp.getName().equals("Observation")) {
            return this.parseObservation(xpp);
        }
        if (xpp.getName().equals("OperationDefinition")) {
            return this.parseOperationDefinition(xpp);
        }
        if (xpp.getName().equals("OperationOutcome")) {
            return this.parseOperationOutcome(xpp);
        }
        if (xpp.getName().equals("Order")) {
            return this.parseOrder(xpp);
        }
        if (xpp.getName().equals("OrderResponse")) {
            return this.parseOrderResponse(xpp);
        }
        if (xpp.getName().equals("OrderSet")) {
            return this.parseOrderSet(xpp);
        }
        if (xpp.getName().equals("Organization")) {
            return this.parseOrganization(xpp);
        }
        if (xpp.getName().equals("Patient")) {
            return this.parsePatient(xpp);
        }
        if (xpp.getName().equals("PaymentNotice")) {
            return this.parsePaymentNotice(xpp);
        }
        if (xpp.getName().equals("PaymentReconciliation")) {
            return this.parsePaymentReconciliation(xpp);
        }
        if (xpp.getName().equals("Person")) {
            return this.parsePerson(xpp);
        }
        if (xpp.getName().equals("Practitioner")) {
            return this.parsePractitioner(xpp);
        }
        if (xpp.getName().equals("PractitionerRole")) {
            return this.parsePractitionerRole(xpp);
        }
        if (xpp.getName().equals("Procedure")) {
            return this.parseProcedure(xpp);
        }
        if (xpp.getName().equals("ProcedureRequest")) {
            return this.parseProcedureRequest(xpp);
        }
        if (xpp.getName().equals("ProcessRequest")) {
            return this.parseProcessRequest(xpp);
        }
        if (xpp.getName().equals("ProcessResponse")) {
            return this.parseProcessResponse(xpp);
        }
        if (xpp.getName().equals("Protocol")) {
            return this.parseProtocol(xpp);
        }
        if (xpp.getName().equals("Provenance")) {
            return this.parseProvenance(xpp);
        }
        if (xpp.getName().equals("Questionnaire")) {
            return this.parseQuestionnaire(xpp);
        }
        if (xpp.getName().equals("QuestionnaireResponse")) {
            return this.parseQuestionnaireResponse(xpp);
        }
        if (xpp.getName().equals("ReferralRequest")) {
            return this.parseReferralRequest(xpp);
        }
        if (xpp.getName().equals("RelatedPerson")) {
            return this.parseRelatedPerson(xpp);
        }
        if (xpp.getName().equals("RiskAssessment")) {
            return this.parseRiskAssessment(xpp);
        }
        if (xpp.getName().equals("Schedule")) {
            return this.parseSchedule(xpp);
        }
        if (xpp.getName().equals("SearchParameter")) {
            return this.parseSearchParameter(xpp);
        }
        if (xpp.getName().equals("Sequence")) {
            return this.parseSequence(xpp);
        }
        if (xpp.getName().equals("Slot")) {
            return this.parseSlot(xpp);
        }
        if (xpp.getName().equals("Specimen")) {
            return this.parseSpecimen(xpp);
        }
        if (xpp.getName().equals("StructureDefinition")) {
            return this.parseStructureDefinition(xpp);
        }
        if (xpp.getName().equals("StructureMap")) {
            return this.parseStructureMap(xpp);
        }
        if (xpp.getName().equals("Subscription")) {
            return this.parseSubscription(xpp);
        }
        if (xpp.getName().equals("Substance")) {
            return this.parseSubstance(xpp);
        }
        if (xpp.getName().equals("SupplyDelivery")) {
            return this.parseSupplyDelivery(xpp);
        }
        if (xpp.getName().equals("SupplyRequest")) {
            return this.parseSupplyRequest(xpp);
        }
        if (xpp.getName().equals("Task")) {
            return this.parseTask(xpp);
        }
        if (xpp.getName().equals("TestScript")) {
            return this.parseTestScript(xpp);
        }
        if (xpp.getName().equals("ValueSet")) {
            return this.parseValueSet(xpp);
        }
        if (xpp.getName().equals("VisionPrescription")) {
            return this.parseVisionPrescription(xpp);
        }
        if (xpp.getName().equals("Binary")) {
            return this.parseBinary(xpp);
        }
        throw new FHIRFormatError("Unknown resource type " + xpp.getName() + "");
    }

    protected Type parseType(String prefix, XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (xpp.getName().equals(prefix + "markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (xpp.getName().equals(prefix + "integer")) {
            return this.parseInteger(xpp);
        }
        if (xpp.getName().equals(prefix + "dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (xpp.getName().equals(prefix + "unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (xpp.getName().equals(prefix + "code")) {
            return this.parseCode(xpp);
        }
        if (xpp.getName().equals(prefix + "date")) {
            return this.parseDate(xpp);
        }
        if (xpp.getName().equals(prefix + "decimal")) {
            return this.parseDecimal(xpp);
        }
        if (xpp.getName().equals(prefix + "uri")) {
            return this.parseUri(xpp);
        }
        if (xpp.getName().equals(prefix + "id")) {
            return this.parseId(xpp);
        }
        if (xpp.getName().equals(prefix + "base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (xpp.getName().equals(prefix + "time")) {
            return this.parseTime(xpp);
        }
        if (xpp.getName().equals(prefix + "oid")) {
            return this.parseOid(xpp);
        }
        if (xpp.getName().equals(prefix + "positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (xpp.getName().equals(prefix + "string")) {
            return this.parseString(xpp);
        }
        if (xpp.getName().equals(prefix + "boolean")) {
            return this.parseBoolean(xpp);
        }
        if (xpp.getName().equals(prefix + "uuid")) {
            return this.parseUuid(xpp);
        }
        if (xpp.getName().equals(prefix + "instant")) {
            return this.parseInstant(xpp);
        }
        if (xpp.getName().equals(prefix + "Extension")) {
            return this.parseExtension(xpp);
        }
        if (xpp.getName().equals(prefix + "Narrative")) {
            return this.parseNarrative(xpp);
        }
        if (xpp.getName().equals(prefix + "Period")) {
            return this.parsePeriod(xpp);
        }
        if (xpp.getName().equals(prefix + "Coding")) {
            return this.parseCoding(xpp);
        }
        if (xpp.getName().equals(prefix + "Range")) {
            return this.parseRange(xpp);
        }
        if (xpp.getName().equals(prefix + "Quantity")) {
            return this.parseQuantity(xpp);
        }
        if (xpp.getName().equals(prefix + "Attachment")) {
            return this.parseAttachment(xpp);
        }
        if (xpp.getName().equals(prefix + "Ratio")) {
            return this.parseRatio(xpp);
        }
        if (xpp.getName().equals(prefix + "Annotation")) {
            return this.parseAnnotation(xpp);
        }
        if (xpp.getName().equals(prefix + "SampledData")) {
            return this.parseSampledData(xpp);
        }
        if (xpp.getName().equals(prefix + "Reference")) {
            return this.parseReference(xpp);
        }
        if (xpp.getName().equals(prefix + "CodeableConcept")) {
            return this.parseCodeableConcept(xpp);
        }
        if (xpp.getName().equals(prefix + "Identifier")) {
            return this.parseIdentifier(xpp);
        }
        if (xpp.getName().equals(prefix + "Signature")) {
            return this.parseSignature(xpp);
        }
        if (xpp.getName().equals(prefix + "Age")) {
            return this.parseAge(xpp);
        }
        if (xpp.getName().equals(prefix + "Count")) {
            return this.parseCount(xpp);
        }
        if (xpp.getName().equals(prefix + "Money")) {
            return this.parseMoney(xpp);
        }
        if (xpp.getName().equals(prefix + "Distance")) {
            return this.parseDistance(xpp);
        }
        if (xpp.getName().equals(prefix + "Duration")) {
            return this.parseDuration(xpp);
        }
        if (xpp.getName().equals(prefix + "SimpleQuantity")) {
            return this.parseSimpleQuantity(xpp);
        }
        if (xpp.getName().equals(prefix + "TriggerDefinition")) {
            return this.parseTriggerDefinition(xpp);
        }
        if (xpp.getName().equals(prefix + "ElementDefinition")) {
            return this.parseElementDefinition(xpp);
        }
        if (xpp.getName().equals(prefix + "Timing")) {
            return this.parseTiming(xpp);
        }
        if (xpp.getName().equals(prefix + "ModuleMetadata")) {
            return this.parseModuleMetadata(xpp);
        }
        if (xpp.getName().equals(prefix + "ActionDefinition")) {
            return this.parseActionDefinition(xpp);
        }
        if (xpp.getName().equals(prefix + "Address")) {
            return this.parseAddress(xpp);
        }
        if (xpp.getName().equals(prefix + "HumanName")) {
            return this.parseHumanName(xpp);
        }
        if (xpp.getName().equals(prefix + "DataRequirement")) {
            return this.parseDataRequirement(xpp);
        }
        if (xpp.getName().equals(prefix + "Meta")) {
            return this.parseMeta(xpp);
        }
        if (xpp.getName().equals(prefix + "ParameterDefinition")) {
            return this.parseParameterDefinition(xpp);
        }
        if (xpp.getName().equals(prefix + "ContactPoint")) {
            return this.parseContactPoint(xpp);
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return this.parseInteger(xpp);
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return this.parseDateTime(xpp);
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return this.parseCode(xpp);
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return this.parseDate(xpp);
        }
        if (xpp.getName().equals(prefix + "Decimal")) {
            return this.parseDecimal(xpp);
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return this.parseUri(xpp);
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return this.parseId(xpp);
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return this.parseTime(xpp);
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return this.parseOid(xpp);
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (xpp.getName().equals(prefix + "String")) {
            return this.parseString(xpp);
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return this.parseBoolean(xpp);
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return this.parseUuid(xpp);
        }
        if (xpp.getName().equals(prefix + "Instant")) {
            return this.parseInstant(xpp);
        }
        throw new FHIRFormatError("Unknown type " + xpp.getName());
    }

    @Override
    protected Type parseType(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        if (type.equals("Extension")) {
            return this.parseExtension(xpp);
        }
        if (type.equals("Narrative")) {
            return this.parseNarrative(xpp);
        }
        if (type.equals("Period")) {
            return this.parsePeriod(xpp);
        }
        if (type.equals("Coding")) {
            return this.parseCoding(xpp);
        }
        if (type.equals("Range")) {
            return this.parseRange(xpp);
        }
        if (type.equals("Quantity")) {
            return this.parseQuantity(xpp);
        }
        if (type.equals("Attachment")) {
            return this.parseAttachment(xpp);
        }
        if (type.equals("Ratio")) {
            return this.parseRatio(xpp);
        }
        if (type.equals("Annotation")) {
            return this.parseAnnotation(xpp);
        }
        if (type.equals("SampledData")) {
            return this.parseSampledData(xpp);
        }
        if (type.equals("Reference")) {
            return this.parseReference(xpp);
        }
        if (type.equals("CodeableConcept")) {
            return this.parseCodeableConcept(xpp);
        }
        if (type.equals("Identifier")) {
            return this.parseIdentifier(xpp);
        }
        if (type.equals("Signature")) {
            return this.parseSignature(xpp);
        }
        if (type.equals("Age")) {
            return this.parseAge(xpp);
        }
        if (type.equals("Count")) {
            return this.parseCount(xpp);
        }
        if (type.equals("Money")) {
            return this.parseMoney(xpp);
        }
        if (type.equals("Distance")) {
            return this.parseDistance(xpp);
        }
        if (type.equals("Duration")) {
            return this.parseDuration(xpp);
        }
        if (type.equals("SimpleQuantity")) {
            return this.parseSimpleQuantity(xpp);
        }
        if (type.equals("TriggerDefinition")) {
            return this.parseTriggerDefinition(xpp);
        }
        if (type.equals("ElementDefinition")) {
            return this.parseElementDefinition(xpp);
        }
        if (type.equals("Timing")) {
            return this.parseTiming(xpp);
        }
        if (type.equals("ModuleMetadata")) {
            return this.parseModuleMetadata(xpp);
        }
        if (type.equals("ActionDefinition")) {
            return this.parseActionDefinition(xpp);
        }
        if (type.equals("Address")) {
            return this.parseAddress(xpp);
        }
        if (type.equals("HumanName")) {
            return this.parseHumanName(xpp);
        }
        if (type.equals("DataRequirement")) {
            return this.parseDataRequirement(xpp);
        }
        if (type.equals("Meta")) {
            return this.parseMeta(xpp);
        }
        if (type.equals("ParameterDefinition")) {
            return this.parseParameterDefinition(xpp);
        }
        if (type.equals("ContactPoint")) {
            return this.parseContactPoint(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    public Base parseFragment(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type.equals("Extension")) {
            return this.parseExtension(xpp);
        }
        if (type.equals("Narrative")) {
            return this.parseNarrative(xpp);
        }
        if (type.equals("Period")) {
            return this.parsePeriod(xpp);
        }
        if (type.equals("Coding")) {
            return this.parseCoding(xpp);
        }
        if (type.equals("Range")) {
            return this.parseRange(xpp);
        }
        if (type.equals("Quantity")) {
            return this.parseQuantity(xpp);
        }
        if (type.equals("Attachment")) {
            return this.parseAttachment(xpp);
        }
        if (type.equals("Ratio")) {
            return this.parseRatio(xpp);
        }
        if (type.equals("Annotation")) {
            return this.parseAnnotation(xpp);
        }
        if (type.equals("SampledData")) {
            return this.parseSampledData(xpp);
        }
        if (type.equals("Reference")) {
            return this.parseReference(xpp);
        }
        if (type.equals("CodeableConcept")) {
            return this.parseCodeableConcept(xpp);
        }
        if (type.equals("Identifier")) {
            return this.parseIdentifier(xpp);
        }
        if (type.equals("Signature")) {
            return this.parseSignature(xpp);
        }
        if (type.equals("Age")) {
            return this.parseAge(xpp);
        }
        if (type.equals("Count")) {
            return this.parseCount(xpp);
        }
        if (type.equals("Money")) {
            return this.parseMoney(xpp);
        }
        if (type.equals("Distance")) {
            return this.parseDistance(xpp);
        }
        if (type.equals("Duration")) {
            return this.parseDuration(xpp);
        }
        if (type.equals("SimpleQuantity")) {
            return this.parseSimpleQuantity(xpp);
        }
        if (type.equals("TriggerDefinition")) {
            return this.parseTriggerDefinition(xpp);
        }
        if (type.equals("ElementDefinition")) {
            return this.parseElementDefinition(xpp);
        }
        if (type.equals("Timing")) {
            return this.parseTiming(xpp);
        }
        if (type.equals("ModuleMetadata")) {
            return this.parseModuleMetadata(xpp);
        }
        if (type.equals("ActionDefinition")) {
            return this.parseActionDefinition(xpp);
        }
        if (type.equals("Address")) {
            return this.parseAddress(xpp);
        }
        if (type.equals("HumanName")) {
            return this.parseHumanName(xpp);
        }
        if (type.equals("DataRequirement")) {
            return this.parseDataRequirement(xpp);
        }
        if (type.equals("Meta")) {
            return this.parseMeta(xpp);
        }
        if (type.equals("ParameterDefinition")) {
            return this.parseParameterDefinition(xpp);
        }
        if (type.equals("ContactPoint")) {
            return this.parseContactPoint(xpp);
        }
        if (type.equals("Parameters")) {
            return this.parseParameters(xpp);
        }
        if (type.equals("Account")) {
            return this.parseAccount(xpp);
        }
        if (type.equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(xpp);
        }
        if (type.equals("Appointment")) {
            return this.parseAppointment(xpp);
        }
        if (type.equals("AppointmentResponse")) {
            return this.parseAppointmentResponse(xpp);
        }
        if (type.equals("AuditEvent")) {
            return this.parseAuditEvent(xpp);
        }
        if (type.equals("Basic")) {
            return this.parseBasic(xpp);
        }
        if (type.equals("Binary")) {
            return this.parseBinary(xpp);
        }
        if (type.equals("BodySite")) {
            return this.parseBodySite(xpp);
        }
        if (type.equals("Bundle")) {
            return this.parseBundle(xpp);
        }
        if (type.equals("CarePlan")) {
            return this.parseCarePlan(xpp);
        }
        if (type.equals("CareTeam")) {
            return this.parseCareTeam(xpp);
        }
        if (type.equals("Claim")) {
            return this.parseClaim(xpp);
        }
        if (type.equals("ClaimResponse")) {
            return this.parseClaimResponse(xpp);
        }
        if (type.equals("ClinicalImpression")) {
            return this.parseClinicalImpression(xpp);
        }
        if (type.equals("CodeSystem")) {
            return this.parseCodeSystem(xpp);
        }
        if (type.equals("Communication")) {
            return this.parseCommunication(xpp);
        }
        if (type.equals("CommunicationRequest")) {
            return this.parseCommunicationRequest(xpp);
        }
        if (type.equals("CompartmentDefinition")) {
            return this.parseCompartmentDefinition(xpp);
        }
        if (type.equals("Composition")) {
            return this.parseComposition(xpp);
        }
        if (type.equals("ConceptMap")) {
            return this.parseConceptMap(xpp);
        }
        if (type.equals("Condition")) {
            return this.parseCondition(xpp);
        }
        if (type.equals("Conformance")) {
            return this.parseConformance(xpp);
        }
        if (type.equals("Contract")) {
            return this.parseContract(xpp);
        }
        if (type.equals("Coverage")) {
            return this.parseCoverage(xpp);
        }
        if (type.equals("DataElement")) {
            return this.parseDataElement(xpp);
        }
        if (type.equals("DecisionSupportRule")) {
            return this.parseDecisionSupportRule(xpp);
        }
        if (type.equals("DecisionSupportServiceModule")) {
            return this.parseDecisionSupportServiceModule(xpp);
        }
        if (type.equals("DetectedIssue")) {
            return this.parseDetectedIssue(xpp);
        }
        if (type.equals("Device")) {
            return this.parseDevice(xpp);
        }
        if (type.equals("DeviceComponent")) {
            return this.parseDeviceComponent(xpp);
        }
        if (type.equals("DeviceMetric")) {
            return this.parseDeviceMetric(xpp);
        }
        if (type.equals("DeviceUseRequest")) {
            return this.parseDeviceUseRequest(xpp);
        }
        if (type.equals("DeviceUseStatement")) {
            return this.parseDeviceUseStatement(xpp);
        }
        if (type.equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(xpp);
        }
        if (type.equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(xpp);
        }
        if (type.equals("DocumentManifest")) {
            return this.parseDocumentManifest(xpp);
        }
        if (type.equals("DocumentReference")) {
            return this.parseDocumentReference(xpp);
        }
        if (type.equals("EligibilityRequest")) {
            return this.parseEligibilityRequest(xpp);
        }
        if (type.equals("EligibilityResponse")) {
            return this.parseEligibilityResponse(xpp);
        }
        if (type.equals("Encounter")) {
            return this.parseEncounter(xpp);
        }
        if (type.equals("EnrollmentRequest")) {
            return this.parseEnrollmentRequest(xpp);
        }
        if (type.equals("EnrollmentResponse")) {
            return this.parseEnrollmentResponse(xpp);
        }
        if (type.equals("EpisodeOfCare")) {
            return this.parseEpisodeOfCare(xpp);
        }
        if (type.equals("ExpansionProfile")) {
            return this.parseExpansionProfile(xpp);
        }
        if (type.equals("ExplanationOfBenefit")) {
            return this.parseExplanationOfBenefit(xpp);
        }
        if (type.equals("FamilyMemberHistory")) {
            return this.parseFamilyMemberHistory(xpp);
        }
        if (type.equals("Flag")) {
            return this.parseFlag(xpp);
        }
        if (type.equals("Goal")) {
            return this.parseGoal(xpp);
        }
        if (type.equals("Group")) {
            return this.parseGroup(xpp);
        }
        if (type.equals("GuidanceResponse")) {
            return this.parseGuidanceResponse(xpp);
        }
        if (type.equals("HealthcareService")) {
            return this.parseHealthcareService(xpp);
        }
        if (type.equals("ImagingExcerpt")) {
            return this.parseImagingExcerpt(xpp);
        }
        if (type.equals("ImagingObjectSelection")) {
            return this.parseImagingObjectSelection(xpp);
        }
        if (type.equals("ImagingStudy")) {
            return this.parseImagingStudy(xpp);
        }
        if (type.equals("Immunization")) {
            return this.parseImmunization(xpp);
        }
        if (type.equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(xpp);
        }
        if (type.equals("ImplementationGuide")) {
            return this.parseImplementationGuide(xpp);
        }
        if (type.equals("Library")) {
            return this.parseLibrary(xpp);
        }
        if (type.equals("Linkage")) {
            return this.parseLinkage(xpp);
        }
        if (type.equals("List")) {
            return this.parseListResource(xpp);
        }
        if (type.equals("Location")) {
            return this.parseLocation(xpp);
        }
        if (type.equals("Measure")) {
            return this.parseMeasure(xpp);
        }
        if (type.equals("MeasureReport")) {
            return this.parseMeasureReport(xpp);
        }
        if (type.equals("Media")) {
            return this.parseMedia(xpp);
        }
        if (type.equals("Medication")) {
            return this.parseMedication(xpp);
        }
        if (type.equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(xpp);
        }
        if (type.equals("MedicationDispense")) {
            return this.parseMedicationDispense(xpp);
        }
        if (type.equals("MedicationOrder")) {
            return this.parseMedicationOrder(xpp);
        }
        if (type.equals("MedicationStatement")) {
            return this.parseMedicationStatement(xpp);
        }
        if (type.equals("MessageHeader")) {
            return this.parseMessageHeader(xpp);
        }
        if (type.equals("ModuleDefinition")) {
            return this.parseModuleDefinition(xpp);
        }
        if (type.equals("NamingSystem")) {
            return this.parseNamingSystem(xpp);
        }
        if (type.equals("NutritionOrder")) {
            return this.parseNutritionOrder(xpp);
        }
        if (type.equals("Observation")) {
            return this.parseObservation(xpp);
        }
        if (type.equals("OperationDefinition")) {
            return this.parseOperationDefinition(xpp);
        }
        if (type.equals("OperationOutcome")) {
            return this.parseOperationOutcome(xpp);
        }
        if (type.equals("Order")) {
            return this.parseOrder(xpp);
        }
        if (type.equals("OrderResponse")) {
            return this.parseOrderResponse(xpp);
        }
        if (type.equals("OrderSet")) {
            return this.parseOrderSet(xpp);
        }
        if (type.equals("Organization")) {
            return this.parseOrganization(xpp);
        }
        if (type.equals("Patient")) {
            return this.parsePatient(xpp);
        }
        if (type.equals("PaymentNotice")) {
            return this.parsePaymentNotice(xpp);
        }
        if (type.equals("PaymentReconciliation")) {
            return this.parsePaymentReconciliation(xpp);
        }
        if (type.equals("Person")) {
            return this.parsePerson(xpp);
        }
        if (type.equals("Practitioner")) {
            return this.parsePractitioner(xpp);
        }
        if (type.equals("PractitionerRole")) {
            return this.parsePractitionerRole(xpp);
        }
        if (type.equals("Procedure")) {
            return this.parseProcedure(xpp);
        }
        if (type.equals("ProcedureRequest")) {
            return this.parseProcedureRequest(xpp);
        }
        if (type.equals("ProcessRequest")) {
            return this.parseProcessRequest(xpp);
        }
        if (type.equals("ProcessResponse")) {
            return this.parseProcessResponse(xpp);
        }
        if (type.equals("Protocol")) {
            return this.parseProtocol(xpp);
        }
        if (type.equals("Provenance")) {
            return this.parseProvenance(xpp);
        }
        if (type.equals("Questionnaire")) {
            return this.parseQuestionnaire(xpp);
        }
        if (type.equals("QuestionnaireResponse")) {
            return this.parseQuestionnaireResponse(xpp);
        }
        if (type.equals("ReferralRequest")) {
            return this.parseReferralRequest(xpp);
        }
        if (type.equals("RelatedPerson")) {
            return this.parseRelatedPerson(xpp);
        }
        if (type.equals("RiskAssessment")) {
            return this.parseRiskAssessment(xpp);
        }
        if (type.equals("Schedule")) {
            return this.parseSchedule(xpp);
        }
        if (type.equals("SearchParameter")) {
            return this.parseSearchParameter(xpp);
        }
        if (type.equals("Sequence")) {
            return this.parseSequence(xpp);
        }
        if (type.equals("Slot")) {
            return this.parseSlot(xpp);
        }
        if (type.equals("Specimen")) {
            return this.parseSpecimen(xpp);
        }
        if (type.equals("StructureDefinition")) {
            return this.parseStructureDefinition(xpp);
        }
        if (type.equals("StructureMap")) {
            return this.parseStructureMap(xpp);
        }
        if (type.equals("Subscription")) {
            return this.parseSubscription(xpp);
        }
        if (type.equals("Substance")) {
            return this.parseSubstance(xpp);
        }
        if (type.equals("SupplyDelivery")) {
            return this.parseSupplyDelivery(xpp);
        }
        if (type.equals("SupplyRequest")) {
            return this.parseSupplyRequest(xpp);
        }
        if (type.equals("Task")) {
            return this.parseTask(xpp);
        }
        if (type.equals("TestScript")) {
            return this.parseTestScript(xpp);
        }
        if (type.equals("ValueSet")) {
            return this.parseValueSet(xpp);
        }
        if (type.equals("VisionPrescription")) {
            return this.parseVisionPrescription(xpp);
        }
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    private boolean nameIsTypeName(XmlPullParser xpp, String prefix) {
        if (xpp.getName().equals(prefix + "Period")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Coding")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Range")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Quantity")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Attachment")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Ratio")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Annotation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SampledData")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Reference")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CodeableConcept")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Identifier")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Signature")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Age")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Count")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Money")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Distance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Duration")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SimpleQuantity")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TriggerDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ElementDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Timing")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ModuleMetadata")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ActionDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Address")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "HumanName")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DataRequirement")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Meta")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ParameterDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ContactPoint")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Parameters")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Account")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AllergyIntolerance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Appointment")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AppointmentResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AuditEvent")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Basic")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Binary")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "BodySite")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Bundle")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CarePlan")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CareTeam")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Claim")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ClaimResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ClinicalImpression")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CodeSystem")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Communication")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CommunicationRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CompartmentDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Composition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ConceptMap")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Condition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Conformance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Contract")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Coverage")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DataElement")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DecisionSupportRule")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DecisionSupportServiceModule")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DetectedIssue")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Device")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceComponent")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceMetric")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceUseRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceUseStatement")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DiagnosticOrder")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DiagnosticReport")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DocumentManifest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DocumentReference")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EligibilityRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EligibilityResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Encounter")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EnrollmentRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EnrollmentResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EpisodeOfCare")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ExpansionProfile")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ExplanationOfBenefit")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "FamilyMemberHistory")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Flag")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Goal")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Group")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "GuidanceResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "HealthcareService")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImagingExcerpt")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImagingObjectSelection")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImagingStudy")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Immunization")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImmunizationRecommendation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImplementationGuide")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Library")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Linkage")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "List")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Location")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Measure")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MeasureReport")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Media")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Medication")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationAdministration")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationDispense")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationOrder")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationStatement")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MessageHeader")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ModuleDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "NamingSystem")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "NutritionOrder")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Observation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OperationDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OperationOutcome")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Order")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OrderResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OrderSet")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Organization")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Patient")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PaymentNotice")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PaymentReconciliation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Person")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Practitioner")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PractitionerRole")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Procedure")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ProcedureRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ProcessRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ProcessResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Protocol")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Provenance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Questionnaire")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "QuestionnaireResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ReferralRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "RelatedPerson")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "RiskAssessment")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Schedule")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SearchParameter")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Sequence")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Slot")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Specimen")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "StructureDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "StructureMap")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Subscription")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Substance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SupplyDelivery")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SupplyRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Task")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TestScript")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ValueSet")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VisionPrescription")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Decimal")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "String")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return true;
        }
        return xpp.getName().equals(prefix + "Instant");
    }

    protected void composeElementElements(Element element) throws IOException {
        for (Extension e : element.getExtension()) {
            this.composeExtension("extension", e);
        }
    }

    protected void composeBackboneElements(BackboneElement element) throws IOException {
        this.composeElementElements(element);
        for (Extension e : element.getModifierExtension()) {
            this.composeExtension("modifierExtension", e);
        }
    }

    protected <E extends Enum<E>> void composeEnumeration(String name, Enumeration<E> value, EnumFactory e) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.getValue() != null) {
                this.xml.attribute("value", e.toCode((Enum)value.getValue()));
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMarkdown(String name, MarkdownType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeInteger(String name, IntegerType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDateTime(String name, DateTimeType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeUnsignedInt(String name, UnsignedIntType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCode(String name, CodeType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDate(String name, DateType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDecimal(String name, DecimalType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeUri(String name, UriType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeId(String name, IdType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString(value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBase64Binary(String name, Base64BinaryType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTime(String name, TimeType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeOid(String name, OidType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePositiveInt(String name, PositiveIntType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    @Override
    protected void composeString(String name, StringType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBoolean(String name, BooleanType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeUuid(String name, UuidType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeInstant(String name, InstantType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeExtension(String name, Extension element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            if (element.hasUrlElement()) {
                this.xml.attribute("url", (String)element.getUrlElement().getValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValue()) {
                this.composeType("value", element.getValue());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeNarrative(String name, Narrative element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory());
            }
            if (element.hasDiv()) {
                this.composeXhtml("div", element.getDiv());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePeriod(String name, Period element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasStartElement()) {
                this.composeDateTime("start", element.getStartElement());
            }
            if (element.hasEndElement()) {
                this.composeDateTime("end", element.getEndElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCoding(String name, Coding element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            if (element.hasDisplayElement()) {
                this.composeString("display", element.getDisplayElement());
            }
            if (element.hasUserSelectedElement()) {
                this.composeBoolean("userSelected", element.getUserSelectedElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeRange(String name, Range element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasLow()) {
                this.composeSimpleQuantity("low", element.getLow());
            }
            if (element.hasHigh()) {
                this.composeSimpleQuantity("high", element.getHigh());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeQuantity(String name, Quantity element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAttachment(String name, Attachment element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasContentTypeElement()) {
                this.composeCode("contentType", element.getContentTypeElement());
            }
            if (element.hasLanguageElement()) {
                this.composeCode("language", element.getLanguageElement());
            }
            if (element.hasDataElement()) {
                this.composeBase64Binary("data", element.getDataElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasSizeElement()) {
                this.composeUnsignedInt("size", element.getSizeElement());
            }
            if (element.hasHashElement()) {
                this.composeBase64Binary("hash", element.getHashElement());
            }
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasCreationElement()) {
                this.composeDateTime("creation", element.getCreationElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeRatio(String name, Ratio element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasNumerator()) {
                this.composeQuantity("numerator", element.getNumerator());
            }
            if (element.hasDenominator()) {
                this.composeQuantity("denominator", element.getDenominator());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAnnotation(String name, Annotation element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasAuthor()) {
                this.composeType("author", element.getAuthor());
            }
            if (element.hasTimeElement()) {
                this.composeDateTime("time", element.getTimeElement());
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeSampledData(String name, SampledData element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasOrigin()) {
                this.composeSimpleQuantity("origin", element.getOrigin());
            }
            if (element.hasPeriodElement()) {
                this.composeDecimal("period", element.getPeriodElement());
            }
            if (element.hasFactorElement()) {
                this.composeDecimal("factor", element.getFactorElement());
            }
            if (element.hasLowerLimitElement()) {
                this.composeDecimal("lowerLimit", element.getLowerLimitElement());
            }
            if (element.hasUpperLimitElement()) {
                this.composeDecimal("upperLimit", element.getUpperLimitElement());
            }
            if (element.hasDimensionsElement()) {
                this.composePositiveInt("dimensions", element.getDimensionsElement());
            }
            if (element.hasDataElement()) {
                this.composeString("data", element.getDataElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeReference(String name, Reference element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasReferenceElement()) {
                this.composeString("reference", element.getReferenceElement());
            }
            if (element.hasDisplayElement()) {
                this.composeString("display", element.getDisplayElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCodeableConcept(String name, CodeableConcept element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasCoding()) {
                for (Coding e : element.getCoding()) {
                    this.composeCoding("coding", e);
                }
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeIdentifier(String name, Identifier element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new Identifier.IdentifierUseEnumFactory());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasValueElement()) {
                this.composeString("value", element.getValueElement());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasAssigner()) {
                this.composeReference("assigner", element.getAssigner());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeSignature(String name, Signature element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasType()) {
                for (Coding e : element.getType()) {
                    this.composeCoding("type", e);
                }
            }
            if (element.hasWhenElement()) {
                this.composeInstant("when", element.getWhenElement());
            }
            if (element.hasWho()) {
                this.composeType("who", element.getWho());
            }
            if (element.hasContentTypeElement()) {
                this.composeCode("contentType", element.getContentTypeElement());
            }
            if (element.hasBlobElement()) {
                this.composeBase64Binary("blob", element.getBlobElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAge(String name, Age element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCount(String name, Count element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMoney(String name, Money element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDistance(String name, Distance element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDuration(String name, Duration element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeSimpleQuantity(String name, SimpleQuantity element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTriggerDefinition(String name, TriggerDefinition element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new TriggerDefinition.TriggerTypeEnumFactory());
            }
            if (element.hasEventNameElement()) {
                this.composeString("eventName", element.getEventNameElement());
            }
            if (element.hasEventTiming()) {
                this.composeType("eventTiming", element.getEventTiming());
            }
            if (element.hasEventData()) {
                this.composeDataRequirement("eventData", element.getEventData());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinition(String name, ElementDefinition element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasPathElement()) {
                this.composeString("path", element.getPathElement());
            }
            if (element.hasRepresentation()) {
                for (Enumeration<ElementDefinition.PropertyRepresentation> enumeration : element.getRepresentation()) {
                    this.composeEnumeration("representation", enumeration, new ElementDefinition.PropertyRepresentationEnumFactory());
                }
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasLabelElement()) {
                this.composeString("label", element.getLabelElement());
            }
            if (element.hasCode()) {
                for (Coding coding : element.getCode()) {
                    this.composeCoding("code", coding);
                }
            }
            if (element.hasSlicing()) {
                this.composeElementDefinitionElementDefinitionSlicingComponent("slicing", element.getSlicing());
            }
            if (element.hasShortElement()) {
                this.composeString("short", element.getShortElement());
            }
            if (element.hasDefinitionElement()) {
                this.composeMarkdown("definition", element.getDefinitionElement());
            }
            if (element.hasCommentsElement()) {
                this.composeMarkdown("comments", element.getCommentsElement());
            }
            if (element.hasRequirementsElement()) {
                this.composeMarkdown("requirements", element.getRequirementsElement());
            }
            if (element.hasAlias()) {
                for (StringType stringType : element.getAlias()) {
                    this.composeString("alias", stringType);
                }
            }
            if (element.hasMinElement()) {
                this.composeInteger("min", element.getMinElement());
            }
            if (element.hasMaxElement()) {
                this.composeString("max", element.getMaxElement());
            }
            if (element.hasBase()) {
                this.composeElementDefinitionElementDefinitionBaseComponent("base", element.getBase());
            }
            if (element.hasContentReferenceElement()) {
                this.composeUri("contentReference", element.getContentReferenceElement());
            }
            if (element.hasType()) {
                for (ElementDefinition.TypeRefComponent typeRefComponent : element.getType()) {
                    this.composeElementDefinitionTypeRefComponent("type", typeRefComponent);
                }
            }
            if (element.hasDefaultValue()) {
                this.composeType("defaultValue", element.getDefaultValue());
            }
            if (element.hasMeaningWhenMissingElement()) {
                this.composeMarkdown("meaningWhenMissing", element.getMeaningWhenMissingElement());
            }
            if (element.hasFixed()) {
                this.composeType("fixed", element.getFixed());
            }
            if (element.hasPattern()) {
                this.composeType("pattern", element.getPattern());
            }
            if (element.hasExample()) {
                this.composeType("example", element.getExample());
            }
            if (element.hasMinValue()) {
                this.composeType("minValue", element.getMinValue());
            }
            if (element.hasMaxValue()) {
                this.composeType("maxValue", element.getMaxValue());
            }
            if (element.hasMaxLengthElement()) {
                this.composeInteger("maxLength", element.getMaxLengthElement());
            }
            if (element.hasCondition()) {
                for (IdType idType : element.getCondition()) {
                    this.composeId("condition", idType);
                }
            }
            if (element.hasConstraint()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : element.getConstraint()) {
                    this.composeElementDefinitionElementDefinitionConstraintComponent("constraint", elementDefinitionConstraintComponent);
                }
            }
            if (element.hasMustSupportElement()) {
                this.composeBoolean("mustSupport", element.getMustSupportElement());
            }
            if (element.hasIsModifierElement()) {
                this.composeBoolean("isModifier", element.getIsModifierElement());
            }
            if (element.hasIsSummaryElement()) {
                this.composeBoolean("isSummary", element.getIsSummaryElement());
            }
            if (element.hasBinding()) {
                this.composeElementDefinitionElementDefinitionBindingComponent("binding", element.getBinding());
            }
            if (element.hasMapping()) {
                for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : element.getMapping()) {
                    this.composeElementDefinitionElementDefinitionMappingComponent("mapping", elementDefinitionMappingComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingComponent(String name, ElementDefinition.ElementDefinitionSlicingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasDiscriminator()) {
                for (StringType e : element.getDiscriminator()) {
                    this.composeString("discriminator", e);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasOrderedElement()) {
                this.composeBoolean("ordered", element.getOrderedElement());
            }
            if (element.hasRulesElement()) {
                this.composeEnumeration("rules", element.getRulesElement(), new ElementDefinition.SlicingRulesEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionBaseComponent(String name, ElementDefinition.ElementDefinitionBaseComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasPathElement()) {
                this.composeString("path", element.getPathElement());
            }
            if (element.hasMinElement()) {
                this.composeInteger("min", element.getMinElement());
            }
            if (element.hasMaxElement()) {
                this.composeString("max", element.getMaxElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(String name, ElementDefinition.TypeRefComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            if (element.hasProfile()) {
                for (UriType uriType : element.getProfile()) {
                    this.composeUri("profile", uriType);
                }
            }
            if (element.hasAggregation()) {
                for (Enumeration enumeration : element.getAggregation()) {
                    this.composeEnumeration("aggregation", enumeration, new ElementDefinition.AggregationModeEnumFactory());
                }
            }
            if (element.hasVersioningElement()) {
                this.composeEnumeration("versioning", element.getVersioningElement(), new ElementDefinition.ReferenceVersionRulesEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionConstraintComponent(String name, ElementDefinition.ElementDefinitionConstraintComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasKeyElement()) {
                this.composeId("key", element.getKeyElement());
            }
            if (element.hasRequirementsElement()) {
                this.composeString("requirements", element.getRequirementsElement());
            }
            if (element.hasSeverityElement()) {
                this.composeEnumeration("severity", element.getSeverityElement(), new ElementDefinition.ConstraintSeverityEnumFactory());
            }
            if (element.hasHumanElement()) {
                this.composeString("human", element.getHumanElement());
            }
            if (element.hasExpressionElement()) {
                this.composeString("expression", element.getExpressionElement());
            }
            if (element.hasXpathElement()) {
                this.composeString("xpath", element.getXpathElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionBindingComponent(String name, ElementDefinition.ElementDefinitionBindingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasStrengthElement()) {
                this.composeEnumeration("strength", element.getStrengthElement(), new Enumerations.BindingStrengthEnumFactory());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasValueSet()) {
                this.composeType("valueSet", element.getValueSet());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionMappingComponent(String name, ElementDefinition.ElementDefinitionMappingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasIdentityElement()) {
                this.composeId("identity", element.getIdentityElement());
            }
            if (element.hasLanguageElement()) {
                this.composeCode("language", element.getLanguageElement());
            }
            if (element.hasMapElement()) {
                this.composeString("map", element.getMapElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTiming(String name, Timing element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasEvent()) {
                for (DateTimeType e : element.getEvent()) {
                    this.composeDateTime("event", e);
                }
            }
            if (element.hasRepeat()) {
                this.composeTimingTimingRepeatComponent("repeat", element.getRepeat());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTimingTimingRepeatComponent(String name, Timing.TimingRepeatComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasBounds()) {
                this.composeType("bounds", element.getBounds());
            }
            if (element.hasCountElement()) {
                this.composeInteger("count", element.getCountElement());
            }
            if (element.hasCountMaxElement()) {
                this.composeInteger("countMax", element.getCountMaxElement());
            }
            if (element.hasDurationElement()) {
                this.composeDecimal("duration", element.getDurationElement());
            }
            if (element.hasDurationMaxElement()) {
                this.composeDecimal("durationMax", element.getDurationMaxElement());
            }
            if (element.hasDurationUnitElement()) {
                this.composeEnumeration("durationUnit", element.getDurationUnitElement(), new Timing.UnitsOfTimeEnumFactory());
            }
            if (element.hasFrequencyElement()) {
                this.composeInteger("frequency", element.getFrequencyElement());
            }
            if (element.hasFrequencyMaxElement()) {
                this.composeInteger("frequencyMax", element.getFrequencyMaxElement());
            }
            if (element.hasPeriodElement()) {
                this.composeDecimal("period", element.getPeriodElement());
            }
            if (element.hasPeriodMaxElement()) {
                this.composeDecimal("periodMax", element.getPeriodMaxElement());
            }
            if (element.hasPeriodUnitElement()) {
                this.composeEnumeration("periodUnit", element.getPeriodUnitElement(), new Timing.UnitsOfTimeEnumFactory());
            }
            if (element.hasWhenElement()) {
                this.composeEnumeration("when", element.getWhenElement(), new Timing.EventTimingEnumFactory());
            }
            if (element.hasOffsetElement()) {
                this.composeUnsignedInt("offset", element.getOffsetElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeModuleMetadata(String name, ModuleMetadata element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new ModuleMetadata.ModuleMetadataTypeEnumFactory());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new ModuleMetadata.ModuleMetadataStatusEnumFactory());
            }
            if (element.hasExperimentalElement()) {
                this.composeBoolean("experimental", element.getExperimentalElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasPurposeElement()) {
                this.composeString("purpose", element.getPurposeElement());
            }
            if (element.hasUsageElement()) {
                this.composeString("usage", element.getUsageElement());
            }
            if (element.hasPublicationDateElement()) {
                this.composeDate("publicationDate", element.getPublicationDateElement());
            }
            if (element.hasLastReviewDateElement()) {
                this.composeDate("lastReviewDate", element.getLastReviewDateElement());
            }
            if (element.hasEffectivePeriod()) {
                this.composePeriod("effectivePeriod", element.getEffectivePeriod());
            }
            if (element.hasCoverage()) {
                for (ModuleMetadata.ModuleMetadataCoverageComponent moduleMetadataCoverageComponent : element.getCoverage()) {
                    this.composeModuleMetadataModuleMetadataCoverageComponent("coverage", moduleMetadataCoverageComponent);
                }
            }
            if (element.hasTopic()) {
                for (CodeableConcept codeableConcept : element.getTopic()) {
                    this.composeCodeableConcept("topic", codeableConcept);
                }
            }
            if (element.hasContributor()) {
                for (ModuleMetadata.ModuleMetadataContributorComponent moduleMetadataContributorComponent : element.getContributor()) {
                    this.composeModuleMetadataModuleMetadataContributorComponent("contributor", moduleMetadataContributorComponent);
                }
            }
            if (element.hasPublisherElement()) {
                this.composeString("publisher", element.getPublisherElement());
            }
            if (element.hasContact()) {
                for (ModuleMetadata.ModuleMetadataContactComponent moduleMetadataContactComponent : element.getContact()) {
                    this.composeModuleMetadataModuleMetadataContactComponent("contact", moduleMetadataContactComponent);
                }
            }
            if (element.hasCopyrightElement()) {
                this.composeString("copyright", element.getCopyrightElement());
            }
            if (element.hasRelatedResource()) {
                for (ModuleMetadata.ModuleMetadataRelatedResourceComponent moduleMetadataRelatedResourceComponent : element.getRelatedResource()) {
                    this.composeModuleMetadataModuleMetadataRelatedResourceComponent("relatedResource", moduleMetadataRelatedResourceComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeModuleMetadataModuleMetadataCoverageComponent(String name, ModuleMetadata.ModuleMetadataCoverageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasFocus()) {
                this.composeCoding("focus", element.getFocus());
            }
            if (element.hasValue()) {
                this.composeCodeableConcept("value", element.getValue());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeModuleMetadataModuleMetadataContributorComponent(String name, ModuleMetadata.ModuleMetadataContributorComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new ModuleMetadata.ModuleMetadataContributorTypeEnumFactory());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasContact()) {
                for (ModuleMetadata.ModuleMetadataContributorContactComponent e : element.getContact()) {
                    this.composeModuleMetadataModuleMetadataContributorContactComponent("contact", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeModuleMetadataModuleMetadataContributorContactComponent(String name, ModuleMetadata.ModuleMetadataContributorContactComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasTelecom()) {
                for (ContactPoint e : element.getTelecom()) {
                    this.composeContactPoint("telecom", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeModuleMetadataModuleMetadataContactComponent(String name, ModuleMetadata.ModuleMetadataContactComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasTelecom()) {
                for (ContactPoint e : element.getTelecom()) {
                    this.composeContactPoint("telecom", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeModuleMetadataModuleMetadataRelatedResourceComponent(String name, ModuleMetadata.ModuleMetadataRelatedResourceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new ModuleMetadata.ModuleMetadataResourceTypeEnumFactory());
            }
            if (element.hasDocument()) {
                this.composeAttachment("document", element.getDocument());
            }
            if (element.hasResource()) {
                this.composeReference("resource", element.getResource());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeActionDefinition(String name, ActionDefinition element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasActionIdentifier()) {
                this.composeIdentifier("actionIdentifier", element.getActionIdentifier());
            }
            if (element.hasLabelElement()) {
                this.composeString("label", element.getLabelElement());
            }
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasTextEquivalentElement()) {
                this.composeString("textEquivalent", element.getTextEquivalentElement());
            }
            if (element.hasConcept()) {
                for (CodeableConcept codeableConcept : element.getConcept()) {
                    this.composeCodeableConcept("concept", codeableConcept);
                }
            }
            if (element.hasSupportingEvidence()) {
                for (Attachment attachment : element.getSupportingEvidence()) {
                    this.composeAttachment("supportingEvidence", attachment);
                }
            }
            if (element.hasDocumentation()) {
                for (Attachment attachment : element.getDocumentation()) {
                    this.composeAttachment("documentation", attachment);
                }
            }
            if (element.hasRelatedAction()) {
                this.composeActionDefinitionActionDefinitionRelatedActionComponent("relatedAction", element.getRelatedAction());
            }
            if (element.hasParticipantType()) {
                for (Enumeration enumeration : element.getParticipantType()) {
                    this.composeEnumeration("participantType", enumeration, new ActionDefinition.ParticipantTypeEnumFactory());
                }
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new ActionDefinition.ActionTypeEnumFactory());
            }
            if (element.hasBehavior()) {
                for (ActionDefinition.ActionDefinitionBehaviorComponent actionDefinitionBehaviorComponent : element.getBehavior()) {
                    this.composeActionDefinitionActionDefinitionBehaviorComponent("behavior", actionDefinitionBehaviorComponent);
                }
            }
            if (element.hasResource()) {
                this.composeReference("resource", element.getResource());
            }
            if (element.hasCustomization()) {
                for (ActionDefinition.ActionDefinitionCustomizationComponent actionDefinitionCustomizationComponent : element.getCustomization()) {
                    this.composeActionDefinitionActionDefinitionCustomizationComponent("customization", actionDefinitionCustomizationComponent);
                }
            }
            if (element.hasAction()) {
                for (ActionDefinition actionDefinition : element.getAction()) {
                    this.composeActionDefinition("action", actionDefinition);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeActionDefinitionActionDefinitionRelatedActionComponent(String name, ActionDefinition.ActionDefinitionRelatedActionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasActionIdentifier()) {
                this.composeIdentifier("actionIdentifier", element.getActionIdentifier());
            }
            if (element.hasRelationshipElement()) {
                this.composeEnumeration("relationship", element.getRelationshipElement(), new ActionDefinition.ActionRelationshipTypeEnumFactory());
            }
            if (element.hasOffset()) {
                this.composeType("offset", element.getOffset());
            }
            if (element.hasAnchorElement()) {
                this.composeEnumeration("anchor", element.getAnchorElement(), new ActionDefinition.ActionRelationshipAnchorEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeActionDefinitionActionDefinitionBehaviorComponent(String name, ActionDefinition.ActionDefinitionBehaviorComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasValue()) {
                this.composeCoding("value", element.getValue());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeActionDefinitionActionDefinitionCustomizationComponent(String name, ActionDefinition.ActionDefinitionCustomizationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasPathElement()) {
                this.composeString("path", element.getPathElement());
            }
            if (element.hasExpressionElement()) {
                this.composeString("expression", element.getExpressionElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAddress(String name, Address element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new Address.AddressUseEnumFactory());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Address.AddressTypeEnumFactory());
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasLine()) {
                for (StringType e : element.getLine()) {
                    this.composeString("line", e);
                }
            }
            if (element.hasCityElement()) {
                this.composeString("city", element.getCityElement());
            }
            if (element.hasDistrictElement()) {
                this.composeString("district", element.getDistrictElement());
            }
            if (element.hasStateElement()) {
                this.composeString("state", element.getStateElement());
            }
            if (element.hasPostalCodeElement()) {
                this.composeString("postalCode", element.getPostalCodeElement());
            }
            if (element.hasCountryElement()) {
                this.composeString("country", element.getCountryElement());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHumanName(String name, HumanName element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new HumanName.NameUseEnumFactory());
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasFamily()) {
                for (StringType e : element.getFamily()) {
                    this.composeString("family", e);
                }
            }
            if (element.hasGiven()) {
                for (StringType e : element.getGiven()) {
                    this.composeString("given", e);
                }
            }
            if (element.hasPrefix()) {
                for (StringType e : element.getPrefix()) {
                    this.composeString("prefix", e);
                }
            }
            if (element.hasSuffix()) {
                for (StringType e : element.getSuffix()) {
                    this.composeString("suffix", e);
                }
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDataRequirement(String name, DataRequirement element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasTypeElement()) {
                this.composeCode("type", element.getTypeElement());
            }
            if (element.hasProfile()) {
                this.composeReference("profile", element.getProfile());
            }
            if (element.hasMustSupport()) {
                for (StringType stringType : element.getMustSupport()) {
                    this.composeString("mustSupport", stringType);
                }
            }
            if (element.hasCodeFilter()) {
                for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : element.getCodeFilter()) {
                    this.composeDataRequirementDataRequirementCodeFilterComponent("codeFilter", dataRequirementCodeFilterComponent);
                }
            }
            if (element.hasDateFilter()) {
                for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : element.getDateFilter()) {
                    this.composeDataRequirementDataRequirementDateFilterComponent("dateFilter", dataRequirementDateFilterComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDataRequirementDataRequirementCodeFilterComponent(String name, DataRequirement.DataRequirementCodeFilterComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasPathElement()) {
                this.composeString("path", element.getPathElement());
            }
            if (element.hasValueSet()) {
                this.composeType("valueSet", element.getValueSet());
            }
            if (element.hasValueCode()) {
                for (CodeType codeType : element.getValueCode()) {
                    this.composeCode("valueCode", codeType);
                }
            }
            if (element.hasValueCoding()) {
                for (Coding coding : element.getValueCoding()) {
                    this.composeCoding("valueCoding", coding);
                }
            }
            if (element.hasValueCodeableConcept()) {
                for (CodeableConcept codeableConcept : element.getValueCodeableConcept()) {
                    this.composeCodeableConcept("valueCodeableConcept", codeableConcept);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDataRequirementDataRequirementDateFilterComponent(String name, DataRequirement.DataRequirementDateFilterComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasPathElement()) {
                this.composeString("path", element.getPathElement());
            }
            if (element.hasValue()) {
                this.composeType("value", element.getValue());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMeta(String name, Meta element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasVersionIdElement()) {
                this.composeId("versionId", element.getVersionIdElement());
            }
            if (element.hasLastUpdatedElement()) {
                this.composeInstant("lastUpdated", element.getLastUpdatedElement());
            }
            if (element.hasProfile()) {
                for (UriType uriType : element.getProfile()) {
                    this.composeUri("profile", uriType);
                }
            }
            if (element.hasSecurity()) {
                for (Coding coding : element.getSecurity()) {
                    this.composeCoding("security", coding);
                }
            }
            if (element.hasTag()) {
                for (Coding coding : element.getTag()) {
                    this.composeCoding("tag", coding);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeParameterDefinition(String name, ParameterDefinition element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasNameElement()) {
                this.composeCode("name", element.getNameElement());
            }
            if (element.hasUseElement()) {
                this.composeCode("use", element.getUseElement());
            }
            if (element.hasMinElement()) {
                this.composeInteger("min", element.getMinElement());
            }
            if (element.hasMaxElement()) {
                this.composeString("max", element.getMaxElement());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            if (element.hasTypeElement()) {
                this.composeCode("type", element.getTypeElement());
            }
            if (element.hasProfile()) {
                this.composeReference("profile", element.getProfile());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContactPoint(String name, ContactPoint element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasSystemElement()) {
                this.composeEnumeration("system", element.getSystemElement(), new ContactPoint.ContactPointSystemEnumFactory());
            }
            if (element.hasValueElement()) {
                this.composeString("value", element.getValueElement());
            }
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new ContactPoint.ContactPointUseEnumFactory());
            }
            if (element.hasRankElement()) {
                this.composePositiveInt("rank", element.getRankElement());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeParameters(String name, Parameters element) throws IOException {
        if (element != null) {
            this.composeResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeResourceElements(element);
            if (element.hasParameter()) {
                for (Parameters.ParametersParameterComponent e : element.getParameter()) {
                    this.composeParametersParametersParameterComponent("parameter", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeParametersParametersParameterComponent(String name, Parameters.ParametersParameterComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasValue()) {
                this.composeType("value", element.getValue());
            }
            if (element.hasResource()) {
                this.xml.enter("http://hl7.org/fhir", "resource");
                this.composeResource(element.getResource());
                this.xml.exit("http://hl7.org/fhir", "resource");
            }
            if (element.hasPart()) {
                for (Parameters.ParametersParameterComponent e : element.getPart()) {
                    this.composeParametersParametersParameterComponent("part", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeResourceAttributes(Resource element) throws IOException {
        if (this.style != IParser.OutputStyle.CANONICAL) {
            for (String comment : element.getFormatCommentsPre()) {
                this.xml.comment(comment, this.getOutputStyle() == IParser.OutputStyle.PRETTY);
            }
        }
    }

    protected void composeResourceElements(Resource element) throws IOException {
        if (element.hasIdElement()) {
            this.composeId("id", element.getIdElement());
        }
        if (element.hasMeta()) {
            this.composeMeta("meta", element.getMeta());
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUri("implicitRules", element.getImplicitRulesElement());
        }
        if (element.hasLanguageElement()) {
            this.composeCode("language", element.getLanguageElement());
        }
    }

    protected void composeDomainResourceAttributes(DomainResource element) throws IOException {
        this.composeResourceAttributes(element);
    }

    protected void composeDomainResourceElements(DomainResource element) throws IOException {
        this.composeResourceElements(element);
        if (element.hasText()) {
            this.composeNarrative("text", element.getText());
        }
        if (element.hasContained()) {
            for (Resource resource : element.getContained()) {
                this.xml.enter("http://hl7.org/fhir", "contained");
                this.composeResource(resource);
                this.xml.exit("http://hl7.org/fhir", "contained");
            }
        }
        if (element.hasExtension()) {
            for (Extension extension : element.getExtension()) {
                this.composeExtension("extension", extension);
            }
        }
        if (element.hasModifierExtension()) {
            for (Extension extension : element.getModifierExtension()) {
                this.composeExtension("modifierExtension", extension);
            }
        }
    }

    protected void composeAccount(String name, Account element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Account.AccountStatusEnumFactory());
            }
            if (element.hasActivePeriod()) {
                this.composePeriod("activePeriod", element.getActivePeriod());
            }
            if (element.hasCurrency()) {
                this.composeCoding("currency", element.getCurrency());
            }
            if (element.hasBalance()) {
                this.composeMoney("balance", element.getBalance());
            }
            if (element.hasCoveragePeriod()) {
                this.composePeriod("coveragePeriod", element.getCoveragePeriod());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasOwner()) {
                this.composeReference("owner", element.getOwner());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAllergyIntolerance(String name, AllergyIntolerance element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory());
            }
            if (element.hasCategoryElement()) {
                this.composeEnumeration("category", element.getCategoryElement(), new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory());
            }
            if (element.hasCriticalityElement()) {
                this.composeEnumeration("criticality", element.getCriticalityElement(), new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory());
            }
            if (element.hasSubstance()) {
                this.composeCodeableConcept("substance", element.getSubstance());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasRecordedDateElement()) {
                this.composeDateTime("recordedDate", element.getRecordedDateElement());
            }
            if (element.hasRecorder()) {
                this.composeReference("recorder", element.getRecorder());
            }
            if (element.hasReporter()) {
                this.composeReference("reporter", element.getReporter());
            }
            if (element.hasOnsetElement()) {
                this.composeDateTime("onset", element.getOnsetElement());
            }
            if (element.hasLastOccurenceElement()) {
                this.composeDateTime("lastOccurence", element.getLastOccurenceElement());
            }
            if (element.hasNote()) {
                for (Annotation annotation : element.getNote()) {
                    this.composeAnnotation("note", annotation);
                }
            }
            if (element.hasReaction()) {
                for (AllergyIntolerance.AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : element.getReaction()) {
                    this.composeAllergyIntoleranceAllergyIntoleranceReactionComponent("reaction", allergyIntoleranceReactionComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponent(String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSubstance()) {
                this.composeCodeableConcept("substance", element.getSubstance());
            }
            if (element.hasCertaintyElement()) {
                this.composeEnumeration("certainty", element.getCertaintyElement(), new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory());
            }
            if (element.hasManifestation()) {
                for (CodeableConcept codeableConcept : element.getManifestation()) {
                    this.composeCodeableConcept("manifestation", codeableConcept);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasOnsetElement()) {
                this.composeDateTime("onset", element.getOnsetElement());
            }
            if (element.hasSeverityElement()) {
                this.composeEnumeration("severity", element.getSeverityElement(), new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory());
            }
            if (element.hasExposureRoute()) {
                this.composeCodeableConcept("exposureRoute", element.getExposureRoute());
            }
            if (element.hasNote()) {
                for (Annotation annotation : element.getNote()) {
                    this.composeAnnotation("note", annotation);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAppointment(String name, Appointment element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Appointment.AppointmentStatusEnumFactory());
            }
            if (element.hasServiceCategory()) {
                this.composeCodeableConcept("serviceCategory", element.getServiceCategory());
            }
            if (element.hasServiceType()) {
                for (CodeableConcept codeableConcept : element.getServiceType()) {
                    this.composeCodeableConcept("serviceType", codeableConcept);
                }
            }
            if (element.hasSpecialty()) {
                for (CodeableConcept codeableConcept : element.getSpecialty()) {
                    this.composeCodeableConcept("specialty", codeableConcept);
                }
            }
            if (element.hasAppointmentType()) {
                this.composeCodeableConcept("appointmentType", element.getAppointmentType());
            }
            if (element.hasReason()) {
                this.composeCodeableConcept("reason", element.getReason());
            }
            if (element.hasPriorityElement()) {
                this.composeUnsignedInt("priority", element.getPriorityElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasStartElement()) {
                this.composeInstant("start", element.getStartElement());
            }
            if (element.hasEndElement()) {
                this.composeInstant("end", element.getEndElement());
            }
            if (element.hasMinutesDurationElement()) {
                this.composePositiveInt("minutesDuration", element.getMinutesDurationElement());
            }
            if (element.hasSlot()) {
                for (Reference reference : element.getSlot()) {
                    this.composeReference("slot", reference);
                }
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasCommentElement()) {
                this.composeString("comment", element.getCommentElement());
            }
            if (element.hasParticipant()) {
                for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : element.getParticipant()) {
                    this.composeAppointmentAppointmentParticipantComponent("participant", appointmentParticipantComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAppointmentAppointmentParticipantComponent(String name, Appointment.AppointmentParticipantComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                for (CodeableConcept e : element.getType()) {
                    this.composeCodeableConcept("type", e);
                }
            }
            if (element.hasActor()) {
                this.composeReference("actor", element.getActor());
            }
            if (element.hasRequiredElement()) {
                this.composeEnumeration("required", element.getRequiredElement(), new Appointment.ParticipantRequiredEnumFactory());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Appointment.ParticipationStatusEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAppointmentResponse(String name, AppointmentResponse element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasAppointment()) {
                this.composeReference("appointment", element.getAppointment());
            }
            if (element.hasStartElement()) {
                this.composeInstant("start", element.getStartElement());
            }
            if (element.hasEndElement()) {
                this.composeInstant("end", element.getEndElement());
            }
            if (element.hasParticipantType()) {
                for (CodeableConcept codeableConcept : element.getParticipantType()) {
                    this.composeCodeableConcept("participantType", codeableConcept);
                }
            }
            if (element.hasActor()) {
                this.composeReference("actor", element.getActor());
            }
            if (element.hasParticipantStatusElement()) {
                this.composeCode("participantStatus", element.getParticipantStatusElement());
            }
            if (element.hasCommentElement()) {
                this.composeString("comment", element.getCommentElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEvent(String name, AuditEvent element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasSubtype()) {
                for (Coding coding : element.getSubtype()) {
                    this.composeCoding("subtype", coding);
                }
            }
            if (element.hasActionElement()) {
                this.composeEnumeration("action", element.getActionElement(), new AuditEvent.AuditEventActionEnumFactory());
            }
            if (element.hasRecordedElement()) {
                this.composeInstant("recorded", element.getRecordedElement());
            }
            if (element.hasOutcomeElement()) {
                this.composeEnumeration("outcome", element.getOutcomeElement(), new AuditEvent.AuditEventOutcomeEnumFactory());
            }
            if (element.hasOutcomeDescElement()) {
                this.composeString("outcomeDesc", element.getOutcomeDescElement());
            }
            if (element.hasPurposeOfEvent()) {
                for (Coding coding : element.getPurposeOfEvent()) {
                    this.composeCoding("purposeOfEvent", coding);
                }
            }
            if (element.hasAgent()) {
                for (AuditEvent.AuditEventAgentComponent auditEventAgentComponent : element.getAgent()) {
                    this.composeAuditEventAuditEventAgentComponent("agent", auditEventAgentComponent);
                }
            }
            if (element.hasSource()) {
                this.composeAuditEventAuditEventSourceComponent("source", element.getSource());
            }
            if (element.hasEntity()) {
                for (AuditEvent.AuditEventEntityComponent auditEventEntityComponent : element.getEntity()) {
                    this.composeAuditEventAuditEventEntityComponent("entity", auditEventEntityComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventAgentComponent(String name, AuditEvent.AuditEventAgentComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasRole()) {
                for (CodeableConcept codeableConcept : element.getRole()) {
                    this.composeCodeableConcept("role", codeableConcept);
                }
            }
            if (element.hasReference()) {
                this.composeReference("reference", element.getReference());
            }
            if (element.hasUserId()) {
                this.composeIdentifier("userId", element.getUserId());
            }
            if (element.hasAltIdElement()) {
                this.composeString("altId", element.getAltIdElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasRequestorElement()) {
                this.composeBoolean("requestor", element.getRequestorElement());
            }
            if (element.hasLocation()) {
                this.composeReference("location", element.getLocation());
            }
            if (element.hasPolicy()) {
                for (UriType uriType : element.getPolicy()) {
                    this.composeUri("policy", uriType);
                }
            }
            if (element.hasMedia()) {
                this.composeCoding("media", element.getMedia());
            }
            if (element.hasNetwork()) {
                this.composeAuditEventAuditEventAgentNetworkComponent("network", element.getNetwork());
            }
            if (element.hasPurposeOfUse()) {
                for (Coding coding : element.getPurposeOfUse()) {
                    this.composeCoding("purposeOfUse", coding);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventAgentNetworkComponent(String name, AuditEvent.AuditEventAgentNetworkComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasAddressElement()) {
                this.composeString("address", element.getAddressElement());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventSourceComponent(String name, AuditEvent.AuditEventSourceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSiteElement()) {
                this.composeString("site", element.getSiteElement());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasType()) {
                for (Coding e : element.getType()) {
                    this.composeCoding("type", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventEntityComponent(String name, AuditEvent.AuditEventEntityComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasReference()) {
                this.composeReference("reference", element.getReference());
            }
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasRole()) {
                this.composeCoding("role", element.getRole());
            }
            if (element.hasLifecycle()) {
                this.composeCoding("lifecycle", element.getLifecycle());
            }
            if (element.hasSecurityLabel()) {
                for (Coding coding : element.getSecurityLabel()) {
                    this.composeCoding("securityLabel", coding);
                }
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasQueryElement()) {
                this.composeBase64Binary("query", element.getQueryElement());
            }
            if (element.hasDetail()) {
                for (AuditEvent.AuditEventEntityDetailComponent auditEventEntityDetailComponent : element.getDetail()) {
                    this.composeAuditEventAuditEventEntityDetailComponent("detail", auditEventEntityDetailComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventEntityDetailComponent(String name, AuditEvent.AuditEventEntityDetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTypeElement()) {
                this.composeString("type", element.getTypeElement());
            }
            if (element.hasValueElement()) {
                this.composeBase64Binary("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBasic(String name, Basic element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasCreatedElement()) {
                this.composeDate("created", element.getCreatedElement());
            }
            if (element.hasAuthor()) {
                this.composeReference("author", element.getAuthor());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBinary(String name, Binary element) throws IOException {
        if (element != null) {
            this.composeResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeResourceElements(element);
            if (element.hasContentTypeElement()) {
                this.composeCode("contentType", element.getContentTypeElement());
            }
            if (element.hasContentElement()) {
                this.composeBase64Binary("content", element.getContentElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBodySite(String name, BodySite element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasModifier()) {
                for (CodeableConcept codeableConcept : element.getModifier()) {
                    this.composeCodeableConcept("modifier", codeableConcept);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasImage()) {
                for (Attachment attachment : element.getImage()) {
                    this.composeAttachment("image", attachment);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundle(String name, Bundle element) throws IOException {
        if (element != null) {
            this.composeResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeResourceElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Bundle.BundleTypeEnumFactory());
            }
            if (element.hasTotalElement()) {
                this.composeUnsignedInt("total", element.getTotalElement());
            }
            if (element.hasLink()) {
                for (Bundle.BundleLinkComponent bundleLinkComponent : element.getLink()) {
                    this.composeBundleBundleLinkComponent("link", bundleLinkComponent);
                }
            }
            if (element.hasEntry()) {
                for (Bundle.BundleEntryComponent bundleEntryComponent : element.getEntry()) {
                    this.composeBundleBundleEntryComponent("entry", bundleEntryComponent);
                }
            }
            if (element.hasSignature()) {
                this.composeSignature("signature", element.getSignature());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleLinkComponent(String name, Bundle.BundleLinkComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasRelationElement()) {
                this.composeString("relation", element.getRelationElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntryComponent(String name, Bundle.BundleEntryComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasLink()) {
                for (Bundle.BundleLinkComponent e : element.getLink()) {
                    this.composeBundleBundleLinkComponent("link", e);
                }
            }
            if (element.hasFullUrlElement()) {
                this.composeUri("fullUrl", element.getFullUrlElement());
            }
            if (element.hasResource()) {
                this.xml.enter("http://hl7.org/fhir", "resource");
                this.composeResource(element.getResource());
                this.xml.exit("http://hl7.org/fhir", "resource");
            }
            if (element.hasSearch()) {
                this.composeBundleBundleEntrySearchComponent("search", element.getSearch());
            }
            if (element.hasRequest()) {
                this.composeBundleBundleEntryRequestComponent("request", element.getRequest());
            }
            if (element.hasResponse()) {
                this.composeBundleBundleEntryResponseComponent("response", element.getResponse());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntrySearchComponent(String name, Bundle.BundleEntrySearchComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasModeElement()) {
                this.composeEnumeration("mode", element.getModeElement(), new Bundle.SearchEntryModeEnumFactory());
            }
            if (element.hasScoreElement()) {
                this.composeDecimal("score", element.getScoreElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntryRequestComponent(String name, Bundle.BundleEntryRequestComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasMethodElement()) {
                this.composeEnumeration("method", element.getMethodElement(), new Bundle.HTTPVerbEnumFactory());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasIfNoneMatchElement()) {
                this.composeString("ifNoneMatch", element.getIfNoneMatchElement());
            }
            if (element.hasIfModifiedSinceElement()) {
                this.composeInstant("ifModifiedSince", element.getIfModifiedSinceElement());
            }
            if (element.hasIfMatchElement()) {
                this.composeString("ifMatch", element.getIfMatchElement());
            }
            if (element.hasIfNoneExistElement()) {
                this.composeString("ifNoneExist", element.getIfNoneExistElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntryResponseComponent(String name, Bundle.BundleEntryResponseComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasStatusElement()) {
                this.composeString("status", element.getStatusElement());
            }
            if (element.hasLocationElement()) {
                this.composeUri("location", element.getLocationElement());
            }
            if (element.hasEtagElement()) {
                this.composeString("etag", element.getEtagElement());
            }
            if (element.hasLastModifiedElement()) {
                this.composeInstant("lastModified", element.getLastModifiedElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCarePlan(String name, CarePlan element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new CarePlan.CarePlanStatusEnumFactory());
            }
            if (element.hasContext()) {
                this.composeReference("context", element.getContext());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasAuthor()) {
                for (Reference reference : element.getAuthor()) {
                    this.composeReference("author", reference);
                }
            }
            if (element.hasModifiedElement()) {
                this.composeDateTime("modified", element.getModifiedElement());
            }
            if (element.hasCategory()) {
                for (CodeableConcept codeableConcept : element.getCategory()) {
                    this.composeCodeableConcept("category", codeableConcept);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasAddresses()) {
                for (Reference reference : element.getAddresses()) {
                    this.composeReference("addresses", reference);
                }
            }
            if (element.hasSupport()) {
                for (Reference reference : element.getSupport()) {
                    this.composeReference("support", reference);
                }
            }
            if (element.hasRelatedPlan()) {
                for (CarePlan.CarePlanRelatedPlanComponent carePlanRelatedPlanComponent : element.getRelatedPlan()) {
                    this.composeCarePlanCarePlanRelatedPlanComponent("relatedPlan", carePlanRelatedPlanComponent);
                }
            }
            if (element.hasParticipant()) {
                for (CarePlan.CarePlanParticipantComponent carePlanParticipantComponent : element.getParticipant()) {
                    this.composeCarePlanCarePlanParticipantComponent("participant", carePlanParticipantComponent);
                }
            }
            if (element.hasGoal()) {
                for (Reference reference : element.getGoal()) {
          