/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.ExtensionHelper;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.Narrative;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.OperationOutcome;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.SampledData;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2.utils.EOperationOutcome;
import org.hl7.fhir.dstu2.utils.INarrativeGenerator;
import org.hl7.fhir.dstu2.utils.IWorkerContext;
import org.hl7.fhir.dstu2.utils.ProfileUtilities;
import org.hl7.fhir.dstu2.utils.ResourceUtilities;
import org.hl7.fhir.dstu2.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XmlGenerator;
import org.w3c.dom.Element;

public class NarrativeGenerator
implements INarrativeGenerator {
    private String prefix;
    private IWorkerContext context;
    private String basePath;
    private String tooCostlyNote;
    private boolean pretty;

    public NarrativeGenerator(String prefix, String basePath, IWorkerContext context) {
        this.prefix = prefix;
        this.context = context;
        this.basePath = basePath;
    }

    public String getTooCostlyNote() {
        return this.tooCostlyNote;
    }

    public NarrativeGenerator setTooCostlyNote(String tooCostlyNote) {
        this.tooCostlyNote = tooCostlyNote;
        return this;
    }

    public void generate(DomainResource r) throws EOperationOutcome, FHIRException, IOException {
        if (r instanceof ConceptMap) {
            this.generate((ConceptMap)r);
        } else if (r instanceof ValueSet) {
            this.generate((ValueSet)r, true);
        } else if (r instanceof OperationOutcome) {
            this.generate((OperationOutcome)r);
        } else if (r instanceof Conformance) {
            this.generate((Conformance)r);
        } else if (r instanceof OperationDefinition) {
            this.generate((OperationDefinition)r);
        } else {
            StructureDefinition p = null;
            if (r.hasMeta()) {
                for (UriType pu : r.getMeta().getProfile()) {
                    if (p != null) continue;
                    p = this.context.fetchResource(StructureDefinition.class, (String)pu.getValue());
                }
            }
            if (p == null) {
                p = this.context.fetchResource(StructureDefinition.class, r.getResourceType().toString());
            }
            if (p == null) {
                p = this.context.fetchTypeDefinition(r.getResourceType().toString().toLowerCase());
            }
            if (p != null) {
                this.generateByProfile(r, p, true);
            }
        }
    }

    public String generate(Element doc) throws IOException {
        String rt = "http://hl7.org/fhir/StructureDefinition/" + doc.getNodeName();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, rt);
        return this.generateByProfile(doc, p, true);
    }

    private void generateByProfile(DomainResource r, StructureDefinition profile, boolean showCodeDetails) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("p").addTag("b").addText("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(r, profile, r, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), r.getResourceType().toString()), x, r.getResourceType().toString(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.addTag("p").addTag("b").setAttribute("style", "color: maroon").addText("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(r, x, Narrative.NarrativeStatus.GENERATED);
    }

    private String generateByProfile(Element er, StructureDefinition profile, boolean showCodeDetails) throws IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("p").addTag("b").addText("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(er, profile, er, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), er.getLocalName()), x, er.getLocalName(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.addTag("p").addTag("b").setAttribute("style", "color: maroon").addText("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(er, x, Narrative.NarrativeStatus.GENERATED);
        return new XhtmlComposer(true, this.pretty).compose(x);
    }

    private void generateByProfile(Element eres, StructureDefinition profile, Element ee, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        ResurceWrapperElement resw = new ResurceWrapperElement(eres, profile);
        BaseWrapperElement base = new BaseWrapperElement(ee, null, profile, profile.getSnapshot().getElement().get(0));
        this.generateByProfile(resw, profile, base, allElements, defn, children, x, path, showCodeDetails);
    }

    private void generateByProfile(Resource res, StructureDefinition profile, Base e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        this.generateByProfile(new ResourceWrapperDirect(res), profile, new BaseWrapperDirect(e), allElements, defn, children, x, path, showCodeDetails);
    }

    private void generateByProfile(ResourceWrapper res, StructureDefinition profile, BaseWrapper e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        if (children.isEmpty()) {
            this.renderLeaf(res, e, defn, x, false, showCodeDetails, this.readDisplayHints(defn));
        } else {
            for (PropertyWrapper p : this.splitExtensions(profile, e.children())) {
                ElementDefinition child;
                if (!p.hasValues() || (child = this.getElementDefinition(children, path + "." + p.getName(), p)) == null) continue;
                Map<String, String> displayHints = this.readDisplayHints(child);
                if (this.exemptFromRendering(child)) continue;
                List<ElementDefinition> grandChildren = this.getChildrenForPath(allElements, path + "." + p.getName());
                this.filterGrandChildren(grandChildren, path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || child == null) continue;
                if (this.isPrimitive(child)) {
                    XhtmlNode para = x.addTag("p");
                    String name = p.getName();
                    if (name.endsWith("[x]")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if (!showCodeDetails && this.isDefaultValue(displayHints, p.getValues())) continue;
                    para.addTag("b").addText(name);
                    para.addText(": ");
                    if (this.renderAsList(child) && p.getValues().size() > 1) {
                        XhtmlNode list = x.addTag("ul");
                        for (BaseWrapper v : p.getValues()) {
                            this.renderLeaf(res, v, child, list.addTag("li"), false, showCodeDetails, displayHints);
                        }
                        continue;
                    }
                    boolean first = true;
                    for (BaseWrapper v : p.getValues()) {
                        if (first) {
                            first = false;
                        } else {
                            para.addText(", ");
                        }
                        this.renderLeaf(res, v, child, para, false, showCodeDetails, displayHints);
                    }
                    continue;
                }
                if (this.canDoTable(path, p, grandChildren)) {
                    x.addTag("h3").addText(Utilities.capitalize(Utilities.camelCase(Utilities.pluralizeMe(p.getName()))));
                    XhtmlNode tbl = x.addTag("table").setAttribute("class", "grid");
                    XhtmlNode tr = tbl.addTag("tr");
                    tr.addTag("td").addText("-");
                    this.addColumnHeadings(tr, grandChildren);
                    for (BaseWrapper v : p.getValues()) {
                        if (v == null) continue;
                        tr = tbl.addTag("tr");
                        tr.addTag("td").addText("*");
                        this.addColumnValues(res, tr, grandChildren, v, showCodeDetails, displayHints);
                    }
                    continue;
                }
                for (BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.addTag("p").addTag("b").addText(p.getName());
                    this.generateByProfile(res, profile, v, allElements, child, grandChildren, bq, path + "." + p.getName(), showCodeDetails);
                }
            }
        }
    }

    private void filterGrandChildren(List<ElementDefinition> grandChildren, String string, PropertyWrapper prop) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        toRemove.addAll(grandChildren);
        for (BaseWrapper b : prop.getValues()) {
            ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : toRemove) {
                PropertyWrapper p = b.getChildByName(this.tail(ed.getPath()));
                if (p == null || !p.hasValues()) continue;
                list.add(ed);
            }
            toRemove.removeAll(list);
        }
        grandChildren.removeAll(toRemove);
    }

    private List<PropertyWrapper> splitExtensions(StructureDefinition profile, List<PropertyWrapper> children) throws UnsupportedEncodingException, IOException, FHIRException {
        ArrayList<PropertyWrapper> results = new ArrayList<PropertyWrapper>();
        HashMap map = new HashMap();
        for (PropertyWrapper p : children) {
            if (p.getName().equals("extension") || p.getName().equals("modifierExtension")) {
                if (!p.hasValues()) continue;
                for (BaseWrapper v : p.getValues()) {
                    Extension ex = (Extension)v.getBase();
                    String url = ex.getUrl();
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    if (p.getName().equals("modifierExtension") && ed == null) {
                        throw new DefinitionException("Unknown modifier extension " + url);
                    }
                    PropertyWrapper pe = (PropertyWrapper)map.get(p.getName() + "[" + url + "]");
                    if (pe == null) {
                        if (ed == null) {
                            if (url.startsWith("http://hl7.org/fhir")) {
                                throw new DefinitionException("unknown extension " + url);
                            }
                            System.out.println("unknown extension " + url);
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", p.getTypeCode(), p.getDefinition(), p.getMinCardinality(), p.getMaxCardinality(), ex));
                        } else {
                            ElementDefinition def = ed.getSnapshot().getElement().get(0);
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", "Extension", def.getDefinition(), def.getMin(), def.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(def.getMax()), ex));
                            ((PropertyWrapperDirect)pe).wrapped.setStructure(ed);
                        }
                        results.add(pe);
                        continue;
                    }
                    pe.getValues().add(v);
                }
                continue;
            }
            results.add(p);
        }
        return results;
    }

    private boolean isDefaultValue(Map<String, String> displayHints, List<BaseWrapper> list) throws UnsupportedEncodingException, IOException, FHIRException {
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0).getBase() instanceof PrimitiveType) {
            return this.isDefault(displayHints, (PrimitiveType)list.get(0).getBase());
        }
        return false;
    }

    private boolean isDefault(Map<String, String> displayHints, PrimitiveType primitiveType) {
        String v = primitiveType.asStringValue();
        return !Utilities.noString(v) && displayHints.containsKey("default") && v.equals(displayHints.get("default"));
    }

    private boolean exemptFromRendering(ElementDefinition child) {
        if (child == null) {
            return false;
        }
        if ("Composition.subject".equals(child.getPath())) {
            return true;
        }
        return "Composition.section".equals(child.getPath());
    }

    private boolean renderAsList(ElementDefinition child) {
        String t;
        return child.getType().size() == 1 && ((t = child.getType().get(0).getCode()).equals("Address") || t.equals("Reference"));
    }

    private void addColumnHeadings(XhtmlNode tr, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            tr.addTag("td").addTag("b").addText(Utilities.capitalize(this.tail(e.getPath())));
        }
    }

    private void addColumnValues(ResourceWrapper res, XhtmlNode tr, List<ElementDefinition> grandChildren, BaseWrapper v, boolean showCodeDetails, Map<String, String> displayHints) throws FHIRException, UnsupportedEncodingException, IOException {
        for (ElementDefinition e : grandChildren) {
            PropertyWrapper p = v.getChildByName(e.getPath().substring(e.getPath().lastIndexOf(".") + 1));
            if (p == null || p.getValues().size() == 0 || p.getValues().get(0) == null) {
                tr.addTag("td").addText(" ");
                continue;
            }
            this.renderLeaf(res, p.getValues().get(0), e, tr.addTag("td"), false, showCodeDetails, displayHints);
        }
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private boolean canDoTable(String path, PropertyWrapper p, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            List<PropertyWrapper> values = this.getValues(path, p, e);
            if (values.size() <= 1 && this.isPrimitive(e) && this.canCollapse(e)) continue;
            return false;
        }
        return true;
    }

    private List<PropertyWrapper> getValues(String path, PropertyWrapper p, ElementDefinition e) {
        ArrayList<PropertyWrapper> res = new ArrayList<PropertyWrapper>();
        for (BaseWrapper v : p.getValues()) {
            for (PropertyWrapper g2 : v.children()) {
                if (!(path + "." + p.getName() + "." + g2.getName()).equals(e.getPath())) continue;
                res.add(p);
            }
        }
        return res;
    }

    private boolean canCollapse(ElementDefinition e) {
        return !e.getType().isEmpty();
    }

    private boolean isPrimitive(ElementDefinition e) {
        if (e.getType().isEmpty()) {
            return false;
        }
        return e.getType().size() != 1 || !this.isBase(e.getType().get(0).getCode());
    }

    private boolean isBase(String code) {
        return code.equals("Element") || code.equals("BackboneElement");
    }

    private ElementDefinition getElementDefinition(List<ElementDefinition> elements, String path, PropertyWrapper p) {
        for (ElementDefinition element : elements) {
            if (!element.getPath().equals(path)) continue;
            return element;
        }
        if (path.endsWith("\"]") && p.getStructure() != null) {
            return p.getStructure().getSnapshot().getElement().get(0);
        }
        return null;
    }

    private void renderLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, boolean title, boolean showCodeDetails, Map<String, String> displayHints) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return;
        }
        Base e = ew.getBase();
        if (e instanceof StringType) {
            x.addText((String)((StringType)e).getValue());
        } else if (e instanceof CodeType) {
            x.addText((String)((CodeType)e).getValue());
        } else if (e instanceof IdType) {
            x.addText(((IdType)e).getValue());
        } else if (e instanceof Extension) {
            x.addText("Extensions: Todo");
        } else if (e instanceof InstantType) {
            x.addText(((InstantType)e).toHumanDisplay());
        } else if (e instanceof DateTimeType) {
            x.addText(((DateTimeType)e).toHumanDisplay());
        } else if (e instanceof Base64BinaryType) {
            x.addText(new Base64().encodeAsString((byte[])((Base64BinaryType)e).getValue()));
        } else if (e instanceof DateType) {
            x.addText(((DateType)e).toHumanDisplay());
        } else if (e instanceof Enumeration) {
            Object ev = ((Enumeration)e).getValue();
            x.addText(ev == null ? "" : ev.toString());
        } else if (e instanceof BooleanType) {
            x.addText(((Boolean)((BooleanType)e).getValue()).toString());
        } else if (e instanceof CodeableConcept) {
            this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
        } else if (e instanceof Coding) {
            this.renderCoding((Coding)e, x, showCodeDetails);
        } else if (e instanceof Annotation) {
            this.renderAnnotation((Annotation)e, x);
        } else if (e instanceof Identifier) {
            this.renderIdentifier((Identifier)e, x);
        } else if (e instanceof IntegerType) {
            x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
        } else if (e instanceof DecimalType) {
            x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
        } else if (e instanceof HumanName) {
            this.renderHumanName((HumanName)e, x);
        } else if (e instanceof SampledData) {
            this.renderSampledData((SampledData)e, x);
        } else if (e instanceof Address) {
            this.renderAddress((Address)e, x);
        } else if (e instanceof ContactPoint) {
            this.renderContactPoint((ContactPoint)e, x);
        } else if (e instanceof UriType) {
            this.renderUri((UriType)e, x);
        } else if (e instanceof Timing) {
            this.renderTiming((Timing)e, x);
        } else if (e instanceof Range) {
            this.renderRange((Range)e, x);
        } else if (e instanceof Quantity) {
            this.renderQuantity((Quantity)e, x, showCodeDetails);
        } else if (e instanceof Ratio) {
            this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
            x.addText("/");
            this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
        } else if (e instanceof Period) {
            Period p = (Period)e;
            x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
            x.addText(" --> ");
            x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
        } else if (e instanceof Reference) {
            Reference r = (Reference)e;
            XhtmlNode c = x;
            ResourceWithReference tr = null;
            if (r.hasReferenceElement()) {
                tr = this.resolveReference(res, r.getReference());
                if (!r.getReference().startsWith("#")) {
                    c = tr != null && tr.getReference() != null ? x.addTag("a").attribute("href", tr.getReference()) : x.addTag("a").attribute("href", r.getReference());
                }
            }
            if (r.hasDisplayElement()) {
                c.addText(r.getDisplay());
                if (tr != null) {
                    c.addText(". Generated Summary: ");
                    this.generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"));
                }
            } else if (tr != null) {
                this.generateResourceSummary(c, tr.getResource(), r.getReference().startsWith("#"), r.getReference().startsWith("#"));
            } else {
                c.addText(r.getReference());
            }
        } else {
            if (e instanceof Resource) {
                return;
            }
            if (e instanceof ElementDefinition) {
                x.addText("todo-bundle");
            } else if (!(e == null || e instanceof Attachment || e instanceof Narrative || e instanceof Meta)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
    }

    private boolean displayLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, String name, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return false;
        }
        Base e = ew.getBase();
        Map<String, String> displayHints = this.readDisplayHints(defn);
        if (name.endsWith("[x]")) {
            name = name.substring(0, name.length() - 3);
        }
        if (!showCodeDetails && e instanceof PrimitiveType && this.isDefault(displayHints, (PrimitiveType)e)) {
            return false;
        }
        if (e instanceof StringType) {
            x.addText(name + ": " + (String)((StringType)e).getValue());
            return true;
        }
        if (e instanceof CodeType) {
            x.addText(name + ": " + (String)((CodeType)e).getValue());
            return true;
        }
        if (e instanceof IdType) {
            x.addText(name + ": " + ((IdType)e).getValue());
            return true;
        }
        if (e instanceof DateTimeType) {
            x.addText(name + ": " + ((DateTimeType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof InstantType) {
            x.addText(name + ": " + ((InstantType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Extension) {
            x.addText("Extensions: todo");
            return true;
        }
        if (e instanceof DateType) {
            x.addText(name + ": " + ((DateType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Enumeration) {
            x.addText(((Enum)((Enumeration)e).getValue()).toString());
            return true;
        }
        if (e instanceof BooleanType) {
            if (((Boolean)((BooleanType)e).getValue()).booleanValue()) {
                x.addText(name);
                return true;
            }
        } else {
            if (e instanceof CodeableConcept) {
                this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Coding) {
                this.renderCoding((Coding)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Annotation) {
                this.renderAnnotation((Annotation)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
                return true;
            }
            if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
                return true;
            }
            if (e instanceof Identifier) {
                this.renderIdentifier((Identifier)e, x);
                return true;
            }
            if (e instanceof HumanName) {
                this.renderHumanName((HumanName)e, x);
                return true;
            }
            if (e instanceof SampledData) {
                this.renderSampledData((SampledData)e, x);
                return true;
            }
            if (e instanceof Address) {
                this.renderAddress((Address)e, x);
                return true;
            }
            if (e instanceof ContactPoint) {
                this.renderContactPoint((ContactPoint)e, x);
                return true;
            }
            if (e instanceof Timing) {
                this.renderTiming((Timing)e, x);
                return true;
            }
            if (e instanceof Quantity) {
                this.renderQuantity((Quantity)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Ratio) {
                this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
                x.addText("/");
                this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
                return true;
            }
            if (e instanceof Period) {
                Period p = (Period)e;
                x.addText(name + ": ");
                x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
                x.addText(" --> ");
                x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
                return true;
            }
            if (e instanceof Reference) {
                Reference r = (Reference)e;
                if (r.hasDisplayElement()) {
                    x.addText(r.getDisplay());
                } else if (r.hasReferenceElement()) {
                    ResourceWithReference tr = this.resolveReference(res, r.getReference());
                    x.addText(tr == null ? r.getReference() : "????");
                } else {
                    x.addText("??");
                }
                return true;
            }
            if (e instanceof Narrative) {
                return false;
            }
            if (e instanceof Resource) {
                return false;
            }
            if (!(e instanceof Attachment)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
        return false;
    }

    private Map<String, String> readDisplayHints(ElementDefinition defn) throws DefinitionException {
        String displayHint;
        HashMap<String, String> hints = new HashMap<String, String>();
        if (defn != null && !Utilities.noString(displayHint = ToolingExtensions.getDisplayHint(defn))) {
            String[] list;
            for (String item : list = displayHint.split(";")) {
                String[] parts = item.split(":");
                if (parts.length != 2) {
                    throw new DefinitionException("error reading display hint: '" + displayHint + "'");
                }
                hints.put(parts[0].trim(), parts[1].trim());
            }
        }
        return hints;
    }

    public static String displayPeriod(Period p) {
        String s2 = !p.hasStart() ? "??" : p.getStartElement().toHumanDisplay();
        s2 = s2 + " --> ";
        return s2 + (!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
    }

    private void generateResourceSummary(XhtmlNode x, ResourceWrapper res, boolean textAlready, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        String path;
        StructureDefinition profile;
        if (!textAlready) {
            XhtmlNode div = res.getNarrative();
            if (div != null) {
                if (div.allChildrenAreText()) {
                    x.getChildNodes().addAll(div.getChildNodes());
                }
                if (div.getChildNodes().size() == 1 && div.getChildNodes().get(0).allChildrenAreText()) {
                    x.getChildNodes().addAll(div.getChildNodes().get(0).getChildNodes());
                }
            }
            x.addText("Generated Summary: ");
        }
        if ((profile = this.context.fetchResource(StructureDefinition.class, path = res.getName())) == null) {
            x.addText("unknown resource " + path);
        } else {
            boolean firstElement = true;
            boolean last = false;
            for (PropertyWrapper p : res.children()) {
                ElementDefinition child = this.getElementDefinition(profile.getSnapshot().getElement(), path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || p.getValues().get(0) == null || child == null || !this.isPrimitive(child) || !this.includeInSummary(child)) continue;
                if (firstElement) {
                    firstElement = false;
                } else if (last) {
                    x.addText("; ");
                }
                boolean first = true;
                last = false;
                for (BaseWrapper v : p.getValues()) {
                    if (first) {
                        first = false;
                    } else if (last) {
                        x.addText(", ");
                    }
                    last = this.displayLeaf(res, v, child, x, p.getName(), showCodeDetails) || last;
                }
            }
        }
    }

    private boolean includeInSummary(ElementDefinition child) {
        String t;
        if (child.getIsModifier()) {
            return true;
        }
        if (child.getMustSupport()) {
            return true;
        }
        return child.getType().size() != 1 || !(t = child.getType().get(0).getCode()).equals("Address") && !t.equals("Contact") && !t.equals("Reference") && !t.equals("Uri");
    }

    private ResourceWithReference resolveReference(ResourceWrapper res, String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("#")) {
            for (ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new ResourceWithReference(null, r);
            }
            return null;
        }
        Object ae = this.context.fetchResource(null, url);
        if (ae == null) {
            return null;
        }
        return new ResourceWithReference(url, new ResourceWrapperDirect((Resource)ae));
    }

    private void renderCodeableConcept(CodeableConcept cc, XhtmlNode x, boolean showCodeDetails) {
        String s2 = cc.getText();
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s2 = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCodeElement() && c.hasSystemElement() && !Utilities.noString(s2 = this.lookupCode(c.getSystem(), c.getCode()))) break;
            }
        }
        if (Utilities.noString(s2)) {
            s2 = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        if (showCodeDetails) {
            x.addText(s2 + " ");
            XhtmlNode sp = x.addTag("span");
            sp.setAttribute("style", "background: LightGoldenRodYellow ");
            sp.addText("(Details ");
            boolean first = true;
            for (Coding c : cc.getCoding()) {
                if (first) {
                    sp.addText(": ");
                    first = false;
                } else {
                    sp.addText("; ");
                }
                sp.addText("{" + this.describeSystem(c.getSystem()) + " code '" + c.getCode() + "' = '" + this.lookupCode(c.getSystem(), c.getCode()) + (c.hasDisplay() ? "', given as '" + c.getDisplay() + "'}" : ""));
            }
            sp.addText(")");
        } else {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding c : cc.getCoding()) {
                if (!c.hasCodeElement() || !c.hasSystemElement()) continue;
                b.append("{" + c.getSystem() + " " + c.getCode() + "}");
            }
            x.addTag("span").setAttribute("title", "Codes: " + b.toString()).addText(s2);
        }
    }

    private void renderAnnotation(Annotation a, XhtmlNode x, boolean showCodeDetails) throws FHIRException {
        StringBuilder s2 = new StringBuilder();
        if (a.hasAuthor()) {
            s2.append("Author: ");
            if (a.hasAuthorReference()) {
                s2.append(a.getAuthorReference().getReference());
            } else if (a.hasAuthorStringType()) {
                s2.append((String)a.getAuthorStringType().getValue());
            }
        }
        if (a.hasTimeElement()) {
            if (s2.length() > 0) {
                s2.append("; ");
            }
            s2.append("Made: ").append(a.getTimeElement().toHumanDisplay());
        }
        if (a.hasText()) {
            if (s2.length() > 0) {
                s2.append("; ");
            }
            s2.append("Annotation: ").append(a.getText());
        }
        x.addText(s2.toString());
    }

    private void renderCoding(Coding c, XhtmlNode x, boolean showCodeDetails) {
        String s2 = "";
        if (c.hasDisplayElement()) {
            s2 = c.getDisplay();
        }
        if (Utilities.noString(s2)) {
            s2 = this.lookupCode(c.getSystem(), c.getCode());
        }
        if (Utilities.noString(s2)) {
            s2 = c.getCode();
        }
        if (showCodeDetails) {
            x.addText(s2 + " (Details: " + this.describeSystem(c.getSystem()) + " code " + c.getCode() + " = '" + this.lookupCode(c.getSystem(), c.getCode()) + "', stated as '" + c.getDisplay() + "')");
        } else {
            x.addTag("span").setAttribute("title", "{" + c.getSystem() + " " + c.getCode() + "}").addText(s2);
        }
    }

    private String describeSystem(String system) {
        if (system == null) {
            return "[not stated]";
        }
        if (system.equals("http://loinc.org")) {
            return "LOINC";
        }
        if (system.startsWith("http://snomed.info")) {
            return "SNOMED CT";
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return "RxNorm";
        }
        if (system.equals("http://hl7.org/fhir/sid/icd-9")) {
            return "ICD-9";
        }
        return system;
    }

    private String lookupCode(String system, String code) {
        IWorkerContext.ValidationResult t = this.context.validateCode(system, code, null);
        if (t != null && t.getDisplay() != null) {
            return t.getDisplay();
        }
        return code;
    }

    private ValueSet.ConceptDefinitionComponent findCode(String code, List<ValueSet.ConceptDefinitionComponent> list) {
        for (ValueSet.ConceptDefinitionComponent t : list) {
            if (code.equals(t.getCode())) {
                return t;
            }
            ValueSet.ConceptDefinitionComponent c = this.findCode(code, t.getConcept());
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private String displayCodeableConcept(CodeableConcept cc) {
        String s2 = cc.getText();
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s2 = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCode() && c.hasSystem() && !Utilities.noString(s2 = this.lookupCode(c.getSystem(), c.getCode()))) break;
            }
        }
        if (Utilities.noString(s2)) {
            s2 = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        return s2;
    }

    private void renderIdentifier(Identifier ii, XhtmlNode x) {
        x.addText(this.displayIdentifier(ii));
    }

    private void renderTiming(Timing s2, XhtmlNode x) throws FHIRException {
        x.addText(this.displayTiming(s2));
    }

    private void renderQuantity(Quantity q, XhtmlNode x, boolean showCodeDetails) {
        if (q.hasComparator()) {
            x.addText(q.getComparator().toCode());
        }
        x.addText(q.getValue().toString());
        if (q.hasUnit()) {
            x.addText(" " + q.getUnit());
        } else if (q.hasCode()) {
            x.addText(" " + q.getCode());
        }
        if (showCodeDetails && q.hasCode()) {
            XhtmlNode sp = x.addTag("span");
            sp.setAttribute("style", "background: LightGoldenRodYellow ");
            sp.addText(" (Details: " + this.describeSystem(q.getSystem()) + " code " + q.getCode() + " = '" + this.lookupCode(q.getSystem(), q.getCode()) + "')");
        }
    }

    private void renderRange(Range q, XhtmlNode x) {
        if (q.hasLow()) {
            x.addText(q.getLow().getValue().toString());
        } else {
            x.addText("?");
        }
        x.addText("-");
        if (q.hasHigh()) {
            x.addText(q.getHigh().getValue().toString());
        } else {
            x.addText("?");
        }
        if (q.getLow().hasUnit()) {
            x.addText(" " + q.getLow().getUnit());
        }
    }

    private void renderHumanName(HumanName name, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayHumanName(name));
    }

    private void renderAnnotation(Annotation annot, XhtmlNode x) {
        x.addText(annot.getText());
    }

    private void renderAddress(Address address, XhtmlNode x) {
        x.addText(this.displayAddress(address));
    }

    private void renderContactPoint(ContactPoint contact, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayContactPoint(contact));
    }

    private void renderUri(UriType uri, XhtmlNode x) {
        x.addTag("a").setAttribute("href", (String)uri.getValue()).addText((String)uri.getValue());
    }

    private void renderSampledData(SampledData sampledData, XhtmlNode x) {
        x.addText(this.displaySampledData(sampledData));
    }

    private String displaySampledData(SampledData s2) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s2.hasOrigin()) {
            b.append("Origin: " + this.displayQuantity(s2.getOrigin()));
        }
        if (s2.hasPeriod()) {
            b.append("Period: " + s2.getPeriod().toString());
        }
        if (s2.hasFactor()) {
            b.append("Factor: " + s2.getFactor().toString());
        }
        if (s2.hasLowerLimit()) {
            b.append("Lower: " + s2.getLowerLimit().toString());
        }
        if (s2.hasUpperLimit()) {
            b.append("Upper: " + s2.getUpperLimit().toString());
        }
        if (s2.hasDimensions()) {
            b.append("Dimensions: " + s2.getDimensions());
        }
        if (s2.hasData()) {
            b.append("Data: " + s2.getData());
        }
        return b.toString();
    }

    private String displayQuantity(Quantity q) {
        StringBuilder s2 = new StringBuilder();
        s2.append("(system = '").append(this.describeSystem(q.getSystem())).append("' code ").append(q.getCode()).append(" = '").append(this.lookupCode(q.getSystem(), q.getCode())).append("')");
        return s2.toString();
    }

    private String displayTiming(Timing s2) throws FHIRException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s2.hasCode()) {
            b.append("Code: " + this.displayCodeableConcept(s2.getCode()));
        }
        if (s2.getEvent().size() > 0) {
            CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
            for (DateTimeType p : s2.getEvent()) {
                c.append(p.toHumanDisplay());
            }
            b.append("Events: " + c.toString());
        }
        if (s2.hasRepeat()) {
            String st;
            Timing.TimingRepeatComponent rep = s2.getRepeat();
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasStart()) {
                b.append("Starting " + rep.getBoundsPeriod().getStartElement().toHumanDisplay());
            }
            if (rep.hasCount()) {
                b.append("Count " + Integer.toString(rep.getCount()) + " times");
            }
            if (rep.hasDuration()) {
                b.append("Duration " + rep.getDuration().toPlainString() + this.displayTimeUnits(rep.getPeriodUnits()));
            }
            if (rep.hasWhen()) {
                st = "";
                if (rep.hasPeriod()) {
                    st = rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = st + this.displayTimeUnits(rep.getPeriodUnits());
                }
                b.append("Do " + st + this.displayEventCode(rep.getWhen()));
            } else {
                st = "";
                if (!rep.hasFrequency() || !rep.hasFrequencyMax() && rep.getFrequency() == 1) {
                    st = "Once";
                } else {
                    st = Integer.toString(rep.getFrequency());
                    if (rep.hasFrequencyMax()) {
                        st = st + "-" + Integer.toString(rep.getFrequency());
                    }
                }
                if (rep.hasPeriod()) {
                    st = st + " per " + rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = st + " " + this.displayTimeUnits(rep.getPeriodUnits());
                }
                b.append("Do " + st);
            }
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasEnd()) {
                b.append("Until " + rep.getBoundsPeriod().getEndElement().toHumanDisplay());
            }
        }
        return b.toString();
    }

    private Object displayEventCode(Timing.EventTiming when) {
        switch (when) {
            case C: {
                return "at meals";
            }
            case CD: {
                return "at lunch";
            }
            case CM: {
                return "at breakfast";
            }
            case CV: {
                return "at dinner";
            }
            case AC: {
                return "before meals";
            }
            case ACD: {
                return "before lunch";
            }
            case ACM: {
                return "before breakfast";
            }
            case ACV: {
                return "before dinner";
            }
            case HS: {
                return "before sleeping";
            }
            case PC: {
                return "after meals";
            }
            case PCD: {
                return "after lunch";
            }
            case PCM: {
                return "after breakfast";
            }
            case PCV: {
                return "after dinner";
            }
            case WAKE: {
                return "after waking";
            }
        }
        return "??";
    }

    private String displayTimeUnits(Timing.UnitsOfTime units) {
        if (units == null) {
            return "??";
        }
        switch (units) {
            case A: {
                return "years";
            }
            case D: {
                return "days";
            }
            case H: {
                return "hours";
            }
            case MIN: {
                return "minutes";
            }
            case MO: {
                return "months";
            }
            case S: {
                return "seconds";
            }
            case WK: {
                return "weeks";
            }
        }
        return "??";
    }

    public static String displayHumanName(HumanName name) {
        StringBuilder s2 = new StringBuilder();
        if (name.hasText()) {
            s2.append(name.getText());
        } else {
            for (StringType p : name.getGiven()) {
                s2.append((String)p.getValue());
                s2.append(" ");
            }
            for (StringType p : name.getFamily()) {
                s2.append((String)p.getValue());
                s2.append(" ");
            }
        }
        if (name.hasUse() && name.getUse() != HumanName.NameUse.USUAL) {
            s2.append("(" + name.getUse().toString() + ")");
        }
        return s2.toString();
    }

    private String displayAddress(Address address) {
        StringBuilder s2 = new StringBuilder();
        if (address.hasText()) {
            s2.append(address.getText());
        } else {
            for (StringType p : address.getLine()) {
                s2.append((String)p.getValue());
                s2.append(" ");
            }
            if (address.hasCity()) {
                s2.append(address.getCity());
                s2.append(" ");
            }
            if (address.hasState()) {
                s2.append(address.getState());
                s2.append(" ");
            }
            if (address.hasPostalCode()) {
                s2.append(address.getPostalCode());
                s2.append(" ");
            }
            if (address.hasCountry()) {
                s2.append(address.getCountry());
                s2.append(" ");
            }
        }
        if (address.hasUse()) {
            s2.append("(" + address.getUse().toString() + ")");
        }
        return s2.toString();
    }

    public static String displayContactPoint(ContactPoint contact) {
        StringBuilder s2 = new StringBuilder();
        s2.append(NarrativeGenerator.describeSystem(contact.getSystem()));
        if (Utilities.noString(contact.getValue())) {
            s2.append("-unknown-");
        } else {
            s2.append(contact.getValue());
        }
        if (contact.hasUse()) {
            s2.append("(" + contact.getUse().toString() + ")");
        }
        return s2.toString();
    }

    private static String describeSystem(ContactPoint.ContactPointSystem system) {
        if (system == null) {
            return "";
        }
        switch (system) {
            case PHONE: {
                return "ph: ";
            }
            case FAX: {
                return "fax: ";
            }
        }
        return "";
    }

    private String displayIdentifier(Identifier ii) {
        String s2;
        String string = s2 = Utilities.noString(ii.getValue()) ? "??" : ii.getValue();
        if (ii.hasType()) {
            if (ii.getType().hasText()) {
                s2 = ii.getType().getText() + " = " + s2;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasDisplay()) {
                s2 = ii.getType().getCoding().get(0).getDisplay() + " = " + s2;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasCode()) {
                s2 = this.lookupCode(ii.getType().getCoding().get(0).getSystem(), ii.getType().getCoding().get(0).getCode()) + " = " + s2;
            }
        }
        if (ii.hasUse()) {
            s2 = s2 + " (" + ii.getUse().toString() + ")";
        }
        return s2;
    }

    private List<ElementDefinition> getChildrenForPath(List<ElementDefinition> elements, String path) throws DefinitionException {
        for (ElementDefinition e : elements) {
            if (!e.getPath().equals(path) || !e.hasNameReference()) continue;
            String name = e.getNameReference();
            ElementDefinition t = null;
            for (ElementDefinition e1 : elements) {
                if (!name.equals(e1.getName())) continue;
                t = e1;
            }
            if (t == null) {
                throw new DefinitionException("Unable to resolve name reference " + name + " trying to resolve " + path);
            }
            path = t.getPath();
            break;
        }
        ArrayList<ElementDefinition> results = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : elements) {
            if (!e.getPath().startsWith(path + ".") || e.getPath().substring(path.length() + 1).contains(".")) continue;
            results.add(e);
        }
        return results;
    }

    public void generate(ConceptMap cm) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("h2").addText(cm.getName() + " (" + cm.getUrl() + ")");
        XhtmlNode p = x.addTag("p");
        p.addText("Mapping from ");
        this.AddVsRef(((Reference)cm.getSource()).getReference(), p);
        p.addText(" to ");
        this.AddVsRef(((Reference)cm.getTarget()).getReference(), p);
        p = x.addTag("p");
        if (cm.getExperimental()) {
            p.addText(Utilities.capitalize(cm.getStatus().toString()) + " (not intended for production usage). ");
        } else {
            p.addText(Utilities.capitalize(cm.getStatus().toString()) + ". ");
        }
        p.addText("Published on " + cm.getDateElement().toHumanDisplay() + " by " + cm.getPublisher());
        if (!cm.getContact().isEmpty()) {
            p.addText(" (");
            boolean firsti = true;
            for (ConceptMap.ConceptMapContactComponent ci : cm.getContact()) {
                if (firsti) {
                    firsti = false;
                } else {
                    p.addText(", ");
                }
                if (ci.hasName()) {
                    p.addText(ci.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : ci.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        p.addText(", ");
                    }
                    this.addTelecom(p, c);
                }
                p.addText("; ");
            }
            p.addText(")");
        }
        p.addText(". ");
        p.addText(cm.getCopyright());
        if (!Utilities.noString(cm.getDescription())) {
            x.addTag("p").addText(cm.getDescription());
        }
        x.addTag("br");
        if (!cm.getElement().isEmpty()) {
            ConceptMap.TargetElementComponent ccm;
            String display;
            XhtmlNode tr;
            XhtmlNode tbl;
            ConceptMap.SourceElementComponent cc = cm.getElement().get(0);
            String src = cc.getCodeSystem();
            boolean comments = false;
            boolean ok = cc.getTarget().size() == 1;
            HashMap sources = new HashMap();
            sources.put("code", new HashSet());
            HashMap targets = new HashMap();
            targets.put("code", new HashSet());
            if (ok) {
                String dst = cc.getTarget().get(0).getCodeSystem();
                for (ConceptMap.SourceElementComponent ccl : cm.getElement()) {
                    boolean bl = ok = ok && src.equals(ccl.getCodeSystem()) && ccl.getTarget().size() == 1 && dst.equals(ccl.getTarget().get(0).getCodeSystem()) && ccl.getTarget().get(0).getDependsOn().isEmpty() && ccl.getTarget().get(0).getProduct().isEmpty();
                    if (ccl.hasCodeSystem()) {
                        ((HashSet)sources.get("code")).add(ccl.getCodeSystem());
                    }
                    for (ConceptMap.TargetElementComponent ccm2 : ccl.getTarget()) {
                        comments = comments || !Utilities.noString(ccm2.getComments());
                        for (ConceptMap.OtherElementComponent d : ccm2.getDependsOn()) {
                            if (!sources.containsKey(d.getElement())) {
                                sources.put(d.getElement(), new HashSet());
                            }
                            ((HashSet)sources.get(d.getElement())).add(d.getCodeSystem());
                        }
                        if (ccm2.hasCodeSystem()) {
                            ((HashSet)targets.get("code")).add(ccm2.getCodeSystem());
                        }
                        for (ConceptMap.OtherElementComponent d : ccm2.getProduct()) {
                            if (!targets.containsKey(d.getElement())) {
                                targets.put(d.getElement(), new HashSet());
                            }
                            ((HashSet)targets.get(d.getElement())).add(d.getCodeSystem());
                        }
                    }
                }
            }
            if (ok) {
                tbl = x.addTag("table").setAttribute("class", "grid");
                tr = tbl.addTag("tr");
                tr.addTag("td").addTag("b").addText("Source Code");
                tr.addTag("td").addTag("b").addText("Equivalence");
                tr.addTag("td").addTag("b").addText("Destination Code");
                if (comments) {
                    tr.addTag("td").addTag("b").addText("Comments");
                }
                for (ConceptMap.SourceElementComponent ccl : cm.getElement()) {
                    tr = tbl.addTag("tr");
                    XhtmlNode td = tr.addTag("td");
                    td.addText(ccl.getCode());
                    display = this.getDisplayForConcept(ccl.getCodeSystem(), ccl.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    ccm = ccl.getTarget().get(0);
                    tr.addTag("td").addText(!ccm.hasEquivalence() ? "" : ccm.getEquivalence().toCode());
                    td = tr.addTag("td");
                    td.addText(ccm.getCode());
                    display = this.getDisplayForConcept(ccm.getCodeSystem(), ccm.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    if (!comments) continue;
                    tr.addTag("td").addText(ccm.getComments());
                }
            } else {
                tbl = x.addTag("table").setAttribute("class", "grid");
                tr = tbl.addTag("tr");
                tr.addTag("td").setAttribute("colspan", Integer.toString(sources.size())).addTag("b").addText("Source Concept");
                tr.addTag("td").addTag("b").addText("Equivalence");
                tr.addTag("td").setAttribute("colspan", Integer.toString(targets.size())).addTag("b").addText("Destination Concept");
                if (comments) {
                    tr.addTag("td").addTag("b").addText("Comments");
                }
                tr = tbl.addTag("tr");
                if (((HashSet)sources.get("code")).size() == 1) {
                    tr.addTag("td").addTag("b").addText("Code " + ((HashSet)sources.get("code")).toString() + "");
                } else {
                    tr.addTag("td").addTag("b").addText("Code");
                }
                for (String s2 : sources.keySet()) {
                    if (s2.equals("code")) continue;
                    if (((HashSet)sources.get(s2)).size() == 1) {
                        tr.addTag("td").addTag("b").addText(this.getDescForConcept(s2) + " " + ((HashSet)sources.get(s2)).toString());
                        continue;
                    }
                    tr.addTag("td").addTag("b").addText(this.getDescForConcept(s2));
                }
                tr.addTag("td");
                if (((HashSet)targets.get("code")).size() == 1) {
                    tr.addTag("td").addTag("b").addText("Code " + ((HashSet)targets.get("code")).toString());
                } else {
                    tr.addTag("td").addTag("b").addText("Code");
                }
                for (String s2 : targets.keySet()) {
                    if (s2.equals("code")) continue;
                    if (((HashSet)targets.get(s2)).size() == 1) {
                        tr.addTag("td").addTag("b").addText(this.getDescForConcept(s2) + " " + ((HashSet)targets.get(s2)).toString() + "");
                        continue;
                    }
                    tr.addTag("td").addTag("b").addText(this.getDescForConcept(s2));
                }
                if (comments) {
                    tr.addTag("td");
                }
                for (ConceptMap.SourceElementComponent ccl : cm.getElement()) {
                    tr = tbl.addTag("tr");
                    XhtmlNode td = tr.addTag("td");
                    if (((HashSet)sources.get("code")).size() == 1) {
                        td.addText(ccl.getCode());
                    } else {
                        td.addText(ccl.getCodeSystem() + " / " + ccl.getCode());
                    }
                    display = this.getDisplayForConcept(ccl.getCodeSystem(), ccl.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    ccm = ccl.getTarget().get(0);
                    for (String s3 : sources.keySet()) {
                        if (s3.equals("code")) continue;
                        td = tr.addTag("td");
                        td.addText(this.getCode(ccm.getDependsOn(), s3, ((HashSet)sources.get(s3)).size() != 1));
                        display = this.getDisplay(ccm.getDependsOn(), s3);
                        if (display == null) continue;
                        td.addText(" (" + display + ")");
                    }
                    tr.addTag("td").addText(ccm.getEquivalence().toString());
                    td = tr.addTag("td");
                    if (((HashSet)targets.get("code")).size() == 1) {
                        td.addText(ccm.getCode());
                    } else {
                        td.addText(ccm.getCodeSystem() + " / " + ccm.getCode());
                    }
                    display = this.getDisplayForConcept(ccm.getCodeSystem(), ccm.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    for (String s3 : targets.keySet()) {
                        if (s3.equals("code")) continue;
                        td = tr.addTag("td");
                        td.addText(this.getCode(ccm.getProduct(), s3, ((HashSet)targets.get(s3)).size() != 1));
                        display = this.getDisplay(ccm.getProduct(), s3);
                        if (display == null) continue;
                        td.addText(" (" + display + ")");
                    }
                    if (!comments) continue;
                    tr.addTag("td").addText(ccm.getComments());
                }
            }
        }
        this.inject(cm, x, Narrative.NarrativeStatus.GENERATED);
    }

    private void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        if (!r.hasText() || !r.getText().hasDiv() || r.getText().getDiv().getChildNodes().isEmpty()) {
            r.setText(new Narrative());
            r.getText().setDiv(x);
            r.getText().setStatus(status);
        } else {
            XhtmlNode n = r.getText().getDiv();
            n.addTag("hr");
            n.getChildNodes().addAll(x.getChildNodes());
        }
    }

    public Element getNarrative(Element er) {
        Element txt = XMLUtil.getNamedChild(er, "text");
        if (txt == null) {
            return null;
        }
        return XMLUtil.getNamedChild(txt, "div");
    }

    private void inject(Element er, XhtmlNode x, Narrative.NarrativeStatus status) {
        Element st;
        Element txt = XMLUtil.getNamedChild(er, "text");
        if (txt == null) {
            txt = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "text");
            Element n = XMLUtil.getFirstChild(er);
            while (n != null && (n.getNodeName().equals("id") || n.getNodeName().equals("meta") || n.getNodeName().equals("implicitRules") || n.getNodeName().equals("language"))) {
                n = XMLUtil.getNextSibling(n);
            }
            if (n == null) {
                er.appendChild(txt);
            } else {
                er.insertBefore(txt, n);
            }
        }
        if ((st = XMLUtil.getNamedChild(txt, "status")) == null) {
            st = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "status");
            Element n = XMLUtil.getFirstChild(txt);
            if (n == null) {
                txt.appendChild(st);
            } else {
                txt.insertBefore(st, n);
            }
        }
        st.setAttribute("value", status.toCode());
        Element div = XMLUtil.getNamedChild(txt, "div");
        if (div == null) {
            div = er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "div");
            div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            txt.appendChild(div);
        }
        if (div.hasChildNodes()) {
            div.appendChild(er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "hr"));
        }
        new XhtmlComposer(true, this.pretty).compose(div, x);
    }

    private String getDisplay(List<ConceptMap.OtherElementComponent> list, String s2) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s2.equals(c.getElement())) continue;
            return this.getDisplayForConcept(c.getCodeSystem(), c.getCode());
        }
        return null;
    }

    private String getDisplayForConcept(String system, String code) {
        if (code == null) {
            return null;
        }
        IWorkerContext.ValidationResult cl = this.context.validateCode(system, code, null);
        return cl == null ? null : cl.getDisplay();
    }

    private String getDescForConcept(String s2) {
        if (s2.startsWith("http://hl7.org/fhir/v2/element/")) {
            return "v2 " + s2.substring("http://hl7.org/fhir/v2/element/".length());
        }
        return s2;
    }

    private String getCode(List<ConceptMap.OtherElementComponent> list, String s2, boolean withSystem) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s2.equals(c.getElement())) continue;
            if (withSystem) {
                return c.getCodeSystem() + " / " + c.getCode();
            }
            return c.getCode();
        }
        return null;
    }

    private void addTelecom(XhtmlNode p, ContactPoint c) {
        if (c.getSystem() == ContactPoint.ContactPointSystem.PHONE) {
            p.addText("Phone: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.FAX) {
            p.addText("Fax: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
            p.addTag("a").setAttribute("href", "mailto:" + c.getValue()).addText(c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.OTHER) {
            if (c.getValue().length() > 30) {
                p.addTag("a").setAttribute("href", c.getValue()).addText(c.getValue().substring(0, 30) + "...");
            } else {
                p.addTag("a").setAttribute("href", c.getValue()).addText(c.getValue());
            }
        }
    }

    public void generate(ValueSet vs, boolean header) {
        this.generate(vs, null, header);
    }

    public void generate(ValueSet vs, ValueSet src, boolean header) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        if (vs.hasExpansion()) {
            this.generateExpansion(x, vs, src, header);
        }
        boolean hasExtensions = false;
        if (vs.hasCodeSystem()) {
            hasExtensions = this.generateDefinition(x, vs, header);
        }
        if (vs.hasCompose()) {
            hasExtensions = this.generateComposition(x, vs, header) || hasExtensions;
        }
        this.inject(vs, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    private Integer countMembership(ValueSet vs) {
        int count = 0;
        if (vs.hasExpansion()) {
            count += this.conceptCount(vs.getExpansion().getContains());
        } else {
            if (vs.hasCodeSystem()) {
                count += this.countConcepts(vs.getCodeSystem().getConcept());
            }
            if (vs.hasCompose()) {
                if (vs.getCompose().hasExclude()) {
                    try {
                        ValueSetExpander.ValueSetExpansionOutcome vse = this.context.expandVS(vs, true);
                        count = 0;
                        return count += this.conceptCount(vse.getValueset().getExpansion().getContains());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                    if (inc.hasFilter()) {
                        return null;
                    }
                    if (!inc.hasConcept()) {
                        return null;
                    }
                    count += inc.getConcept().size();
                }
            }
        }
        return count;
    }

    private int conceptCount(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        int count = 0;
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (!c.getAbstract()) {
                ++count;
            }
            count += this.conceptCount(c.getContains());
        }
        return count;
    }

    private int countConcepts(List<ValueSet.ConceptDefinitionComponent> list) {
        int count = list.size();
        for (ValueSet.ConceptDefinitionComponent c : list) {
            if (!c.hasConcept()) continue;
            count += this.countConcepts(c.getConcept());
        }
        return count;
    }

    private boolean generateExpansion(XhtmlNode x, ValueSet vs, ValueSet src, boolean header) {
        boolean hasExtensions = false;
        HashMap<ConceptMap, String> mymaps = new HashMap<ConceptMap, String>();
        for (ConceptMap a : this.context.findMapsForSource(vs.getUrl())) {
            String url = "";
            ValueSet vsr = this.context.fetchResource(ValueSet.class, ((Reference)a.getTarget()).getReference());
            if (vsr != null) {
                url = (String)vsr.getUserData("filename");
            }
            mymaps.put(a, url);
        }
        if (header) {
            XhtmlNode h2 = x.addTag("h3");
            h2.addText("Value Set Contents");
            if (this.IsNotFixedExpansion(vs)) {
                x.addTag("p").addText(vs.getDescription());
            }
            if (vs.hasCopyright()) {
                this.generateCopyright(x, vs);
            }
        }
        if (ToolingExtensions.hasExtension(vs.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
            x.addTag("p").setAttribute("style", "border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(this.tooCostlyNote);
        } else {
            Integer count = this.countMembership(vs);
            if (count == null) {
                x.addTag("p").addText("This value set does not contain a fixed number of concepts");
            } else {
                x.addTag("p").addText("This value set contains " + count.toString() + " concepts");
            }
        }
        boolean doSystem = this.checkDoSystem(vs, src);
        if (doSystem && this.allFromOneSystem(vs)) {
            doSystem = false;
            XhtmlNode p = x.addTag("p");
            p.addText("All codes from system ");
            p.addTag("code").addText(vs.getExpansion().getContains().get(0).getSystem());
        }
        XhtmlNode t = x.addTag("table").setAttribute("class", "codes");
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("td").addTag("b").addText("Code");
        if (doSystem) {
            tr.addTag("td").addTag("b").addText("System");
        }
        tr.addTag("td").addTag("b").addText("Display");
        this.addMapHeaders(tr, mymaps);
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.addExpansionRowToTable(t, c, 0, doSystem, mymaps);
        }
        return hasExtensions;
    }

    private boolean allFromOneSystem(ValueSet vs) {
        if (vs.getExpansion().getContains().isEmpty()) {
            return false;
        }
        String system = vs.getExpansion().getContains().get(0).getSystem();
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (this.checkSystemMatches(system, cc)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSystemMatches(String system, ValueSet.ValueSetExpansionContainsComponent cc) {
        if (!system.equals(cc.getSystem())) {
            return false;
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : cc.getContains()) {
            if (this.checkSystemMatches(system, cc1)) continue;
            return false;
        }
        return true;
    }

    private boolean checkDoSystem(ValueSet vs, ValueSet src) {
        if (src != null) {
            vs = src;
        }
        if (!vs.hasCodeSystem()) {
            return true;
        }
        return vs.hasCompose();
    }

    private boolean IsNotFixedExpansion(ValueSet vs) {
        if (vs.hasCompose()) {
            return false;
        }
        if (vs.getCompose().hasImport()) {
            return true;
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            if (cc.hasVersion()) continue;
            return true;
        }
        return false;
    }

    private boolean generateDefinition(XhtmlNode x, ValueSet vs, boolean header) {
        boolean hasExtensions = false;
        HashMap<ConceptMap, String> mymaps = new HashMap<ConceptMap, String>();
        for (ConceptMap a : this.context.findMapsForSource(vs.getUrl())) {
            String url = "";
            ValueSet vsr = this.context.fetchResource(ValueSet.class, ((Reference)a.getTarget()).getReference());
            if (vsr != null) {
                url = (String)vsr.getUserData("filename");
            }
            mymaps.put(a, url);
        }
        for (Resource r : vs.getContained()) {
            ConceptMap cm;
            if (!(r instanceof ConceptMap) || !((Reference)(cm = (ConceptMap)r).getSource()).getReference().equals(vs.getUrl())) continue;
            String url = "";
            ValueSet vsr = this.context.fetchResource(ValueSet.class, ((Reference)cm.getTarget()).getReference());
            if (vsr != null) {
                url = (String)vsr.getUserData("filename");
            }
            mymaps.put(cm, url);
        }
        ArrayList<String> langs = new ArrayList<String>();
        if (header) {
            XhtmlNode h2 = x.addTag("h2");
            h2.addText(vs.getName());
            XhtmlNode p = x.addTag("p");
            this.smartAddText(p, vs.getDescription());
            if (vs.hasCopyright()) {
                this.generateCopyright(x, vs);
            }
        }
        XhtmlNode p = x.addTag("p");
        p.addText("This value set has an inline code system " + vs.getCodeSystem().getSystem() + ", which defines the following codes:");
        XhtmlNode t = x.addTag("table").setAttribute("class", "codes");
        boolean commentS = false;
        boolean deprecated = false;
        boolean display = false;
        boolean hierarchy = false;
        for (ValueSet.ConceptDefinitionComponent c : vs.getCodeSystem().getConcept()) {
            commentS = commentS || this.conceptsHaveComments(c);
            deprecated = deprecated || this.conceptsHaveDeprecated(c);
            display = display || this.conceptsHaveDisplay(c);
            hierarchy = hierarchy || c.hasConcept();
            this.scanLangs(c, langs);
        }
        this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, true, commentS, deprecated), mymaps);
        for (ValueSet.ConceptDefinitionComponent c : vs.getCodeSystem().getConcept()) {
            hasExtensions = this.addDefineRowToTable(t, c, 0, hierarchy, display, commentS, deprecated, mymaps, vs.getCodeSystem().getSystem()) || hasExtensions;
        }
        if (langs.size() > 0) {
            Collections.sort(langs);
            x.addTag("p").addTag("b").addText("Additional Language Displays");
            t = x.addTag("table").setAttribute("class", "codes");
            XhtmlNode tr = t.addTag("tr");
            tr.addTag("td").addTag("b").addText("Code");
            for (String lang : langs) {
                tr.addTag("td").addTag("b").addText(lang);
            }
            for (ValueSet.ConceptDefinitionComponent c : vs.getCodeSystem().getConcept()) {
                this.addLanguageRow(c, t, langs);
            }
        }
        return hasExtensions;
    }

    private void addLanguageRow(ValueSet.ConceptDefinitionComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("td").addText(c.getCode());
        for (String lang : langs) {
            ValueSet.ConceptDefinitionDesignationComponent d = null;
            for (ValueSet.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
                if (!lang.equals(designation.getLanguage())) continue;
                d = designation;
            }
            tr.addTag("td").addText(d == null ? "" : d.getValue());
        }
    }

    private void scanLangs(ValueSet.ConceptDefinitionComponent c, List<String> langs) {
        for (ValueSet.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
            String lang = designation.getLanguage();
            if (langs == null || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ConceptDefinitionComponent g2 : c.getConcept()) {
            this.scanLangs(g2, langs);
        }
    }

    private void addMapHeaders(XhtmlNode tr, Map<ConceptMap, String> mymaps) {
        for (ConceptMap m3 : mymaps.keySet()) {
            XhtmlNode td = tr.addTag("td");
            XhtmlNode b = td.addTag("b");
            XhtmlNode a = b.addTag("a");
            a.setAttribute("href", this.prefix + mymaps.get(m3));
            a.addText(m3.hasDescription() ? m3.getDescription() : m3.getName());
        }
    }

    private void smartAddText(XhtmlNode p, String text) {
        if (text == null) {
            return;
        }
        String[] lines = text.split("\\r\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                p.addTag("br");
            }
            p.addText(lines[i]);
        }
    }

    private boolean conceptsHaveComments(ValueSet.ConceptDefinitionComponent c) {
        if (ToolingExtensions.hasComment(c)) {
            return true;
        }
        for (ValueSet.ConceptDefinitionComponent g2 : c.getConcept()) {
            if (!this.conceptsHaveComments(g2)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDisplay(ValueSet.ConceptDefinitionComponent c) {
        if (c.hasDisplay()) {
            return true;
        }
        for (ValueSet.ConceptDefinitionComponent g2 : c.getConcept()) {
            if (!this.conceptsHaveDisplay(g2)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDeprecated(ValueSet.ConceptDefinitionComponent c) {
        if (ToolingExtensions.hasDeprecated(c)) {
            return true;
        }
        for (ValueSet.ConceptDefinitionComponent g2 : c.getConcept()) {
            if (!this.conceptsHaveDeprecated(g2)) continue;
            return true;
        }
        return false;
    }

    private void generateCopyright(XhtmlNode x, ValueSet vs) {
        XhtmlNode p = x.addTag("p");
        p.addTag("b").addText("Copyright Statement:");
        this.smartAddText(p, " " + vs.getCopyright());
    }

    private XhtmlNode addTableHeaderRowStandard(XhtmlNode t, boolean hasHierarchy, boolean hasDisplay, boolean definitions, boolean comments, boolean deprecated) {
        XhtmlNode tr = t.addTag("tr");
        if (hasHierarchy) {
            tr.addTag("td").addTag("b").addText("Lvl");
        }
        tr.addTag("td").addTag("b").addText("Code");
        if (hasDisplay) {
            tr.addTag("td").addTag("b").addText("Display");
        }
        if (definitions) {
            tr.addTag("td").addTag("b").addText("Definition");
        }
        if (deprecated) {
            tr.addTag("td").addTag("b").addText("Deprecated");
        }
        if (comments) {
            tr.addTag("td").addTag("b").addText("Comments");
        }
        return tr;
    }

    private void addExpansionRowToTable(XhtmlNode t, ValueSet.ValueSetExpansionContainsComponent c, int i, boolean doSystem, Map<ConceptMap, String> mymaps) {
        XhtmlNode tr = t.addTag("tr");
        XhtmlNode td = tr.addTag("td");
        String tgt = this.makeAnchor(c.getSystem(), c.getCode());
        td.addTag("a").setAttribute("name", tgt).addText(" ");
        String s2 = Utilities.padLeft("", '.', i * 2);
        td.addText(s2);
        ValueSet e = this.context.fetchCodeSystem(c.getSystem());
        if (e == null) {
            td.addText(c.getCode());
        } else {
            XhtmlNode a = td.addTag("a");
            a.addText(c.getCode());
            a.setAttribute("href", this.prefix + this.getCsRef(e) + "#" + Utilities.nmtokenize(c.getCode()));
        }
        if (doSystem) {
            td = tr.addTag("td");
            td.addText(c.getSystem());
        }
        td = tr.addTag("td");
        if (c.hasDisplayElement()) {
            td.addText(c.getDisplay());
        }
        for (ConceptMap m3 : mymaps.keySet()) {
            td = tr.addTag("td");
            List<ConceptMap.TargetElementComponent> mappings = this.findMappingsForCode(c.getCode(), m3);
            boolean first = true;
            for (ConceptMap.TargetElementComponent mapping : mappings) {
                if (!first) {
                    td.addTag("br");
                }
                first = false;
                XhtmlNode span = td.addTag("span");
                span.setAttribute("title", mapping.getEquivalence().toString());
                span.addText(this.getCharForEquivalence(mapping));
                XhtmlNode a = td.addTag("a");
                a.setAttribute("href", this.prefix + mymaps.get(m3) + "#" + mapping.getCode());
                a.addText(mapping.getCode());
                if (Utilities.noString(mapping.getComments())) continue;
                td.addTag("i").addText("(" + mapping.getComments() + ")");
            }
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addExpansionRowToTable(t, cc, i + 1, doSystem, mymaps);
        }
    }

    private boolean addDefineRowToTable(XhtmlNode t, ValueSet.ConceptDefinitionComponent c, int i, boolean hasHierarchy, boolean hasDisplay, boolean comment, boolean deprecated, Map<ConceptMap, String> maps, String system) {
        XhtmlNode a;
        boolean hasExtensions = false;
        XhtmlNode tr = t.addTag("tr");
        XhtmlNode td = tr.addTag("td");
        if (hasHierarchy) {
            td.addText(Integer.toString(i + 1));
            td = tr.addTag("td");
            String s2 = Utilities.padLeft("", '\u00a0', i * 2);
            td.addText(s2);
        }
        td.addText(c.getCode());
        if (c.hasCodeElement()) {
            a = td.addTag("a");
            a.setAttribute("name", Utilities.nmtokenize(c.getCode()));
            a.addText(" ");
        }
        if (hasDisplay) {
            td = tr.addTag("td");
            if (c.hasDisplayElement()) {
                td.addText(c.getDisplay());
            }
        }
        td = tr.addTag("td");
        if (c != null) {
            this.smartAddText(td, c.getDefinition());
        }
        if (deprecated) {
            td = tr.addTag("td");
            Boolean b = ToolingExtensions.getDeprecated(c);
            if (b != null && b.booleanValue()) {
                this.smartAddText(td, "Deprecated");
                hasExtensions = true;
                if (ToolingExtensions.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby")) {
                    Coding coding = (Coding)ToolingExtensions.getExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby").getValue();
                    td.addText(" (replaced by ");
                    String url = this.getCodingReference(coding, system);
                    if (url != null) {
                        td.addTag("a").setAttribute("href", url).addText(coding.getCode());
                        td.addText(": " + coding.getDisplay() + ")");
                    } else {
                        td.addText(coding.getCode() + " '" + coding.getDisplay() + "' in " + coding.getSystem() + ")");
                    }
                }
            }
        }
        if (comment) {
            td = tr.addTag("td");
            String s3 = ToolingExtensions.getComment(c);
            if (s3 != null) {
                this.smartAddText(td, s3);
                hasExtensions = true;
            }
        }
        for (ConceptMap conceptMap : maps.keySet()) {
            td = tr.addTag("td");
            List<ConceptMap.TargetElementComponent> mappings = this.findMappingsForCode(c.getCode(), conceptMap);
            boolean first = true;
            for (ConceptMap.TargetElementComponent mapping : mappings) {
                if (!first) {
                    td.addTag("br");
                }
                first = false;
                XhtmlNode span = td.addTag("span");
                span.setAttribute("title", mapping.hasEquivalence() ? mapping.getEquivalence().toCode() : "");
                span.addText(this.getCharForEquivalence(mapping));
                a = td.addTag("a");
                a.setAttribute("href", this.prefix + maps.get(conceptMap) + "#" + this.makeAnchor(mapping.getCodeSystem(), mapping.getCode()));
                a.addText(mapping.getCode());
                if (Utilities.noString(mapping.getComments())) continue;
                td.addTag("i").addText("(" + mapping.getComments() + ")");
            }
        }
        for (CodeType codeType : ToolingExtensions.getSubsumes(c)) {
            hasExtensions = true;
            tr = t.addTag("tr");
            td = tr.addTag("td");
            String s4 = Utilities.padLeft("", '.', i * 2);
            td.addText(s4);
            a = td.addTag("a");
            a.setAttribute("href", "#" + Utilities.nmtokenize((String)codeType.getValue()));
            a.addText(c.getCode());
        }
        for (ValueSet.ConceptDefinitionComponent conceptDefinitionComponent : c.getConcept()) {
            hasExtensions = this.addDefineRowToTable(t, conceptDefinitionComponent, i + 1, hasHierarchy, hasDisplay, comment, deprecated, maps, system) || hasExtensions;
        }
        return hasExtensions;
    }

    private String makeAnchor(String codeSystem, String code) {
        String s2 = codeSystem + '-' + code;
        StringBuilder b = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '.') {
                b.append(c);
                continue;
            }
            b.append('-');
        }
        return b.toString();
    }

    private String getCodingReference(Coding cc, String system) {
        if (cc.getSystem().equals(system)) {
            return "#" + cc.getCode();
        }
        if (cc.getSystem().equals("http://snomed.info/sct")) {
            return "http://snomed.info/sct/" + cc.getCode();
        }
        if (cc.getSystem().equals("http://loinc.org")) {
            return "http://s.details.loinc.org/LOINC/" + cc.getCode() + ".html";
        }
        return null;
    }

    private String getCharForEquivalence(ConceptMap.TargetElementComponent mapping) {
        if (!mapping.hasEquivalence()) {
            return "";
        }
        switch (mapping.getEquivalence()) {
            case EQUAL: {
                return "=";
            }
            case EQUIVALENT: {
                return "~";
            }
            case WIDER: {
                return "<";
            }
            case NARROWER: {
                return ">";
            }
            case INEXACT: {
                return "><";
            }
            case UNMATCHED: {
                return "-";
            }
            case DISJOINT: {
                return "!=";
            }
        }
        return "?";
    }

    private List<ConceptMap.TargetElementComponent> findMappingsForCode(String code, ConceptMap map) {
        ArrayList<ConceptMap.TargetElementComponent> mappings = new ArrayList<ConceptMap.TargetElementComponent>();
        for (ConceptMap.SourceElementComponent c : map.getElement()) {
            if (!c.getCode().equals(code)) continue;
            mappings.addAll(c.getTarget());
        }
        return mappings;
    }

    private boolean generateComposition(XhtmlNode x, ValueSet vs, boolean header) {
        XhtmlNode p;
        boolean hasExtensions = false;
        if (!vs.hasCodeSystem()) {
            if (header) {
                XhtmlNode h2 = x.addTag("h2");
                h2.addText(vs.getName());
                XhtmlNode p2 = x.addTag("p");
                this.smartAddText(p2, vs.getDescription());
                if (vs.hasCopyrightElement()) {
                    this.generateCopyright(x, vs);
                }
            }
            p = x.addTag("p");
            p.addText("This value set includes codes from the following code systems:");
        } else {
            p = x.addTag("p");
            p.addText("In addition, this value set includes codes from other code systems:");
        }
        XhtmlNode ul = x.addTag("ul");
        for (UriType imp : vs.getCompose().getImport()) {
            XhtmlNode li = ul.addTag("li");
            li.addText("Import all the codes that are contained in ");
            this.AddVsRef((String)imp.getValue(), li);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            hasExtensions = this.genInclude(ul, inc, "Include") || hasExtensions;
        }
        for (ValueSet.ConceptSetComponent exc : vs.getCompose().getExclude()) {
            hasExtensions = this.genInclude(ul, exc, "Exclude") || hasExtensions;
        }
        return hasExtensions;
    }

    private void AddVsRef(String value, XhtmlNode li) {
        ValueSet vs = this.context.fetchResource(ValueSet.class, value);
        if (vs == null) {
            vs = this.context.fetchCodeSystem(value);
        }
        if (vs != null) {
            String ref = (String)vs.getUserData("path");
            ref = this.adjustForPath(ref);
            XhtmlNode a = li.addTag("a");
            a.setAttribute("href", ref == null ? "??" : ref.replace("\\", "/"));
            a.addText(value);
        } else if (value.equals("http://snomed.info/sct") || value.equals("http://snomed.info/id")) {
            XhtmlNode a = li.addTag("a");
            a.setAttribute("href", value);
            a.addText("SNOMED-CT");
        } else {
            li.addText(value);
        }
    }

    private String adjustForPath(String ref) {
        if (this.prefix == null) {
            return ref;
        }
        return this.prefix + ref;
    }

    private boolean genInclude(XhtmlNode ul, ValueSet.ConceptSetComponent inc, String type) {
        boolean hasExtensions = false;
        XhtmlNode li = ul.addTag("li");
        ValueSet e = this.context.fetchCodeSystem(inc.getSystem());
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            li.addText(type + " all codes defined in ");
            this.addCsRef(inc, li, e);
        } else {
            if (inc.getConcept().size() > 0) {
                li.addText(type + " these codes as defined in ");
                this.addCsRef(inc, li, e);
                XhtmlNode t = li.addTag("table");
                boolean hasComments = false;
                boolean hasDefinition = false;
                for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                    hasComments = hasComments || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-comments");
                    hasDefinition = hasDefinition || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-definition");
                }
                if (hasComments || hasDefinition) {
                    hasExtensions = true;
                }
                this.addTableHeaderRowStandard(t, false, true, hasDefinition, hasComments, false);
                for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                    XhtmlNode tr = t.addTag("tr");
                    tr.addTag("td").addText(c.getCode());
                    ValueSet.ConceptDefinitionComponent cc = this.getConceptForCode(e, c.getCode(), inc.getSystem());
                    XhtmlNode td = tr.addTag("td");
                    if (!Utilities.noString(c.getDisplay())) {
                        td.addText(c.getDisplay());
                    } else if (cc != null && !Utilities.noString(cc.getDisplay())) {
                        td.addText(cc.getDisplay());
                    }
                    td = tr.addTag("td");
                    if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-definition")) {
                        this.smartAddText(td, ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-definition"));
                    } else if (cc != null && !Utilities.noString(cc.getDefinition())) {
                        this.smartAddText(td, cc.getDefinition());
                    }
                    if (!ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-comments")) continue;
                    this.smartAddText(tr.addTag("td"), "Note: " + ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-comments"));
                }
            }
            boolean first = true;
            for (ValueSet.ConceptSetFilterComponent f : inc.getFilter()) {
                String disp;
                if (first) {
                    li.addText(type + " codes from ");
                    first = false;
                } else {
                    li.addText(" and ");
                }
                this.addCsRef(inc, li, e);
                li.addText(" where " + f.getProperty() + " " + this.describe(f.getOp()) + " ");
                if (e != null && this.codeExistsInValueSet(e, f.getValue())) {
                    XhtmlNode a = li.addTag("a");
                    a.addText(f.getValue());
                    a.setAttribute("href", this.prefix + this.getCsRef(e) + "#" + Utilities.nmtokenize(f.getValue()));
                } else {
                    li.addText(f.getValue());
                }
                if ((disp = ToolingExtensions.getDisplayHint(f)) == null) continue;
                li.addText(" (" + disp + ")");
            }
        }
        return hasExtensions;
    }

    private String describe(ValueSet.FilterOperator opSimple) {
        switch (opSimple) {
            case EQUAL: {
                return " = ";
            }
            case ISA: {
                return " is-a ";
            }
            case ISNOTA: {
                return " is-not-a ";
            }
            case REGEX: {
                return " matches (by regex) ";
            }
            case NULL: {
                return " ?? ";
            }
            case IN: {
                return " in ";
            }
            case NOTIN: {
                return " not in ";
            }
        }
        return null;
    }

    private <T extends Resource> ValueSet.ConceptDefinitionComponent getConceptForCode(T e, String code, String system) {
        if (e == null) {
            return this.context.validateCode(system, code, null).asConceptDefinition();
        }
        ValueSet vs = (ValueSet)e;
        if (!vs.hasCodeSystem()) {
            return null;
        }
        for (ValueSet.ConceptDefinitionComponent c : vs.getCodeSystem().getConcept()) {
            ValueSet.ConceptDefinitionComponent v = this.getConceptForCode(c, code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private ValueSet.ConceptDefinitionComponent getConceptForCode(ValueSet.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (ValueSet.ConceptDefinitionComponent cc : c.getConcept()) {
            ValueSet.ConceptDefinitionComponent v = this.getConceptForCode(cc, code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private <T extends Resource> void addCsRef(ValueSet.ConceptSetComponent inc, XhtmlNode li, T cs) {
        String ref = null;
        if (cs != null && Utilities.noString(ref = (String)cs.getUserData("filename"))) {
            ref = (String)cs.getUserData("path");
        }
        if (cs != null && ref != null) {
            if (!Utilities.noString(this.prefix) && ref.startsWith("http://hl7.org/fhir/")) {
                ref = ref.substring(20) + "/index.html";
            } else if (!ref.endsWith(".html")) {
                ref = ref + ".html";
            }
            XhtmlNode a = li.addTag("a");
            a.setAttribute("href", this.prefix + ref.replace("\\", "/"));
            a.addText(inc.getSystem().toString());
        } else {
            li.addText(inc.getSystem().toString());
        }
    }

    private <T extends Resource> String getCsRef(T cs) {
        String ref = (String)cs.getUserData("filename");
        if (ref == null) {
            return "??";
        }
        if (!ref.endsWith(".html")) {
            ref = ref + ".html";
        }
        return ref.replace("\\", "/");
    }

    private <T extends Resource> boolean codeExistsInValueSet(T cs, String code) {
        ValueSet vs = (ValueSet)cs;
        for (ValueSet.ConceptDefinitionComponent c : vs.getCodeSystem().getConcept()) {
            if (!this.inConcept(code, c)) continue;
            return true;
        }
        return false;
    }

    private boolean inConcept(String code, ValueSet.ConceptDefinitionComponent c) {
        if (c.hasCodeElement() && c.getCode().equals(code)) {
            return true;
        }
        for (ValueSet.ConceptDefinitionComponent g2 : c.getConcept()) {
            if (!this.inConcept(code, g2)) continue;
            return true;
        }
        return false;
    }

    public void generate(OperationOutcome op) throws DefinitionException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasSource = false;
        boolean success = true;
        for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
            success = success && i.getSeverity() == OperationOutcome.IssueSeverity.INFORMATION;
            hasSource = hasSource || ExtensionHelper.hasExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        }
        if (success) {
            x.addTag("p").addText("All OK");
        }
        if (op.getIssue().size() > 0) {
            XhtmlNode tbl = x.addTag("table");
            tbl.setAttribute("class", "grid");
            XhtmlNode tr = tbl.addTag("tr");
            tr.addTag("td").addTag("b").addText("Severity");
            tr.addTag("td").addTag("b").addText("Location");
            tr.addTag("td").addTag("b").addText("Code");
            tr.addTag("td").addTag("b").addText("Details");
            tr.addTag("td").addTag("b").addText("Diagnostics");
            if (hasSource) {
                tr.addTag("td").addTag("b").addText("Source");
            }
            for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
                tr = tbl.addTag("tr");
                tr.addTag("td").addText(i.getSeverity().toString());
                XhtmlNode td = tr.addTag("td");
                boolean d = false;
                for (StringType s2 : i.getLocation()) {
                    if (d) {
                        td.addText(", ");
                    } else {
                        d = true;
                    }
                    td.addText((String)s2.getValue());
                }
                tr.addTag("td").addText(i.getCode().getDisplay());
                tr.addTag("td").addText(this.gen(i.getDetails()));
                this.smartAddText(tr.addTag("td"), i.getDiagnostics());
                if (!hasSource) continue;
                Extension ext = ExtensionHelper.getExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
                tr.addTag("td").addText(ext == null ? "" : this.gen(ext));
            }
        }
        this.inject(op, x, hasSource ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    private String gen(Extension extension) throws DefinitionException {
        if (extension.getValue() instanceof CodeType) {
            return (String)((CodeType)extension.getValue()).getValue();
        }
        if (extension.getValue() instanceof Coding) {
            return this.gen((Coding)extension.getValue());
        }
        throw new DefinitionException("Unhandled type " + extension.getValue().getClass().getName());
    }

    private String gen(CodeableConcept code) {
        if (code == null) {
            return null;
        }
        if (code.hasText()) {
            return code.getText();
        }
        if (code.hasCoding()) {
            return this.gen(code.getCoding().get(0));
        }
        return null;
    }

    private String gen(Coding code) {
        if (code == null) {
            return null;
        }
        if (code.hasDisplayElement()) {
            return code.getDisplay();
        }
        if (code.hasCodeElement()) {
            return code.getCode();
        }
        return null;
    }

    public void generate(OperationDefinition opd) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("h2").addText(opd.getName());
        x.addTag("p").addText(Utilities.capitalize(opd.getKind().toString()) + ": " + opd.getName());
        this.addMarkdown(x, opd.getDescription());
        if (opd.getSystem()) {
            x.addTag("p").addText("URL: [base]/$" + opd.getCode());
        }
        for (CodeType c : opd.getType()) {
            x.addTag("p").addText("URL: [base]/" + (String)c.getValue() + "/$" + opd.getCode());
            if (!opd.getInstance()) continue;
            x.addTag("p").addText("URL: [base]/" + (String)c.getValue() + "/[id]/$" + opd.getCode());
        }
        x.addTag("p").addText("Parameters");
        XhtmlNode tbl = x.addTag("table").setAttribute("class", "grid");
        XhtmlNode tr = tbl.addTag("tr");
        tr.addTag("td").addTag("b").addText("Use");
        tr.addTag("td").addTag("b").addText("Name");
        tr.addTag("td").addTag("b").addText("Cardinality");
        tr.addTag("td").addTag("b").addText("Type");
        tr.addTag("td").addTag("b").addText("Binding");
        tr.addTag("td").addTag("b").addText("Documentation");
        for (OperationDefinition.OperationDefinitionParameterComponent p : opd.getParameter()) {
            this.genOpParam(tbl, "", p);
        }
        this.addMarkdown(x, opd.getNotes());
        this.inject(opd, x, Narrative.NarrativeStatus.GENERATED);
    }

    private void genOpParam(XhtmlNode tbl, String path, OperationDefinition.OperationDefinitionParameterComponent p) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode tr = tbl.addTag("tr");
        tr.addTag("td").addText(p.getUse().toString());
        tr.addTag("td").addText(path + p.getName());
        tr.addTag("td").addText(Integer.toString(p.getMin()) + ".." + p.getMax());
        tr.addTag("td").addText(p.hasType() ? p.getType() : "");
        XhtmlNode td = tr.addTag("td");
        if (p.hasBinding() && p.getBinding().hasValueSet()) {
            if (p.getBinding().getValueSet() instanceof Reference) {
                this.AddVsRef(p.getBinding().getValueSetReference().getReference(), td);
            } else {
                td.addTag("a").setAttribute("href", (String)p.getBinding().getValueSetUriType().getValue()).addText("External Reference");
            }
            td.addText(" (" + p.getBinding().getStrength().getDisplay() + ")");
        }
        this.addMarkdown(tr.addTag("td"), p.getDocumentation());
        if (!p.hasType()) {
            for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
                this.genOpParam(tbl, path + p.getName() + ".", pp);
            }
        }
    }

    private void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            while (text.contains("[[[")) {
                String left = text.substring(0, text.indexOf("[[["));
                String link = text.substring(text.indexOf("[[[") + 3, text.indexOf("]]]"));
                String right = text.substring(text.indexOf("]]]") + 3);
                String url = link;
                String[] parts = link.split("\\#");
                StructureDefinition p = this.context.fetchResource(StructureDefinition.class, parts[0]);
                if (p == null) {
                    p = this.context.fetchTypeDefinition(parts[0]);
                }
                if (p == null) {
                    p = this.context.fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    url = p.getUserString("path");
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException("Unable to resolve markdown link " + link);
                }
                text = left + "[" + link + "](" + url + ")" + right;
            }
            String s2 = new MarkDownProcessor(MarkDownProcessor.Dialect.DARING_FIREBALL).process(Utilities.escapeXml(text), "NarrativeGenerator");
            XhtmlParser p = new XhtmlParser();
            XhtmlDocument m3 = p.parse("<div>" + s2 + "</div>", "div");
            x.getChildNodes().addAll(m3.getChildNodes());
        }
    }

    public void generate(Conformance conf) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("h2").addText(conf.getName());
        this.smartAddText(x.addTag("p"), conf.getDescription());
        Conformance.ConformanceRestComponent rest = conf.getRest().get(0);
        XhtmlNode t = x.addTag("table");
        this.addTableRow(t, "Mode", rest.getMode().toString());
        this.addTableRow(t, "Description", rest.getDocumentation());
        this.addTableRow(t, "Transaction", this.showOp(rest, Conformance.SystemRestfulInteraction.TRANSACTION));
        this.addTableRow(t, "System History", this.showOp(rest, Conformance.SystemRestfulInteraction.HISTORYSYSTEM));
        this.addTableRow(t, "System Search", this.showOp(rest, Conformance.SystemRestfulInteraction.SEARCHSYSTEM));
        t = x.addTag("table");
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("th").addTag("b").addText("Resource Type");
        tr.addTag("th").addTag("b").addText("Profile");
        tr.addTag("th").addTag("b").addText("Read");
        tr.addTag("th").addTag("b").addText("V-Read");
        tr.addTag("th").addTag("b").addText("Search");
        tr.addTag("th").addTag("b").addText("Update");
        tr.addTag("th").addTag("b").addText("Updates");
        tr.addTag("th").addTag("b").addText("Create");
        tr.addTag("th").addTag("b").addText("Delete");
        tr.addTag("th").addTag("b").addText("History");
        for (Conformance.ConformanceRestResourceComponent r : rest.getResource()) {
            tr = t.addTag("tr");
            tr.addTag("td").addText(r.getType());
            if (r.hasProfile()) {
                XhtmlNode a = tr.addTag("td").addTag("a");
                a.addText(r.getProfile().getReference());
                a.setAttribute("href", this.prefix + r.getProfile().getReference());
            }
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.READ));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.VREAD));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.SEARCHTYPE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.UPDATE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.HISTORYINSTANCE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.CREATE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.DELETE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.HISTORYTYPE));
        }
        this.inject(conf, x, Narrative.NarrativeStatus.GENERATED);
    }

    private String showOp(Conformance.ConformanceRestResourceComponent r, Conformance.TypeRestfulInteraction on) {
        for (Conformance.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private String showOp(Conformance.ConformanceRestComponent r, Conformance.SystemRestfulInteraction on) {
        for (Conformance.SystemInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private void addTableRow(XhtmlNode t, String name, String value) {
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("td").addText(name);
        tr.addTag("td").addText(value);
    }

    public XhtmlNode generateDocumentNarrative(Bundle feed) {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        Composition comp = (Composition)feed.getEntry().get(0).getResource();
        root.getChildNodes().add(comp.getText().getDiv());
        Resource subject = ResourceUtilities.getById(feed, null, comp.getSubject().getReference());
        if (subject != null && subject instanceof DomainResource) {
            root.addTag("hr");
            root.getChildNodes().add(((DomainResource)subject).getText().getDiv());
        }
        List<Composition.SectionComponent> sections = comp.getSection();
        this.renderSections(feed, root, sections, 1);
        return root;
    }

    private void renderSections(Bundle feed, XhtmlNode node, List<Composition.SectionComponent> sections, int level) {
        for (Composition.SectionComponent section : sections) {
            node.addTag("hr");
            if (!section.hasTitleElement()) continue;
            node.addTag("h" + Integer.toString(level)).addText(section.getTitle());
        }
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public class ResourceWithReference {
        private String reference;
        private ResourceWrapper resource;

        public ResourceWithReference(String reference, ResourceWrapper resource) {
            this.reference = reference;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public ResourceWrapper getResource() {
            return this.resource;
        }
    }

    private class ResourceWrapperDirect
    implements ResourceWrapper {
        private Resource wrapped;

        private ResourceWrapperDirect(Resource wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            ArrayList<ResourceWrapper> list = new ArrayList<ResourceWrapper>();
            if (this.wrapped instanceof DomainResource) {
                DomainResource dr = (DomainResource)this.wrapped;
                for (Resource c : dr.getContained()) {
                    list.add(new ResourceWrapperDirect(c));
                }
            }
            return list;
        }

        @Override
        public String getId() {
            return this.wrapped.getId();
        }

        @Override
        public XhtmlNode getNarrative() {
            DomainResource dr;
            if (this.wrapped instanceof DomainResource && (dr = (DomainResource)this.wrapped).hasText() && dr.getText().hasDiv()) {
                return dr.getText().getDiv();
            }
            return null;
        }

        @Override
        public String getName() {
            return this.wrapped.getResourceType().toString();
        }

        @Override
        public List<PropertyWrapper> children() {
            ArrayList<PropertyWrapper> list = new ArrayList<PropertyWrapper>();
            for (Property c : this.wrapped.children()) {
                list.add(new PropertyWrapperDirect(c));
            }
            return list;
        }
    }

    private class BaseWrapperDirect
    implements BaseWrapper {
        private Base wrapped;
        private List<PropertyWrapper> list;

        private BaseWrapperDirect(Base wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public Base getBase() {
            return this.wrapped;
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.list = new ArrayList<PropertyWrapper>();
                for (Property p : this.wrapped.children()) {
                    this.list.add(new PropertyWrapperDirect(p));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            Property p = this.wrapped.getChildByName(name);
            if (p == null) {
                return null;
            }
            return new PropertyWrapperDirect(p);
        }
    }

    private class PropertyWrapperDirect
    implements PropertyWrapper {
        private Property wrapped;
        private List<BaseWrapper> list;

        private PropertyWrapperDirect(Property wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public boolean hasValues() {
            return this.wrapped.hasValues();
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Base b : this.wrapped.getValues()) {
                    this.list.add(b == null ? null : new BaseWrapperDirect(b));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.wrapped.getTypeCode();
        }

        @Override
        public String getDefinition() {
            return this.wrapped.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public int getMaxCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public StructureDefinition getStructure() {
            return this.wrapped.getStructure();
        }
    }

    private class ResurceWrapperElement
    implements ResourceWrapper {
        private Element wrapped;
        private StructureDefinition definition;
        private List<ResourceWrapper> list;
        private List<PropertyWrapper> list2;

        public ResurceWrapperElement(Element wrapped, StructureDefinition definition) {
            this.wrapped = wrapped;
            this.definition = definition;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            if (this.list == null) {
                ArrayList<Element> children = new ArrayList<Element>();
                XMLUtil.getNamedChildren(this.wrapped, "contained", children);
                this.list = new ArrayList<ResourceWrapper>();
                for (Element e : children) {
                    Element c = XMLUtil.getFirstChild(e);
                    this.list.add(new ResurceWrapperElement(c, NarrativeGenerator.this.context.fetchTypeDefinition(c.getNodeName())));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return XMLUtil.getNamedChildValue(this.wrapped, "id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = XMLUtil.getNamedChild(this.wrapped, "text");
            if (txt == null) {
                return null;
            }
            Element div = XMLUtil.getNamedChild(txt, "div");
            if (div == null) {
                return null;
            }
            return new XhtmlParser().parse(new XmlGenerator().generate(div), "div");
        }

        @Override
        public String getName() {
            return this.wrapped.getNodeName();
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = ProfileUtilities.getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard(this.wrapped, NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list2.add(new PropertyWrapperElement(this.definition, child, elements));
                }
            }
            return this.list2;
        }
    }

    private class PropertyWrapperElement
    implements PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrapper> list;

        public PropertyWrapperElement(StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return NarrativeGenerator.this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperElement(e, this.determineType(e), this.structure, this.definition));
                }
            }
            return this.list;
        }

        private String determineType(Element e) {
            if (this.definition.getType().isEmpty()) {
                return null;
            }
            if (this.definition.getType().size() == 1) {
                if (this.definition.getType().get(0).getCode().equals("Element") || this.definition.getType().get(0).getCode().equals("BackboneElement")) {
                    return null;
                }
                return this.definition.getType().get(0).getCode();
            }
            String t = e.getNodeName().substring(NarrativeGenerator.this.tail(this.definition.getPath()).length() - 3);
            boolean allReference = true;
            for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
                if (tr.getCode().equals("Reference")) continue;
                allReference = false;
            }
            if (allReference) {
                return "Reference";
            }
            if (ProfileUtilities.isPrimitive(t)) {
                return Utilities.uncapitalize(t);
            }
            return t;
        }

        @Override
        public String getTypeCode() {
            throw new Error("todo");
        }

        @Override
        public String getDefinition() {
            throw new Error("todo");
        }

        @Override
        public int getMinCardinality() {
            throw new Error("todo");
        }

        @Override
        public int getMaxCardinality() {
            throw new Error("todo");
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }
    }

    private class BaseWrapperElement
    implements BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<PropertyWrapper> list;

        public BaseWrapperElement(Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            String xml = new XmlGenerator().generate(this.element);
            return NarrativeGenerator.this.context.newXmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).parseType(xml, this.type);
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.children = ProfileUtilities.getChildList(this.structure, this.definition);
                this.list = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard(this.element, NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list.add(new PropertyWrapperElement(this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    private static interface BaseWrapper {
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException;

        public List<PropertyWrapper> children();

        public PropertyWrapper getChildByName(String var1);
    }

    private static interface ResourceWrapper {
        public List<ResourceWrapper> getContained();

        public String getId();

        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException;

        public String getName();

        public List<PropertyWrapper> children();
    }

    private static interface PropertyWrapper {
        public String getName();

        public boolean hasValues();

        public List<BaseWrapper> getValues();

        public String getTypeCode();

        public String getDefinition();

        public int getMinCardinality();

        public int getMaxCardinality();

        public StructureDefinition getStructure();
    }
}

