/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="VisionPrescription", profile="http://hl7.org/fhir/Profile/VisionPrescription")
public class VisionPrescription
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifier which may be used by other parties to reference or identify the prescription.")
    protected List<Identifier> identifier;
    @Child(name="dateWritten", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When prescription was authorized", formalDefinition="The date (and perhaps time) when the prescription was written.")
    protected DateTimeType dateWritten;
    @Child(name="patient", type={Patient.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who prescription is for", formalDefinition="A link to a resource representing the person to whom the vision products will be supplied.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="prescriber", type={Practitioner.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who authorizes the vision product", formalDefinition="The healthcare professional responsible for authorizing the prescription.")
    protected Reference prescriber;
    protected Practitioner prescriberTarget;
    @Child(name="encounter", type={Encounter.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Created during encounter / admission / stay", formalDefinition="A link to a resource that identifies the particular occurrence of contact between patient and health care provider.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="reason", type={CodeableConcept.class, Condition.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason or indication for writing the prescription", formalDefinition="Can be the reason or the indication for writing the prescription.")
    protected Type reason;
    @Child(name="dispense", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Vision supply authorization", formalDefinition="Deals with details of the dispense part of the supply specification.")
    protected List<VisionPrescriptionDispenseComponent> dispense;
    private static final long serialVersionUID = -1108276057L;
    @SearchParamDefinition(name="prescriber", path="VisionPrescription.prescriber", description="Who authorizes the vision product", type="reference")
    public static final String SP_PRESCRIBER = "prescriber";
    @SearchParamDefinition(name="identifier", path="VisionPrescription.identifier", description="Return prescriptions with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="patient", path="VisionPrescription.patient", description="The identity of a patient to list dispenses for", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="datewritten", path="VisionPrescription.dateWritten", description="Return prescriptions written on this date", type="date")
    public static final String SP_DATEWRITTEN = "datewritten";
    @SearchParamDefinition(name="encounter", path="VisionPrescription.encounter", description="Return prescriptions with this encounter identifier", type="reference")
    public static final String SP_ENCOUNTER = "encounter";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public VisionPrescription addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public DateTimeType getDateWrittenElement() {
        if (this.dateWritten == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.dateWritten");
            }
            if (Configuration.doAutoCreate()) {
                this.dateWritten = new DateTimeType();
            }
        }
        return this.dateWritten;
    }

    public boolean hasDateWrittenElement() {
        return this.dateWritten != null && !this.dateWritten.isEmpty();
    }

    public boolean hasDateWritten() {
        return this.dateWritten != null && !this.dateWritten.isEmpty();
    }

    public VisionPrescription setDateWrittenElement(DateTimeType value) {
        this.dateWritten = value;
        return this;
    }

    public Date getDateWritten() {
        return this.dateWritten == null ? null : (Date)this.dateWritten.getValue();
    }

    public VisionPrescription setDateWritten(Date value) {
        if (value == null) {
            this.dateWritten = null;
        } else {
            if (this.dateWritten == null) {
                this.dateWritten = new DateTimeType();
            }
            this.dateWritten.setValue(value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public VisionPrescription setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public VisionPrescription setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getPrescriber() {
        if (this.prescriber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.prescriber");
            }
            if (Configuration.doAutoCreate()) {
                this.prescriber = new Reference();
            }
        }
        return this.prescriber;
    }

    public boolean hasPrescriber() {
        return this.prescriber != null && !this.prescriber.isEmpty();
    }

    public VisionPrescription setPrescriber(Reference value) {
        this.prescriber = value;
        return this;
    }

    public Practitioner getPrescriberTarget() {
        if (this.prescriberTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.prescriber");
            }
            if (Configuration.doAutoCreate()) {
                this.prescriberTarget = new Practitioner();
            }
        }
        return this.prescriberTarget;
    }

    public VisionPrescription setPrescriberTarget(Practitioner value) {
        this.prescriberTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public VisionPrescription setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public VisionPrescription setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public VisionPrescription setReason(Type value) {
        this.reason = value;
        return this;
    }

    public List<VisionPrescriptionDispenseComponent> getDispense() {
        if (this.dispense == null) {
            this.dispense = new ArrayList<VisionPrescriptionDispenseComponent>();
        }
        return this.dispense;
    }

    public boolean hasDispense() {
        if (this.dispense == null) {
            return false;
        }
        for (VisionPrescriptionDispenseComponent item : this.dispense) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public VisionPrescriptionDispenseComponent addDispense() {
        VisionPrescriptionDispenseComponent t = new VisionPrescriptionDispenseComponent();
        if (this.dispense == null) {
            this.dispense = new ArrayList<VisionPrescriptionDispenseComponent>();
        }
        this.dispense.add(t);
        return t;
    }

    public VisionPrescription addDispense(VisionPrescriptionDispenseComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dispense == null) {
            this.dispense = new ArrayList<VisionPrescriptionDispenseComponent>();
        }
        this.dispense.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier which may be used by other parties to reference or identify the prescription.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("dateWritten", "dateTime", "The date (and perhaps time) when the prescription was written.", 0, Integer.MAX_VALUE, this.dateWritten));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person to whom the vision products will be supplied.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_PRESCRIBER, "Reference(Practitioner)", "The healthcare professional responsible for authorizing the prescription.", 0, Integer.MAX_VALUE, this.prescriber));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "A link to a resource that identifies the particular occurrence of contact between patient and health care provider.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("reason[x]", "CodeableConcept|Reference(Condition)", "Can be the reason or the indication for writing the prescription.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("dispense", "", "Deals with details of the dispense part of the supply specification.", 0, Integer.MAX_VALUE, this.dispense));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("dateWritten")) {
            this.dateWritten = this.castToDateTime(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_PRESCRIBER)) {
            this.prescriber = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("reason[x]")) {
            this.reason = (Type)value;
        } else if (name.equals("dispense")) {
            this.getDispense().add((VisionPrescriptionDispenseComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("dateWritten")) {
            throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.dateWritten");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_PRESCRIBER)) {
            this.prescriber = new Reference();
            return this.prescriber;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("dispense")) {
            return this.addDispense();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "VisionPrescription";
    }

    @Override
    public VisionPrescription copy() {
        VisionPrescription dst = new VisionPrescription();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.dateWritten = this.dateWritten == null ? null : this.dateWritten.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.prescriber = this.prescriber == null ? null : this.prescriber.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        Type type = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.dispense != null) {
            dst.dispense = new ArrayList<VisionPrescriptionDispenseComponent>();
            for (VisionPrescriptionDispenseComponent visionPrescriptionDispenseComponent : this.dispense) {
                dst.dispense.add(visionPrescriptionDispenseComponent.copy());
            }
        }
        return dst;
    }

    protected VisionPrescription typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof VisionPrescription)) {
            return false;
        }
        VisionPrescription o = (VisionPrescription)other;
        return VisionPrescription.compareDeep(this.identifier, o.identifier, true) && VisionPrescription.compareDeep(this.dateWritten, o.dateWritten, true) && VisionPrescription.compareDeep(this.patient, o.patient, true) && VisionPrescription.compareDeep(this.prescriber, o.prescriber, true) && VisionPrescription.compareDeep(this.encounter, o.encounter, true) && VisionPrescription.compareDeep(this.reason, o.reason, true) && VisionPrescription.compareDeep(this.dispense, o.dispense, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof VisionPrescription)) {
            return false;
        }
        VisionPrescription o = (VisionPrescription)other;
        return VisionPrescription.compareValues(this.dateWritten, o.dateWritten, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.dateWritten != null && !this.dateWritten.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.prescriber != null && !this.prescriber.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.dispense != null && !this.dispense.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.VisionPrescription;
    }

    @Block
    public static class VisionPrescriptionDispenseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="product", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Product to be supplied", formalDefinition="Identifies the type of vision correction product which is required for the patient.")
        protected Coding product;
        @Child(name="eye", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="right | left", formalDefinition="The eye for which the lens applies.")
        protected Enumeration<VisionEyes> eye;
        @Child(name="sphere", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens sphere", formalDefinition="Lens power measured in diopters (0.25 units).")
        protected DecimalType sphere;
        @Child(name="cylinder", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens cylinder", formalDefinition="Power adjustment for astigmatism measured in diopters (0.25 units).")
        protected DecimalType cylinder;
        @Child(name="axis", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens axis", formalDefinition="Adjustment for astigmatism measured in integer degrees.")
        protected IntegerType axis;
        @Child(name="prism", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens prism", formalDefinition="Amount of prism to compensate for eye alignment in fractional units.")
        protected DecimalType prism;
        @Child(name="base", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="up | down | in | out", formalDefinition="The relative base, or reference lens edge, for the prism.")
        protected Enumeration<VisionBase> base;
        @Child(name="add", type={DecimalType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens add", formalDefinition="Power adjustment for multifocal lenses measured in diopters (0.25 units).")
        protected DecimalType add;
        @Child(name="power", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contact lens power", formalDefinition="Contact lens power measured in diopters (0.25 units).")
        protected DecimalType power;
        @Child(name="backCurve", type={DecimalType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contact lens back curvature", formalDefinition="Back curvature measured in millimeters.")
        protected DecimalType backCurve;
        @Child(name="diameter", type={DecimalType.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contact lens diameter", formalDefinition="Contact lens diameter measured in millimeters.")
        protected DecimalType diameter;
        @Child(name="duration", type={SimpleQuantity.class}, order=12, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens wear duration", formalDefinition="The recommended maximum wear period for the lens.")
        protected SimpleQuantity duration;
        @Child(name="color", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens add", formalDefinition="Special color or pattern.")
        protected StringType color;
        @Child(name="brand", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lens add", formalDefinition="Brand recommendations or restrictions.")
        protected StringType brand;
        @Child(name="notes", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Notes for coatings", formalDefinition="Notes for special requirements such as coatings and lens materials.")
        protected StringType notes;
        private static final long serialVersionUID = -1586392610L;

        public VisionPrescriptionDispenseComponent() {
        }

        public VisionPrescriptionDispenseComponent(Coding product) {
            this.product = product;
        }

        public Coding getProduct() {
            if (this.product == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.product");
                }
                if (Configuration.doAutoCreate()) {
                    this.product = new Coding();
                }
            }
            return this.product;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setProduct(Coding value) {
            this.product = value;
            return this;
        }

        public Enumeration<VisionEyes> getEyeElement() {
            if (this.eye == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.eye");
                }
                if (Configuration.doAutoCreate()) {
                    this.eye = new Enumeration<VisionEyes>(new VisionEyesEnumFactory());
                }
            }
            return this.eye;
        }

        public boolean hasEyeElement() {
            return this.eye != null && !this.eye.isEmpty();
        }

        public boolean hasEye() {
            return this.eye != null && !this.eye.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setEyeElement(Enumeration<VisionEyes> value) {
            this.eye = value;
            return this;
        }

        public VisionEyes getEye() {
            return this.eye == null ? null : (VisionEyes)((Object)this.eye.getValue());
        }

        public VisionPrescriptionDispenseComponent setEye(VisionEyes value) {
            if (value == null) {
                this.eye = null;
            } else {
                if (this.eye == null) {
                    this.eye = new Enumeration<VisionEyes>(new VisionEyesEnumFactory());
                }
                this.eye.setValue((Object)value);
            }
            return this;
        }

        public DecimalType getSphereElement() {
            if (this.sphere == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.sphere");
                }
                if (Configuration.doAutoCreate()) {
                    this.sphere = new DecimalType();
                }
            }
            return this.sphere;
        }

        public boolean hasSphereElement() {
            return this.sphere != null && !this.sphere.isEmpty();
        }

        public boolean hasSphere() {
            return this.sphere != null && !this.sphere.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setSphereElement(DecimalType value) {
            this.sphere = value;
            return this;
        }

        public BigDecimal getSphere() {
            return this.sphere == null ? null : (BigDecimal)this.sphere.getValue();
        }

        public VisionPrescriptionDispenseComponent setSphere(BigDecimal value) {
            if (value == null) {
                this.sphere = null;
            } else {
                if (this.sphere == null) {
                    this.sphere = new DecimalType();
                }
                this.sphere.setValue(value);
            }
            return this;
        }

        public DecimalType getCylinderElement() {
            if (this.cylinder == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.cylinder");
                }
                if (Configuration.doAutoCreate()) {
                    this.cylinder = new DecimalType();
                }
            }
            return this.cylinder;
        }

        public boolean hasCylinderElement() {
            return this.cylinder != null && !this.cylinder.isEmpty();
        }

        public boolean hasCylinder() {
            return this.cylinder != null && !this.cylinder.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setCylinderElement(DecimalType value) {
            this.cylinder = value;
            return this;
        }

        public BigDecimal getCylinder() {
            return this.cylinder == null ? null : (BigDecimal)this.cylinder.getValue();
        }

        public VisionPrescriptionDispenseComponent setCylinder(BigDecimal value) {
            if (value == null) {
                this.cylinder = null;
            } else {
                if (this.cylinder == null) {
                    this.cylinder = new DecimalType();
                }
                this.cylinder.setValue(value);
            }
            return this;
        }

        public IntegerType getAxisElement() {
            if (this.axis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.axis");
                }
                if (Configuration.doAutoCreate()) {
                    this.axis = new IntegerType();
                }
            }
            return this.axis;
        }

        public boolean hasAxisElement() {
            return this.axis != null && !this.axis.isEmpty();
        }

        public boolean hasAxis() {
            return this.axis != null && !this.axis.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setAxisElement(IntegerType value) {
            this.axis = value;
            return this;
        }

        public int getAxis() {
            return this.axis == null || this.axis.isEmpty() ? 0 : (Integer)this.axis.getValue();
        }

        public VisionPrescriptionDispenseComponent setAxis(int value) {
            if (this.axis == null) {
                this.axis = new IntegerType();
            }
            this.axis.setValue((Object)value);
            return this;
        }

        public DecimalType getPrismElement() {
            if (this.prism == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.prism");
                }
                if (Configuration.doAutoCreate()) {
                    this.prism = new DecimalType();
                }
            }
            return this.prism;
        }

        public boolean hasPrismElement() {
            return this.prism != null && !this.prism.isEmpty();
        }

        public boolean hasPrism() {
            return this.prism != null && !this.prism.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setPrismElement(DecimalType value) {
            this.prism = value;
            return this;
        }

        public BigDecimal getPrism() {
            return this.prism == null ? null : (BigDecimal)this.prism.getValue();
        }

        public VisionPrescriptionDispenseComponent setPrism(BigDecimal value) {
            if (value == null) {
                this.prism = null;
            } else {
                if (this.prism == null) {
                    this.prism = new DecimalType();
                }
                this.prism.setValue(value);
            }
            return this;
        }

        public Enumeration<VisionBase> getBaseElement() {
            if (this.base == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.base");
                }
                if (Configuration.doAutoCreate()) {
                    this.base = new Enumeration<VisionBase>(new VisionBaseEnumFactory());
                }
            }
            return this.base;
        }

        public boolean hasBaseElement() {
            return this.base != null && !this.base.isEmpty();
        }

        public boolean hasBase() {
            return this.base != null && !this.base.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setBaseElement(Enumeration<VisionBase> value) {
            this.base = value;
            return this;
        }

        public VisionBase getBase() {
            return this.base == null ? null : (VisionBase)((Object)this.base.getValue());
        }

        public VisionPrescriptionDispenseComponent setBase(VisionBase value) {
            if (value == null) {
                this.base = null;
            } else {
                if (this.base == null) {
                    this.base = new Enumeration<VisionBase>(new VisionBaseEnumFactory());
                }
                this.base.setValue((Object)value);
            }
            return this;
        }

        public DecimalType getAddElement() {
            if (this.add == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.add");
                }
                if (Configuration.doAutoCreate()) {
                    this.add = new DecimalType();
                }
            }
            return this.add;
        }

        public boolean hasAddElement() {
            return this.add != null && !this.add.isEmpty();
        }

        public boolean hasAdd() {
            return this.add != null && !this.add.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setAddElement(DecimalType value) {
            this.add = value;
            return this;
        }

        public BigDecimal getAdd() {
            return this.add == null ? null : (BigDecimal)this.add.getValue();
        }

        public VisionPrescriptionDispenseComponent setAdd(BigDecimal value) {
            if (value == null) {
                this.add = null;
            } else {
                if (this.add == null) {
                    this.add = new DecimalType();
                }
                this.add.setValue(value);
            }
            return this;
        }

        public DecimalType getPowerElement() {
            if (this.power == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.power");
                }
                if (Configuration.doAutoCreate()) {
                    this.power = new DecimalType();
                }
            }
            return this.power;
        }

        public boolean hasPowerElement() {
            return this.power != null && !this.power.isEmpty();
        }

        public boolean hasPower() {
            return this.power != null && !this.power.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setPowerElement(DecimalType value) {
            this.power = value;
            return this;
        }

        public BigDecimal getPower() {
            return this.power == null ? null : (BigDecimal)this.power.getValue();
        }

        public VisionPrescriptionDispenseComponent setPower(BigDecimal value) {
            if (value == null) {
                this.power = null;
            } else {
                if (this.power == null) {
                    this.power = new DecimalType();
                }
                this.power.setValue(value);
            }
            return this;
        }

        public DecimalType getBackCurveElement() {
            if (this.backCurve == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.backCurve");
                }
                if (Configuration.doAutoCreate()) {
                    this.backCurve = new DecimalType();
                }
            }
            return this.backCurve;
        }

        public boolean hasBackCurveElement() {
            return this.backCurve != null && !this.backCurve.isEmpty();
        }

        public boolean hasBackCurve() {
            return this.backCurve != null && !this.backCurve.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setBackCurveElement(DecimalType value) {
            this.backCurve = value;
            return this;
        }

        public BigDecimal getBackCurve() {
            return this.backCurve == null ? null : (BigDecimal)this.backCurve.getValue();
        }

        public VisionPrescriptionDispenseComponent setBackCurve(BigDecimal value) {
            if (value == null) {
                this.backCurve = null;
            } else {
                if (this.backCurve == null) {
                    this.backCurve = new DecimalType();
                }
                this.backCurve.setValue(value);
            }
            return this;
        }

        public DecimalType getDiameterElement() {
            if (this.diameter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.diameter");
                }
                if (Configuration.doAutoCreate()) {
                    this.diameter = new DecimalType();
                }
            }
            return this.diameter;
        }

        public boolean hasDiameterElement() {
            return this.diameter != null && !this.diameter.isEmpty();
        }

        public boolean hasDiameter() {
            return this.diameter != null && !this.diameter.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setDiameterElement(DecimalType value) {
            this.diameter = value;
            return this;
        }

        public BigDecimal getDiameter() {
            return this.diameter == null ? null : (BigDecimal)this.diameter.getValue();
        }

        public VisionPrescriptionDispenseComponent setDiameter(BigDecimal value) {
            if (value == null) {
                this.diameter = null;
            } else {
                if (this.diameter == null) {
                    this.diameter = new DecimalType();
                }
                this.diameter.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new SimpleQuantity();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setDuration(SimpleQuantity value) {
            this.duration = value;
            return this;
        }

        public StringType getColorElement() {
            if (this.color == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.color");
                }
                if (Configuration.doAutoCreate()) {
                    this.color = new StringType();
                }
            }
            return this.color;
        }

        public boolean hasColorElement() {
            return this.color != null && !this.color.isEmpty();
        }

        public boolean hasColor() {
            return this.color != null && !this.color.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setColorElement(StringType value) {
            this.color = value;
            return this;
        }

        public String getColor() {
            return this.color == null ? null : (String)this.color.getValue();
        }

        public VisionPrescriptionDispenseComponent setColor(String value) {
            if (Utilities.noString(value)) {
                this.color = null;
            } else {
                if (this.color == null) {
                    this.color = new StringType();
                }
                this.color.setValue(value);
            }
            return this;
        }

        public StringType getBrandElement() {
            if (this.brand == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.brand");
                }
                if (Configuration.doAutoCreate()) {
                    this.brand = new StringType();
                }
            }
            return this.brand;
        }

        public boolean hasBrandElement() {
            return this.brand != null && !this.brand.isEmpty();
        }

        public boolean hasBrand() {
            return this.brand != null && !this.brand.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setBrandElement(StringType value) {
            this.brand = value;
            return this;
        }

        public String getBrand() {
            return this.brand == null ? null : (String)this.brand.getValue();
        }

        public VisionPrescriptionDispenseComponent setBrand(String value) {
            if (Utilities.noString(value)) {
                this.brand = null;
            } else {
                if (this.brand == null) {
                    this.brand = new StringType();
                }
                this.brand.setValue(value);
            }
            return this;
        }

        public StringType getNotesElement() {
            if (this.notes == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionDispenseComponent.notes");
                }
                if (Configuration.doAutoCreate()) {
                    this.notes = new StringType();
                }
            }
            return this.notes;
        }

        public boolean hasNotesElement() {
            return this.notes != null && !this.notes.isEmpty();
        }

        public boolean hasNotes() {
            return this.notes != null && !this.notes.isEmpty();
        }

        public VisionPrescriptionDispenseComponent setNotesElement(StringType value) {
            this.notes = value;
            return this;
        }

        public String getNotes() {
            return this.notes == null ? null : (String)this.notes.getValue();
        }

        public VisionPrescriptionDispenseComponent setNotes(String value) {
            if (Utilities.noString(value)) {
                this.notes = null;
            } else {
                if (this.notes == null) {
                    this.notes = new StringType();
                }
                this.notes.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("product", "Coding", "Identifies the type of vision correction product which is required for the patient.", 0, Integer.MAX_VALUE, this.product));
            childrenList.add(new Property("eye", "code", "The eye for which the lens applies.", 0, Integer.MAX_VALUE, this.eye));
            childrenList.add(new Property("sphere", "decimal", "Lens power measured in diopters (0.25 units).", 0, Integer.MAX_VALUE, this.sphere));
            childrenList.add(new Property("cylinder", "decimal", "Power adjustment for astigmatism measured in diopters (0.25 units).", 0, Integer.MAX_VALUE, this.cylinder));
            childrenList.add(new Property("axis", "integer", "Adjustment for astigmatism measured in integer degrees.", 0, Integer.MAX_VALUE, this.axis));
            childrenList.add(new Property("prism", "decimal", "Amount of prism to compensate for eye alignment in fractional units.", 0, Integer.MAX_VALUE, this.prism));
            childrenList.add(new Property("base", "code", "The relative base, or reference lens edge, for the prism.", 0, Integer.MAX_VALUE, this.base));
            childrenList.add(new Property("add", "decimal", "Power adjustment for multifocal lenses measured in diopters (0.25 units).", 0, Integer.MAX_VALUE, this.add));
            childrenList.add(new Property("power", "decimal", "Contact lens power measured in diopters (0.25 units).", 0, Integer.MAX_VALUE, this.power));
            childrenList.add(new Property("backCurve", "decimal", "Back curvature measured in millimeters.", 0, Integer.MAX_VALUE, this.backCurve));
            childrenList.add(new Property("diameter", "decimal", "Contact lens diameter measured in millimeters.", 0, Integer.MAX_VALUE, this.diameter));
            childrenList.add(new Property("duration", "SimpleQuantity", "The recommended maximum wear period for the lens.", 0, Integer.MAX_VALUE, this.duration));
            childrenList.add(new Property("color", "string", "Special color or pattern.", 0, Integer.MAX_VALUE, this.color));
            childrenList.add(new Property("brand", "string", "Brand recommendations or restrictions.", 0, Integer.MAX_VALUE, this.brand));
            childrenList.add(new Property("notes", "string", "Notes for special requirements such as coatings and lens materials.", 0, Integer.MAX_VALUE, this.notes));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("product")) {
                this.product = this.castToCoding(value);
            } else if (name.equals("eye")) {
                this.eye = new VisionEyesEnumFactory().fromType(value);
            } else if (name.equals("sphere")) {
                this.sphere = this.castToDecimal(value);
            } else if (name.equals("cylinder")) {
                this.cylinder = this.castToDecimal(value);
            } else if (name.equals("axis")) {
                this.axis = this.castToInteger(value);
            } else if (name.equals("prism")) {
                this.prism = this.castToDecimal(value);
            } else if (name.equals("base")) {
                this.base = new VisionBaseEnumFactory().fromType(value);
            } else if (name.equals("add")) {
                this.add = this.castToDecimal(value);
            } else if (name.equals("power")) {
                this.power = this.castToDecimal(value);
            } else if (name.equals("backCurve")) {
                this.backCurve = this.castToDecimal(value);
            } else if (name.equals("diameter")) {
                this.diameter = this.castToDecimal(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToSimpleQuantity(value);
            } else if (name.equals("color")) {
                this.color = this.castToString(value);
            } else if (name.equals("brand")) {
                this.brand = this.castToString(value);
            } else if (name.equals("notes")) {
                this.notes = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("product")) {
                this.product = new Coding();
                return this.product;
            }
            if (name.equals("eye")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.eye");
            }
            if (name.equals("sphere")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.sphere");
            }
            if (name.equals("cylinder")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.cylinder");
            }
            if (name.equals("axis")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.axis");
            }
            if (name.equals("prism")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.prism");
            }
            if (name.equals("base")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.base");
            }
            if (name.equals("add")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.add");
            }
            if (name.equals("power")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.power");
            }
            if (name.equals("backCurve")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.backCurve");
            }
            if (name.equals("diameter")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.diameter");
            }
            if (name.equals("duration")) {
                this.duration = new SimpleQuantity();
                return this.duration;
            }
            if (name.equals("color")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.color");
            }
            if (name.equals("brand")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.brand");
            }
            if (name.equals("notes")) {
                throw new FHIRException("Cannot call addChild on a primitive type VisionPrescription.notes");
            }
            return super.addChild(name);
        }

        @Override
        public VisionPrescriptionDispenseComponent copy() {
            VisionPrescriptionDispenseComponent dst = new VisionPrescriptionDispenseComponent();
            this.copyValues(dst);
            dst.product = this.product == null ? null : this.product.copy();
            dst.eye = this.eye == null ? null : this.eye.copy();
            dst.sphere = this.sphere == null ? null : this.sphere.copy();
            dst.cylinder = this.cylinder == null ? null : this.cylinder.copy();
            dst.axis = this.axis == null ? null : this.axis.copy();
            dst.prism = this.prism == null ? null : this.prism.copy();
            dst.base = this.base == null ? null : this.base.copy();
            dst.add = this.add == null ? null : this.add.copy();
            dst.power = this.power == null ? null : this.power.copy();
            dst.backCurve = this.backCurve == null ? null : this.backCurve.copy();
            dst.diameter = this.diameter == null ? null : this.diameter.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.color = this.color == null ? null : this.color.copy();
            dst.brand = this.brand == null ? null : this.brand.copy();
            dst.notes = this.notes == null ? null : this.notes.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof VisionPrescriptionDispenseComponent)) {
                return false;
            }
            VisionPrescriptionDispenseComponent o = (VisionPrescriptionDispenseComponent)other;
            return VisionPrescriptionDispenseComponent.compareDeep(this.product, o.product, true) && VisionPrescriptionDispenseComponent.compareDeep(this.eye, o.eye, true) && VisionPrescriptionDispenseComponent.compareDeep(this.sphere, o.sphere, true) && VisionPrescriptionDispenseComponent.compareDeep(this.cylinder, o.cylinder, true) && VisionPrescriptionDispenseComponent.compareDeep(this.axis, o.axis, true) && VisionPrescriptionDispenseComponent.compareDeep(this.prism, o.prism, true) && VisionPrescriptionDispenseComponent.compareDeep(this.base, o.base, true) && VisionPrescriptionDispenseComponent.compareDeep(this.add, o.add, true) && VisionPrescriptionDispenseComponent.compareDeep(this.power, o.power, true) && VisionPrescriptionDispenseComponent.compareDeep(this.backCurve, o.backCurve, true) && VisionPrescriptionDispenseComponent.compareDeep(this.diameter, o.diameter, true) && VisionPrescriptionDispenseComponent.compareDeep(this.duration, o.duration, true) && VisionPrescriptionDispenseComponent.compareDeep(this.color, o.color, true) && VisionPrescriptionDispenseComponent.compareDeep(this.brand, o.brand, true) && VisionPrescriptionDispenseComponent.compareDeep(this.notes, o.notes, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof VisionPrescriptionDispenseComponent)) {
                return false;
            }
            VisionPrescriptionDispenseComponent o = (VisionPrescriptionDispenseComponent)other;
            return VisionPrescriptionDispenseComponent.compareValues(this.eye, o.eye, true) && VisionPrescriptionDispenseComponent.compareValues(this.sphere, o.sphere, true) && VisionPrescriptionDispenseComponent.compareValues(this.cylinder, o.cylinder, true) && VisionPrescriptionDispenseComponent.compareValues(this.axis, o.axis, true) && VisionPrescriptionDispenseComponent.compareValues(this.prism, o.prism, true) && VisionPrescriptionDispenseComponent.compareValues(this.base, o.base, true) && VisionPrescriptionDispenseComponent.compareValues(this.add, o.add, true) && VisionPrescriptionDispenseComponent.compareValues(this.power, o.power, true) && VisionPrescriptionDispenseComponent.compareValues(this.backCurve, o.backCurve, true) && VisionPrescriptionDispenseComponent.compareValues(this.diameter, o.diameter, true) && VisionPrescriptionDispenseComponent.compareValues(this.color, o.color, true) && VisionPrescriptionDispenseComponent.compareValues(this.brand, o.brand, true) && VisionPrescriptionDispenseComponent.compareValues(this.notes, o.notes, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.product != null && !this.product.isEmpty() || this.eye != null && !this.eye.isEmpty() || this.sphere != null && !this.sphere.isEmpty() || this.cylinder != null && !this.cylinder.isEmpty() || this.axis != null && !this.axis.isEmpty() || this.prism != null && !this.prism.isEmpty() || this.base != null && !this.base.isEmpty() || this.add != null && !this.add.isEmpty() || this.power != null && !this.power.isEmpty() || this.backCurve != null && !this.backCurve.isEmpty() || this.diameter != null && !this.diameter.isEmpty() || this.duration != null && !this.duration.isEmpty() || this.color != null && !this.color.isEmpty() || this.brand != null && !this.brand.isEmpty() || this.notes != null && !this.notes.isEmpty());
        }

        @Override
        public String fhirType() {
            return "VisionPrescription.dispense";
        }
    }

    public static class VisionBaseEnumFactory
    implements EnumFactory<VisionBase> {
        @Override
        public VisionBase fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("up".equals(codeString)) {
                return VisionBase.UP;
            }
            if ("down".equals(codeString)) {
                return VisionBase.DOWN;
            }
            if ("in".equals(codeString)) {
                return VisionBase.IN;
            }
            if ("out".equals(codeString)) {
                return VisionBase.OUT;
            }
            throw new IllegalArgumentException("Unknown VisionBase code '" + codeString + "'");
        }

        public Enumeration<VisionBase> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("up".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.UP);
            }
            if ("down".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.DOWN);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.IN);
            }
            if ("out".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.OUT);
            }
            throw new FHIRException("Unknown VisionBase code '" + codeString + "'");
        }

        @Override
        public String toCode(VisionBase code) {
            if (code == VisionBase.UP) {
                return "up";
            }
            if (code == VisionBase.DOWN) {
                return "down";
            }
            if (code == VisionBase.IN) {
                return "in";
            }
            if (code == VisionBase.OUT) {
                return "out";
            }
            return "?";
        }
    }

    public static enum VisionBase {
        UP,
        DOWN,
        IN,
        OUT,
        NULL;


        public static VisionBase fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("up".equals(codeString)) {
                return UP;
            }
            if ("down".equals(codeString)) {
                return DOWN;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("out".equals(codeString)) {
                return OUT;
            }
            throw new FHIRException("Unknown VisionBase code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UP: {
                    return "up";
                }
                case DOWN: {
                    return "down";
                }
                case IN: {
                    return "in";
                }
                case OUT: {
                    return "out";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UP: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
                case DOWN: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
                case IN: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
                case OUT: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UP: {
                    return "top";
                }
                case DOWN: {
                    return "bottom";
                }
                case IN: {
                    return "inner edge";
                }
                case OUT: {
                    return "outer edge";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UP: {
                    return "Up";
                }
                case DOWN: {
                    return "Down";
                }
                case IN: {
                    return "In";
                }
                case OUT: {
                    return "Out";
                }
            }
            return "?";
        }
    }

    public static class VisionEyesEnumFactory
    implements EnumFactory<VisionEyes> {
        @Override
        public VisionEyes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("right".equals(codeString)) {
                return VisionEyes.RIGHT;
            }
            if ("left".equals(codeString)) {
                return VisionEyes.LEFT;
            }
            throw new IllegalArgumentException("Unknown VisionEyes code '" + codeString + "'");
        }

        public Enumeration<VisionEyes> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("right".equals(codeString)) {
                return new Enumeration<VisionEyes>(this, VisionEyes.RIGHT);
            }
            if ("left".equals(codeString)) {
                return new Enumeration<VisionEyes>(this, VisionEyes.LEFT);
            }
            throw new FHIRException("Unknown VisionEyes code '" + codeString + "'");
        }

        @Override
        public String toCode(VisionEyes code) {
            if (code == VisionEyes.RIGHT) {
                return "right";
            }
            if (code == VisionEyes.LEFT) {
                return "left";
            }
            return "?";
        }
    }

    public static enum VisionEyes {
        RIGHT,
        LEFT,
        NULL;


        public static VisionEyes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("right".equals(codeString)) {
                return RIGHT;
            }
            if ("left".equals(codeString)) {
                return LEFT;
            }
            throw new FHIRException("Unknown VisionEyes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RIGHT: {
                    return "right";
                }
                case LEFT: {
                    return "left";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RIGHT: {
                    return "http://hl7.org/fhir/vision-eye-codes";
                }
                case LEFT: {
                    return "http://hl7.org/fhir/vision-eye-codes";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RIGHT: {
                    return "Right Eye";
                }
                case LEFT: {
                    return "Left Eye";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RIGHT: {
                    return "Right Eye";
                }
                case LEFT: {
                    return "Left Eye";
                }
            }
            return "?";
        }
    }
}

