/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Subscription", profile="http://hl7.org/fhir/Profile/Subscription")
public class Subscription
extends DomainResource {
    @Child(name="criteria", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Rule for server push criteria", formalDefinition="The rules that the server should use to determine when to generate notifications for this subscription.")
    protected StringType criteria;
    @Child(name="contact", type={ContactPoint.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for source (e.g. troubleshooting)", formalDefinition="Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.")
    protected List<ContactPoint> contact;
    @Child(name="reason", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of why this subscription was created", formalDefinition="A description of why this subscription is defined.")
    protected StringType reason;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="requested | active | error | off", formalDefinition="The status of the subscription, which marks the server state for managing the subscription.")
    protected Enumeration<SubscriptionStatus> status;
    @Child(name="error", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Latest error note", formalDefinition="A record of the last error that occurred when the server processed a notification.")
    protected StringType error;
    @Child(name="channel", type={}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The channel on which to report matches to the criteria", formalDefinition="Details where to send notifications when resources are received that meet the criteria.")
    protected SubscriptionChannelComponent channel;
    @Child(name="end", type={InstantType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When to automatically delete the subscription", formalDefinition="The time for the server to turn the subscription off.")
    protected InstantType end;
    @Child(name="tag", type={Coding.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A tag to add to matching resources", formalDefinition="A tag to add to any resource that matches the criteria, after the subscription is processed.")
    protected List<Coding> tag;
    private static final long serialVersionUID = -1390870804L;
    @SearchParamDefinition(name="payload", path="Subscription.channel.payload", description="Mimetype to send, or blank for no payload", type="string")
    public static final String SP_PAYLOAD = "payload";
    @SearchParamDefinition(name="criteria", path="Subscription.criteria", description="Rule for server push criteria", type="string")
    public static final String SP_CRITERIA = "criteria";
    @SearchParamDefinition(name="contact", path="Subscription.contact", description="Contact details for source (e.g. troubleshooting)", type="token")
    public static final String SP_CONTACT = "contact";
    @SearchParamDefinition(name="tag", path="Subscription.tag", description="A tag to add to matching resources", type="token")
    public static final String SP_TAG = "tag";
    @SearchParamDefinition(name="type", path="Subscription.channel.type", description="rest-hook | websocket | email | sms | message", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="url", path="Subscription.channel.endpoint", description="Where the channel points to", type="uri")
    public static final String SP_URL = "url";
    @SearchParamDefinition(name="status", path="Subscription.status", description="requested | active | error | off", type="token")
    public static final String SP_STATUS = "status";

    public Subscription() {
    }

    public Subscription(StringType criteria, StringType reason, Enumeration<SubscriptionStatus> status, SubscriptionChannelComponent channel) {
        this.criteria = criteria;
        this.reason = reason;
        this.status = status;
        this.channel = channel;
    }

    public StringType getCriteriaElement() {
        if (this.criteria == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.criteria");
            }
            if (Configuration.doAutoCreate()) {
                this.criteria = new StringType();
            }
        }
        return this.criteria;
    }

    public boolean hasCriteriaElement() {
        return this.criteria != null && !this.criteria.isEmpty();
    }

    public boolean hasCriteria() {
        return this.criteria != null && !this.criteria.isEmpty();
    }

    public Subscription setCriteriaElement(StringType value) {
        this.criteria = value;
        return this;
    }

    public String getCriteria() {
        return this.criteria == null ? null : (String)this.criteria.getValue();
    }

    public Subscription setCriteria(String value) {
        if (this.criteria == null) {
            this.criteria = new StringType();
        }
        this.criteria.setValue(value);
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Subscription addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public StringType getReasonElement() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new StringType();
            }
        }
        return this.reason;
    }

    public boolean hasReasonElement() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Subscription setReasonElement(StringType value) {
        this.reason = value;
        return this;
    }

    public String getReason() {
        return this.reason == null ? null : (String)this.reason.getValue();
    }

    public Subscription setReason(String value) {
        if (this.reason == null) {
            this.reason = new StringType();
        }
        this.reason.setValue(value);
        return this;
    }

    public Enumeration<SubscriptionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SubscriptionStatus>(new SubscriptionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Subscription setStatusElement(Enumeration<SubscriptionStatus> value) {
        this.status = value;
        return this;
    }

    public SubscriptionStatus getStatus() {
        return this.status == null ? null : (SubscriptionStatus)((Object)this.status.getValue());
    }

    public Subscription setStatus(SubscriptionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<SubscriptionStatus>(new SubscriptionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public StringType getErrorElement() {
        if (this.error == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.error");
            }
            if (Configuration.doAutoCreate()) {
                this.error = new StringType();
            }
        }
        return this.error;
    }

    public boolean hasErrorElement() {
        return this.error != null && !this.error.isEmpty();
    }

    public boolean hasError() {
        return this.error != null && !this.error.isEmpty();
    }

    public Subscription setErrorElement(StringType value) {
        this.error = value;
        return this;
    }

    public String getError() {
        return this.error == null ? null : (String)this.error.getValue();
    }

    public Subscription setError(String value) {
        if (Utilities.noString(value)) {
            this.error = null;
        } else {
            if (this.error == null) {
                this.error = new StringType();
            }
            this.error.setValue(value);
        }
        return this;
    }

    public SubscriptionChannelComponent getChannel() {
        if (this.channel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.channel");
            }
            if (Configuration.doAutoCreate()) {
                this.channel = new SubscriptionChannelComponent();
            }
        }
        return this.channel;
    }

    public boolean hasChannel() {
        return this.channel != null && !this.channel.isEmpty();
    }

    public Subscription setChannel(SubscriptionChannelComponent value) {
        this.channel = value;
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Subscription setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Subscription setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public List<Coding> getTag() {
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        return this.tag;
    }

    public boolean hasTag() {
        if (this.tag == null) {
            return false;
        }
        for (Coding item : this.tag) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addTag() {
        Coding t = new Coding();
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        this.tag.add(t);
        return t;
    }

    public Subscription addTag(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        this.tag.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_CRITERIA, "string", "The rules that the server should use to determine when to generate notifications for this subscription.", 0, Integer.MAX_VALUE, this.criteria));
        childrenList.add(new Property(SP_CONTACT, "ContactPoint", "Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("reason", "string", "A description of why this subscription is defined.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("error", "string", "A record of the last error that occurred when the server processed a notification.", 0, Integer.MAX_VALUE, this.error));
        childrenList.add(new Property("channel", "", "Details where to send notifications when resources are received that meet the criteria.", 0, Integer.MAX_VALUE, this.channel));
        childrenList.add(new Property("end", "instant", "The time for the server to turn the subscription off.", 0, Integer.MAX_VALUE, this.end));
        childrenList.add(new Property(SP_TAG, "Coding", "A tag to add to any resource that matches the criteria, after the subscription is processed.", 0, Integer.MAX_VALUE, this.tag));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_CRITERIA)) {
            this.criteria = this.castToString(value);
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().add(this.castToContactPoint(value));
        } else if (name.equals("reason")) {
            this.reason = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new SubscriptionStatusEnumFactory().fromType(value);
        } else if (name.equals("error")) {
            this.error = this.castToString(value);
        } else if (name.equals("channel")) {
            this.channel = (SubscriptionChannelComponent)value;
        } else if (name.equals("end")) {
            this.end = this.castToInstant(value);
        } else if (name.equals(SP_TAG)) {
            this.getTag().add(this.castToCoding(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_CRITERIA)) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.criteria");
        }
        if (name.equals(SP_CONTACT)) {
            return this.addContact();
        }
        if (name.equals("reason")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.reason");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.status");
        }
        if (name.equals("error")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.error");
        }
        if (name.equals("channel")) {
            this.channel = new SubscriptionChannelComponent();
            return this.channel;
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.end");
        }
        if (name.equals(SP_TAG)) {
            return this.addTag();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Subscription";
    }

    @Override
    public Subscription copy() {
        Subscription dst = new Subscription();
        this.copyValues(dst);
        StringType stringType = dst.criteria = this.criteria == null ? null : this.criteria.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.error = this.error == null ? null : this.error.copy();
        dst.channel = this.channel == null ? null : this.channel.copy();
        InstantType instantType = dst.end = this.end == null ? null : this.end.copy();
        if (this.tag != null) {
            dst.tag = new ArrayList<Coding>();
            for (Coding coding : this.tag) {
                dst.tag.add(coding.copy());
            }
        }
        return dst;
    }

    protected Subscription typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Subscription)) {
            return false;
        }
        Subscription o = (Subscription)other;
        return Subscription.compareDeep(this.criteria, o.criteria, true) && Subscription.compareDeep(this.contact, o.contact, true) && Subscription.compareDeep(this.reason, o.reason, true) && Subscription.compareDeep(this.status, o.status, true) && Subscription.compareDeep(this.error, o.error, true) && Subscription.compareDeep(this.channel, o.channel, true) && Subscription.compareDeep(this.end, o.end, true) && Subscription.compareDeep(this.tag, o.tag, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Subscription)) {
            return false;
        }
        Subscription o = (Subscription)other;
        return Subscription.compareValues(this.criteria, o.criteria, true) && Subscription.compareValues(this.reason, o.reason, true) && Subscription.compareValues(this.status, o.status, true) && Subscription.compareValues(this.error, o.error, true) && Subscription.compareValues(this.end, o.end, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.criteria != null && !this.criteria.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.status != null && !this.status.isEmpty() || this.error != null && !this.error.isEmpty() || this.channel != null && !this.channel.isEmpty() || this.end != null && !this.end.isEmpty() || this.tag != null && !this.tag.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Subscription;
    }

    @Block
    public static class SubscriptionChannelComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="rest-hook | websocket | email | sms | message", formalDefinition="The type of channel to send notifications on.")
        protected Enumeration<SubscriptionChannelType> type;
        @Child(name="endpoint", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where the channel points to", formalDefinition="The uri that describes the actual end-point to send messages to.")
        protected UriType endpoint;
        @Child(name="payload", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Mimetype to send, or blank for no payload", formalDefinition="The mime type to send the payload in - either application/xml+fhir, or application/json+fhir. If the mime type is blank, then there is no payload in the notification, just a notification.")
        protected StringType payload;
        @Child(name="header", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Usage depends on the channel type", formalDefinition="Additional headers / information to send as part of the notification.")
        protected StringType header;
        private static final long serialVersionUID = -279715391L;

        public SubscriptionChannelComponent() {
        }

        public SubscriptionChannelComponent(Enumeration<SubscriptionChannelType> type, StringType payload) {
            this.type = type;
            this.payload = payload;
        }

        public Enumeration<SubscriptionChannelType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionChannelComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<SubscriptionChannelType>(new SubscriptionChannelTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubscriptionChannelComponent setTypeElement(Enumeration<SubscriptionChannelType> value) {
            this.type = value;
            return this;
        }

        public SubscriptionChannelType getType() {
            return this.type == null ? null : (SubscriptionChannelType)((Object)this.type.getValue());
        }

        public SubscriptionChannelComponent setType(SubscriptionChannelType value) {
            if (this.type == null) {
                this.type = new Enumeration<SubscriptionChannelType>(new SubscriptionChannelTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getEndpointElement() {
            if (this.endpoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionChannelComponent.endpoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.endpoint = new UriType();
                }
            }
            return this.endpoint;
        }

        public boolean hasEndpointElement() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public boolean hasEndpoint() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public SubscriptionChannelComponent setEndpointElement(UriType value) {
            this.endpoint = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint == null ? null : (String)this.endpoint.getValue();
        }

        public SubscriptionChannelComponent setEndpoint(String value) {
            if (Utilities.noString(value)) {
                this.endpoint = null;
            } else {
                if (this.endpoint == null) {
                    this.endpoint = new UriType();
                }
                this.endpoint.setValue(value);
            }
            return this;
        }

        public StringType getPayloadElement() {
            if (this.payload == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionChannelComponent.payload");
                }
                if (Configuration.doAutoCreate()) {
                    this.payload = new StringType();
                }
            }
            return this.payload;
        }

        public boolean hasPayloadElement() {
            return this.payload != null && !this.payload.isEmpty();
        }

        public boolean hasPayload() {
            return this.payload != null && !this.payload.isEmpty();
        }

        public SubscriptionChannelComponent setPayloadElement(StringType value) {
            this.payload = value;
            return this;
        }

        public String getPayload() {
            return this.payload == null ? null : (String)this.payload.getValue();
        }

        public SubscriptionChannelComponent setPayload(String value) {
            if (this.payload == null) {
                this.payload = new StringType();
            }
            this.payload.setValue(value);
            return this;
        }

        public StringType getHeaderElement() {
            if (this.header == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionChannelComponent.header");
                }
                if (Configuration.doAutoCreate()) {
                    this.header = new StringType();
                }
            }
            return this.header;
        }

        public boolean hasHeaderElement() {
            return this.header != null && !this.header.isEmpty();
        }

        public boolean hasHeader() {
            return this.header != null && !this.header.isEmpty();
        }

        public SubscriptionChannelComponent setHeaderElement(StringType value) {
            this.header = value;
            return this;
        }

        public String getHeader() {
            return this.header == null ? null : (String)this.header.getValue();
        }

        public SubscriptionChannelComponent setHeader(String value) {
            if (Utilities.noString(value)) {
                this.header = null;
            } else {
                if (this.header == null) {
                    this.header = new StringType();
                }
                this.header.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Subscription.SP_TYPE, "code", "The type of channel to send notifications on.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("endpoint", "uri", "The uri that describes the actual end-point to send messages to.", 0, Integer.MAX_VALUE, this.endpoint));
            childrenList.add(new Property(Subscription.SP_PAYLOAD, "string", "The mime type to send the payload in - either application/xml+fhir, or application/json+fhir. If the mime type is blank, then there is no payload in the notification, just a notification.", 0, Integer.MAX_VALUE, this.payload));
            childrenList.add(new Property("header", "string", "Additional headers / information to send as part of the notification.", 0, Integer.MAX_VALUE, this.header));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Subscription.SP_TYPE)) {
                this.type = new SubscriptionChannelTypeEnumFactory().fromType(value);
            } else if (name.equals("endpoint")) {
                this.endpoint = this.castToUri(value);
            } else if (name.equals(Subscription.SP_PAYLOAD)) {
                this.payload = this.castToString(value);
            } else if (name.equals("header")) {
                this.header = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Subscription.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Subscription.type");
            }
            if (name.equals("endpoint")) {
                throw new FHIRException("Cannot call addChild on a primitive type Subscription.endpoint");
            }
            if (name.equals(Subscription.SP_PAYLOAD)) {
                throw new FHIRException("Cannot call addChild on a primitive type Subscription.payload");
            }
            if (name.equals("header")) {
                throw new FHIRException("Cannot call addChild on a primitive type Subscription.header");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionChannelComponent copy() {
            SubscriptionChannelComponent dst = new SubscriptionChannelComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            dst.payload = this.payload == null ? null : this.payload.copy();
            dst.header = this.header == null ? null : this.header.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubscriptionChannelComponent)) {
                return false;
            }
            SubscriptionChannelComponent o = (SubscriptionChannelComponent)other;
            return SubscriptionChannelComponent.compareDeep(this.type, o.type, true) && SubscriptionChannelComponent.compareDeep(this.endpoint, o.endpoint, true) && SubscriptionChannelComponent.compareDeep(this.payload, o.payload, true) && SubscriptionChannelComponent.compareDeep(this.header, o.header, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubscriptionChannelComponent)) {
                return false;
            }
            SubscriptionChannelComponent o = (SubscriptionChannelComponent)other;
            return SubscriptionChannelComponent.compareValues(this.type, o.type, true) && SubscriptionChannelComponent.compareValues(this.endpoint, o.endpoint, true) && SubscriptionChannelComponent.compareValues(this.payload, o.payload, true) && SubscriptionChannelComponent.compareValues(this.header, o.header, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.endpoint != null && !this.endpoint.isEmpty() || this.payload != null && !this.payload.isEmpty() || this.header != null && !this.header.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Subscription.channel";
        }
    }

    public static class SubscriptionChannelTypeEnumFactory
    implements EnumFactory<SubscriptionChannelType> {
        @Override
        public SubscriptionChannelType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("rest-hook".equals(codeString)) {
                return SubscriptionChannelType.RESTHOOK;
            }
            if ("websocket".equals(codeString)) {
                return SubscriptionChannelType.WEBSOCKET;
            }
            if ("email".equals(codeString)) {
                return SubscriptionChannelType.EMAIL;
            }
            if ("sms".equals(codeString)) {
                return SubscriptionChannelType.SMS;
            }
            if ("message".equals(codeString)) {
                return SubscriptionChannelType.MESSAGE;
            }
            throw new IllegalArgumentException("Unknown SubscriptionChannelType code '" + codeString + "'");
        }

        public Enumeration<SubscriptionChannelType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("rest-hook".equals(codeString)) {
                return new Enumeration<SubscriptionChannelType>(this, SubscriptionChannelType.RESTHOOK);
            }
            if ("websocket".equals(codeString)) {
                return new Enumeration<SubscriptionChannelType>(this, SubscriptionChannelType.WEBSOCKET);
            }
            if ("email".equals(codeString)) {
                return new Enumeration<SubscriptionChannelType>(this, SubscriptionChannelType.EMAIL);
            }
            if ("sms".equals(codeString)) {
                return new Enumeration<SubscriptionChannelType>(this, SubscriptionChannelType.SMS);
            }
            if ("message".equals(codeString)) {
                return new Enumeration<SubscriptionChannelType>(this, SubscriptionChannelType.MESSAGE);
            }
            throw new FHIRException("Unknown SubscriptionChannelType code '" + codeString + "'");
        }

        @Override
        public String toCode(SubscriptionChannelType code) {
            if (code == SubscriptionChannelType.RESTHOOK) {
                return "rest-hook";
            }
            if (code == SubscriptionChannelType.WEBSOCKET) {
                return "websocket";
            }
            if (code == SubscriptionChannelType.EMAIL) {
                return "email";
            }
            if (code == SubscriptionChannelType.SMS) {
                return "sms";
            }
            if (code == SubscriptionChannelType.MESSAGE) {
                return "message";
            }
            return "?";
        }
    }

    public static enum SubscriptionChannelType {
        RESTHOOK,
        WEBSOCKET,
        EMAIL,
        SMS,
        MESSAGE,
        NULL;


        public static SubscriptionChannelType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("rest-hook".equals(codeString)) {
                return RESTHOOK;
            }
            if ("websocket".equals(codeString)) {
                return WEBSOCKET;
            }
            if ("email".equals(codeString)) {
                return EMAIL;
            }
            if ("sms".equals(codeString)) {
                return SMS;
            }
            if ("message".equals(codeString)) {
                return MESSAGE;
            }
            throw new FHIRException("Unknown SubscriptionChannelType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RESTHOOK: {
                    return "rest-hook";
                }
                case WEBSOCKET: {
                    return "websocket";
                }
                case EMAIL: {
                    return "email";
                }
                case SMS: {
                    return "sms";
                }
                case MESSAGE: {
                    return "message";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RESTHOOK: {
                    return "http://hl7.org/fhir/subscription-channel-type";
                }
                case WEBSOCKET: {
                    return "http://hl7.org/fhir/subscription-channel-type";
                }
                case EMAIL: {
                    return "http://hl7.org/fhir/subscription-channel-type";
                }
                case SMS: {
                    return "http://hl7.org/fhir/subscription-channel-type";
                }
                case MESSAGE: {
                    return "http://hl7.org/fhir/subscription-channel-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RESTHOOK: {
                    return "The channel is executed by making a post to the URI. If a payload is included, the URL is interpreted as the service base, and an update (PUT) is made.";
                }
                case WEBSOCKET: {
                    return "The channel is executed by sending a packet across a web socket connection maintained by the client. The URL identifies the websocket, and the client binds to this URL.";
                }
                case EMAIL: {
                    return "The channel is executed by sending an email to the email addressed in the URI (which must be a mailto:).";
                }
                case SMS: {
                    return "The channel is executed by sending an SMS message to the phone number identified in the URL (tel:).";
                }
                case MESSAGE: {
                    return "The channel is executed by sending a message (e.g. a Bundle with a MessageHeader resource etc.) to the application identified in the URI.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RESTHOOK: {
                    return "Rest Hook";
                }
                case WEBSOCKET: {
                    return "Websocket";
                }
                case EMAIL: {
                    return "Email";
                }
                case SMS: {
                    return "SMS";
                }
                case MESSAGE: {
                    return "Message";
                }
            }
            return "?";
        }
    }

    public static class SubscriptionStatusEnumFactory
    implements EnumFactory<SubscriptionStatus> {
        @Override
        public SubscriptionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("requested".equals(codeString)) {
                return SubscriptionStatus.REQUESTED;
            }
            if ("active".equals(codeString)) {
                return SubscriptionStatus.ACTIVE;
            }
            if ("error".equals(codeString)) {
                return SubscriptionStatus.ERROR;
            }
            if ("off".equals(codeString)) {
                return SubscriptionStatus.OFF;
            }
            throw new IllegalArgumentException("Unknown SubscriptionStatus code '" + codeString + "'");
        }

        public Enumeration<SubscriptionStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<SubscriptionStatus>(this, SubscriptionStatus.REQUESTED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<SubscriptionStatus>(this, SubscriptionStatus.ACTIVE);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<SubscriptionStatus>(this, SubscriptionStatus.ERROR);
            }
            if ("off".equals(codeString)) {
                return new Enumeration<SubscriptionStatus>(this, SubscriptionStatus.OFF);
            }
            throw new FHIRException("Unknown SubscriptionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SubscriptionStatus code) {
            if (code == SubscriptionStatus.REQUESTED) {
                return "requested";
            }
            if (code == SubscriptionStatus.ACTIVE) {
                return "active";
            }
            if (code == SubscriptionStatus.ERROR) {
                return "error";
            }
            if (code == SubscriptionStatus.OFF) {
                return "off";
            }
            return "?";
        }
    }

    public static enum SubscriptionStatus {
        REQUESTED,
        ACTIVE,
        ERROR,
        OFF,
        NULL;


        public static SubscriptionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("off".equals(codeString)) {
                return OFF;
            }
            throw new FHIRException("Unknown SubscriptionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REQUESTED: {
                    return "requested";
                }
                case ACTIVE: {
                    return "active";
                }
                case ERROR: {
                    return "error";
                }
                case OFF: {
                    return "off";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REQUESTED: {
                    return "http://hl7.org/fhir/subscription-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/subscription-status";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/subscription-status";
                }
                case OFF: {
                    return "http://hl7.org/fhir/subscription-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REQUESTED: {
                    return "The client has requested the subscription, and the server has not yet set it up.";
                }
                case ACTIVE: {
                    return "The subscription is active.";
                }
                case ERROR: {
                    return "The server has an error executing the notification.";
                }
                case OFF: {
                    return "Too many errors have occurred or the subscription has expired.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REQUESTED: {
                    return "Requested";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ERROR: {
                    return "Error";
                }
                case OFF: {
                    return "Off";
                }
            }
            return "?";
        }
    }
}

