/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="SampledData")
public class SampledData
extends Type
implements ICompositeType {
    @Child(name="origin", type={SimpleQuantity.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Zero value and units", formalDefinition="The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.")
    protected SimpleQuantity origin;
    @Child(name="period", type={DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of milliseconds between samples", formalDefinition="The length of time between sampling times, measured in milliseconds.")
    protected DecimalType period;
    @Child(name="factor", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Multiply data by this before adding to origin", formalDefinition="A correction factor that is applied to the sampled data points before they are added to the origin.")
    protected DecimalType factor;
    @Child(name="lowerLimit", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Lower limit of detection", formalDefinition="The lower limit of detection of the measured points. This is needed if any of the data points have the value \"L\" (lower than detection limit).")
    protected DecimalType lowerLimit;
    @Child(name="upperLimit", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit of detection", formalDefinition="The upper limit of detection of the measured points. This is needed if any of the data points have the value \"U\" (higher than detection limit).")
    protected DecimalType upperLimit;
    @Child(name="dimensions", type={PositiveIntType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of sample points at each time point", formalDefinition="The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.")
    protected PositiveIntType dimensions;
    @Child(name="data", type={StringType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Decimal values with spaces, or \"E\" | \"U\" | \"L\"", formalDefinition="A series of data points which are decimal values separated by a single space (character u20). The special values \"E\" (error), \"L\" (below detection limit) and \"U\" (above detection limit) can also be used in place of a decimal value.")
    protected StringType data;
    private static final long serialVersionUID = -1763278368L;

    public SampledData() {
    }

    public SampledData(SimpleQuantity origin, DecimalType period, PositiveIntType dimensions, StringType data) {
        this.origin = origin;
        this.period = period;
        this.dimensions = dimensions;
        this.data = data;
    }

    public SimpleQuantity getOrigin() {
        if (this.origin == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.origin");
            }
            if (Configuration.doAutoCreate()) {
                this.origin = new SimpleQuantity();
            }
        }
        return this.origin;
    }

    public boolean hasOrigin() {
        return this.origin != null && !this.origin.isEmpty();
    }

    public SampledData setOrigin(SimpleQuantity value) {
        this.origin = value;
        return this;
    }

    public DecimalType getPeriodElement() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new DecimalType();
            }
        }
        return this.period;
    }

    public boolean hasPeriodElement() {
        return this.period != null && !this.period.isEmpty();
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public SampledData setPeriodElement(DecimalType value) {
        this.period = value;
        return this;
    }

    public BigDecimal getPeriod() {
        return this.period == null ? null : (BigDecimal)this.period.getValue();
    }

    public SampledData setPeriod(BigDecimal value) {
        if (this.period == null) {
            this.period = new DecimalType();
        }
        this.period.setValue(value);
        return this;
    }

    public DecimalType getFactorElement() {
        if (this.factor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.factor");
            }
            if (Configuration.doAutoCreate()) {
                this.factor = new DecimalType();
            }
        }
        return this.factor;
    }

    public boolean hasFactorElement() {
        return this.factor != null && !this.factor.isEmpty();
    }

    public boolean hasFactor() {
        return this.factor != null && !this.factor.isEmpty();
    }

    public SampledData setFactorElement(DecimalType value) {
        this.factor = value;
        return this;
    }

    public BigDecimal getFactor() {
        return this.factor == null ? null : (BigDecimal)this.factor.getValue();
    }

    public SampledData setFactor(BigDecimal value) {
        if (value == null) {
            this.factor = null;
        } else {
            if (this.factor == null) {
                this.factor = new DecimalType();
            }
            this.factor.setValue(value);
        }
        return this;
    }

    public DecimalType getLowerLimitElement() {
        if (this.lowerLimit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.lowerLimit");
            }
            if (Configuration.doAutoCreate()) {
                this.lowerLimit = new DecimalType();
            }
        }
        return this.lowerLimit;
    }

    public boolean hasLowerLimitElement() {
        return this.lowerLimit != null && !this.lowerLimit.isEmpty();
    }

    public boolean hasLowerLimit() {
        return this.lowerLimit != null && !this.lowerLimit.isEmpty();
    }

    public SampledData setLowerLimitElement(DecimalType value) {
        this.lowerLimit = value;
        return this;
    }

    public BigDecimal getLowerLimit() {
        return this.lowerLimit == null ? null : (BigDecimal)this.lowerLimit.getValue();
    }

    public SampledData setLowerLimit(BigDecimal value) {
        if (value == null) {
            this.lowerLimit = null;
        } else {
            if (this.lowerLimit == null) {
                this.lowerLimit = new DecimalType();
            }
            this.lowerLimit.setValue(value);
        }
        return this;
    }

    public DecimalType getUpperLimitElement() {
        if (this.upperLimit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.upperLimit");
            }
            if (Configuration.doAutoCreate()) {
                this.upperLimit = new DecimalType();
            }
        }
        return this.upperLimit;
    }

    public boolean hasUpperLimitElement() {
        return this.upperLimit != null && !this.upperLimit.isEmpty();
    }

    public boolean hasUpperLimit() {
        return this.upperLimit != null && !this.upperLimit.isEmpty();
    }

    public SampledData setUpperLimitElement(DecimalType value) {
        this.upperLimit = value;
        return this;
    }

    public BigDecimal getUpperLimit() {
        return this.upperLimit == null ? null : (BigDecimal)this.upperLimit.getValue();
    }

    public SampledData setUpperLimit(BigDecimal value) {
        if (value == null) {
            this.upperLimit = null;
        } else {
            if (this.upperLimit == null) {
                this.upperLimit = new DecimalType();
            }
            this.upperLimit.setValue(value);
        }
        return this;
    }

    public PositiveIntType getDimensionsElement() {
        if (this.dimensions == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.dimensions");
            }
            if (Configuration.doAutoCreate()) {
                this.dimensions = new PositiveIntType();
            }
        }
        return this.dimensions;
    }

    public boolean hasDimensionsElement() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public boolean hasDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public SampledData setDimensionsElement(PositiveIntType value) {
        this.dimensions = value;
        return this;
    }

    public int getDimensions() {
        return this.dimensions == null || this.dimensions.isEmpty() ? 0 : (Integer)this.dimensions.getValue();
    }

    public SampledData setDimensions(int value) {
        if (this.dimensions == null) {
            this.dimensions = new PositiveIntType();
        }
        this.dimensions.setValue((Object)value);
        return this;
    }

    public StringType getDataElement() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new StringType();
            }
        }
        return this.data;
    }

    public boolean hasDataElement() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public SampledData setDataElement(StringType value) {
        this.data = value;
        return this;
    }

    public String getData() {
        return this.data == null ? null : (String)this.data.getValue();
    }

    public SampledData setData(String value) {
        if (this.data == null) {
            this.data = new StringType();
        }
        this.data.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("origin", "SimpleQuantity", "The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.", 0, Integer.MAX_VALUE, this.origin));
        childrenList.add(new Property("period", "decimal", "The length of time between sampling times, measured in milliseconds.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("factor", "decimal", "A correction factor that is applied to the sampled data points before they are added to the origin.", 0, Integer.MAX_VALUE, this.factor));
        childrenList.add(new Property("lowerLimit", "decimal", "The lower limit of detection of the measured points. This is needed if any of the data points have the value \"L\" (lower than detection limit).", 0, Integer.MAX_VALUE, this.lowerLimit));
        childrenList.add(new Property("upperLimit", "decimal", "The upper limit of detection of the measured points. This is needed if any of the data points have the value \"U\" (higher than detection limit).", 0, Integer.MAX_VALUE, this.upperLimit));
        childrenList.add(new Property("dimensions", "positiveInt", "The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.", 0, Integer.MAX_VALUE, this.dimensions));
        childrenList.add(new Property("data", "string", "A series of data points which are decimal values separated by a single space (character u20). The special values \"E\" (error), \"L\" (below detection limit) and \"U\" (above detection limit) can also be used in place of a decimal value.", 0, Integer.MAX_VALUE, this.data));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("origin")) {
            this.origin = this.castToSimpleQuantity(value);
        } else if (name.equals("period")) {
            this.period = this.castToDecimal(value);
        } else if (name.equals("factor")) {
            this.factor = this.castToDecimal(value);
        } else if (name.equals("lowerLimit")) {
            this.lowerLimit = this.castToDecimal(value);
        } else if (name.equals("upperLimit")) {
            this.upperLimit = this.castToDecimal(value);
        } else if (name.equals("dimensions")) {
            this.dimensions = this.castToPositiveInt(value);
        } else if (name.equals("data")) {
            this.data = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("origin")) {
            this.origin = new SimpleQuantity();
            return this.origin;
        }
        if (name.equals("period")) {
            throw new FHIRException("Cannot call addChild on a primitive type SampledData.period");
        }
        if (name.equals("factor")) {
            throw new FHIRException("Cannot call addChild on a primitive type SampledData.factor");
        }
        if (name.equals("lowerLimit")) {
            throw new FHIRException("Cannot call addChild on a primitive type SampledData.lowerLimit");
        }
        if (name.equals("upperLimit")) {
            throw new FHIRException("Cannot call addChild on a primitive type SampledData.upperLimit");
        }
        if (name.equals("dimensions")) {
            throw new FHIRException("Cannot call addChild on a primitive type SampledData.dimensions");
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on a primitive type SampledData.data");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SampledData";
    }

    @Override
    public SampledData copy() {
        SampledData dst = new SampledData();
        this.copyValues(dst);
        dst.origin = this.origin == null ? null : this.origin.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.factor = this.factor == null ? null : this.factor.copy();
        dst.lowerLimit = this.lowerLimit == null ? null : this.lowerLimit.copy();
        dst.upperLimit = this.upperLimit == null ? null : this.upperLimit.copy();
        dst.dimensions = this.dimensions == null ? null : this.dimensions.copy();
        dst.data = this.data == null ? null : this.data.copy();
        return dst;
    }

    @Override
    protected SampledData typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof SampledData)) {
            return false;
        }
        SampledData o = (SampledData)other;
        return SampledData.compareDeep(this.origin, o.origin, true) && SampledData.compareDeep(this.period, o.period, true) && SampledData.compareDeep(this.factor, o.factor, true) && SampledData.compareDeep(this.lowerLimit, o.lowerLimit, true) && SampledData.compareDeep(this.upperLimit, o.upperLimit, true) && SampledData.compareDeep(this.dimensions, o.dimensions, true) && SampledData.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof SampledData)) {
            return false;
        }
        SampledData o = (SampledData)other;
        return SampledData.compareValues(this.period, o.period, true) && SampledData.compareValues(this.factor, o.factor, true) && SampledData.compareValues(this.lowerLimit, o.lowerLimit, true) && SampledData.compareValues(this.upperLimit, o.upperLimit, true) && SampledData.compareValues(this.dimensions, o.dimensions, true) && SampledData.compareValues(this.data, o.data, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.origin != null && !this.origin.isEmpty() || this.period != null && !this.period.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.lowerLimit != null && !this.lowerLimit.isEmpty() || this.upperLimit != null && !this.upperLimit.isEmpty() || this.dimensions != null && !this.dimensions.isEmpty() || this.data != null && !this.data.isEmpty());
    }
}

