/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RiskAssessment", profile="http://hl7.org/fhir/Profile/RiskAssessment")
public class RiskAssessment
extends DomainResource {
    @Child(name="subject", type={Patient.class, Group.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what does assessment apply to?", formalDefinition="The patient or group the risk assessment applies to.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="date", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When was assessment made?", formalDefinition="The date (and possibly time) the risk assessment was performed.")
    protected DateTimeType date;
    @Child(name="condition", type={Condition.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Condition assessed", formalDefinition="For assessments or prognosis specific to a particular condition, indicates the condition being assessed.")
    protected Reference condition;
    protected Condition conditionTarget;
    @Child(name="encounter", type={Encounter.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where was assessment performed?", formalDefinition="The encounter where the assessment was performed.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="performer", type={Practitioner.class, Device.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who did assessment?", formalDefinition="The provider or software application that performed the assessment.")
    protected Reference performer;
    protected Resource performerTarget;
    @Child(name="identifier", type={Identifier.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier for the assessment", formalDefinition="Business identifier assigned to the risk assessment.")
    protected Identifier identifier;
    @Child(name="method", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Evaluation mechanism", formalDefinition="The algorithm, process or mechanism used to evaluate the risk.")
    protected CodeableConcept method;
    @Child(name="basis", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information used in assessment", formalDefinition="Indicates the source data considered as part of the assessment (FamilyHistory, Observations, Procedures, Conditions, etc.).")
    protected List<Reference> basis;
    protected List<Resource> basisTarget;
    @Child(name="prediction", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Outcome predicted", formalDefinition="Describes the expected outcome for the subject.")
    protected List<RiskAssessmentPredictionComponent> prediction;
    @Child(name="mitigation", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How to reduce risk", formalDefinition="A description of the steps that might be taken to reduce the identified risk(s).")
    protected StringType mitigation;
    private static final long serialVersionUID = 724306293L;
    @SearchParamDefinition(name="date", path="RiskAssessment.date", description="When was assessment made?", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="RiskAssessment.identifier", description="Unique identifier for the assessment", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="condition", path="RiskAssessment.condition", description="Condition assessed", type="reference")
    public static final String SP_CONDITION = "condition";
    @SearchParamDefinition(name="performer", path="RiskAssessment.performer", description="Who did assessment?", type="reference")
    public static final String SP_PERFORMER = "performer";
    @SearchParamDefinition(name="method", path="RiskAssessment.method", description="Evaluation mechanism", type="token")
    public static final String SP_METHOD = "method";
    @SearchParamDefinition(name="subject", path="RiskAssessment.subject", description="Who/what does assessment apply to?", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="patient", path="RiskAssessment.subject", description="Who/what does assessment apply to?", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="encounter", path="RiskAssessment.encounter", description="Where was assessment performed?", type="reference")
    public static final String SP_ENCOUNTER = "encounter";

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public RiskAssessment setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public RiskAssessment setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public RiskAssessment setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public RiskAssessment setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getCondition() {
        if (this.condition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.condition");
            }
            if (Configuration.doAutoCreate()) {
                this.condition = new Reference();
            }
        }
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && !this.condition.isEmpty();
    }

    public RiskAssessment setCondition(Reference value) {
        this.condition = value;
        return this;
    }

    public Condition getConditionTarget() {
        if (this.conditionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.condition");
            }
            if (Configuration.doAutoCreate()) {
                this.conditionTarget = new Condition();
            }
        }
        return this.conditionTarget;
    }

    public RiskAssessment setConditionTarget(Condition value) {
        this.conditionTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public RiskAssessment setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public RiskAssessment setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public RiskAssessment setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Resource getPerformerTarget() {
        return this.performerTarget;
    }

    public RiskAssessment setPerformerTarget(Resource value) {
        this.performerTarget = value;
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public RiskAssessment setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public RiskAssessment setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public List<Reference> getBasis() {
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        return this.basis;
    }

    public boolean hasBasis() {
        if (this.basis == null) {
            return false;
        }
        for (Reference item : this.basis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasis() {
        Reference t = new Reference();
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        this.basis.add(t);
        return t;
    }

    public RiskAssessment addBasis(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        this.basis.add(t);
        return this;
    }

    public List<Resource> getBasisTarget() {
        if (this.basisTarget == null) {
            this.basisTarget = new ArrayList<Resource>();
        }
        return this.basisTarget;
    }

    public List<RiskAssessmentPredictionComponent> getPrediction() {
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        return this.prediction;
    }

    public boolean hasPrediction() {
        if (this.prediction == null) {
            return false;
        }
        for (RiskAssessmentPredictionComponent item : this.prediction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RiskAssessmentPredictionComponent addPrediction() {
        RiskAssessmentPredictionComponent t = new RiskAssessmentPredictionComponent();
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        this.prediction.add(t);
        return t;
    }

    public RiskAssessment addPrediction(RiskAssessmentPredictionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        this.prediction.add(t);
        return this;
    }

    public StringType getMitigationElement() {
        if (this.mitigation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.mitigation");
            }
            if (Configuration.doAutoCreate()) {
                this.mitigation = new StringType();
            }
        }
        return this.mitigation;
    }

    public boolean hasMitigationElement() {
        return this.mitigation != null && !this.mitigation.isEmpty();
    }

    public boolean hasMitigation() {
        return this.mitigation != null && !this.mitigation.isEmpty();
    }

    public RiskAssessment setMitigationElement(StringType value) {
        this.mitigation = value;
        return this;
    }

    public String getMitigation() {
        return this.mitigation == null ? null : (String)this.mitigation.getValue();
    }

    public RiskAssessment setMitigation(String value) {
        if (Utilities.noString(value)) {
            this.mitigation = null;
        } else {
            if (this.mitigation == null) {
                this.mitigation = new StringType();
            }
            this.mitigation.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group the risk assessment applies to.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date (and possibly time) the risk assessment was performed.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_CONDITION, "Reference(Condition)", "For assessments or prognosis specific to a particular condition, indicates the condition being assessed.", 0, Integer.MAX_VALUE, this.condition));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter where the assessment was performed.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_PERFORMER, "Reference(Practitioner|Device)", "The provider or software application that performed the assessment.", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier assigned to the risk assessment.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_METHOD, "CodeableConcept", "The algorithm, process or mechanism used to evaluate the risk.", 0, Integer.MAX_VALUE, this.method));
        childrenList.add(new Property("basis", "Reference(Any)", "Indicates the source data considered as part of the assessment (FamilyHistory, Observations, Procedures, Conditions, etc.).", 0, Integer.MAX_VALUE, this.basis));
        childrenList.add(new Property("prediction", "", "Describes the expected outcome for the subject.", 0, Integer.MAX_VALUE, this.prediction));
        childrenList.add(new Property("mitigation", "string", "A description of the steps that might be taken to reduce the identified risk(s).", 0, Integer.MAX_VALUE, this.mitigation));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_CONDITION)) {
            this.condition = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = this.castToReference(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_METHOD)) {
            this.method = this.castToCodeableConcept(value);
        } else if (name.equals("basis")) {
            this.getBasis().add(this.castToReference(value));
        } else if (name.equals("prediction")) {
            this.getPrediction().add((RiskAssessmentPredictionComponent)value);
        } else if (name.equals("mitigation")) {
            this.mitigation = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.date");
        }
        if (name.equals(SP_CONDITION)) {
            this.condition = new Reference();
            return this.condition;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_METHOD)) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("basis")) {
            return this.addBasis();
        }
        if (name.equals("prediction")) {
            return this.addPrediction();
        }
        if (name.equals("mitigation")) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.mitigation");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RiskAssessment";
    }

    @Override
    public RiskAssessment copy() {
        RiskAssessment dst = new RiskAssessment();
        this.copyValues(dst);
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.condition = this.condition == null ? null : this.condition.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        CodeableConcept codeableConcept = dst.method = this.method == null ? null : this.method.copy();
        if (this.basis != null) {
            dst.basis = new ArrayList<Reference>();
            for (Reference reference : this.basis) {
                dst.basis.add(reference.copy());
            }
        }
        if (this.prediction != null) {
            dst.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
            for (RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : this.prediction) {
                dst.prediction.add(riskAssessmentPredictionComponent.copy());
            }
        }
        dst.mitigation = this.mitigation == null ? null : this.mitigation.copy();
        return dst;
    }

    protected RiskAssessment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof RiskAssessment)) {
            return false;
        }
        RiskAssessment o = (RiskAssessment)other;
        return RiskAssessment.compareDeep(this.subject, o.subject, true) && RiskAssessment.compareDeep(this.date, o.date, true) && RiskAssessment.compareDeep(this.condition, o.condition, true) && RiskAssessment.compareDeep(this.encounter, o.encounter, true) && RiskAssessment.compareDeep(this.performer, o.performer, true) && RiskAssessment.compareDeep(this.identifier, o.identifier, true) && RiskAssessment.compareDeep(this.method, o.method, true) && RiskAssessment.compareDeep(this.basis, o.basis, true) && RiskAssessment.compareDeep(this.prediction, o.prediction, true) && RiskAssessment.compareDeep(this.mitigation, o.mitigation, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof RiskAssessment)) {
            return false;
        }
        RiskAssessment o = (RiskAssessment)other;
        return RiskAssessment.compareValues(this.date, o.date, true) && RiskAssessment.compareValues(this.mitigation, o.mitigation, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.date != null && !this.date.isEmpty() || this.condition != null && !this.condition.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.method != null && !this.method.isEmpty() || this.basis != null && !this.basis.isEmpty() || this.prediction != null && !this.prediction.isEmpty() || this.mitigation != null && !this.mitigation.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RiskAssessment;
    }

    @Block
    public static class RiskAssessmentPredictionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="outcome", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Possible outcome for the subject", formalDefinition="One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).")
        protected CodeableConcept outcome;
        @Child(name="probability", type={DecimalType.class, Range.class, CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Likelihood of specified outcome", formalDefinition="How likely is the outcome (in the specified timeframe).")
        protected Type probability;
        @Child(name="relativeRisk", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Relative likelihood", formalDefinition="Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).")
        protected DecimalType relativeRisk;
        @Child(name="when", type={Period.class, Range.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Timeframe or age range", formalDefinition="Indicates the period of time or age range of the subject to which the specified probability applies.")
        protected Type when;
        @Child(name="rationale", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation of prediction", formalDefinition="Additional information explaining the basis for the prediction.")
        protected StringType rationale;
        private static final long serialVersionUID = 647967428L;

        public RiskAssessmentPredictionComponent() {
        }

        public RiskAssessmentPredictionComponent(CodeableConcept outcome) {
            this.outcome = outcome;
        }

        public CodeableConcept getOutcome() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new CodeableConcept();
                }
            }
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public RiskAssessmentPredictionComponent setOutcome(CodeableConcept value) {
            this.outcome = value;
            return this;
        }

        public Type getProbability() {
            return this.probability;
        }

        public DecimalType getProbabilityDecimalType() throws FHIRException {
            if (!(this.probability instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.probability.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.probability;
        }

        public boolean hasProbabilityDecimalType() {
            return this.probability instanceof DecimalType;
        }

        public Range getProbabilityRange() throws FHIRException {
            if (!(this.probability instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.probability.getClass().getName() + " was encountered");
            }
            return (Range)this.probability;
        }

        public boolean hasProbabilityRange() {
            return this.probability instanceof Range;
        }

        public CodeableConcept getProbabilityCodeableConcept() throws FHIRException {
            if (!(this.probability instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.probability.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.probability;
        }

        public boolean hasProbabilityCodeableConcept() {
            return this.probability instanceof CodeableConcept;
        }

        public boolean hasProbability() {
            return this.probability != null && !this.probability.isEmpty();
        }

        public RiskAssessmentPredictionComponent setProbability(Type value) {
            this.probability = value;
            return this;
        }

        public DecimalType getRelativeRiskElement() {
            if (this.relativeRisk == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.relativeRisk");
                }
                if (Configuration.doAutoCreate()) {
                    this.relativeRisk = new DecimalType();
                }
            }
            return this.relativeRisk;
        }

        public boolean hasRelativeRiskElement() {
            return this.relativeRisk != null && !this.relativeRisk.isEmpty();
        }

        public boolean hasRelativeRisk() {
            return this.relativeRisk != null && !this.relativeRisk.isEmpty();
        }

        public RiskAssessmentPredictionComponent setRelativeRiskElement(DecimalType value) {
            this.relativeRisk = value;
            return this;
        }

        public BigDecimal getRelativeRisk() {
            return this.relativeRisk == null ? null : (BigDecimal)this.relativeRisk.getValue();
        }

        public RiskAssessmentPredictionComponent setRelativeRisk(BigDecimal value) {
            if (value == null) {
                this.relativeRisk = null;
            } else {
                if (this.relativeRisk == null) {
                    this.relativeRisk = new DecimalType();
                }
                this.relativeRisk.setValue(value);
            }
            return this;
        }

        public Type getWhen() {
            return this.when;
        }

        public Period getWhenPeriod() throws FHIRException {
            if (!(this.when instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (Period)this.when;
        }

        public boolean hasWhenPeriod() {
            return this.when instanceof Period;
        }

        public Range getWhenRange() throws FHIRException {
            if (!(this.when instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (Range)this.when;
        }

        public boolean hasWhenRange() {
            return this.when instanceof Range;
        }

        public boolean hasWhen() {
            return this.when != null && !this.when.isEmpty();
        }

        public RiskAssessmentPredictionComponent setWhen(Type value) {
            this.when = value;
            return this;
        }

        public StringType getRationaleElement() {
            if (this.rationale == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.rationale");
                }
                if (Configuration.doAutoCreate()) {
                    this.rationale = new StringType();
                }
            }
            return this.rationale;
        }

        public boolean hasRationaleElement() {
            return this.rationale != null && !this.rationale.isEmpty();
        }

        public boolean hasRationale() {
            return this.rationale != null && !this.rationale.isEmpty();
        }

        public RiskAssessmentPredictionComponent setRationaleElement(StringType value) {
            this.rationale = value;
            return this;
        }

        public String getRationale() {
            return this.rationale == null ? null : (String)this.rationale.getValue();
        }

        public RiskAssessmentPredictionComponent setRationale(String value) {
            if (Utilities.noString(value)) {
                this.rationale = null;
            } else {
                if (this.rationale == null) {
                    this.rationale = new StringType();
                }
                this.rationale.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("outcome", "CodeableConcept", "One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).", 0, Integer.MAX_VALUE, this.outcome));
            childrenList.add(new Property("probability[x]", "decimal|Range|CodeableConcept", "How likely is the outcome (in the specified timeframe).", 0, Integer.MAX_VALUE, this.probability));
            childrenList.add(new Property("relativeRisk", "decimal", "Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).", 0, Integer.MAX_VALUE, this.relativeRisk));
            childrenList.add(new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, Integer.MAX_VALUE, this.when));
            childrenList.add(new Property("rationale", "string", "Additional information explaining the basis for the prediction.", 0, Integer.MAX_VALUE, this.rationale));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("outcome")) {
                this.outcome = this.castToCodeableConcept(value);
            } else if (name.equals("probability[x]")) {
                this.probability = (Type)value;
            } else if (name.equals("relativeRisk")) {
                this.relativeRisk = this.castToDecimal(value);
            } else if (name.equals("when[x]")) {
                this.when = (Type)value;
            } else if (name.equals("rationale")) {
                this.rationale = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("outcome")) {
                this.outcome = new CodeableConcept();
                return this.outcome;
            }
            if (name.equals("probabilityDecimal")) {
                this.probability = new DecimalType();
                return this.probability;
            }
            if (name.equals("probabilityRange")) {
                this.probability = new Range();
                return this.probability;
            }
            if (name.equals("probabilityCodeableConcept")) {
                this.probability = new CodeableConcept();
                return this.probability;
            }
            if (name.equals("relativeRisk")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.relativeRisk");
            }
            if (name.equals("whenPeriod")) {
                this.when = new Period();
                return this.when;
            }
            if (name.equals("whenRange")) {
                this.when = new Range();
                return this.when;
            }
            if (name.equals("rationale")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.rationale");
            }
            return super.addChild(name);
        }

        @Override
        public RiskAssessmentPredictionComponent copy() {
            RiskAssessmentPredictionComponent dst = new RiskAssessmentPredictionComponent();
            this.copyValues(dst);
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            dst.probability = this.probability == null ? null : this.probability.copy();
            dst.relativeRisk = this.relativeRisk == null ? null : this.relativeRisk.copy();
            dst.when = this.when == null ? null : this.when.copy();
            dst.rationale = this.rationale == null ? null : this.rationale.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof RiskAssessmentPredictionComponent)) {
                return false;
            }
            RiskAssessmentPredictionComponent o = (RiskAssessmentPredictionComponent)other;
            return RiskAssessmentPredictionComponent.compareDeep(this.outcome, o.outcome, true) && RiskAssessmentPredictionComponent.compareDeep(this.probability, o.probability, true) && RiskAssessmentPredictionComponent.compareDeep(this.relativeRisk, o.relativeRisk, true) && RiskAssessmentPredictionComponent.compareDeep(this.when, o.when, true) && RiskAssessmentPredictionComponent.compareDeep(this.rationale, o.rationale, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof RiskAssessmentPredictionComponent)) {
                return false;
            }
            RiskAssessmentPredictionComponent o = (RiskAssessmentPredictionComponent)other;
            return RiskAssessmentPredictionComponent.compareValues(this.relativeRisk, o.relativeRisk, true) && RiskAssessmentPredictionComponent.compareValues(this.rationale, o.rationale, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.probability != null && !this.probability.isEmpty() || this.relativeRisk != null && !this.relativeRisk.isEmpty() || this.when != null && !this.when.isEmpty() || this.rationale != null && !this.rationale.isEmpty());
        }

        @Override
        public String fhirType() {
            return "RiskAssessment.prediction";
        }
    }
}

