/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class PrimitiveType<T>
extends Type
implements IPrimitiveType<T>,
IBaseHasExtensions {
    private static final long serialVersionUID = 3L;
    private T myCoercedValue;
    private String myStringValue;

    @Override
    public T getValue() {
        return this.myCoercedValue;
    }

    public String asStringValue() {
        return this.myStringValue;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getValue()).toHashCode();
    }

    @Override
    public PrimitiveType<T> setValue(T theValue) {
        this.myCoercedValue = theValue;
        this.updateStringValue();
        return this;
    }

    protected void updateStringValue() {
        this.myStringValue = this.myCoercedValue == null ? null : this.encode(this.myCoercedValue);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && StringUtils.isBlank(this.getValueAsString());
    }

    public void fromStringValue(String theValue) {
        this.myCoercedValue = theValue == null ? null : this.parse(theValue);
        this.myStringValue = theValue;
    }

    protected abstract T parse(String var1);

    protected abstract String encode(T var1);

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public String primitiveValue() {
        return this.asStringValue();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.asStringValue() + "]";
    }

    @Override
    public boolean hasValue() {
        return !StringUtils.isBlank(this.getValueAsString());
    }

    @Override
    public String getValueAsString() {
        return this.asStringValue();
    }

    @Override
    public void setValueAsString(String theValue) {
        this.fromStringValue(theValue);
    }

    @Override
    protected Type typedCopy() {
        return this.copy();
    }

    @Override
    public abstract Type copy();

    @Override
    public boolean equalsDeep(Base obj) {
        if (!super.equalsDeep(obj)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PrimitiveType o = (PrimitiveType)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append(this.getValue(), o.getValue());
        return b.isEquals();
    }

    @Override
    public boolean equalsShallow(Base obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PrimitiveType o = (PrimitiveType)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append(this.getValue(), o.getValue());
        return b.isEquals();
    }
}

