/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Immunization", profile="http://hl7.org/fhir/Profile/Immunization")
public class Immunization
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this immunization record.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | on-hold | completed | entered-in-error | stopped", formalDefinition="Indicates the current status of the vaccination event.")
    protected CodeType status;
    @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccination administration date", formalDefinition="Date vaccine administered or was to be administered.")
    protected DateTimeType date;
    @Child(name="vaccineCode", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccine product administered", formalDefinition="Vaccine that was administered or was to be administered.")
    protected CodeableConcept vaccineCode;
    @Child(name="patient", type={Patient.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who was immunized", formalDefinition="The patient who either received or did not receive the immunization.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="wasNotGiven", type={BooleanType.class}, order=5, min=1, max=1, modifier=true, summary=false)
    @Description(shortDefinition="Flag for whether immunization was given", formalDefinition="Indicates if the vaccination was or was not given.")
    protected BooleanType wasNotGiven;
    @Child(name="reported", type={BooleanType.class}, order=6, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates a self-reported record", formalDefinition="True if this administration was reported rather than directly administered.")
    protected BooleanType reported;
    @Child(name="performer", type={Practitioner.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who administered vaccine", formalDefinition="Clinician who administered the vaccine.")
    protected Reference performer;
    protected Practitioner performerTarget;
    @Child(name="requester", type={Practitioner.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who ordered vaccination", formalDefinition="Clinician who ordered the vaccination.")
    protected Reference requester;
    protected Practitioner requesterTarget;
    @Child(name="encounter", type={Encounter.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter administered as part of", formalDefinition="The visit or admission or other contact between patient and health care provider the immunization was performed as part of.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="manufacturer", type={Organization.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccine manufacturer", formalDefinition="Name of vaccine manufacturer.")
    protected Reference manufacturer;
    protected Organization manufacturerTarget;
    @Child(name="location", type={Location.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where vaccination occurred", formalDefinition="The service delivery location where the vaccine administration occurred.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="lotNumber", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccine lot number", formalDefinition="Lot number of the  vaccine product.")
    protected StringType lotNumber;
    @Child(name="expirationDate", type={DateType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccine expiration date", formalDefinition="Date vaccine batch expires.")
    protected DateType expirationDate;
    @Child(name="site", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Body site vaccine  was administered", formalDefinition="Body site where vaccine was administered.")
    protected CodeableConcept site;
    @Child(name="route", type={CodeableConcept.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How vaccine entered body", formalDefinition="The path by which the vaccine product is taken into the body.")
    protected CodeableConcept route;
    @Child(name="doseQuantity", type={SimpleQuantity.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Amount of vaccine administered", formalDefinition="The quantity of vaccine product that was administered.")
    protected SimpleQuantity doseQuantity;
    @Child(name="note", type={Annotation.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Vaccination notes", formalDefinition="Extra information about the immunization that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="explanation", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Administration/non-administration reasons", formalDefinition="Reasons why a vaccine was or was not administered.")
    protected ImmunizationExplanationComponent explanation;
    @Child(name="reaction", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details of a reaction that follows immunization", formalDefinition="Categorical data indicating that an adverse event is associated in time to an immunization.")
    protected List<ImmunizationReactionComponent> reaction;
    @Child(name="vaccinationProtocol", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What protocol was followed", formalDefinition="Contains information about the protocol(s) under which the vaccine was administered.")
    protected List<ImmunizationVaccinationProtocolComponent> vaccinationProtocol;
    private static final long serialVersionUID = 898786200L;
    @SearchParamDefinition(name="date", path="Immunization.date", description="Vaccination  (non)-Administration Date", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="requester", path="Immunization.requester", description="The practitioner who ordered the vaccination", type="reference")
    public static final String SP_REQUESTER = "requester";
    @SearchParamDefinition(name="identifier", path="Immunization.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="reason", path="Immunization.explanation.reason", description="Why immunization occurred", type="token")
    public static final String SP_REASON = "reason";
    @SearchParamDefinition(name="performer", path="Immunization.performer", description="The practitioner who administered the vaccination", type="reference")
    public static final String SP_PERFORMER = "performer";
    @SearchParamDefinition(name="reaction", path="Immunization.reaction.detail", description="Additional information on reaction", type="reference")
    public static final String SP_REACTION = "reaction";
    @SearchParamDefinition(name="lot-number", path="Immunization.lotNumber", description="Vaccine Lot Number", type="string")
    public static final String SP_LOTNUMBER = "lot-number";
    @SearchParamDefinition(name="notgiven", path="Immunization.wasNotGiven", description="Administrations which were not given", type="token")
    public static final String SP_NOTGIVEN = "notgiven";
    @SearchParamDefinition(name="manufacturer", path="Immunization.manufacturer", description="Vaccine Manufacturer", type="reference")
    public static final String SP_MANUFACTURER = "manufacturer";
    @SearchParamDefinition(name="dose-sequence", path="Immunization.vaccinationProtocol.doseSequence", description="Dose number within series", type="number")
    public static final String SP_DOSESEQUENCE = "dose-sequence";
    @SearchParamDefinition(name="patient", path="Immunization.patient", description="The patient for the vaccination record", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="vaccine-code", path="Immunization.vaccineCode", description="Vaccine Product Administered", type="token")
    public static final String SP_VACCINECODE = "vaccine-code";
    @SearchParamDefinition(name="reason-not-given", path="Immunization.explanation.reasonNotGiven", description="Explanation of reason vaccination was not administered", type="token")
    public static final String SP_REASONNOTGIVEN = "reason-not-given";
    @SearchParamDefinition(name="location", path="Immunization.location", description="The service delivery location or facility in which the vaccine was / was to be administered", type="reference")
    public static final String SP_LOCATION = "location";
    @SearchParamDefinition(name="reaction-date", path="Immunization.reaction.date", description="When reaction started", type="date")
    public static final String SP_REACTIONDATE = "reaction-date";
    @SearchParamDefinition(name="status", path="Immunization.status", description="Immunization event status", type="token")
    public static final String SP_STATUS = "status";

    public Immunization() {
    }

    public Immunization(CodeType status, CodeableConcept vaccineCode, Reference patient, BooleanType wasNotGiven, BooleanType reported) {
        this.status = status;
        this.vaccineCode = vaccineCode;
        this.patient = patient;
        this.wasNotGiven = wasNotGiven;
        this.reported = reported;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Immunization addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeType getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeType();
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Immunization setStatusElement(CodeType value) {
        this.status = value;
        return this;
    }

    public String getStatus() {
        return this.status == null ? null : (String)this.status.getValue();
    }

    public Immunization setStatus(String value) {
        if (this.status == null) {
            this.status = new CodeType();
        }
        this.status.setValue(value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Immunization setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Immunization setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public CodeableConcept getVaccineCode() {
        if (this.vaccineCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.vaccineCode");
            }
            if (Configuration.doAutoCreate()) {
                this.vaccineCode = new CodeableConcept();
            }
        }
        return this.vaccineCode;
    }

    public boolean hasVaccineCode() {
        return this.vaccineCode != null && !this.vaccineCode.isEmpty();
    }

    public Immunization setVaccineCode(CodeableConcept value) {
        this.vaccineCode = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Immunization setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Immunization setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public BooleanType getWasNotGivenElement() {
        if (this.wasNotGiven == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.wasNotGiven");
            }
            if (Configuration.doAutoCreate()) {
                this.wasNotGiven = new BooleanType();
            }
        }
        return this.wasNotGiven;
    }

    public boolean hasWasNotGivenElement() {
        return this.wasNotGiven != null && !this.wasNotGiven.isEmpty();
    }

    public boolean hasWasNotGiven() {
        return this.wasNotGiven != null && !this.wasNotGiven.isEmpty();
    }

    public Immunization setWasNotGivenElement(BooleanType value) {
        this.wasNotGiven = value;
        return this;
    }

    public boolean getWasNotGiven() {
        return this.wasNotGiven == null || this.wasNotGiven.isEmpty() ? false : (Boolean)this.wasNotGiven.getValue();
    }

    public Immunization setWasNotGiven(boolean value) {
        if (this.wasNotGiven == null) {
            this.wasNotGiven = new BooleanType();
        }
        this.wasNotGiven.setValue((Object)value);
        return this;
    }

    public BooleanType getReportedElement() {
        if (this.reported == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.reported");
            }
            if (Configuration.doAutoCreate()) {
                this.reported = new BooleanType();
            }
        }
        return this.reported;
    }

    public boolean hasReportedElement() {
        return this.reported != null && !this.reported.isEmpty();
    }

    public boolean hasReported() {
        return this.reported != null && !this.reported.isEmpty();
    }

    public Immunization setReportedElement(BooleanType value) {
        this.reported = value;
        return this;
    }

    public boolean getReported() {
        return this.reported == null || this.reported.isEmpty() ? false : (Boolean)this.reported.getValue();
    }

    public Immunization setReported(boolean value) {
        if (this.reported == null) {
            this.reported = new BooleanType();
        }
        this.reported.setValue((Object)value);
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public Immunization setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Practitioner getPerformerTarget() {
        if (this.performerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performerTarget = new Practitioner();
            }
        }
        return this.performerTarget;
    }

    public Immunization setPerformerTarget(Practitioner value) {
        this.performerTarget = value;
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public Immunization setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public Practitioner getRequesterTarget() {
        if (this.requesterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requesterTarget = new Practitioner();
            }
        }
        return this.requesterTarget;
    }

    public Immunization setRequesterTarget(Practitioner value) {
        this.requesterTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Immunization setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Immunization setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Immunization setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public Organization getManufacturerTarget() {
        if (this.manufacturerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturerTarget = new Organization();
            }
        }
        return this.manufacturerTarget;
    }

    public Immunization setManufacturerTarget(Organization value) {
        this.manufacturerTarget = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Immunization setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Immunization setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public Immunization setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public Immunization setLotNumber(String value) {
        if (Utilities.noString(value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public DateType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public Immunization setExpirationDateElement(DateType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public Immunization setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public CodeableConcept getSite() {
        if (this.site == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.site");
            }
            if (Configuration.doAutoCreate()) {
                this.site = new CodeableConcept();
            }
        }
        return this.site;
    }

    public boolean hasSite() {
        return this.site != null && !this.site.isEmpty();
    }

    public Immunization setSite(CodeableConcept value) {
        this.site = value;
        return this;
    }

    public CodeableConcept getRoute() {
        if (this.route == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.route");
            }
            if (Configuration.doAutoCreate()) {
                this.route = new CodeableConcept();
            }
        }
        return this.route;
    }

    public boolean hasRoute() {
        return this.route != null && !this.route.isEmpty();
    }

    public Immunization setRoute(CodeableConcept value) {
        this.route = value;
        return this;
    }

    public SimpleQuantity getDoseQuantity() {
        if (this.doseQuantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.doseQuantity");
            }
            if (Configuration.doAutoCreate()) {
                this.doseQuantity = new SimpleQuantity();
            }
        }
        return this.doseQuantity;
    }

    public boolean hasDoseQuantity() {
        return this.doseQuantity != null && !this.doseQuantity.isEmpty();
    }

    public Immunization setDoseQuantity(SimpleQuantity value) {
        this.doseQuantity = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Immunization addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public ImmunizationExplanationComponent getExplanation() {
        if (this.explanation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.explanation");
            }
            if (Configuration.doAutoCreate()) {
                this.explanation = new ImmunizationExplanationComponent();
            }
        }
        return this.explanation;
    }

    public boolean hasExplanation() {
        return this.explanation != null && !this.explanation.isEmpty();
    }

    public Immunization setExplanation(ImmunizationExplanationComponent value) {
        this.explanation = value;
        return this;
    }

    public List<ImmunizationReactionComponent> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReactionComponent>();
        }
        return this.reaction;
    }

    public boolean hasReaction() {
        if (this.reaction == null) {
            return false;
        }
        for (ImmunizationReactionComponent item : this.reaction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationReactionComponent addReaction() {
        ImmunizationReactionComponent t = new ImmunizationReactionComponent();
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReactionComponent>();
        }
        this.reaction.add(t);
        return t;
    }

    public Immunization addReaction(ImmunizationReactionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReactionComponent>();
        }
        this.reaction.add(t);
        return this;
    }

    public List<ImmunizationVaccinationProtocolComponent> getVaccinationProtocol() {
        if (this.vaccinationProtocol == null) {
            this.vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocolComponent>();
        }
        return this.vaccinationProtocol;
    }

    public boolean hasVaccinationProtocol() {
        if (this.vaccinationProtocol == null) {
            return false;
        }
        for (ImmunizationVaccinationProtocolComponent item : this.vaccinationProtocol) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationVaccinationProtocolComponent addVaccinationProtocol() {
        ImmunizationVaccinationProtocolComponent t = new ImmunizationVaccinationProtocolComponent();
        if (this.vaccinationProtocol == null) {
            this.vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocolComponent>();
        }
        this.vaccinationProtocol.add(t);
        return t;
    }

    public Immunization addVaccinationProtocol(ImmunizationVaccinationProtocolComponent t) {
        if (t == null) {
            return this;
        }
        if (this.vaccinationProtocol == null) {
            this.vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocolComponent>();
        }
        this.vaccinationProtocol.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this immunization record.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "Indicates the current status of the vaccination event.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_DATE, "dateTime", "Date vaccine administered or was to be administered.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property("vaccineCode", "CodeableConcept", "Vaccine that was administered or was to be administered.", 0, Integer.MAX_VALUE, this.vaccineCode));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who either received or did not receive the immunization.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("wasNotGiven", "boolean", "Indicates if the vaccination was or was not given.", 0, Integer.MAX_VALUE, this.wasNotGiven));
        childrenList.add(new Property("reported", "boolean", "True if this administration was reported rather than directly administered.", 0, Integer.MAX_VALUE, this.reported));
        childrenList.add(new Property(SP_PERFORMER, "Reference(Practitioner)", "Clinician who administered the vaccine.", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property(SP_REQUESTER, "Reference(Practitioner)", "Clinician who ordered the vaccination.", 0, Integer.MAX_VALUE, this.requester));
        childrenList.add(new Property("encounter", "Reference(Encounter)", "The visit or admission or other contact between patient and health care provider the immunization was performed as part of.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Name of vaccine manufacturer.", 0, Integer.MAX_VALUE, this.manufacturer));
        childrenList.add(new Property(SP_LOCATION, "Reference(Location)", "The service delivery location where the vaccine administration occurred.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property("lotNumber", "string", "Lot number of the  vaccine product.", 0, Integer.MAX_VALUE, this.lotNumber));
        childrenList.add(new Property("expirationDate", SP_DATE, "Date vaccine batch expires.", 0, Integer.MAX_VALUE, this.expirationDate));
        childrenList.add(new Property("site", "CodeableConcept", "Body site where vaccine was administered.", 0, Integer.MAX_VALUE, this.site));
        childrenList.add(new Property("route", "CodeableConcept", "The path by which the vaccine product is taken into the body.", 0, Integer.MAX_VALUE, this.route));
        childrenList.add(new Property("doseQuantity", "SimpleQuantity", "The quantity of vaccine product that was administered.", 0, Integer.MAX_VALUE, this.doseQuantity));
        childrenList.add(new Property("note", "Annotation", "Extra information about the immunization that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("explanation", "", "Reasons why a vaccine was or was not administered.", 0, Integer.MAX_VALUE, this.explanation));
        childrenList.add(new Property(SP_REACTION, "", "Categorical data indicating that an adverse event is associated in time to an immunization.", 0, Integer.MAX_VALUE, this.reaction));
        childrenList.add(new Property("vaccinationProtocol", "", "Contains information about the protocol(s) under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.vaccinationProtocol));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = this.castToCode(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("vaccineCode")) {
            this.vaccineCode = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("wasNotGiven")) {
            this.wasNotGiven = this.castToBoolean(value);
        } else if (name.equals("reported")) {
            this.reported = this.castToBoolean(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = this.castToReference(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = this.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToReference(value);
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = this.castToString(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = this.castToDate(value);
        } else if (name.equals("site")) {
            this.site = this.castToCodeableConcept(value);
        } else if (name.equals("route")) {
            this.route = this.castToCodeableConcept(value);
        } else if (name.equals("doseQuantity")) {
            this.doseQuantity = this.castToSimpleQuantity(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("explanation")) {
            this.explanation = (ImmunizationExplanationComponent)value;
        } else if (name.equals(SP_REACTION)) {
            this.getReaction().add((ImmunizationReactionComponent)value);
        } else if (name.equals("vaccinationProtocol")) {
            this.getVaccinationProtocol().add((ImmunizationVaccinationProtocolComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.status");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.date");
        }
        if (name.equals("vaccineCode")) {
            this.vaccineCode = new CodeableConcept();
            return this.vaccineCode;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("wasNotGiven")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.wasNotGiven");
        }
        if (name.equals("reported")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.reported");
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.lotNumber");
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.expirationDate");
        }
        if (name.equals("site")) {
            this.site = new CodeableConcept();
            return this.site;
        }
        if (name.equals("route")) {
            this.route = new CodeableConcept();
            return this.route;
        }
        if (name.equals("doseQuantity")) {
            this.doseQuantity = new SimpleQuantity();
            return this.doseQuantity;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("explanation")) {
            this.explanation = new ImmunizationExplanationComponent();
            return this.explanation;
        }
        if (name.equals(SP_REACTION)) {
            return this.addReaction();
        }
        if (name.equals("vaccinationProtocol")) {
            return this.addVaccinationProtocol();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Immunization";
    }

    @Override
    public Immunization copy() {
        Immunization dst = new Immunization();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.vaccineCode = this.vaccineCode == null ? null : this.vaccineCode.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.wasNotGiven = this.wasNotGiven == null ? null : this.wasNotGiven.copy();
        dst.reported = this.reported == null ? null : this.reported.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        dst.requester = this.requester == null ? null : this.requester.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.location = this.location == null ? null : this.location.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.site = this.site == null ? null : this.site.copy();
        dst.route = this.route == null ? null : this.route.copy();
        SimpleQuantity simpleQuantity = dst.doseQuantity = this.doseQuantity == null ? null : this.doseQuantity.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        ImmunizationExplanationComponent immunizationExplanationComponent = dst.explanation = this.explanation == null ? null : this.explanation.copy();
        if (this.reaction != null) {
            dst.reaction = new ArrayList<ImmunizationReactionComponent>();
            for (ImmunizationReactionComponent immunizationReactionComponent : this.reaction) {
                dst.reaction.add(immunizationReactionComponent.copy());
            }
        }
        if (this.vaccinationProtocol != null) {
            dst.vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocolComponent>();
            for (ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent : this.vaccinationProtocol) {
                dst.vaccinationProtocol.add(immunizationVaccinationProtocolComponent.copy());
            }
        }
        return dst;
    }

    protected Immunization typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Immunization)) {
            return false;
        }
        Immunization o = (Immunization)other;
        return Immunization.compareDeep(this.identifier, o.identifier, true) && Immunization.compareDeep(this.status, o.status, true) && Immunization.compareDeep(this.date, o.date, true) && Immunization.compareDeep(this.vaccineCode, o.vaccineCode, true) && Immunization.compareDeep(this.patient, o.patient, true) && Immunization.compareDeep(this.wasNotGiven, o.wasNotGiven, true) && Immunization.compareDeep(this.reported, o.reported, true) && Immunization.compareDeep(this.performer, o.performer, true) && Immunization.compareDeep(this.requester, o.requester, true) && Immunization.compareDeep(this.encounter, o.encounter, true) && Immunization.compareDeep(this.manufacturer, o.manufacturer, true) && Immunization.compareDeep(this.location, o.location, true) && Immunization.compareDeep(this.lotNumber, o.lotNumber, true) && Immunization.compareDeep(this.expirationDate, o.expirationDate, true) && Immunization.compareDeep(this.site, o.site, true) && Immunization.compareDeep(this.route, o.route, true) && Immunization.compareDeep(this.doseQuantity, o.doseQuantity, true) && Immunization.compareDeep(this.note, o.note, true) && Immunization.compareDeep(this.explanation, o.explanation, true) && Immunization.compareDeep(this.reaction, o.reaction, true) && Immunization.compareDeep(this.vaccinationProtocol, o.vaccinationProtocol, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Immunization)) {
            return false;
        }
        Immunization o = (Immunization)other;
        return Immunization.compareValues(this.status, o.status, true) && Immunization.compareValues(this.date, o.date, true) && Immunization.compareValues(this.wasNotGiven, o.wasNotGiven, true) && Immunization.compareValues(this.reported, o.reported, true) && Immunization.compareValues(this.lotNumber, o.lotNumber, true) && Immunization.compareValues(this.expirationDate, o.expirationDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.date != null && !this.date.isEmpty() || this.vaccineCode != null && !this.vaccineCode.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.wasNotGiven != null && !this.wasNotGiven.isEmpty() || this.reported != null && !this.reported.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.requester != null && !this.requester.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.manufacturer != null && !this.manufacturer.isEmpty() || this.location != null && !this.location.isEmpty() || this.lotNumber != null && !this.lotNumber.isEmpty() || this.expirationDate != null && !this.expirationDate.isEmpty() || this.site != null && !this.site.isEmpty() || this.route != null && !this.route.isEmpty() || this.doseQuantity != null && !this.doseQuantity.isEmpty() || this.note != null && !this.note.isEmpty() || this.explanation != null && !this.explanation.isEmpty() || this.reaction != null && !this.reaction.isEmpty() || this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Immunization;
    }

    @Block
    public static class ImmunizationVaccinationProtocolComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="doseSequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Dose number within series", formalDefinition="Nominal position in a series.")
        protected PositiveIntType doseSequence;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Details of vaccine protocol", formalDefinition="Contains the description about the protocol under which the vaccine was administered.")
        protected StringType description;
        @Child(name="authority", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is responsible for protocol", formalDefinition="Indicates the authority who published the protocol.  E.g. ACIP.")
        protected Reference authority;
        protected Organization authorityTarget;
        @Child(name="series", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of vaccine series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority.")
        protected StringType series;
        @Child(name="seriesDoses", type={PositiveIntType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recommended number of doses for immunity", formalDefinition="The recommended number of doses to achieve immunity.")
        protected PositiveIntType seriesDoses;
        @Child(name="targetDisease", type={CodeableConcept.class}, order=6, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Disease immunized against", formalDefinition="The targeted disease.")
        protected List<CodeableConcept> targetDisease;
        @Child(name="doseStatus", type={CodeableConcept.class}, order=7, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates if dose counts towards immunity", formalDefinition="Indicates if the immunization event should \"count\" against  the protocol.")
        protected CodeableConcept doseStatus;
        @Child(name="doseStatusReason", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why dose does (not) count", formalDefinition="Provides an explanation as to why an immunization event should or should not count against the protocol.")
        protected CodeableConcept doseStatusReason;
        private static final long serialVersionUID = 386814037L;

        public ImmunizationVaccinationProtocolComponent() {
        }

        public ImmunizationVaccinationProtocolComponent(PositiveIntType doseSequence, CodeableConcept doseStatus) {
            this.doseSequence = doseSequence;
            this.doseStatus = doseStatus;
        }

        public PositiveIntType getDoseSequenceElement() {
            if (this.doseSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.doseSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseSequence = new PositiveIntType();
                }
            }
            return this.doseSequence;
        }

        public boolean hasDoseSequenceElement() {
            return this.doseSequence != null && !this.doseSequence.isEmpty();
        }

        public boolean hasDoseSequence() {
            return this.doseSequence != null && !this.doseSequence.isEmpty();
        }

        public ImmunizationVaccinationProtocolComponent setDoseSequenceElement(PositiveIntType value) {
            this.doseSequence = value;
            return this;
        }

        public int getDoseSequence() {
            return this.doseSequence == null || this.doseSequence.isEmpty() ? 0 : (Integer)this.doseSequence.getValue();
        }

        public ImmunizationVaccinationProtocolComponent setDoseSequence(int value) {
            if (this.doseSequence == null) {
                this.doseSequence = new PositiveIntType();
            }
            this.doseSequence.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImmunizationVaccinationProtocolComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImmunizationVaccinationProtocolComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Reference getAuthority() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new Reference();
                }
            }
            return this.authority;
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public ImmunizationVaccinationProtocolComponent setAuthority(Reference value) {
            this.authority = value;
            return this;
        }

        public Organization getAuthorityTarget() {
            if (this.authorityTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorityTarget = new Organization();
                }
            }
            return this.authorityTarget;
        }

        public ImmunizationVaccinationProtocolComponent setAuthorityTarget(Organization value) {
            this.authorityTarget = value;
            return this;
        }

        public StringType getSeriesElement() {
            if (this.series == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.series");
                }
                if (Configuration.doAutoCreate()) {
                    this.series = new StringType();
                }
            }
            return this.series;
        }

        public boolean hasSeriesElement() {
            return this.series != null && !this.series.isEmpty();
        }

        public boolean hasSeries() {
            return this.series != null && !this.series.isEmpty();
        }

        public ImmunizationVaccinationProtocolComponent setSeriesElement(StringType value) {
            this.series = value;
            return this;
        }

        public String getSeries() {
            return this.series == null ? null : (String)this.series.getValue();
        }

        public ImmunizationVaccinationProtocolComponent setSeries(String value) {
            if (Utilities.noString(value)) {
                this.series = null;
            } else {
                if (this.series == null) {
                    this.series = new StringType();
                }
                this.series.setValue(value);
            }
            return this;
        }

        public PositiveIntType getSeriesDosesElement() {
            if (this.seriesDoses == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.seriesDoses");
                }
                if (Configuration.doAutoCreate()) {
                    this.seriesDoses = new PositiveIntType();
                }
            }
            return this.seriesDoses;
        }

        public boolean hasSeriesDosesElement() {
            return this.seriesDoses != null && !this.seriesDoses.isEmpty();
        }

        public boolean hasSeriesDoses() {
            return this.seriesDoses != null && !this.seriesDoses.isEmpty();
        }

        public ImmunizationVaccinationProtocolComponent setSeriesDosesElement(PositiveIntType value) {
            this.seriesDoses = value;
            return this;
        }

        public int getSeriesDoses() {
            return this.seriesDoses == null || this.seriesDoses.isEmpty() ? 0 : (Integer)this.seriesDoses.getValue();
        }

        public ImmunizationVaccinationProtocolComponent setSeriesDoses(int value) {
            if (this.seriesDoses == null) {
                this.seriesDoses = new PositiveIntType();
            }
            this.seriesDoses.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getTargetDisease() {
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            return this.targetDisease;
        }

        public boolean hasTargetDisease() {
            if (this.targetDisease == null) {
                return false;
            }
            for (CodeableConcept item : this.targetDisease) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addTargetDisease() {
            CodeableConcept t = new CodeableConcept();
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            this.targetDisease.add(t);
            return t;
        }

        public ImmunizationVaccinationProtocolComponent addTargetDisease(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            this.targetDisease.add(t);
            return this;
        }

        public CodeableConcept getDoseStatus() {
            if (this.doseStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.doseStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseStatus = new CodeableConcept();
                }
            }
            return this.doseStatus;
        }

        public boolean hasDoseStatus() {
            return this.doseStatus != null && !this.doseStatus.isEmpty();
        }

        public ImmunizationVaccinationProtocolComponent setDoseStatus(CodeableConcept value) {
            this.doseStatus = value;
            return this;
        }

        public CodeableConcept getDoseStatusReason() {
            if (this.doseStatusReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationVaccinationProtocolComponent.doseStatusReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseStatusReason = new CodeableConcept();
                }
            }
            return this.doseStatusReason;
        }

        public boolean hasDoseStatusReason() {
            return this.doseStatusReason != null && !this.doseStatusReason.isEmpty();
        }

        public ImmunizationVaccinationProtocolComponent setDoseStatusReason(CodeableConcept value) {
            this.doseStatusReason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("doseSequence", "positiveInt", "Nominal position in a series.", 0, Integer.MAX_VALUE, this.doseSequence));
            childrenList.add(new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol.  E.g. ACIP.", 0, Integer.MAX_VALUE, this.authority));
            childrenList.add(new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, Integer.MAX_VALUE, this.series));
            childrenList.add(new Property("seriesDoses", "positiveInt", "The recommended number of doses to achieve immunity.", 0, Integer.MAX_VALUE, this.seriesDoses));
            childrenList.add(new Property("targetDisease", "CodeableConcept", "The targeted disease.", 0, Integer.MAX_VALUE, this.targetDisease));
            childrenList.add(new Property("doseStatus", "CodeableConcept", "Indicates if the immunization event should \"count\" against  the protocol.", 0, Integer.MAX_VALUE, this.doseStatus));
            childrenList.add(new Property("doseStatusReason", "CodeableConcept", "Provides an explanation as to why an immunization event should or should not count against the protocol.", 0, Integer.MAX_VALUE, this.doseStatusReason));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("doseSequence")) {
                this.doseSequence = this.castToPositiveInt(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("authority")) {
                this.authority = this.castToReference(value);
            } else if (name.equals("series")) {
                this.series = this.castToString(value);
            } else if (name.equals("seriesDoses")) {
                this.seriesDoses = this.castToPositiveInt(value);
            } else if (name.equals("targetDisease")) {
                this.getTargetDisease().add(this.castToCodeableConcept(value));
            } else if (name.equals("doseStatus")) {
                this.doseStatus = this.castToCodeableConcept(value);
            } else if (name.equals("doseStatusReason")) {
                this.doseStatusReason = this.castToCodeableConcept(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("doseSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.doseSequence");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.description");
            }
            if (name.equals("authority")) {
                this.authority = new Reference();
                return this.authority;
            }
            if (name.equals("series")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.series");
            }
            if (name.equals("seriesDoses")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.seriesDoses");
            }
            if (name.equals("targetDisease")) {
                return this.addTargetDisease();
            }
            if (name.equals("doseStatus")) {
                this.doseStatus = new CodeableConcept();
                return this.doseStatus;
            }
            if (name.equals("doseStatusReason")) {
                this.doseStatusReason = new CodeableConcept();
                return this.doseStatusReason;
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationVaccinationProtocolComponent copy() {
            ImmunizationVaccinationProtocolComponent dst = new ImmunizationVaccinationProtocolComponent();
            this.copyValues(dst);
            dst.doseSequence = this.doseSequence == null ? null : this.doseSequence.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.series = this.series == null ? null : this.series.copy();
            PositiveIntType positiveIntType = dst.seriesDoses = this.seriesDoses == null ? null : this.seriesDoses.copy();
            if (this.targetDisease != null) {
                dst.targetDisease = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.targetDisease) {
                    dst.targetDisease.add(i.copy());
                }
            }
            dst.doseStatus = this.doseStatus == null ? null : this.doseStatus.copy();
            dst.doseStatusReason = this.doseStatusReason == null ? null : this.doseStatusReason.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationVaccinationProtocolComponent)) {
                return false;
            }
            ImmunizationVaccinationProtocolComponent o = (ImmunizationVaccinationProtocolComponent)other;
            return ImmunizationVaccinationProtocolComponent.compareDeep(this.doseSequence, o.doseSequence, true) && ImmunizationVaccinationProtocolComponent.compareDeep(this.description, o.description, true) && ImmunizationVaccinationProtocolComponent.compareDeep(this.authority, o.authority, true) && ImmunizationVaccinationProtocolComponent.compareDeep(this.series, o.series, true) && ImmunizationVaccinationProtocolComponent.compareDeep(this.seriesDoses, o.seriesDoses, true) && ImmunizationVaccinationProtocolComponent.compareDeep(this.targetDisease, o.targetDisease, true) && ImmunizationVaccinationProtocolComponent.compareDeep(this.doseStatus, o.doseStatus, true) && ImmunizationVaccinationProtocolComponent.compareDeep(this.doseStatusReason, o.doseStatusReason, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationVaccinationProtocolComponent)) {
                return false;
            }
            ImmunizationVaccinationProtocolComponent o = (ImmunizationVaccinationProtocolComponent)other;
            return ImmunizationVaccinationProtocolComponent.compareValues(this.doseSequence, o.doseSequence, true) && ImmunizationVaccinationProtocolComponent.compareValues(this.description, o.description, true) && ImmunizationVaccinationProtocolComponent.compareValues(this.series, o.series, true) && ImmunizationVaccinationProtocolComponent.compareValues(this.seriesDoses, o.seriesDoses, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.doseSequence != null && !this.doseSequence.isEmpty() || this.description != null && !this.description.isEmpty() || this.authority != null && !this.authority.isEmpty() || this.series != null && !this.series.isEmpty() || this.seriesDoses != null && !this.seriesDoses.isEmpty() || this.targetDisease != null && !this.targetDisease.isEmpty() || this.doseStatus != null && !this.doseStatus.isEmpty() || this.doseStatusReason != null && !this.doseStatusReason.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Immunization.vaccinationProtocol";
        }
    }

    @Block
    public static class ImmunizationReactionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="date", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When reaction started", formalDefinition="Date of reaction to the immunization.")
        protected DateTimeType date;
        @Child(name="detail", type={Observation.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information on reaction", formalDefinition="Details of the reaction.")
        protected Reference detail;
        protected Observation detailTarget;
        @Child(name="reported", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates self-reported reaction", formalDefinition="Self-reported indicator.")
        protected BooleanType reported;
        private static final long serialVersionUID = -1297668556L;

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationReactionComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ImmunizationReactionComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ImmunizationReactionComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getDetail() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationReactionComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new Reference();
                }
            }
            return this.detail;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public ImmunizationReactionComponent setDetail(Reference value) {
            this.detail = value;
            return this;
        }

        public Observation getDetailTarget() {
            if (this.detailTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationReactionComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailTarget = new Observation();
                }
            }
            return this.detailTarget;
        }

        public ImmunizationReactionComponent setDetailTarget(Observation value) {
            this.detailTarget = value;
            return this;
        }

        public BooleanType getReportedElement() {
            if (this.reported == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationReactionComponent.reported");
                }
                if (Configuration.doAutoCreate()) {
                    this.reported = new BooleanType();
                }
            }
            return this.reported;
        }

        public boolean hasReportedElement() {
            return this.reported != null && !this.reported.isEmpty();
        }

        public boolean hasReported() {
            return this.reported != null && !this.reported.isEmpty();
        }

        public ImmunizationReactionComponent setReportedElement(BooleanType value) {
            this.reported = value;
            return this;
        }

        public boolean getReported() {
            return this.reported == null || this.reported.isEmpty() ? false : (Boolean)this.reported.getValue();
        }

        public ImmunizationReactionComponent setReported(boolean value) {
            if (this.reported == null) {
                this.reported = new BooleanType();
            }
            this.reported.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Immunization.SP_DATE, "dateTime", "Date of reaction to the immunization.", 0, Integer.MAX_VALUE, this.date));
            childrenList.add(new Property("detail", "Reference(Observation)", "Details of the reaction.", 0, Integer.MAX_VALUE, this.detail));
            childrenList.add(new Property("reported", "boolean", "Self-reported indicator.", 0, Integer.MAX_VALUE, this.reported));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Immunization.SP_DATE)) {
                this.date = this.castToDateTime(value);
            } else if (name.equals("detail")) {
                this.detail = this.castToReference(value);
            } else if (name.equals("reported")) {
                this.reported = this.castToBoolean(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Immunization.SP_DATE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.date");
            }
            if (name.equals("detail")) {
                this.detail = new Reference();
                return this.detail;
            }
            if (name.equals("reported")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.reported");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationReactionComponent copy() {
            ImmunizationReactionComponent dst = new ImmunizationReactionComponent();
            this.copyValues(dst);
            dst.date = this.date == null ? null : this.date.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            dst.reported = this.reported == null ? null : this.reported.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationReactionComponent)) {
                return false;
            }
            ImmunizationReactionComponent o = (ImmunizationReactionComponent)other;
            return ImmunizationReactionComponent.compareDeep(this.date, o.date, true) && ImmunizationReactionComponent.compareDeep(this.detail, o.detail, true) && ImmunizationReactionComponent.compareDeep(this.reported, o.reported, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationReactionComponent)) {
                return false;
            }
            ImmunizationReactionComponent o = (ImmunizationReactionComponent)other;
            return ImmunizationReactionComponent.compareValues(this.date, o.date, true) && ImmunizationReactionComponent.compareValues(this.reported, o.reported, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.date != null && !this.date.isEmpty() || this.detail != null && !this.detail.isEmpty() || this.reported != null && !this.reported.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Immunization.reaction";
        }
    }

    @Block
    public static class ImmunizationExplanationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reason", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why immunization occurred", formalDefinition="Reasons why a vaccine was administered.")
        protected List<CodeableConcept> reason;
        @Child(name="reasonNotGiven", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why immunization did not occur", formalDefinition="Reason why a vaccine was not administered.")
        protected List<CodeableConcept> reasonNotGiven;
        private static final long serialVersionUID = -539821866L;

        public List<CodeableConcept> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            return this.reason;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableConcept item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return t;
        }

        public ImmunizationExplanationComponent addReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return this;
        }

        public List<CodeableConcept> getReasonNotGiven() {
            if (this.reasonNotGiven == null) {
                this.reasonNotGiven = new ArrayList<CodeableConcept>();
            }
            return this.reasonNotGiven;
        }

        public boolean hasReasonNotGiven() {
            if (this.reasonNotGiven == null) {
                return false;
            }
            for (CodeableConcept item : this.reasonNotGiven) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReasonNotGiven() {
            CodeableConcept t = new CodeableConcept();
            if (this.reasonNotGiven == null) {
                this.reasonNotGiven = new ArrayList<CodeableConcept>();
            }
            this.reasonNotGiven.add(t);
            return t;
        }

        public ImmunizationExplanationComponent addReasonNotGiven(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reasonNotGiven == null) {
                this.reasonNotGiven = new ArrayList<CodeableConcept>();
            }
            this.reasonNotGiven.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Immunization.SP_REASON, "CodeableConcept", "Reasons why a vaccine was administered.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("reasonNotGiven", "CodeableConcept", "Reason why a vaccine was not administered.", 0, Integer.MAX_VALUE, this.reasonNotGiven));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Immunization.SP_REASON)) {
                this.getReason().add(this.castToCodeableConcept(value));
            } else if (name.equals("reasonNotGiven")) {
                this.getReasonNotGiven().add(this.castToCodeableConcept(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Immunization.SP_REASON)) {
                return this.addReason();
            }
            if (name.equals("reasonNotGiven")) {
                return this.addReasonNotGiven();
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationExplanationComponent copy() {
            ImmunizationExplanationComponent dst = new ImmunizationExplanationComponent();
            this.copyValues(dst);
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.reason) {
                    dst.reason.add(i.copy());
                }
            }
            if (this.reasonNotGiven != null) {
                dst.reasonNotGiven = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.reasonNotGiven) {
                    dst.reasonNotGiven.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationExplanationComponent)) {
                return false;
            }
            ImmunizationExplanationComponent o = (ImmunizationExplanationComponent)other;
            return ImmunizationExplanationComponent.compareDeep(this.reason, o.reason, true) && ImmunizationExplanationComponent.compareDeep(this.reasonNotGiven, o.reasonNotGiven, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationExplanationComponent)) {
                return false;
            }
            ImmunizationExplanationComponent o = (ImmunizationExplanationComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Immunization.explanation";
        }
    }
}

