/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.MarkdownType;
import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.OidType;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.SampledData;
import org.hl7.fhir.dstu2.model.Signature;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.TimeType;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ElementDefinition")
public class ElementDefinition
extends Type
implements ICompositeType {
    @Child(name="path", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The path of the element (see the Detailed Descriptions)", formalDefinition="The path identifies the element and is expressed as a \".\"-separated list of ancestor elements, beginning with the name of the resource or extension.")
    protected StringType path;
    @Child(name="representation", type={CodeType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="How this element is represented in instances", formalDefinition="Codes that define how this element is represented in instances, when the deviation varies from the normal case.")
    protected List<Enumeration<PropertyRepresentation>> representation;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this particular element definition (reference target)", formalDefinition="The name of this element definition (to refer to it from other element definitions using ElementDefinition.nameReference). This is a unique name referring to a specific set of constraints applied to this element. One use of this is to provide a name to different slices of the same element.")
    protected StringType name;
    @Child(name="label", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for element to display with or prompt for element", formalDefinition="The text to display beside the element indicating its meaning or to use to prompt for the element in a user display or form.")
    protected StringType label;
    @Child(name="code", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Defining code", formalDefinition="A code that provides the meaning for the element according to a particular terminology.")
    protected List<Coding> code;
    @Child(name="slicing", type={}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="This element is sliced - slices follow", formalDefinition="Indicates that the element is sliced into a set of alternative definitions (i.e. in a structure definition, there are multiple different constraints on a single element in the base resource). Slicing can be used in any resource that has cardinality ..* on the base resource, or any resource with a choice of types. The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set).")
    protected ElementDefinitionSlicingComponent slicing;
    @Child(name="short", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Concise definition for xml presentation", formalDefinition="A concise description of what this element means (e.g. for use in autogenerated summaries).")
    protected StringType short_;
    @Child(name="definition", type={MarkdownType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Full formal definition as narrative text", formalDefinition="Provides a complete explanation of the meaning of the data element for human readability.  For the case of elements derived from existing elements (e.g. constraints), the definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource.")
    protected MarkdownType definition;
    @Child(name="comments", type={MarkdownType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Comments about the use of this element", formalDefinition="Explanatory notes and implementation guidance about the data element, including notes about how to use the data properly, exceptions to proper use, etc.")
    protected MarkdownType comments;
    @Child(name="requirements", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why is this needed?", formalDefinition="This element is for traceability of why the element was created and why the constraints exist as they do. This may be used to point to source materials or specifications that drove the structure of this element.")
    protected MarkdownType requirements;
    @Child(name="alias", type={StringType.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other names", formalDefinition="Identifies additional names by which this element might also be known.")
    protected List<StringType> alias;
    @Child(name="min", type={IntegerType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Minimum Cardinality", formalDefinition="The minimum number of times this element SHALL appear in the instance.")
    protected IntegerType min;
    @Child(name="max", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum Cardinality (a number or *)", formalDefinition="The maximum number of times this element is permitted to appear in the instance.")
    protected StringType max;
    @Child(name="base", type={}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Base definition information for tools", formalDefinition="Information about the base definition of the element, provided to make it unncessary for tools to trace the deviation of the element through the derived and related profiles. This information is only provided where the element definition represents a constraint on another element definition, and must be present if there is a base element definition.")
    protected ElementDefinitionBaseComponent base;
    @Child(name="type", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Data type and Profile for this element", formalDefinition="The data type or resource that the value of this element is permitted to be.")
    protected List<TypeRefComponent> type;
    @Child(name="nameReference", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="To another element constraint (by element.name)", formalDefinition="Identifies the name of a slice defined elsewhere in the profile whose constraints should be applied to the current element.")
    protected StringType nameReference;
    @Child(name="defaultValue", type={}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specified value it missing from instance", formalDefinition="The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').")
    protected Type defaultValue;
    @Child(name="meaningWhenMissing", type={MarkdownType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Implicit meaning when this element is missing", formalDefinition="The Implicit meaning that is to be understood when this element is missing (e.g. 'when this element is missing, the period is ongoing'.")
    protected MarkdownType meaningWhenMissing;
    @Child(name="fixed", type={}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Value must be exactly this", formalDefinition="Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.")
    protected Type fixed;
    @Child(name="pattern", type={}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Value must have at least these property values", formalDefinition="Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  The values of elements present in the pattern must match exactly (case-sensitive, accent-sensitive, etc.).")
    protected Type pattern;
    @Child(name="example", type={}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Example value: [as defined for type]", formalDefinition="A sample value for this element demonstrating the type of information that would typically be captured.")
    protected Type example;
    @Child(name="minValue", type={}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Minimum Allowed Value (for some types)", formalDefinition="The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.")
    protected Type minValue;
    @Child(name="maxValue", type={}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum Allowed Value (for some types)", formalDefinition="The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.")
    protected Type maxValue;
    @Child(name="maxLength", type={IntegerType.class}, order=23, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Max length for strings", formalDefinition="Indicates the maximum length in characters that is permitted to be present in conformant instances and which is expected to be supported by conformant consumers that support the element.")
    protected IntegerType maxLength;
    @Child(name="condition", type={IdType.class}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to invariant about presence", formalDefinition="A reference to an invariant that may make additional statements about the cardinality or value in the instance.")
    protected List<IdType> condition;
    @Child(name="constraint", type={}, order=25, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Condition that must evaluate to true", formalDefinition="Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance.")
    protected List<ElementDefinitionConstraintComponent> constraint;
    @Child(name="mustSupport", type={BooleanType.class}, order=26, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the element must supported", formalDefinition="If true, implementations that produce or consume resources SHALL provide \"support\" for the element in some meaningful way.  If false, the element may be ignored and not supported.")
    protected BooleanType mustSupport;
    @Child(name="isModifier", type={BooleanType.class}, order=27, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this modifies the meaning of other elements", formalDefinition="If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.")
    protected BooleanType isModifier;
    @Child(name="isSummary", type={BooleanType.class}, order=28, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Include when _summary = true?", formalDefinition="Whether the element should be included if a client requests a search with the parameter _summary=true.")
    protected BooleanType isSummary;
    @Child(name="binding", type={}, order=29, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ValueSet details if this is coded", formalDefinition="Binds to a value set if this element is coded (code, Coding, CodeableConcept).")
    protected ElementDefinitionBindingComponent binding;
    @Child(name="mapping", type={}, order=30, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Map element to another set of definitions", formalDefinition="Identifies a concept from an external specification that roughly corresponds to this element.")
    protected List<ElementDefinitionMappingComponent> mapping;
    private static final long serialVersionUID = -447087484L;

    public ElementDefinition() {
    }

    public ElementDefinition(StringType path) {
        this.path = path;
    }

    public StringType getPathElement() {
        if (this.path == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.path");
            }
            if (Configuration.doAutoCreate()) {
                this.path = new StringType();
            }
        }
        return this.path;
    }

    public boolean hasPathElement() {
        return this.path != null && !this.path.isEmpty();
    }

    public boolean hasPath() {
        return this.path != null && !this.path.isEmpty();
    }

    public ElementDefinition setPathElement(StringType value) {
        this.path = value;
        return this;
    }

    public String getPath() {
        return this.path == null ? null : (String)this.path.getValue();
    }

    public ElementDefinition setPath(String value) {
        if (this.path == null) {
            this.path = new StringType();
        }
        this.path.setValue(value);
        return this;
    }

    public List<Enumeration<PropertyRepresentation>> getRepresentation() {
        if (this.representation == null) {
            this.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
        }
        return this.representation;
    }

    public ElementDefinition setRepresentation(List<Enumeration<PropertyRepresentation>> representation) {
        this.representation = representation;
        return this;
    }

    public boolean hasRepresentation() {
        if (this.representation == null) {
            return false;
        }
        for (Enumeration<PropertyRepresentation> item : this.representation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<PropertyRepresentation> addRepresentationElement() {
        Enumeration<PropertyRepresentation> t = new Enumeration<PropertyRepresentation>(new PropertyRepresentationEnumFactory());
        if (this.representation == null) {
            this.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
        }
        this.representation.add(t);
        return t;
    }

    public ElementDefinition addRepresentation(PropertyRepresentation value) {
        Enumeration<PropertyRepresentation> t = new Enumeration<PropertyRepresentation>(new PropertyRepresentationEnumFactory());
        t.setValue((Object)value);
        if (this.representation == null) {
            this.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
        }
        this.representation.add(t);
        return this;
    }

    public boolean hasRepresentation(PropertyRepresentation value) {
        if (this.representation == null) {
            return false;
        }
        for (Enumeration<PropertyRepresentation> v : this.representation) {
            if (!v.equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ElementDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ElementDefinition setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getLabelElement() {
        if (this.label == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.label");
            }
            if (Configuration.doAutoCreate()) {
                this.label = new StringType();
            }
        }
        return this.label;
    }

    public boolean hasLabelElement() {
        return this.label != null && !this.label.isEmpty();
    }

    public boolean hasLabel() {
        return this.label != null && !this.label.isEmpty();
    }

    public ElementDefinition setLabelElement(StringType value) {
        this.label = value;
        return this;
    }

    public String getLabel() {
        return this.label == null ? null : (String)this.label.getValue();
    }

    public ElementDefinition setLabel(String value) {
        if (Utilities.noString(value)) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
        }
        return this;
    }

    public List<Coding> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        return this.code;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (Coding item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addCode() {
        Coding t = new Coding();
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return t;
    }

    public ElementDefinition addCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return this;
    }

    public ElementDefinitionSlicingComponent getSlicing() {
        if (this.slicing == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.slicing");
            }
            if (Configuration.doAutoCreate()) {
                this.slicing = new ElementDefinitionSlicingComponent();
            }
        }
        return this.slicing;
    }

    public boolean hasSlicing() {
        return this.slicing != null && !this.slicing.isEmpty();
    }

    public ElementDefinition setSlicing(ElementDefinitionSlicingComponent value) {
        this.slicing = value;
        return this;
    }

    public StringType getShortElement() {
        if (this.short_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.short_");
            }
            if (Configuration.doAutoCreate()) {
                this.short_ = new StringType();
            }
        }
        return this.short_;
    }

    public boolean hasShortElement() {
        return this.short_ != null && !this.short_.isEmpty();
    }

    public boolean hasShort() {
        return this.short_ != null && !this.short_.isEmpty();
    }

    public ElementDefinition setShortElement(StringType value) {
        this.short_ = value;
        return this;
    }

    public String getShort() {
        return this.short_ == null ? null : (String)this.short_.getValue();
    }

    public ElementDefinition setShort(String value) {
        if (Utilities.noString(value)) {
            this.short_ = null;
        } else {
            if (this.short_ == null) {
                this.short_ = new StringType();
            }
            this.short_.setValue(value);
        }
        return this;
    }

    public MarkdownType getDefinitionElement() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new MarkdownType();
            }
        }
        return this.definition;
    }

    public boolean hasDefinitionElement() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public ElementDefinition setDefinitionElement(MarkdownType value) {
        this.definition = value;
        return this;
    }

    public String getDefinition() {
        return this.definition == null ? null : (String)this.definition.getValue();
    }

    public ElementDefinition setDefinition(String value) {
        if (value == null) {
            this.definition = null;
        } else {
            if (this.definition == null) {
                this.definition = new MarkdownType();
            }
            this.definition.setValue(value);
        }
        return this;
    }

    public MarkdownType getCommentsElement() {
        if (this.comments == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.comments");
            }
            if (Configuration.doAutoCreate()) {
                this.comments = new MarkdownType();
            }
        }
        return this.comments;
    }

    public boolean hasCommentsElement() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public ElementDefinition setCommentsElement(MarkdownType value) {
        this.comments = value;
        return this;
    }

    public String getComments() {
        return this.comments == null ? null : (String)this.comments.getValue();
    }

    public ElementDefinition setComments(String value) {
        if (value == null) {
            this.comments = null;
        } else {
            if (this.comments == null) {
                this.comments = new MarkdownType();
            }
            this.comments.setValue(value);
        }
        return this;
    }

    public MarkdownType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new MarkdownType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public ElementDefinition setRequirementsElement(MarkdownType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public ElementDefinition setRequirements(String value) {
        if (value == null) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new MarkdownType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public ElementDefinition addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public IntegerType getMinElement() {
        if (this.min == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.min");
            }
            if (Configuration.doAutoCreate()) {
                this.min = new IntegerType();
            }
        }
        return this.min;
    }

    public boolean hasMinElement() {
        return this.min != null && !this.min.isEmpty();
    }

    public boolean hasMin() {
        return this.min != null && !this.min.isEmpty();
    }

    public ElementDefinition setMinElement(IntegerType value) {
        this.min = value;
        return this;
    }

    public int getMin() {
        return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
    }

    public ElementDefinition setMin(int value) {
        if (this.min == null) {
            this.min = new IntegerType();
        }
        this.min.setValue((Object)value);
        return this;
    }

    public StringType getMaxElement() {
        if (this.max == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.max");
            }
            if (Configuration.doAutoCreate()) {
                this.max = new StringType();
            }
        }
        return this.max;
    }

    public boolean hasMaxElement() {
        return this.max != null && !this.max.isEmpty();
    }

    public boolean hasMax() {
        return this.max != null && !this.max.isEmpty();
    }

    public ElementDefinition setMaxElement(StringType value) {
        this.max = value;
        return this;
    }

    public String getMax() {
        return this.max == null ? null : (String)this.max.getValue();
    }

    public ElementDefinition setMax(String value) {
        if (Utilities.noString(value)) {
            this.max = null;
        } else {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
        }
        return this;
    }

    public ElementDefinitionBaseComponent getBase() {
        if (this.base == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.base");
            }
            if (Configuration.doAutoCreate()) {
                this.base = new ElementDefinitionBaseComponent();
            }
        }
        return this.base;
    }

    public boolean hasBase() {
        return this.base != null && !this.base.isEmpty();
    }

    public ElementDefinition setBase(ElementDefinitionBaseComponent value) {
        this.base = value;
        return this;
    }

    public List<TypeRefComponent> getType() {
        if (this.type == null) {
            this.type = new ArrayList<TypeRefComponent>();
        }
        return this.type;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (TypeRefComponent item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TypeRefComponent addType() {
        TypeRefComponent t = new TypeRefComponent();
        if (this.type == null) {
            this.type = new ArrayList<TypeRefComponent>();
        }
        this.type.add(t);
        return t;
    }

    public ElementDefinition addType(TypeRefComponent t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<TypeRefComponent>();
        }
        this.type.add(t);
        return this;
    }

    public StringType getNameReferenceElement() {
        if (this.nameReference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.nameReference");
            }
            if (Configuration.doAutoCreate()) {
                this.nameReference = new StringType();
            }
        }
        return this.nameReference;
    }

    public boolean hasNameReferenceElement() {
        return this.nameReference != null && !this.nameReference.isEmpty();
    }

    public boolean hasNameReference() {
        return this.nameReference != null && !this.nameReference.isEmpty();
    }

    public ElementDefinition setNameReferenceElement(StringType value) {
        this.nameReference = value;
        return this;
    }

    public String getNameReference() {
        return this.nameReference == null ? null : (String)this.nameReference.getValue();
    }

    public ElementDefinition setNameReference(String value) {
        if (Utilities.noString(value)) {
            this.nameReference = null;
        } else {
            if (this.nameReference == null) {
                this.nameReference = new StringType();
            }
            this.nameReference.setValue(value);
        }
        return this;
    }

    public Type getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null && !this.defaultValue.isEmpty();
    }

    public ElementDefinition setDefaultValue(Type value) {
        this.defaultValue = value;
        return this;
    }

    public MarkdownType getMeaningWhenMissingElement() {
        if (this.meaningWhenMissing == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.meaningWhenMissing");
            }
            if (Configuration.doAutoCreate()) {
                this.meaningWhenMissing = new MarkdownType();
            }
        }
        return this.meaningWhenMissing;
    }

    public boolean hasMeaningWhenMissingElement() {
        return this.meaningWhenMissing != null && !this.meaningWhenMissing.isEmpty();
    }

    public boolean hasMeaningWhenMissing() {
        return this.meaningWhenMissing != null && !this.meaningWhenMissing.isEmpty();
    }

    public ElementDefinition setMeaningWhenMissingElement(MarkdownType value) {
        this.meaningWhenMissing = value;
        return this;
    }

    public String getMeaningWhenMissing() {
        return this.meaningWhenMissing == null ? null : (String)this.meaningWhenMissing.getValue();
    }

    public ElementDefinition setMeaningWhenMissing(String value) {
        if (value == null) {
            this.meaningWhenMissing = null;
        } else {
            if (this.meaningWhenMissing == null) {
                this.meaningWhenMissing = new MarkdownType();
            }
            this.meaningWhenMissing.setValue(value);
        }
        return this;
    }

    public Type getFixed() {
        return this.fixed;
    }

    public boolean hasFixed() {
        return this.fixed != null && !this.fixed.isEmpty();
    }

    public ElementDefinition setFixed(Type value) {
        this.fixed = value;
        return this;
    }

    public Type getPattern() {
        return this.pattern;
    }

    public boolean hasPattern() {
        return this.pattern != null && !this.pattern.isEmpty();
    }

    public ElementDefinition setPattern(Type value) {
        this.pattern = value;
        return this;
    }

    public Type getExample() {
        return this.example;
    }

    public boolean hasExample() {
        return this.example != null && !this.example.isEmpty();
    }

    public ElementDefinition setExample(Type value) {
        this.example = value;
        return this;
    }

    public Type getMinValue() {
        return this.minValue;
    }

    public boolean hasMinValue() {
        return this.minValue != null && !this.minValue.isEmpty();
    }

    public ElementDefinition setMinValue(Type value) {
        this.minValue = value;
        return this;
    }

    public Type getMaxValue() {
        return this.maxValue;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null && !this.maxValue.isEmpty();
    }

    public ElementDefinition setMaxValue(Type value) {
        this.maxValue = value;
        return this;
    }

    public IntegerType getMaxLengthElement() {
        if (this.maxLength == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.maxLength");
            }
            if (Configuration.doAutoCreate()) {
                this.maxLength = new IntegerType();
            }
        }
        return this.maxLength;
    }

    public boolean hasMaxLengthElement() {
        return this.maxLength != null && !this.maxLength.isEmpty();
    }

    public boolean hasMaxLength() {
        return this.maxLength != null && !this.maxLength.isEmpty();
    }

    public ElementDefinition setMaxLengthElement(IntegerType value) {
        this.maxLength = value;
        return this;
    }

    public int getMaxLength() {
        return this.maxLength == null || this.maxLength.isEmpty() ? 0 : (Integer)this.maxLength.getValue();
    }

    public ElementDefinition setMaxLength(int value) {
        if (this.maxLength == null) {
            this.maxLength = new IntegerType();
        }
        this.maxLength.setValue((Object)value);
        return this;
    }

    public List<IdType> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<IdType>();
        }
        return this.condition;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (IdType item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IdType addConditionElement() {
        IdType t = new IdType();
        if (this.condition == null) {
            this.condition = new ArrayList<IdType>();
        }
        this.condition.add(t);
        return t;
    }

    public ElementDefinition addCondition(String value) {
        IdType t = new IdType();
        t.setValue(value);
        if (this.condition == null) {
            this.condition = new ArrayList<IdType>();
        }
        this.condition.add(t);
        return this;
    }

    public boolean hasCondition(String value) {
        if (this.condition == null) {
            return false;
        }
        for (IdType v : this.condition) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<ElementDefinitionConstraintComponent> getConstraint() {
        if (this.constraint == null) {
            this.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
        }
        return this.constraint;
    }

    public boolean hasConstraint() {
        if (this.constraint == null) {
            return false;
        }
        for (ElementDefinitionConstraintComponent item : this.constraint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinitionConstraintComponent addConstraint() {
        ElementDefinitionConstraintComponent t = new ElementDefinitionConstraintComponent();
        if (this.constraint == null) {
            this.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
        }
        this.constraint.add(t);
        return t;
    }

    public ElementDefinition addConstraint(ElementDefinitionConstraintComponent t) {
        if (t == null) {
            return this;
        }
        if (this.constraint == null) {
            this.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
        }
        this.constraint.add(t);
        return this;
    }

    public BooleanType getMustSupportElement() {
        if (this.mustSupport == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.mustSupport");
            }
            if (Configuration.doAutoCreate()) {
                this.mustSupport = new BooleanType();
            }
        }
        return this.mustSupport;
    }

    public boolean hasMustSupportElement() {
        return this.mustSupport != null && !this.mustSupport.isEmpty();
    }

    public boolean hasMustSupport() {
        return this.mustSupport != null && !this.mustSupport.isEmpty();
    }

    public ElementDefinition setMustSupportElement(BooleanType value) {
        this.mustSupport = value;
        return this;
    }

    public boolean getMustSupport() {
        return this.mustSupport == null || this.mustSupport.isEmpty() ? false : (Boolean)this.mustSupport.getValue();
    }

    public ElementDefinition setMustSupport(boolean value) {
        if (this.mustSupport == null) {
            this.mustSupport = new BooleanType();
        }
        this.mustSupport.setValue((Object)value);
        return this;
    }

    public BooleanType getIsModifierElement() {
        if (this.isModifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.isModifier");
            }
            if (Configuration.doAutoCreate()) {
                this.isModifier = new BooleanType();
            }
        }
        return this.isModifier;
    }

    public boolean hasIsModifierElement() {
        return this.isModifier != null && !this.isModifier.isEmpty();
    }

    public boolean hasIsModifier() {
        return this.isModifier != null && !this.isModifier.isEmpty();
    }

    public ElementDefinition setIsModifierElement(BooleanType value) {
        this.isModifier = value;
        return this;
    }

    public boolean getIsModifier() {
        return this.isModifier == null || this.isModifier.isEmpty() ? false : (Boolean)this.isModifier.getValue();
    }

    public ElementDefinition setIsModifier(boolean value) {
        if (this.isModifier == null) {
            this.isModifier = new BooleanType();
        }
        this.isModifier.setValue((Object)value);
        return this;
    }

    public BooleanType getIsSummaryElement() {
        if (this.isSummary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.isSummary");
            }
            if (Configuration.doAutoCreate()) {
                this.isSummary = new BooleanType();
            }
        }
        return this.isSummary;
    }

    public boolean hasIsSummaryElement() {
        return this.isSummary != null && !this.isSummary.isEmpty();
    }

    public boolean hasIsSummary() {
        return this.isSummary != null && !this.isSummary.isEmpty();
    }

    public ElementDefinition setIsSummaryElement(BooleanType value) {
        this.isSummary = value;
        return this;
    }

    public boolean getIsSummary() {
        return this.isSummary == null || this.isSummary.isEmpty() ? false : (Boolean)this.isSummary.getValue();
    }

    public ElementDefinition setIsSummary(boolean value) {
        if (this.isSummary == null) {
            this.isSummary = new BooleanType();
        }
        this.isSummary.setValue((Object)value);
        return this;
    }

    public ElementDefinitionBindingComponent getBinding() {
        if (this.binding == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ElementDefinition.binding");
            }
            if (Configuration.doAutoCreate()) {
                this.binding = new ElementDefinitionBindingComponent();
            }
        }
        return this.binding;
    }

    public boolean hasBinding() {
        return this.binding != null && !this.binding.isEmpty();
    }

    public ElementDefinition setBinding(ElementDefinitionBindingComponent value) {
        this.binding = value;
        return this;
    }

    public List<ElementDefinitionMappingComponent> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<ElementDefinitionMappingComponent>();
        }
        return this.mapping;
    }

    public boolean hasMapping() {
        if (this.mapping == null) {
            return false;
        }
        for (ElementDefinitionMappingComponent item : this.mapping) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinitionMappingComponent addMapping() {
        ElementDefinitionMappingComponent t = new ElementDefinitionMappingComponent();
        if (this.mapping == null) {
            this.mapping = new ArrayList<ElementDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return t;
    }

    public ElementDefinition addMapping(ElementDefinitionMappingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mapping == null) {
            this.mapping = new ArrayList<ElementDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("path", "string", "The path identifies the element and is expressed as a \".\"-separated list of ancestor elements, beginning with the name of the resource or extension.", 0, Integer.MAX_VALUE, this.path));
        childrenList.add(new Property("representation", "code", "Codes that define how this element is represented in instances, when the deviation varies from the normal case.", 0, Integer.MAX_VALUE, this.representation));
        childrenList.add(new Property("name", "string", "The name of this element definition (to refer to it from other element definitions using ElementDefinition.nameReference). This is a unique name referring to a specific set of constraints applied to this element. One use of this is to provide a name to different slices of the same element.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("label", "string", "The text to display beside the element indicating its meaning or to use to prompt for the element in a user display or form.", 0, Integer.MAX_VALUE, this.label));
        childrenList.add(new Property("code", "Coding", "A code that provides the meaning for the element according to a particular terminology.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("slicing", "", "Indicates that the element is sliced into a set of alternative definitions (i.e. in a structure definition, there are multiple different constraints on a single element in the base resource). Slicing can be used in any resource that has cardinality ..* on the base resource, or any resource with a choice of types. The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set).", 0, Integer.MAX_VALUE, this.slicing));
        childrenList.add(new Property("short", "string", "A concise description of what this element means (e.g. for use in autogenerated summaries).", 0, Integer.MAX_VALUE, this.short_));
        childrenList.add(new Property("definition", "markdown", "Provides a complete explanation of the meaning of the data element for human readability.  For the case of elements derived from existing elements (e.g. constraints), the definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource.", 0, Integer.MAX_VALUE, this.definition));
        childrenList.add(new Property("comments", "markdown", "Explanatory notes and implementation guidance about the data element, including notes about how to use the data properly, exceptions to proper use, etc.", 0, Integer.MAX_VALUE, this.comments));
        childrenList.add(new Property("requirements", "markdown", "This element is for traceability of why the element was created and why the constraints exist as they do. This may be used to point to source materials or specifications that drove the structure of this element.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("alias", "string", "Identifies additional names by which this element might also be known.", 0, Integer.MAX_VALUE, this.alias));
        childrenList.add(new Property("min", "integer", "The minimum number of times this element SHALL appear in the instance.", 0, Integer.MAX_VALUE, this.min));
        childrenList.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the instance.", 0, Integer.MAX_VALUE, this.max));
        childrenList.add(new Property("base", "", "Information about the base definition of the element, provided to make it unncessary for tools to trace the deviation of the element through the derived and related profiles. This information is only provided where the element definition represents a constraint on another element definition, and must be present if there is a base element definition.", 0, Integer.MAX_VALUE, this.base));
        childrenList.add(new Property("type", "", "The data type or resource that the value of this element is permitted to be.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("nameReference", "string", "Identifies the name of a slice defined elsewhere in the profile whose constraints should be applied to the current element.", 0, Integer.MAX_VALUE, this.nameReference));
        childrenList.add(new Property("defaultValue[x]", "*", "The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').", 0, Integer.MAX_VALUE, this.defaultValue));
        childrenList.add(new Property("meaningWhenMissing", "markdown", "The Implicit meaning that is to be understood when this element is missing (e.g. 'when this element is missing, the period is ongoing'.", 0, Integer.MAX_VALUE, this.meaningWhenMissing));
        childrenList.add(new Property("fixed[x]", "*", "Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.", 0, Integer.MAX_VALUE, this.fixed));
        childrenList.add(new Property("pattern[x]", "*", "Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  The values of elements present in the pattern must match exactly (case-sensitive, accent-sensitive, etc.).", 0, Integer.MAX_VALUE, this.pattern));
        childrenList.add(new Property("example[x]", "*", "A sample value for this element demonstrating the type of information that would typically be captured.", 0, Integer.MAX_VALUE, this.example));
        childrenList.add(new Property("minValue[x]", "*", "The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, Integer.MAX_VALUE, this.minValue));
        childrenList.add(new Property("maxValue[x]", "*", "The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.", 0, Integer.MAX_VALUE, this.maxValue));
        childrenList.add(new Property("maxLength", "integer", "Indicates the maximum length in characters that is permitted to be present in conformant instances and which is expected to be supported by conformant consumers that support the element.", 0, Integer.MAX_VALUE, this.maxLength));
        childrenList.add(new Property("condition", "id", "A reference to an invariant that may make additional statements about the cardinality or value in the instance.", 0, Integer.MAX_VALUE, this.condition));
        childrenList.add(new Property("constraint", "", "Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance.", 0, Integer.MAX_VALUE, this.constraint));
        childrenList.add(new Property("mustSupport", "boolean", "If true, implementations that produce or consume resources SHALL provide \"support\" for the element in some meaningful way.  If false, the element may be ignored and not supported.", 0, Integer.MAX_VALUE, this.mustSupport));
        childrenList.add(new Property("isModifier", "boolean", "If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.", 0, Integer.MAX_VALUE, this.isModifier));
        childrenList.add(new Property("isSummary", "boolean", "Whether the element should be included if a client requests a search with the parameter _summary=true.", 0, Integer.MAX_VALUE, this.isSummary));
        childrenList.add(new Property("binding", "", "Binds to a value set if this element is coded (code, Coding, CodeableConcept).", 0, Integer.MAX_VALUE, this.binding));
        childrenList.add(new Property("mapping", "", "Identifies a concept from an external specification that roughly corresponds to this element.", 0, Integer.MAX_VALUE, this.mapping));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("path")) {
            this.path = this.castToString(value);
        } else if (name.equals("representation")) {
            this.getRepresentation().add(new PropertyRepresentationEnumFactory().fromType(value));
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("label")) {
            this.label = this.castToString(value);
        } else if (name.equals("code")) {
            this.getCode().add(this.castToCoding(value));
        } else if (name.equals("slicing")) {
            this.slicing = (ElementDefinitionSlicingComponent)value;
        } else if (name.equals("short")) {
            this.short_ = this.castToString(value);
        } else if (name.equals("definition")) {
            this.definition = this.castToMarkdown(value);
        } else if (name.equals("comments")) {
            this.comments = this.castToMarkdown(value);
        } else if (name.equals("requirements")) {
            this.requirements = this.castToMarkdown(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(this.castToString(value));
        } else if (name.equals("min")) {
            this.min = this.castToInteger(value);
        } else if (name.equals("max")) {
            this.max = this.castToString(value);
        } else if (name.equals("base")) {
            this.base = (ElementDefinitionBaseComponent)value;
        } else if (name.equals("type")) {
            this.getType().add((TypeRefComponent)value);
        } else if (name.equals("nameReference")) {
            this.nameReference = this.castToString(value);
        } else if (name.equals("defaultValue[x]")) {
            this.defaultValue = (Type)value;
        } else if (name.equals("meaningWhenMissing")) {
            this.meaningWhenMissing = this.castToMarkdown(value);
        } else if (name.equals("fixed[x]")) {
            this.fixed = (Type)value;
        } else if (name.equals("pattern[x]")) {
            this.pattern = (Type)value;
        } else if (name.equals("example[x]")) {
            this.example = (Type)value;
        } else if (name.equals("minValue[x]")) {
            this.minValue = (Type)value;
        } else if (name.equals("maxValue[x]")) {
            this.maxValue = (Type)value;
        } else if (name.equals("maxLength")) {
            this.maxLength = this.castToInteger(value);
        } else if (name.equals("condition")) {
            this.getCondition().add(this.castToId(value));
        } else if (name.equals("constraint")) {
            this.getConstraint().add((ElementDefinitionConstraintComponent)value);
        } else if (name.equals("mustSupport")) {
            this.mustSupport = this.castToBoolean(value);
        } else if (name.equals("isModifier")) {
            this.isModifier = this.castToBoolean(value);
        } else if (name.equals("isSummary")) {
            this.isSummary = this.castToBoolean(value);
        } else if (name.equals("binding")) {
            this.binding = (ElementDefinitionBindingComponent)value;
        } else if (name.equals("mapping")) {
            this.getMapping().add((ElementDefinitionMappingComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("path")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.path");
        }
        if (name.equals("representation")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.representation");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.name");
        }
        if (name.equals("label")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.label");
        }
        if (name.equals("code")) {
            return this.addCode();
        }
        if (name.equals("slicing")) {
            this.slicing = new ElementDefinitionSlicingComponent();
            return this.slicing;
        }
        if (name.equals("short")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.short");
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.definition");
        }
        if (name.equals("comments")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.comments");
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.requirements");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.alias");
        }
        if (name.equals("min")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.min");
        }
        if (name.equals("max")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.max");
        }
        if (name.equals("base")) {
            this.base = new ElementDefinitionBaseComponent();
            return this.base;
        }
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("nameReference")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.nameReference");
        }
        if (name.equals("defaultValueBoolean")) {
            this.defaultValue = new BooleanType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueInteger")) {
            this.defaultValue = new IntegerType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDecimal")) {
            this.defaultValue = new DecimalType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueBase64Binary")) {
            this.defaultValue = new Base64BinaryType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueInstant")) {
            this.defaultValue = new InstantType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueString")) {
            this.defaultValue = new StringType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueUri")) {
            this.defaultValue = new UriType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDate")) {
            this.defaultValue = new DateType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueDateTime")) {
            this.defaultValue = new DateTimeType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueTime")) {
            this.defaultValue = new TimeType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCode")) {
            this.defaultValue = new CodeType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueOid")) {
            this.defaultValue = new OidType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueId")) {
            this.defaultValue = new IdType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueUnsignedInt")) {
            this.defaultValue = new UnsignedIntType();
            return this.defaultValue;
        }
        if (name.equals("defaultValuePositiveInt")) {
            this.defaultValue = new PositiveIntType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueMarkdown")) {
            this.defaultValue = new MarkdownType();
            return this.defaultValue;
        }
        if (name.equals("defaultValueAnnotation")) {
            this.defaultValue = new Annotation();
            return this.defaultValue;
        }
        if (name.equals("defaultValueAttachment")) {
            this.defaultValue = new Attachment();
            return this.defaultValue;
        }
        if (name.equals("defaultValueIdentifier")) {
            this.defaultValue = new Identifier();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCodeableConcept")) {
            this.defaultValue = new CodeableConcept();
            return this.defaultValue;
        }
        if (name.equals("defaultValueCoding")) {
            this.defaultValue = new Coding();
            return this.defaultValue;
        }
        if (name.equals("defaultValueQuantity")) {
            this.defaultValue = new Quantity();
            return this.defaultValue;
        }
        if (name.equals("defaultValueRange")) {
            this.defaultValue = new Range();
            return this.defaultValue;
        }
        if (name.equals("defaultValuePeriod")) {
            this.defaultValue = new Period();
            return this.defaultValue;
        }
        if (name.equals("defaultValueRatio")) {
            this.defaultValue = new Ratio();
            return this.defaultValue;
        }
        if (name.equals("defaultValueSampledData")) {
            this.defaultValue = new SampledData();
            return this.defaultValue;
        }
        if (name.equals("defaultValueSignature")) {
            this.defaultValue = new Signature();
            return this.defaultValue;
        }
        if (name.equals("defaultValueHumanName")) {
            this.defaultValue = new HumanName();
            return this.defaultValue;
        }
        if (name.equals("defaultValueAddress")) {
            this.defaultValue = new Address();
            return this.defaultValue;
        }
        if (name.equals("defaultValueContactPoint")) {
            this.defaultValue = new ContactPoint();
            return this.defaultValue;
        }
        if (name.equals("defaultValueTiming")) {
            this.defaultValue = new Timing();
            return this.defaultValue;
        }
        if (name.equals("defaultValueReference")) {
            this.defaultValue = new Reference();
            return this.defaultValue;
        }
        if (name.equals("defaultValueMeta")) {
            this.defaultValue = new Meta();
            return this.defaultValue;
        }
        if (name.equals("meaningWhenMissing")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.meaningWhenMissing");
        }
        if (name.equals("fixedBoolean")) {
            this.fixed = new BooleanType();
            return this.fixed;
        }
        if (name.equals("fixedInteger")) {
            this.fixed = new IntegerType();
            return this.fixed;
        }
        if (name.equals("fixedDecimal")) {
            this.fixed = new DecimalType();
            return this.fixed;
        }
        if (name.equals("fixedBase64Binary")) {
            this.fixed = new Base64BinaryType();
            return this.fixed;
        }
        if (name.equals("fixedInstant")) {
            this.fixed = new InstantType();
            return this.fixed;
        }
        if (name.equals("fixedString")) {
            this.fixed = new StringType();
            return this.fixed;
        }
        if (name.equals("fixedUri")) {
            this.fixed = new UriType();
            return this.fixed;
        }
        if (name.equals("fixedDate")) {
            this.fixed = new DateType();
            return this.fixed;
        }
        if (name.equals("fixedDateTime")) {
            this.fixed = new DateTimeType();
            return this.fixed;
        }
        if (name.equals("fixedTime")) {
            this.fixed = new TimeType();
            return this.fixed;
        }
        if (name.equals("fixedCode")) {
            this.fixed = new CodeType();
            return this.fixed;
        }
        if (name.equals("fixedOid")) {
            this.fixed = new OidType();
            return this.fixed;
        }
        if (name.equals("fixedId")) {
            this.fixed = new IdType();
            return this.fixed;
        }
        if (name.equals("fixedUnsignedInt")) {
            this.fixed = new UnsignedIntType();
            return this.fixed;
        }
        if (name.equals("fixedPositiveInt")) {
            this.fixed = new PositiveIntType();
            return this.fixed;
        }
        if (name.equals("fixedMarkdown")) {
            this.fixed = new MarkdownType();
            return this.fixed;
        }
        if (name.equals("fixedAnnotation")) {
            this.fixed = new Annotation();
            return this.fixed;
        }
        if (name.equals("fixedAttachment")) {
            this.fixed = new Attachment();
            return this.fixed;
        }
        if (name.equals("fixedIdentifier")) {
            this.fixed = new Identifier();
            return this.fixed;
        }
        if (name.equals("fixedCodeableConcept")) {
            this.fixed = new CodeableConcept();
            return this.fixed;
        }
        if (name.equals("fixedCoding")) {
            this.fixed = new Coding();
            return this.fixed;
        }
        if (name.equals("fixedQuantity")) {
            this.fixed = new Quantity();
            return this.fixed;
        }
        if (name.equals("fixedRange")) {
            this.fixed = new Range();
            return this.fixed;
        }
        if (name.equals("fixedPeriod")) {
            this.fixed = new Period();
            return this.fixed;
        }
        if (name.equals("fixedRatio")) {
            this.fixed = new Ratio();
            return this.fixed;
        }
        if (name.equals("fixedSampledData")) {
            this.fixed = new SampledData();
            return this.fixed;
        }
        if (name.equals("fixedSignature")) {
            this.fixed = new Signature();
            return this.fixed;
        }
        if (name.equals("fixedHumanName")) {
            this.fixed = new HumanName();
            return this.fixed;
        }
        if (name.equals("fixedAddress")) {
            this.fixed = new Address();
            return this.fixed;
        }
        if (name.equals("fixedContactPoint")) {
            this.fixed = new ContactPoint();
            return this.fixed;
        }
        if (name.equals("fixedTiming")) {
            this.fixed = new Timing();
            return this.fixed;
        }
        if (name.equals("fixedReference")) {
            this.fixed = new Reference();
            return this.fixed;
        }
        if (name.equals("fixedMeta")) {
            this.fixed = new Meta();
            return this.fixed;
        }
        if (name.equals("patternBoolean")) {
            this.pattern = new BooleanType();
            return this.pattern;
        }
        if (name.equals("patternInteger")) {
            this.pattern = new IntegerType();
            return this.pattern;
        }
        if (name.equals("patternDecimal")) {
            this.pattern = new DecimalType();
            return this.pattern;
        }
        if (name.equals("patternBase64Binary")) {
            this.pattern = new Base64BinaryType();
            return this.pattern;
        }
        if (name.equals("patternInstant")) {
            this.pattern = new InstantType();
            return this.pattern;
        }
        if (name.equals("patternString")) {
            this.pattern = new StringType();
            return this.pattern;
        }
        if (name.equals("patternUri")) {
            this.pattern = new UriType();
            return this.pattern;
        }
        if (name.equals("patternDate")) {
            this.pattern = new DateType();
            return this.pattern;
        }
        if (name.equals("patternDateTime")) {
            this.pattern = new DateTimeType();
            return this.pattern;
        }
        if (name.equals("patternTime")) {
            this.pattern = new TimeType();
            return this.pattern;
        }
        if (name.equals("patternCode")) {
            this.pattern = new CodeType();
            return this.pattern;
        }
        if (name.equals("patternOid")) {
            this.pattern = new OidType();
            return this.pattern;
        }
        if (name.equals("patternId")) {
            this.pattern = new IdType();
            return this.pattern;
        }
        if (name.equals("patternUnsignedInt")) {
            this.pattern = new UnsignedIntType();
            return this.pattern;
        }
        if (name.equals("patternPositiveInt")) {
            this.pattern = new PositiveIntType();
            return this.pattern;
        }
        if (name.equals("patternMarkdown")) {
            this.pattern = new MarkdownType();
            return this.pattern;
        }
        if (name.equals("patternAnnotation")) {
            this.pattern = new Annotation();
            return this.pattern;
        }
        if (name.equals("patternAttachment")) {
            this.pattern = new Attachment();
            return this.pattern;
        }
        if (name.equals("patternIdentifier")) {
            this.pattern = new Identifier();
            return this.pattern;
        }
        if (name.equals("patternCodeableConcept")) {
            this.pattern = new CodeableConcept();
            return this.pattern;
        }
        if (name.equals("patternCoding")) {
            this.pattern = new Coding();
            return this.pattern;
        }
        if (name.equals("patternQuantity")) {
            this.pattern = new Quantity();
            return this.pattern;
        }
        if (name.equals("patternRange")) {
            this.pattern = new Range();
            return this.pattern;
        }
        if (name.equals("patternPeriod")) {
            this.pattern = new Period();
            return this.pattern;
        }
        if (name.equals("patternRatio")) {
            this.pattern = new Ratio();
            return this.pattern;
        }
        if (name.equals("patternSampledData")) {
            this.pattern = new SampledData();
            return this.pattern;
        }
        if (name.equals("patternSignature")) {
            this.pattern = new Signature();
            return this.pattern;
        }
        if (name.equals("patternHumanName")) {
            this.pattern = new HumanName();
            return this.pattern;
        }
        if (name.equals("patternAddress")) {
            this.pattern = new Address();
            return this.pattern;
        }
        if (name.equals("patternContactPoint")) {
            this.pattern = new ContactPoint();
            return this.pattern;
        }
        if (name.equals("patternTiming")) {
            this.pattern = new Timing();
            return this.pattern;
        }
        if (name.equals("patternReference")) {
            this.pattern = new Reference();
            return this.pattern;
        }
        if (name.equals("patternMeta")) {
            this.pattern = new Meta();
            return this.pattern;
        }
        if (name.equals("exampleBoolean")) {
            this.example = new BooleanType();
            return this.example;
        }
        if (name.equals("exampleInteger")) {
            this.example = new IntegerType();
            return this.example;
        }
        if (name.equals("exampleDecimal")) {
            this.example = new DecimalType();
            return this.example;
        }
        if (name.equals("exampleBase64Binary")) {
            this.example = new Base64BinaryType();
            return this.example;
        }
        if (name.equals("exampleInstant")) {
            this.example = new InstantType();
            return this.example;
        }
        if (name.equals("exampleString")) {
            this.example = new StringType();
            return this.example;
        }
        if (name.equals("exampleUri")) {
            this.example = new UriType();
            return this.example;
        }
        if (name.equals("exampleDate")) {
            this.example = new DateType();
            return this.example;
        }
        if (name.equals("exampleDateTime")) {
            this.example = new DateTimeType();
            return this.example;
        }
        if (name.equals("exampleTime")) {
            this.example = new TimeType();
            return this.example;
        }
        if (name.equals("exampleCode")) {
            this.example = new CodeType();
            return this.example;
        }
        if (name.equals("exampleOid")) {
            this.example = new OidType();
            return this.example;
        }
        if (name.equals("exampleId")) {
            this.example = new IdType();
            return this.example;
        }
        if (name.equals("exampleUnsignedInt")) {
            this.example = new UnsignedIntType();
            return this.example;
        }
        if (name.equals("examplePositiveInt")) {
            this.example = new PositiveIntType();
            return this.example;
        }
        if (name.equals("exampleMarkdown")) {
            this.example = new MarkdownType();
            return this.example;
        }
        if (name.equals("exampleAnnotation")) {
            this.example = new Annotation();
            return this.example;
        }
        if (name.equals("exampleAttachment")) {
            this.example = new Attachment();
            return this.example;
        }
        if (name.equals("exampleIdentifier")) {
            this.example = new Identifier();
            return this.example;
        }
        if (name.equals("exampleCodeableConcept")) {
            this.example = new CodeableConcept();
            return this.example;
        }
        if (name.equals("exampleCoding")) {
            this.example = new Coding();
            return this.example;
        }
        if (name.equals("exampleQuantity")) {
            this.example = new Quantity();
            return this.example;
        }
        if (name.equals("exampleRange")) {
            this.example = new Range();
            return this.example;
        }
        if (name.equals("examplePeriod")) {
            this.example = new Period();
            return this.example;
        }
        if (name.equals("exampleRatio")) {
            this.example = new Ratio();
            return this.example;
        }
        if (name.equals("exampleSampledData")) {
            this.example = new SampledData();
            return this.example;
        }
        if (name.equals("exampleSignature")) {
            this.example = new Signature();
            return this.example;
        }
        if (name.equals("exampleHumanName")) {
            this.example = new HumanName();
            return this.example;
        }
        if (name.equals("exampleAddress")) {
            this.example = new Address();
            return this.example;
        }
        if (name.equals("exampleContactPoint")) {
            this.example = new ContactPoint();
            return this.example;
        }
        if (name.equals("exampleTiming")) {
            this.example = new Timing();
            return this.example;
        }
        if (name.equals("exampleReference")) {
            this.example = new Reference();
            return this.example;
        }
        if (name.equals("exampleMeta")) {
            this.example = new Meta();
            return this.example;
        }
        if (name.equals("minValueBoolean")) {
            this.minValue = new BooleanType();
            return this.minValue;
        }
        if (name.equals("minValueInteger")) {
            this.minValue = new IntegerType();
            return this.minValue;
        }
        if (name.equals("minValueDecimal")) {
            this.minValue = new DecimalType();
            return this.minValue;
        }
        if (name.equals("minValueBase64Binary")) {
            this.minValue = new Base64BinaryType();
            return this.minValue;
        }
        if (name.equals("minValueInstant")) {
            this.minValue = new InstantType();
            return this.minValue;
        }
        if (name.equals("minValueString")) {
            this.minValue = new StringType();
            return this.minValue;
        }
        if (name.equals("minValueUri")) {
            this.minValue = new UriType();
            return this.minValue;
        }
        if (name.equals("minValueDate")) {
            this.minValue = new DateType();
            return this.minValue;
        }
        if (name.equals("minValueDateTime")) {
            this.minValue = new DateTimeType();
            return this.minValue;
        }
        if (name.equals("minValueTime")) {
            this.minValue = new TimeType();
            return this.minValue;
        }
        if (name.equals("minValueCode")) {
            this.minValue = new CodeType();
            return this.minValue;
        }
        if (name.equals("minValueOid")) {
            this.minValue = new OidType();
            return this.minValue;
        }
        if (name.equals("minValueId")) {
            this.minValue = new IdType();
            return this.minValue;
        }
        if (name.equals("minValueUnsignedInt")) {
            this.minValue = new UnsignedIntType();
            return this.minValue;
        }
        if (name.equals("minValuePositiveInt")) {
            this.minValue = new PositiveIntType();
            return this.minValue;
        }
        if (name.equals("minValueMarkdown")) {
            this.minValue = new MarkdownType();
            return this.minValue;
        }
        if (name.equals("minValueAnnotation")) {
            this.minValue = new Annotation();
            return this.minValue;
        }
        if (name.equals("minValueAttachment")) {
            this.minValue = new Attachment();
            return this.minValue;
        }
        if (name.equals("minValueIdentifier")) {
            this.minValue = new Identifier();
            return this.minValue;
        }
        if (name.equals("minValueCodeableConcept")) {
            this.minValue = new CodeableConcept();
            return this.minValue;
        }
        if (name.equals("minValueCoding")) {
            this.minValue = new Coding();
            return this.minValue;
        }
        if (name.equals("minValueQuantity")) {
            this.minValue = new Quantity();
            return this.minValue;
        }
        if (name.equals("minValueRange")) {
            this.minValue = new Range();
            return this.minValue;
        }
        if (name.equals("minValuePeriod")) {
            this.minValue = new Period();
            return this.minValue;
        }
        if (name.equals("minValueRatio")) {
            this.minValue = new Ratio();
            return this.minValue;
        }
        if (name.equals("minValueSampledData")) {
            this.minValue = new SampledData();
            return this.minValue;
        }
        if (name.equals("minValueSignature")) {
            this.minValue = new Signature();
            return this.minValue;
        }
        if (name.equals("minValueHumanName")) {
            this.minValue = new HumanName();
            return this.minValue;
        }
        if (name.equals("minValueAddress")) {
            this.minValue = new Address();
            return this.minValue;
        }
        if (name.equals("minValueContactPoint")) {
            this.minValue = new ContactPoint();
            return this.minValue;
        }
        if (name.equals("minValueTiming")) {
            this.minValue = new Timing();
            return this.minValue;
        }
        if (name.equals("minValueReference")) {
            this.minValue = new Reference();
            return this.minValue;
        }
        if (name.equals("minValueMeta")) {
            this.minValue = new Meta();
            return this.minValue;
        }
        if (name.equals("maxValueBoolean")) {
            this.maxValue = new BooleanType();
            return this.maxValue;
        }
        if (name.equals("maxValueInteger")) {
            this.maxValue = new IntegerType();
            return this.maxValue;
        }
        if (name.equals("maxValueDecimal")) {
            this.maxValue = new DecimalType();
            return this.maxValue;
        }
        if (name.equals("maxValueBase64Binary")) {
            this.maxValue = new Base64BinaryType();
            return this.maxValue;
        }
        if (name.equals("maxValueInstant")) {
            this.maxValue = new InstantType();
            return this.maxValue;
        }
        if (name.equals("maxValueString")) {
            this.maxValue = new StringType();
            return this.maxValue;
        }
        if (name.equals("maxValueUri")) {
            this.maxValue = new UriType();
            return this.maxValue;
        }
        if (name.equals("maxValueDate")) {
            this.maxValue = new DateType();
            return this.maxValue;
        }
        if (name.equals("maxValueDateTime")) {
            this.maxValue = new DateTimeType();
            return this.maxValue;
        }
        if (name.equals("maxValueTime")) {
            this.maxValue = new TimeType();
            return this.maxValue;
        }
        if (name.equals("maxValueCode")) {
            this.maxValue = new CodeType();
            return this.maxValue;
        }
        if (name.equals("maxValueOid")) {
            this.maxValue = new OidType();
            return this.maxValue;
        }
        if (name.equals("maxValueId")) {
            this.maxValue = new IdType();
            return this.maxValue;
        }
        if (name.equals("maxValueUnsignedInt")) {
            this.maxValue = new UnsignedIntType();
            return this.maxValue;
        }
        if (name.equals("maxValuePositiveInt")) {
            this.maxValue = new PositiveIntType();
            return this.maxValue;
        }
        if (name.equals("maxValueMarkdown")) {
            this.maxValue = new MarkdownType();
            return this.maxValue;
        }
        if (name.equals("maxValueAnnotation")) {
            this.maxValue = new Annotation();
            return this.maxValue;
        }
        if (name.equals("maxValueAttachment")) {
            this.maxValue = new Attachment();
            return this.maxValue;
        }
        if (name.equals("maxValueIdentifier")) {
            this.maxValue = new Identifier();
            return this.maxValue;
        }
        if (name.equals("maxValueCodeableConcept")) {
            this.maxValue = new CodeableConcept();
            return this.maxValue;
        }
        if (name.equals("maxValueCoding")) {
            this.maxValue = new Coding();
            return this.maxValue;
        }
        if (name.equals("maxValueQuantity")) {
            this.maxValue = new Quantity();
            return this.maxValue;
        }
        if (name.equals("maxValueRange")) {
            this.maxValue = new Range();
            return this.maxValue;
        }
        if (name.equals("maxValuePeriod")) {
            this.maxValue = new Period();
            return this.maxValue;
        }
        if (name.equals("maxValueRatio")) {
            this.maxValue = new Ratio();
            return this.maxValue;
        }
        if (name.equals("maxValueSampledData")) {
            this.maxValue = new SampledData();
            return this.maxValue;
        }
        if (name.equals("maxValueSignature")) {
            this.maxValue = new Signature();
            return this.maxValue;
        }
        if (name.equals("maxValueHumanName")) {
            this.maxValue = new HumanName();
            return this.maxValue;
        }
        if (name.equals("maxValueAddress")) {
            this.maxValue = new Address();
            return this.maxValue;
        }
        if (name.equals("maxValueContactPoint")) {
            this.maxValue = new ContactPoint();
            return this.maxValue;
        }
        if (name.equals("maxValueTiming")) {
            this.maxValue = new Timing();
            return this.maxValue;
        }
        if (name.equals("maxValueReference")) {
            this.maxValue = new Reference();
            return this.maxValue;
        }
        if (name.equals("maxValueMeta")) {
            this.maxValue = new Meta();
            return this.maxValue;
        }
        if (name.equals("maxLength")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.maxLength");
        }
        if (name.equals("condition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.condition");
        }
        if (name.equals("constraint")) {
            return this.addConstraint();
        }
        if (name.equals("mustSupport")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.mustSupport");
        }
        if (name.equals("isModifier")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.isModifier");
        }
        if (name.equals("isSummary")) {
            throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.isSummary");
        }
        if (name.equals("binding")) {
            this.binding = new ElementDefinitionBindingComponent();
            return this.binding;
        }
        if (name.equals("mapping")) {
            return this.addMapping();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ElementDefinition";
    }

    @Override
    public ElementDefinition copy() {
        ElementDefinition dst = new ElementDefinition();
        this.copyValues(dst);
        StringType stringType = dst.path = this.path == null ? null : this.path.copy();
        if (this.representation != null) {
            dst.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
            for (Enumeration<PropertyRepresentation> enumeration : this.representation) {
                dst.representation.add((Enumeration<PropertyRepresentation>)enumeration.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType2 = dst.label = this.label == null ? null : this.label.copy();
        if (this.code != null) {
            dst.code = new ArrayList<Coding>();
            for (Coding coding : this.code) {
                dst.code.add(coding.copy());
            }
        }
        dst.slicing = this.slicing == null ? null : this.slicing.copy();
        dst.short_ = this.short_ == null ? null : this.short_.copy();
        dst.definition = this.definition == null ? null : this.definition.copy();
        dst.comments = this.comments == null ? null : this.comments.copy();
        MarkdownType markdownType = dst.requirements = this.requirements == null ? null : this.requirements.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType3 : this.alias) {
                dst.alias.add(stringType3.copy());
            }
        }
        dst.min = this.min == null ? null : this.min.copy();
        dst.max = this.max == null ? null : this.max.copy();
        ElementDefinitionBaseComponent elementDefinitionBaseComponent = dst.base = this.base == null ? null : this.base.copy();
        if (this.type != null) {
            dst.type = new ArrayList<TypeRefComponent>();
            for (TypeRefComponent typeRefComponent : this.type) {
                dst.type.add(typeRefComponent.copy());
            }
        }
        dst.nameReference = this.nameReference == null ? null : this.nameReference.copy();
        dst.defaultValue = this.defaultValue == null ? null : this.defaultValue.copy();
        dst.meaningWhenMissing = this.meaningWhenMissing == null ? null : this.meaningWhenMissing.copy();
        dst.fixed = this.fixed == null ? null : this.fixed.copy();
        dst.pattern = this.pattern == null ? null : this.pattern.copy();
        dst.example = this.example == null ? null : this.example.copy();
        dst.minValue = this.minValue == null ? null : this.minValue.copy();
        dst.maxValue = this.maxValue == null ? null : this.maxValue.copy();
        IntegerType integerType = dst.maxLength = this.maxLength == null ? null : this.maxLength.copy();
        if (this.condition != null) {
            dst.condition = new ArrayList<IdType>();
            for (IdType idType : this.condition) {
                dst.condition.add(idType.copy());
            }
        }
        if (this.constraint != null) {
            dst.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
            for (ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : this.constraint) {
                dst.constraint.add(elementDefinitionConstraintComponent.copy());
            }
        }
        dst.mustSupport = this.mustSupport == null ? null : this.mustSupport.copy();
        dst.isModifier = this.isModifier == null ? null : this.isModifier.copy();
        dst.isSummary = this.isSummary == null ? null : this.isSummary.copy();
        ElementDefinitionBindingComponent elementDefinitionBindingComponent = dst.binding = this.binding == null ? null : this.binding.copy();
        if (this.mapping != null) {
            dst.mapping = new ArrayList<ElementDefinitionMappingComponent>();
            for (ElementDefinitionMappingComponent elementDefinitionMappingComponent : this.mapping) {
                dst.mapping.add(elementDefinitionMappingComponent.copy());
            }
        }
        return dst;
    }

    @Override
    protected ElementDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ElementDefinition)) {
            return false;
        }
        ElementDefinition o = (ElementDefinition)other;
        return ElementDefinition.compareDeep(this.path, o.path, true) && ElementDefinition.compareDeep(this.representation, o.representation, true) && ElementDefinition.compareDeep(this.name, o.name, true) && ElementDefinition.compareDeep(this.label, o.label, true) && ElementDefinition.compareDeep(this.code, o.code, true) && ElementDefinition.compareDeep(this.slicing, o.slicing, true) && ElementDefinition.compareDeep(this.short_, o.short_, true) && ElementDefinition.compareDeep(this.definition, o.definition, true) && ElementDefinition.compareDeep(this.comments, o.comments, true) && ElementDefinition.compareDeep(this.requirements, o.requirements, true) && ElementDefinition.compareDeep(this.alias, o.alias, true) && ElementDefinition.compareDeep(this.min, o.min, true) && ElementDefinition.compareDeep(this.max, o.max, true) && ElementDefinition.compareDeep(this.base, o.base, true) && ElementDefinition.compareDeep(this.type, o.type, true) && ElementDefinition.compareDeep(this.nameReference, o.nameReference, true) && ElementDefinition.compareDeep(this.defaultValue, o.defaultValue, true) && ElementDefinition.compareDeep(this.meaningWhenMissing, o.meaningWhenMissing, true) && ElementDefinition.compareDeep(this.fixed, o.fixed, true) && ElementDefinition.compareDeep(this.pattern, o.pattern, true) && ElementDefinition.compareDeep(this.example, o.example, true) && ElementDefinition.compareDeep(this.minValue, o.minValue, true) && ElementDefinition.compareDeep(this.maxValue, o.maxValue, true) && ElementDefinition.compareDeep(this.maxLength, o.maxLength, true) && ElementDefinition.compareDeep(this.condition, o.condition, true) && ElementDefinition.compareDeep(this.constraint, o.constraint, true) && ElementDefinition.compareDeep(this.mustSupport, o.mustSupport, true) && ElementDefinition.compareDeep(this.isModifier, o.isModifier, true) && ElementDefinition.compareDeep(this.isSummary, o.isSummary, true) && ElementDefinition.compareDeep(this.binding, o.binding, true) && ElementDefinition.compareDeep(this.mapping, o.mapping, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ElementDefinition)) {
            return false;
        }
        ElementDefinition o = (ElementDefinition)other;
        return ElementDefinition.compareValues(this.path, o.path, true) && ElementDefinition.compareValues(this.representation, o.representation, true) && ElementDefinition.compareValues(this.name, o.name, true) && ElementDefinition.compareValues(this.label, o.label, true) && ElementDefinition.compareValues(this.short_, o.short_, true) && ElementDefinition.compareValues(this.definition, o.definition, true) && ElementDefinition.compareValues(this.comments, o.comments, true) && ElementDefinition.compareValues(this.requirements, o.requirements, true) && ElementDefinition.compareValues(this.alias, o.alias, true) && ElementDefinition.compareValues(this.min, o.min, true) && ElementDefinition.compareValues(this.max, o.max, true) && ElementDefinition.compareValues(this.nameReference, o.nameReference, true) && ElementDefinition.compareValues(this.meaningWhenMissing, o.meaningWhenMissing, true) && ElementDefinition.compareValues(this.maxLength, o.maxLength, true) && ElementDefinition.compareValues(this.condition, o.condition, true) && ElementDefinition.compareValues(this.mustSupport, o.mustSupport, true) && ElementDefinition.compareValues(this.isModifier, o.isModifier, true) && ElementDefinition.compareValues(this.isSummary, o.isSummary, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.path != null && !this.path.isEmpty() || this.representation != null && !this.representation.isEmpty() || this.name != null && !this.name.isEmpty() || this.label != null && !this.label.isEmpty() || this.code != null && !this.code.isEmpty() || this.slicing != null && !this.slicing.isEmpty() || this.short_ != null && !this.short_.isEmpty() || this.definition != null && !this.definition.isEmpty() || this.comments != null && !this.comments.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.alias != null && !this.alias.isEmpty() || this.min != null && !this.min.isEmpty() || this.max != null && !this.max.isEmpty() || this.base != null && !this.base.isEmpty() || this.type != null && !this.type.isEmpty() || this.nameReference != null && !this.nameReference.isEmpty() || this.defaultValue != null && !this.defaultValue.isEmpty() || this.meaningWhenMissing != null && !this.meaningWhenMissing.isEmpty() || this.fixed != null && !this.fixed.isEmpty() || this.pattern != null && !this.pattern.isEmpty() || this.example != null && !this.example.isEmpty() || this.minValue != null && !this.minValue.isEmpty() || this.maxValue != null && !this.maxValue.isEmpty() || this.maxLength != null && !this.maxLength.isEmpty() || this.condition != null && !this.condition.isEmpty() || this.constraint != null && !this.constraint.isEmpty() || this.mustSupport != null && !this.mustSupport.isEmpty() || this.isModifier != null && !this.isModifier.isEmpty() || this.isSummary != null && !this.isSummary.isEmpty() || this.binding != null && !this.binding.isEmpty() || this.mapping != null && !this.mapping.isEmpty());
    }

    @Block
    public static class ElementDefinitionMappingComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="identity", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to mapping declaration", formalDefinition="An internal reference to the definition of a mapping.")
        protected IdType identity;
        @Child(name="language", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Computable language of mapping", formalDefinition="Identifies the computable language in which mapping.map is expressed.")
        protected CodeType language;
        @Child(name="map", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Details of the mapping", formalDefinition="Expresses what part of the target specification corresponds to this element.")
        protected StringType map;
        private static final long serialVersionUID = -669205371L;

        public ElementDefinitionMappingComponent() {
        }

        public ElementDefinitionMappingComponent(IdType identity, StringType map) {
            this.identity = identity;
            this.map = map;
        }

        public IdType getIdentityElement() {
            if (this.identity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionMappingComponent.identity");
                }
                if (Configuration.doAutoCreate()) {
                    this.identity = new IdType();
                }
            }
            return this.identity;
        }

        public boolean hasIdentityElement() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public boolean hasIdentity() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public ElementDefinitionMappingComponent setIdentityElement(IdType value) {
            this.identity = value;
            return this;
        }

        public String getIdentity() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public ElementDefinitionMappingComponent setIdentity(String value) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(value);
            return this;
        }

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionMappingComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ElementDefinitionMappingComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ElementDefinitionMappingComponent setLanguage(String value) {
            if (Utilities.noString(value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public StringType getMapElement() {
            if (this.map == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionMappingComponent.map");
                }
                if (Configuration.doAutoCreate()) {
                    this.map = new StringType();
                }
            }
            return this.map;
        }

        public boolean hasMapElement() {
            return this.map != null && !this.map.isEmpty();
        }

        public boolean hasMap() {
            return this.map != null && !this.map.isEmpty();
        }

        public ElementDefinitionMappingComponent setMapElement(StringType value) {
            this.map = value;
            return this;
        }

        public String getMap() {
            return this.map == null ? null : (String)this.map.getValue();
        }

        public ElementDefinitionMappingComponent setMap(String value) {
            if (this.map == null) {
                this.map = new StringType();
            }
            this.map.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identity", "id", "An internal reference to the definition of a mapping.", 0, Integer.MAX_VALUE, this.identity));
            childrenList.add(new Property("language", "code", "Identifies the computable language in which mapping.map is expressed.", 0, Integer.MAX_VALUE, this.language));
            childrenList.add(new Property("map", "string", "Expresses what part of the target specification corresponds to this element.", 0, Integer.MAX_VALUE, this.map));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identity")) {
                this.identity = this.castToId(value);
            } else if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("map")) {
                this.map = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identity")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.identity");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.language");
            }
            if (name.equals("map")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.map");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionMappingComponent copy() {
            ElementDefinitionMappingComponent dst = new ElementDefinitionMappingComponent();
            this.copyValues(dst);
            dst.identity = this.identity == null ? null : this.identity.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.map = this.map == null ? null : this.map.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionMappingComponent)) {
                return false;
            }
            ElementDefinitionMappingComponent o = (ElementDefinitionMappingComponent)other;
            return ElementDefinitionMappingComponent.compareDeep(this.identity, o.identity, true) && ElementDefinitionMappingComponent.compareDeep(this.language, o.language, true) && ElementDefinitionMappingComponent.compareDeep(this.map, o.map, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionMappingComponent)) {
                return false;
            }
            ElementDefinitionMappingComponent o = (ElementDefinitionMappingComponent)other;
            return ElementDefinitionMappingComponent.compareValues(this.identity, o.identity, true) && ElementDefinitionMappingComponent.compareValues(this.language, o.language, true) && ElementDefinitionMappingComponent.compareValues(this.map, o.map, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identity != null && !this.identity.isEmpty() || this.language != null && !this.language.isEmpty() || this.map != null && !this.map.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.mapping";
        }
    }

    @Block
    public static class ElementDefinitionBindingComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="strength", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="required | extensible | preferred | example", formalDefinition="Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.")
        protected Enumeration<Enumerations.BindingStrength> strength;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human explanation of the value set", formalDefinition="Describes the intended use of this particular set of codes.")
        protected StringType description;
        @Child(name="valueSet", type={UriType.class, ValueSet.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Source of value set", formalDefinition="Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.")
        protected Type valueSet;
        private static final long serialVersionUID = 1355538460L;

        public ElementDefinitionBindingComponent() {
        }

        public ElementDefinitionBindingComponent(Enumeration<Enumerations.BindingStrength> strength) {
            this.strength = strength;
        }

        public Enumeration<Enumerations.BindingStrength> getStrengthElement() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBindingComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
                }
            }
            return this.strength;
        }

        public boolean hasStrengthElement() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public ElementDefinitionBindingComponent setStrengthElement(Enumeration<Enumerations.BindingStrength> value) {
            this.strength = value;
            return this;
        }

        public Enumerations.BindingStrength getStrength() {
            return this.strength == null ? null : (Enumerations.BindingStrength)((Object)this.strength.getValue());
        }

        public ElementDefinitionBindingComponent setStrength(Enumerations.BindingStrength value) {
            if (this.strength == null) {
                this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
            }
            this.strength.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBindingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ElementDefinitionBindingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ElementDefinitionBindingComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Type getValueSet() {
            return this.valueSet;
        }

        public UriType getValueSetUriType() throws FHIRException {
            if (!(this.valueSet instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (UriType)this.valueSet;
        }

        public boolean hasValueSetUriType() {
            return this.valueSet instanceof UriType;
        }

        public Reference getValueSetReference() throws FHIRException {
            if (!(this.valueSet instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (Reference)this.valueSet;
        }

        public boolean hasValueSetReference() {
            return this.valueSet instanceof Reference;
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public ElementDefinitionBindingComponent setValueSet(Type value) {
            this.valueSet = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("strength", "code", "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, Integer.MAX_VALUE, this.strength));
            childrenList.add(new Property("description", "string", "Describes the intended use of this particular set of codes.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("valueSet[x]", "uri|Reference(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, Integer.MAX_VALUE, this.valueSet));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("strength")) {
                this.strength = new Enumerations.BindingStrengthEnumFactory().fromType(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("valueSet[x]")) {
                this.valueSet = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("strength")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.strength");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.description");
            }
            if (name.equals("valueSetUri")) {
                this.valueSet = new UriType();
                return this.valueSet;
            }
            if (name.equals("valueSetReference")) {
                this.valueSet = new Reference();
                return this.valueSet;
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionBindingComponent copy() {
            ElementDefinitionBindingComponent dst = new ElementDefinitionBindingComponent();
            this.copyValues(dst);
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionBindingComponent)) {
                return false;
            }
            ElementDefinitionBindingComponent o = (ElementDefinitionBindingComponent)other;
            return ElementDefinitionBindingComponent.compareDeep(this.strength, o.strength, true) && ElementDefinitionBindingComponent.compareDeep(this.description, o.description, true) && ElementDefinitionBindingComponent.compareDeep(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionBindingComponent)) {
                return false;
            }
            ElementDefinitionBindingComponent o = (ElementDefinitionBindingComponent)other;
            return ElementDefinitionBindingComponent.compareValues(this.strength, o.strength, true) && ElementDefinitionBindingComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.strength != null && !this.strength.isEmpty() || this.description != null && !this.description.isEmpty() || this.valueSet != null && !this.valueSet.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.binding";
        }
    }

    @Block
    public static class ElementDefinitionConstraintComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="key", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Target of 'condition' reference above", formalDefinition="Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality.")
        protected IdType key;
        @Child(name="requirements", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Why this constraint necessary or appropriate", formalDefinition="Description of why this constraint is necessary or appropriate.")
        protected StringType requirements;
        @Child(name="severity", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="error | warning", formalDefinition="Identifies the impact constraint violation has on the conformance of the instance.")
        protected Enumeration<ConstraintSeverity> severity;
        @Child(name="human", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human description of constraint", formalDefinition="Text that can be used to describe the constraint in messages identifying that the constraint has been violated.")
        protected StringType human;
        @Child(name="xpath", type={StringType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="XPath expression of constraint", formalDefinition="An XPath expression of constraint that can be executed to see if this constraint is met.")
        protected StringType xpath;
        private static final long serialVersionUID = 854521265L;

        public ElementDefinitionConstraintComponent() {
        }

        public ElementDefinitionConstraintComponent(IdType key, Enumeration<ConstraintSeverity> severity, StringType human, StringType xpath) {
            this.key = key;
            this.severity = severity;
            this.human = human;
            this.xpath = xpath;
        }

        public IdType getKeyElement() {
            if (this.key == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.key");
                }
                if (Configuration.doAutoCreate()) {
                    this.key = new IdType();
                }
            }
            return this.key;
        }

        public boolean hasKeyElement() {
            return this.key != null && !this.key.isEmpty();
        }

        public boolean hasKey() {
            return this.key != null && !this.key.isEmpty();
        }

        public ElementDefinitionConstraintComponent setKeyElement(IdType value) {
            this.key = value;
            return this;
        }

        public String getKey() {
            return this.key == null ? null : this.key.getValue();
        }

        public ElementDefinitionConstraintComponent setKey(String value) {
            if (this.key == null) {
                this.key = new IdType();
            }
            this.key.setValue(value);
            return this;
        }

        public StringType getRequirementsElement() {
            if (this.requirements == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.requirements");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirements = new StringType();
                }
            }
            return this.requirements;
        }

        public boolean hasRequirementsElement() {
            return this.requirements != null && !this.requirements.isEmpty();
        }

        public boolean hasRequirements() {
            return this.requirements != null && !this.requirements.isEmpty();
        }

        public ElementDefinitionConstraintComponent setRequirementsElement(StringType value) {
            this.requirements = value;
            return this;
        }

        public String getRequirements() {
            return this.requirements == null ? null : (String)this.requirements.getValue();
        }

        public ElementDefinitionConstraintComponent setRequirements(String value) {
            if (Utilities.noString(value)) {
                this.requirements = null;
            } else {
                if (this.requirements == null) {
                    this.requirements = new StringType();
                }
                this.requirements.setValue(value);
            }
            return this;
        }

        public Enumeration<ConstraintSeverity> getSeverityElement() {
            if (this.severity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.severity");
                }
                if (Configuration.doAutoCreate()) {
                    this.severity = new Enumeration<ConstraintSeverity>(new ConstraintSeverityEnumFactory());
                }
            }
            return this.severity;
        }

        public boolean hasSeverityElement() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public boolean hasSeverity() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public ElementDefinitionConstraintComponent setSeverityElement(Enumeration<ConstraintSeverity> value) {
            this.severity = value;
            return this;
        }

        public ConstraintSeverity getSeverity() {
            return this.severity == null ? null : (ConstraintSeverity)((Object)this.severity.getValue());
        }

        public ElementDefinitionConstraintComponent setSeverity(ConstraintSeverity value) {
            if (this.severity == null) {
                this.severity = new Enumeration<ConstraintSeverity>(new ConstraintSeverityEnumFactory());
            }
            this.severity.setValue((Object)value);
            return this;
        }

        public StringType getHumanElement() {
            if (this.human == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.human");
                }
                if (Configuration.doAutoCreate()) {
                    this.human = new StringType();
                }
            }
            return this.human;
        }

        public boolean hasHumanElement() {
            return this.human != null && !this.human.isEmpty();
        }

        public boolean hasHuman() {
            return this.human != null && !this.human.isEmpty();
        }

        public ElementDefinitionConstraintComponent setHumanElement(StringType value) {
            this.human = value;
            return this;
        }

        public String getHuman() {
            return this.human == null ? null : (String)this.human.getValue();
        }

        public ElementDefinitionConstraintComponent setHuman(String value) {
            if (this.human == null) {
                this.human = new StringType();
            }
            this.human.setValue(value);
            return this;
        }

        public StringType getXpathElement() {
            if (this.xpath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionConstraintComponent.xpath");
                }
                if (Configuration.doAutoCreate()) {
                    this.xpath = new StringType();
                }
            }
            return this.xpath;
        }

        public boolean hasXpathElement() {
            return this.xpath != null && !this.xpath.isEmpty();
        }

        public boolean hasXpath() {
            return this.xpath != null && !this.xpath.isEmpty();
        }

        public ElementDefinitionConstraintComponent setXpathElement(StringType value) {
            this.xpath = value;
            return this;
        }

        public String getXpath() {
            return this.xpath == null ? null : (String)this.xpath.getValue();
        }

        public ElementDefinitionConstraintComponent setXpath(String value) {
            if (this.xpath == null) {
                this.xpath = new StringType();
            }
            this.xpath.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("key", "id", "Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality.", 0, Integer.MAX_VALUE, this.key));
            childrenList.add(new Property("requirements", "string", "Description of why this constraint is necessary or appropriate.", 0, Integer.MAX_VALUE, this.requirements));
            childrenList.add(new Property("severity", "code", "Identifies the impact constraint violation has on the conformance of the instance.", 0, Integer.MAX_VALUE, this.severity));
            childrenList.add(new Property("human", "string", "Text that can be used to describe the constraint in messages identifying that the constraint has been violated.", 0, Integer.MAX_VALUE, this.human));
            childrenList.add(new Property("xpath", "string", "An XPath expression of constraint that can be executed to see if this constraint is met.", 0, Integer.MAX_VALUE, this.xpath));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = this.castToId(value);
            } else if (name.equals("requirements")) {
                this.requirements = this.castToString(value);
            } else if (name.equals("severity")) {
                this.severity = new ConstraintSeverityEnumFactory().fromType(value);
            } else if (name.equals("human")) {
                this.human = this.castToString(value);
            } else if (name.equals("xpath")) {
                this.xpath = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("key")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.key");
            }
            if (name.equals("requirements")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.requirements");
            }
            if (name.equals("severity")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.severity");
            }
            if (name.equals("human")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.human");
            }
            if (name.equals("xpath")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.xpath");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionConstraintComponent copy() {
            ElementDefinitionConstraintComponent dst = new ElementDefinitionConstraintComponent();
            this.copyValues(dst);
            dst.key = this.key == null ? null : this.key.copy();
            dst.requirements = this.requirements == null ? null : this.requirements.copy();
            dst.severity = this.severity == null ? null : this.severity.copy();
            dst.human = this.human == null ? null : this.human.copy();
            dst.xpath = this.xpath == null ? null : this.xpath.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionConstraintComponent)) {
                return false;
            }
            ElementDefinitionConstraintComponent o = (ElementDefinitionConstraintComponent)other;
            return ElementDefinitionConstraintComponent.compareDeep(this.key, o.key, true) && ElementDefinitionConstraintComponent.compareDeep(this.requirements, o.requirements, true) && ElementDefinitionConstraintComponent.compareDeep(this.severity, o.severity, true) && ElementDefinitionConstraintComponent.compareDeep(this.human, o.human, true) && ElementDefinitionConstraintComponent.compareDeep(this.xpath, o.xpath, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionConstraintComponent)) {
                return false;
            }
            ElementDefinitionConstraintComponent o = (ElementDefinitionConstraintComponent)other;
            return ElementDefinitionConstraintComponent.compareValues(this.key, o.key, true) && ElementDefinitionConstraintComponent.compareValues(this.requirements, o.requirements, true) && ElementDefinitionConstraintComponent.compareValues(this.severity, o.severity, true) && ElementDefinitionConstraintComponent.compareValues(this.human, o.human, true) && ElementDefinitionConstraintComponent.compareValues(this.xpath, o.xpath, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.key != null && !this.key.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.severity != null && !this.severity.isEmpty() || this.human != null && !this.human.isEmpty() || this.xpath != null && !this.xpath.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.constraint";
        }
    }

    @Block
    public static class TypeRefComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of Data type or Resource", formalDefinition="Name of Data type or Resource that is a(or the) type used for this element.")
        protected CodeType code;
        @Child(name="profile", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Profile (StructureDefinition) to apply (or IG)", formalDefinition="Identifies a profile structure or implementation Guide that SHALL hold for resources or datatypes referenced as the type of this element. Can be a local reference - to another structure in this profile, or a reference to a structure in another profile. When more than one profile is specified, the content must conform to all of them. When an implementation guide is specified, the resource SHALL conform to at least one profile defined in the implementation guide.")
        protected List<UriType> profile;
        @Child(name="aggregation", type={CodeType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="contained | referenced | bundled - how aggregated", formalDefinition="If the type is a reference to another resource, how the resource is or can be aggregated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle.")
        protected List<Enumeration<AggregationMode>> aggregation;
        private static final long serialVersionUID = -988693373L;

        public TypeRefComponent() {
        }

        public TypeRefComponent(CodeType code) {
            this.code = code;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TypeRefComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TypeRefComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TypeRefComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public List<UriType> getProfile() {
            if (this.profile == null) {
                this.profile = new ArrayList<UriType>();
            }
            return this.profile;
        }

        public boolean hasProfile() {
            if (this.profile == null) {
                return false;
            }
            for (UriType item : this.profile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addProfileElement() {
            UriType t = new UriType();
            if (this.profile == null) {
                this.profile = new ArrayList<UriType>();
            }
            this.profile.add(t);
            return t;
        }

        public TypeRefComponent addProfile(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.profile == null) {
                this.profile = new ArrayList<UriType>();
            }
            this.profile.add(t);
            return this;
        }

        public boolean hasProfile(String value) {
            if (this.profile == null) {
                return false;
            }
            for (UriType v : this.profile) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Enumeration<AggregationMode>> getAggregation() {
            if (this.aggregation == null) {
                this.aggregation = new ArrayList<Enumeration<AggregationMode>>();
            }
            return this.aggregation;
        }

        public TypeRefComponent setAggregation(List<Enumeration<AggregationMode>> aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public boolean hasAggregation() {
            if (this.aggregation == null) {
                return false;
            }
            for (Enumeration<AggregationMode> item : this.aggregation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<AggregationMode> addAggregationElement() {
            Enumeration<AggregationMode> t = new Enumeration<AggregationMode>(new AggregationModeEnumFactory());
            if (this.aggregation == null) {
                this.aggregation = new ArrayList<Enumeration<AggregationMode>>();
            }
            this.aggregation.add(t);
            return t;
        }

        public TypeRefComponent addAggregation(AggregationMode value) {
            Enumeration<AggregationMode> t = new Enumeration<AggregationMode>(new AggregationModeEnumFactory());
            t.setValue((Object)value);
            if (this.aggregation == null) {
                this.aggregation = new ArrayList<Enumeration<AggregationMode>>();
            }
            this.aggregation.add(t);
            return this;
        }

        public boolean hasAggregation(AggregationMode value) {
            if (this.aggregation == null) {
                return false;
            }
            for (Enumeration<AggregationMode> v : this.aggregation) {
                if (!v.equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "code", "Name of Data type or Resource that is a(or the) type used for this element.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("profile", "uri", "Identifies a profile structure or implementation Guide that SHALL hold for resources or datatypes referenced as the type of this element. Can be a local reference - to another structure in this profile, or a reference to a structure in another profile. When more than one profile is specified, the content must conform to all of them. When an implementation guide is specified, the resource SHALL conform to at least one profile defined in the implementation guide.", 0, Integer.MAX_VALUE, this.profile));
            childrenList.add(new Property("aggregation", "code", "If the type is a reference to another resource, how the resource is or can be aggregated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle.", 0, Integer.MAX_VALUE, this.aggregation));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.getProfile().add(this.castToUri(value));
            } else if (name.equals("aggregation")) {
                this.getAggregation().add(new AggregationModeEnumFactory().fromType(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.code");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.profile");
            }
            if (name.equals("aggregation")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.aggregation");
            }
            return super.addChild(name);
        }

        @Override
        public TypeRefComponent copy() {
            TypeRefComponent dst = new TypeRefComponent();
            this.copyValues(dst);
            CodeType codeType = dst.code = this.code == null ? null : this.code.copy();
            if (this.profile != null) {
                dst.profile = new ArrayList<UriType>();
                for (UriType uriType : this.profile) {
                    dst.profile.add(uriType.copy());
                }
            }
            if (this.aggregation != null) {
                dst.aggregation = new ArrayList<Enumeration<AggregationMode>>();
                for (Enumeration enumeration : this.aggregation) {
                    dst.aggregation.add((Enumeration<AggregationMode>)enumeration.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TypeRefComponent)) {
                return false;
            }
            TypeRefComponent o = (TypeRefComponent)other;
            return TypeRefComponent.compareDeep(this.code, o.code, true) && TypeRefComponent.compareDeep(this.profile, o.profile, true) && TypeRefComponent.compareDeep(this.aggregation, o.aggregation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TypeRefComponent)) {
                return false;
            }
            TypeRefComponent o = (TypeRefComponent)other;
            return TypeRefComponent.compareValues(this.code, o.code, true) && TypeRefComponent.compareValues(this.profile, o.profile, true) && TypeRefComponent.compareValues(this.aggregation, o.aggregation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.aggregation != null && !this.aggregation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.type";
        }

        public boolean hasTarget() {
            return Utilities.existsInList(this.getCode(), "Reference");
        }
    }

    @Block
    public static class ElementDefinitionBaseComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Path that identifies the base element", formalDefinition="The Path that identifies the base element - this matches the ElementDefinition.path for that element. Across FHIR, there is only one base definition of any element - that is, an element definition on a [[[StructureDefinition]]] without a StructureDefinition.base.")
        protected StringType path;
        @Child(name="min", type={IntegerType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Min cardinality of the base element", formalDefinition="Minimum cardinality of the base element identified by the path.")
        protected IntegerType min;
        @Child(name="max", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Max cardinality of the base element", formalDefinition="Maximum cardinality of the base element identified by the path.")
        protected StringType max;
        private static final long serialVersionUID = 232204455L;

        public ElementDefinitionBaseComponent() {
        }

        public ElementDefinitionBaseComponent(StringType path, IntegerType min2, StringType max) {
            this.path = path;
            this.min = min2;
            this.max = max;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBaseComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ElementDefinitionBaseComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ElementDefinitionBaseComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public IntegerType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBaseComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new IntegerType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public ElementDefinitionBaseComponent setMinElement(IntegerType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public ElementDefinitionBaseComponent setMin(int value) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionBaseComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public ElementDefinitionBaseComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public ElementDefinitionBaseComponent setMax(String value) {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("path", "string", "The Path that identifies the base element - this matches the ElementDefinition.path for that element. Across FHIR, there is only one base definition of any element - that is, an element definition on a [[[StructureDefinition]]] without a StructureDefinition.base.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("min", "integer", "Minimum cardinality of the base element identified by the path.", 0, Integer.MAX_VALUE, this.min));
            childrenList.add(new Property("max", "string", "Maximum cardinality of the base element identified by the path.", 0, Integer.MAX_VALUE, this.max));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("min")) {
                this.min = this.castToInteger(value);
            } else if (name.equals("max")) {
                this.max = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.path");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.max");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionBaseComponent copy() {
            ElementDefinitionBaseComponent dst = new ElementDefinitionBaseComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionBaseComponent)) {
                return false;
            }
            ElementDefinitionBaseComponent o = (ElementDefinitionBaseComponent)other;
            return ElementDefinitionBaseComponent.compareDeep(this.path, o.path, true) && ElementDefinitionBaseComponent.compareDeep(this.min, o.min, true) && ElementDefinitionBaseComponent.compareDeep(this.max, o.max, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionBaseComponent)) {
                return false;
            }
            ElementDefinitionBaseComponent o = (ElementDefinitionBaseComponent)other;
            return ElementDefinitionBaseComponent.compareValues(this.path, o.path, true) && ElementDefinitionBaseComponent.compareValues(this.min, o.min, true) && ElementDefinitionBaseComponent.compareValues(this.max, o.max, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.path != null && !this.path.isEmpty() || this.min != null && !this.min.isEmpty() || this.max != null && !this.max.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.base";
        }
    }

    @Block
    public static class ElementDefinitionSlicingComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="discriminator", type={StringType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Element values that used to distinguish the slices", formalDefinition="Designates which child elements are used to discriminate between the slices when processing an instance. If one or more discriminators are provided, the value of the child elements in the instance data SHALL completely distinguish which slice the element in the resource matches based on the allowed values for those elements in each of the slices.")
        protected List<StringType> discriminator;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text description of how slicing works (or not)", formalDefinition="A human-readable text description of how the slicing works. If there is no discriminator, this is required to be present to provide whatever information is possible about how the slices can be differentiated.")
        protected StringType description;
        @Child(name="ordered", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If elements must be in same order as slices", formalDefinition="If the matching elements have to occur in the same order as defined in the profile.")
        protected BooleanType ordered;
        @Child(name="rules", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="closed | open | openAtEnd", formalDefinition="Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end.")
        protected Enumeration<SlicingRules> rules;
        private static final long serialVersionUID = 233544215L;

        public ElementDefinitionSlicingComponent() {
        }

        public ElementDefinitionSlicingComponent(Enumeration<SlicingRules> rules) {
            this.rules = rules;
        }

        public List<StringType> getDiscriminator() {
            if (this.discriminator == null) {
                this.discriminator = new ArrayList<StringType>();
            }
            return this.discriminator;
        }

        public boolean hasDiscriminator() {
            if (this.discriminator == null) {
                return false;
            }
            for (StringType item : this.discriminator) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addDiscriminatorElement() {
            StringType t = new StringType();
            if (this.discriminator == null) {
                this.discriminator = new ArrayList<StringType>();
            }
            this.discriminator.add(t);
            return t;
        }

        public ElementDefinitionSlicingComponent addDiscriminator(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.discriminator == null) {
                this.discriminator = new ArrayList<StringType>();
            }
            this.discriminator.add(t);
            return this;
        }

        public boolean hasDiscriminator(String value) {
            if (this.discriminator == null) {
                return false;
            }
            for (StringType v : this.discriminator) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ElementDefinitionSlicingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ElementDefinitionSlicingComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public BooleanType getOrderedElement() {
            if (this.ordered == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingComponent.ordered");
                }
                if (Configuration.doAutoCreate()) {
                    this.ordered = new BooleanType();
                }
            }
            return this.ordered;
        }

        public boolean hasOrderedElement() {
            return this.ordered != null && !this.ordered.isEmpty();
        }

        public boolean hasOrdered() {
            return this.ordered != null && !this.ordered.isEmpty();
        }

        public ElementDefinitionSlicingComponent setOrderedElement(BooleanType value) {
            this.ordered = value;
            return this;
        }

        public boolean getOrdered() {
            return this.ordered == null || this.ordered.isEmpty() ? false : (Boolean)this.ordered.getValue();
        }

        public ElementDefinitionSlicingComponent setOrdered(boolean value) {
            if (this.ordered == null) {
                this.ordered = new BooleanType();
            }
            this.ordered.setValue((Object)value);
            return this;
        }

        public Enumeration<SlicingRules> getRulesElement() {
            if (this.rules == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ElementDefinitionSlicingComponent.rules");
                }
                if (Configuration.doAutoCreate()) {
                    this.rules = new Enumeration<SlicingRules>(new SlicingRulesEnumFactory());
                }
            }
            return this.rules;
        }

        public boolean hasRulesElement() {
            return this.rules != null && !this.rules.isEmpty();
        }

        public boolean hasRules() {
            return this.rules != null && !this.rules.isEmpty();
        }

        public ElementDefinitionSlicingComponent setRulesElement(Enumeration<SlicingRules> value) {
            this.rules = value;
            return this;
        }

        public SlicingRules getRules() {
            return this.rules == null ? null : (SlicingRules)((Object)this.rules.getValue());
        }

        public ElementDefinitionSlicingComponent setRules(SlicingRules value) {
            if (this.rules == null) {
                this.rules = new Enumeration<SlicingRules>(new SlicingRulesEnumFactory());
            }
            this.rules.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("discriminator", "string", "Designates which child elements are used to discriminate between the slices when processing an instance. If one or more discriminators are provided, the value of the child elements in the instance data SHALL completely distinguish which slice the element in the resource matches based on the allowed values for those elements in each of the slices.", 0, Integer.MAX_VALUE, this.discriminator));
            childrenList.add(new Property("description", "string", "A human-readable text description of how the slicing works. If there is no discriminator, this is required to be present to provide whatever information is possible about how the slices can be differentiated.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("ordered", "boolean", "If the matching elements have to occur in the same order as defined in the profile.", 0, Integer.MAX_VALUE, this.ordered));
            childrenList.add(new Property("rules", "code", "Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end.", 0, Integer.MAX_VALUE, this.rules));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("discriminator")) {
                this.getDiscriminator().add(this.castToString(value));
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("ordered")) {
                this.ordered = this.castToBoolean(value);
            } else if (name.equals("rules")) {
                this.rules = new SlicingRulesEnumFactory().fromType(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("discriminator")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.discriminator");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.description");
            }
            if (name.equals("ordered")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.ordered");
            }
            if (name.equals("rules")) {
                throw new FHIRException("Cannot call addChild on a primitive type ElementDefinition.rules");
            }
            return super.addChild(name);
        }

        @Override
        public ElementDefinitionSlicingComponent copy() {
            ElementDefinitionSlicingComponent dst = new ElementDefinitionSlicingComponent();
            this.copyValues(dst);
            if (this.discriminator != null) {
                dst.discriminator = new ArrayList<StringType>();
                for (StringType i : this.discriminator) {
                    dst.discriminator.add(i.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.ordered = this.ordered == null ? null : this.ordered.copy();
            dst.rules = this.rules == null ? null : this.rules.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionSlicingComponent)) {
                return false;
            }
            ElementDefinitionSlicingComponent o = (ElementDefinitionSlicingComponent)other;
            return ElementDefinitionSlicingComponent.compareDeep(this.discriminator, o.discriminator, true) && ElementDefinitionSlicingComponent.compareDeep(this.description, o.description, true) && ElementDefinitionSlicingComponent.compareDeep(this.ordered, o.ordered, true) && ElementDefinitionSlicingComponent.compareDeep(this.rules, o.rules, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ElementDefinitionSlicingComponent)) {
                return false;
            }
            ElementDefinitionSlicingComponent o = (ElementDefinitionSlicingComponent)other;
            return ElementDefinitionSlicingComponent.compareValues(this.discriminator, o.discriminator, true) && ElementDefinitionSlicingComponent.compareValues(this.description, o.description, true) && ElementDefinitionSlicingComponent.compareValues(this.ordered, o.ordered, true) && ElementDefinitionSlicingComponent.compareValues(this.rules, o.rules, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.discriminator != null && !this.discriminator.isEmpty() || this.description != null && !this.description.isEmpty() || this.ordered != null && !this.ordered.isEmpty() || this.rules != null && !this.rules.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ElementDefinition.slicing";
        }
    }

    public static class ConstraintSeverityEnumFactory
    implements EnumFactory<ConstraintSeverity> {
        @Override
        public ConstraintSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("error".equals(codeString)) {
                return ConstraintSeverity.ERROR;
            }
            if ("warning".equals(codeString)) {
                return ConstraintSeverity.WARNING;
            }
            throw new IllegalArgumentException("Unknown ConstraintSeverity code '" + codeString + "'");
        }

        public Enumeration<ConstraintSeverity> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("error".equals(codeString)) {
                return new Enumeration<ConstraintSeverity>(this, ConstraintSeverity.ERROR);
            }
            if ("warning".equals(codeString)) {
                return new Enumeration<ConstraintSeverity>(this, ConstraintSeverity.WARNING);
            }
            throw new FHIRException("Unknown ConstraintSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(ConstraintSeverity code) {
            if (code == ConstraintSeverity.ERROR) {
                return "error";
            }
            if (code == ConstraintSeverity.WARNING) {
                return "warning";
            }
            return "?";
        }
    }

    public static enum ConstraintSeverity {
        ERROR,
        WARNING,
        NULL;


        public static ConstraintSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("warning".equals(codeString)) {
                return WARNING;
            }
            throw new FHIRException("Unknown ConstraintSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case WARNING: {
                    return "warning";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ERROR: {
                    return "http://hl7.org/fhir/constraint-severity";
                }
                case WARNING: {
                    return "http://hl7.org/fhir/constraint-severity";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ERROR: {
                    return "If the constraint is violated, the resource is not conformant.";
                }
                case WARNING: {
                    return "If the constraint is violated, the resource is conformant, but it is not necessarily following best practice.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ERROR: {
                    return "Error";
                }
                case WARNING: {
                    return "Warning";
                }
            }
            return "?";
        }
    }

    public static class AggregationModeEnumFactory
    implements EnumFactory<AggregationMode> {
        @Override
        public AggregationMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("contained".equals(codeString)) {
                return AggregationMode.CONTAINED;
            }
            if ("referenced".equals(codeString)) {
                return AggregationMode.REFERENCED;
            }
            if ("bundled".equals(codeString)) {
                return AggregationMode.BUNDLED;
            }
            throw new IllegalArgumentException("Unknown AggregationMode code '" + codeString + "'");
        }

        public Enumeration<AggregationMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("contained".equals(codeString)) {
                return new Enumeration<AggregationMode>(this, AggregationMode.CONTAINED);
            }
            if ("referenced".equals(codeString)) {
                return new Enumeration<AggregationMode>(this, AggregationMode.REFERENCED);
            }
            if ("bundled".equals(codeString)) {
                return new Enumeration<AggregationMode>(this, AggregationMode.BUNDLED);
            }
            throw new FHIRException("Unknown AggregationMode code '" + codeString + "'");
        }

        @Override
        public String toCode(AggregationMode code) {
            if (code == AggregationMode.CONTAINED) {
                return "contained";
            }
            if (code == AggregationMode.REFERENCED) {
                return "referenced";
            }
            if (code == AggregationMode.BUNDLED) {
                return "bundled";
            }
            return "?";
        }
    }

    public static enum AggregationMode {
        CONTAINED,
        REFERENCED,
        BUNDLED,
        NULL;


        public static AggregationMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("contained".equals(codeString)) {
                return CONTAINED;
            }
            if ("referenced".equals(codeString)) {
                return REFERENCED;
            }
            if ("bundled".equals(codeString)) {
                return BUNDLED;
            }
            throw new FHIRException("Unknown AggregationMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CONTAINED: {
                    return "contained";
                }
                case REFERENCED: {
                    return "referenced";
                }
                case BUNDLED: {
                    return "bundled";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CONTAINED: {
                    return "http://hl7.org/fhir/resource-aggregation-mode";
                }
                case REFERENCED: {
                    return "http://hl7.org/fhir/resource-aggregation-mode";
                }
                case BUNDLED: {
                    return "http://hl7.org/fhir/resource-aggregation-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CONTAINED: {
                    return "The reference is a local reference to a contained resource.";
                }
                case REFERENCED: {
                    return "The reference to a resource that has to be resolved externally to the resource that includes the reference.";
                }
                case BUNDLED: {
                    return "The resource the reference points to will be found in the same bundle as the resource that includes the reference.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CONTAINED: {
                    return "Contained";
                }
                case REFERENCED: {
                    return "Referenced";
                }
                case BUNDLED: {
                    return "Bundled";
                }
            }
            return "?";
        }
    }

    public static class SlicingRulesEnumFactory
    implements EnumFactory<SlicingRules> {
        @Override
        public SlicingRules fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("closed".equals(codeString)) {
                return SlicingRules.CLOSED;
            }
            if ("open".equals(codeString)) {
                return SlicingRules.OPEN;
            }
            if ("openAtEnd".equals(codeString)) {
                return SlicingRules.OPENATEND;
            }
            throw new IllegalArgumentException("Unknown SlicingRules code '" + codeString + "'");
        }

        public Enumeration<SlicingRules> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("closed".equals(codeString)) {
                return new Enumeration<SlicingRules>(this, SlicingRules.CLOSED);
            }
            if ("open".equals(codeString)) {
                return new Enumeration<SlicingRules>(this, SlicingRules.OPEN);
            }
            if ("openAtEnd".equals(codeString)) {
                return new Enumeration<SlicingRules>(this, SlicingRules.OPENATEND);
            }
            throw new FHIRException("Unknown SlicingRules code '" + codeString + "'");
        }

        @Override
        public String toCode(SlicingRules code) {
            if (code == SlicingRules.CLOSED) {
                return "closed";
            }
            if (code == SlicingRules.OPEN) {
                return "open";
            }
            if (code == SlicingRules.OPENATEND) {
                return "openAtEnd";
            }
            return "?";
        }
    }

    public static enum SlicingRules {
        CLOSED,
        OPEN,
        OPENATEND,
        NULL;


        public static SlicingRules fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("closed".equals(codeString)) {
                return CLOSED;
            }
            if ("open".equals(codeString)) {
                return OPEN;
            }
            if ("openAtEnd".equals(codeString)) {
                return OPENATEND;
            }
            throw new FHIRException("Unknown SlicingRules code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLOSED: {
                    return "closed";
                }
                case OPEN: {
                    return "open";
                }
                case OPENATEND: {
                    return "openAtEnd";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLOSED: {
                    return "http://hl7.org/fhir/resource-slicing-rules";
                }
                case OPEN: {
                    return "http://hl7.org/fhir/resource-slicing-rules";
                }
                case OPENATEND: {
                    return "http://hl7.org/fhir/resource-slicing-rules";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLOSED: {
                    return "No additional content is allowed other than that described by the slices in this profile.";
                }
                case OPEN: {
                    return "Additional content is allowed anywhere in the list.";
                }
                case OPENATEND: {
                    return "Additional content is allowed, but only at the end of the list. Note that using this requires that the slices be ordered, which makes it hard to share uses. This should only be done where absolutely required.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLOSED: {
                    return "Closed";
                }
                case OPEN: {
                    return "Open";
                }
                case OPENATEND: {
                    return "Open at End";
                }
            }
            return "?";
        }
    }

    public static class PropertyRepresentationEnumFactory
    implements EnumFactory<PropertyRepresentation> {
        @Override
        public PropertyRepresentation fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("xmlAttr".equals(codeString)) {
                return PropertyRepresentation.XMLATTR;
            }
            throw new IllegalArgumentException("Unknown PropertyRepresentation code '" + codeString + "'");
        }

        public Enumeration<PropertyRepresentation> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("xmlAttr".equals(codeString)) {
                return new Enumeration<PropertyRepresentation>(this, PropertyRepresentation.XMLATTR);
            }
            throw new FHIRException("Unknown PropertyRepresentation code '" + codeString + "'");
        }

        @Override
        public String toCode(PropertyRepresentation code) {
            if (code == PropertyRepresentation.XMLATTR) {
                return "xmlAttr";
            }
            return "?";
        }
    }

    public static enum PropertyRepresentation {
        XMLATTR,
        NULL;


        public static PropertyRepresentation fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("xmlAttr".equals(codeString)) {
                return XMLATTR;
            }
            throw new FHIRException("Unknown PropertyRepresentation code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case XMLATTR: {
                    return "xmlAttr";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case XMLATTR: {
                    return "http://hl7.org/fhir/property-representation";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case XMLATTR: {
                    return "In XML, this property is represented as an attribute not an element.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case XMLATTR: {
                    return "XML Attribute";
                }
            }
            return "?";
        }
    }
}

