/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Conformance", profile="http://hl7.org/fhir/Profile/Conformance")
public class Conformance
extends DomainResource
implements IBaseConformance {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical uri to reference this statement", formalDefinition="An absolute URL that is used to identify this conformance statement when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this conformance statement is (or will be) published.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id for this version of the statement", formalDefinition="The identifier that is used to identify this version of the conformance statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this conformance statement", formalDefinition="A free text natural language name identifying the conformance statement.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of this conformance statement.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this conformance statement is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the conformance.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<ConformanceContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Publication Date(/time)", formalDefinition="The date  (and optionally time) when the conformance statement was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the conformance statement changes.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human description of the conformance statement", formalDefinition="A free text natural language description of the conformance statement and its use. Typically, this is used when the conformance statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.")
    protected StringType description;
    @Child(name="requirements", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why is this needed?", formalDefinition="Explains why this conformance statement is needed and why it's been constrained as it has.")
    protected StringType requirements;
    @Child(name="copyright", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the conformance statement and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the system described by the conformance statement.")
    protected StringType copyright;
    @Child(name="kind", type={CodeType.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="instance | capability | requirements", formalDefinition="The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind not instance of software) or a class of implementation (e.g. a desired purchase).")
    protected Enumeration<ConformanceStatementKind> kind;
    @Child(name="software", type={}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Software that is covered by this conformance statement", formalDefinition="Software that is covered by this conformance statement.  It is used when the conformance statement describes the capabilities of a particular software version, independent of an installation.")
    protected ConformanceSoftwareComponent software;
    @Child(name="implementation", type={}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this describes a specific instance", formalDefinition="Identifies a specific implementation instance that is described by the conformance statement - i.e. a particular installation, rather than the capabilities of a software program.")
    protected ConformanceImplementationComponent implementation;
    @Child(name="fhirVersion", type={IdType.class}, order=14, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version the system uses", formalDefinition="The version of the FHIR specification on which this conformance statement is based.")
    protected IdType fhirVersion;
    @Child(name="acceptUnknown", type={CodeType.class}, order=15, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="no | extensions | elements | both", formalDefinition="A code that indicates whether the application accepts unknown elements or extensions when reading resources.")
    protected Enumeration<UnknownContentCode> acceptUnknown;
    @Child(name="format", type={CodeType.class}, order=16, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="formats supported (xml | json | mime type)", formalDefinition="A list of the formats supported by this implementation using their content types.")
    protected List<CodeType> format;
    @Child(name="profile", type={StructureDefinition.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Profiles for use cases supported", formalDefinition="A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles]{profiling.html#profile-uses}.")
    protected List<Reference> profile;
    protected List<StructureDefinition> profileTarget;
    @Child(name="rest", type={}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="If the endpoint is a RESTful one", formalDefinition="A definition of the restful capabilities of the solution, if any.")
    protected List<ConformanceRestComponent> rest;
    @Child(name="messaging", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="If messaging is supported", formalDefinition="A description of the messaging capabilities of the solution.")
    protected List<ConformanceMessagingComponent> messaging;
    @Child(name="document", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Document definition", formalDefinition="A document definition.")
    protected List<ConformanceDocumentComponent> document;
    private static final long serialVersionUID = 1863739648L;
    @SearchParamDefinition(name="date", path="Conformance.date", description="The conformance statement publication date", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="software", path="Conformance.software.name", description="Part of a the name of a software application", type="string")
    public static final String SP_SOFTWARE = "software";
    @SearchParamDefinition(name="resource", path="Conformance.rest.resource.type", description="Name of a resource mentioned in a conformance statement", type="token")
    public static final String SP_RESOURCE = "resource";
    @SearchParamDefinition(name="profile", path="Conformance.rest.resource.profile", description="A profile id invoked in a conformance statement", type="reference")
    public static final String SP_PROFILE = "profile";
    @SearchParamDefinition(name="format", path="Conformance.format", description="formats supported (xml | json | mime type)", type="token")
    public static final String SP_FORMAT = "format";
    @SearchParamDefinition(name="description", path="Conformance.description", description="Text search in the description of the conformance statement", type="string")
    public static final String SP_DESCRIPTION = "description";
    @SearchParamDefinition(name="fhirversion", path="Conformance.version", description="The version of FHIR", type="token")
    public static final String SP_FHIRVERSION = "fhirversion";
    @SearchParamDefinition(name="version", path="Conformance.version", description="The version identifier of the conformance statement", type="token")
    public static final String SP_VERSION = "version";
    @SearchParamDefinition(name="url", path="Conformance.url", description="The uri that identifies the conformance statement", type="uri")
    public static final String SP_URL = "url";
    @SearchParamDefinition(name="supported-profile", path="Conformance.profile", description="Profiles for use cases supported", type="reference")
    public static final String SP_SUPPORTEDPROFILE = "supported-profile";
    @SearchParamDefinition(name="mode", path="Conformance.rest.mode", description="Mode - restful (server/client) or messaging (sender/receiver)", type="token")
    public static final String SP_MODE = "mode";
    @SearchParamDefinition(name="security", path="Conformance.rest.security.service", description="OAuth | SMART-on-FHIR | NTLM | Basic | Kerberos | Certificates", type="token")
    public static final String SP_SECURITY = "security";
    @SearchParamDefinition(name="name", path="Conformance.name", description="Name of the conformance statement", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="publisher", path="Conformance.publisher", description="Name of the publisher of the conformance statement", type="string")
    public static final String SP_PUBLISHER = "publisher";
    @SearchParamDefinition(name="event", path="Conformance.messaging.event.code", description="Event code in a conformance statement", type="token")
    public static final String SP_EVENT = "event";
    @SearchParamDefinition(name="status", path="Conformance.status", description="The current status of the conformance statement", type="token")
    public static final String SP_STATUS = "status";

    public Conformance() {
    }

    public Conformance(DateTimeType date, Enumeration<ConformanceStatementKind> kind, IdType fhirVersion, Enumeration<UnknownContentCode> acceptUnknown) {
        this.date = date;
        this.kind = kind;
        this.fhirVersion = fhirVersion;
        this.acceptUnknown = acceptUnknown;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Conformance setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Conformance setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Conformance setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Conformance setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Conformance setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Conformance setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Conformance setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public Conformance setStatus(Enumerations.ConformanceResourceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public Conformance setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public Conformance setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public Conformance setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public Conformance setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ConformanceContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ConformanceContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ConformanceContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConformanceContactComponent addContact() {
        ConformanceContactComponent t = new ConformanceContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ConformanceContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public Conformance addContact(ConformanceContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ConformanceContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Conformance setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Conformance setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Conformance setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Conformance setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public Conformance setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public Conformance setRequirements(String value) {
        if (Utilities.noString(value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public Conformance setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public Conformance setCopyright(String value) {
        if (Utilities.noString(value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Enumeration<ConformanceStatementKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<ConformanceStatementKind>(new ConformanceStatementKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public Conformance setKindElement(Enumeration<ConformanceStatementKind> value) {
        this.kind = value;
        return this;
    }

    public ConformanceStatementKind getKind() {
        return this.kind == null ? null : (ConformanceStatementKind)((Object)this.kind.getValue());
    }

    public Conformance setKind(ConformanceStatementKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<ConformanceStatementKind>(new ConformanceStatementKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public ConformanceSoftwareComponent getSoftware() {
        if (this.software == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.software");
            }
            if (Configuration.doAutoCreate()) {
                this.software = new ConformanceSoftwareComponent();
            }
        }
        return this.software;
    }

    public boolean hasSoftware() {
        return this.software != null && !this.software.isEmpty();
    }

    public Conformance setSoftware(ConformanceSoftwareComponent value) {
        this.software = value;
        return this;
    }

    public ConformanceImplementationComponent getImplementation() {
        if (this.implementation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.implementation");
            }
            if (Configuration.doAutoCreate()) {
                this.implementation = new ConformanceImplementationComponent();
            }
        }
        return this.implementation;
    }

    public boolean hasImplementation() {
        return this.implementation != null && !this.implementation.isEmpty();
    }

    public Conformance setImplementation(ConformanceImplementationComponent value) {
        this.implementation = value;
        return this;
    }

    public IdType getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new IdType();
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public Conformance setFhirVersionElement(IdType value) {
        this.fhirVersion = value;
        return this;
    }

    public String getFhirVersion() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public Conformance setFhirVersion(String value) {
        if (this.fhirVersion == null) {
            this.fhirVersion = new IdType();
        }
        this.fhirVersion.setValue(value);
        return this;
    }

    public Enumeration<UnknownContentCode> getAcceptUnknownElement() {
        if (this.acceptUnknown == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Conformance.acceptUnknown");
            }
            if (Configuration.doAutoCreate()) {
                this.acceptUnknown = new Enumeration<UnknownContentCode>(new UnknownContentCodeEnumFactory());
            }
        }
        return this.acceptUnknown;
    }

    public boolean hasAcceptUnknownElement() {
        return this.acceptUnknown != null && !this.acceptUnknown.isEmpty();
    }

    public boolean hasAcceptUnknown() {
        return this.acceptUnknown != null && !this.acceptUnknown.isEmpty();
    }

    public Conformance setAcceptUnknownElement(Enumeration<UnknownContentCode> value) {
        this.acceptUnknown = value;
        return this;
    }

    public UnknownContentCode getAcceptUnknown() {
        return this.acceptUnknown == null ? null : (UnknownContentCode)((Object)this.acceptUnknown.getValue());
    }

    public Conformance setAcceptUnknown(UnknownContentCode value) {
        if (this.acceptUnknown == null) {
            this.acceptUnknown = new Enumeration<UnknownContentCode>(new UnknownContentCodeEnumFactory());
        }
        this.acceptUnknown.setValue((Object)value);
        return this;
    }

    public List<CodeType> getFormat() {
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        return this.format;
    }

    public boolean hasFormat() {
        if (this.format == null) {
            return false;
        }
        for (CodeType item : this.format) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addFormatElement() {
        CodeType t = new CodeType();
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        this.format.add(t);
        return t;
    }

    public Conformance addFormat(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        this.format.add(t);
        return this;
    }

    public boolean hasFormat(String value) {
        if (this.format == null) {
            return false;
        }
        for (CodeType v : this.format) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        return this.profile;
    }

    public boolean hasProfile() {
        if (this.profile == null) {
            return false;
        }
        for (Reference item : this.profile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProfile() {
        Reference t = new Reference();
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        this.profile.add(t);
        return t;
    }

    public Conformance addProfile(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        this.profile.add(t);
        return this;
    }

    public List<StructureDefinition> getProfileTarget() {
        if (this.profileTarget == null) {
            this.profileTarget = new ArrayList<StructureDefinition>();
        }
        return this.profileTarget;
    }

    public StructureDefinition addProfileTarget() {
        StructureDefinition r = new StructureDefinition();
        if (this.profileTarget == null) {
            this.profileTarget = new ArrayList<StructureDefinition>();
        }
        this.profileTarget.add(r);
        return r;
    }

    public List<ConformanceRestComponent> getRest() {
        if (this.rest == null) {
            this.rest = new ArrayList<ConformanceRestComponent>();
        }
        return this.rest;
    }

    public boolean hasRest() {
        if (this.rest == null) {
            return false;
        }
        for (ConformanceRestComponent item : this.rest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConformanceRestComponent addRest() {
        ConformanceRestComponent t = new ConformanceRestComponent();
        if (this.rest == null) {
            this.rest = new ArrayList<ConformanceRestComponent>();
        }
        this.rest.add(t);
        return t;
    }

    public Conformance addRest(ConformanceRestComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rest == null) {
            this.rest = new ArrayList<ConformanceRestComponent>();
        }
        this.rest.add(t);
        return this;
    }

    public List<ConformanceMessagingComponent> getMessaging() {
        if (this.messaging == null) {
            this.messaging = new ArrayList<ConformanceMessagingComponent>();
        }
        return this.messaging;
    }

    public boolean hasMessaging() {
        if (this.messaging == null) {
            return false;
        }
        for (ConformanceMessagingComponent item : this.messaging) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConformanceMessagingComponent addMessaging() {
        ConformanceMessagingComponent t = new ConformanceMessagingComponent();
        if (this.messaging == null) {
            this.messaging = new ArrayList<ConformanceMessagingComponent>();
        }
        this.messaging.add(t);
        return t;
    }

    public Conformance addMessaging(ConformanceMessagingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.messaging == null) {
            this.messaging = new ArrayList<ConformanceMessagingComponent>();
        }
        this.messaging.add(t);
        return this;
    }

    public List<ConformanceDocumentComponent> getDocument() {
        if (this.document == null) {
            this.document = new ArrayList<ConformanceDocumentComponent>();
        }
        return this.document;
    }

    public boolean hasDocument() {
        if (this.document == null) {
            return false;
        }
        for (ConformanceDocumentComponent item : this.document) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConformanceDocumentComponent addDocument() {
        ConformanceDocumentComponent t = new ConformanceDocumentComponent();
        if (this.document == null) {
            this.document = new ArrayList<ConformanceDocumentComponent>();
        }
        this.document.add(t);
        return t;
    }

    public Conformance addDocument(ConformanceDocumentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.document == null) {
            this.document = new ArrayList<ConformanceDocumentComponent>();
        }
        this.document.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this conformance statement when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this conformance statement is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the conformance statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the conformance statement.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, "code", "The status of this conformance statement.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "A flag to indicate that this conformance statement is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the conformance.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the conformance statement was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the conformance statement changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the conformance statement and its use. Typically, this is used when the conformance statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("requirements", "string", "Explains why this conformance statement is needed and why it's been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the conformance statement and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the system described by the conformance statement.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("kind", "code", "The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind not instance of software) or a class of implementation (e.g. a desired purchase).", 0, Integer.MAX_VALUE, this.kind));
        childrenList.add(new Property(SP_SOFTWARE, "", "Software that is covered by this conformance statement.  It is used when the conformance statement describes the capabilities of a particular software version, independent of an installation.", 0, Integer.MAX_VALUE, this.software));
        childrenList.add(new Property("implementation", "", "Identifies a specific implementation instance that is described by the conformance statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, Integer.MAX_VALUE, this.implementation));
        childrenList.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this conformance statement is based.", 0, Integer.MAX_VALUE, this.fhirVersion));
        childrenList.add(new Property("acceptUnknown", "code", "A code that indicates whether the application accepts unknown elements or extensions when reading resources.", 0, Integer.MAX_VALUE, this.acceptUnknown));
        childrenList.add(new Property(SP_FORMAT, "code", "A list of the formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.format));
        childrenList.add(new Property(SP_PROFILE, "Reference(StructureDefinition)", "A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles]{profiling.html#profile-uses}.", 0, Integer.MAX_VALUE, this.profile));
        childrenList.add(new Property("rest", "", "A definition of the restful capabilities of the solution, if any.", 0, Integer.MAX_VALUE, this.rest));
        childrenList.add(new Property("messaging", "", "A description of the messaging capabilities of the solution.", 0, Integer.MAX_VALUE, this.messaging));
        childrenList.add(new Property("document", "", "A document definition.", 0, Integer.MAX_VALUE, this.document));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((ConformanceContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("kind")) {
            this.kind = new ConformanceStatementKindEnumFactory().fromType(value);
        } else if (name.equals(SP_SOFTWARE)) {
            this.software = (ConformanceSoftwareComponent)value;
        } else if (name.equals("implementation")) {
            this.implementation = (ConformanceImplementationComponent)value;
        } else if (name.equals("fhirVersion")) {
            this.fhirVersion = this.castToId(value);
        } else if (name.equals("acceptUnknown")) {
            this.acceptUnknown = new UnknownContentCodeEnumFactory().fromType(value);
        } else if (name.equals(SP_FORMAT)) {
            this.getFormat().add(this.castToCode(value));
        } else if (name.equals(SP_PROFILE)) {
            this.getProfile().add(this.castToReference(value));
        } else if (name.equals("rest")) {
            this.getRest().add((ConformanceRestComponent)value);
        } else if (name.equals("messaging")) {
            this.getMessaging().add((ConformanceMessagingComponent)value);
        } else if (name.equals("document")) {
            this.getDocument().add((ConformanceDocumentComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.description");
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.requirements");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.copyright");
        }
        if (name.equals("kind")) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.kind");
        }
        if (name.equals(SP_SOFTWARE)) {
            this.software = new ConformanceSoftwareComponent();
            return this.software;
        }
        if (name.equals("implementation")) {
            this.implementation = new ConformanceImplementationComponent();
            return this.implementation;
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.fhirVersion");
        }
        if (name.equals("acceptUnknown")) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.acceptUnknown");
        }
        if (name.equals(SP_FORMAT)) {
            throw new FHIRException("Cannot call addChild on a primitive type Conformance.format");
        }
        if (name.equals(SP_PROFILE)) {
            return this.addProfile();
        }
        if (name.equals("rest")) {
            return this.addRest();
        }
        if (name.equals("messaging")) {
            return this.addMessaging();
        }
        if (name.equals("document")) {
            return this.addDocument();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Conformance";
    }

    @Override
    public Conformance copy() {
        Conformance dst = new Conformance();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ConformanceContactComponent>();
            for (ConformanceContactComponent conformanceContactComponent : this.contact) {
                dst.contact.add(conformanceContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.software = this.software == null ? null : this.software.copy();
        dst.implementation = this.implementation == null ? null : this.implementation.copy();
        dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        Enumeration<UnknownContentCode> enumeration = dst.acceptUnknown = this.acceptUnknown == null ? null : this.acceptUnknown.copy();
        if (this.format != null) {
            dst.format = new ArrayList<CodeType>();
            for (CodeType codeType : this.format) {
                dst.format.add(codeType.copy());
            }
        }
        if (this.profile != null) {
            dst.profile = new ArrayList<Reference>();
            for (Reference reference : this.profile) {
                dst.profile.add(reference.copy());
            }
        }
        if (this.rest != null) {
            dst.rest = new ArrayList<ConformanceRestComponent>();
            for (ConformanceRestComponent conformanceRestComponent : this.rest) {
                dst.rest.add(conformanceRestComponent.copy());
            }
        }
        if (this.messaging != null) {
            dst.messaging = new ArrayList<ConformanceMessagingComponent>();
            for (ConformanceMessagingComponent conformanceMessagingComponent : this.messaging) {
                dst.messaging.add(conformanceMessagingComponent.copy());
            }
        }
        if (this.document != null) {
            dst.document = new ArrayList<ConformanceDocumentComponent>();
            for (ConformanceDocumentComponent conformanceDocumentComponent : this.document) {
                dst.document.add(conformanceDocumentComponent.copy());
            }
        }
        return dst;
    }

    protected Conformance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Conformance)) {
            return false;
        }
        Conformance o = (Conformance)other;
        return Conformance.compareDeep(this.url, o.url, true) && Conformance.compareDeep(this.version, o.version, true) && Conformance.compareDeep(this.name, o.name, true) && Conformance.compareDeep(this.status, o.status, true) && Conformance.compareDeep(this.experimental, o.experimental, true) && Conformance.compareDeep(this.publisher, o.publisher, true) && Conformance.compareDeep(this.contact, o.contact, true) && Conformance.compareDeep(this.date, o.date, true) && Conformance.compareDeep(this.description, o.description, true) && Conformance.compareDeep(this.requirements, o.requirements, true) && Conformance.compareDeep(this.copyright, o.copyright, true) && Conformance.compareDeep(this.kind, o.kind, true) && Conformance.compareDeep(this.software, o.software, true) && Conformance.compareDeep(this.implementation, o.implementation, true) && Conformance.compareDeep(this.fhirVersion, o.fhirVersion, true) && Conformance.compareDeep(this.acceptUnknown, o.acceptUnknown, true) && Conformance.compareDeep(this.format, o.format, true) && Conformance.compareDeep(this.profile, o.profile, true) && Conformance.compareDeep(this.rest, o.rest, true) && Conformance.compareDeep(this.messaging, o.messaging, true) && Conformance.compareDeep(this.document, o.document, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Conformance)) {
            return false;
        }
        Conformance o = (Conformance)other;
        return Conformance.compareValues(this.url, o.url, true) && Conformance.compareValues(this.version, o.version, true) && Conformance.compareValues(this.name, o.name, true) && Conformance.compareValues(this.status, o.status, true) && Conformance.compareValues(this.experimental, o.experimental, true) && Conformance.compareValues(this.publisher, o.publisher, true) && Conformance.compareValues(this.date, o.date, true) && Conformance.compareValues(this.description, o.description, true) && Conformance.compareValues(this.requirements, o.requirements, true) && Conformance.compareValues(this.copyright, o.copyright, true) && Conformance.compareValues(this.kind, o.kind, true) && Conformance.compareValues(this.fhirVersion, o.fhirVersion, true) && Conformance.compareValues(this.acceptUnknown, o.acceptUnknown, true) && Conformance.compareValues(this.format, o.format, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.kind != null && !this.kind.isEmpty() || this.software != null && !this.software.isEmpty() || this.implementation != null && !this.implementation.isEmpty() || this.fhirVersion != null && !this.fhirVersion.isEmpty() || this.acceptUnknown != null && !this.acceptUnknown.isEmpty() || this.format != null && !this.format.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.rest != null && !this.rest.isEmpty() || this.messaging != null && !this.messaging.isEmpty() || this.document != null && !this.document.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Conformance;
    }

    @Block
    public static class ConformanceDocumentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="producer | consumer", formalDefinition="Mode of this document declaration - whether application is producer or consumer.")
        protected Enumeration<DocumentMode> mode;
        @Child(name="documentation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of document support", formalDefinition="A description of how the application supports or uses the specified document profile.  For example, when are documents created, what action is taken with consumed documents, etc.")
        protected StringType documentation;
        @Child(name="profile", type={StructureDefinition.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Constraint on a resource used in the document", formalDefinition="A constraint on a resource used in the document.")
        protected Reference profile;
        protected StructureDefinition profileTarget;
        private static final long serialVersionUID = -1059555053L;

        public ConformanceDocumentComponent() {
        }

        public ConformanceDocumentComponent(Enumeration<DocumentMode> mode, Reference profile) {
            this.mode = mode;
            this.profile = profile;
        }

        public Enumeration<DocumentMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceDocumentComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<DocumentMode>(new DocumentModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ConformanceDocumentComponent setModeElement(Enumeration<DocumentMode> value) {
            this.mode = value;
            return this;
        }

        public DocumentMode getMode() {
            return this.mode == null ? null : (DocumentMode)((Object)this.mode.getValue());
        }

        public ConformanceDocumentComponent setMode(DocumentMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<DocumentMode>(new DocumentModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceDocumentComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ConformanceDocumentComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ConformanceDocumentComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public Reference getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceDocumentComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Reference();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ConformanceDocumentComponent setProfile(Reference value) {
            this.profile = value;
            return this;
        }

        public StructureDefinition getProfileTarget() {
            if (this.profileTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceDocumentComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profileTarget = new StructureDefinition();
                }
            }
            return this.profileTarget;
        }

        public ConformanceDocumentComponent setProfileTarget(StructureDefinition value) {
            this.profileTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Conformance.SP_MODE, "code", "Mode of this document declaration - whether application is producer or consumer.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("documentation", "string", "A description of how the application supports or uses the specified document profile.  For example, when are documents created, what action is taken with consumed documents, etc.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property(Conformance.SP_PROFILE, "Reference(StructureDefinition)", "A constraint on a resource used in the document.", 0, Integer.MAX_VALUE, this.profile));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Conformance.SP_MODE)) {
                this.mode = new DocumentModeEnumFactory().fromType(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals(Conformance.SP_PROFILE)) {
                this.profile = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Conformance.SP_MODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.documentation");
            }
            if (name.equals(Conformance.SP_PROFILE)) {
                this.profile = new Reference();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceDocumentComponent copy() {
            ConformanceDocumentComponent dst = new ConformanceDocumentComponent();
            this.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceDocumentComponent)) {
                return false;
            }
            ConformanceDocumentComponent o = (ConformanceDocumentComponent)other;
            return ConformanceDocumentComponent.compareDeep(this.mode, o.mode, true) && ConformanceDocumentComponent.compareDeep(this.documentation, o.documentation, true) && ConformanceDocumentComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceDocumentComponent)) {
                return false;
            }
            ConformanceDocumentComponent o = (ConformanceDocumentComponent)other;
            return ConformanceDocumentComponent.compareValues(this.mode, o.mode, true) && ConformanceDocumentComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.profile != null && !this.profile.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.document";
        }
    }

    @Block
    public static class ConformanceMessagingEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Event type", formalDefinition="A coded identifier of a supported messaging event.")
        protected Coding code;
        @Child(name="category", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Consequence | Currency | Notification", formalDefinition="The impact of the content of the message.")
        protected Enumeration<MessageSignificanceCategory> category;
        @Child(name="mode", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="sender | receiver", formalDefinition="The mode of this event declaration - whether application is sender or receiver.")
        protected Enumeration<ConformanceEventMode> mode;
        @Child(name="focus", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource that's focus of message", formalDefinition="A resource associated with the event.  This is the resource that defines the event.")
        protected CodeType focus;
        @Child(name="request", type={StructureDefinition.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile that describes the request", formalDefinition="Information about the request for this event.")
        protected Reference request;
        protected StructureDefinition requestTarget;
        @Child(name="response", type={StructureDefinition.class}, order=6, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile that describes the response", formalDefinition="Information about the response for this event.")
        protected Reference response;
        protected StructureDefinition responseTarget;
        @Child(name="documentation", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Endpoint-specific event documentation", formalDefinition="Guidance on how this event is handled, such as internal system trigger points, business rules, etc.")
        protected StringType documentation;
        private static final long serialVersionUID = -47031390L;

        public ConformanceMessagingEventComponent() {
        }

        public ConformanceMessagingEventComponent(Coding code, Enumeration<ConformanceEventMode> mode, CodeType focus, Reference request, Reference response) {
            this.code = code;
            this.mode = mode;
            this.focus = focus;
            this.request = request;
            this.response = response;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConformanceMessagingEventComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        public Enumeration<MessageSignificanceCategory> getCategoryElement() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Enumeration<MessageSignificanceCategory>(new MessageSignificanceCategoryEnumFactory());
                }
            }
            return this.category;
        }

        public boolean hasCategoryElement() {
            return this.category != null && !this.category.isEmpty();
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ConformanceMessagingEventComponent setCategoryElement(Enumeration<MessageSignificanceCategory> value) {
            this.category = value;
            return this;
        }

        public MessageSignificanceCategory getCategory() {
            return this.category == null ? null : (MessageSignificanceCategory)((Object)this.category.getValue());
        }

        public ConformanceMessagingEventComponent setCategory(MessageSignificanceCategory value) {
            if (value == null) {
                this.category = null;
            } else {
                if (this.category == null) {
                    this.category = new Enumeration<MessageSignificanceCategory>(new MessageSignificanceCategoryEnumFactory());
                }
                this.category.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ConformanceEventMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<ConformanceEventMode>(new ConformanceEventModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ConformanceMessagingEventComponent setModeElement(Enumeration<ConformanceEventMode> value) {
            this.mode = value;
            return this;
        }

        public ConformanceEventMode getMode() {
            return this.mode == null ? null : (ConformanceEventMode)((Object)this.mode.getValue());
        }

        public ConformanceMessagingEventComponent setMode(ConformanceEventMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<ConformanceEventMode>(new ConformanceEventModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public CodeType getFocusElement() {
            if (this.focus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.focus");
                }
                if (Configuration.doAutoCreate()) {
                    this.focus = new CodeType();
                }
            }
            return this.focus;
        }

        public boolean hasFocusElement() {
            return this.focus != null && !this.focus.isEmpty();
        }

        public boolean hasFocus() {
            return this.focus != null && !this.focus.isEmpty();
        }

        public ConformanceMessagingEventComponent setFocusElement(CodeType value) {
            this.focus = value;
            return this;
        }

        public String getFocus() {
            return this.focus == null ? null : (String)this.focus.getValue();
        }

        public ConformanceMessagingEventComponent setFocus(String value) {
            if (this.focus == null) {
                this.focus = new CodeType();
            }
            this.focus.setValue(value);
            return this;
        }

        public Reference getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new Reference();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public ConformanceMessagingEventComponent setRequest(Reference value) {
            this.request = value;
            return this;
        }

        public StructureDefinition getRequestTarget() {
            if (this.requestTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.requestTarget = new StructureDefinition();
                }
            }
            return this.requestTarget;
        }

        public ConformanceMessagingEventComponent setRequestTarget(StructureDefinition value) {
            this.requestTarget = value;
            return this;
        }

        public Reference getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new Reference();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public ConformanceMessagingEventComponent setResponse(Reference value) {
            this.response = value;
            return this;
        }

        public StructureDefinition getResponseTarget() {
            if (this.responseTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.responseTarget = new StructureDefinition();
                }
            }
            return this.responseTarget;
        }

        public ConformanceMessagingEventComponent setResponseTarget(StructureDefinition value) {
            this.responseTarget = value;
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEventComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ConformanceMessagingEventComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ConformanceMessagingEventComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "Coding", "A coded identifier of a supported messaging event.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("category", "code", "The impact of the content of the message.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property(Conformance.SP_MODE, "code", "The mode of this event declaration - whether application is sender or receiver.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("focus", "code", "A resource associated with the event.  This is the resource that defines the event.", 0, Integer.MAX_VALUE, this.focus));
            childrenList.add(new Property("request", "Reference(StructureDefinition)", "Information about the request for this event.", 0, Integer.MAX_VALUE, this.request));
            childrenList.add(new Property("response", "Reference(StructureDefinition)", "Information about the response for this event.", 0, Integer.MAX_VALUE, this.response));
            childrenList.add(new Property("documentation", "string", "Guidance on how this event is handled, such as internal system trigger points, business rules, etc.", 0, Integer.MAX_VALUE, this.documentation));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else if (name.equals("category")) {
                this.category = new MessageSignificanceCategoryEnumFactory().fromType(value);
            } else if (name.equals(Conformance.SP_MODE)) {
                this.mode = new ConformanceEventModeEnumFactory().fromType(value);
            } else if (name.equals("focus")) {
                this.focus = this.castToCode(value);
            } else if (name.equals("request")) {
                this.request = this.castToReference(value);
            } else if (name.equals("response")) {
                this.response = this.castToReference(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            if (name.equals("category")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.category");
            }
            if (name.equals(Conformance.SP_MODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.mode");
            }
            if (name.equals("focus")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.focus");
            }
            if (name.equals("request")) {
                this.request = new Reference();
                return this.request;
            }
            if (name.equals("response")) {
                this.response = new Reference();
                return this.response;
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceMessagingEventComponent copy() {
            ConformanceMessagingEventComponent dst = new ConformanceMessagingEventComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.category = this.category == null ? null : this.category.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.focus = this.focus == null ? null : this.focus.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.response = this.response == null ? null : this.response.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceMessagingEventComponent)) {
                return false;
            }
            ConformanceMessagingEventComponent o = (ConformanceMessagingEventComponent)other;
            return ConformanceMessagingEventComponent.compareDeep(this.code, o.code, true) && ConformanceMessagingEventComponent.compareDeep(this.category, o.category, true) && ConformanceMessagingEventComponent.compareDeep(this.mode, o.mode, true) && ConformanceMessagingEventComponent.compareDeep(this.focus, o.focus, true) && ConformanceMessagingEventComponent.compareDeep(this.request, o.request, true) && ConformanceMessagingEventComponent.compareDeep(this.response, o.response, true) && ConformanceMessagingEventComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceMessagingEventComponent)) {
                return false;
            }
            ConformanceMessagingEventComponent o = (ConformanceMessagingEventComponent)other;
            return ConformanceMessagingEventComponent.compareValues(this.category, o.category, true) && ConformanceMessagingEventComponent.compareValues(this.mode, o.mode, true) && ConformanceMessagingEventComponent.compareValues(this.focus, o.focus, true) && ConformanceMessagingEventComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.category != null && !this.category.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.focus != null && !this.focus.isEmpty() || this.request != null && !this.request.isEmpty() || this.response != null && !this.response.isEmpty() || this.documentation != null && !this.documentation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.messaging.event";
        }
    }

    @Block
    public static class ConformanceMessagingEndpointComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="protocol", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="http | ftp | mllp +", formalDefinition="A list of the messaging transport protocol(s) identifiers, supported by this endpoint.")
        protected Coding protocol;
        @Child(name="address", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Address of end-point", formalDefinition="The network address of the end-point. For solutions that do not use network addresses for routing, it can be just an identifier.")
        protected UriType address;
        private static final long serialVersionUID = 1294656428L;

        public ConformanceMessagingEndpointComponent() {
        }

        public ConformanceMessagingEndpointComponent(Coding protocol, UriType address) {
            this.protocol = protocol;
            this.address = address;
        }

        public Coding getProtocol() {
            if (this.protocol == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEndpointComponent.protocol");
                }
                if (Configuration.doAutoCreate()) {
                    this.protocol = new Coding();
                }
            }
            return this.protocol;
        }

        public boolean hasProtocol() {
            return this.protocol != null && !this.protocol.isEmpty();
        }

        public ConformanceMessagingEndpointComponent setProtocol(Coding value) {
            this.protocol = value;
            return this;
        }

        public UriType getAddressElement() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingEndpointComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new UriType();
                }
            }
            return this.address;
        }

        public boolean hasAddressElement() {
            return this.address != null && !this.address.isEmpty();
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public ConformanceMessagingEndpointComponent setAddressElement(UriType value) {
            this.address = value;
            return this;
        }

        public String getAddress() {
            return this.address == null ? null : (String)this.address.getValue();
        }

        public ConformanceMessagingEndpointComponent setAddress(String value) {
            if (this.address == null) {
                this.address = new UriType();
            }
            this.address.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("protocol", "Coding", "A list of the messaging transport protocol(s) identifiers, supported by this endpoint.", 0, Integer.MAX_VALUE, this.protocol));
            childrenList.add(new Property("address", "uri", "The network address of the end-point. For solutions that do not use network addresses for routing, it can be just an identifier.", 0, Integer.MAX_VALUE, this.address));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("protocol")) {
                this.protocol = this.castToCoding(value);
            } else if (name.equals("address")) {
                this.address = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("protocol")) {
                this.protocol = new Coding();
                return this.protocol;
            }
            if (name.equals("address")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.address");
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceMessagingEndpointComponent copy() {
            ConformanceMessagingEndpointComponent dst = new ConformanceMessagingEndpointComponent();
            this.copyValues(dst);
            dst.protocol = this.protocol == null ? null : this.protocol.copy();
            dst.address = this.address == null ? null : this.address.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceMessagingEndpointComponent)) {
                return false;
            }
            ConformanceMessagingEndpointComponent o = (ConformanceMessagingEndpointComponent)other;
            return ConformanceMessagingEndpointComponent.compareDeep(this.protocol, o.protocol, true) && ConformanceMessagingEndpointComponent.compareDeep(this.address, o.address, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceMessagingEndpointComponent)) {
                return false;
            }
            ConformanceMessagingEndpointComponent o = (ConformanceMessagingEndpointComponent)other;
            return ConformanceMessagingEndpointComponent.compareValues(this.address, o.address, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.protocol != null && !this.protocol.isEmpty() || this.address != null && !this.address.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.messaging.endpoint";
        }
    }

    @Block
    public static class ConformanceMessagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="endpoint", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A messaging service end-point", formalDefinition="An endpoint (network accessible address) to which messages and/or replies are to be sent.")
        protected List<ConformanceMessagingEndpointComponent> endpoint;
        @Child(name="reliableCache", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reliable Message Cache Length (min)", formalDefinition="Length if the receiver's reliable messaging cache in minutes (if a receiver) or how long the cache length on the receiver should be (if a sender).")
        protected UnsignedIntType reliableCache;
        @Child(name="documentation", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Messaging interface behavior details", formalDefinition="Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the conformance statement.  For example, process for becoming an authorized messaging exchange partner.")
        protected StringType documentation;
        @Child(name="event", type={}, order=4, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Declare support for this event", formalDefinition="A description of the solution's support for an event at this end-point.")
        protected List<ConformanceMessagingEventComponent> event;
        private static final long serialVersionUID = -712362545L;

        public List<ConformanceMessagingEndpointComponent> getEndpoint() {
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<ConformanceMessagingEndpointComponent>();
            }
            return this.endpoint;
        }

        public boolean hasEndpoint() {
            if (this.endpoint == null) {
                return false;
            }
            for (ConformanceMessagingEndpointComponent item : this.endpoint) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConformanceMessagingEndpointComponent addEndpoint() {
            ConformanceMessagingEndpointComponent t = new ConformanceMessagingEndpointComponent();
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<ConformanceMessagingEndpointComponent>();
            }
            this.endpoint.add(t);
            return t;
        }

        public ConformanceMessagingComponent addEndpoint(ConformanceMessagingEndpointComponent t) {
            if (t == null) {
                return this;
            }
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<ConformanceMessagingEndpointComponent>();
            }
            this.endpoint.add(t);
            return this;
        }

        public UnsignedIntType getReliableCacheElement() {
            if (this.reliableCache == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingComponent.reliableCache");
                }
                if (Configuration.doAutoCreate()) {
                    this.reliableCache = new UnsignedIntType();
                }
            }
            return this.reliableCache;
        }

        public boolean hasReliableCacheElement() {
            return this.reliableCache != null && !this.reliableCache.isEmpty();
        }

        public boolean hasReliableCache() {
            return this.reliableCache != null && !this.reliableCache.isEmpty();
        }

        public ConformanceMessagingComponent setReliableCacheElement(UnsignedIntType value) {
            this.reliableCache = value;
            return this;
        }

        public int getReliableCache() {
            return this.reliableCache == null || this.reliableCache.isEmpty() ? 0 : (Integer)this.reliableCache.getValue();
        }

        public ConformanceMessagingComponent setReliableCache(int value) {
            if (this.reliableCache == null) {
                this.reliableCache = new UnsignedIntType();
            }
            this.reliableCache.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceMessagingComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ConformanceMessagingComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ConformanceMessagingComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<ConformanceMessagingEventComponent> getEvent() {
            if (this.event == null) {
                this.event = new ArrayList<ConformanceMessagingEventComponent>();
            }
            return this.event;
        }

        public boolean hasEvent() {
            if (this.event == null) {
                return false;
            }
            for (ConformanceMessagingEventComponent item : this.event) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConformanceMessagingEventComponent addEvent() {
            ConformanceMessagingEventComponent t = new ConformanceMessagingEventComponent();
            if (this.event == null) {
                this.event = new ArrayList<ConformanceMessagingEventComponent>();
            }
            this.event.add(t);
            return t;
        }

        public ConformanceMessagingComponent addEvent(ConformanceMessagingEventComponent t) {
            if (t == null) {
                return this;
            }
            if (this.event == null) {
                this.event = new ArrayList<ConformanceMessagingEventComponent>();
            }
            this.event.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("endpoint", "", "An endpoint (network accessible address) to which messages and/or replies are to be sent.", 0, Integer.MAX_VALUE, this.endpoint));
            childrenList.add(new Property("reliableCache", "unsignedInt", "Length if the receiver's reliable messaging cache in minutes (if a receiver) or how long the cache length on the receiver should be (if a sender).", 0, Integer.MAX_VALUE, this.reliableCache));
            childrenList.add(new Property("documentation", "string", "Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the conformance statement.  For example, process for becoming an authorized messaging exchange partner.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property(Conformance.SP_EVENT, "", "A description of the solution's support for an event at this end-point.", 0, Integer.MAX_VALUE, this.event));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("endpoint")) {
                this.getEndpoint().add((ConformanceMessagingEndpointComponent)value);
            } else if (name.equals("reliableCache")) {
                this.reliableCache = this.castToUnsignedInt(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals(Conformance.SP_EVENT)) {
                this.getEvent().add((ConformanceMessagingEventComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("endpoint")) {
                return this.addEndpoint();
            }
            if (name.equals("reliableCache")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.reliableCache");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.documentation");
            }
            if (name.equals(Conformance.SP_EVENT)) {
                return this.addEvent();
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceMessagingComponent copy() {
            ConformanceMessagingComponent dst = new ConformanceMessagingComponent();
            this.copyValues(dst);
            if (this.endpoint != null) {
                dst.endpoint = new ArrayList<ConformanceMessagingEndpointComponent>();
                for (ConformanceMessagingEndpointComponent conformanceMessagingEndpointComponent : this.endpoint) {
                    dst.endpoint.add(conformanceMessagingEndpointComponent.copy());
                }
            }
            dst.reliableCache = this.reliableCache == null ? null : this.reliableCache.copy();
            StringType stringType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.event != null) {
                dst.event = new ArrayList<ConformanceMessagingEventComponent>();
                for (ConformanceMessagingEventComponent conformanceMessagingEventComponent : this.event) {
                    dst.event.add(conformanceMessagingEventComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceMessagingComponent)) {
                return false;
            }
            ConformanceMessagingComponent o = (ConformanceMessagingComponent)other;
            return ConformanceMessagingComponent.compareDeep(this.endpoint, o.endpoint, true) && ConformanceMessagingComponent.compareDeep(this.reliableCache, o.reliableCache, true) && ConformanceMessagingComponent.compareDeep(this.documentation, o.documentation, true) && ConformanceMessagingComponent.compareDeep(this.event, o.event, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceMessagingComponent)) {
                return false;
            }
            ConformanceMessagingComponent o = (ConformanceMessagingComponent)other;
            return ConformanceMessagingComponent.compareValues(this.reliableCache, o.reliableCache, true) && ConformanceMessagingComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.endpoint != null && !this.endpoint.isEmpty() || this.reliableCache != null && !this.reliableCache.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.event != null && !this.event.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.messaging";
        }
    }

    @Block
    public static class ConformanceRestOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name by which the operation/query is invoked", formalDefinition="The name of a query, which is used in the _query parameter when the query is called.")
        protected StringType name;
        @Child(name="definition", type={OperationDefinition.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The defined operation/query", formalDefinition="Where the formal definition can be found.")
        protected Reference definition;
        protected OperationDefinition definitionTarget;
        private static final long serialVersionUID = 122107272L;

        public ConformanceRestOperationComponent() {
        }

        public ConformanceRestOperationComponent(StringType name, Reference definition) {
            this.name = name;
            this.definition = definition;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestOperationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ConformanceRestOperationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ConformanceRestOperationComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Reference getDefinition() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestOperationComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new Reference();
                }
            }
            return this.definition;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public ConformanceRestOperationComponent setDefinition(Reference value) {
            this.definition = value;
            return this;
        }

        public OperationDefinition getDefinitionTarget() {
            if (this.definitionTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestOperationComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionTarget = new OperationDefinition();
                }
            }
            return this.definitionTarget;
        }

        public ConformanceRestOperationComponent setDefinitionTarget(OperationDefinition value) {
            this.definitionTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Conformance.SP_NAME, "string", "The name of a query, which is used in the _query parameter when the query is called.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("definition", "Reference(OperationDefinition)", "Where the formal definition can be found.", 0, Integer.MAX_VALUE, this.definition));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.name");
            }
            if (name.equals("definition")) {
                this.definition = new Reference();
                return this.definition;
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceRestOperationComponent copy() {
            ConformanceRestOperationComponent dst = new ConformanceRestOperationComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestOperationComponent)) {
                return false;
            }
            ConformanceRestOperationComponent o = (ConformanceRestOperationComponent)other;
            return ConformanceRestOperationComponent.compareDeep(this.name, o.name, true) && ConformanceRestOperationComponent.compareDeep(this.definition, o.definition, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestOperationComponent)) {
                return false;
            }
            ConformanceRestOperationComponent o = (ConformanceRestOperationComponent)other;
            return ConformanceRestOperationComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.definition != null && !this.definition.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest.operation";
        }
    }

    @Block
    public static class SystemInteractionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="transaction | search-system | history-system", formalDefinition="A coded identifier of the operation, supported by the system.")
        protected Enumeration<SystemRestfulInteraction> code;
        @Child(name="documentation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.")
        protected StringType documentation;
        private static final long serialVersionUID = 510675287L;

        public SystemInteractionComponent() {
        }

        public SystemInteractionComponent(Enumeration<SystemRestfulInteraction> code) {
            this.code = code;
        }

        public Enumeration<SystemRestfulInteraction> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SystemInteractionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<SystemRestfulInteraction>(new SystemRestfulInteractionEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SystemInteractionComponent setCodeElement(Enumeration<SystemRestfulInteraction> value) {
            this.code = value;
            return this;
        }

        public SystemRestfulInteraction getCode() {
            return this.code == null ? null : (SystemRestfulInteraction)((Object)this.code.getValue());
        }

        public SystemInteractionComponent setCode(SystemRestfulInteraction value) {
            if (this.code == null) {
                this.code = new Enumeration<SystemRestfulInteraction>(new SystemRestfulInteractionEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SystemInteractionComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public SystemInteractionComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public SystemInteractionComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "code", "A coded identifier of the operation, supported by the system.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("documentation", "string", "Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.", 0, Integer.MAX_VALUE, this.documentation));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = new SystemRestfulInteractionEnumFactory().fromType(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.code");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public SystemInteractionComponent copy() {
            SystemInteractionComponent dst = new SystemInteractionComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SystemInteractionComponent)) {
                return false;
            }
            SystemInteractionComponent o = (SystemInteractionComponent)other;
            return SystemInteractionComponent.compareDeep(this.code, o.code, true) && SystemInteractionComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SystemInteractionComponent)) {
                return false;
            }
            SystemInteractionComponent o = (SystemInteractionComponent)other;
            return SystemInteractionComponent.compareValues(this.code, o.code, true) && SystemInteractionComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.documentation != null && !this.documentation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest.interaction";
        }
    }

    @Block
    public static class ConformanceRestResourceSearchParamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of search parameter", formalDefinition="The name of the search parameter used in the interface.")
        protected StringType name;
        @Child(name="definition", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source of definition for parameter", formalDefinition="An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [[[SearchParameter.url]]]).")
        protected UriType definition;
        @Child(name="type", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted.")
        protected Enumeration<Enumerations.SearchParamType> type;
        @Child(name="documentation", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Server-specific usage", formalDefinition="This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.")
        protected StringType documentation;
        @Child(name="target", type={CodeType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Types of resource (if a resource reference)", formalDefinition="Types of resource (if a resource is referenced).")
        protected List<CodeType> target;
        @Child(name="modifier", type={CodeType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="missing | exact | contains | not | text | in | not-in | below | above | type", formalDefinition="A modifier supported for the search parameter.")
        protected List<Enumeration<SearchModifierCode>> modifier;
        @Child(name="chain", type={StringType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Chained names supported", formalDefinition="Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference, and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from Conformance.rest.resource.searchParam.name on the target resource type.")
        protected List<StringType> chain;
        private static final long serialVersionUID = -1020405086L;

        public ConformanceRestResourceSearchParamComponent() {
        }

        public ConformanceRestResourceSearchParamComponent(StringType name, Enumeration<Enumerations.SearchParamType> type) {
            this.name = name;
            this.type = type;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceSearchParamComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ConformanceRestResourceSearchParamComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ConformanceRestResourceSearchParamComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public UriType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceSearchParamComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new UriType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public ConformanceRestResourceSearchParamComponent setDefinitionElement(UriType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public ConformanceRestResourceSearchParamComponent setDefinition(String value) {
            if (Utilities.noString(value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new UriType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.SearchParamType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceSearchParamComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ConformanceRestResourceSearchParamComponent setTypeElement(Enumeration<Enumerations.SearchParamType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.SearchParamType getType() {
            return this.type == null ? null : (Enumerations.SearchParamType)((Object)this.type.getValue());
        }

        public ConformanceRestResourceSearchParamComponent setType(Enumerations.SearchParamType value) {
            if (this.type == null) {
                this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceSearchParamComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ConformanceRestResourceSearchParamComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ConformanceRestResourceSearchParamComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<CodeType> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<CodeType>();
            }
            return this.target;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (CodeType item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addTargetElement() {
            CodeType t = new CodeType();
            if (this.target == null) {
                this.target = new ArrayList<CodeType>();
            }
            this.target.add(t);
            return t;
        }

        public ConformanceRestResourceSearchParamComponent addTarget(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.target == null) {
                this.target = new ArrayList<CodeType>();
            }
            this.target.add(t);
            return this;
        }

        public boolean hasTarget(String value) {
            if (this.target == null) {
                return false;
            }
            for (CodeType v : this.target) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Enumeration<SearchModifierCode>> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
            }
            return this.modifier;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (Enumeration<SearchModifierCode> item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<SearchModifierCode> addModifierElement() {
            Enumeration<SearchModifierCode> t = new Enumeration<SearchModifierCode>(new SearchModifierCodeEnumFactory());
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
            }
            this.modifier.add(t);
            return t;
        }

        public ConformanceRestResourceSearchParamComponent addModifier(SearchModifierCode value) {
            Enumeration<SearchModifierCode> t = new Enumeration<SearchModifierCode>(new SearchModifierCodeEnumFactory());
            t.setValue((Object)value);
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
            }
            this.modifier.add(t);
            return this;
        }

        public boolean hasModifier(SearchModifierCode value) {
            if (this.modifier == null) {
                return false;
            }
            for (Enumeration<SearchModifierCode> v : this.modifier) {
                if (!v.equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getChain() {
            if (this.chain == null) {
                this.chain = new ArrayList<StringType>();
            }
            return this.chain;
        }

        public boolean hasChain() {
            if (this.chain == null) {
                return false;
            }
            for (StringType item : this.chain) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addChainElement() {
            StringType t = new StringType();
            if (this.chain == null) {
                this.chain = new ArrayList<StringType>();
            }
            this.chain.add(t);
            return t;
        }

        public ConformanceRestResourceSearchParamComponent addChain(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.chain == null) {
                this.chain = new ArrayList<StringType>();
            }
            this.chain.add(t);
            return this;
        }

        public boolean hasChain(String value) {
            if (this.chain == null) {
                return false;
            }
            for (StringType v : this.chain) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Conformance.SP_NAME, "string", "The name of the search parameter used in the interface.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("definition", "uri", "An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [[[SearchParameter.url]]]).", 0, Integer.MAX_VALUE, this.definition));
            childrenList.add(new Property("type", "code", "The type of value a search parameter refers to, and how the content is interpreted.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("documentation", "string", "This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property("target", "code", "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target));
            childrenList.add(new Property("modifier", "code", "A modifier supported for the search parameter.", 0, Integer.MAX_VALUE, this.modifier));
            childrenList.add(new Property("chain", "string", "Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference, and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from Conformance.rest.resource.searchParam.name on the target resource type.", 0, Integer.MAX_VALUE, this.chain));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = this.castToUri(value);
            } else if (name.equals("type")) {
                this.type = new Enumerations.SearchParamTypeEnumFactory().fromType(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals("target")) {
                this.getTarget().add(this.castToCode(value));
            } else if (name.equals("modifier")) {
                this.getModifier().add(new SearchModifierCodeEnumFactory().fromType(value));
            } else if (name.equals("chain")) {
                this.getChain().add(this.castToString(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.name");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.definition");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.type");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.documentation");
            }
            if (name.equals("target")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.target");
            }
            if (name.equals("modifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.modifier");
            }
            if (name.equals("chain")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.chain");
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceRestResourceSearchParamComponent copy() {
            ConformanceRestResourceSearchParamComponent dst = new ConformanceRestResourceSearchParamComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.target != null) {
                dst.target = new ArrayList<CodeType>();
                for (CodeType codeType : this.target) {
                    dst.target.add(codeType.copy());
                }
            }
            if (this.modifier != null) {
                dst.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
                for (Enumeration enumeration : this.modifier) {
                    dst.modifier.add((Enumeration<SearchModifierCode>)enumeration.copy());
                }
            }
            if (this.chain != null) {
                dst.chain = new ArrayList<StringType>();
                for (StringType stringType2 : this.chain) {
                    dst.chain.add(stringType2.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestResourceSearchParamComponent)) {
                return false;
            }
            ConformanceRestResourceSearchParamComponent o = (ConformanceRestResourceSearchParamComponent)other;
            return ConformanceRestResourceSearchParamComponent.compareDeep(this.name, o.name, true) && ConformanceRestResourceSearchParamComponent.compareDeep(this.definition, o.definition, true) && ConformanceRestResourceSearchParamComponent.compareDeep(this.type, o.type, true) && ConformanceRestResourceSearchParamComponent.compareDeep(this.documentation, o.documentation, true) && ConformanceRestResourceSearchParamComponent.compareDeep(this.target, o.target, true) && ConformanceRestResourceSearchParamComponent.compareDeep(this.modifier, o.modifier, true) && ConformanceRestResourceSearchParamComponent.compareDeep(this.chain, o.chain, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestResourceSearchParamComponent)) {
                return false;
            }
            ConformanceRestResourceSearchParamComponent o = (ConformanceRestResourceSearchParamComponent)other;
            return ConformanceRestResourceSearchParamComponent.compareValues(this.name, o.name, true) && ConformanceRestResourceSearchParamComponent.compareValues(this.definition, o.definition, true) && ConformanceRestResourceSearchParamComponent.compareValues(this.type, o.type, true) && ConformanceRestResourceSearchParamComponent.compareValues(this.documentation, o.documentation, true) && ConformanceRestResourceSearchParamComponent.compareValues(this.target, o.target, true) && ConformanceRestResourceSearchParamComponent.compareValues(this.modifier, o.modifier, true) && ConformanceRestResourceSearchParamComponent.compareValues(this.chain, o.chain, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.definition != null && !this.definition.isEmpty() || this.type != null && !this.type.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.target != null && !this.target.isEmpty() || this.modifier != null && !this.modifier.isEmpty() || this.chain != null && !this.chain.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest.resource.searchParam";
        }
    }

    @Block
    public static class ResourceInteractionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="read | vread | update | delete | history-instance | validate | history-type | create | search-type", formalDefinition="Coded identifier of the operation, supported by the system resource.")
        protected Enumeration<TypeRestfulInteraction> code;
        @Child(name="documentation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.")
        protected StringType documentation;
        private static final long serialVersionUID = -437507806L;

        public ResourceInteractionComponent() {
        }

        public ResourceInteractionComponent(Enumeration<TypeRestfulInteraction> code) {
            this.code = code;
        }

        public Enumeration<TypeRestfulInteraction> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResourceInteractionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<TypeRestfulInteraction>(new TypeRestfulInteractionEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ResourceInteractionComponent setCodeElement(Enumeration<TypeRestfulInteraction> value) {
            this.code = value;
            return this;
        }

        public TypeRestfulInteraction getCode() {
            return this.code == null ? null : (TypeRestfulInteraction)((Object)this.code.getValue());
        }

        public ResourceInteractionComponent setCode(TypeRestfulInteraction value) {
            if (this.code == null) {
                this.code = new Enumeration<TypeRestfulInteraction>(new TypeRestfulInteractionEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResourceInteractionComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ResourceInteractionComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ResourceInteractionComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "code", "Coded identifier of the operation, supported by the system resource.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("documentation", "string", "Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.", 0, Integer.MAX_VALUE, this.documentation));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = new TypeRestfulInteractionEnumFactory().fromType(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.code");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public ResourceInteractionComponent copy() {
            ResourceInteractionComponent dst = new ResourceInteractionComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ResourceInteractionComponent)) {
                return false;
            }
            ResourceInteractionComponent o = (ResourceInteractionComponent)other;
            return ResourceInteractionComponent.compareDeep(this.code, o.code, true) && ResourceInteractionComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ResourceInteractionComponent)) {
                return false;
            }
            ResourceInteractionComponent o = (ResourceInteractionComponent)other;
            return ResourceInteractionComponent.compareValues(this.code, o.code, true) && ResourceInteractionComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.documentation != null && !this.documentation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest.resource.interaction";
        }
    }

    @Block
    public static class ConformanceRestResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A resource type that is supported", formalDefinition="A type of resource exposed via the restful interface.")
        protected CodeType type;
        @Child(name="profile", type={StructureDefinition.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Base System profile for all uses of resource", formalDefinition="A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles]{profiling.html#profile-uses}.")
        protected Reference profile;
        protected StructureDefinition profileTarget;
        @Child(name="interaction", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="Identifies a restful operation supported by the solution.")
        protected List<ResourceInteractionComponent> interaction;
        @Child(name="versioning", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="no-version | versioned | versioned-update", formalDefinition="This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API.")
        protected Enumeration<ResourceVersionPolicy> versioning;
        @Child(name="readHistory", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether vRead can return past versions", formalDefinition="A flag for whether the server is able to return past versions as part of the vRead operation.")
        protected BooleanType readHistory;
        @Child(name="updateCreate", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If update can commit to a new identity", formalDefinition="A flag to indicate that the server allows or needs to allow the client to create new identities on the server (e.g. that is, the client PUTs to a location where there is no existing resource). Allowing this operation means that the server allows the client to create new identities on the server.")
        protected BooleanType updateCreate;
        @Child(name="conditionalCreate", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If allows/uses conditional create", formalDefinition="A flag that indicates that the server supports conditional create.")
        protected BooleanType conditionalCreate;
        @Child(name="conditionalUpdate", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If allows/uses conditional update", formalDefinition="A flag that indicates that the server supports conditional update.")
        protected BooleanType conditionalUpdate;
        @Child(name="conditionalDelete", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="not-supported | single | multiple - how conditional delete is supported", formalDefinition="A code that indicates how the server supports conditional delete.")
        protected Enumeration<ConditionalDeleteStatus> conditionalDelete;
        @Child(name="searchInclude", type={StringType.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="_include values supported by the server", formalDefinition="A list of _include values supported by the server.")
        protected List<StringType> searchInclude;
        @Child(name="searchRevInclude", type={StringType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="_revinclude values supported by the server", formalDefinition="A list of _revinclude (reverse include) values supported by the server.")
        protected List<StringType> searchRevInclude;
        @Child(name="searchParam", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Search params supported by implementation", formalDefinition="Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.")
        protected List<ConformanceRestResourceSearchParamComponent> searchParam;
        private static final long serialVersionUID = 1781959905L;

        public ConformanceRestResourceComponent() {
        }

        public ConformanceRestResourceComponent(CodeType type) {
            this.type = type;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ConformanceRestResourceComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ConformanceRestResourceComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public Reference getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Reference();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ConformanceRestResourceComponent setProfile(Reference value) {
            this.profile = value;
            return this;
        }

        public StructureDefinition getProfileTarget() {
            if (this.profileTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profileTarget = new StructureDefinition();
                }
            }
            return this.profileTarget;
        }

        public ConformanceRestResourceComponent setProfileTarget(StructureDefinition value) {
            this.profileTarget = value;
            return this;
        }

        public List<ResourceInteractionComponent> getInteraction() {
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            return this.interaction;
        }

        public boolean hasInteraction() {
            if (this.interaction == null) {
                return false;
            }
            for (ResourceInteractionComponent item : this.interaction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ResourceInteractionComponent addInteraction() {
            ResourceInteractionComponent t = new ResourceInteractionComponent();
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            this.interaction.add(t);
            return t;
        }

        public ConformanceRestResourceComponent addInteraction(ResourceInteractionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            this.interaction.add(t);
            return this;
        }

        public Enumeration<ResourceVersionPolicy> getVersioningElement() {
            if (this.versioning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.versioning");
                }
                if (Configuration.doAutoCreate()) {
                    this.versioning = new Enumeration<ResourceVersionPolicy>(new ResourceVersionPolicyEnumFactory());
                }
            }
            return this.versioning;
        }

        public boolean hasVersioningElement() {
            return this.versioning != null && !this.versioning.isEmpty();
        }

        public boolean hasVersioning() {
            return this.versioning != null && !this.versioning.isEmpty();
        }

        public ConformanceRestResourceComponent setVersioningElement(Enumeration<ResourceVersionPolicy> value) {
            this.versioning = value;
            return this;
        }

        public ResourceVersionPolicy getVersioning() {
            return this.versioning == null ? null : (ResourceVersionPolicy)((Object)this.versioning.getValue());
        }

        public ConformanceRestResourceComponent setVersioning(ResourceVersionPolicy value) {
            if (value == null) {
                this.versioning = null;
            } else {
                if (this.versioning == null) {
                    this.versioning = new Enumeration<ResourceVersionPolicy>(new ResourceVersionPolicyEnumFactory());
                }
                this.versioning.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getReadHistoryElement() {
            if (this.readHistory == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.readHistory");
                }
                if (Configuration.doAutoCreate()) {
                    this.readHistory = new BooleanType();
                }
            }
            return this.readHistory;
        }

        public boolean hasReadHistoryElement() {
            return this.readHistory != null && !this.readHistory.isEmpty();
        }

        public boolean hasReadHistory() {
            return this.readHistory != null && !this.readHistory.isEmpty();
        }

        public ConformanceRestResourceComponent setReadHistoryElement(BooleanType value) {
            this.readHistory = value;
            return this;
        }

        public boolean getReadHistory() {
            return this.readHistory == null || this.readHistory.isEmpty() ? false : (Boolean)this.readHistory.getValue();
        }

        public ConformanceRestResourceComponent setReadHistory(boolean value) {
            if (this.readHistory == null) {
                this.readHistory = new BooleanType();
            }
            this.readHistory.setValue((Object)value);
            return this;
        }

        public BooleanType getUpdateCreateElement() {
            if (this.updateCreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.updateCreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.updateCreate = new BooleanType();
                }
            }
            return this.updateCreate;
        }

        public boolean hasUpdateCreateElement() {
            return this.updateCreate != null && !this.updateCreate.isEmpty();
        }

        public boolean hasUpdateCreate() {
            return this.updateCreate != null && !this.updateCreate.isEmpty();
        }

        public ConformanceRestResourceComponent setUpdateCreateElement(BooleanType value) {
            this.updateCreate = value;
            return this;
        }

        public boolean getUpdateCreate() {
            return this.updateCreate == null || this.updateCreate.isEmpty() ? false : (Boolean)this.updateCreate.getValue();
        }

        public ConformanceRestResourceComponent setUpdateCreate(boolean value) {
            if (this.updateCreate == null) {
                this.updateCreate = new BooleanType();
            }
            this.updateCreate.setValue((Object)value);
            return this;
        }

        public BooleanType getConditionalCreateElement() {
            if (this.conditionalCreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.conditionalCreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionalCreate = new BooleanType();
                }
            }
            return this.conditionalCreate;
        }

        public boolean hasConditionalCreateElement() {
            return this.conditionalCreate != null && !this.conditionalCreate.isEmpty();
        }

        public boolean hasConditionalCreate() {
            return this.conditionalCreate != null && !this.conditionalCreate.isEmpty();
        }

        public ConformanceRestResourceComponent setConditionalCreateElement(BooleanType value) {
            this.conditionalCreate = value;
            return this;
        }

        public boolean getConditionalCreate() {
            return this.conditionalCreate == null || this.conditionalCreate.isEmpty() ? false : (Boolean)this.conditionalCreate.getValue();
        }

        public ConformanceRestResourceComponent setConditionalCreate(boolean value) {
            if (this.conditionalCreate == null) {
                this.conditionalCreate = new BooleanType();
            }
            this.conditionalCreate.setValue((Object)value);
            return this;
        }

        public BooleanType getConditionalUpdateElement() {
            if (this.conditionalUpdate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.conditionalUpdate");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionalUpdate = new BooleanType();
                }
            }
            return this.conditionalUpdate;
        }

        public boolean hasConditionalUpdateElement() {
            return this.conditionalUpdate != null && !this.conditionalUpdate.isEmpty();
        }

        public boolean hasConditionalUpdate() {
            return this.conditionalUpdate != null && !this.conditionalUpdate.isEmpty();
        }

        public ConformanceRestResourceComponent setConditionalUpdateElement(BooleanType value) {
            this.conditionalUpdate = value;
            return this;
        }

        public boolean getConditionalUpdate() {
            return this.conditionalUpdate == null || this.conditionalUpdate.isEmpty() ? false : (Boolean)this.conditionalUpdate.getValue();
        }

        public ConformanceRestResourceComponent setConditionalUpdate(boolean value) {
            if (this.conditionalUpdate == null) {
                this.conditionalUpdate = new BooleanType();
            }
            this.conditionalUpdate.setValue((Object)value);
            return this;
        }

        public Enumeration<ConditionalDeleteStatus> getConditionalDeleteElement() {
            if (this.conditionalDelete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestResourceComponent.conditionalDelete");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionalDelete = new Enumeration<ConditionalDeleteStatus>(new ConditionalDeleteStatusEnumFactory());
                }
            }
            return this.conditionalDelete;
        }

        public boolean hasConditionalDeleteElement() {
            return this.conditionalDelete != null && !this.conditionalDelete.isEmpty();
        }

        public boolean hasConditionalDelete() {
            return this.conditionalDelete != null && !this.conditionalDelete.isEmpty();
        }

        public ConformanceRestResourceComponent setConditionalDeleteElement(Enumeration<ConditionalDeleteStatus> value) {
            this.conditionalDelete = value;
            return this;
        }

        public ConditionalDeleteStatus getConditionalDelete() {
            return this.conditionalDelete == null ? null : (ConditionalDeleteStatus)((Object)this.conditionalDelete.getValue());
        }

        public ConformanceRestResourceComponent setConditionalDelete(ConditionalDeleteStatus value) {
            if (value == null) {
                this.conditionalDelete = null;
            } else {
                if (this.conditionalDelete == null) {
                    this.conditionalDelete = new Enumeration<ConditionalDeleteStatus>(new ConditionalDeleteStatusEnumFactory());
                }
                this.conditionalDelete.setValue((Object)value);
            }
            return this;
        }

        public List<StringType> getSearchInclude() {
            if (this.searchInclude == null) {
                this.searchInclude = new ArrayList<StringType>();
            }
            return this.searchInclude;
        }

        public boolean hasSearchInclude() {
            if (this.searchInclude == null) {
                return false;
            }
            for (StringType item : this.searchInclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addSearchIncludeElement() {
            StringType t = new StringType();
            if (this.searchInclude == null) {
                this.searchInclude = new ArrayList<StringType>();
            }
            this.searchInclude.add(t);
            return t;
        }

        public ConformanceRestResourceComponent addSearchInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.searchInclude == null) {
                this.searchInclude = new ArrayList<StringType>();
            }
            this.searchInclude.add(t);
            return this;
        }

        public boolean hasSearchInclude(String value) {
            if (this.searchInclude == null) {
                return false;
            }
            for (StringType v : this.searchInclude) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getSearchRevInclude() {
            if (this.searchRevInclude == null) {
                this.searchRevInclude = new ArrayList<StringType>();
            }
            return this.searchRevInclude;
        }

        public boolean hasSearchRevInclude() {
            if (this.searchRevInclude == null) {
                return false;
            }
            for (StringType item : this.searchRevInclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addSearchRevIncludeElement() {
            StringType t = new StringType();
            if (this.searchRevInclude == null) {
                this.searchRevInclude = new ArrayList<StringType>();
            }
            this.searchRevInclude.add(t);
            return t;
        }

        public ConformanceRestResourceComponent addSearchRevInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.searchRevInclude == null) {
                this.searchRevInclude = new ArrayList<StringType>();
            }
            this.searchRevInclude.add(t);
            return this;
        }

        public boolean hasSearchRevInclude(String value) {
            if (this.searchRevInclude == null) {
                return false;
            }
            for (StringType v : this.searchRevInclude) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ConformanceRestResourceSearchParamComponent> getSearchParam() {
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            }
            return this.searchParam;
        }

        public boolean hasSearchParam() {
            if (this.searchParam == null) {
                return false;
            }
            for (ConformanceRestResourceSearchParamComponent item : this.searchParam) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConformanceRestResourceSearchParamComponent addSearchParam() {
            ConformanceRestResourceSearchParamComponent t = new ConformanceRestResourceSearchParamComponent();
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return t;
        }

        public ConformanceRestResourceComponent addSearchParam(ConformanceRestResourceSearchParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "A type of resource exposed via the restful interface.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(Conformance.SP_PROFILE, "Reference(StructureDefinition)", "A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles]{profiling.html#profile-uses}.", 0, Integer.MAX_VALUE, this.profile));
            childrenList.add(new Property("interaction", "", "Identifies a restful operation supported by the solution.", 0, Integer.MAX_VALUE, this.interaction));
            childrenList.add(new Property("versioning", "code", "This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API.", 0, Integer.MAX_VALUE, this.versioning));
            childrenList.add(new Property("readHistory", "boolean", "A flag for whether the server is able to return past versions as part of the vRead operation.", 0, Integer.MAX_VALUE, this.readHistory));
            childrenList.add(new Property("updateCreate", "boolean", "A flag to indicate that the server allows or needs to allow the client to create new identities on the server (e.g. that is, the client PUTs to a location where there is no existing resource). Allowing this operation means that the server allows the client to create new identities on the server.", 0, Integer.MAX_VALUE, this.updateCreate));
            childrenList.add(new Property("conditionalCreate", "boolean", "A flag that indicates that the server supports conditional create.", 0, Integer.MAX_VALUE, this.conditionalCreate));
            childrenList.add(new Property("conditionalUpdate", "boolean", "A flag that indicates that the server supports conditional update.", 0, Integer.MAX_VALUE, this.conditionalUpdate));
            childrenList.add(new Property("conditionalDelete", "code", "A code that indicates how the server supports conditional delete.", 0, Integer.MAX_VALUE, this.conditionalDelete));
            childrenList.add(new Property("searchInclude", "string", "A list of _include values supported by the server.", 0, Integer.MAX_VALUE, this.searchInclude));
            childrenList.add(new Property("searchRevInclude", "string", "A list of _revinclude (reverse include) values supported by the server.", 0, Integer.MAX_VALUE, this.searchRevInclude));
            childrenList.add(new Property("searchParam", "", "Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals(Conformance.SP_PROFILE)) {
                this.profile = this.castToReference(value);
            } else if (name.equals("interaction")) {
                this.getInteraction().add((ResourceInteractionComponent)value);
            } else if (name.equals("versioning")) {
                this.versioning = new ResourceVersionPolicyEnumFactory().fromType(value);
            } else if (name.equals("readHistory")) {
                this.readHistory = this.castToBoolean(value);
            } else if (name.equals("updateCreate")) {
                this.updateCreate = this.castToBoolean(value);
            } else if (name.equals("conditionalCreate")) {
                this.conditionalCreate = this.castToBoolean(value);
            } else if (name.equals("conditionalUpdate")) {
                this.conditionalUpdate = this.castToBoolean(value);
            } else if (name.equals("conditionalDelete")) {
                this.conditionalDelete = new ConditionalDeleteStatusEnumFactory().fromType(value);
            } else if (name.equals("searchInclude")) {
                this.getSearchInclude().add(this.castToString(value));
            } else if (name.equals("searchRevInclude")) {
                this.getSearchRevInclude().add(this.castToString(value));
            } else if (name.equals("searchParam")) {
                this.getSearchParam().add((ConformanceRestResourceSearchParamComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.type");
            }
            if (name.equals(Conformance.SP_PROFILE)) {
                this.profile = new Reference();
                return this.profile;
            }
            if (name.equals("interaction")) {
                return this.addInteraction();
            }
            if (name.equals("versioning")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.versioning");
            }
            if (name.equals("readHistory")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.readHistory");
            }
            if (name.equals("updateCreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.updateCreate");
            }
            if (name.equals("conditionalCreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.conditionalCreate");
            }
            if (name.equals("conditionalUpdate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.conditionalUpdate");
            }
            if (name.equals("conditionalDelete")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.conditionalDelete");
            }
            if (name.equals("searchInclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.searchInclude");
            }
            if (name.equals("searchRevInclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.searchRevInclude");
            }
            if (name.equals("searchParam")) {
                return this.addSearchParam();
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceRestResourceComponent copy() {
            ConformanceRestResourceComponent dst = new ConformanceRestResourceComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Reference reference = dst.profile = this.profile == null ? null : this.profile.copy();
            if (this.interaction != null) {
                dst.interaction = new ArrayList<ResourceInteractionComponent>();
                for (ResourceInteractionComponent resourceInteractionComponent : this.interaction) {
                    dst.interaction.add(resourceInteractionComponent.copy());
                }
            }
            dst.versioning = this.versioning == null ? null : this.versioning.copy();
            dst.readHistory = this.readHistory == null ? null : this.readHistory.copy();
            dst.updateCreate = this.updateCreate == null ? null : this.updateCreate.copy();
            dst.conditionalCreate = this.conditionalCreate == null ? null : this.conditionalCreate.copy();
            dst.conditionalUpdate = this.conditionalUpdate == null ? null : this.conditionalUpdate.copy();
            Enumeration<ConditionalDeleteStatus> enumeration = dst.conditionalDelete = this.conditionalDelete == null ? null : this.conditionalDelete.copy();
            if (this.searchInclude != null) {
                dst.searchInclude = new ArrayList<StringType>();
                for (StringType stringType : this.searchInclude) {
                    dst.searchInclude.add(stringType.copy());
                }
            }
            if (this.searchRevInclude != null) {
                dst.searchRevInclude = new ArrayList<StringType>();
                for (StringType stringType : this.searchRevInclude) {
                    dst.searchRevInclude.add(stringType.copy());
                }
            }
            if (this.searchParam != null) {
                dst.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
                for (ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : this.searchParam) {
                    dst.searchParam.add(conformanceRestResourceSearchParamComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestResourceComponent)) {
                return false;
            }
            ConformanceRestResourceComponent o = (ConformanceRestResourceComponent)other;
            return ConformanceRestResourceComponent.compareDeep(this.type, o.type, true) && ConformanceRestResourceComponent.compareDeep(this.profile, o.profile, true) && ConformanceRestResourceComponent.compareDeep(this.interaction, o.interaction, true) && ConformanceRestResourceComponent.compareDeep(this.versioning, o.versioning, true) && ConformanceRestResourceComponent.compareDeep(this.readHistory, o.readHistory, true) && ConformanceRestResourceComponent.compareDeep(this.updateCreate, o.updateCreate, true) && ConformanceRestResourceComponent.compareDeep(this.conditionalCreate, o.conditionalCreate, true) && ConformanceRestResourceComponent.compareDeep(this.conditionalUpdate, o.conditionalUpdate, true) && ConformanceRestResourceComponent.compareDeep(this.conditionalDelete, o.conditionalDelete, true) && ConformanceRestResourceComponent.compareDeep(this.searchInclude, o.searchInclude, true) && ConformanceRestResourceComponent.compareDeep(this.searchRevInclude, o.searchRevInclude, true) && ConformanceRestResourceComponent.compareDeep(this.searchParam, o.searchParam, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestResourceComponent)) {
                return false;
            }
            ConformanceRestResourceComponent o = (ConformanceRestResourceComponent)other;
            return ConformanceRestResourceComponent.compareValues(this.type, o.type, true) && ConformanceRestResourceComponent.compareValues(this.versioning, o.versioning, true) && ConformanceRestResourceComponent.compareValues(this.readHistory, o.readHistory, true) && ConformanceRestResourceComponent.compareValues(this.updateCreate, o.updateCreate, true) && ConformanceRestResourceComponent.compareValues(this.conditionalCreate, o.conditionalCreate, true) && ConformanceRestResourceComponent.compareValues(this.conditionalUpdate, o.conditionalUpdate, true) && ConformanceRestResourceComponent.compareValues(this.conditionalDelete, o.conditionalDelete, true) && ConformanceRestResourceComponent.compareValues(this.searchInclude, o.searchInclude, true) && ConformanceRestResourceComponent.compareValues(this.searchRevInclude, o.searchRevInclude, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.interaction != null && !this.interaction.isEmpty() || this.versioning != null && !this.versioning.isEmpty() || this.readHistory != null && !this.readHistory.isEmpty() || this.updateCreate != null && !this.updateCreate.isEmpty() || this.conditionalCreate != null && !this.conditionalCreate.isEmpty() || this.conditionalUpdate != null && !this.conditionalUpdate.isEmpty() || this.conditionalDelete != null && !this.conditionalDelete.isEmpty() || this.searchInclude != null && !this.searchInclude.isEmpty() || this.searchRevInclude != null && !this.searchRevInclude.isEmpty() || this.searchParam != null && !this.searchParam.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest.resource";
        }
    }

    @Block
    public static class ConformanceRestSecurityCertificateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Mime type for certificate", formalDefinition="Mime type for certificate.")
        protected CodeType type;
        @Child(name="blob", type={Base64BinaryType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Actual certificate", formalDefinition="Actual certificate.")
        protected Base64BinaryType blob;
        private static final long serialVersionUID = 2092655854L;

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestSecurityCertificateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ConformanceRestSecurityCertificateComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ConformanceRestSecurityCertificateComponent setType(String value) {
            if (Utilities.noString(value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new CodeType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public Base64BinaryType getBlobElement() {
            if (this.blob == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestSecurityCertificateComponent.blob");
                }
                if (Configuration.doAutoCreate()) {
                    this.blob = new Base64BinaryType();
                }
            }
            return this.blob;
        }

        public boolean hasBlobElement() {
            return this.blob != null && !this.blob.isEmpty();
        }

        public boolean hasBlob() {
            return this.blob != null && !this.blob.isEmpty();
        }

        public ConformanceRestSecurityCertificateComponent setBlobElement(Base64BinaryType value) {
            this.blob = value;
            return this;
        }

        public byte[] getBlob() {
            return this.blob == null ? null : (byte[])this.blob.getValue();
        }

        public ConformanceRestSecurityCertificateComponent setBlob(byte[] value) {
            if (value == null) {
                this.blob = null;
            } else {
                if (this.blob == null) {
                    this.blob = new Base64BinaryType();
                }
                this.blob.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "Mime type for certificate.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("blob", "base64Binary", "Actual certificate.", 0, Integer.MAX_VALUE, this.blob));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("blob")) {
                this.blob = this.castToBase64Binary(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.type");
            }
            if (name.equals("blob")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.blob");
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceRestSecurityCertificateComponent copy() {
            ConformanceRestSecurityCertificateComponent dst = new ConformanceRestSecurityCertificateComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.blob = this.blob == null ? null : this.blob.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestSecurityCertificateComponent)) {
                return false;
            }
            ConformanceRestSecurityCertificateComponent o = (ConformanceRestSecurityCertificateComponent)other;
            return ConformanceRestSecurityCertificateComponent.compareDeep(this.type, o.type, true) && ConformanceRestSecurityCertificateComponent.compareDeep(this.blob, o.blob, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestSecurityCertificateComponent)) {
                return false;
            }
            ConformanceRestSecurityCertificateComponent o = (ConformanceRestSecurityCertificateComponent)other;
            return ConformanceRestSecurityCertificateComponent.compareValues(this.type, o.type, true) && ConformanceRestSecurityCertificateComponent.compareValues(this.blob, o.blob, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.blob != null && !this.blob.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest.security.certificate";
        }
    }

    @Block
    public static class ConformanceRestSecurityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="cors", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adds CORS Headers (http://enable-cors.org/)", formalDefinition="Server adds CORS headers when responding to requests - this enables javascript applications to use the server.")
        protected BooleanType cors;
        @Child(name="service", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="OAuth | SMART-on-FHIR | NTLM | Basic | Kerberos | Certificates", formalDefinition="Types of security services are supported/required by the system.")
        protected List<CodeableConcept> service;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General description of how security works", formalDefinition="General description of how security works.")
        protected StringType description;
        @Child(name="certificate", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Certificates associated with security profiles", formalDefinition="Certificates associated with security profiles.")
        protected List<ConformanceRestSecurityCertificateComponent> certificate;
        private static final long serialVersionUID = 391663952L;

        public BooleanType getCorsElement() {
            if (this.cors == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestSecurityComponent.cors");
                }
                if (Configuration.doAutoCreate()) {
                    this.cors = new BooleanType();
                }
            }
            return this.cors;
        }

        public boolean hasCorsElement() {
            return this.cors != null && !this.cors.isEmpty();
        }

        public boolean hasCors() {
            return this.cors != null && !this.cors.isEmpty();
        }

        public ConformanceRestSecurityComponent setCorsElement(BooleanType value) {
            this.cors = value;
            return this;
        }

        public boolean getCors() {
            return this.cors == null || this.cors.isEmpty() ? false : (Boolean)this.cors.getValue();
        }

        public ConformanceRestSecurityComponent setCors(boolean value) {
            if (this.cors == null) {
                this.cors = new BooleanType();
            }
            this.cors.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getService() {
            if (this.service == null) {
                this.service = new ArrayList<CodeableConcept>();
            }
            return this.service;
        }

        public boolean hasService() {
            if (this.service == null) {
                return false;
            }
            for (CodeableConcept item : this.service) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addService() {
            CodeableConcept t = new CodeableConcept();
            if (this.service == null) {
                this.service = new ArrayList<CodeableConcept>();
            }
            this.service.add(t);
            return t;
        }

        public ConformanceRestSecurityComponent addService(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.service == null) {
                this.service = new ArrayList<CodeableConcept>();
            }
            this.service.add(t);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestSecurityComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ConformanceRestSecurityComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ConformanceRestSecurityComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ConformanceRestSecurityCertificateComponent> getCertificate() {
            if (this.certificate == null) {
                this.certificate = new ArrayList<ConformanceRestSecurityCertificateComponent>();
            }
            return this.certificate;
        }

        public boolean hasCertificate() {
            if (this.certificate == null) {
                return false;
            }
            for (ConformanceRestSecurityCertificateComponent item : this.certificate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConformanceRestSecurityCertificateComponent addCertificate() {
            ConformanceRestSecurityCertificateComponent t = new ConformanceRestSecurityCertificateComponent();
            if (this.certificate == null) {
                this.certificate = new ArrayList<ConformanceRestSecurityCertificateComponent>();
            }
            this.certificate.add(t);
            return t;
        }

        public ConformanceRestSecurityComponent addCertificate(ConformanceRestSecurityCertificateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.certificate == null) {
                this.certificate = new ArrayList<ConformanceRestSecurityCertificateComponent>();
            }
            this.certificate.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("cors", "boolean", "Server adds CORS headers when responding to requests - this enables javascript applications to use the server.", 0, Integer.MAX_VALUE, this.cors));
            childrenList.add(new Property("service", "CodeableConcept", "Types of security services are supported/required by the system.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property(Conformance.SP_DESCRIPTION, "string", "General description of how security works.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("certificate", "", "Certificates associated with security profiles.", 0, Integer.MAX_VALUE, this.certificate));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("cors")) {
                this.cors = this.castToBoolean(value);
            } else if (name.equals("service")) {
                this.getService().add(this.castToCodeableConcept(value));
            } else if (name.equals(Conformance.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("certificate")) {
                this.getCertificate().add((ConformanceRestSecurityCertificateComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("cors")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.cors");
            }
            if (name.equals("service")) {
                return this.addService();
            }
            if (name.equals(Conformance.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.description");
            }
            if (name.equals("certificate")) {
                return this.addCertificate();
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceRestSecurityComponent copy() {
            ConformanceRestSecurityComponent dst = new ConformanceRestSecurityComponent();
            this.copyValues(dst);
            BooleanType booleanType = dst.cors = this.cors == null ? null : this.cors.copy();
            if (this.service != null) {
                dst.service = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.service) {
                    dst.service.add(codeableConcept.copy());
                }
            }
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.certificate != null) {
                dst.certificate = new ArrayList<ConformanceRestSecurityCertificateComponent>();
                for (ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent : this.certificate) {
                    dst.certificate.add(conformanceRestSecurityCertificateComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestSecurityComponent)) {
                return false;
            }
            ConformanceRestSecurityComponent o = (ConformanceRestSecurityComponent)other;
            return ConformanceRestSecurityComponent.compareDeep(this.cors, o.cors, true) && ConformanceRestSecurityComponent.compareDeep(this.service, o.service, true) && ConformanceRestSecurityComponent.compareDeep(this.description, o.description, true) && ConformanceRestSecurityComponent.compareDeep(this.certificate, o.certificate, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestSecurityComponent)) {
                return false;
            }
            ConformanceRestSecurityComponent o = (ConformanceRestSecurityComponent)other;
            return ConformanceRestSecurityComponent.compareValues(this.cors, o.cors, true) && ConformanceRestSecurityComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.cors != null && !this.cors.isEmpty() || this.service != null && !this.service.isEmpty() || this.description != null && !this.description.isEmpty() || this.certificate != null && !this.certificate.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest.security";
        }
    }

    @Block
    public static class ConformanceRestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="client | server", formalDefinition="Identifies whether this portion of the statement is describing ability to initiate or receive restful operations.")
        protected Enumeration<RestfulConformanceMode> mode;
        @Child(name="documentation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General description of implementation", formalDefinition="Information about the system's restful capabilities that apply across all applications, such as security.")
        protected StringType documentation;
        @Child(name="security", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information about security of implementation", formalDefinition="Information about security implementation from an interface perspective - what a client needs to know.")
        protected ConformanceRestSecurityComponent security;
        @Child(name="resource", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Resource served on the REST interface", formalDefinition="A specification of the restful capabilities of the solution for a specific resource type.")
        protected List<ConformanceRestResourceComponent> resource;
        @Child(name="interaction", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="A specification of restful operations supported by the system.")
        protected List<SystemInteractionComponent> interaction;
        @Child(name="transactionMode", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="not-supported | batch | transaction | both", formalDefinition="A code that indicates how transactions are supported.")
        protected Enumeration<TransactionMode> transactionMode;
        @Child(name="searchParam", type={ConformanceRestResourceSearchParamComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Search params for searching all resources", formalDefinition="Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.")
        protected List<ConformanceRestResourceSearchParamComponent> searchParam;
        @Child(name="operation", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of an operation or a custom query", formalDefinition="Definition of an operation or a named query and with its parameters and their meaning and type.")
        protected List<ConformanceRestOperationComponent> operation;
        @Child(name="compartment", type={UriType.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Compartments served/used by system", formalDefinition="An absolute URI which is a reference to the definition of a compartment hosted by the system.")
        protected List<UriType> compartment;
        private static final long serialVersionUID = 931983837L;

        public ConformanceRestComponent() {
        }

        public ConformanceRestComponent(Enumeration<RestfulConformanceMode> mode) {
            this.mode = mode;
        }

        public Enumeration<RestfulConformanceMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<RestfulConformanceMode>(new RestfulConformanceModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ConformanceRestComponent setModeElement(Enumeration<RestfulConformanceMode> value) {
            this.mode = value;
            return this;
        }

        public RestfulConformanceMode getMode() {
            return this.mode == null ? null : (RestfulConformanceMode)((Object)this.mode.getValue());
        }

        public ConformanceRestComponent setMode(RestfulConformanceMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<RestfulConformanceMode>(new RestfulConformanceModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ConformanceRestComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ConformanceRestComponent setDocumentation(String value) {
            if (Utilities.noString(value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public ConformanceRestSecurityComponent getSecurity() {
            if (this.security == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestComponent.security");
                }
                if (Configuration.doAutoCreate()) {
                    this.security = new ConformanceRestSecurityComponent();
                }
            }
            return this.security;
        }

        public boolean hasSecurity() {
            return this.security != null && !this.security.isEmpty();
        }

        public ConformanceRestComponent setSecurity(ConformanceRestSecurityComponent value) {
            this.security = value;
            return this;
        }

        public List<ConformanceRestResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<ConformanceRestResourceComponent>();
            }
            return this.resource;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (ConformanceRestResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConformanceRestResourceComponent addResource() {
            ConformanceRestResourceComponent t = new ConformanceRestResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<ConformanceRestResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public ConformanceRestComponent addResource(ConformanceRestResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<ConformanceRestResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public List<SystemInteractionComponent> getInteraction() {
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            return this.interaction;
        }

        public boolean hasInteraction() {
            if (this.interaction == null) {
                return false;
            }
            for (SystemInteractionComponent item : this.interaction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SystemInteractionComponent addInteraction() {
            SystemInteractionComponent t = new SystemInteractionComponent();
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            this.interaction.add(t);
            return t;
        }

        public ConformanceRestComponent addInteraction(SystemInteractionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            this.interaction.add(t);
            return this;
        }

        public Enumeration<TransactionMode> getTransactionModeElement() {
            if (this.transactionMode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceRestComponent.transactionMode");
                }
                if (Configuration.doAutoCreate()) {
                    this.transactionMode = new Enumeration<TransactionMode>(new TransactionModeEnumFactory());
                }
            }
            return this.transactionMode;
        }

        public boolean hasTransactionModeElement() {
            return this.transactionMode != null && !this.transactionMode.isEmpty();
        }

        public boolean hasTransactionMode() {
            return this.transactionMode != null && !this.transactionMode.isEmpty();
        }

        public ConformanceRestComponent setTransactionModeElement(Enumeration<TransactionMode> value) {
            this.transactionMode = value;
            return this;
        }

        public TransactionMode getTransactionMode() {
            return this.transactionMode == null ? null : (TransactionMode)((Object)this.transactionMode.getValue());
        }

        public ConformanceRestComponent setTransactionMode(TransactionMode value) {
            if (value == null) {
                this.transactionMode = null;
            } else {
                if (this.transactionMode == null) {
                    this.transactionMode = new Enumeration<TransactionMode>(new TransactionModeEnumFactory());
                }
                this.transactionMode.setValue((Object)value);
            }
            return this;
        }

        public List<ConformanceRestResourceSearchParamComponent> getSearchParam() {
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            }
            return this.searchParam;
        }

        public boolean hasSearchParam() {
            if (this.searchParam == null) {
                return false;
            }
            for (ConformanceRestResourceSearchParamComponent item : this.searchParam) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConformanceRestResourceSearchParamComponent addSearchParam() {
            ConformanceRestResourceSearchParamComponent t = new ConformanceRestResourceSearchParamComponent();
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return t;
        }

        public ConformanceRestComponent addSearchParam(ConformanceRestResourceSearchParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return this;
        }

        public List<ConformanceRestOperationComponent> getOperation() {
            if (this.operation == null) {
                this.operation = new ArrayList<ConformanceRestOperationComponent>();
            }
            return this.operation;
        }

        public boolean hasOperation() {
            if (this.operation == null) {
                return false;
            }
            for (ConformanceRestOperationComponent item : this.operation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConformanceRestOperationComponent addOperation() {
            ConformanceRestOperationComponent t = new ConformanceRestOperationComponent();
            if (this.operation == null) {
                this.operation = new ArrayList<ConformanceRestOperationComponent>();
            }
            this.operation.add(t);
            return t;
        }

        public ConformanceRestComponent addOperation(ConformanceRestOperationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.operation == null) {
                this.operation = new ArrayList<ConformanceRestOperationComponent>();
            }
            this.operation.add(t);
            return this;
        }

        public List<UriType> getCompartment() {
            if (this.compartment == null) {
                this.compartment = new ArrayList<UriType>();
            }
            return this.compartment;
        }

        public boolean hasCompartment() {
            if (this.compartment == null) {
                return false;
            }
            for (UriType item : this.compartment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addCompartmentElement() {
            UriType t = new UriType();
            if (this.compartment == null) {
                this.compartment = new ArrayList<UriType>();
            }
            this.compartment.add(t);
            return t;
        }

        public ConformanceRestComponent addCompartment(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.compartment == null) {
                this.compartment = new ArrayList<UriType>();
            }
            this.compartment.add(t);
            return this;
        }

        public boolean hasCompartment(String value) {
            if (this.compartment == null) {
                return false;
            }
            for (UriType v : this.compartment) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Conformance.SP_MODE, "code", "Identifies whether this portion of the statement is describing ability to initiate or receive restful operations.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("documentation", "string", "Information about the system's restful capabilities that apply across all applications, such as security.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property(Conformance.SP_SECURITY, "", "Information about security implementation from an interface perspective - what a client needs to know.", 0, Integer.MAX_VALUE, this.security));
            childrenList.add(new Property(Conformance.SP_RESOURCE, "", "A specification of the restful capabilities of the solution for a specific resource type.", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("interaction", "", "A specification of restful operations supported by the system.", 0, Integer.MAX_VALUE, this.interaction));
            childrenList.add(new Property("transactionMode", "code", "A code that indicates how transactions are supported.", 0, Integer.MAX_VALUE, this.transactionMode));
            childrenList.add(new Property("searchParam", "@Conformance.rest.resource.searchParam", "Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam));
            childrenList.add(new Property("operation", "", "Definition of an operation or a named query and with its parameters and their meaning and type.", 0, Integer.MAX_VALUE, this.operation));
            childrenList.add(new Property("compartment", "uri", "An absolute URI which is a reference to the definition of a compartment hosted by the system.", 0, Integer.MAX_VALUE, this.compartment));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Conformance.SP_MODE)) {
                this.mode = new RestfulConformanceModeEnumFactory().fromType(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals(Conformance.SP_SECURITY)) {
                this.security = (ConformanceRestSecurityComponent)value;
            } else if (name.equals(Conformance.SP_RESOURCE)) {
                this.getResource().add((ConformanceRestResourceComponent)value);
            } else if (name.equals("interaction")) {
                this.getInteraction().add((SystemInteractionComponent)value);
            } else if (name.equals("transactionMode")) {
                this.transactionMode = new TransactionModeEnumFactory().fromType(value);
            } else if (name.equals("searchParam")) {
                this.getSearchParam().add((ConformanceRestResourceSearchParamComponent)value);
            } else if (name.equals("operation")) {
                this.getOperation().add((ConformanceRestOperationComponent)value);
            } else if (name.equals("compartment")) {
                this.getCompartment().add(this.castToUri(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Conformance.SP_MODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.documentation");
            }
            if (name.equals(Conformance.SP_SECURITY)) {
                this.security = new ConformanceRestSecurityComponent();
                return this.security;
            }
            if (name.equals(Conformance.SP_RESOURCE)) {
                return this.addResource();
            }
            if (name.equals("interaction")) {
                return this.addInteraction();
            }
            if (name.equals("transactionMode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.transactionMode");
            }
            if (name.equals("searchParam")) {
                return this.addSearchParam();
            }
            if (name.equals("operation")) {
                return this.addOperation();
            }
            if (name.equals("compartment")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.compartment");
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceRestComponent copy() {
            ConformanceRestComponent dst = new ConformanceRestComponent();
            this.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            ConformanceRestSecurityComponent conformanceRestSecurityComponent = dst.security = this.security == null ? null : this.security.copy();
            if (this.resource != null) {
                dst.resource = new ArrayList<ConformanceRestResourceComponent>();
                for (ConformanceRestResourceComponent conformanceRestResourceComponent : this.resource) {
                    dst.resource.add(conformanceRestResourceComponent.copy());
                }
            }
            if (this.interaction != null) {
                dst.interaction = new ArrayList<SystemInteractionComponent>();
                for (SystemInteractionComponent systemInteractionComponent : this.interaction) {
                    dst.interaction.add(systemInteractionComponent.copy());
                }
            }
            Enumeration<TransactionMode> enumeration = dst.transactionMode = this.transactionMode == null ? null : this.transactionMode.copy();
            if (this.searchParam != null) {
                dst.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
                for (ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : this.searchParam) {
                    dst.searchParam.add(conformanceRestResourceSearchParamComponent.copy());
                }
            }
            if (this.operation != null) {
                dst.operation = new ArrayList<ConformanceRestOperationComponent>();
                for (ConformanceRestOperationComponent conformanceRestOperationComponent : this.operation) {
                    dst.operation.add(conformanceRestOperationComponent.copy());
                }
            }
            if (this.compartment != null) {
                dst.compartment = new ArrayList<UriType>();
                for (UriType uriType : this.compartment) {
                    dst.compartment.add(uriType.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestComponent)) {
                return false;
            }
            ConformanceRestComponent o = (ConformanceRestComponent)other;
            return ConformanceRestComponent.compareDeep(this.mode, o.mode, true) && ConformanceRestComponent.compareDeep(this.documentation, o.documentation, true) && ConformanceRestComponent.compareDeep(this.security, o.security, true) && ConformanceRestComponent.compareDeep(this.resource, o.resource, true) && ConformanceRestComponent.compareDeep(this.interaction, o.interaction, true) && ConformanceRestComponent.compareDeep(this.transactionMode, o.transactionMode, true) && ConformanceRestComponent.compareDeep(this.searchParam, o.searchParam, true) && ConformanceRestComponent.compareDeep(this.operation, o.operation, true) && ConformanceRestComponent.compareDeep(this.compartment, o.compartment, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceRestComponent)) {
                return false;
            }
            ConformanceRestComponent o = (ConformanceRestComponent)other;
            return ConformanceRestComponent.compareValues(this.mode, o.mode, true) && ConformanceRestComponent.compareValues(this.documentation, o.documentation, true) && ConformanceRestComponent.compareValues(this.transactionMode, o.transactionMode, true) && ConformanceRestComponent.compareValues(this.compartment, o.compartment, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.security != null && !this.security.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.interaction != null && !this.interaction.isEmpty() || this.transactionMode != null && !this.transactionMode.isEmpty() || this.searchParam != null && !this.searchParam.isEmpty() || this.operation != null && !this.operation.isEmpty() || this.compartment != null && !this.compartment.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.rest";
        }
    }

    @Block
    public static class ConformanceImplementationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Describes this specific instance", formalDefinition="Information about the specific installation that this conformance statement relates to.")
        protected StringType description;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Base URL for the installation", formalDefinition="An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.")
        protected UriType url;
        private static final long serialVersionUID = -289238508L;

        public ConformanceImplementationComponent() {
        }

        public ConformanceImplementationComponent(StringType description) {
            this.description = description;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceImplementationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ConformanceImplementationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ConformanceImplementationComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceImplementationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public ConformanceImplementationComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public ConformanceImplementationComponent setUrl(String value) {
            if (Utilities.noString(value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Conformance.SP_DESCRIPTION, "string", "Information about the specific installation that this conformance statement relates to.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property(Conformance.SP_URL, "uri", "An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Conformance.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals(Conformance.SP_URL)) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Conformance.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.description");
            }
            if (name.equals(Conformance.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.url");
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceImplementationComponent copy() {
            ConformanceImplementationComponent dst = new ConformanceImplementationComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceImplementationComponent)) {
                return false;
            }
            ConformanceImplementationComponent o = (ConformanceImplementationComponent)other;
            return ConformanceImplementationComponent.compareDeep(this.description, o.description, true) && ConformanceImplementationComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceImplementationComponent)) {
                return false;
            }
            ConformanceImplementationComponent o = (ConformanceImplementationComponent)other;
            return ConformanceImplementationComponent.compareValues(this.description, o.description, true) && ConformanceImplementationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.description != null && !this.description.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.implementation";
        }
    }

    @Block
    public static class ConformanceSoftwareComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A name the software is known by", formalDefinition="Name software is known by.")
        protected StringType name;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version covered by this statement", formalDefinition="The version identifier for the software covered by this statement.")
        protected StringType version;
        @Child(name="releaseDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date this version released", formalDefinition="Date this version of the software released.")
        protected DateTimeType releaseDate;
        private static final long serialVersionUID = 1819769027L;

        public ConformanceSoftwareComponent() {
        }

        public ConformanceSoftwareComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceSoftwareComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ConformanceSoftwareComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ConformanceSoftwareComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceSoftwareComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ConformanceSoftwareComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ConformanceSoftwareComponent setVersion(String value) {
            if (Utilities.noString(value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public DateTimeType getReleaseDateElement() {
            if (this.releaseDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceSoftwareComponent.releaseDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.releaseDate = new DateTimeType();
                }
            }
            return this.releaseDate;
        }

        public boolean hasReleaseDateElement() {
            return this.releaseDate != null && !this.releaseDate.isEmpty();
        }

        public boolean hasReleaseDate() {
            return this.releaseDate != null && !this.releaseDate.isEmpty();
        }

        public ConformanceSoftwareComponent setReleaseDateElement(DateTimeType value) {
            this.releaseDate = value;
            return this;
        }

        public Date getReleaseDate() {
            return this.releaseDate == null ? null : (Date)this.releaseDate.getValue();
        }

        public ConformanceSoftwareComponent setReleaseDate(Date value) {
            if (value == null) {
                this.releaseDate = null;
            } else {
                if (this.releaseDate == null) {
                    this.releaseDate = new DateTimeType();
                }
                this.releaseDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Conformance.SP_NAME, "string", "Name software is known by.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Conformance.SP_VERSION, "string", "The version identifier for the software covered by this statement.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("releaseDate", "dateTime", "Date this version of the software released.", 0, Integer.MAX_VALUE, this.releaseDate));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(Conformance.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("releaseDate")) {
                this.releaseDate = this.castToDateTime(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.name");
            }
            if (name.equals(Conformance.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.version");
            }
            if (name.equals("releaseDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.releaseDate");
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceSoftwareComponent copy() {
            ConformanceSoftwareComponent dst = new ConformanceSoftwareComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.releaseDate = this.releaseDate == null ? null : this.releaseDate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceSoftwareComponent)) {
                return false;
            }
            ConformanceSoftwareComponent o = (ConformanceSoftwareComponent)other;
            return ConformanceSoftwareComponent.compareDeep(this.name, o.name, true) && ConformanceSoftwareComponent.compareDeep(this.version, o.version, true) && ConformanceSoftwareComponent.compareDeep(this.releaseDate, o.releaseDate, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceSoftwareComponent)) {
                return false;
            }
            ConformanceSoftwareComponent o = (ConformanceSoftwareComponent)other;
            return ConformanceSoftwareComponent.compareValues(this.name, o.name, true) && ConformanceSoftwareComponent.compareValues(this.version, o.version, true) && ConformanceSoftwareComponent.compareValues(this.releaseDate, o.releaseDate, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.version != null && !this.version.isEmpty() || this.releaseDate != null && !this.releaseDate.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.software";
        }
    }

    @Block
    public static class ConformanceContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of a individual to contact", formalDefinition="The name of an individual to contact regarding the conformance.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConformanceContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ConformanceContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ConformanceContactComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ConformanceContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Conformance.SP_NAME, "string", "The name of an individual to contact regarding the conformance.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Conformance.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type Conformance.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public ConformanceContactComponent copy() {
            ConformanceContactComponent dst = new ConformanceContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConformanceContactComponent)) {
                return false;
            }
            ConformanceContactComponent o = (ConformanceContactComponent)other;
            return ConformanceContactComponent.compareDeep(this.name, o.name, true) && ConformanceContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConformanceContactComponent)) {
                return false;
            }
            ConformanceContactComponent o = (ConformanceContactComponent)other;
            return ConformanceContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Conformance.contact";
        }
    }

    public static class DocumentModeEnumFactory
    implements EnumFactory<DocumentMode> {
        @Override
        public DocumentMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("producer".equals(codeString)) {
                return DocumentMode.PRODUCER;
            }
            if ("consumer".equals(codeString)) {
                return DocumentMode.CONSUMER;
            }
            throw new IllegalArgumentException("Unknown DocumentMode code '" + codeString + "'");
        }

        public Enumeration<DocumentMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("producer".equals(codeString)) {
                return new Enumeration<DocumentMode>(this, DocumentMode.PRODUCER);
            }
            if ("consumer".equals(codeString)) {
                return new Enumeration<DocumentMode>(this, DocumentMode.CONSUMER);
            }
            throw new FHIRException("Unknown DocumentMode code '" + codeString + "'");
        }

        @Override
        public String toCode(DocumentMode code) {
            if (code == DocumentMode.PRODUCER) {
                return "producer";
            }
            if (code == DocumentMode.CONSUMER) {
                return "consumer";
            }
            return "?";
        }
    }

    public static enum DocumentMode {
        PRODUCER,
        CONSUMER,
        NULL;


        public static DocumentMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("producer".equals(codeString)) {
                return PRODUCER;
            }
            if ("consumer".equals(codeString)) {
                return CONSUMER;
            }
            throw new FHIRException("Unknown DocumentMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRODUCER: {
                    return "producer";
                }
                case CONSUMER: {
                    return "consumer";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRODUCER: {
                    return "http://hl7.org/fhir/document-mode";
                }
                case CONSUMER: {
                    return "http://hl7.org/fhir/document-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRODUCER: {
                    return "The application produces documents of the specified type.";
                }
                case CONSUMER: {
                    return "The application consumes documents of the specified type.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRODUCER: {
                    return "Producer";
                }
                case CONSUMER: {
                    return "Consumer";
                }
            }
            return "?";
        }
    }

    public static class ConformanceEventModeEnumFactory
    implements EnumFactory<ConformanceEventMode> {
        @Override
        public ConformanceEventMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("sender".equals(codeString)) {
                return ConformanceEventMode.SENDER;
            }
            if ("receiver".equals(codeString)) {
                return ConformanceEventMode.RECEIVER;
            }
            throw new IllegalArgumentException("Unknown ConformanceEventMode code '" + codeString + "'");
        }

        public Enumeration<ConformanceEventMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sender".equals(codeString)) {
                return new Enumeration<ConformanceEventMode>(this, ConformanceEventMode.SENDER);
            }
            if ("receiver".equals(codeString)) {
                return new Enumeration<ConformanceEventMode>(this, ConformanceEventMode.RECEIVER);
            }
            throw new FHIRException("Unknown ConformanceEventMode code '" + codeString + "'");
        }

        @Override
        public String toCode(ConformanceEventMode code) {
            if (code == ConformanceEventMode.SENDER) {
                return "sender";
            }
            if (code == ConformanceEventMode.RECEIVER) {
                return "receiver";
            }
            return "?";
        }
    }

    public static enum ConformanceEventMode {
        SENDER,
        RECEIVER,
        NULL;


        public static ConformanceEventMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sender".equals(codeString)) {
                return SENDER;
            }
            if ("receiver".equals(codeString)) {
                return RECEIVER;
            }
            throw new FHIRException("Unknown ConformanceEventMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SENDER: {
                    return "sender";
                }
                case RECEIVER: {
                    return "receiver";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SENDER: {
                    return "http://hl7.org/fhir/message-conformance-event-mode";
                }
                case RECEIVER: {
                    return "http://hl7.org/fhir/message-conformance-event-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SENDER: {
                    return "The application sends requests and receives responses.";
                }
                case RECEIVER: {
                    return "The application receives requests and sends responses.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SENDER: {
                    return "Sender";
                }
                case RECEIVER: {
                    return "Receiver";
                }
            }
            return "?";
        }
    }

    public static class MessageSignificanceCategoryEnumFactory
    implements EnumFactory<MessageSignificanceCategory> {
        @Override
        public MessageSignificanceCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Consequence".equals(codeString)) {
                return MessageSignificanceCategory.CONSEQUENCE;
            }
            if ("Currency".equals(codeString)) {
                return MessageSignificanceCategory.CURRENCY;
            }
            if ("Notification".equals(codeString)) {
                return MessageSignificanceCategory.NOTIFICATION;
            }
            throw new IllegalArgumentException("Unknown MessageSignificanceCategory code '" + codeString + "'");
        }

        public Enumeration<MessageSignificanceCategory> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Consequence".equals(codeString)) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.CONSEQUENCE);
            }
            if ("Currency".equals(codeString)) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.CURRENCY);
            }
            if ("Notification".equals(codeString)) {
                return new Enumeration<MessageSignificanceCategory>(this, MessageSignificanceCategory.NOTIFICATION);
            }
            throw new FHIRException("Unknown MessageSignificanceCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(MessageSignificanceCategory code) {
            if (code == MessageSignificanceCategory.CONSEQUENCE) {
                return "Consequence";
            }
            if (code == MessageSignificanceCategory.CURRENCY) {
                return "Currency";
            }
            if (code == MessageSignificanceCategory.NOTIFICATION) {
                return "Notification";
            }
            return "?";
        }
    }

    public static enum MessageSignificanceCategory {
        CONSEQUENCE,
        CURRENCY,
        NOTIFICATION,
        NULL;


        public static MessageSignificanceCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Consequence".equals(codeString)) {
                return CONSEQUENCE;
            }
            if ("Currency".equals(codeString)) {
                return CURRENCY;
            }
            if ("Notification".equals(codeString)) {
                return NOTIFICATION;
            }
            throw new FHIRException("Unknown MessageSignificanceCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CONSEQUENCE: {
                    return "Consequence";
                }
                case CURRENCY: {
                    return "Currency";
                }
                case NOTIFICATION: {
                    return "Notification";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CONSEQUENCE: {
                    return "http://hl7.org/fhir/message-significance-category";
                }
                case CURRENCY: {
                    return "http://hl7.org/fhir/message-significance-category";
                }
                case NOTIFICATION: {
                    return "http://hl7.org/fhir/message-significance-category";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CONSEQUENCE: {
                    return "The message represents/requests a change that should not be processed more than once; e.g. Making a booking for an appointment.";
                }
                case CURRENCY: {
                    return "The message represents a response to query for current information. Retrospective processing is wrong and/or wasteful.";
                }
                case NOTIFICATION: {
                    return "The content is not necessarily intended to be current, and it can be reprocessed, though there may be version issues created by processing old notifications.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CONSEQUENCE: {
                    return "Consequence";
                }
                case CURRENCY: {
                    return "Currency";
                }
                case NOTIFICATION: {
                    return "Notification";
                }
            }
            return "?";
        }
    }

    public static class TransactionModeEnumFactory
    implements EnumFactory<TransactionMode> {
        @Override
        public TransactionMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return TransactionMode.NOTSUPPORTED;
            }
            if ("batch".equals(codeString)) {
                return TransactionMode.BATCH;
            }
            if ("transaction".equals(codeString)) {
                return TransactionMode.TRANSACTION;
            }
            if ("both".equals(codeString)) {
                return TransactionMode.BOTH;
            }
            throw new IllegalArgumentException("Unknown TransactionMode code '" + codeString + "'");
        }

        public Enumeration<TransactionMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return new Enumeration<TransactionMode>(this, TransactionMode.NOTSUPPORTED);
            }
            if ("batch".equals(codeString)) {
                return new Enumeration<TransactionMode>(this, TransactionMode.BATCH);
            }
            if ("transaction".equals(codeString)) {
                return new Enumeration<TransactionMode>(this, TransactionMode.TRANSACTION);
            }
            if ("both".equals(codeString)) {
                return new Enumeration<TransactionMode>(this, TransactionMode.BOTH);
            }
            throw new FHIRException("Unknown TransactionMode code '" + codeString + "'");
        }

        @Override
        public String toCode(TransactionMode code) {
            if (code == TransactionMode.NOTSUPPORTED) {
                return "not-supported";
            }
            if (code == TransactionMode.BATCH) {
                return "batch";
            }
            if (code == TransactionMode.TRANSACTION) {
                return "transaction";
            }
            if (code == TransactionMode.BOTH) {
                return "both";
            }
            return "?";
        }
    }

    public static enum TransactionMode {
        NOTSUPPORTED,
        BATCH,
        TRANSACTION,
        BOTH,
        NULL;


        public static TransactionMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return NOTSUPPORTED;
            }
            if ("batch".equals(codeString)) {
                return BATCH;
            }
            if ("transaction".equals(codeString)) {
                return TRANSACTION;
            }
            if ("both".equals(codeString)) {
                return BOTH;
            }
            throw new FHIRException("Unknown TransactionMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "not-supported";
                }
                case BATCH: {
                    return "batch";
                }
                case TRANSACTION: {
                    return "transaction";
                }
                case BOTH: {
                    return "both";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "http://hl7.org/fhir/transaction-mode";
                }
                case BATCH: {
                    return "http://hl7.org/fhir/transaction-mode";
                }
                case TRANSACTION: {
                    return "http://hl7.org/fhir/transaction-mode";
                }
                case BOTH: {
                    return "http://hl7.org/fhir/transaction-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "Neither batch or transaction is supported.";
                }
                case BATCH: {
                    return "Batches are  supported.";
                }
                case TRANSACTION: {
                    return "Transactions are supported.";
                }
                case BOTH: {
                    return "Both batches and transactions are supported.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "None";
                }
                case BATCH: {
                    return "Batches supported";
                }
                case TRANSACTION: {
                    return "Transactions Supported";
                }
                case BOTH: {
                    return "Batches & Transactions";
                }
            }
            return "?";
        }
    }

    public static class SystemRestfulInteractionEnumFactory
    implements EnumFactory<SystemRestfulInteraction> {
        @Override
        public SystemRestfulInteraction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return SystemRestfulInteraction.TRANSACTION;
            }
            if ("search-system".equals(codeString)) {
                return SystemRestfulInteraction.SEARCHSYSTEM;
            }
            if ("history-system".equals(codeString)) {
                return SystemRestfulInteraction.HISTORYSYSTEM;
            }
            throw new IllegalArgumentException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        public Enumeration<SystemRestfulInteraction> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.TRANSACTION);
            }
            if ("search-system".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.SEARCHSYSTEM);
            }
            if ("history-system".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.HISTORYSYSTEM);
            }
            throw new FHIRException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        @Override
        public String toCode(SystemRestfulInteraction code) {
            if (code == SystemRestfulInteraction.TRANSACTION) {
                return "transaction";
            }
            if (code == SystemRestfulInteraction.SEARCHSYSTEM) {
                return "search-system";
            }
            if (code == SystemRestfulInteraction.HISTORYSYSTEM) {
                return "history-system";
            }
            return "?";
        }
    }

    public static enum SystemRestfulInteraction {
        TRANSACTION,
        SEARCHSYSTEM,
        HISTORYSYSTEM,
        NULL;


        public static SystemRestfulInteraction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return TRANSACTION;
            }
            if ("search-system".equals(codeString)) {
                return SEARCHSYSTEM;
            }
            if ("history-system".equals(codeString)) {
                return HISTORYSYSTEM;
            }
            throw new FHIRException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TRANSACTION: {
                    return "transaction";
                }
                case SEARCHSYSTEM: {
                    return "search-system";
                }
                case HISTORYSYSTEM: {
                    return "history-system";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TRANSACTION: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case SEARCHSYSTEM: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYSYSTEM: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TRANSACTION: {
                    return "";
                }
                case SEARCHSYSTEM: {
                    return "";
                }
                case HISTORYSYSTEM: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TRANSACTION: {
                    return "transaction";
                }
                case SEARCHSYSTEM: {
                    return "search-system";
                }
                case HISTORYSYSTEM: {
                    return "history-system";
                }
            }
            return "?";
        }
    }

    public static class SearchModifierCodeEnumFactory
    implements EnumFactory<SearchModifierCode> {
        @Override
        public SearchModifierCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return SearchModifierCode.MISSING;
            }
            if ("exact".equals(codeString)) {
                return SearchModifierCode.EXACT;
            }
            if ("contains".equals(codeString)) {
                return SearchModifierCode.CONTAINS;
            }
            if ("not".equals(codeString)) {
                return SearchModifierCode.NOT;
            }
            if ("text".equals(codeString)) {
                return SearchModifierCode.TEXT;
            }
            if ("in".equals(codeString)) {
                return SearchModifierCode.IN;
            }
            if ("not-in".equals(codeString)) {
                return SearchModifierCode.NOTIN;
            }
            if ("below".equals(codeString)) {
                return SearchModifierCode.BELOW;
            }
            if ("above".equals(codeString)) {
                return SearchModifierCode.ABOVE;
            }
            if ("type".equals(codeString)) {
                return SearchModifierCode.TYPE;
            }
            throw new IllegalArgumentException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        public Enumeration<SearchModifierCode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.MISSING);
            }
            if ("exact".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.EXACT);
            }
            if ("contains".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.CONTAINS);
            }
            if ("not".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.NOT);
            }
            if ("text".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.TEXT);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.IN);
            }
            if ("not-in".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.NOTIN);
            }
            if ("below".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.BELOW);
            }
            if ("above".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.ABOVE);
            }
            if ("type".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.TYPE);
            }
            throw new FHIRException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchModifierCode code) {
            if (code == SearchModifierCode.MISSING) {
                return "missing";
            }
            if (code == SearchModifierCode.EXACT) {
                return "exact";
            }
            if (code == SearchModifierCode.CONTAINS) {
                return "contains";
            }
            if (code == SearchModifierCode.NOT) {
                return "not";
            }
            if (code == SearchModifierCode.TEXT) {
                return "text";
            }
            if (code == SearchModifierCode.IN) {
                return "in";
            }
            if (code == SearchModifierCode.NOTIN) {
                return "not-in";
            }
            if (code == SearchModifierCode.BELOW) {
                return "below";
            }
            if (code == SearchModifierCode.ABOVE) {
                return "above";
            }
            if (code == SearchModifierCode.TYPE) {
                return "type";
            }
            return "?";
        }
    }

    public static enum SearchModifierCode {
        MISSING,
        EXACT,
        CONTAINS,
        NOT,
        TEXT,
        IN,
        NOTIN,
        BELOW,
        ABOVE,
        TYPE,
        NULL;


        public static SearchModifierCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return MISSING;
            }
            if ("exact".equals(codeString)) {
                return EXACT;
            }
            if ("contains".equals(codeString)) {
                return CONTAINS;
            }
            if ("not".equals(codeString)) {
                return NOT;
            }
            if ("text".equals(codeString)) {
                return TEXT;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("not-in".equals(codeString)) {
                return NOTIN;
            }
            if ("below".equals(codeString)) {
                return BELOW;
            }
            if ("above".equals(codeString)) {
                return ABOVE;
            }
            if ("type".equals(codeString)) {
                return TYPE;
            }
            throw new FHIRException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MISSING: {
                    return "missing";
                }
                case EXACT: {
                    return "exact";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOT: {
                    return "not";
                }
                case TEXT: {
                    return "text";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case BELOW: {
                    return "below";
                }
                case ABOVE: {
                    return "above";
                }
                case TYPE: {
                    return "type";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MISSING: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case EXACT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case CONTAINS: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case NOT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case TEXT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case IN: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case BELOW: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case ABOVE: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case TYPE: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MISSING: {
                    return "The search parameter returns resources that have a value or not.";
                }
                case EXACT: {
                    return "The search parameter returns resources that have a value that exactly matches the supplied parameter (the whole string, including casing and accents).";
                }
                case CONTAINS: {
                    return "The search parameter returns resources that include the supplied parameter value anywhere within the field being searched.";
                }
                case NOT: {
                    return "The search parameter returns resources that do not contain a match .";
                }
                case TEXT: {
                    return "The search parameter is processed as a string that searches text associated with the code/value - either CodeableConcept.text, Coding.display, or Identifier.type.text.";
                }
                case IN: {
                    return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is in the specified value set.";
                }
                case NOTIN: {
                    return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is not in the specified value set.";
                }
                case BELOW: {
                    return "The search parameter tests whether the value in a resource is subsumed by the specified value (is-a, or hierarchical relationships).";
                }
                case ABOVE: {
                    return "The search parameter tests whether the value in a resource subsumes the specified value (is-a, or hierarchical relationships).";
                }
                case TYPE: {
                    return "The search parameter only applies to the Resource Type specified as a modifier (e.g. the modifier is not actually :type, but :Patient etc.).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MISSING: {
                    return "Missing";
                }
                case EXACT: {
                    return "Exact";
                }
                case CONTAINS: {
                    return "Contains";
                }
                case NOT: {
                    return "Not";
                }
                case TEXT: {
                    return "Text";
                }
                case IN: {
                    return "In";
                }
                case NOTIN: {
                    return "Not In";
                }
                case BELOW: {
                    return "Below";
                }
                case ABOVE: {
                    return "Above";
                }
                case TYPE: {
                    return "Type";
                }
            }
            return "?";
        }
    }

    public static class ConditionalDeleteStatusEnumFactory
    implements EnumFactory<ConditionalDeleteStatus> {
        @Override
        public ConditionalDeleteStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return ConditionalDeleteStatus.NOTSUPPORTED;
            }
            if ("single".equals(codeString)) {
                return ConditionalDeleteStatus.SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return ConditionalDeleteStatus.MULTIPLE;
            }
            throw new IllegalArgumentException("Unknown ConditionalDeleteStatus code '" + codeString + "'");
        }

        public Enumeration<ConditionalDeleteStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return new Enumeration<ConditionalDeleteStatus>(this, ConditionalDeleteStatus.NOTSUPPORTED);
            }
            if ("single".equals(codeString)) {
                return new Enumeration<ConditionalDeleteStatus>(this, ConditionalDeleteStatus.SINGLE);
            }
            if ("multiple".equals(codeString)) {
                return new Enumeration<ConditionalDeleteStatus>(this, ConditionalDeleteStatus.MULTIPLE);
            }
            throw new FHIRException("Unknown ConditionalDeleteStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionalDeleteStatus code) {
            if (code == ConditionalDeleteStatus.NOTSUPPORTED) {
                return "not-supported";
            }
            if (code == ConditionalDeleteStatus.SINGLE) {
                return "single";
            }
            if (code == ConditionalDeleteStatus.MULTIPLE) {
                return "multiple";
            }
            return "?";
        }
    }

    public static enum ConditionalDeleteStatus {
        NOTSUPPORTED,
        SINGLE,
        MULTIPLE,
        NULL;


        public static ConditionalDeleteStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return NOTSUPPORTED;
            }
            if ("single".equals(codeString)) {
                return SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return MULTIPLE;
            }
            throw new FHIRException("Unknown ConditionalDeleteStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "not-supported";
                }
                case SINGLE: {
                    return "single";
                }
                case MULTIPLE: {
                    return "multiple";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "http://hl7.org/fhir/conditional-delete-status";
                }
                case SINGLE: {
                    return "http://hl7.org/fhir/conditional-delete-status";
                }
                case MULTIPLE: {
                    return "http://hl7.org/fhir/conditional-delete-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "No support for conditional deletes.";
                }
                case SINGLE: {
                    return "Conditional deletes are supported, but only single resources at a time.";
                }
                case MULTIPLE: {
                    return "Conditional deletes are supported, and multiple resources can be deleted in a single interaction.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "Not Supported";
                }
                case SINGLE: {
                    return "Single Deletes Supported";
                }
                case MULTIPLE: {
                    return "Multiple Deletes Supported";
                }
            }
            return "?";
        }
    }

    public static class ResourceVersionPolicyEnumFactory
    implements EnumFactory<ResourceVersionPolicy> {
        @Override
        public ResourceVersionPolicy fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("no-version".equals(codeString)) {
                return ResourceVersionPolicy.NOVERSION;
            }
            if ("versioned".equals(codeString)) {
                return ResourceVersionPolicy.VERSIONED;
            }
            if ("versioned-update".equals(codeString)) {
                return ResourceVersionPolicy.VERSIONEDUPDATE;
            }
            throw new IllegalArgumentException("Unknown ResourceVersionPolicy code '" + codeString + "'");
        }

        public Enumeration<ResourceVersionPolicy> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("no-version".equals(codeString)) {
                return new Enumeration<ResourceVersionPolicy>(this, ResourceVersionPolicy.NOVERSION);
            }
            if ("versioned".equals(codeString)) {
                return new Enumeration<ResourceVersionPolicy>(this, ResourceVersionPolicy.VERSIONED);
            }
            if ("versioned-update".equals(codeString)) {
                return new Enumeration<ResourceVersionPolicy>(this, ResourceVersionPolicy.VERSIONEDUPDATE);
            }
            throw new FHIRException("Unknown ResourceVersionPolicy code '" + codeString + "'");
        }

        @Override
        public String toCode(ResourceVersionPolicy code) {
            if (code == ResourceVersionPolicy.NOVERSION) {
                return "no-version";
            }
            if (code == ResourceVersionPolicy.VERSIONED) {
                return "versioned";
            }
            if (code == ResourceVersionPolicy.VERSIONEDUPDATE) {
                return "versioned-update";
            }
            return "?";
        }
    }

    public static enum ResourceVersionPolicy {
        NOVERSION,
        VERSIONED,
        VERSIONEDUPDATE,
        NULL;


        public static ResourceVersionPolicy fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("no-version".equals(codeString)) {
                return NOVERSION;
            }
            if ("versioned".equals(codeString)) {
                return VERSIONED;
            }
            if ("versioned-update".equals(codeString)) {
                return VERSIONEDUPDATE;
            }
            throw new FHIRException("Unknown ResourceVersionPolicy code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOVERSION: {
                    return "no-version";
                }
                case VERSIONED: {
                    return "versioned";
                }
                case VERSIONEDUPDATE: {
                    return "versioned-update";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOVERSION: {
                    return "http://hl7.org/fhir/versioning-policy";
                }
                case VERSIONED: {
                    return "http://hl7.org/fhir/versioning-policy";
                }
                case VERSIONEDUPDATE: {
                    return "http://hl7.org/fhir/versioning-policy";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOVERSION: {
                    return "VersionId meta-property is not supported (server) or used (client).";
                }
                case VERSIONED: {
                    return "VersionId meta-property is supported (server) or used (client).";
                }
                case VERSIONEDUPDATE: {
                    return "VersionId is must be correct for updates (server) or will be specified (If-match header) for updates (client).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOVERSION: {
                    return "No VersionId Support";
                }
                case VERSIONED: {
                    return "Versioned";
                }
                case VERSIONEDUPDATE: {
                    return "VersionId tracked fully";
                }
            }
            return "?";
        }
    }

    public static class TypeRestfulInteractionEnumFactory
    implements EnumFactory<TypeRestfulInteraction> {
        @Override
        public TypeRestfulInteraction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("read".equals(codeString)) {
                return TypeRestfulInteraction.READ;
            }
            if ("vread".equals(codeString)) {
                return TypeRestfulInteraction.VREAD;
            }
            if ("update".equals(codeString)) {
                return TypeRestfulInteraction.UPDATE;
            }
            if ("delete".equals(codeString)) {
                return TypeRestfulInteraction.DELETE;
            }
            if ("history-instance".equals(codeString)) {
                return TypeRestfulInteraction.HISTORYINSTANCE;
            }
            if ("validate".equals(codeString)) {
                return TypeRestfulInteraction.VALIDATE;
            }
            if ("history-type".equals(codeString)) {
                return TypeRestfulInteraction.HISTORYTYPE;
            }
            if ("create".equals(codeString)) {
                return TypeRestfulInteraction.CREATE;
            }
            if ("search-type".equals(codeString)) {
                return TypeRestfulInteraction.SEARCHTYPE;
            }
            throw new IllegalArgumentException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        public Enumeration<TypeRestfulInteraction> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("read".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.READ);
            }
            if ("vread".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.VREAD);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.UPDATE);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.DELETE);
            }
            if ("history-instance".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.HISTORYINSTANCE);
            }
            if ("validate".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.VALIDATE);
            }
            if ("history-type".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.HISTORYTYPE);
            }
            if ("create".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.CREATE);
            }
            if ("search-type".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.SEARCHTYPE);
            }
            throw new FHIRException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        @Override
        public String toCode(TypeRestfulInteraction code) {
            if (code == TypeRestfulInteraction.READ) {
                return "read";
            }
            if (code == TypeRestfulInteraction.VREAD) {
                return "vread";
            }
            if (code == TypeRestfulInteraction.UPDATE) {
                return "update";
            }
            if (code == TypeRestfulInteraction.DELETE) {
                return "delete";
            }
            if (code == TypeRestfulInteraction.HISTORYINSTANCE) {
                return "history-instance";
            }
            if (code == TypeRestfulInteraction.VALIDATE) {
                return "validate";
            }
            if (code == TypeRestfulInteraction.HISTORYTYPE) {
                return "history-type";
            }
            if (code == TypeRestfulInteraction.CREATE) {
                return "create";
            }
            if (code == TypeRestfulInteraction.SEARCHTYPE) {
                return "search-type";
            }
            return "?";
        }
    }

    public static enum TypeRestfulInteraction {
        READ,
        VREAD,
        UPDATE,
        DELETE,
        HISTORYINSTANCE,
        VALIDATE,
        HISTORYTYPE,
        CREATE,
        SEARCHTYPE,
        NULL;


        public static TypeRestfulInteraction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("read".equals(codeString)) {
                return READ;
            }
            if ("vread".equals(codeString)) {
                return VREAD;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if ("history-instance".equals(codeString)) {
                return HISTORYINSTANCE;
            }
            if ("validate".equals(codeString)) {
                return VALIDATE;
            }
            if ("history-type".equals(codeString)) {
                return HISTORYTYPE;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("search-type".equals(codeString)) {
                return SEARCHTYPE;
            }
            throw new FHIRException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case READ: {
                    return "read";
                }
                case VREAD: {
                    return "vread";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case HISTORYINSTANCE: {
                    return "history-instance";
                }
                case VALIDATE: {
                    return "validate";
                }
                case HISTORYTYPE: {
                    return "history-type";
                }
                case CREATE: {
                    return "create";
                }
                case SEARCHTYPE: {
                    return "search-type";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case READ: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case VREAD: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYINSTANCE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case VALIDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYTYPE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case CREATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case SEARCHTYPE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case READ: {
                    return "";
                }
                case VREAD: {
                    return "";
                }
                case UPDATE: {
                    return "";
                }
                case DELETE: {
                    return "";
                }
                case HISTORYINSTANCE: {
                    return "";
                }
                case VALIDATE: {
                    return "";
                }
                case HISTORYTYPE: {
                    return "";
                }
                case CREATE: {
                    return "";
                }
                case SEARCHTYPE: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case READ: {
                    return "read";
                }
                case VREAD: {
                    return "vread";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case HISTORYINSTANCE: {
                    return "history-instance";
                }
                case VALIDATE: {
                    return "validate";
                }
                case HISTORYTYPE: {
                    return "history-type";
                }
                case CREATE: {
                    return "create";
                }
                case SEARCHTYPE: {
                    return "search-type";
                }
            }
            return "?";
        }
    }

    public static class RestfulConformanceModeEnumFactory
    implements EnumFactory<RestfulConformanceMode> {
        @Override
        public RestfulConformanceMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("client".equals(codeString)) {
                return RestfulConformanceMode.CLIENT;
            }
            if ("server".equals(codeString)) {
                return RestfulConformanceMode.SERVER;
            }
            throw new IllegalArgumentException("Unknown RestfulConformanceMode code '" + codeString + "'");
        }

        public Enumeration<RestfulConformanceMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("client".equals(codeString)) {
                return new Enumeration<RestfulConformanceMode>(this, RestfulConformanceMode.CLIENT);
            }
            if ("server".equals(codeString)) {
                return new Enumeration<RestfulConformanceMode>(this, RestfulConformanceMode.SERVER);
            }
            throw new FHIRException("Unknown RestfulConformanceMode code '" + codeString + "'");
        }

        @Override
        public String toCode(RestfulConformanceMode code) {
            if (code == RestfulConformanceMode.CLIENT) {
                return "client";
            }
            if (code == RestfulConformanceMode.SERVER) {
                return "server";
            }
            return "?";
        }
    }

    public static enum RestfulConformanceMode {
        CLIENT,
        SERVER,
        NULL;


        public static RestfulConformanceMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("client".equals(codeString)) {
                return CLIENT;
            }
            if ("server".equals(codeString)) {
                return SERVER;
            }
            throw new FHIRException("Unknown RestfulConformanceMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLIENT: {
                    return "client";
                }
                case SERVER: {
                    return "server";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLIENT: {
                    return "http://hl7.org/fhir/restful-conformance-mode";
                }
                case SERVER: {
                    return "http://hl7.org/fhir/restful-conformance-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLIENT: {
                    return "The application acts as a client for this resource.";
                }
                case SERVER: {
                    return "The application acts as a server for this resource.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLIENT: {
                    return "Client";
                }
                case SERVER: {
                    return "Server";
                }
            }
            return "?";
        }
    }

    public static class UnknownContentCodeEnumFactory
    implements EnumFactory<UnknownContentCode> {
        @Override
        public UnknownContentCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("no".equals(codeString)) {
                return UnknownContentCode.NO;
            }
            if ("extensions".equals(codeString)) {
                return UnknownContentCode.EXTENSIONS;
            }
            if ("elements".equals(codeString)) {
                return UnknownContentCode.ELEMENTS;
            }
            if ("both".equals(codeString)) {
                return UnknownContentCode.BOTH;
            }
            throw new IllegalArgumentException("Unknown UnknownContentCode code '" + codeString + "'");
        }

        public Enumeration<UnknownContentCode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("no".equals(codeString)) {
                return new Enumeration<UnknownContentCode>(this, UnknownContentCode.NO);
            }
            if ("extensions".equals(codeString)) {
                return new Enumeration<UnknownContentCode>(this, UnknownContentCode.EXTENSIONS);
            }
            if ("elements".equals(codeString)) {
                return new Enumeration<UnknownContentCode>(this, UnknownContentCode.ELEMENTS);
            }
            if ("both".equals(codeString)) {
                return new Enumeration<UnknownContentCode>(this, UnknownContentCode.BOTH);
            }
            throw new FHIRException("Unknown UnknownContentCode code '" + codeString + "'");
        }

        @Override
        public String toCode(UnknownContentCode code) {
            if (code == UnknownContentCode.NO) {
                return "no";
            }
            if (code == UnknownContentCode.EXTENSIONS) {
                return "extensions";
            }
            if (code == UnknownContentCode.ELEMENTS) {
                return "elements";
            }
            if (code == UnknownContentCode.BOTH) {
                return "both";
            }
            return "?";
        }
    }

    public static enum UnknownContentCode {
        NO,
        EXTENSIONS,
        ELEMENTS,
        BOTH,
        NULL;


        public static UnknownContentCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("no".equals(codeString)) {
                return NO;
            }
            if ("extensions".equals(codeString)) {
                return EXTENSIONS;
            }
            if ("elements".equals(codeString)) {
                return ELEMENTS;
            }
            if ("both".equals(codeString)) {
                return BOTH;
            }
            throw new FHIRException("Unknown UnknownContentCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NO: {
                    return "no";
                }
                case EXTENSIONS: {
                    return "extensions";
                }
                case ELEMENTS: {
                    return "elements";
                }
                case BOTH: {
                    return "both";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NO: {
                    return "http://hl7.org/fhir/unknown-content-code";
                }
                case EXTENSIONS: {
                    return "http://hl7.org/fhir/unknown-content-code";
                }
                case ELEMENTS: {
                    return "http://hl7.org/fhir/unknown-content-code";
                }
                case BOTH: {
                    return "http://hl7.org/fhir/unknown-content-code";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NO: {
                    return "The application does not accept either unknown elements or extensions.";
                }
                case EXTENSIONS: {
                    return "The application accepts unknown extensions, but not unknown elements.";
                }
                case ELEMENTS: {
                    return "The application accepts unknown elements, but not unknown extensions.";
                }
                case BOTH: {
                    return "The application accepts unknown elements and extensions.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NO: {
                    return "Neither Elements or Extensions";
                }
                case EXTENSIONS: {
                    return "Unknown Extensions";
                }
                case ELEMENTS: {
                    return "Unknown Elements";
                }
                case BOTH: {
                    return "Unknown Elements and Extensions";
                }
            }
            return "?";
        }
    }

    public static class ConformanceStatementKindEnumFactory
    implements EnumFactory<ConformanceStatementKind> {
        @Override
        public ConformanceStatementKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return ConformanceStatementKind.INSTANCE;
            }
            if ("capability".equals(codeString)) {
                return ConformanceStatementKind.CAPABILITY;
            }
            if ("requirements".equals(codeString)) {
                return ConformanceStatementKind.REQUIREMENTS;
            }
            throw new IllegalArgumentException("Unknown ConformanceStatementKind code '" + codeString + "'");
        }

        public Enumeration<ConformanceStatementKind> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return new Enumeration<ConformanceStatementKind>(this, ConformanceStatementKind.INSTANCE);
            }
            if ("capability".equals(codeString)) {
                return new Enumeration<ConformanceStatementKind>(this, ConformanceStatementKind.CAPABILITY);
            }
            if ("requirements".equals(codeString)) {
                return new Enumeration<ConformanceStatementKind>(this, ConformanceStatementKind.REQUIREMENTS);
            }
            throw new FHIRException("Unknown ConformanceStatementKind code '" + codeString + "'");
        }

        @Override
        public String toCode(ConformanceStatementKind code) {
            if (code == ConformanceStatementKind.INSTANCE) {
                return "instance";
            }
            if (code == ConformanceStatementKind.CAPABILITY) {
                return "capability";
            }
            if (code == ConformanceStatementKind.REQUIREMENTS) {
                return "requirements";
            }
            return "?";
        }
    }

    public static enum ConformanceStatementKind {
        INSTANCE,
        CAPABILITY,
        REQUIREMENTS,
        NULL;


        public static ConformanceStatementKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return INSTANCE;
            }
            if ("capability".equals(codeString)) {
                return CAPABILITY;
            }
            if ("requirements".equals(codeString)) {
                return REQUIREMENTS;
            }
            throw new FHIRException("Unknown ConformanceStatementKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTANCE: {
                    return "instance";
                }
                case CAPABILITY: {
                    return "capability";
                }
                case REQUIREMENTS: {
                    return "requirements";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTANCE: {
                    return "http://hl7.org/fhir/conformance-statement-kind";
                }
                case CAPABILITY: {
                    return "http://hl7.org/fhir/conformance-statement-kind";
                }
                case REQUIREMENTS: {
                    return "http://hl7.org/fhir/conformance-statement-kind";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTANCE: {
                    return "The Conformance instance represents the present capabilities of a specific system instance.  This is the kind returned by OPTIONS for a FHIR server end-point.";
                }
                case CAPABILITY: {
                    return "The Conformance instance represents the capabilities of a system or piece of software, independent of a particular installation.";
                }
                case REQUIREMENTS: {
                    return "The Conformance instance represents a set of requirements for other systems to meet; e.g. as part of an implementation guide or 'request for proposal'.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTANCE: {
                    return "Instance";
                }
                case CAPABILITY: {
                    return "Capability";
                }
                case REQUIREMENTS: {
                    return "Requirements";
                }
            }
            return "?";
        }
    }
}

