/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AuditEvent", profile="http://hl7.org/fhir/Profile/AuditEvent")
public class AuditEvent
extends DomainResource {
    @Child(name="event", type={}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What was done", formalDefinition="Identifies the name, action type, time, and disposition of the audited event.")
    protected AuditEventEventComponent event;
    @Child(name="participant", type={}, order=1, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A person, a hardware device or software process", formalDefinition="A person, a hardware device or software process.")
    protected List<AuditEventParticipantComponent> participant;
    @Child(name="source", type={}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Application systems and processes", formalDefinition="Application systems and processes.")
    protected AuditEventSourceComponent source;
    @Child(name="object", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specific instances of data or objects that have been accessed", formalDefinition="Specific instances of data or objects that have been accessed.")
    protected List<AuditEventObjectComponent> object;
    private static final long serialVersionUID = -1495151000L;
    @SearchParamDefinition(name="date", path="AuditEvent.event.dateTime", description="Time when the event occurred on source", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="address", path="AuditEvent.participant.network.address", description="Identifier for the network access point of the user device", type="token")
    public static final String SP_ADDRESS = "address";
    @SearchParamDefinition(name="source", path="AuditEvent.source.identifier", description="The identity of source detecting the event", type="token")
    public static final String SP_SOURCE = "source";
    @SearchParamDefinition(name="type", path="AuditEvent.event.type", description="Type/identifier of event", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="altid", path="AuditEvent.participant.altId", description="Alternative User id e.g. authentication", type="token")
    public static final String SP_ALTID = "altid";
    @SearchParamDefinition(name="participant", path="AuditEvent.participant.reference", description="Direct reference to resource", type="reference")
    public static final String SP_PARTICIPANT = "participant";
    @SearchParamDefinition(name="reference", path="AuditEvent.object.reference", description="Specific instance of resource (e.g. versioned)", type="reference")
    public static final String SP_REFERENCE = "reference";
    @SearchParamDefinition(name="site", path="AuditEvent.source.site", description="Logical source location within the enterprise", type="token")
    public static final String SP_SITE = "site";
    @SearchParamDefinition(name="subtype", path="AuditEvent.event.subtype", description="More specific type/id for the event", type="token")
    public static final String SP_SUBTYPE = "subtype";
    @SearchParamDefinition(name="identity", path="AuditEvent.object.identifier", description="Specific instance of object (e.g. versioned)", type="token")
    public static final String SP_IDENTITY = "identity";
    @SearchParamDefinition(name="patient", path="AuditEvent.participant.reference | AuditEvent.object.reference", description="Direct reference to resource", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="object-type", path="AuditEvent.object.type", description="Type of object involved", type="token")
    public static final String SP_OBJECTTYPE = "object-type";
    @SearchParamDefinition(name="name", path="AuditEvent.participant.name", description="Human-meaningful name for the user", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="action", path="AuditEvent.event.action", description="Type of action performed during the event", type="token")
    public static final String SP_ACTION = "action";
    @SearchParamDefinition(name="user", path="AuditEvent.participant.userId", description="Unique identifier for the user", type="token")
    public static final String SP_USER = "user";
    @SearchParamDefinition(name="desc", path="AuditEvent.object.name", description="Instance-specific descriptor for Object", type="string")
    public static final String SP_DESC = "desc";
    @SearchParamDefinition(name="policy", path="AuditEvent.participant.policy", description="Policy that authorized event", type="uri")
    public static final String SP_POLICY = "policy";

    public AuditEvent() {
    }

    public AuditEvent(AuditEventEventComponent event, AuditEventSourceComponent source) {
        this.event = event;
        this.source = source;
    }

    public AuditEventEventComponent getEvent() {
        if (this.event == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.event");
            }
            if (Configuration.doAutoCreate()) {
                this.event = new AuditEventEventComponent();
            }
        }
        return this.event;
    }

    public boolean hasEvent() {
        return this.event != null && !this.event.isEmpty();
    }

    public AuditEvent setEvent(AuditEventEventComponent value) {
        this.event = value;
        return this;
    }

    public List<AuditEventParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AuditEventParticipantComponent>();
        }
        return this.participant;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (AuditEventParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AuditEventParticipantComponent addParticipant() {
        AuditEventParticipantComponent t = new AuditEventParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<AuditEventParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public AuditEvent addParticipant(AuditEventParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<AuditEventParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public AuditEventSourceComponent getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new AuditEventSourceComponent();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public AuditEvent setSource(AuditEventSourceComponent value) {
        this.source = value;
        return this;
    }

    public List<AuditEventObjectComponent> getObject() {
        if (this.object == null) {
            this.object = new ArrayList<AuditEventObjectComponent>();
        }
        return this.object;
    }

    public boolean hasObject() {
        if (this.object == null) {
            return false;
        }
        for (AuditEventObjectComponent item : this.object) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AuditEventObjectComponent addObject() {
        AuditEventObjectComponent t = new AuditEventObjectComponent();
        if (this.object == null) {
            this.object = new ArrayList<AuditEventObjectComponent>();
        }
        this.object.add(t);
        return t;
    }

    public AuditEvent addObject(AuditEventObjectComponent t) {
        if (t == null) {
            return this;
        }
        if (this.object == null) {
            this.object = new ArrayList<AuditEventObjectComponent>();
        }
        this.object.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("event", "", "Identifies the name, action type, time, and disposition of the audited event.", 0, Integer.MAX_VALUE, this.event));
        childrenList.add(new Property(SP_PARTICIPANT, "", "A person, a hardware device or software process.", 0, Integer.MAX_VALUE, this.participant));
        childrenList.add(new Property(SP_SOURCE, "", "Application systems and processes.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property("object", "", "Specific instances of data or objects that have been accessed.", 0, Integer.MAX_VALUE, this.object));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("event")) {
            this.event = (AuditEventEventComponent)value;
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((AuditEventParticipantComponent)value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = (AuditEventSourceComponent)value;
        } else if (name.equals("object")) {
            this.getObject().add((AuditEventObjectComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("event")) {
            this.event = new AuditEventEventComponent();
            return this.event;
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new AuditEventSourceComponent();
            return this.source;
        }
        if (name.equals("object")) {
            return this.addObject();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AuditEvent";
    }

    @Override
    public AuditEvent copy() {
        AuditEvent dst = new AuditEvent();
        this.copyValues(dst);
        AuditEventEventComponent auditEventEventComponent = dst.event = this.event == null ? null : this.event.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<AuditEventParticipantComponent>();
            for (AuditEventParticipantComponent auditEventParticipantComponent : this.participant) {
                dst.participant.add(auditEventParticipantComponent.copy());
            }
        }
        AuditEventSourceComponent auditEventSourceComponent = dst.source = this.source == null ? null : this.source.copy();
        if (this.object != null) {
            dst.object = new ArrayList<AuditEventObjectComponent>();
            for (AuditEventObjectComponent auditEventObjectComponent : this.object) {
                dst.object.add(auditEventObjectComponent.copy());
            }
        }
        return dst;
    }

    protected AuditEvent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof AuditEvent)) {
            return false;
        }
        AuditEvent o = (AuditEvent)other;
        return AuditEvent.compareDeep(this.event, o.event, true) && AuditEvent.compareDeep(this.participant, o.participant, true) && AuditEvent.compareDeep(this.source, o.source, true) && AuditEvent.compareDeep(this.object, o.object, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof AuditEvent)) {
            return false;
        }
        AuditEvent o = (AuditEvent)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.event != null && !this.event.isEmpty() || this.participant != null && !this.participant.isEmpty() || this.source != null && !this.source.isEmpty() || this.object != null && !this.object.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AuditEvent;
    }

    @Block
    public static class AuditEventObjectDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the property", formalDefinition="Name of the property.")
        protected StringType type;
        @Child(name="value", type={Base64BinaryType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Property value", formalDefinition="Property value.")
        protected Base64BinaryType value;
        private static final long serialVersionUID = 11139504L;

        public AuditEventObjectDetailComponent() {
        }

        public AuditEventObjectDetailComponent(StringType type, Base64BinaryType value) {
            this.type = type;
            this.value = value;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectDetailComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventObjectDetailComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public AuditEventObjectDetailComponent setType(String value) {
            if (this.type == null) {
                this.type = new StringType();
            }
            this.type.setValue(value);
            return this;
        }

        public Base64BinaryType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectDetailComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Base64BinaryType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AuditEventObjectDetailComponent setValueElement(Base64BinaryType value) {
            this.value = value;
            return this;
        }

        public byte[] getValue() {
            return this.value == null ? null : (byte[])this.value.getValue();
        }

        public AuditEventObjectDetailComponent setValue(byte[] value) {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(AuditEvent.SP_TYPE, "string", "Name of the property.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("value", "base64Binary", "Property value.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = this.castToString(value);
            } else if (name.equals("value")) {
                this.value = this.castToBase64Binary(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.type");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.value");
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventObjectDetailComponent copy() {
            AuditEventObjectDetailComponent dst = new AuditEventObjectDetailComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AuditEventObjectDetailComponent)) {
                return false;
            }
            AuditEventObjectDetailComponent o = (AuditEventObjectDetailComponent)other;
            return AuditEventObjectDetailComponent.compareDeep(this.type, o.type, true) && AuditEventObjectDetailComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AuditEventObjectDetailComponent)) {
                return false;
            }
            AuditEventObjectDetailComponent o = (AuditEventObjectDetailComponent)other;
            return AuditEventObjectDetailComponent.compareValues(this.type, o.type, true) && AuditEventObjectDetailComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "AuditEvent.object.detail";
        }
    }

    @Block
    public static class AuditEventObjectComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific instance of object (e.g. versioned)", formalDefinition="Identifies a specific instance of the participant object. The reference should always be version specific.")
        protected Identifier identifier;
        @Child(name="reference", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific instance of resource (e.g. versioned)", formalDefinition="Identifies a specific instance of the participant object. The reference should always be version specific.")
        protected Reference reference;
        protected Resource referenceTarget;
        @Child(name="type", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of object involved", formalDefinition="The type of the object that was involved in this audit event.")
        protected Coding type;
        @Child(name="role", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What role the Object played", formalDefinition="Code representing the functional application role of Participant Object being audited.")
        protected Coding role;
        @Child(name="lifecycle", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Life-cycle stage for the object", formalDefinition="Identifier for the data life-cycle stage for the participant object.")
        protected Coding lifecycle;
        @Child(name="securityLabel", type={Coding.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Security labels applied to the object", formalDefinition="Denotes security labels for the identified object.")
        protected List<Coding> securityLabel;
        @Child(name="name", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Instance-specific descriptor for Object", formalDefinition="An instance-specific descriptor of the Participant Object ID audited, such as a person's name.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Descriptive text", formalDefinition="Text that describes the object in more detail.")
        protected StringType description;
        @Child(name="query", type={Base64BinaryType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual query for object", formalDefinition="The actual query for a query-type participant object.")
        protected Base64BinaryType query;
        @Child(name="detail", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional Information about the Object", formalDefinition="Additional Information about the Object.")
        protected List<AuditEventObjectDetailComponent> detail;
        private static final long serialVersionUID = 997591908L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public AuditEventObjectComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public AuditEventObjectComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public AuditEventObjectComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventObjectComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new Coding();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public AuditEventObjectComponent setRole(Coding value) {
            this.role = value;
            return this;
        }

        public Coding getLifecycle() {
            if (this.lifecycle == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.lifecycle");
                }
                if (Configuration.doAutoCreate()) {
                    this.lifecycle = new Coding();
                }
            }
            return this.lifecycle;
        }

        public boolean hasLifecycle() {
            return this.lifecycle != null && !this.lifecycle.isEmpty();
        }

        public AuditEventObjectComponent setLifecycle(Coding value) {
            this.lifecycle = value;
            return this;
        }

        public List<Coding> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            return this.securityLabel;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (Coding item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurityLabel() {
            Coding t = new Coding();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public AuditEventObjectComponent addSecurityLabel(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public AuditEventObjectComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public AuditEventObjectComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public AuditEventObjectComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public AuditEventObjectComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Base64BinaryType getQueryElement() {
            if (this.query == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventObjectComponent.query");
                }
                if (Configuration.doAutoCreate()) {
                    this.query = new Base64BinaryType();
                }
            }
            return this.query;
        }

        public boolean hasQueryElement() {
            return this.query != null && !this.query.isEmpty();
        }

        public boolean hasQuery() {
            return this.query != null && !this.query.isEmpty();
        }

        public AuditEventObjectComponent setQueryElement(Base64BinaryType value) {
            this.query = value;
            return this;
        }

        public byte[] getQuery() {
            return this.query == null ? null : (byte[])this.query.getValue();
        }

        public AuditEventObjectComponent setQuery(byte[] value) {
            if (value == null) {
                this.query = null;
            } else {
                if (this.query == null) {
                    this.query = new Base64BinaryType();
                }
                this.query.setValue(value);
            }
            return this;
        }

        public List<AuditEventObjectDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventObjectDetailComponent>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AuditEventObjectDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AuditEventObjectDetailComponent addDetail() {
            AuditEventObjectDetailComponent t = new AuditEventObjectDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventObjectDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AuditEventObjectComponent addDetail(AuditEventObjectDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventObjectDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identifier", "Identifier", "Identifies a specific instance of the participant object. The reference should always be version specific.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(AuditEvent.SP_REFERENCE, "Reference(Any)", "Identifies a specific instance of the participant object. The reference should always be version specific.", 0, Integer.MAX_VALUE, this.reference));
            childrenList.add(new Property(AuditEvent.SP_TYPE, "Coding", "The type of the object that was involved in this audit event.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("role", "Coding", "Code representing the functional application role of Participant Object being audited.", 0, Integer.MAX_VALUE, this.role));
            childrenList.add(new Property("lifecycle", "Coding", "Identifier for the data life-cycle stage for the participant object.", 0, Integer.MAX_VALUE, this.lifecycle));
            childrenList.add(new Property("securityLabel", "Coding", "Denotes security labels for the identified object.", 0, Integer.MAX_VALUE, this.securityLabel));
            childrenList.add(new Property(AuditEvent.SP_NAME, "string", "An instance-specific descriptor of the Participant Object ID audited, such as a person's name.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("description", "string", "Text that describes the object in more detail.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("query", "base64Binary", "The actual query for a query-type participant object.", 0, Integer.MAX_VALUE, this.query));
            childrenList.add(new Property("detail", "", "Additional Information about the Object.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals(AuditEvent.SP_REFERENCE)) {
                this.reference = this.castToReference(value);
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = this.castToCoding(value);
            } else if (name.equals("role")) {
                this.role = this.castToCoding(value);
            } else if (name.equals("lifecycle")) {
                this.lifecycle = this.castToCoding(value);
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(this.castToCoding(value));
            } else if (name.equals(AuditEvent.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("query")) {
                this.query = this.castToBase64Binary(value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AuditEventObjectDetailComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(AuditEvent.SP_REFERENCE)) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("role")) {
                this.role = new Coding();
                return this.role;
            }
            if (name.equals("lifecycle")) {
                this.lifecycle = new Coding();
                return this.lifecycle;
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals(AuditEvent.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.description");
            }
            if (name.equals("query")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.query");
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventObjectComponent copy() {
            AuditEventObjectComponent dst = new AuditEventObjectComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.role = this.role == null ? null : this.role.copy();
            Coding coding = dst.lifecycle = this.lifecycle == null ? null : this.lifecycle.copy();
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<Coding>();
                for (Coding coding2 : this.securityLabel) {
                    dst.securityLabel.add(coding2.copy());
                }
            }
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            Base64BinaryType base64BinaryType = dst.query = this.query == null ? null : this.query.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<AuditEventObjectDetailComponent>();
                for (AuditEventObjectDetailComponent auditEventObjectDetailComponent : this.detail) {
                    dst.detail.add(auditEventObjectDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AuditEventObjectComponent)) {
                return false;
            }
            AuditEventObjectComponent o = (AuditEventObjectComponent)other;
            return AuditEventObjectComponent.compareDeep(this.identifier, o.identifier, true) && AuditEventObjectComponent.compareDeep(this.reference, o.reference, true) && AuditEventObjectComponent.compareDeep(this.type, o.type, true) && AuditEventObjectComponent.compareDeep(this.role, o.role, true) && AuditEventObjectComponent.compareDeep(this.lifecycle, o.lifecycle, true) && AuditEventObjectComponent.compareDeep(this.securityLabel, o.securityLabel, true) && AuditEventObjectComponent.compareDeep(this.name, o.name, true) && AuditEventObjectComponent.compareDeep(this.description, o.description, true) && AuditEventObjectComponent.compareDeep(this.query, o.query, true) && AuditEventObjectComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AuditEventObjectComponent)) {
                return false;
            }
            AuditEventObjectComponent o = (AuditEventObjectComponent)other;
            return AuditEventObjectComponent.compareValues(this.name, o.name, true) && AuditEventObjectComponent.compareValues(this.description, o.description, true) && AuditEventObjectComponent.compareValues(this.query, o.query, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.type != null && !this.type.isEmpty() || this.role != null && !this.role.isEmpty() || this.lifecycle != null && !this.lifecycle.isEmpty() || this.securityLabel != null && !this.securityLabel.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.query != null && !this.query.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "AuditEvent.object";
        }
    }

    @Block
    public static class AuditEventSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="site", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Logical source location within the enterprise", formalDefinition="Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.")
        protected StringType site;
        @Child(name="identifier", type={Identifier.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identity of source detecting the event", formalDefinition="Identifier of the source where the event was detected.")
        protected Identifier identifier;
        @Child(name="type", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The type of source where event originated", formalDefinition="Code specifying the type of source where event originated.")
        protected List<Coding> type;
        private static final long serialVersionUID = -1562673890L;

        public AuditEventSourceComponent() {
        }

        public AuditEventSourceComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public StringType getSiteElement() {
            if (this.site == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventSourceComponent.site");
                }
                if (Configuration.doAutoCreate()) {
                    this.site = new StringType();
                }
            }
            return this.site;
        }

        public boolean hasSiteElement() {
            return this.site != null && !this.site.isEmpty();
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public AuditEventSourceComponent setSiteElement(StringType value) {
            this.site = value;
            return this;
        }

        public String getSite() {
            return this.site == null ? null : (String)this.site.getValue();
        }

        public AuditEventSourceComponent setSite(String value) {
            if (Utilities.noString(value)) {
                this.site = null;
            } else {
                if (this.site == null) {
                    this.site = new StringType();
                }
                this.site.setValue(value);
            }
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventSourceComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public AuditEventSourceComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public List<Coding> getType() {
            if (this.type == null) {
                this.type = new ArrayList<Coding>();
            }
            return this.type;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (Coding item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addType() {
            Coding t = new Coding();
            if (this.type == null) {
                this.type = new ArrayList<Coding>();
            }
            this.type.add(t);
            return t;
        }

        public AuditEventSourceComponent addType(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<Coding>();
            }
            this.type.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(AuditEvent.SP_SITE, "string", "Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.", 0, Integer.MAX_VALUE, this.site));
            childrenList.add(new Property("identifier", "Identifier", "Identifier of the source where the event was detected.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(AuditEvent.SP_TYPE, "Coding", "Code specifying the type of source where event originated.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_SITE)) {
                this.site = this.castToString(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.getType().add(this.castToCoding(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_SITE)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.site");
            }
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(AuditEvent.SP_TYPE)) {
                return this.addType();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventSourceComponent copy() {
            AuditEventSourceComponent dst = new AuditEventSourceComponent();
            this.copyValues(dst);
            dst.site = this.site == null ? null : this.site.copy();
            Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
            if (this.type != null) {
                dst.type = new ArrayList<Coding>();
                for (Coding i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AuditEventSourceComponent)) {
                return false;
            }
            AuditEventSourceComponent o = (AuditEventSourceComponent)other;
            return AuditEventSourceComponent.compareDeep(this.site, o.site, true) && AuditEventSourceComponent.compareDeep(this.identifier, o.identifier, true) && AuditEventSourceComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AuditEventSourceComponent)) {
                return false;
            }
            AuditEventSourceComponent o = (AuditEventSourceComponent)other;
            return AuditEventSourceComponent.compareValues(this.site, o.site, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.site != null && !this.site.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.type != null && !this.type.isEmpty());
        }

        @Override
        public String fhirType() {
            return "AuditEvent.source";
        }
    }

    @Block
    public static class AuditEventParticipantNetworkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="address", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier for the network access point of the user device", formalDefinition="An identifier for the network access point of the user device for the audit event.")
        protected StringType address;
        @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of network access point", formalDefinition="An identifier for the type of network access point that originated the audit event.")
        protected Enumeration<AuditEventParticipantNetworkType> type;
        private static final long serialVersionUID = -1355220390L;

        public StringType getAddressElement() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantNetworkComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new StringType();
                }
            }
            return this.address;
        }

        public boolean hasAddressElement() {
            return this.address != null && !this.address.isEmpty();
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public AuditEventParticipantNetworkComponent setAddressElement(StringType value) {
            this.address = value;
            return this;
        }

        public String getAddress() {
            return this.address == null ? null : (String)this.address.getValue();
        }

        public AuditEventParticipantNetworkComponent setAddress(String value) {
            if (Utilities.noString(value)) {
                this.address = null;
            } else {
                if (this.address == null) {
                    this.address = new StringType();
                }
                this.address.setValue(value);
            }
            return this;
        }

        public Enumeration<AuditEventParticipantNetworkType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantNetworkComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<AuditEventParticipantNetworkType>(new AuditEventParticipantNetworkTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventParticipantNetworkComponent setTypeElement(Enumeration<AuditEventParticipantNetworkType> value) {
            this.type = value;
            return this;
        }

        public AuditEventParticipantNetworkType getType() {
            return this.type == null ? null : (AuditEventParticipantNetworkType)((Object)this.type.getValue());
        }

        public AuditEventParticipantNetworkComponent setType(AuditEventParticipantNetworkType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<AuditEventParticipantNetworkType>(new AuditEventParticipantNetworkTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(AuditEvent.SP_ADDRESS, "string", "An identifier for the network access point of the user device for the audit event.", 0, Integer.MAX_VALUE, this.address));
            childrenList.add(new Property(AuditEvent.SP_TYPE, "code", "An identifier for the type of network access point that originated the audit event.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_ADDRESS)) {
                this.address = this.castToString(value);
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = new AuditEventParticipantNetworkTypeEnumFactory().fromType(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_ADDRESS)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.address");
            }
            if (name.equals(AuditEvent.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.type");
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventParticipantNetworkComponent copy() {
            AuditEventParticipantNetworkComponent dst = new AuditEventParticipantNetworkComponent();
            this.copyValues(dst);
            dst.address = this.address == null ? null : this.address.copy();
            dst.type = this.type == null ? null : this.type.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AuditEventParticipantNetworkComponent)) {
                return false;
            }
            AuditEventParticipantNetworkComponent o = (AuditEventParticipantNetworkComponent)other;
            return AuditEventParticipantNetworkComponent.compareDeep(this.address, o.address, true) && AuditEventParticipantNetworkComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AuditEventParticipantNetworkComponent)) {
                return false;
            }
            AuditEventParticipantNetworkComponent o = (AuditEventParticipantNetworkComponent)other;
            return AuditEventParticipantNetworkComponent.compareValues(this.address, o.address, true) && AuditEventParticipantNetworkComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.address != null && !this.address.isEmpty() || this.type != null && !this.type.isEmpty());
        }

        @Override
        public String fhirType() {
            return "AuditEvent.participant.network";
        }
    }

    @Block
    public static class AuditEventParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="User roles (e.g. local RBAC codes)", formalDefinition="Specification of the role(s) the user plays when performing the event. Usually the codes used in this element are local codes defined by the role-based access control security system used in the local context.")
        protected List<CodeableConcept> role;
        @Child(name="reference", type={Practitioner.class, Organization.class, Device.class, Patient.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Direct reference to resource", formalDefinition="Direct reference to a resource that identifies the participant.")
        protected Reference reference;
        protected Resource referenceTarget;
        @Child(name="userId", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique identifier for the user", formalDefinition="Unique identifier for the user actively participating in the event.")
        protected Identifier userId;
        @Child(name="altId", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Alternative User id e.g. authentication", formalDefinition="Alternative Participant Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g. single sign-on), if available.")
        protected StringType altId;
        @Child(name="name", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-meaningful name for the user", formalDefinition="Human-meaningful name for the user.")
        protected StringType name;
        @Child(name="requestor", type={BooleanType.class}, order=6, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether user is initiator", formalDefinition="Indicator that the user is or is not the requestor, or initiator, for the event being audited.")
        protected BooleanType requestor;
        @Child(name="location", type={Location.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where", formalDefinition="Where the event occurred.")
        protected Reference location;
        protected Location locationTarget;
        @Child(name="policy", type={UriType.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Policy that authorized event", formalDefinition="The policy or plan that authorized the activity being recorded. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.")
        protected List<UriType> policy;
        @Child(name="media", type={Coding.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of media", formalDefinition="Type of media involved. Used when the event is about exporting/importing onto media.")
        protected Coding media;
        @Child(name="network", type={}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Logical network location for application activity", formalDefinition="Logical network location for application activity, if the activity has a network location.")
        protected AuditEventParticipantNetworkComponent network;
        @Child(name="purposeOfUse", type={Coding.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Reason given for this user", formalDefinition="The reason (purpose of use), specific to this participant, that was used during the event being recorded.")
        protected List<Coding> purposeOfUse;
        private static final long serialVersionUID = -1783296995L;

        public AuditEventParticipantComponent() {
        }

        public AuditEventParticipantComponent(BooleanType requestor) {
            this.requestor = requestor;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public AuditEventParticipantComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public AuditEventParticipantComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public AuditEventParticipantComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        public Identifier getUserId() {
            if (this.userId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.userId");
                }
                if (Configuration.doAutoCreate()) {
                    this.userId = new Identifier();
                }
            }
            return this.userId;
        }

        public boolean hasUserId() {
            return this.userId != null && !this.userId.isEmpty();
        }

        public AuditEventParticipantComponent setUserId(Identifier value) {
            this.userId = value;
            return this;
        }

        public StringType getAltIdElement() {
            if (this.altId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.altId");
                }
                if (Configuration.doAutoCreate()) {
                    this.altId = new StringType();
                }
            }
            return this.altId;
        }

        public boolean hasAltIdElement() {
            return this.altId != null && !this.altId.isEmpty();
        }

        public boolean hasAltId() {
            return this.altId != null && !this.altId.isEmpty();
        }

        public AuditEventParticipantComponent setAltIdElement(StringType value) {
            this.altId = value;
            return this;
        }

        public String getAltId() {
            return this.altId == null ? null : (String)this.altId.getValue();
        }

        public AuditEventParticipantComponent setAltId(String value) {
            if (Utilities.noString(value)) {
                this.altId = null;
            } else {
                if (this.altId == null) {
                    this.altId = new StringType();
                }
                this.altId.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public AuditEventParticipantComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public AuditEventParticipantComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public BooleanType getRequestorElement() {
            if (this.requestor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.requestor");
                }
                if (Configuration.doAutoCreate()) {
                    this.requestor = new BooleanType();
                }
            }
            return this.requestor;
        }

        public boolean hasRequestorElement() {
            return this.requestor != null && !this.requestor.isEmpty();
        }

        public boolean hasRequestor() {
            return this.requestor != null && !this.requestor.isEmpty();
        }

        public AuditEventParticipantComponent setRequestorElement(BooleanType value) {
            this.requestor = value;
            return this;
        }

        public boolean getRequestor() {
            return this.requestor == null || this.requestor.isEmpty() ? false : (Boolean)this.requestor.getValue();
        }

        public AuditEventParticipantComponent setRequestor(boolean value) {
            if (this.requestor == null) {
                this.requestor = new BooleanType();
            }
            this.requestor.setValue((Object)value);
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AuditEventParticipantComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Location getLocationTarget() {
            if (this.locationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.locationTarget = new Location();
                }
            }
            return this.locationTarget;
        }

        public AuditEventParticipantComponent setLocationTarget(Location value) {
            this.locationTarget = value;
            return this;
        }

        public List<UriType> getPolicy() {
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            return this.policy;
        }

        public boolean hasPolicy() {
            if (this.policy == null) {
                return false;
            }
            for (UriType item : this.policy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addPolicyElement() {
            UriType t = new UriType();
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            this.policy.add(t);
            return t;
        }

        public AuditEventParticipantComponent addPolicy(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            this.policy.add(t);
            return this;
        }

        public boolean hasPolicy(String value) {
            if (this.policy == null) {
                return false;
            }
            for (UriType v : this.policy) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Coding getMedia() {
            if (this.media == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.media");
                }
                if (Configuration.doAutoCreate()) {
                    this.media = new Coding();
                }
            }
            return this.media;
        }

        public boolean hasMedia() {
            return this.media != null && !this.media.isEmpty();
        }

        public AuditEventParticipantComponent setMedia(Coding value) {
            this.media = value;
            return this;
        }

        public AuditEventParticipantNetworkComponent getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventParticipantComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new AuditEventParticipantNetworkComponent();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public AuditEventParticipantComponent setNetwork(AuditEventParticipantNetworkComponent value) {
            this.network = value;
            return this;
        }

        public List<Coding> getPurposeOfUse() {
            if (this.purposeOfUse == null) {
                this.purposeOfUse = new ArrayList<Coding>();
            }
            return this.purposeOfUse;
        }

        public boolean hasPurposeOfUse() {
            if (this.purposeOfUse == null) {
                return false;
            }
            for (Coding item : this.purposeOfUse) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addPurposeOfUse() {
            Coding t = new Coding();
            if (this.purposeOfUse == null) {
                this.purposeOfUse = new ArrayList<Coding>();
            }
            this.purposeOfUse.add(t);
            return t;
        }

        public AuditEventParticipantComponent addPurposeOfUse(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.purposeOfUse == null) {
                this.purposeOfUse = new ArrayList<Coding>();
            }
            this.purposeOfUse.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("role", "CodeableConcept", "Specification of the role(s) the user plays when performing the event. Usually the codes used in this element are local codes defined by the role-based access control security system used in the local context.", 0, Integer.MAX_VALUE, this.role));
            childrenList.add(new Property(AuditEvent.SP_REFERENCE, "Reference(Practitioner|Organization|Device|Patient|RelatedPerson)", "Direct reference to a resource that identifies the participant.", 0, Integer.MAX_VALUE, this.reference));
            childrenList.add(new Property("userId", "Identifier", "Unique identifier for the user actively participating in the event.", 0, Integer.MAX_VALUE, this.userId));
            childrenList.add(new Property("altId", "string", "Alternative Participant Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g. single sign-on), if available.", 0, Integer.MAX_VALUE, this.altId));
            childrenList.add(new Property(AuditEvent.SP_NAME, "string", "Human-meaningful name for the user.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("requestor", "boolean", "Indicator that the user is or is not the requestor, or initiator, for the event being audited.", 0, Integer.MAX_VALUE, this.requestor));
            childrenList.add(new Property("location", "Reference(Location)", "Where the event occurred.", 0, Integer.MAX_VALUE, this.location));
            childrenList.add(new Property(AuditEvent.SP_POLICY, "uri", "The policy or plan that authorized the activity being recorded. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.", 0, Integer.MAX_VALUE, this.policy));
            childrenList.add(new Property("media", "Coding", "Type of media involved. Used when the event is about exporting/importing onto media.", 0, Integer.MAX_VALUE, this.media));
            childrenList.add(new Property("network", "", "Logical network location for application activity, if the activity has a network location.", 0, Integer.MAX_VALUE, this.network));
            childrenList.add(new Property("purposeOfUse", "Coding", "The reason (purpose of use), specific to this participant, that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.purposeOfUse));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.getRole().add(this.castToCodeableConcept(value));
            } else if (name.equals(AuditEvent.SP_REFERENCE)) {
                this.reference = this.castToReference(value);
            } else if (name.equals("userId")) {
                this.userId = this.castToIdentifier(value);
            } else if (name.equals("altId")) {
                this.altId = this.castToString(value);
            } else if (name.equals(AuditEvent.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("requestor")) {
                this.requestor = this.castToBoolean(value);
            } else if (name.equals("location")) {
                this.location = this.castToReference(value);
            } else if (name.equals(AuditEvent.SP_POLICY)) {
                this.getPolicy().add(this.castToUri(value));
            } else if (name.equals("media")) {
                this.media = this.castToCoding(value);
            } else if (name.equals("network")) {
                this.network = (AuditEventParticipantNetworkComponent)value;
            } else if (name.equals("purposeOfUse")) {
                this.getPurposeOfUse().add(this.castToCoding(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                return this.addRole();
            }
            if (name.equals(AuditEvent.SP_REFERENCE)) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("userId")) {
                this.userId = new Identifier();
                return this.userId;
            }
            if (name.equals("altId")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.altId");
            }
            if (name.equals(AuditEvent.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.name");
            }
            if (name.equals("requestor")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.requestor");
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(AuditEvent.SP_POLICY)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.policy");
            }
            if (name.equals("media")) {
                this.media = new Coding();
                return this.media;
            }
            if (name.equals("network")) {
                this.network = new AuditEventParticipantNetworkComponent();
                return this.network;
            }
            if (name.equals("purposeOfUse")) {
                return this.addPurposeOfUse();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventParticipantComponent copy() {
            AuditEventParticipantComponent dst = new AuditEventParticipantComponent();
            this.copyValues(dst);
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.role) {
                    dst.role.add(codeableConcept.copy());
                }
            }
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.userId = this.userId == null ? null : this.userId.copy();
            dst.altId = this.altId == null ? null : this.altId.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.requestor = this.requestor == null ? null : this.requestor.copy();
            Reference reference = dst.location = this.location == null ? null : this.location.copy();
            if (this.policy != null) {
                dst.policy = new ArrayList<UriType>();
                for (UriType uriType : this.policy) {
                    dst.policy.add(uriType.copy());
                }
            }
            dst.media = this.media == null ? null : this.media.copy();
            AuditEventParticipantNetworkComponent auditEventParticipantNetworkComponent = dst.network = this.network == null ? null : this.network.copy();
            if (this.purposeOfUse != null) {
                dst.purposeOfUse = new ArrayList<Coding>();
                for (Coding coding : this.purposeOfUse) {
                    dst.purposeOfUse.add(coding.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AuditEventParticipantComponent)) {
                return false;
            }
            AuditEventParticipantComponent o = (AuditEventParticipantComponent)other;
            return AuditEventParticipantComponent.compareDeep(this.role, o.role, true) && AuditEventParticipantComponent.compareDeep(this.reference, o.reference, true) && AuditEventParticipantComponent.compareDeep(this.userId, o.userId, true) && AuditEventParticipantComponent.compareDeep(this.altId, o.altId, true) && AuditEventParticipantComponent.compareDeep(this.name, o.name, true) && AuditEventParticipantComponent.compareDeep(this.requestor, o.requestor, true) && AuditEventParticipantComponent.compareDeep(this.location, o.location, true) && AuditEventParticipantComponent.compareDeep(this.policy, o.policy, true) && AuditEventParticipantComponent.compareDeep(this.media, o.media, true) && AuditEventParticipantComponent.compareDeep(this.network, o.network, true) && AuditEventParticipantComponent.compareDeep(this.purposeOfUse, o.purposeOfUse, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AuditEventParticipantComponent)) {
                return false;
            }
            AuditEventParticipantComponent o = (AuditEventParticipantComponent)other;
            return AuditEventParticipantComponent.compareValues(this.altId, o.altId, true) && AuditEventParticipantComponent.compareValues(this.name, o.name, true) && AuditEventParticipantComponent.compareValues(this.requestor, o.requestor, true) && AuditEventParticipantComponent.compareValues(this.policy, o.policy, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.role != null && !this.role.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.userId != null && !this.userId.isEmpty() || this.altId != null && !this.altId.isEmpty() || this.name != null && !this.name.isEmpty() || this.requestor != null && !this.requestor.isEmpty() || this.location != null && !this.location.isEmpty() || this.policy != null && !this.policy.isEmpty() || this.media != null && !this.media.isEmpty() || this.network != null && !this.network.isEmpty() || this.purposeOfUse != null && !this.purposeOfUse.isEmpty());
        }

        @Override
        public String fhirType() {
            return "AuditEvent.participant";
        }
    }

    @Block
    public static class AuditEventEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type/identifier of event", formalDefinition="Identifier for a family of the event.  For example, a menu item, program, rule, policy, function code, application name or URL. It identifies the performed function.")
        protected Coding type;
        @Child(name="subtype", type={Coding.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="More specific type/id for the event", formalDefinition="Identifier for the category of event.")
        protected List<Coding> subtype;
        @Child(name="action", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of action performed during the event", formalDefinition="Indicator for type of action performed during the event that generated the audit.")
        protected Enumeration<AuditEventAction> action;
        @Child(name="dateTime", type={InstantType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Time when the event occurred on source", formalDefinition="The time when the event occurred on the source.")
        protected InstantType dateTime;
        @Child(name="outcome", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether the event succeeded or failed", formalDefinition="Indicates whether the event succeeded or failed.")
        protected Enumeration<AuditEventOutcome> outcome;
        @Child(name="outcomeDesc", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of the event outcome", formalDefinition="A free text description of the outcome of the event.")
        protected StringType outcomeDesc;
        @Child(name="purposeOfEvent", type={Coding.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The purposeOfUse of the event", formalDefinition="The purposeOfUse (reason) that was used during the event being recorded.")
        protected List<Coding> purposeOfEvent;
        private static final long serialVersionUID = 1916806397L;

        public AuditEventEventComponent() {
        }

        public AuditEventEventComponent(Coding type, InstantType dateTime) {
            this.type = type;
            this.dateTime = dateTime;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEventComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventEventComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public List<Coding> getSubtype() {
            if (this.subtype == null) {
                this.subtype = new ArrayList<Coding>();
            }
            return this.subtype;
        }

        public boolean hasSubtype() {
            if (this.subtype == null) {
                return false;
            }
            for (Coding item : this.subtype) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSubtype() {
            Coding t = new Coding();
            if (this.subtype == null) {
                this.subtype = new ArrayList<Coding>();
            }
            this.subtype.add(t);
            return t;
        }

        public AuditEventEventComponent addSubtype(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.subtype == null) {
                this.subtype = new ArrayList<Coding>();
            }
            this.subtype.add(t);
            return this;
        }

        public Enumeration<AuditEventAction> getActionElement() {
            if (this.action == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEventComponent.action");
                }
                if (Configuration.doAutoCreate()) {
                    this.action = new Enumeration<AuditEventAction>(new AuditEventActionEnumFactory());
                }
            }
            return this.action;
        }

        public boolean hasActionElement() {
            return this.action != null && !this.action.isEmpty();
        }

        public boolean hasAction() {
            return this.action != null && !this.action.isEmpty();
        }

        public AuditEventEventComponent setActionElement(Enumeration<AuditEventAction> value) {
            this.action = value;
            return this;
        }

        public AuditEventAction getAction() {
            return this.action == null ? null : (AuditEventAction)((Object)this.action.getValue());
        }

        public AuditEventEventComponent setAction(AuditEventAction value) {
            if (value == null) {
                this.action = null;
            } else {
                if (this.action == null) {
                    this.action = new Enumeration<AuditEventAction>(new AuditEventActionEnumFactory());
                }
                this.action.setValue((Object)value);
            }
            return this;
        }

        public InstantType getDateTimeElement() {
            if (this.dateTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEventComponent.dateTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateTime = new InstantType();
                }
            }
            return this.dateTime;
        }

        public boolean hasDateTimeElement() {
            return this.dateTime != null && !this.dateTime.isEmpty();
        }

        public boolean hasDateTime() {
            return this.dateTime != null && !this.dateTime.isEmpty();
        }

        public AuditEventEventComponent setDateTimeElement(InstantType value) {
            this.dateTime = value;
            return this;
        }

        public Date getDateTime() {
            return this.dateTime == null ? null : (Date)this.dateTime.getValue();
        }

        public AuditEventEventComponent setDateTime(Date value) {
            if (this.dateTime == null) {
                this.dateTime = new InstantType();
            }
            this.dateTime.setValue(value);
            return this;
        }

        public Enumeration<AuditEventOutcome> getOutcomeElement() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEventComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new Enumeration<AuditEventOutcome>(new AuditEventOutcomeEnumFactory());
                }
            }
            return this.outcome;
        }

        public boolean hasOutcomeElement() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public AuditEventEventComponent setOutcomeElement(Enumeration<AuditEventOutcome> value) {
            this.outcome = value;
            return this;
        }

        public AuditEventOutcome getOutcome() {
            return this.outcome == null ? null : (AuditEventOutcome)((Object)this.outcome.getValue());
        }

        public AuditEventEventComponent setOutcome(AuditEventOutcome value) {
            if (value == null) {
                this.outcome = null;
            } else {
                if (this.outcome == null) {
                    this.outcome = new Enumeration<AuditEventOutcome>(new AuditEventOutcomeEnumFactory());
                }
                this.outcome.setValue((Object)value);
            }
            return this;
        }

        public StringType getOutcomeDescElement() {
            if (this.outcomeDesc == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEventComponent.outcomeDesc");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcomeDesc = new StringType();
                }
            }
            return this.outcomeDesc;
        }

        public boolean hasOutcomeDescElement() {
            return this.outcomeDesc != null && !this.outcomeDesc.isEmpty();
        }

        public boolean hasOutcomeDesc() {
            return this.outcomeDesc != null && !this.outcomeDesc.isEmpty();
        }

        public AuditEventEventComponent setOutcomeDescElement(StringType value) {
            this.outcomeDesc = value;
            return this;
        }

        public String getOutcomeDesc() {
            return this.outcomeDesc == null ? null : (String)this.outcomeDesc.getValue();
        }

        public AuditEventEventComponent setOutcomeDesc(String value) {
            if (Utilities.noString(value)) {
                this.outcomeDesc = null;
            } else {
                if (this.outcomeDesc == null) {
                    this.outcomeDesc = new StringType();
                }
                this.outcomeDesc.setValue(value);
            }
            return this;
        }

        public List<Coding> getPurposeOfEvent() {
            if (this.purposeOfEvent == null) {
                this.purposeOfEvent = new ArrayList<Coding>();
            }
            return this.purposeOfEvent;
        }

        public boolean hasPurposeOfEvent() {
            if (this.purposeOfEvent == null) {
                return false;
            }
            for (Coding item : this.purposeOfEvent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addPurposeOfEvent() {
            Coding t = new Coding();
            if (this.purposeOfEvent == null) {
                this.purposeOfEvent = new ArrayList<Coding>();
            }
            this.purposeOfEvent.add(t);
            return t;
        }

        public AuditEventEventComponent addPurposeOfEvent(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.purposeOfEvent == null) {
                this.purposeOfEvent = new ArrayList<Coding>();
            }
            this.purposeOfEvent.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(AuditEvent.SP_TYPE, "Coding", "Identifier for a family of the event.  For example, a menu item, program, rule, policy, function code, application name or URL. It identifies the performed function.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(AuditEvent.SP_SUBTYPE, "Coding", "Identifier for the category of event.", 0, Integer.MAX_VALUE, this.subtype));
            childrenList.add(new Property(AuditEvent.SP_ACTION, "code", "Indicator for type of action performed during the event that generated the audit.", 0, Integer.MAX_VALUE, this.action));
            childrenList.add(new Property("dateTime", "instant", "The time when the event occurred on the source.", 0, Integer.MAX_VALUE, this.dateTime));
            childrenList.add(new Property("outcome", "code", "Indicates whether the event succeeded or failed.", 0, Integer.MAX_VALUE, this.outcome));
            childrenList.add(new Property("outcomeDesc", "string", "A free text description of the outcome of the event.", 0, Integer.MAX_VALUE, this.outcomeDesc));
            childrenList.add(new Property("purposeOfEvent", "Coding", "The purposeOfUse (reason) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.purposeOfEvent));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = this.castToCoding(value);
            } else if (name.equals(AuditEvent.SP_SUBTYPE)) {
                this.getSubtype().add(this.castToCoding(value));
            } else if (name.equals(AuditEvent.SP_ACTION)) {
                this.action = new AuditEventActionEnumFactory().fromType(value);
            } else if (name.equals("dateTime")) {
                this.dateTime = this.castToInstant(value);
            } else if (name.equals("outcome")) {
                this.outcome = new AuditEventOutcomeEnumFactory().fromType(value);
            } else if (name.equals("outcomeDesc")) {
                this.outcomeDesc = this.castToString(value);
            } else if (name.equals("purposeOfEvent")) {
                this.getPurposeOfEvent().add(this.castToCoding(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals(AuditEvent.SP_SUBTYPE)) {
                return this.addSubtype();
            }
            if (name.equals(AuditEvent.SP_ACTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.action");
            }
            if (name.equals("dateTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.dateTime");
            }
            if (name.equals("outcome")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.outcome");
            }
            if (name.equals("outcomeDesc")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.outcomeDesc");
            }
            if (name.equals("purposeOfEvent")) {
                return this.addPurposeOfEvent();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventEventComponent copy() {
            AuditEventEventComponent dst = new AuditEventEventComponent();
            this.copyValues(dst);
            Coding coding = dst.type = this.type == null ? null : this.type.copy();
            if (this.subtype != null) {
                dst.subtype = new ArrayList<Coding>();
                for (Coding i : this.subtype) {
                    dst.subtype.add(i.copy());
                }
            }
            dst.action = this.action == null ? null : this.action.copy();
            dst.dateTime = this.dateTime == null ? null : this.dateTime.copy();
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            StringType stringType = dst.outcomeDesc = this.outcomeDesc == null ? null : this.outcomeDesc.copy();
            if (this.purposeOfEvent != null) {
                dst.purposeOfEvent = new ArrayList<Coding>();
                for (Coding i : this.purposeOfEvent) {
                    dst.purposeOfEvent.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AuditEventEventComponent)) {
                return false;
            }
            AuditEventEventComponent o = (AuditEventEventComponent)other;
            return AuditEventEventComponent.compareDeep(this.type, o.type, true) && AuditEventEventComponent.compareDeep(this.subtype, o.subtype, true) && AuditEventEventComponent.compareDeep(this.action, o.action, true) && AuditEventEventComponent.compareDeep(this.dateTime, o.dateTime, true) && AuditEventEventComponent.compareDeep(this.outcome, o.outcome, true) && AuditEventEventComponent.compareDeep(this.outcomeDesc, o.outcomeDesc, true) && AuditEventEventComponent.compareDeep(this.purposeOfEvent, o.purposeOfEvent, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AuditEventEventComponent)) {
                return false;
            }
            AuditEventEventComponent o = (AuditEventEventComponent)other;
            return AuditEventEventComponent.compareValues(this.action, o.action, true) && AuditEventEventComponent.compareValues(this.dateTime, o.dateTime, true) && AuditEventEventComponent.compareValues(this.outcome, o.outcome, true) && AuditEventEventComponent.compareValues(this.outcomeDesc, o.outcomeDesc, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.subtype != null && !this.subtype.isEmpty() || this.action != null && !this.action.isEmpty() || this.dateTime != null && !this.dateTime.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.outcomeDesc != null && !this.outcomeDesc.isEmpty() || this.purposeOfEvent != null && !this.purposeOfEvent.isEmpty());
        }

        @Override
        public String fhirType() {
            return "AuditEvent.event";
        }
    }

    public static class AuditEventParticipantNetworkTypeEnumFactory
    implements EnumFactory<AuditEventParticipantNetworkType> {
        @Override
        public AuditEventParticipantNetworkType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("1".equals(codeString)) {
                return AuditEventParticipantNetworkType._1;
            }
            if ("2".equals(codeString)) {
                return AuditEventParticipantNetworkType._2;
            }
            if ("3".equals(codeString)) {
                return AuditEventParticipantNetworkType._3;
            }
            if ("4".equals(codeString)) {
                return AuditEventParticipantNetworkType._4;
            }
            if ("5".equals(codeString)) {
                return AuditEventParticipantNetworkType._5;
            }
            throw new IllegalArgumentException("Unknown AuditEventParticipantNetworkType code '" + codeString + "'");
        }

        public Enumeration<AuditEventParticipantNetworkType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("1".equals(codeString)) {
                return new Enumeration<AuditEventParticipantNetworkType>(this, AuditEventParticipantNetworkType._1);
            }
            if ("2".equals(codeString)) {
                return new Enumeration<AuditEventParticipantNetworkType>(this, AuditEventParticipantNetworkType._2);
            }
            if ("3".equals(codeString)) {
                return new Enumeration<AuditEventParticipantNetworkType>(this, AuditEventParticipantNetworkType._3);
            }
            if ("4".equals(codeString)) {
                return new Enumeration<AuditEventParticipantNetworkType>(this, AuditEventParticipantNetworkType._4);
            }
            if ("5".equals(codeString)) {
                return new Enumeration<AuditEventParticipantNetworkType>(this, AuditEventParticipantNetworkType._5);
            }
            throw new FHIRException("Unknown AuditEventParticipantNetworkType code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventParticipantNetworkType code) {
            if (code == AuditEventParticipantNetworkType._1) {
                return "1";
            }
            if (code == AuditEventParticipantNetworkType._2) {
                return "2";
            }
            if (code == AuditEventParticipantNetworkType._3) {
                return "3";
            }
            if (code == AuditEventParticipantNetworkType._4) {
                return "4";
            }
            if (code == AuditEventParticipantNetworkType._5) {
                return "5";
            }
            return "?";
        }
    }

    public static enum AuditEventParticipantNetworkType {
        _1,
        _2,
        _3,
        _4,
        _5,
        NULL;


        public static AuditEventParticipantNetworkType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("1".equals(codeString)) {
                return _1;
            }
            if ("2".equals(codeString)) {
                return _2;
            }
            if ("3".equals(codeString)) {
                return _3;
            }
            if ("4".equals(codeString)) {
                return _4;
            }
            if ("5".equals(codeString)) {
                return _5;
            }
            throw new FHIRException("Unknown AuditEventParticipantNetworkType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case _1: {
                    return "1";
                }
                case _2: {
                    return "2";
                }
                case _3: {
                    return "3";
                }
                case _4: {
                    return "4";
                }
                case _5: {
                    return "5";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case _1: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _2: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _3: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _4: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _5: {
                    return "http://hl7.org/fhir/network-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case _1: {
                    return "The machine name, including DNS name.";
                }
                case _2: {
                    return "The assigned Internet Protocol (IP) address.";
                }
                case _3: {
                    return "The assigned telephone number.";
                }
                case _4: {
                    return "The assigned email address.";
                }
                case _5: {
                    return "URI (User directory, HTTP-PUT, ftp, etc.).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case _1: {
                    return "Machine Name";
                }
                case _2: {
                    return "IP Address";
                }
                case _3: {
                    return "Telephone Number";
                }
                case _4: {
                    return "Email address";
                }
                case _5: {
                    return "URI";
                }
            }
            return "?";
        }
    }

    public static class AuditEventOutcomeEnumFactory
    implements EnumFactory<AuditEventOutcome> {
        @Override
        public AuditEventOutcome fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("0".equals(codeString)) {
                return AuditEventOutcome._0;
            }
            if ("4".equals(codeString)) {
                return AuditEventOutcome._4;
            }
            if ("8".equals(codeString)) {
                return AuditEventOutcome._8;
            }
            if ("12".equals(codeString)) {
                return AuditEventOutcome._12;
            }
            throw new IllegalArgumentException("Unknown AuditEventOutcome code '" + codeString + "'");
        }

        public Enumeration<AuditEventOutcome> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("0".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._0);
            }
            if ("4".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._4);
            }
            if ("8".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._8);
            }
            if ("12".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._12);
            }
            throw new FHIRException("Unknown AuditEventOutcome code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventOutcome code) {
            if (code == AuditEventOutcome._0) {
                return "0";
            }
            if (code == AuditEventOutcome._4) {
                return "4";
            }
            if (code == AuditEventOutcome._8) {
                return "8";
            }
            if (code == AuditEventOutcome._12) {
                return "12";
            }
            return "?";
        }
    }

    public static enum AuditEventOutcome {
        _0,
        _4,
        _8,
        _12,
        NULL;


        public static AuditEventOutcome fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("0".equals(codeString)) {
                return _0;
            }
            if ("4".equals(codeString)) {
                return _4;
            }
            if ("8".equals(codeString)) {
                return _8;
            }
            if ("12".equals(codeString)) {
                return _12;
            }
            throw new FHIRException("Unknown AuditEventOutcome code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case _0: {
                    return "0";
                }
                case _4: {
                    return "4";
                }
                case _8: {
                    return "8";
                }
                case _12: {
                    return "12";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case _0: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
                case _4: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
                case _8: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
                case _12: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case _0: {
                    return "The operation completed successfully (whether with warnings or not).";
                }
                case _4: {
                    return "The action was not successful due to some kind of catered for error (often equivalent to an HTTP 400 response).";
                }
                case _8: {
                    return "The action was not successful due to some kind of unexpected error (often equivalent to an HTTP 500 response).";
                }
                case _12: {
                    return "An error of such magnitude occurred that the system is no longer available for use (i.e. the system died).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case _0: {
                    return "Success";
                }
                case _4: {
                    return "Minor failure";
                }
                case _8: {
                    return "Serious failure";
                }
                case _12: {
                    return "Major failure";
                }
            }
            return "?";
        }
    }

    public static class AuditEventActionEnumFactory
    implements EnumFactory<AuditEventAction> {
        @Override
        public AuditEventAction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("C".equals(codeString)) {
                return AuditEventAction.C;
            }
            if ("R".equals(codeString)) {
                return AuditEventAction.R;
            }
            if ("U".equals(codeString)) {
                return AuditEventAction.U;
            }
            if ("D".equals(codeString)) {
                return AuditEventAction.D;
            }
            if ("E".equals(codeString)) {
                return AuditEventAction.E;
            }
            throw new IllegalArgumentException("Unknown AuditEventAction code '" + codeString + "'");
        }

        public Enumeration<AuditEventAction> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("C".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.C);
            }
            if ("R".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.R);
            }
            if ("U".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.U);
            }
            if ("D".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.D);
            }
            if ("E".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.E);
            }
            throw new FHIRException("Unknown AuditEventAction code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventAction code) {
            if (code == AuditEventAction.C) {
                return "C";
            }
            if (code == AuditEventAction.R) {
                return "R";
            }
            if (code == AuditEventAction.U) {
                return "U";
            }
            if (code == AuditEventAction.D) {
                return "D";
            }
            if (code == AuditEventAction.E) {
                return "E";
            }
            return "?";
        }
    }

    public static enum AuditEventAction {
        C,
        R,
        U,
        D,
        E,
        NULL;


        public static AuditEventAction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("C".equals(codeString)) {
                return C;
            }
            if ("R".equals(codeString)) {
                return R;
            }
            if ("U".equals(codeString)) {
                return U;
            }
            if ("D".equals(codeString)) {
                return D;
            }
            if ("E".equals(codeString)) {
                return E;
            }
            throw new FHIRException("Unknown AuditEventAction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case C: {
                    return "C";
                }
                case R: {
                    return "R";
                }
                case U: {
                    return "U";
                }
                case D: {
                    return "D";
                }
                case E: {
                    return "E";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case C: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case R: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case U: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case D: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case E: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case C: {
                    return "Create a new database object, such as placing an order.";
                }
                case R: {
                    return "Display or print data, such as a doctor census.";
                }
                case U: {
                    return "Update data, such as revise patient information.";
                }
                case D: {
                    return "Delete items, such as a doctor master file record.";
                }
                case E: {
                    return "Perform a system or application function such as log-on, program execution or use of an object's method, or perform a query/search operation.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case C: {
                    return "Create";
                }
                case R: {
                    return "Read/View/Print";
                }
                case U: {
                    return "Update";
                }
                case D: {
                    return "Delete";
                }
                case E: {
                    return "Execute";
                }
            }
            return "?";
        }
    }
}

