/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.formats;

import java.io.IOException;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2.formats.XmlParserBase;
import org.hl7.fhir.dstu2.model.Account;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.Age;
import org.hl7.fhir.dstu2.model.AllergyIntolerance;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.Appointment;
import org.hl7.fhir.dstu2.model.AppointmentResponse;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.AuditEvent;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.Basic;
import org.hl7.fhir.dstu2.model.Binary;
import org.hl7.fhir.dstu2.model.BodySite;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.CarePlan;
import org.hl7.fhir.dstu2.model.Claim;
import org.hl7.fhir.dstu2.model.ClaimResponse;
import org.hl7.fhir.dstu2.model.ClinicalImpression;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Communication;
import org.hl7.fhir.dstu2.model.CommunicationRequest;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Contract;
import org.hl7.fhir.dstu2.model.Count;
import org.hl7.fhir.dstu2.model.Coverage;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DetectedIssue;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DeviceComponent;
import org.hl7.fhir.dstu2.model.DeviceMetric;
import org.hl7.fhir.dstu2.model.DeviceUseRequest;
import org.hl7.fhir.dstu2.model.DeviceUseStatement;
import org.hl7.fhir.dstu2.model.DiagnosticOrder;
import org.hl7.fhir.dstu2.model.DiagnosticReport;
import org.hl7.fhir.dstu2.model.Distance;
import org.hl7.fhir.dstu2.model.DocumentManifest;
import org.hl7.fhir.dstu2.model.DocumentReference;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Duration;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.EligibilityRequest;
import org.hl7.fhir.dstu2.model.EligibilityResponse;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnrollmentRequest;
import org.hl7.fhir.dstu2.model.EnrollmentResponse;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.EpisodeOfCare;
import org.hl7.fhir.dstu2.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.ExtensionHelper;
import org.hl7.fhir.dstu2.model.FamilyMemberHistory;
import org.hl7.fhir.dstu2.model.Flag;
import org.hl7.fhir.dstu2.model.Goal;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.ImagingObjectSelection;
import org.hl7.fhir.dstu2.model.ImagingStudy;
import org.hl7.fhir.dstu2.model.Immunization;
import org.hl7.fhir.dstu2.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu2.model.ImplementationGuide;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.List_;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.MarkdownType;
import org.hl7.fhir.dstu2.model.Media;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.MedicationAdministration;
import org.hl7.fhir.dstu2.model.MedicationDispense;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu2.model.MedicationStatement;
import org.hl7.fhir.dstu2.model.MessageHeader;
import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.Money;
import org.hl7.fhir.dstu2.model.NamingSystem;
import org.hl7.fhir.dstu2.model.Narrative;
import org.hl7.fhir.dstu2.model.NutritionOrder;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.dstu2.model.OidType;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.OperationOutcome;
import org.hl7.fhir.dstu2.model.Order;
import org.hl7.fhir.dstu2.model.OrderResponse;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Parameters;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.PaymentNotice;
import org.hl7.fhir.dstu2.model.PaymentReconciliation;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Person;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Procedure;
import org.hl7.fhir.dstu2.model.ProcedureRequest;
import org.hl7.fhir.dstu2.model.ProcessRequest;
import org.hl7.fhir.dstu2.model.ProcessResponse;
import org.hl7.fhir.dstu2.model.Provenance;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Questionnaire;
import org.hl7.fhir.dstu2.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ReferralRequest;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.RiskAssessment;
import org.hl7.fhir.dstu2.model.SampledData;
import org.hl7.fhir.dstu2.model.Schedule;
import org.hl7.fhir.dstu2.model.SearchParameter;
import org.hl7.fhir.dstu2.model.Signature;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.Slot;
import org.hl7.fhir.dstu2.model.Specimen;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu2.model.SupplyDelivery;
import org.hl7.fhir.dstu2.model.SupplyRequest;
import org.hl7.fhir.dstu2.model.TestScript;
import org.hl7.fhir.dstu2.model.TimeType;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.UuidType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser
extends XmlParserBase {
    public XmlParser() {
    }

    public XmlParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("extension")) {
            return false;
        }
        res.getExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected boolean parseBackboneContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("modifierExtension")) {
            return this.parseElementContent(eventType, xpp, res);
        }
        res.getModifierExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        this.parseElementAttributes(xpp, res);
        res.setValue(e.fromCode(xpp.getAttributeValue(null, "value")));
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateType res = new DateType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StringType res = new StringType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OidType res = new OidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UriType res = new UriType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IdType res = new IdType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseElementAttributes(xpp, res);
        if (xpp.getAttributeValue(null, "url") != null) {
            res.setUrl(xpp.getAttributeValue(null, "url"));
        }
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("div")) {
                res.setDiv(this.parseXhtml(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assigner")) {
                res.setAssigner(this.parseReference(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("userSelected")) {
                res.setUserSelectedElement(this.parseBoolean(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhenElement(this.parseInstant(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "who")) {
                res.setWho(this.parseType("who", xpp));
            } else if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("blob")) {
                res.setBlobElement(this.parseBase64Binary(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("origin")) {
                res.setOrigin(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriodElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lowerLimit")) {
                res.setLowerLimitElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("upperLimit")) {
                res.setUpperLimitElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dimensions")) {
                res.setDimensionsElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("data")) {
                res.setDataElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Period res = new Period();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseDateTime(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("data")) {
                res.setDataElement(this.parseBase64Binary(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("size")) {
                res.setSizeElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("hash")) {
                res.setHashElement(this.parseBase64Binary(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("creation")) {
                res.setCreationElement(this.parseDateTime(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("numerator")) {
                res.setNumerator(this.parseQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("denominator")) {
                res.setDenominator(this.parseQuantity(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Range res = new Range();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("low")) {
                res.setLow(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("high")) {
                res.setHigh(this.parseSimpleQuantity(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "author")) {
                res.setAuthor(this.parseType("author", xpp));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("coding")) {
                res.getCoding().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Money res = new Money();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SimpleQuantity parseSimpleQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SimpleQuantity res = new SimpleQuantity();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Count res = new Count();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Age res = new Age();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comparator")) {
                res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnitElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("family")) {
                res.getFamily().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("given")) {
                res.getGiven().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prefix")) {
                res.getPrefix().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("suffix")) {
                res.getSuffix().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("rank")) {
                res.setRankElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("versionId")) {
                res.setVersionIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastUpdated")) {
                res.setLastUpdatedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("security")) {
                res.getSecurity().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("tag")) {
                res.getTag().add(this.parseCoding(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Address res = new Address();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("line")) {
                res.getLine().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("city")) {
                res.setCityElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("district")) {
                res.setDistrictElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("state")) {
                res.setStateElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("postalCode")) {
                res.setPostalCodeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("country")) {
                res.setCountryElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("repeat")) {
                res.setRepeat(this.parseTimingTimingRepeatComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(XmlPullParser xpp, Timing owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "bounds")) {
                res.setBounds(this.parseType("bounds", xpp));
            } else if (eventType == 2 && xpp.getName().equals("count")) {
                res.setCountElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDurationElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("durationMax")) {
                res.setDurationMaxElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("durationUnits")) {
                res.setDurationUnitsElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("frequency")) {
                res.setFrequencyElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("frequencyMax")) {
                res.setFrequencyMaxElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriodElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("periodMax")) {
                res.setPeriodMaxElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("periodUnits")) {
                res.setPeriodUnitsElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhenElement(this.parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("representation")) {
                res.getRepresentation().add(this.parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.getCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("slicing")) {
                res.setSlicing(this.parseElementDefinitionElementDefinitionSlicingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("short")) {
                res.setShortElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && xpp.getName().equals("alias")) {
                res.getAlias().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("min")) {
                res.setMinElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("max")) {
                res.setMaxElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBase(this.parseElementDefinitionElementDefinitionBaseComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseElementDefinitionTypeRefComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("nameReference")) {
                res.setNameReferenceElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "defaultValue")) {
                res.setDefaultValue(this.parseType("defaultValue", xpp));
            } else if (eventType == 2 && xpp.getName().equals("meaningWhenMissing")) {
                res.setMeaningWhenMissingElement(this.parseMarkdown(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "fixed")) {
                res.setFixed(this.parseType("fixed", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "pattern")) {
                res.setPattern(this.parseType("pattern", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "example")) {
                res.setExample(this.parseType("example", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "minValue")) {
                res.setMinValue(this.parseType("minValue", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "maxValue")) {
                res.setMaxValue(this.parseType("maxValue", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxLength")) {
                res.setMaxLengthElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.getCondition().add(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("constraint")) {
                res.getConstraint().add(this.parseElementDefinitionElementDefinitionConstraintComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
                res.setMustSupportElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("isModifier")) {
                res.setIsModifierElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("isSummary")) {
                res.setIsSummaryElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("binding")) {
                res.setBinding(this.parseElementDefinitionElementDefinitionBindingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("mapping")) {
                res.getMapping().add(this.parseElementDefinitionElementDefinitionMappingComponent(xpp, res));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("discriminator")) {
                res.getDiscriminator().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ordered")) {
                res.setOrderedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rules")) {
                res.setRulesElement(this.parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("min")) {
                res.setMinElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("max")) {
                res.setMaxElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("aggregation")) {
                res.getAggregation().add(this.parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("key")) {
                res.setKeyElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("human")) {
                res.setHumanElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("xpath")) {
                res.setXpathElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("strength")) {
                res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
                res.setValueSet(this.parseType("valueSet", xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identity")) {
                res.setIdentityElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("map")) {
                res.setMapElement(this.parseString(xpp));
            } else if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected void parseDomainResourceAttributes(XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        this.parseResourceAttributes(xpp, res);
    }

    protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contained")) {
            res.getContained().add(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extension")) {
            res.getExtension().add(this.parseExtension(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifierExtension")) {
            res.getModifierExtension().add(this.parseExtension(xpp));
        } else {
            return this.parseResourceContent(eventType, xpp, res);
        }
        return true;
    }

    protected Parameters parseParameters(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters res = new Parameters();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseParametersParametersParameterComponent(xpp, res));
            } else if (!this.parseResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(XmlPullParser xpp, Parameters owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseResourceContained(xpp));
            } else if (eventType == 2 && xpp.getName().equals("part")) {
                res.getPart().add(this.parseParametersParametersParameterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected void parseResourceAttributes(XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (!this.comments.isEmpty()) {
            res.getFormatCommentsPre().addAll(this.comments);
            this.comments.clear();
        }
    }

    protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("meta")) {
            res.setMeta(this.parseMeta(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else {
            return false;
        }
        return true;
    }

    protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account res = new Account();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("activePeriod")) {
                res.setActivePeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("currency")) {
                res.setCurrency(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("balance")) {
                res.setBalance(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coveragePeriod")) {
                res.setCoveragePeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("owner")) {
                res.setOwner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("onset")) {
                res.setOnsetElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
                res.setRecordedDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recorder")) {
                res.setRecorder(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reporter")) {
                res.setReporter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("substance")) {
                res.setSubstance(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceStatus.NULL, new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("criticality")) {
                res.setCriticalityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("lastOccurence")) {
                res.setLastOccurenceElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reaction")) {
                res.getReaction().add(this.parseAllergyIntoleranceAllergyIntoleranceReactionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(XmlPullParser xpp, AllergyIntolerance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("substance")) {
                res.setSubstance(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("certainty")) {
                res.setCertaintyElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCertainty.NULL, new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("manifestation")) {
                res.getManifestation().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("onset")) {
                res.setOnsetElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("exposureRoute")) {
                res.setExposureRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("minutesDuration")) {
                res.setMinutesDurationElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("slot")) {
                res.getSlot().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseAppointmentAppointmentParticipantComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(XmlPullParser xpp, Appointment owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseEnumeration(xpp, Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("appointment")) {
                res.setAppointment(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participantType")) {
                res.getParticipantType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participantStatus")) {
                res.setParticipantStatusElement(this.parseEnumeration(xpp, AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("event")) {
                res.setEvent(this.parseAuditEventAuditEventEventComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseAuditEventAuditEventParticipantComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseAuditEventAuditEventSourceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("object")) {
                res.getObject().add(this.parseAuditEventAuditEventObjectComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventEventComponent parseAuditEventAuditEventEventComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEventComponent res = new AuditEvent.AuditEventEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subtype")) {
                res.getSubtype().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.setActionElement(this.parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
                res.setDateTimeElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("outcomeDesc")) {
                res.setOutcomeDescElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("purposeOfEvent")) {
                res.getPurposeOfEvent().add(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventParticipantComponent parseAuditEventAuditEventParticipantComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventParticipantComponent res = new AuditEvent.AuditEventParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("userId")) {
                res.setUserId(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("altId")) {
                res.setAltIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestor")) {
                res.setRequestorElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("policy")) {
                res.getPolicy().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("media")) {
                res.setMedia(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("network")) {
                res.setNetwork(this.parseAuditEventAuditEventParticipantNetworkComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("purposeOfUse")) {
                res.getPurposeOfUse().add(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventParticipantNetworkComponent parseAuditEventAuditEventParticipantNetworkComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventParticipantNetworkComponent res = new AuditEvent.AuditEventParticipantNetworkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddressElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventParticipantNetworkType.NULL, new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("site")) {
                res.setSiteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventObjectComponent parseAuditEventAuditEventObjectComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventObjectComponent res = new AuditEvent.AuditEventObjectComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lifecycle")) {
                res.setLifecycle(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
                res.getSecurityLabel().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("query")) {
                res.setQueryElement(this.parseBase64Binary(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseAuditEventAuditEventObjectDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected AuditEvent.AuditEventObjectDetailComponent parseAuditEventAuditEventObjectDetailComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventObjectDetailComponent res = new AuditEvent.AuditEventObjectDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseBase64Binary(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDate(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.setContentElement(this.parseBase64Binary(xpp));
            } else if (!this.parseResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected BodySite parseBodySite(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BodySite res = new BodySite();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.getModifier().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("image")) {
                res.getImage().add(this.parseAttachment(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("total")) {
                res.setTotalElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseBundleBundleLinkComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("entry")) {
                res.getEntry().add(this.parseBundleBundleEntryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("signature")) {
                res.setSignature(this.parseSignature(xpp));
            } else if (!this.parseResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("relation")) {
                res.setRelationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseBundleBundleLinkComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("fullUrl")) {
                res.setFullUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseResourceContained(xpp));
            } else if (eventType == 2 && xpp.getName().equals("search")) {
                res.setSearch(this.parseBundleBundleEntrySearchComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseBundleBundleEntryRequestComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseBundleBundleEntryResponseComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("score")) {
                res.setScoreElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethodElement(this.parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifNoneMatch")) {
                res.setIfNoneMatchElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifModifiedSince")) {
                res.setIfModifiedSinceElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifMatch")) {
                res.setIfMatchElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ifNoneExist")) {
                res.setIfNoneExistElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocationElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("etag")) {
                res.setEtagElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastModified")) {
                res.setLastModifiedElement(this.parseInstant(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.setContext(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modified")) {
                res.setModifiedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.getCategory().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("addresses")) {
                res.getAddresses().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("support")) {
                res.getSupport().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatedPlan")) {
                res.getRelatedPlan().add(this.parseCarePlanCarePlanRelatedPlanComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseCarePlanCarePlanParticipantComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("goal")) {
                res.getGoal().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("activity")) {
                res.getActivity().add(this.parseCarePlanCarePlanActivityComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanRelatedPlanComponent parseCarePlanCarePlanRelatedPlanComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanRelatedPlanComponent res = new CarePlan.CarePlanRelatedPlanComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, CarePlan.CarePlanRelationship.NULL, new CarePlan.CarePlanRelationshipEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("plan")) {
                res.setPlan(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanParticipantComponent parseCarePlanCarePlanParticipantComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanParticipantComponent res = new CarePlan.CarePlanParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("member")) {
                res.setMember(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actionResulting")) {
                res.getActionResulting().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("progress")) {
                res.getProgress().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReference(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.setDetail(this.parseCarePlanCarePlanActivityDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
                res.getReasonCode().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
                res.getReasonReference().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("goal")) {
                res.getGoal().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
                res.setStatusReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prohibited")) {
                res.setProhibitedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
                res.setScheduled(this.parseType("scheduled", xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.getPerformer().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
                res.setProduct(this.parseType("product", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dailyAmount")) {
                res.setDailyAmount(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Claim.ClaimType.NULL, new Claim.ClaimTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, Claim.Use.NULL, new Claim.UseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
                res.setFundsReserve(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("enterer")) {
                res.setEnterer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("facility")) {
                res.setFacility(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prescription")) {
                res.setPrescription(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalPrescription")) {
                res.setOriginalPrescription(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payee")) {
                res.setPayee(this.parseClaimPayeeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("referral")) {
                res.setReferral(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
                res.getDiagnosis().add(this.parseClaimDiagnosisComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.getCondition().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.getCoverage().add(this.parseClaimCoverageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("exception")) {
                res.getException().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("school")) {
                res.setSchoolElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accident")) {
                res.setAccidentElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accidentType")) {
                res.setAccidentType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("interventionException")) {
                res.getInterventionException().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseClaimItemsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("additionalMaterials")) {
                res.getAdditionalMaterials().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("missingTeeth")) {
                res.getMissingTeeth().add(this.parseClaimMissingTeethComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("person")) {
                res.setPerson(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
                res.setDiagnosis(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.CoverageComponent parseClaimCoverageComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.CoverageComponent res = new Claim.CoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("focal")) {
                res.setFocalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.setCoverage(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
                res.setBusinessArrangementElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
                res.getPreAuthRef().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
                res.setClaimResponse(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.ItemsComponent parseClaimItemsComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ItemsComponent res = new Claim.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnosisLinkId")) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceDate")) {
                res.setServiceDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.setUdi(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subSite")) {
                res.getSubSite().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.getModifier().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseClaimDetailComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("prosthesis")) {
                res.setProsthesis(this.parseClaimProsthesisComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.setUdi(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
                res.getSubDetail().add(this.parseClaimSubDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.setUdi(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.ProsthesisComponent parseClaimProsthesisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ProsthesisComponent res = new Claim.ProsthesisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("initial")) {
                res.setInitialElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priorDate")) {
                res.setPriorDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priorMaterial")) {
                res.setPriorMaterial(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Claim.MissingTeethComponent parseClaimMissingTeethComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.MissingTeethComponent res = new Claim.MissingTeethComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("tooth")) {
                res.setTooth(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extractionDate")) {
                res.setExtractionDateElement(this.parseDate(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
                res.setRequestProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
                res.setRequestOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payeeType")) {
                res.setPayeeType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseClaimResponseItemsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("addItem")) {
                res.getAddItem().add(this.parseClaimResponseAddedItemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("error")) {
                res.getError().add(this.parseClaimResponseErrorsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("totalCost")) {
                res.setTotalCost(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unallocDeductable")) {
                res.setUnallocDeductable(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("totalBenefit")) {
                res.setTotalBenefit(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAdjustment")) {
                res.setPaymentAdjustment(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAdjustmentReason")) {
                res.setPaymentAdjustmentReason(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentDate")) {
                res.setPaymentDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentAmount")) {
                res.setPaymentAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentRef")) {
                res.setPaymentRef(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reserved")) {
                res.setReserved(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseClaimResponseNotesComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.getCoverage().add(this.parseClaimResponseCoverageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ItemsComponent parseClaimResponseItemsComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemsComponent res = new ClaimResponse.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
                res.getNoteNumber().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseItemAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseClaimResponseItemDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ItemAdjudicationComponent parseClaimResponseItemAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemAdjudicationComponent res = new ClaimResponse.ItemAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseDetailAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
                res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.DetailAdjudicationComponent parseClaimResponseDetailAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.DetailAdjudicationComponent res = new ClaimResponse.DetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseSubdetailAdjudicationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.SubdetailAdjudicationComponent parseClaimResponseSubdetailAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.SubdetailAdjudicationComponent res = new ClaimResponse.SubdetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.getSequenceLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fee")) {
                res.setFee(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("noteNumberLinkId")) {
                res.getNoteNumberLinkId().add(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemAdjudicationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseClaimResponseAddedItemsDetailComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemAdjudicationComponent parseClaimResponseAddedItemAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemAdjudicationComponent res = new ClaimResponse.AddedItemAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("service")) {
                res.setService(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fee")) {
                res.setFee(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemDetailAdjudicationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.AddedItemDetailAdjudicationComponent parseClaimResponseAddedItemDetailAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailAdjudicationComponent res = new ClaimResponse.AddedItemDetailAdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.ErrorsComponent parseClaimResponseErrorsComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ErrorsComponent res = new ClaimResponse.ErrorsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detailSequenceLinkId")) {
                res.setDetailSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subdetailSequenceLinkId")) {
                res.setSubdetailSequenceLinkIdElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.NotesComponent parseClaimResponseNotesComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.NotesComponent res = new ClaimResponse.NotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("number")) {
                res.setNumberElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClaimResponse.CoverageComponent parseClaimResponseCoverageComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.CoverageComponent res = new ClaimResponse.CoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("focal")) {
                res.setFocalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.setCoverage(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
                res.setBusinessArrangementElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
                res.getPreAuthRef().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
                res.setClaimResponse(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assessor")) {
                res.setAssessor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("previous")) {
                res.setPrevious(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("problem")) {
                res.getProblem().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "trigger")) {
                res.setTrigger(this.parseType("trigger", xpp));
            } else if (eventType == 2 && xpp.getName().equals("investigations")) {
                res.getInvestigations().add(this.parseClinicalImpressionClinicalImpressionInvestigationsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("protocol")) {
                res.setProtocolElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("summary")) {
                res.setSummaryElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("finding")) {
                res.getFinding().add(this.parseClinicalImpressionClinicalImpressionFindingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("resolved")) {
                res.getResolved().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruledOut")) {
                res.getRuledOut().add(this.parseClinicalImpressionClinicalImpressionRuledOutComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("prognosis")) {
                res.setPrognosisElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("plan")) {
                res.getPlan().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionInvestigationsComponent parseClinicalImpressionClinicalImpressionInvestigationsComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionInvestigationsComponent res = new ClinicalImpression.ClinicalImpressionInvestigationsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("cause")) {
                res.setCauseElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionRuledOutComponent parseClinicalImpressionClinicalImpressionRuledOutComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionRuledOutComponent res = new ClinicalImpression.ClinicalImpressionRuledOutComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReasonElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sender")) {
                res.setSender(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payload")) {
                res.getPayload().add(this.parseCommunicationCommunicationPayloadComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("medium")) {
                res.getMedium().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sent")) {
                res.setSentElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("received")) {
                res.setReceivedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestDetail")) {
                res.setRequestDetail(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(XmlPullParser xpp, Communication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sender")) {
                res.setSender(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payload")) {
                res.getPayload().add(this.parseCommunicationRequestCommunicationRequestPayloadComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("medium")) {
                res.getMedium().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requester")) {
                res.setRequester(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
                res.setScheduled(this.parseType("scheduled", xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestedOn")) {
                res.setRequestedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("class")) {
                res.setClass_(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("confidentiality")) {
                res.setConfidentialityElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("attester")) {
                res.getAttester().add(this.parseCompositionCompositionAttesterComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("custodian")) {
                res.setCustodian(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseCompositionCompositionEventComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("section")) {
                res.getSection().add(this.parseCompositionSectionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.getMode().add(this.parseEnumeration(xpp, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("party")) {
                res.setParty(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.getCode().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setText(this.parseNarrative(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
                res.setOrderedBy(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("entry")) {
                res.getEntry().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
                res.setEmptyReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("section")) {
                res.getSection().add(this.parseCompositionSectionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseConceptMapConceptMapContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
                res.setSource(this.parseType("source", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseConceptMapSourceElementComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.ConceptMapContactComponent parseConceptMapConceptMapContactComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapContactComponent res = new ConceptMap.ConceptMapContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.setCodeSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseConceptMapTargetElementComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.setCodeSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("equivalence")) {
                res.setEquivalenceElement(this.parseEnumeration(xpp, Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
                res.getDependsOn().add(this.parseConceptMapOtherElementComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("product")) {
                res.getProduct().add(this.parseConceptMapOtherElementComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("element")) {
                res.setElementElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.setCodeSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("asserter")) {
                res.setAsserter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateRecorded")) {
                res.setDateRecordedElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
                res.setClinicalStatusElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
                res.setVerificationStatusElement(this.parseEnumeration(xpp, Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverity(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
                res.setOnset(this.parseType("onset", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "abatement")) {
                res.setAbatement(this.parseType("abatement", xpp));
            } else if (eventType == 2 && xpp.getName().equals("stage")) {
                res.setStage(this.parseConditionConditionStageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("evidence")) {
                res.getEvidence().add(this.parseConditionConditionEvidenceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.getBodySite().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.setNotesElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Condition.ConditionStageComponent parseConditionConditionStageComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("summary")) {
                res.setSummary(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assessment")) {
                res.getAssessment().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance parseConformance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance res = new Conformance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseConformanceConformanceContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, Conformance.ConformanceStatementKind.NULL, new Conformance.ConformanceStatementKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("software")) {
                res.setSoftware(this.parseConformanceConformanceSoftwareComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("implementation")) {
                res.setImplementation(this.parseConformanceConformanceImplementationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
                res.setFhirVersionElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("acceptUnknown")) {
                res.setAcceptUnknownElement(this.parseEnumeration(xpp, Conformance.UnknownContentCode.NULL, new Conformance.UnknownContentCodeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("format")) {
                res.getFormat().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("rest")) {
                res.getRest().add(this.parseConformanceConformanceRestComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("messaging")) {
                res.getMessaging().add(this.parseConformanceConformanceMessagingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("document")) {
                res.getDocument().add(this.parseConformanceConformanceDocumentComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceContactComponent parseConformanceConformanceContactComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceContactComponent res = new Conformance.ConformanceContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceSoftwareComponent parseConformanceConformanceSoftwareComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceSoftwareComponent res = new Conformance.ConformanceSoftwareComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("releaseDate")) {
                res.setReleaseDateElement(this.parseDateTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceImplementationComponent parseConformanceConformanceImplementationComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceImplementationComponent res = new Conformance.ConformanceImplementationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestComponent parseConformanceConformanceRestComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestComponent res = new Conformance.ConformanceRestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Conformance.RestfulConformanceMode.NULL, new Conformance.RestfulConformanceModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("security")) {
                res.setSecurity(this.parseConformanceConformanceRestSecurityComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.getResource().add(this.parseConformanceConformanceRestResourceComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("interaction")) {
                res.getInteraction().add(this.parseConformanceSystemInteractionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("transactionMode")) {
                res.setTransactionModeElement(this.parseEnumeration(xpp, Conformance.TransactionMode.NULL, new Conformance.TransactionModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("operation")) {
                res.getOperation().add(this.parseConformanceConformanceRestOperationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("compartment")) {
                res.getCompartment().add(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestSecurityComponent parseConformanceConformanceRestSecurityComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestSecurityComponent res = new Conformance.ConformanceRestSecurityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("cors")) {
                res.setCorsElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("service")) {
                res.getService().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("certificate")) {
                res.getCertificate().add(this.parseConformanceConformanceRestSecurityCertificateComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestSecurityCertificateComponent parseConformanceConformanceRestSecurityCertificateComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestSecurityCertificateComponent res = new Conformance.ConformanceRestSecurityCertificateComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("blob")) {
                res.setBlobElement(this.parseBase64Binary(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestResourceComponent parseConformanceConformanceRestResourceComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestResourceComponent res = new Conformance.ConformanceRestResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("interaction")) {
                res.getInteraction().add(this.parseConformanceResourceInteractionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("versioning")) {
                res.setVersioningElement(this.parseEnumeration(xpp, Conformance.ResourceVersionPolicy.NULL, new Conformance.ResourceVersionPolicyEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("readHistory")) {
                res.setReadHistoryElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("updateCreate")) {
                res.setUpdateCreateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conditionalCreate")) {
                res.setConditionalCreateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conditionalUpdate")) {
                res.setConditionalUpdateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conditionalDelete")) {
                res.setConditionalDeleteElement(this.parseEnumeration(xpp, Conformance.ConditionalDeleteStatus.NULL, new Conformance.ConditionalDeleteStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("searchInclude")) {
                res.getSearchInclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("searchRevInclude")) {
                res.getSearchRevInclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ResourceInteractionComponent parseConformanceResourceInteractionComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ResourceInteractionComponent res = new Conformance.ResourceInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, Conformance.TypeRestfulInteraction.NULL, new Conformance.TypeRestfulInteractionEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestResourceSearchParamComponent parseConformanceConformanceRestResourceSearchParamComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestResourceSearchParamComponent res = new Conformance.ConformanceRestResourceSearchParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.getModifier().add(this.parseEnumeration(xpp, Conformance.SearchModifierCode.NULL, new Conformance.SearchModifierCodeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("chain")) {
                res.getChain().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.SystemInteractionComponent parseConformanceSystemInteractionComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.SystemInteractionComponent res = new Conformance.SystemInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, Conformance.SystemRestfulInteraction.NULL, new Conformance.SystemRestfulInteractionEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceRestOperationComponent parseConformanceConformanceRestOperationComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceRestOperationComponent res = new Conformance.ConformanceRestOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinition(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceMessagingComponent parseConformanceConformanceMessagingComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceMessagingComponent res = new Conformance.ConformanceMessagingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.getEndpoint().add(this.parseConformanceConformanceMessagingEndpointComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("reliableCache")) {
                res.setReliableCacheElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseConformanceConformanceMessagingEventComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceMessagingEndpointComponent parseConformanceConformanceMessagingEndpointComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEndpointComponent res = new Conformance.ConformanceMessagingEndpointComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("protocol")) {
                res.setProtocol(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddressElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceMessagingEventComponent parseConformanceConformanceMessagingEventComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEventComponent res = new Conformance.ConformanceMessagingEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, Conformance.MessageSignificanceCategory.NULL, new Conformance.MessageSignificanceCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Conformance.ConformanceEventMode.NULL, new Conformance.ConformanceEventModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("focus")) {
                res.setFocusElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Conformance.ConformanceDocumentComponent parseConformanceConformanceDocumentComponent(XmlPullParser xpp, Conformance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Conformance.ConformanceDocumentComponent res = new Conformance.ConformanceDocumentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Conformance.DocumentMode.NULL, new Conformance.DocumentModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("applies")) {
                res.setApplies(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.getSubject().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authority")) {
                res.getAuthority().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("domain")) {
                res.getDomain().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subType")) {
                res.getSubType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actionReason")) {
                res.getActionReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.getActor().add(this.parseContractActorComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
                res.getValuedItem().add(this.parseContractValuedItemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("signer")) {
                res.getSigner().add(this.parseContractSignatoryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("term")) {
                res.getTerm().add(this.parseContractTermComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "binding")) {
                res.setBinding(this.parseType("binding", xpp));
            } else if (eventType == 2 && xpp.getName().equals("friendly")) {
                res.getFriendly().add(this.parseContractFriendlyLanguageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("legal")) {
                res.getLegal().add(this.parseContractLegalLanguageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("rule")) {
                res.getRule().add(this.parseContractComputableLanguageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.ActorComponent parseContractActorComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ActorComponent res = new Contract.ActorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("entity")) {
                res.setEntity(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
                res.setEntity(this.parseType("entity", xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
                res.setEffectiveTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("party")) {
                res.setParty(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("signature")) {
                res.setSignatureElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("applies")) {
                res.setApplies(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subType")) {
                res.setSubType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actionReason")) {
                res.getActionReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.getActor().add(this.parseContractTermActorComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
                res.getValuedItem().add(this.parseContractTermValuedItemComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseContractTermComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.TermActorComponent parseContractTermActorComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermActorComponent res = new Contract.TermActorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("entity")) {
                res.setEntity(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
                res.setEntity(this.parseType("entity", xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
                res.setEffectiveTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
                res.setUnitPrice(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("factor")) {
                res.setFactorElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("points")) {
                res.setPointsElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("net")) {
                res.setNet(this.parseMoney(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
                res.setContent(this.parseType("content", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("issuer")) {
                res.setIssuer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bin")) {
                res.setBin(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subscriberId")) {
                res.setSubscriberId(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.setGroupElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("plan")) {
                res.setPlanElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subPlan")) {
                res.setSubPlanElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dependent")) {
                res.setDependentElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sequence")) {
                res.setSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subscriber")) {
                res.setSubscriber(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("network")) {
                res.setNetwork(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contract")) {
                res.getContract().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataElement parseDataElement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement res = new DataElement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseDataElementDataElementContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("stringency")) {
                res.setStringencyElement(this.parseEnumeration(xpp, DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("mapping")) {
                res.getMapping().add(this.parseDataElementDataElementMappingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseElementDefinition(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataElement.DataElementContactComponent parseDataElementDataElementContactComponent(XmlPullParser xpp, DataElement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement.DataElementContactComponent res = new DataElement.DataElementContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(XmlPullParser xpp, DataElement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identity")) {
                res.setIdentityElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uri")) {
                res.setUriElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("implicated")) {
                res.getImplicated().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.setDetailElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
                res.getMitigation().add(this.parseDetectedIssueDetectedIssueMitigationComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.setAction(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device res = new Device();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Device.DeviceStatus.NULL, new Device.DeviceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
                res.setManufacturerElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("model")) {
                res.setModelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manufactureDate")) {
                res.setManufactureDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expiry")) {
                res.setExpiryElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("udi")) {
                res.setUdiElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
                res.setLotNumberElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("owner")) {
                res.setOwner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceComponent parseDeviceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceComponent res = new DeviceComponent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lastSystemChange")) {
                res.setLastSystemChangeElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.setParent(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
                res.getOperationalStatus().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parameterGroup")) {
                res.setParameterGroup(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("measurementPrinciple")) {
                res.setMeasurementPrincipleElement(this.parseEnumeration(xpp, DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("productionSpecification")) {
                res.getProductionSpecification().add(this.parseDeviceComponentDeviceComponentProductionSpecificationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("languageCode")) {
                res.setLanguageCode(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(XmlPullParser xpp, DeviceComponent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("specType")) {
                res.setSpecType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("componentId")) {
                res.setComponentId(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("productionSpec")) {
                res.setProductionSpecElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("unit")) {
                res.setUnit(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.setParent(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
                res.setOperationalStatusElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("color")) {
                res.setColorElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategoryElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("measurementPeriod")) {
                res.setMeasurementPeriod(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("calibration")) {
                res.getCalibration().add(this.parseDeviceMetricDeviceMetricCalibrationComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(XmlPullParser xpp, DeviceMetric owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("state")) {
                res.setStateElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseInstant(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceUseRequest parseDeviceUseRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUseRequest res = new DeviceUseRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "bodySite")) {
                res.setBodySite(this.parseType("bodySite", xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DeviceUseRequest.DeviceUseRequestStatus.NULL, new DeviceUseRequest.DeviceUseRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.setDevice(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indication")) {
                res.getIndication().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prnReason")) {
                res.getPrnReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedOn")) {
                res.setOrderedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recordedOn")) {
                res.setRecordedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
                res.setTiming(this.parseType("timing", xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseEnumeration(xpp, DeviceUseRequest.DeviceUseRequestPriority.NULL, new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory()));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DeviceUseStatement parseDeviceUseStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "bodySite")) {
                res.setBodySite(this.parseType("bodySite", xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenUsed")) {
                res.setWhenUsed(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.setDevice(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indication")) {
                res.getIndication().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recordedOn")) {
                res.setRecordedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
                res.setTiming(this.parseType("timing", xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticOrder parseDiagnosticOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticOrder res = new DiagnosticOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderer")) {
                res.setOrderer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
                res.getSupportingInformation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.getSpecimen().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderPriority.NULL, new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseDiagnosticOrderDiagnosticOrderItemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderEventComponent parseDiagnosticOrderDiagnosticOrderEventComponent(XmlPullParser xpp, DiagnosticOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticOrder.DiagnosticOrderEventComponent res = new DiagnosticOrder.DiagnosticOrderEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescription(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
                res.setDateTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderItemComponent parseDiagnosticOrderDiagnosticOrderItemComponent(XmlPullParser xpp, DiagnosticOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticOrder.DiagnosticOrderItemComponent res = new DiagnosticOrder.DiagnosticOrderItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.getSpecimen().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
                res.setEffective(this.parseType("effective", xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.getRequest().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.getSpecimen().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("result")) {
                res.getResult().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
                res.getImagingStudy().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("image")) {
                res.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("conclusion")) {
                res.setConclusionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codedDiagnosis")) {
                res.getCodedDiagnosis().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("presentedForm")) {
                res.getPresentedForm().add(this.parseAttachment(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(XmlPullParser xpp, DiagnosticReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.setLink(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest res = new DocumentManifest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
                res.setMasterIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSourceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseDocumentManifestDocumentManifestContentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseDocumentManifestDocumentManifestRelatedComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "p")) {
                res.setP(this.parseType("p", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ref")) {
                res.setRef(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
                res.setMasterIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("class")) {
                res.setClass_(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.getAuthor().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("custodian")) {
                res.setCustodian(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authenticator")) {
                res.setAuthenticator(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indexed")) {
                res.setIndexedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("docStatus")) {
                res.setDocStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
                res.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
                res.getSecurityLabel().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseDocumentReferenceDocumentReferenceContentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("attachment")) {
                res.setAttachment(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("format")) {
                res.getFormat().add(this.parseCoding(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.getEvent().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("facilityType")) {
                res.setFacilityType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("practiceSetting")) {
                res.setPracticeSetting(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sourcePatientInfo")) {
                res.setSourcePatientInfo(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseDocumentReferenceDocumentReferenceContextRelatedComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ref")) {
                res.setRef(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EligibilityRequest parseEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityRequest res = new EligibilityRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EligibilityResponse parseEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse res = new EligibilityResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
                res.setRequestProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
                res.setRequestOrganization(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
                res.getStatusHistory().add(this.parseEncounterEncounterStatusHistoryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("class")) {
                res.setClass_Element(this.parseEnumeration(xpp, Encounter.EncounterClass.NULL, new Encounter.EncounterClassEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("episodeOfCare")) {
                res.getEpisodeOfCare().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("incomingReferral")) {
                res.getIncomingReferral().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("participant")) {
                res.getParticipant().add(this.parseEncounterEncounterParticipantComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("appointment")) {
                res.setAppointment(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("length")) {
                res.setLength(this.parseDuration(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("indication")) {
                res.getIndication().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
                res.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseEncounterEncounterLocationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("serviceProvider")) {
                res.setServiceProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("partOf")) {
                res.setPartOf(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterStatusHistoryComponent parseEncounterEncounterStatusHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterStatusHistoryComponent res = new Encounter.EncounterStatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("individual")) {
                res.setIndividual(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("preAdmissionIdentifier")) {
                res.setPreAdmissionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("origin")) {
                res.setOrigin(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("admitSource")) {
                res.setAdmitSource(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("admittingDiagnosis")) {
                res.getAdmittingDiagnosis().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reAdmission")) {
                res.setReAdmission(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dietPreference")) {
                res.getDietPreference().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialCourtesy")) {
                res.getSpecialCourtesy().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialArrangement")) {
                res.getSpecialArrangement().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestination(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dischargeDisposition")) {
                res.setDischargeDisposition(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dischargeDiagnosis")) {
                res.getDischargeDiagnosis().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverage")) {
                res.setCoverage(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
                res.setRequestProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
                res.setRequestOrganization(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
                res.getStatusHistory().add(this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.getCondition().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referralRequest")) {
                res.getReferralRequest().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("careManager")) {
                res.setCareManager(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
                res.getCareTeam().add(this.parseEpisodeOfCareEpisodeOfCareCareTeamComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected EpisodeOfCare.EpisodeOfCareCareTeamComponent parseEpisodeOfCareEpisodeOfCareCareTeamComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareCareTeamComponent res = new EpisodeOfCare.EpisodeOfCareCareTeamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.getRole().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("member")) {
                res.setMember(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
                res.setRequestProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
                res.setRequestOrganization(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "born")) {
                res.setBorn(this.parseType("born", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "age")) {
                res.setAge(this.parseType("age", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
                res.setDeceased(this.parseType("deceased", xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.getCondition().add(this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(XmlPullParser xpp, FamilyMemberHistory owner) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
                res.setOnset(this.parseType("onset", xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNote(this.parseAnnotation(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal res = new Goal();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "start")) {
                res.setStart(this.parseType("start", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
                res.setTarget(this.parseType("target", xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.getCategory().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
                res.setStatusDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
                res.setStatusReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("addresses")) {
                res.getAddresses().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.getOutcome().add(this.parseGoalGoalOutcomeComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Goal.GoalOutcomeComponent parseGoalGoalOutcomeComponent(XmlPullParser xpp, Goal owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal.GoalOutcomeComponent res = new Goal.GoalOutcomeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "result")) {
                res.setResult(this.parseType("result", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Group res = new Group();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("actual")) {
                res.setActualElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantityElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
                res.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("member")) {
                res.getMember().add(this.parseGroupGroupMemberComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.setExcludeElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Group.GroupMemberComponent parseGroupGroupMemberComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("entity")) {
                res.setEntity(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("inactive")) {
                res.setInactiveElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService res = new HealthcareService();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("providedBy")) {
                res.setProvidedBy(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
                res.setServiceCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
                res.getServiceType().add(this.parseHealthcareServiceServiceTypeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceName")) {
                res.setServiceNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extraDetails")) {
                res.setExtraDetailsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.setPhoto(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
                res.getCoverageArea().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceProvisionCode")) {
                res.getServiceProvisionCode().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("eligibility")) {
                res.setEligibility(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("eligibilityNote")) {
                res.setEligibilityNoteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("programName")) {
                res.getProgramName().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
                res.getCharacteristic().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referralMethod")) {
                res.getReferralMethod().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publicKey")) {
                res.setPublicKeyElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("appointmentRequired")) {
                res.setAppointmentRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableTime")) {
                res.getAvailableTime().add(this.parseHealthcareServiceHealthcareServiceAvailableTimeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("notAvailable")) {
                res.getNotAvailable().add(this.parseHealthcareServiceHealthcareServiceNotAvailableComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("availabilityExceptions")) {
                res.setAvailabilityExceptionsElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HealthcareService.ServiceTypeComponent parseHealthcareServiceServiceTypeComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.ServiceTypeComponent res = new HealthcareService.ServiceTypeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
                res.getDaysOfWeek().add(this.parseEnumeration(xpp, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("allDay")) {
                res.setAllDayElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableStartTime")) {
                res.setAvailableStartTimeElement(this.parseTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availableEndTime")) {
                res.setAvailableEndTimeElement(this.parseTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("during")) {
                res.setDuring(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection parseImagingObjectSelection(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection res = new ImagingObjectSelection();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitle(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authoringTime")) {
                res.setAuthoringTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("study")) {
                res.getStudy().add(this.parseImagingObjectSelectionStudyComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.StudyComponent parseImagingObjectSelectionStudyComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.StudyComponent res = new ImagingObjectSelection.StudyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
                res.setImagingStudy(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.getSeries().add(this.parseImagingObjectSelectionSeriesComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.SeriesComponent parseImagingObjectSelectionSeriesComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.SeriesComponent res = new ImagingObjectSelection.SeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.getInstance().add(this.parseImagingObjectSelectionInstanceComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.InstanceComponent parseImagingObjectSelectionInstanceComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.InstanceComponent res = new ImagingObjectSelection.InstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sopClass")) {
                res.setSopClassElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("frames")) {
                res.getFrames().add(this.parseImagingObjectSelectionFramesComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingObjectSelection.FramesComponent parseImagingObjectSelectionFramesComponent(XmlPullParser xpp, ImagingObjectSelection owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingObjectSelection.FramesComponent res = new ImagingObjectSelection.FramesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("frameNumbers")) {
                res.getFrameNumbers().add(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy res = new ImagingStudy();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("started")) {
                res.setStartedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accession")) {
                res.setAccession(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("order")) {
                res.getOrder().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modalityList")) {
                res.getModalityList().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referrer")) {
                res.setReferrer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availability")) {
                res.setAvailabilityElement(this.parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfSeries")) {
                res.setNumberOfSeriesElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
                res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("procedure")) {
                res.getProcedure().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("interpreter")) {
                res.setInterpreter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("number")) {
                res.setNumberElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("modality")) {
                res.setModality(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
                res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("availability")) {
                res.setAvailabilityElement(this.parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("laterality")) {
                res.setLaterality(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("started")) {
                res.setStartedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("number")) {
                res.setNumberElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uid")) {
                res.setUidElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sopClass")) {
                res.setSopClassElement(this.parseOid(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseAttachment(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization res = new Immunization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
                res.setVaccineCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("wasNotGiven")) {
                res.setWasNotGivenElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reported")) {
                res.setReportedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requester")) {
                res.setRequester(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
                res.setManufacturer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
                res.setLotNumberElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
                res.setExpirationDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("site")) {
                res.setSite(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseQuantity")) {
                res.setDoseQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("explanation")) {
                res.setExplanation(this.parseImmunizationImmunizationExplanationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("reaction")) {
                res.getReaction().add(this.parseImmunizationImmunizationReactionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("vaccinationProtocol")) {
                res.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotGiven")) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.setDetail(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reported")) {
                res.setReportedElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("doseSequence")) {
                res.setDoseSequenceElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authority")) {
                res.setAuthority(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.setSeriesElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("seriesDoses")) {
                res.setSeriesDosesElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
                res.getTargetDisease().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseStatus")) {
                res.setDoseStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseStatusReason")) {
                res.setDoseStatusReason(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recommendation")) {
                res.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
                res.setVaccineCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("doseNumber")) {
                res.setDoseNumberElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("forecastStatus")) {
                res.setForecastStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateCriterion")) {
                res.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("protocol")) {
                res.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("supportingImmunization")) {
                res.getSupportingImmunization().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingPatientInformation")) {
                res.getSupportingPatientInformation().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseDateTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("doseSequence")) {
                res.setDoseSequenceElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authority")) {
                res.setAuthority(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("series")) {
                res.setSeriesElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide res = new ImplementationGuide();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseImplementationGuideImplementationGuideContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
                res.setFhirVersionElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dependency")) {
                res.getDependency().add(this.parseImplementationGuideImplementationGuideDependencyComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("package")) {
                res.getPackage().add(this.parseImplementationGuideImplementationGuidePackageComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("global")) {
                res.getGlobal().add(this.parseImplementationGuideImplementationGuideGlobalComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("binary")) {
                res.getBinary().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("page")) {
                res.setPage(this.parseImplementationGuideImplementationGuidePageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuideContactComponent parseImplementationGuideImplementationGuideContactComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideContactComponent res = new ImplementationGuide.ImplementationGuideContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("uri")) {
                res.setUriElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.getResource().add(this.parseImplementationGuideImplementationGuidePackageResourceComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("purpose")) {
                res.setPurposeElement(this.parseEnumeration(xpp, ImplementationGuide.GuideResourcePurpose.NULL, new ImplementationGuide.GuideResourcePurposeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("acronym")) {
                res.setAcronymElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
                res.setSource(this.parseType("source", xpp));
            } else if (eventType == 2 && xpp.getName().equals("exampleFor")) {
                res.setExampleFor(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSourceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("package")) {
                res.getPackage().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("format")) {
                res.setFormatElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("page")) {
                res.getPage().add(this.parseImplementationGuideImplementationGuidePageComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected List_ parseList_(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        List_ res = new List_();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, List_.ListStatus.NULL, new List_.ListStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
                res.setOrderedBy(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, List_.ListMode.NULL, new List_.ListModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNoteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("entry")) {
                res.getEntry().add(this.parseList_ListEntryComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
                res.setEmptyReason(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected List_.ListEntryComponent parseList_ListEntryComponent(XmlPullParser xpp, List_ owner) throws XmlPullParserException, IOException, FHIRFormatError {
        List_.ListEntryComponent res = new List_.ListEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("flag")) {
                res.setFlag(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("deleted")) {
                res.setDeletedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Location res = new Location();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mode")) {
                res.setModeElement(this.parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddress(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("physicalType")) {
                res.setPhysicalType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("position")) {
                res.setPosition(this.parseLocationLocationPositionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("partOf")) {
                res.setPartOf(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Location.LocationPositionComponent parseLocationLocationPositionComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("longitude")) {
                res.setLongitudeElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("latitude")) {
                res.setLatitudeElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("altitude")) {
                res.setAltitudeElement(this.parseDecimal(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Media parseMedia(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Media res = new Media();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("subtype")) {
                res.setSubtype(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operator")) {
                res.setOperator(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("view")) {
                res.setView(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("deviceName")) {
                res.setDeviceNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("height")) {
                res.setHeightElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("width")) {
                res.setWidthElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("frames")) {
                res.setFramesElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDurationElement(this.parseUnsignedInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.setContent(this.parseAttachment(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication parseMedication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication res = new Medication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("isBrand")) {
                res.setIsBrandElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
                res.setManufacturer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("product")) {
                res.setProduct(this.parseMedicationMedicationProductComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("package")) {
                res.setPackage(this.parseMedicationMedicationPackageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationProductComponent parseMedicationMedicationProductComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationProductComponent res = new Medication.MedicationProductComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
                res.getIngredient().add(this.parseMedicationMedicationProductIngredientComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("batch")) {
                res.getBatch().add(this.parseMedicationMedicationProductBatchComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationProductIngredientComponent parseMedicationMedicationProductIngredientComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationProductIngredientComponent res = new Medication.MedicationProductIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationProductBatchComponent parseMedicationMedicationProductBatchComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationProductBatchComponent res = new Medication.MedicationProductBatchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("lotNumber")) {
                res.setLotNumberElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
                res.setExpirationDateElement(this.parseDateTime(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("container")) {
                res.setContainer(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("content")) {
                res.getContent().add(this.parseMedicationMedicationPackageContentComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("item")) {
                res.setItem(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseSimpleQuantity(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationAdministration parseMedicationAdministration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration res = new MedicationAdministration();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("practitioner")) {
                res.setPractitioner(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prescription")) {
                res.setPrescription(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("wasNotGiven")) {
                res.setWasNotGivenElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotGiven")) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonGiven")) {
                res.getReasonGiven().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effectiveTime")) {
                res.setEffectiveTime(this.parseType("effectiveTime", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.getDevice().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNoteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosage")) {
                res.setDosage(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationDispense parseMedicationDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense res = new MedicationDispense();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dispenser")) {
                res.setDispenser(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authorizingPrescription")) {
                res.getAuthorizingPrescription().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("daysSupply")) {
                res.setDaysSupply(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenPrepared")) {
                res.setWhenPreparedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenHandedOver")) {
                res.setWhenHandedOverElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestination(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receiver")) {
                res.getReceiver().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNoteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
                res.getDosageInstruction().add(this.parseMedicationDispenseMedicationDispenseDosageInstructionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("substitution")) {
                res.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationDispense.MedicationDispenseDosageInstructionComponent parseMedicationDispenseMedicationDispenseDosageInstructionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispenseDosageInstructionComponent res = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additionalInstructions")) {
                res.setAdditionalInstructions(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timing")) {
                res.setTiming(this.parseTiming(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "dose")) {
                res.setDose(this.parseType("dose", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
                res.setMaxDosePerPeriod(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("responsibleParty")) {
                res.getResponsibleParty().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder parseMedicationOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder res = new MedicationOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateWritten")) {
                res.setDateWrittenElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationOrder.MedicationOrderStatus.NULL, new MedicationOrder.MedicationOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("dateEnded")) {
                res.setDateEndedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonEnded")) {
                res.setReasonEnded(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prescriber")) {
                res.setPrescriber(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNoteElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
                res.getDosageInstruction().add(this.parseMedicationOrderMedicationOrderDosageInstructionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("dispenseRequest")) {
                res.setDispenseRequest(this.parseMedicationOrderMedicationOrderDispenseRequestComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("substitution")) {
                res.setSubstitution(this.parseMedicationOrderMedicationOrderSubstitutionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("priorPrescription")) {
                res.setPriorPrescription(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder.MedicationOrderDosageInstructionComponent parseMedicationOrderMedicationOrderDosageInstructionComponent(XmlPullParser xpp, MedicationOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderDosageInstructionComponent res = new MedicationOrder.MedicationOrderDosageInstructionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additionalInstructions")) {
                res.setAdditionalInstructions(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timing")) {
                res.setTiming(this.parseTiming(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "dose")) {
                res.setDose(this.parseType("dose", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
                res.setMaxDosePerPeriod(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder.MedicationOrderDispenseRequestComponent parseMedicationOrderMedicationOrderDispenseRequestComponent(XmlPullParser xpp, MedicationOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderDispenseRequestComponent res = new MedicationOrder.MedicationOrderDispenseRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("validityPeriod")) {
                res.setValidityPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("numberOfRepeatsAllowed")) {
                res.setNumberOfRepeatsAllowedElement(this.parsePositiveInt(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expectedSupplyDuration")) {
                res.setExpectedSupplyDuration(this.parseDuration(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationOrder.MedicationOrderSubstitutionComponent parseMedicationOrderMedicationOrderSubstitutionComponent(XmlPullParser xpp, MedicationOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderSubstitutionComponent res = new MedicationOrder.MedicationOrderSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationStatement parseMedicationStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationStatement res = new MedicationStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("informationSource")) {
                res.setInformationSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateAsserted")) {
                res.setDateAssertedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("wasNotTaken")) {
                res.setWasNotTakenElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotTaken")) {
                res.getReasonNotTaken().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reasonForUse")) {
                res.setReasonForUse(this.parseType("reasonForUse", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
                res.setEffective(this.parseType("effective", xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.setNoteElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
                res.getSupportingInformation().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
                res.setMedication(this.parseType("medication", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dosage")) {
                res.getDosage().add(this.parseMedicationStatementMedicationStatementDosageComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MedicationStatement.MedicationStatementDosageComponent parseMedicationStatementMedicationStatementDosageComponent(XmlPullParser xpp, MedicationStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationStatement.MedicationStatementDosageComponent res = new MedicationStatement.MedicationStatementDosageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timing")) {
                res.setTiming(this.parseTiming(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "site")) {
                res.setSite(this.parseType("site", xpp));
            } else if (eventType == 2 && xpp.getName().equals("route")) {
                res.setRoute(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "quantity")) {
                res.setQuantity(this.parseType("quantity", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
                res.setMaxDosePerPeriod(this.parseRatio(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader parseMessageHeader(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader res = new MessageHeader();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("timestamp")) {
                res.setTimestampElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("event")) {
                res.setEvent(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseMessageHeaderMessageSourceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("enterer")) {
                res.setEnterer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receiver")) {
                res.setReceiver(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("responsible")) {
                res.setResponsible(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("data")) {
                res.getData().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("details")) {
                res.setDetails(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("software")) {
                res.setSoftwareElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.setContact(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.setEndpointElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.setEndpointElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NamingSystem parseNamingSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem res = new NamingSystem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseNamingSystemNamingSystemContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("responsible")) {
                res.setResponsibleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("usage")) {
                res.setUsageElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uniqueId")) {
                res.getUniqueId().add(this.parseNamingSystemNamingSystemUniqueIdComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("replacedBy")) {
                res.setReplacedBy(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NamingSystem.NamingSystemContactComponent parseNamingSystemNamingSystemContactComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem.NamingSystemContactComponent res = new NamingSystem.NamingSystemContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preferred")) {
                res.setPreferredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder parseNutritionOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder res = new NutritionOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderer")) {
                res.setOrderer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
                res.setDateTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("allergyIntolerance")) {
                res.getAllergyIntolerance().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("foodPreferenceModifier")) {
                res.getFoodPreferenceModifier().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("excludeFoodModifier")) {
                res.getExcludeFoodModifier().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("oralDiet")) {
                res.setOralDiet(this.parseNutritionOrderNutritionOrderOralDietComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("supplement")) {
                res.getSupplement().add(this.parseNutritionOrderNutritionOrderSupplementComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("enteralFormula")) {
                res.setEnteralFormula(this.parseNutritionOrderNutritionOrderEnteralFormulaComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.getSchedule().add(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("nutrient")) {
                res.getNutrient().add(this.parseNutritionOrderNutritionOrderOralDietNutrientComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("texture")) {
                res.getTexture().add(this.parseNutritionOrderNutritionOrderOralDietTextureComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("fluidConsistencyType")) {
                res.getFluidConsistencyType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instruction")) {
                res.setInstructionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.setModifier(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseSimpleQuantity(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("modifier")) {
                res.setModifier(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("foodType")) {
                res.setFoodType(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("productName")) {
                res.setProductNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.getSchedule().add(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instruction")) {
                res.setInstructionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("baseFormulaType")) {
                res.setBaseFormulaType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("baseFormulaProductName")) {
                res.setBaseFormulaProductNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additiveType")) {
                res.setAdditiveType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additiveProductName")) {
                res.setAdditiveProductNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("caloricDensity")) {
                res.setCaloricDensity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("routeofAdministration")) {
                res.setRouteofAdministration(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("administration")) {
                res.getAdministration().add(this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("maxVolumeToDeliver")) {
                res.setMaxVolumeToDeliver(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("administrationInstruction")) {
                res.setAdministrationInstructionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseTiming(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
                res.setRate(this.parseType("rate", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation parseObservation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation res = new Observation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
                res.setEffective(this.parseType("effective", xpp));
            } else if (eventType == 2 && xpp.getName().equals("issued")) {
                res.setIssuedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.getPerformer().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
                res.setDataAbsentReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("interpretation")) {
                res.setInterpretation(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimen")) {
                res.setSpecimen(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("device")) {
                res.setDevice(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceRange")) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("related")) {
                res.getRelated().add(this.parseObservationObservationRelatedComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("component")) {
                res.getComponent().add(this.parseObservationObservationComponentComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("low")) {
                res.setLow(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("high")) {
                res.setHigh(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("meaning")) {
                res.setMeaning(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("age")) {
                res.setAge(this.parseRange(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
                res.setDataAbsentReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("referenceRange")) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition parseOperationDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition res = new OperationDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseOperationDefinitionOperationDefinitionContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("idempotent")) {
                res.setIdempotentElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.setNotesElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBase(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.setInstanceElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition.OperationDefinitionContactComponent parseOperationDefinitionOperationDefinitionContactComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionContactComponent res = new OperationDefinition.OperationDefinitionContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUseElement(this.parseEnumeration(xpp, OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("min")) {
                res.setMinElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("max")) {
                res.setMaxElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("documentation")) {
                res.setDocumentationElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.setProfile(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("binding")) {
                res.setBinding(this.parseOperationDefinitionOperationDefinitionParameterBindingComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("part")) {
                res.getPart().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("strength")) {
                res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
                res.setValueSet(this.parseType("valueSet", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationOutcome parseOperationOutcome(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationOutcome res = new OperationOutcome();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("issue")) {
                res.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(XmlPullParser xpp, OperationOutcome owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("severity")) {
                res.setSeverityElement(this.parseEnumeration(xpp, OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseEnumeration(xpp, OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("details")) {
                res.setDetails(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diagnostics")) {
                res.setDiagnosticsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Order parseOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Order res = new Order();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhen(this.parseOrderOrderWhenComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Order.OrderWhenComponent parseOrderOrderWhenComponent(XmlPullParser xpp, Order owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Order.OrderWhenComponent res = new Order.OrderWhenComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseTiming(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OrderResponse parseOrderResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OrderResponse res = new OrderResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("who")) {
                res.setWho(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderStatus")) {
                res.setOrderStatusElement(this.parseEnumeration(xpp, OrderResponse.OrderStatus.NULL, new OrderResponse.OrderStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fulfillment")) {
                res.getFulfillment().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Organization parseOrganization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Organization res = new Organization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("partOf")) {
                res.setPartOf(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseOrganizationOrganizationContactComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(XmlPullParser xpp, Organization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("purpose")) {
                res.setPurpose(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setName(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddress(this.parseAddress(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient parsePatient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient res = new Patient();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.getName().add(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
                res.setDeceased(this.parseType("deceased", xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("maritalStatus")) {
                res.setMaritalStatus(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "multipleBirth")) {
                res.setMultipleBirth(this.parseType("multipleBirth", xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.getPhoto().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parsePatientContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("animal")) {
                res.setAnimal(this.parsePatientAnimalComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("communication")) {
                res.getCommunication().add(this.parsePatientPatientCommunicationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("careProvider")) {
                res.getCareProvider().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parsePatientPatientLinkComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.ContactComponent parsePatientContactComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.ContactComponent res = new Patient.ContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.getRelationship().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setName(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.setAddress(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.AnimalComponent parsePatientAnimalComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.AnimalComponent res = new Patient.AnimalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("species")) {
                res.setSpecies(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("breed")) {
                res.setBreed(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("genderStatus")) {
                res.setGenderStatus(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguage(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("preferred")) {
                res.setPreferredElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("other")) {
                res.setOther(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentNotice parsePaymentNotice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentNotice res = new PaymentNotice();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("paymentStatus")) {
                res.setPaymentStatus(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentReconciliation parsePaymentReconciliation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation res = new PaymentReconciliation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
                res.setRequestProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
                res.setRequestOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("detail")) {
                res.getDetail().add(this.parsePaymentReconciliationDetailsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("total")) {
                res.setTotal(this.parseMoney(xpp));
            } else if (eventType == 2 && xpp.getName().equals("note")) {
                res.getNote().add(this.parsePaymentReconciliationNotesComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("responce")) {
                res.setResponce(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("submitter")) {
                res.setSubmitter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payee")) {
                res.setPayee(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("amount")) {
                res.setAmount(this.parseMoney(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Person parsePerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Person res = new Person();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.getName().add(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.setPhoto(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parsePersonPersonLinkComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Person.PersonLinkComponent parsePersonPersonLinkComponent(XmlPullParser xpp, Person owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Person.PersonLinkComponent res = new Person.PersonLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("assurance")) {
                res.setAssuranceElement(this.parseEnumeration(xpp, Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Practitioner parsePractitioner(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner res = new Practitioner();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("active")) {
                res.setActiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setName(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.getPhoto().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("practitionerRole")) {
                res.getPractitionerRole().add(this.parsePractitionerPractitionerPractitionerRoleComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("qualification")) {
                res.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("communication")) {
                res.getCommunication().add(this.parseCodeableConcept(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Practitioner.PractitionerPractitionerRoleComponent parsePractitionerPractitionerPractitionerRoleComponent(XmlPullParser xpp, Practitioner owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner.PractitionerPractitionerRoleComponent res = new Practitioner.PractitionerPractitionerRoleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
                res.setManagingOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.getSpecialty().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.getLocation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("healthcareService")) {
                res.getHealthcareService().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(XmlPullParser xpp, Practitioner owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("issuer")) {
                res.setIssuer(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Procedure parseProcedure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure res = new Procedure();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.setCategory(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notPerformed")) {
                res.setNotPerformedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reasonNotPerformed")) {
                res.getReasonNotPerformed().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.getBodySite().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.getPerformer().add(this.parseProcedureProcedurePerformerComponent(xpp, res));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "performed")) {
                res.setPerformed(this.parseType("performed", xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("report")) {
                res.getReport().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("complication")) {
                res.getComplication().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("followUp")) {
                res.getFollowUp().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && xpp.getName().equals("focalDevice")) {
                res.getFocalDevice().add(this.parseProcedureProcedureFocalDeviceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("used")) {
                res.getUsed().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.setAction(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("manipulated")) {
                res.setManipulated(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcedureRequest parseProcedureRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcedureRequest res = new ProcedureRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.getBodySite().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
                res.setScheduled(this.parseType("scheduled", xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseAnnotation(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
                res.setAsNeeded(this.parseType("asNeeded", xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedOn")) {
                res.setOrderedOnElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderer")) {
                res.setOrderer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriorityElement(this.parseEnumeration(xpp, ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessRequest parseProcessRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessRequest res = new ProcessRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.setActionElement(this.parseEnumeration(xpp, ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTarget(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("provider")) {
                res.setProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponse(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("nullify")) {
                res.setNullifyElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("item")) {
                res.getItem().add(this.parseProcessRequestItemsComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("include")) {
                res.getInclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.getExclude().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(XmlPullParser xpp, ProcessRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
                res.setSequenceLinkIdElement(this.parseInteger(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessResponse parseProcessResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessResponse res = new ProcessResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("request")) {
                res.setRequest(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("disposition")) {
                res.setDispositionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
                res.setRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("originalRuleset")) {
                res.setOriginalRuleset(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("created")) {
                res.setCreatedElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("organization")) {
                res.setOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
                res.setRequestProvider(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
                res.setRequestOrganization(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("form")) {
                res.setForm(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.getNotes().add(this.parseProcessResponseProcessResponseNotesComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("error")) {
                res.getError().add(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ProcessResponse.ProcessResponseNotesComponent parseProcessResponseProcessResponseNotesComponent(XmlPullParser xpp, ProcessResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessResponse.ProcessResponseNotesComponent res = new ProcessResponse.ProcessResponseNotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance parseProvenance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance res = new Provenance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recorded")) {
                res.setRecordedElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.getReason().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("activity")) {
                res.setActivity(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("location")) {
                res.setLocation(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("policy")) {
                res.getPolicy().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("agent")) {
                res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("entity")) {
                res.getEntity().add(this.parseProvenanceProvenanceEntityComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("signature")) {
                res.getSignature().add(this.parseSignature(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRole(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("userId")) {
                res.setUserId(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relatedAgent")) {
                res.getRelatedAgent().add(this.parseProvenanceProvenanceAgentRelatedAgentComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance.ProvenanceAgentRelatedAgentComponent parseProvenanceProvenanceAgentRelatedAgentComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceAgentRelatedAgentComponent res = new Provenance.ProvenanceAgentRelatedAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.setTargetElement(this.parseUri(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("role")) {
                res.setRoleElement(this.parseEnumeration(xpp, Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reference")) {
                res.setReferenceElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("agent")) {
                res.setAgent(this.parseProvenanceProvenanceAgentComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Questionnaire parseQuestionnaire(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire res = new Questionnaire();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Questionnaire.QuestionnaireStatus.NULL, new Questionnaire.QuestionnaireStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subjectType")) {
                res.getSubjectType().add(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.setGroup(this.parseQuestionnaireGroupComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Questionnaire.GroupComponent parseQuestionnaireGroupComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.GroupComponent res = new Questionnaire.GroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("linkId")) {
                res.setLinkIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("repeats")) {
                res.setRepeatsElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseQuestionnaireGroupComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("question")) {
                res.getQuestion().add(this.parseQuestionnaireQuestionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Questionnaire.QuestionComponent parseQuestionnaireQuestionComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.QuestionComponent res = new Questionnaire.QuestionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("linkId")) {
                res.setLinkIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Questionnaire.AnswerFormat.NULL, new Questionnaire.AnswerFormatEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("repeats")) {
                res.setRepeatsElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("options")) {
                res.setOptions(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("option")) {
                res.getOption().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseQuestionnaireGroupComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected QuestionnaireResponse parseQuestionnaireResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse res = new QuestionnaireResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("questionnaire")) {
                res.setQuestionnaire(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("author")) {
                res.setAuthor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("authored")) {
                res.setAuthoredElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.setGroup(this.parseQuestionnaireResponseGroupComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected QuestionnaireResponse.GroupComponent parseQuestionnaireResponseGroupComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse.GroupComponent res = new QuestionnaireResponse.GroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("linkId")) {
                res.setLinkIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("title")) {
                res.setTitleElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseQuestionnaireResponseGroupComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("question")) {
                res.getQuestion().add(this.parseQuestionnaireResponseQuestionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected QuestionnaireResponse.QuestionComponent parseQuestionnaireResponseQuestionComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionComponent res = new QuestionnaireResponse.QuestionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("linkId")) {
                res.setLinkIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("text")) {
                res.setTextElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("answer")) {
                res.getAnswer().add(this.parseQuestionnaireResponseQuestionAnswerComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected QuestionnaireResponse.QuestionAnswerComponent parseQuestionnaireResponseQuestionAnswerComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionAnswerComponent res = new QuestionnaireResponse.QuestionAnswerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (eventType == 2 && xpp.getName().equals("group")) {
                res.getGroup().add(this.parseQuestionnaireResponseGroupComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ReferralRequest parseReferralRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ReferralRequest res = new ReferralRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, ReferralRequest.ReferralStatus.NULL, new ReferralRequest.ReferralStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specialty")) {
                res.setSpecialty(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("priority")) {
                res.setPriority(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requester")) {
                res.setRequester(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("recipient")) {
                res.getRecipient().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateSent")) {
                res.setDateSentElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReason(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("serviceRequested")) {
                res.getServiceRequested().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
                res.getSupportingInformation().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fulfillmentTime")) {
                res.setFulfillmentTime(this.parsePeriod(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected RelatedPerson parseRelatedPerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RelatedPerson res = new RelatedPerson();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("relationship")) {
                res.setRelationship(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setName(this.parseHumanName(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("gender")) {
                res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
                res.setBirthDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("address")) {
                res.getAddress().add(this.parseAddress(xpp));
            } else if (eventType == 2 && xpp.getName().equals("photo")) {
                res.getPhoto().add(this.parseAttachment(xpp));
            } else if (eventType == 2 && xpp.getName().equals("period")) {
                res.setPeriod(this.parsePeriod(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected RiskAssessment parseRiskAssessment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RiskAssessment res = new RiskAssessment();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("condition")) {
                res.setCondition(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("performer")) {
                res.setPerformer(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("basis")) {
                res.getBasis().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prediction")) {
                res.getPrediction().add(this.parseRiskAssessmentRiskAssessmentPredictionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
                res.setMitigationElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(XmlPullParser xpp, RiskAssessment owner) throws XmlPullParserException, IOException, FHIRFormatError {
        RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("outcome")) {
                res.setOutcome(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "probability")) {
                res.setProbability(this.parseType("probability", xpp));
            } else if (eventType == 2 && xpp.getName().equals("relativeRisk")) {
                res.setRelativeRiskElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "when")) {
                res.setWhen(this.parseType("when", xpp));
            } else if (eventType == 2 && xpp.getName().equals("rationale")) {
                res.setRationaleElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Schedule parseSchedule(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Schedule res = new Schedule();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.getType().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("actor")) {
                res.setActor(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("planningHorizon")) {
                res.setPlanningHorizon(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SearchParameter parseSearchParameter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SearchParameter res = new SearchParameter();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseSearchParameterSearchParameterContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBaseElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("xpath")) {
                res.setXpathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("xpathUsage")) {
                res.setXpathUsageElement(this.parseEnumeration(xpp, SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("target")) {
                res.getTarget().add(this.parseCode(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SearchParameter.SearchParameterContactComponent parseSearchParameterSearchParameterContactComponent(XmlPullParser xpp, SearchParameter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SearchParameter.SearchParameterContactComponent res = new SearchParameter.SearchParameterContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Slot parseSlot(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Slot res = new Slot();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("freeBusyType")) {
                res.setFreeBusyTypeElement(this.parseEnumeration(xpp, Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("start")) {
                res.setStartElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("overbooked")) {
                res.setOverbookedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.setCommentElement(this.parseString(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen parseSpecimen(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen res = new Specimen();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Specimen.SpecimenStatus.NULL, new Specimen.SpecimenStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parent")) {
                res.getParent().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("subject")) {
                res.setSubject(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accessionIdentifier")) {
                res.setAccessionIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receivedTime")) {
                res.setReceivedTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("collection")) {
                res.setCollection(this.parseSpecimenSpecimenCollectionComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("treatment")) {
                res.getTreatment().add(this.parseSpecimenSpecimenTreatmentComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("container")) {
                res.getContainer().add(this.parseSpecimenSpecimenContainerComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("collector")) {
                res.setCollector(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comment")) {
                res.getComment().add(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "collected")) {
                res.setCollected(this.parseType("collected", xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("method")) {
                res.setMethod(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
                res.setBodySite(this.parseCodeableConcept(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen.SpecimenTreatmentComponent parseSpecimenSpecimenTreatmentComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenTreatmentComponent res = new Specimen.SpecimenTreatmentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("procedure")) {
                res.setProcedure(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("additive")) {
                res.getAdditive().add(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("capacity")) {
                res.setCapacity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("specimenQuantity")) {
                res.setSpecimenQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "additive")) {
                res.setAdditive(this.parseType("additive", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition parseStructureDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition res = new StructureDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseStructureDefinitionStructureDefinitionContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.getCode().add(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
                res.setFhirVersionElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("mapping")) {
                res.getMapping().add(this.parseStructureDefinitionStructureDefinitionMappingComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKindElement(this.parseEnumeration(xpp, StructureDefinition.StructureDefinitionKind.NULL, new StructureDefinition.StructureDefinitionKindEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("constrainedType")) {
                res.setConstrainedTypeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("abstract")) {
                res.setAbstractElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contextType")) {
                res.setContextTypeElement(this.parseEnumeration(xpp, StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("context")) {
                res.getContext().add(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBaseElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("snapshot")) {
                res.setSnapshot(this.parseStructureDefinitionStructureDefinitionSnapshotComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("differential")) {
                res.setDifferential(this.parseStructureDefinitionStructureDefinitionDifferentialComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionContactComponent parseStructureDefinitionStructureDefinitionContactComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionContactComponent res = new StructureDefinition.StructureDefinitionContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identity")) {
                res.setIdentityElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("uri")) {
                res.setUriElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("comments")) {
                res.setCommentsElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseElementDefinition(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("element")) {
                res.getElement().add(this.parseElementDefinition(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Subscription parseSubscription(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Subscription res = new Subscription();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("criteria")) {
                res.setCriteriaElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseContactPoint(xpp));
            } else if (eventType == 2 && xpp.getName().equals("reason")) {
                res.setReasonElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Subscription.SubscriptionStatus.NULL, new Subscription.SubscriptionStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("error")) {
                res.setErrorElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("channel")) {
                res.setChannel(this.parseSubscriptionSubscriptionChannelComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("end")) {
                res.setEndElement(this.parseInstant(xpp));
            } else if (eventType == 2 && xpp.getName().equals("tag")) {
                res.getTag().add(this.parseCoding(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(XmlPullParser xpp, Subscription owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setTypeElement(this.parseEnumeration(xpp, Subscription.SubscriptionChannelType.NULL, new Subscription.SubscriptionChannelTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
                res.setEndpointElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("payload")) {
                res.setPayloadElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("header")) {
                res.setHeaderElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Substance parseSubstance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance res = new Substance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("category")) {
                res.getCategory().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("instance")) {
                res.getInstance().add(this.parseSubstanceSubstanceInstanceComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
                res.getIngredient().add(this.parseSubstanceSubstanceIngredientComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("expiry")) {
                res.setExpiryElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseRatio(xpp));
            } else if (eventType == 2 && xpp.getName().equals("substance")) {
                res.setSubstance(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SupplyDelivery parseSupplyDelivery(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyDelivery res = new SupplyDelivery();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, SupplyDelivery.SupplyDeliveryStatus.NULL, new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("quantity")) {
                res.setQuantity(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("suppliedItem")) {
                res.setSuppliedItem(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supplier")) {
                res.setSupplier(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("whenPrepared")) {
                res.setWhenPrepared(this.parsePeriod(xpp));
            } else if (eventType == 2 && xpp.getName().equals("time")) {
                res.setTimeElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestination(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("receiver")) {
                res.getReceiver().add(this.parseReference(xpp));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SupplyRequest parseSupplyRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyRequest res = new SupplyRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("source")) {
                res.setSource(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, SupplyRequest.SupplyRequestStatus.NULL, new SupplyRequest.SupplyRequestStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("kind")) {
                res.setKind(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("orderedItem")) {
                res.setOrderedItem(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("supplier")) {
                res.getSupplier().add(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("when")) {
                res.setWhen(this.parseSupplyRequestSupplyRequestWhenComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected SupplyRequest.SupplyRequestWhenComponent parseSupplyRequestSupplyRequestWhenComponent(XmlPullParser xpp, SupplyRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyRequest.SupplyRequestWhenComponent res = new SupplyRequest.SupplyRequestWhenComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCode(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("schedule")) {
                res.setSchedule(this.parseTiming(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript parseTestScript(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript res = new TestScript();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseTestScriptTestScriptContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("metadata")) {
                res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("multiserver")) {
                res.setMultiserverElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("fixture")) {
                res.getFixture().add(this.parseTestScriptTestScriptFixtureComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("profile")) {
                res.getProfile().add(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("variable")) {
                res.getVariable().add(this.parseTestScriptTestScriptVariableComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("setup")) {
                res.setSetup(this.parseTestScriptTestScriptSetupComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("test")) {
                res.getTest().add(this.parseTestScriptTestScriptTestComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("teardown")) {
                res.setTeardown(this.parseTestScriptTestScriptTeardownComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptContactComponent parseTestScriptTestScriptContactComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptContactComponent res = new TestScript.TestScriptContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseTestScriptTestScriptMetadataLinkComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("capability")) {
                res.getCapability().add(this.parseTestScriptTestScriptMetadataCapabilityComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("required")) {
                res.setRequiredElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("validated")) {
                res.setValidatedElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestinationElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("link")) {
                res.getLink().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("conformance")) {
                res.setConformance(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("autocreate")) {
                res.setAutocreateElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("autodelete")) {
                res.setAutodeleteElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResource(this.parseReference(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("headerField")) {
                res.setHeaderFieldElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
                res.setSourceIdElement(this.parseId(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptSetupComponent parseTestScriptTestScriptSetupComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptSetupComponent res = new TestScript.TestScriptSetupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("metadata")) {
                res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseTestScriptTestScriptSetupActionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptSetupActionComponent parseTestScriptTestScriptSetupActionComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionComponent res = new TestScript.TestScriptSetupActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("operation")) {
                res.setOperation(this.parseTestScriptTestScriptSetupActionOperationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("assert")) {
                res.setAssert(this.parseTestScriptTestScriptSetupActionAssertComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptSetupActionOperationComponent parseTestScriptTestScriptSetupActionOperationComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionOperationComponent res = new TestScript.TestScriptSetupActionOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("type")) {
                res.setType(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResourceElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("accept")) {
                res.setAcceptElement(this.parseEnumeration(xpp, TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseEnumeration(xpp, TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("destination")) {
                res.setDestinationElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encodeRequestUrl")) {
                res.setEncodeRequestUrlElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("params")) {
                res.setParamsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requestHeader")) {
                res.getRequestHeader().add(this.parseTestScriptTestScriptSetupActionOperationRequestHeaderComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("responseId")) {
                res.setResponseIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
                res.setSourceIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("targetId")) {
                res.setTargetIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptSetupActionOperationRequestHeaderComponent parseTestScriptTestScriptSetupActionOperationRequestHeaderComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionOperationRequestHeaderComponent res = new TestScript.TestScriptSetupActionOperationRequestHeaderComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("field")) {
                res.setFieldElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptSetupActionAssertComponent parseTestScriptTestScriptSetupActionAssertComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionAssertComponent res = new TestScript.TestScriptSetupActionAssertComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("label")) {
                res.setLabelElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("direction")) {
                res.setDirectionElement(this.parseEnumeration(xpp, TestScript.AssertionDirectionType.NULL, new TestScript.AssertionDirectionTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("compareToSourceId")) {
                res.setCompareToSourceIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("compareToSourcePath")) {
                res.setCompareToSourcePathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contentType")) {
                res.setContentTypeElement(this.parseEnumeration(xpp, TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("headerField")) {
                res.setHeaderFieldElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("minimumId")) {
                res.setMinimumIdElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("navigationLinks")) {
                res.setNavigationLinksElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("operator")) {
                res.setOperatorElement(this.parseEnumeration(xpp, TestScript.AssertionOperatorType.NULL, new TestScript.AssertionOperatorTypeEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("path")) {
                res.setPathElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("resource")) {
                res.setResourceElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("response")) {
                res.setResponseElement(this.parseEnumeration(xpp, TestScript.AssertionResponseTypes.NULL, new TestScript.AssertionResponseTypesEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("responseCode")) {
                res.setResponseCodeElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
                res.setSourceIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("validateProfileId")) {
                res.setValidateProfileIdElement(this.parseId(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("warningOnly")) {
                res.setWarningOnlyElement(this.parseBoolean(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptTestComponent parseTestScriptTestScriptTestComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptTestComponent res = new TestScript.TestScriptTestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("metadata")) {
                res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseTestScriptTestScriptTestActionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptTestActionComponent parseTestScriptTestScriptTestActionComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptTestActionComponent res = new TestScript.TestScriptTestActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("operation")) {
                res.setOperation(this.parseTestScriptTestScriptSetupActionOperationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("assert")) {
                res.setAssert(this.parseTestScriptTestScriptSetupActionAssertComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptTeardownComponent parseTestScriptTestScriptTeardownComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptTeardownComponent res = new TestScript.TestScriptTeardownComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("action")) {
                res.getAction().add(this.parseTestScriptTestScriptTeardownActionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TestScript.TestScriptTeardownActionComponent parseTestScriptTestScriptTeardownActionComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptTeardownActionComponent res = new TestScript.TestScriptTeardownActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("operation")) {
                res.setOperation(this.parseTestScriptTestScriptSetupActionOperationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet parseValueSet(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet res = new ValueSet();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("url")) {
                res.setUrlElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifier(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("status")) {
                res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("experimental")) {
                res.setExperimentalElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("publisher")) {
                res.setPublisherElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contact")) {
                res.getContact().add(this.parseValueSetValueSetContactComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("date")) {
                res.setDateElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("lockedDate")) {
                res.setLockedDateElement(this.parseDate(xpp));
            } else if (eventType == 2 && xpp.getName().equals("description")) {
                res.setDescriptionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("useContext")) {
                res.getUseContext().add(this.parseCodeableConcept(xpp));
            } else if (eventType == 2 && xpp.getName().equals("immutable")) {
                res.setImmutableElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("requirements")) {
                res.setRequirementsElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("copyright")) {
                res.setCopyrightElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("extensible")) {
                res.setExtensibleElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("codeSystem")) {
                res.setCodeSystem(this.parseValueSetValueSetCodeSystemComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("compose")) {
                res.setCompose(this.parseValueSetValueSetComposeComponent(xpp, res));
            } else if (eventType == 2 && xpp.getName().equals("expansion")) {
                res.setExpansion(this.parseValueSetValueSetExpansionComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetContactComponent parseValueSetValueSetContactComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetContactComponent res = new ValueSet.ValueSetContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("telecom")) {
                res.getTelecom().add(this.parseContactPoint(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetCodeSystemComponent parseValueSetValueSetCodeSystemComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetCodeSystemComponent res = new ValueSet.ValueSetCodeSystemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("caseSensitive")) {
                res.setCaseSensitiveElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseValueSetConceptDefinitionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptDefinitionComponent parseValueSetConceptDefinitionComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptDefinitionComponent res = new ValueSet.ConceptDefinitionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("abstract")) {
                res.setAbstractElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("definition")) {
                res.setDefinitionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("designation")) {
                res.getDesignation().add(this.parseValueSetConceptDefinitionDesignationComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseValueSetConceptDefinitionComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptDefinitionDesignationComponent parseValueSetConceptDefinitionDesignationComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptDefinitionDesignationComponent res = new ValueSet.ConceptDefinitionDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("language")) {
                res.setLanguageElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("use")) {
                res.setUse(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetComposeComponent res = new ValueSet.ValueSetComposeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("import")) {
                res.getImport().add(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("include")) {
                res.getInclude().add(this.parseValueSetConceptSetComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("exclude")) {
                res.getExclude().add(this.parseValueSetConceptSetComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptSetComponent res = new ValueSet.ConceptSetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("concept")) {
                res.getConcept().add(this.parseValueSetConceptReferenceComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("filter")) {
                res.getFilter().add(this.parseValueSetConceptSetFilterComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptReferenceComponent parseValueSetConceptReferenceComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptReferenceComponent res = new ValueSet.ConceptReferenceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("designation")) {
                res.getDesignation().add(this.parseValueSetConceptDefinitionDesignationComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ConceptSetFilterComponent res = new ValueSet.ConceptSetFilterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("property")) {
                res.setPropertyElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("op")) {
                res.setOpElement(this.parseEnumeration(xpp, ValueSet.FilterOperator.NULL, new ValueSet.FilterOperatorEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("value")) {
                res.setValueElement(this.parseCode(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionComponent res = new ValueSet.ValueSetExpansionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.setIdentifierElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("timestamp")) {
                res.setTimestampElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("total")) {
                res.setTotalElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("offset")) {
                res.setOffsetElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("parameter")) {
                res.getParameter().add(this.parseValueSetValueSetExpansionParameterComponent(xpp, owner));
            } else if (eventType == 2 && xpp.getName().equals("contains")) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetExpansionParameterComponent parseValueSetValueSetExpansionParameterComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionParameterComponent res = new ValueSet.ValueSetExpansionParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("name")) {
                res.setNameElement(this.parseString(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
                res.setValue(this.parseType("value", xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(XmlPullParser xpp, ValueSet owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("system")) {
                res.setSystemElement(this.parseUri(xpp));
            } else if (eventType == 2 && xpp.getName().equals("abstract")) {
                res.setAbstractElement(this.parseBoolean(xpp));
            } else if (eventType == 2 && xpp.getName().equals("version")) {
                res.setVersionElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("code")) {
                res.setCodeElement(this.parseCode(xpp));
            } else if (eventType == 2 && xpp.getName().equals("display")) {
                res.setDisplayElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("contains")) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(xpp, owner));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected VisionPrescription parseVisionPrescription(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VisionPrescription res = new VisionPrescription();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("identifier")) {
                res.getIdentifier().add(this.parseIdentifier(xpp));
            } else if (eventType == 2 && xpp.getName().equals("dateWritten")) {
                res.setDateWrittenElement(this.parseDateTime(xpp));
            } else if (eventType == 2 && xpp.getName().equals("patient")) {
                res.setPatient(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prescriber")) {
                res.setPrescriber(this.parseReference(xpp));
            } else if (eventType == 2 && xpp.getName().equals("encounter")) {
                res.setEncounter(this.parseReference(xpp));
            } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
                res.setReason(this.parseType("reason", xpp));
            } else if (eventType == 2 && xpp.getName().equals("dispense")) {
                res.getDispense().add(this.parseVisionPrescriptionVisionPrescriptionDispenseComponent(xpp, res));
            } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected VisionPrescription.VisionPrescriptionDispenseComponent parseVisionPrescriptionVisionPrescriptionDispenseComponent(XmlPullParser xpp, VisionPrescription owner) throws XmlPullParserException, IOException, FHIRFormatError {
        VisionPrescription.VisionPrescriptionDispenseComponent res = new VisionPrescription.VisionPrescriptionDispenseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (eventType == 2 && xpp.getName().equals("product")) {
                res.setProduct(this.parseCoding(xpp));
            } else if (eventType == 2 && xpp.getName().equals("eye")) {
                res.setEyeElement(this.parseEnumeration(xpp, VisionPrescription.VisionEyes.NULL, new VisionPrescription.VisionEyesEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("sphere")) {
                res.setSphereElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("cylinder")) {
                res.setCylinderElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("axis")) {
                res.setAxisElement(this.parseInteger(xpp));
            } else if (eventType == 2 && xpp.getName().equals("prism")) {
                res.setPrismElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("base")) {
                res.setBaseElement(this.parseEnumeration(xpp, VisionPrescription.VisionBase.NULL, new VisionPrescription.VisionBaseEnumFactory()));
            } else if (eventType == 2 && xpp.getName().equals("add")) {
                res.setAddElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("power")) {
                res.setPowerElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("backCurve")) {
                res.setBackCurveElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("diameter")) {
                res.setDiameterElement(this.parseDecimal(xpp));
            } else if (eventType == 2 && xpp.getName().equals("duration")) {
                res.setDuration(this.parseSimpleQuantity(xpp));
            } else if (eventType == 2 && xpp.getName().equals("color")) {
                res.setColorElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("brand")) {
                res.setBrandElement(this.parseString(xpp));
            } else if (eventType == 2 && xpp.getName().equals("notes")) {
                res.setNotesElement(this.parseString(xpp));
            } else if (!this.parseBackboneContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    @Override
    protected Resource parseResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (xpp.getName().equals("Parameters")) {
            return this.parseParameters(xpp);
        }
        if (xpp.getName().equals("Account")) {
            return this.parseAccount(xpp);
        }
        if (xpp.getName().equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(xpp);
        }
        if (xpp.getName().equals("Appointment")) {
            return this.parseAppointment(xpp);
        }
        if (xpp.getName().equals("AppointmentResponse")) {
            return this.parseAppointmentResponse(xpp);
        }
        if (xpp.getName().equals("AuditEvent")) {
            return this.parseAuditEvent(xpp);
        }
        if (xpp.getName().equals("Basic")) {
            return this.parseBasic(xpp);
        }
        if (xpp.getName().equals("Binary")) {
            return this.parseBinary(xpp);
        }
        if (xpp.getName().equals("BodySite")) {
            return this.parseBodySite(xpp);
        }
        if (xpp.getName().equals("Bundle")) {
            return this.parseBundle(xpp);
        }
        if (xpp.getName().equals("CarePlan")) {
            return this.parseCarePlan(xpp);
        }
        if (xpp.getName().equals("Claim")) {
            return this.parseClaim(xpp);
        }
        if (xpp.getName().equals("ClaimResponse")) {
            return this.parseClaimResponse(xpp);
        }
        if (xpp.getName().equals("ClinicalImpression")) {
            return this.parseClinicalImpression(xpp);
        }
        if (xpp.getName().equals("Communication")) {
            return this.parseCommunication(xpp);
        }
        if (xpp.getName().equals("CommunicationRequest")) {
            return this.parseCommunicationRequest(xpp);
        }
        if (xpp.getName().equals("Composition")) {
            return this.parseComposition(xpp);
        }
        if (xpp.getName().equals("ConceptMap")) {
            return this.parseConceptMap(xpp);
        }
        if (xpp.getName().equals("Condition")) {
            return this.parseCondition(xpp);
        }
        if (xpp.getName().equals("Conformance")) {
            return this.parseConformance(xpp);
        }
        if (xpp.getName().equals("Contract")) {
            return this.parseContract(xpp);
        }
        if (xpp.getName().equals("Coverage")) {
            return this.parseCoverage(xpp);
        }
        if (xpp.getName().equals("DataElement")) {
            return this.parseDataElement(xpp);
        }
        if (xpp.getName().equals("DetectedIssue")) {
            return this.parseDetectedIssue(xpp);
        }
        if (xpp.getName().equals("Device")) {
            return this.parseDevice(xpp);
        }
        if (xpp.getName().equals("DeviceComponent")) {
            return this.parseDeviceComponent(xpp);
        }
        if (xpp.getName().equals("DeviceMetric")) {
            return this.parseDeviceMetric(xpp);
        }
        if (xpp.getName().equals("DeviceUseRequest")) {
            return this.parseDeviceUseRequest(xpp);
        }
        if (xpp.getName().equals("DeviceUseStatement")) {
            return this.parseDeviceUseStatement(xpp);
        }
        if (xpp.getName().equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(xpp);
        }
        if (xpp.getName().equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(xpp);
        }
        if (xpp.getName().equals("DocumentManifest")) {
            return this.parseDocumentManifest(xpp);
        }
        if (xpp.getName().equals("DocumentReference")) {
            return this.parseDocumentReference(xpp);
        }
        if (xpp.getName().equals("EligibilityRequest")) {
            return this.parseEligibilityRequest(xpp);
        }
        if (xpp.getName().equals("EligibilityResponse")) {
            return this.parseEligibilityResponse(xpp);
        }
        if (xpp.getName().equals("Encounter")) {
            return this.parseEncounter(xpp);
        }
        if (xpp.getName().equals("EnrollmentRequest")) {
            return this.parseEnrollmentRequest(xpp);
        }
        if (xpp.getName().equals("EnrollmentResponse")) {
            return this.parseEnrollmentResponse(xpp);
        }
        if (xpp.getName().equals("EpisodeOfCare")) {
            return this.parseEpisodeOfCare(xpp);
        }
        if (xpp.getName().equals("ExplanationOfBenefit")) {
            return this.parseExplanationOfBenefit(xpp);
        }
        if (xpp.getName().equals("FamilyMemberHistory")) {
            return this.parseFamilyMemberHistory(xpp);
        }
        if (xpp.getName().equals("Flag")) {
            return this.parseFlag(xpp);
        }
        if (xpp.getName().equals("Goal")) {
            return this.parseGoal(xpp);
        }
        if (xpp.getName().equals("Group")) {
            return this.parseGroup(xpp);
        }
        if (xpp.getName().equals("HealthcareService")) {
            return this.parseHealthcareService(xpp);
        }
        if (xpp.getName().equals("ImagingObjectSelection")) {
            return this.parseImagingObjectSelection(xpp);
        }
        if (xpp.getName().equals("ImagingStudy")) {
            return this.parseImagingStudy(xpp);
        }
        if (xpp.getName().equals("Immunization")) {
            return this.parseImmunization(xpp);
        }
        if (xpp.getName().equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(xpp);
        }
        if (xpp.getName().equals("ImplementationGuide")) {
            return this.parseImplementationGuide(xpp);
        }
        if (xpp.getName().equals("List")) {
            return this.parseList_(xpp);
        }
        if (xpp.getName().equals("Location")) {
            return this.parseLocation(xpp);
        }
        if (xpp.getName().equals("Media")) {
            return this.parseMedia(xpp);
        }
        if (xpp.getName().equals("Medication")) {
            return this.parseMedication(xpp);
        }
        if (xpp.getName().equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(xpp);
        }
        if (xpp.getName().equals("MedicationDispense")) {
            return this.parseMedicationDispense(xpp);
        }
        if (xpp.getName().equals("MedicationOrder")) {
            return this.parseMedicationOrder(xpp);
        }
        if (xpp.getName().equals("MedicationStatement")) {
            return this.parseMedicationStatement(xpp);
        }
        if (xpp.getName().equals("MessageHeader")) {
            return this.parseMessageHeader(xpp);
        }
        if (xpp.getName().equals("NamingSystem")) {
            return this.parseNamingSystem(xpp);
        }
        if (xpp.getName().equals("NutritionOrder")) {
            return this.parseNutritionOrder(xpp);
        }
        if (xpp.getName().equals("Observation")) {
            return this.parseObservation(xpp);
        }
        if (xpp.getName().equals("OperationDefinition")) {
            return this.parseOperationDefinition(xpp);
        }
        if (xpp.getName().equals("OperationOutcome")) {
            return this.parseOperationOutcome(xpp);
        }
        if (xpp.getName().equals("Order")) {
            return this.parseOrder(xpp);
        }
        if (xpp.getName().equals("OrderResponse")) {
            return this.parseOrderResponse(xpp);
        }
        if (xpp.getName().equals("Organization")) {
            return this.parseOrganization(xpp);
        }
        if (xpp.getName().equals("Patient")) {
            return this.parsePatient(xpp);
        }
        if (xpp.getName().equals("PaymentNotice")) {
            return this.parsePaymentNotice(xpp);
        }
        if (xpp.getName().equals("PaymentReconciliation")) {
            return this.parsePaymentReconciliation(xpp);
        }
        if (xpp.getName().equals("Person")) {
            return this.parsePerson(xpp);
        }
        if (xpp.getName().equals("Practitioner")) {
            return this.parsePractitioner(xpp);
        }
        if (xpp.getName().equals("Procedure")) {
            return this.parseProcedure(xpp);
        }
        if (xpp.getName().equals("ProcedureRequest")) {
            return this.parseProcedureRequest(xpp);
        }
        if (xpp.getName().equals("ProcessRequest")) {
            return this.parseProcessRequest(xpp);
        }
        if (xpp.getName().equals("ProcessResponse")) {
            return this.parseProcessResponse(xpp);
        }
        if (xpp.getName().equals("Provenance")) {
            return this.parseProvenance(xpp);
        }
        if (xpp.getName().equals("Questionnaire")) {
            return this.parseQuestionnaire(xpp);
        }
        if (xpp.getName().equals("QuestionnaireResponse")) {
            return this.parseQuestionnaireResponse(xpp);
        }
        if (xpp.getName().equals("ReferralRequest")) {
            return this.parseReferralRequest(xpp);
        }
        if (xpp.getName().equals("RelatedPerson")) {
            return this.parseRelatedPerson(xpp);
        }
        if (xpp.getName().equals("RiskAssessment")) {
            return this.parseRiskAssessment(xpp);
        }
        if (xpp.getName().equals("Schedule")) {
            return this.parseSchedule(xpp);
        }
        if (xpp.getName().equals("SearchParameter")) {
            return this.parseSearchParameter(xpp);
        }
        if (xpp.getName().equals("Slot")) {
            return this.parseSlot(xpp);
        }
        if (xpp.getName().equals("Specimen")) {
            return this.parseSpecimen(xpp);
        }
        if (xpp.getName().equals("StructureDefinition")) {
            return this.parseStructureDefinition(xpp);
        }
        if (xpp.getName().equals("Subscription")) {
            return this.parseSubscription(xpp);
        }
        if (xpp.getName().equals("Substance")) {
            return this.parseSubstance(xpp);
        }
        if (xpp.getName().equals("SupplyDelivery")) {
            return this.parseSupplyDelivery(xpp);
        }
        if (xpp.getName().equals("SupplyRequest")) {
            return this.parseSupplyRequest(xpp);
        }
        if (xpp.getName().equals("TestScript")) {
            return this.parseTestScript(xpp);
        }
        if (xpp.getName().equals("ValueSet")) {
            return this.parseValueSet(xpp);
        }
        if (xpp.getName().equals("VisionPrescription")) {
            return this.parseVisionPrescription(xpp);
        }
        if (xpp.getName().equals("Binary")) {
            return this.parseBinary(xpp);
        }
        throw new FHIRFormatError("Unknown resource type " + xpp.getName() + "");
    }

    protected Type parseType(String prefix, XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (xpp.getName().equals(prefix + "date")) {
            return this.parseDate(xpp);
        }
        if (xpp.getName().equals(prefix + "dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (xpp.getName().equals(prefix + "code")) {
            return this.parseCode(xpp);
        }
        if (xpp.getName().equals(prefix + "string")) {
            return this.parseString(xpp);
        }
        if (xpp.getName().equals(prefix + "integer")) {
            return this.parseInteger(xpp);
        }
        if (xpp.getName().equals(prefix + "oid")) {
            return this.parseOid(xpp);
        }
        if (xpp.getName().equals(prefix + "uri")) {
            return this.parseUri(xpp);
        }
        if (xpp.getName().equals(prefix + "uuid")) {
            return this.parseUuid(xpp);
        }
        if (xpp.getName().equals(prefix + "instant")) {
            return this.parseInstant(xpp);
        }
        if (xpp.getName().equals(prefix + "boolean")) {
            return this.parseBoolean(xpp);
        }
        if (xpp.getName().equals(prefix + "base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (xpp.getName().equals(prefix + "unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (xpp.getName().equals(prefix + "markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (xpp.getName().equals(prefix + "time")) {
            return this.parseTime(xpp);
        }
        if (xpp.getName().equals(prefix + "id")) {
            return this.parseId(xpp);
        }
        if (xpp.getName().equals(prefix + "positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (xpp.getName().equals(prefix + "decimal")) {
            return this.parseDecimal(xpp);
        }
        if (xpp.getName().equals(prefix + "Extension")) {
            return this.parseExtension(xpp);
        }
        if (xpp.getName().equals(prefix + "Narrative")) {
            return this.parseNarrative(xpp);
        }
        if (xpp.getName().equals(prefix + "Identifier")) {
            return this.parseIdentifier(xpp);
        }
        if (xpp.getName().equals(prefix + "Coding")) {
            return this.parseCoding(xpp);
        }
        if (xpp.getName().equals(prefix + "Reference")) {
            return this.parseReference(xpp);
        }
        if (xpp.getName().equals(prefix + "Signature")) {
            return this.parseSignature(xpp);
        }
        if (xpp.getName().equals(prefix + "SampledData")) {
            return this.parseSampledData(xpp);
        }
        if (xpp.getName().equals(prefix + "Quantity")) {
            return this.parseQuantity(xpp);
        }
        if (xpp.getName().equals(prefix + "Period")) {
            return this.parsePeriod(xpp);
        }
        if (xpp.getName().equals(prefix + "Attachment")) {
            return this.parseAttachment(xpp);
        }
        if (xpp.getName().equals(prefix + "Ratio")) {
            return this.parseRatio(xpp);
        }
        if (xpp.getName().equals(prefix + "Range")) {
            return this.parseRange(xpp);
        }
        if (xpp.getName().equals(prefix + "Annotation")) {
            return this.parseAnnotation(xpp);
        }
        if (xpp.getName().equals(prefix + "CodeableConcept")) {
            return this.parseCodeableConcept(xpp);
        }
        if (xpp.getName().equals(prefix + "Money")) {
            return this.parseMoney(xpp);
        }
        if (xpp.getName().equals(prefix + "SimpleQuantity")) {
            return this.parseSimpleQuantity(xpp);
        }
        if (xpp.getName().equals(prefix + "Duration")) {
            return this.parseDuration(xpp);
        }
        if (xpp.getName().equals(prefix + "Count")) {
            return this.parseCount(xpp);
        }
        if (xpp.getName().equals(prefix + "Distance")) {
            return this.parseDistance(xpp);
        }
        if (xpp.getName().equals(prefix + "Age")) {
            return this.parseAge(xpp);
        }
        if (xpp.getName().equals(prefix + "HumanName")) {
            return this.parseHumanName(xpp);
        }
        if (xpp.getName().equals(prefix + "ContactPoint")) {
            return this.parseContactPoint(xpp);
        }
        if (xpp.getName().equals(prefix + "Meta")) {
            return this.parseMeta(xpp);
        }
        if (xpp.getName().equals(prefix + "Address")) {
            return this.parseAddress(xpp);
        }
        if (xpp.getName().equals(prefix + "Timing")) {
            return this.parseTiming(xpp);
        }
        if (xpp.getName().equals(prefix + "ElementDefinition")) {
            return this.parseElementDefinition(xpp);
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return this.parseDate(xpp);
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return this.parseDateTime(xpp);
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return this.parseCode(xpp);
        }
        if (xpp.getName().equals(prefix + "String")) {
            return this.parseString(xpp);
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return this.parseInteger(xpp);
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return this.parseOid(xpp);
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return this.parseUri(xpp);
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return this.parseUuid(xpp);
        }
        if (xpp.getName().equals(prefix + "Instant")) {
            return this.parseInstant(xpp);
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return this.parseBoolean(xpp);
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return this.parseTime(xpp);
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return this.parseId(xpp);
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (xpp.getName().equals(prefix + "Decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + xpp.getName());
    }

    @Override
    protected Type parseType(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        if (type.equals("Extension")) {
            return this.parseExtension(xpp);
        }
        if (type.equals("Narrative")) {
            return this.parseNarrative(xpp);
        }
        if (type.equals("Identifier")) {
            return this.parseIdentifier(xpp);
        }
        if (type.equals("Coding")) {
            return this.parseCoding(xpp);
        }
        if (type.equals("Reference")) {
            return this.parseReference(xpp);
        }
        if (type.equals("Signature")) {
            return this.parseSignature(xpp);
        }
        if (type.equals("SampledData")) {
            return this.parseSampledData(xpp);
        }
        if (type.equals("Quantity")) {
            return this.parseQuantity(xpp);
        }
        if (type.equals("Period")) {
            return this.parsePeriod(xpp);
        }
        if (type.equals("Attachment")) {
            return this.parseAttachment(xpp);
        }
        if (type.equals("Ratio")) {
            return this.parseRatio(xpp);
        }
        if (type.equals("Range")) {
            return this.parseRange(xpp);
        }
        if (type.equals("Annotation")) {
            return this.parseAnnotation(xpp);
        }
        if (type.equals("CodeableConcept")) {
            return this.parseCodeableConcept(xpp);
        }
        if (type.equals("Money")) {
            return this.parseMoney(xpp);
        }
        if (type.equals("SimpleQuantity")) {
            return this.parseSimpleQuantity(xpp);
        }
        if (type.equals("Duration")) {
            return this.parseDuration(xpp);
        }
        if (type.equals("Count")) {
            return this.parseCount(xpp);
        }
        if (type.equals("Distance")) {
            return this.parseDistance(xpp);
        }
        if (type.equals("Age")) {
            return this.parseAge(xpp);
        }
        if (type.equals("HumanName")) {
            return this.parseHumanName(xpp);
        }
        if (type.equals("ContactPoint")) {
            return this.parseContactPoint(xpp);
        }
        if (type.equals("Meta")) {
            return this.parseMeta(xpp);
        }
        if (type.equals("Address")) {
            return this.parseAddress(xpp);
        }
        if (type.equals("Timing")) {
            return this.parseTiming(xpp);
        }
        if (type.equals("ElementDefinition")) {
            return this.parseElementDefinition(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    public Base parseFragment(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type.equals("Extension")) {
            return this.parseExtension(xpp);
        }
        if (type.equals("Narrative")) {
            return this.parseNarrative(xpp);
        }
        if (type.equals("Identifier")) {
            return this.parseIdentifier(xpp);
        }
        if (type.equals("Coding")) {
            return this.parseCoding(xpp);
        }
        if (type.equals("Reference")) {
            return this.parseReference(xpp);
        }
        if (type.equals("Signature")) {
            return this.parseSignature(xpp);
        }
        if (type.equals("SampledData")) {
            return this.parseSampledData(xpp);
        }
        if (type.equals("Quantity")) {
            return this.parseQuantity(xpp);
        }
        if (type.equals("Period")) {
            return this.parsePeriod(xpp);
        }
        if (type.equals("Attachment")) {
            return this.parseAttachment(xpp);
        }
        if (type.equals("Ratio")) {
            return this.parseRatio(xpp);
        }
        if (type.equals("Range")) {
            return this.parseRange(xpp);
        }
        if (type.equals("Annotation")) {
            return this.parseAnnotation(xpp);
        }
        if (type.equals("CodeableConcept")) {
            return this.parseCodeableConcept(xpp);
        }
        if (type.equals("Money")) {
            return this.parseMoney(xpp);
        }
        if (type.equals("SimpleQuantity")) {
            return this.parseSimpleQuantity(xpp);
        }
        if (type.equals("Duration")) {
            return this.parseDuration(xpp);
        }
        if (type.equals("Count")) {
            return this.parseCount(xpp);
        }
        if (type.equals("Distance")) {
            return this.parseDistance(xpp);
        }
        if (type.equals("Age")) {
            return this.parseAge(xpp);
        }
        if (type.equals("HumanName")) {
            return this.parseHumanName(xpp);
        }
        if (type.equals("ContactPoint")) {
            return this.parseContactPoint(xpp);
        }
        if (type.equals("Meta")) {
            return this.parseMeta(xpp);
        }
        if (type.equals("Address")) {
            return this.parseAddress(xpp);
        }
        if (type.equals("Timing")) {
            return this.parseTiming(xpp);
        }
        if (type.equals("ElementDefinition")) {
            return this.parseElementDefinition(xpp);
        }
        if (type.equals("Parameters")) {
            return this.parseParameters(xpp);
        }
        if (type.equals("Account")) {
            return this.parseAccount(xpp);
        }
        if (type.equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(xpp);
        }
        if (type.equals("Appointment")) {
            return this.parseAppointment(xpp);
        }
        if (type.equals("AppointmentResponse")) {
            return this.parseAppointmentResponse(xpp);
        }
        if (type.equals("AuditEvent")) {
            return this.parseAuditEvent(xpp);
        }
        if (type.equals("Basic")) {
            return this.parseBasic(xpp);
        }
        if (type.equals("Binary")) {
            return this.parseBinary(xpp);
        }
        if (type.equals("BodySite")) {
            return this.parseBodySite(xpp);
        }
        if (type.equals("Bundle")) {
            return this.parseBundle(xpp);
        }
        if (type.equals("CarePlan")) {
            return this.parseCarePlan(xpp);
        }
        if (type.equals("Claim")) {
            return this.parseClaim(xpp);
        }
        if (type.equals("ClaimResponse")) {
            return this.parseClaimResponse(xpp);
        }
        if (type.equals("ClinicalImpression")) {
            return this.parseClinicalImpression(xpp);
        }
        if (type.equals("Communication")) {
            return this.parseCommunication(xpp);
        }
        if (type.equals("CommunicationRequest")) {
            return this.parseCommunicationRequest(xpp);
        }
        if (type.equals("Composition")) {
            return this.parseComposition(xpp);
        }
        if (type.equals("ConceptMap")) {
            return this.parseConceptMap(xpp);
        }
        if (type.equals("Condition")) {
            return this.parseCondition(xpp);
        }
        if (type.equals("Conformance")) {
            return this.parseConformance(xpp);
        }
        if (type.equals("Contract")) {
            return this.parseContract(xpp);
        }
        if (type.equals("Coverage")) {
            return this.parseCoverage(xpp);
        }
        if (type.equals("DataElement")) {
            return this.parseDataElement(xpp);
        }
        if (type.equals("DetectedIssue")) {
            return this.parseDetectedIssue(xpp);
        }
        if (type.equals("Device")) {
            return this.parseDevice(xpp);
        }
        if (type.equals("DeviceComponent")) {
            return this.parseDeviceComponent(xpp);
        }
        if (type.equals("DeviceMetric")) {
            return this.parseDeviceMetric(xpp);
        }
        if (type.equals("DeviceUseRequest")) {
            return this.parseDeviceUseRequest(xpp);
        }
        if (type.equals("DeviceUseStatement")) {
            return this.parseDeviceUseStatement(xpp);
        }
        if (type.equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(xpp);
        }
        if (type.equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(xpp);
        }
        if (type.equals("DocumentManifest")) {
            return this.parseDocumentManifest(xpp);
        }
        if (type.equals("DocumentReference")) {
            return this.parseDocumentReference(xpp);
        }
        if (type.equals("EligibilityRequest")) {
            return this.parseEligibilityRequest(xpp);
        }
        if (type.equals("EligibilityResponse")) {
            return this.parseEligibilityResponse(xpp);
        }
        if (type.equals("Encounter")) {
            return this.parseEncounter(xpp);
        }
        if (type.equals("EnrollmentRequest")) {
            return this.parseEnrollmentRequest(xpp);
        }
        if (type.equals("EnrollmentResponse")) {
            return this.parseEnrollmentResponse(xpp);
        }
        if (type.equals("EpisodeOfCare")) {
            return this.parseEpisodeOfCare(xpp);
        }
        if (type.equals("ExplanationOfBenefit")) {
            return this.parseExplanationOfBenefit(xpp);
        }
        if (type.equals("FamilyMemberHistory")) {
            return this.parseFamilyMemberHistory(xpp);
        }
        if (type.equals("Flag")) {
            return this.parseFlag(xpp);
        }
        if (type.equals("Goal")) {
            return this.parseGoal(xpp);
        }
        if (type.equals("Group")) {
            return this.parseGroup(xpp);
        }
        if (type.equals("HealthcareService")) {
            return this.parseHealthcareService(xpp);
        }
        if (type.equals("ImagingObjectSelection")) {
            return this.parseImagingObjectSelection(xpp);
        }
        if (type.equals("ImagingStudy")) {
            return this.parseImagingStudy(xpp);
        }
        if (type.equals("Immunization")) {
            return this.parseImmunization(xpp);
        }
        if (type.equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(xpp);
        }
        if (type.equals("ImplementationGuide")) {
            return this.parseImplementationGuide(xpp);
        }
        if (type.equals("List")) {
            return this.parseList_(xpp);
        }
        if (type.equals("Location")) {
            return this.parseLocation(xpp);
        }
        if (type.equals("Media")) {
            return this.parseMedia(xpp);
        }
        if (type.equals("Medication")) {
            return this.parseMedication(xpp);
        }
        if (type.equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(xpp);
        }
        if (type.equals("MedicationDispense")) {
            return this.parseMedicationDispense(xpp);
        }
        if (type.equals("MedicationOrder")) {
            return this.parseMedicationOrder(xpp);
        }
        if (type.equals("MedicationStatement")) {
            return this.parseMedicationStatement(xpp);
        }
        if (type.equals("MessageHeader")) {
            return this.parseMessageHeader(xpp);
        }
        if (type.equals("NamingSystem")) {
            return this.parseNamingSystem(xpp);
        }
        if (type.equals("NutritionOrder")) {
            return this.parseNutritionOrder(xpp);
        }
        if (type.equals("Observation")) {
            return this.parseObservation(xpp);
        }
        if (type.equals("OperationDefinition")) {
            return this.parseOperationDefinition(xpp);
        }
        if (type.equals("OperationOutcome")) {
            return this.parseOperationOutcome(xpp);
        }
        if (type.equals("Order")) {
            return this.parseOrder(xpp);
        }
        if (type.equals("OrderResponse")) {
            return this.parseOrderResponse(xpp);
        }
        if (type.equals("Organization")) {
            return this.parseOrganization(xpp);
        }
        if (type.equals("Patient")) {
            return this.parsePatient(xpp);
        }
        if (type.equals("PaymentNotice")) {
            return this.parsePaymentNotice(xpp);
        }
        if (type.equals("PaymentReconciliation")) {
            return this.parsePaymentReconciliation(xpp);
        }
        if (type.equals("Person")) {
            return this.parsePerson(xpp);
        }
        if (type.equals("Practitioner")) {
            return this.parsePractitioner(xpp);
        }
        if (type.equals("Procedure")) {
            return this.parseProcedure(xpp);
        }
        if (type.equals("ProcedureRequest")) {
            return this.parseProcedureRequest(xpp);
        }
        if (type.equals("ProcessRequest")) {
            return this.parseProcessRequest(xpp);
        }
        if (type.equals("ProcessResponse")) {
            return this.parseProcessResponse(xpp);
        }
        if (type.equals("Provenance")) {
            return this.parseProvenance(xpp);
        }
        if (type.equals("Questionnaire")) {
            return this.parseQuestionnaire(xpp);
        }
        if (type.equals("QuestionnaireResponse")) {
            return this.parseQuestionnaireResponse(xpp);
        }
        if (type.equals("ReferralRequest")) {
            return this.parseReferralRequest(xpp);
        }
        if (type.equals("RelatedPerson")) {
            return this.parseRelatedPerson(xpp);
        }
        if (type.equals("RiskAssessment")) {
            return this.parseRiskAssessment(xpp);
        }
        if (type.equals("Schedule")) {
            return this.parseSchedule(xpp);
        }
        if (type.equals("SearchParameter")) {
            return this.parseSearchParameter(xpp);
        }
        if (type.equals("Slot")) {
            return this.parseSlot(xpp);
        }
        if (type.equals("Specimen")) {
            return this.parseSpecimen(xpp);
        }
        if (type.equals("StructureDefinition")) {
            return this.parseStructureDefinition(xpp);
        }
        if (type.equals("Subscription")) {
            return this.parseSubscription(xpp);
        }
        if (type.equals("Substance")) {
            return this.parseSubstance(xpp);
        }
        if (type.equals("SupplyDelivery")) {
            return this.parseSupplyDelivery(xpp);
        }
        if (type.equals("SupplyRequest")) {
            return this.parseSupplyRequest(xpp);
        }
        if (type.equals("TestScript")) {
            return this.parseTestScript(xpp);
        }
        if (type.equals("ValueSet")) {
            return this.parseValueSet(xpp);
        }
        if (type.equals("VisionPrescription")) {
            return this.parseVisionPrescription(xpp);
        }
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    private boolean nameIsTypeName(XmlPullParser xpp, String prefix) {
        if (xpp.getName().equals(prefix + "Identifier")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Coding")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Reference")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Signature")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SampledData")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Quantity")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Period")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Attachment")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Ratio")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Range")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Annotation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CodeableConcept")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Money")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SimpleQuantity")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Duration")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Count")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Distance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Age")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "HumanName")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ContactPoint")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Meta")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Address")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Timing")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ElementDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Parameters")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Account")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AllergyIntolerance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Appointment")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AppointmentResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AuditEvent")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Basic")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Binary")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "BodySite")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Bundle")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CarePlan")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Claim")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ClaimResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ClinicalImpression")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Communication")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CommunicationRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Composition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ConceptMap")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Condition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Conformance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Contract")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Coverage")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DataElement")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DetectedIssue")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Device")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceComponent")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceMetric")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceUseRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DeviceUseStatement")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DiagnosticOrder")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DiagnosticReport")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DocumentManifest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DocumentReference")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EligibilityRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EligibilityResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Encounter")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EnrollmentRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EnrollmentResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EpisodeOfCare")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ExplanationOfBenefit")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "FamilyMemberHistory")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Flag")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Goal")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Group")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "HealthcareService")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImagingObjectSelection")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImagingStudy")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Immunization")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImmunizationRecommendation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ImplementationGuide")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "List")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Location")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Media")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Medication")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationAdministration")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationDispense")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationOrder")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MedicationStatement")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "MessageHeader")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "NamingSystem")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "NutritionOrder")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Observation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OperationDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OperationOutcome")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Order")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OrderResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Organization")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Patient")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PaymentNotice")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PaymentReconciliation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Person")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Practitioner")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Procedure")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ProcedureRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ProcessRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ProcessResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Provenance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Questionnaire")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "QuestionnaireResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ReferralRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "RelatedPerson")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "RiskAssessment")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Schedule")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SearchParameter")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Slot")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Specimen")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "StructureDefinition")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Subscription")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Substance")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SupplyDelivery")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SupplyRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TestScript")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ValueSet")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VisionPrescription")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "String")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Instant")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return true;
        }
        return xpp.getName().equals(prefix + "Decimal");
    }

    protected void composeElementElements(Element element) throws IOException {
        for (Extension e : element.getExtension()) {
            this.composeExtension("extension", e);
        }
    }

    protected void composeBackboneElements(BackboneElement element) throws IOException {
        this.composeElementElements(element);
        for (Extension e : element.getModifierExtension()) {
            this.composeExtension("modifierExtension", e);
        }
    }

    protected <E extends Enum<E>> void composeEnumeration(String name, Enumeration<E> value, EnumFactory e) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.getValue() != null) {
                this.xml.attribute("value", e.toCode((Enum)value.getValue()));
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDate(String name, DateType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDateTime(String name, DateTimeType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCode(String name, CodeType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    @Override
    protected void composeString(String name, StringType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeInteger(String name, IntegerType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeOid(String name, OidType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeUri(String name, UriType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeUuid(String name, UuidType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeInstant(String name, InstantType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBoolean(String name, BooleanType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBase64Binary(String name, Base64BinaryType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeUnsignedInt(String name, UnsignedIntType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMarkdown(String name, MarkdownType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTime(String name, TimeType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString((String)value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeId(String name, IdType value) throws IOException {
        if (!(value == null || Utilities.noString(value.getId()) && !ExtensionHelper.hasExtensions(value) && Utilities.noString(value.getValue()))) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePositiveInt(String name, PositiveIntType value) throws IOException {
        if (value != null) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDecimal(String name, DecimalType value) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || value.getValue() != null)) {
            this.composeElementAttributes(value);
            if (value.asStringValue() != null) {
                this.xml.attribute("value", value.asStringValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(value);
            this.composeElementClose(value);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeExtension(String name, Extension element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            if (element.hasUrlElement()) {
                this.xml.attribute("url", (String)element.getUrlElement().getValue());
            }
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValue()) {
                this.composeType("value", element.getValue());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeNarrative(String name, Narrative element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory());
            }
            if (element.hasDiv()) {
                this.composeXhtml("div", element.getDiv());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeIdentifier(String name, Identifier element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new Identifier.IdentifierUseEnumFactory());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasValueElement()) {
                this.composeString("value", element.getValueElement());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasAssigner()) {
                this.composeReference("assigner", element.getAssigner());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCoding(String name, Coding element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            if (element.hasDisplayElement()) {
                this.composeString("display", element.getDisplayElement());
            }
            if (element.hasUserSelectedElement()) {
                this.composeBoolean("userSelected", element.getUserSelectedElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeReference(String name, Reference element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasReferenceElement()) {
                this.composeString("reference", element.getReferenceElement());
            }
            if (element.hasDisplayElement()) {
                this.composeString("display", element.getDisplayElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeSignature(String name, Signature element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasType()) {
                for (Coding e : element.getType()) {
                    this.composeCoding("type", e);
                }
            }
            if (element.hasWhenElement()) {
                this.composeInstant("when", element.getWhenElement());
            }
            if (element.hasWho()) {
                this.composeType("who", element.getWho());
            }
            if (element.hasContentTypeElement()) {
                this.composeCode("contentType", element.getContentTypeElement());
            }
            if (element.hasBlobElement()) {
                this.composeBase64Binary("blob", element.getBlobElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeSampledData(String name, SampledData element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasOrigin()) {
                this.composeSimpleQuantity("origin", element.getOrigin());
            }
            if (element.hasPeriodElement()) {
                this.composeDecimal("period", element.getPeriodElement());
            }
            if (element.hasFactorElement()) {
                this.composeDecimal("factor", element.getFactorElement());
            }
            if (element.hasLowerLimitElement()) {
                this.composeDecimal("lowerLimit", element.getLowerLimitElement());
            }
            if (element.hasUpperLimitElement()) {
                this.composeDecimal("upperLimit", element.getUpperLimitElement());
            }
            if (element.hasDimensionsElement()) {
                this.composePositiveInt("dimensions", element.getDimensionsElement());
            }
            if (element.hasDataElement()) {
                this.composeString("data", element.getDataElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeQuantity(String name, Quantity element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePeriod(String name, Period element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasStartElement()) {
                this.composeDateTime("start", element.getStartElement());
            }
            if (element.hasEndElement()) {
                this.composeDateTime("end", element.getEndElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAttachment(String name, Attachment element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasContentTypeElement()) {
                this.composeCode("contentType", element.getContentTypeElement());
            }
            if (element.hasLanguageElement()) {
                this.composeCode("language", element.getLanguageElement());
            }
            if (element.hasDataElement()) {
                this.composeBase64Binary("data", element.getDataElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasSizeElement()) {
                this.composeUnsignedInt("size", element.getSizeElement());
            }
            if (element.hasHashElement()) {
                this.composeBase64Binary("hash", element.getHashElement());
            }
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasCreationElement()) {
                this.composeDateTime("creation", element.getCreationElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeRatio(String name, Ratio element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasNumerator()) {
                this.composeQuantity("numerator", element.getNumerator());
            }
            if (element.hasDenominator()) {
                this.composeQuantity("denominator", element.getDenominator());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeRange(String name, Range element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasLow()) {
                this.composeSimpleQuantity("low", element.getLow());
            }
            if (element.hasHigh()) {
                this.composeSimpleQuantity("high", element.getHigh());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAnnotation(String name, Annotation element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasAuthor()) {
                this.composeType("author", element.getAuthor());
            }
            if (element.hasTimeElement()) {
                this.composeDateTime("time", element.getTimeElement());
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCodeableConcept(String name, CodeableConcept element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasCoding()) {
                for (Coding e : element.getCoding()) {
                    this.composeCoding("coding", e);
                }
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMoney(String name, Money element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeSimpleQuantity(String name, SimpleQuantity element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDuration(String name, Duration element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCount(String name, Count element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDistance(String name, Distance element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAge(String name, Age element) throws IOException {
        if (element != null) {
            this.composeTypeAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            if (element.hasComparatorElement()) {
                this.composeEnumeration("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory());
            }
            if (element.hasUnitElement()) {
                this.composeString("unit", element.getUnitElement());
            }
            if (element.hasSystemElement()) {
                this.composeUri("system", element.getSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHumanName(String name, HumanName element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new HumanName.NameUseEnumFactory());
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasFamily()) {
                for (StringType e : element.getFamily()) {
                    this.composeString("family", e);
                }
            }
            if (element.hasGiven()) {
                for (StringType e : element.getGiven()) {
                    this.composeString("given", e);
                }
            }
            if (element.hasPrefix()) {
                for (StringType e : element.getPrefix()) {
                    this.composeString("prefix", e);
                }
            }
            if (element.hasSuffix()) {
                for (StringType e : element.getSuffix()) {
                    this.composeString("suffix", e);
                }
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContactPoint(String name, ContactPoint element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasSystemElement()) {
                this.composeEnumeration("system", element.getSystemElement(), new ContactPoint.ContactPointSystemEnumFactory());
            }
            if (element.hasValueElement()) {
                this.composeString("value", element.getValueElement());
            }
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new ContactPoint.ContactPointUseEnumFactory());
            }
            if (element.hasRankElement()) {
                this.composePositiveInt("rank", element.getRankElement());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMeta(String name, Meta element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasVersionIdElement()) {
                this.composeId("versionId", element.getVersionIdElement());
            }
            if (element.hasLastUpdatedElement()) {
                this.composeInstant("lastUpdated", element.getLastUpdatedElement());
            }
            if (element.hasProfile()) {
                for (UriType uriType : element.getProfile()) {
                    this.composeUri("profile", uriType);
                }
            }
            if (element.hasSecurity()) {
                for (Coding coding : element.getSecurity()) {
                    this.composeCoding("security", coding);
                }
            }
            if (element.hasTag()) {
                for (Coding coding : element.getTag()) {
                    this.composeCoding("tag", coding);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAddress(String name, Address element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new Address.AddressUseEnumFactory());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Address.AddressTypeEnumFactory());
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasLine()) {
                for (StringType e : element.getLine()) {
                    this.composeString("line", e);
                }
            }
            if (element.hasCityElement()) {
                this.composeString("city", element.getCityElement());
            }
            if (element.hasDistrictElement()) {
                this.composeString("district", element.getDistrictElement());
            }
            if (element.hasStateElement()) {
                this.composeString("state", element.getStateElement());
            }
            if (element.hasPostalCodeElement()) {
                this.composeString("postalCode", element.getPostalCodeElement());
            }
            if (element.hasCountryElement()) {
                this.composeString("country", element.getCountryElement());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTiming(String name, Timing element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasEvent()) {
                for (DateTimeType e : element.getEvent()) {
                    this.composeDateTime("event", e);
                }
            }
            if (element.hasRepeat()) {
                this.composeTimingTimingRepeatComponent("repeat", element.getRepeat());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTimingTimingRepeatComponent(String name, Timing.TimingRepeatComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasBounds()) {
                this.composeType("bounds", element.getBounds());
            }
            if (element.hasCountElement()) {
                this.composeInteger("count", element.getCountElement());
            }
            if (element.hasDurationElement()) {
                this.composeDecimal("duration", element.getDurationElement());
            }
            if (element.hasDurationMaxElement()) {
                this.composeDecimal("durationMax", element.getDurationMaxElement());
            }
            if (element.hasDurationUnitsElement()) {
                this.composeEnumeration("durationUnits", element.getDurationUnitsElement(), new Timing.UnitsOfTimeEnumFactory());
            }
            if (element.hasFrequencyElement()) {
                this.composeInteger("frequency", element.getFrequencyElement());
            }
            if (element.hasFrequencyMaxElement()) {
                this.composeInteger("frequencyMax", element.getFrequencyMaxElement());
            }
            if (element.hasPeriodElement()) {
                this.composeDecimal("period", element.getPeriodElement());
            }
            if (element.hasPeriodMaxElement()) {
                this.composeDecimal("periodMax", element.getPeriodMaxElement());
            }
            if (element.hasPeriodUnitsElement()) {
                this.composeEnumeration("periodUnits", element.getPeriodUnitsElement(), new Timing.UnitsOfTimeEnumFactory());
            }
            if (element.hasWhenElement()) {
                this.composeEnumeration("when", element.getWhenElement(), new Timing.EventTimingEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinition(String name, ElementDefinition element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasPathElement()) {
                this.composeString("path", element.getPathElement());
            }
            if (element.hasRepresentation()) {
                for (Enumeration<ElementDefinition.PropertyRepresentation> enumeration : element.getRepresentation()) {
                    this.composeEnumeration("representation", enumeration, new ElementDefinition.PropertyRepresentationEnumFactory());
                }
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasLabelElement()) {
                this.composeString("label", element.getLabelElement());
            }
            if (element.hasCode()) {
                for (Coding coding : element.getCode()) {
                    this.composeCoding("code", coding);
                }
            }
            if (element.hasSlicing()) {
                this.composeElementDefinitionElementDefinitionSlicingComponent("slicing", element.getSlicing());
            }
            if (element.hasShortElement()) {
                this.composeString("short", element.getShortElement());
            }
            if (element.hasDefinitionElement()) {
                this.composeMarkdown("definition", element.getDefinitionElement());
            }
            if (element.hasCommentsElement()) {
                this.composeMarkdown("comments", element.getCommentsElement());
            }
            if (element.hasRequirementsElement()) {
                this.composeMarkdown("requirements", element.getRequirementsElement());
            }
            if (element.hasAlias()) {
                for (StringType stringType : element.getAlias()) {
                    this.composeString("alias", stringType);
                }
            }
            if (element.hasMinElement()) {
                this.composeInteger("min", element.getMinElement());
            }
            if (element.hasMaxElement()) {
                this.composeString("max", element.getMaxElement());
            }
            if (element.hasBase()) {
                this.composeElementDefinitionElementDefinitionBaseComponent("base", element.getBase());
            }
            if (element.hasType()) {
                for (ElementDefinition.TypeRefComponent typeRefComponent : element.getType()) {
                    this.composeElementDefinitionTypeRefComponent("type", typeRefComponent);
                }
            }
            if (element.hasNameReferenceElement()) {
                this.composeString("nameReference", element.getNameReferenceElement());
            }
            if (element.hasDefaultValue()) {
                this.composeType("defaultValue", element.getDefaultValue());
            }
            if (element.hasMeaningWhenMissingElement()) {
                this.composeMarkdown("meaningWhenMissing", element.getMeaningWhenMissingElement());
            }
            if (element.hasFixed()) {
                this.composeType("fixed", element.getFixed());
            }
            if (element.hasPattern()) {
                this.composeType("pattern", element.getPattern());
            }
            if (element.hasExample()) {
                this.composeType("example", element.getExample());
            }
            if (element.hasMinValue()) {
                this.composeType("minValue", element.getMinValue());
            }
            if (element.hasMaxValue()) {
                this.composeType("maxValue", element.getMaxValue());
            }
            if (element.hasMaxLengthElement()) {
                this.composeInteger("maxLength", element.getMaxLengthElement());
            }
            if (element.hasCondition()) {
                for (IdType idType : element.getCondition()) {
                    this.composeId("condition", idType);
                }
            }
            if (element.hasConstraint()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : element.getConstraint()) {
                    this.composeElementDefinitionElementDefinitionConstraintComponent("constraint", elementDefinitionConstraintComponent);
                }
            }
            if (element.hasMustSupportElement()) {
                this.composeBoolean("mustSupport", element.getMustSupportElement());
            }
            if (element.hasIsModifierElement()) {
                this.composeBoolean("isModifier", element.getIsModifierElement());
            }
            if (element.hasIsSummaryElement()) {
                this.composeBoolean("isSummary", element.getIsSummaryElement());
            }
            if (element.hasBinding()) {
                this.composeElementDefinitionElementDefinitionBindingComponent("binding", element.getBinding());
            }
            if (element.hasMapping()) {
                for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : element.getMapping()) {
                    this.composeElementDefinitionElementDefinitionMappingComponent("mapping", elementDefinitionMappingComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingComponent(String name, ElementDefinition.ElementDefinitionSlicingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasDiscriminator()) {
                for (StringType e : element.getDiscriminator()) {
                    this.composeString("discriminator", e);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasOrderedElement()) {
                this.composeBoolean("ordered", element.getOrderedElement());
            }
            if (element.hasRulesElement()) {
                this.composeEnumeration("rules", element.getRulesElement(), new ElementDefinition.SlicingRulesEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionBaseComponent(String name, ElementDefinition.ElementDefinitionBaseComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasPathElement()) {
                this.composeString("path", element.getPathElement());
            }
            if (element.hasMinElement()) {
                this.composeInteger("min", element.getMinElement());
            }
            if (element.hasMaxElement()) {
                this.composeString("max", element.getMaxElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(String name, ElementDefinition.TypeRefComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            if (element.hasProfile()) {
                for (UriType uriType : element.getProfile()) {
                    this.composeUri("profile", uriType);
                }
            }
            if (element.hasAggregation()) {
                for (Enumeration enumeration : element.getAggregation()) {
                    this.composeEnumeration("aggregation", enumeration, new ElementDefinition.AggregationModeEnumFactory());
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionConstraintComponent(String name, ElementDefinition.ElementDefinitionConstraintComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasKeyElement()) {
                this.composeId("key", element.getKeyElement());
            }
            if (element.hasRequirementsElement()) {
                this.composeString("requirements", element.getRequirementsElement());
            }
            if (element.hasSeverityElement()) {
                this.composeEnumeration("severity", element.getSeverityElement(), new ElementDefinition.ConstraintSeverityEnumFactory());
            }
            if (element.hasHumanElement()) {
                this.composeString("human", element.getHumanElement());
            }
            if (element.hasXpathElement()) {
                this.composeString("xpath", element.getXpathElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionBindingComponent(String name, ElementDefinition.ElementDefinitionBindingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasStrengthElement()) {
                this.composeEnumeration("strength", element.getStrengthElement(), new Enumerations.BindingStrengthEnumFactory());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasValueSet()) {
                this.composeType("valueSet", element.getValueSet());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeElementDefinitionElementDefinitionMappingComponent(String name, ElementDefinition.ElementDefinitionMappingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeElementElements(element);
            if (element.hasIdentityElement()) {
                this.composeId("identity", element.getIdentityElement());
            }
            if (element.hasLanguageElement()) {
                this.composeCode("language", element.getLanguageElement());
            }
            if (element.hasMapElement()) {
                this.composeString("map", element.getMapElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDomainResourceAttributes(DomainResource element) throws IOException {
        this.composeResourceAttributes(element);
    }

    protected void composeDomainResourceElements(DomainResource element) throws IOException {
        this.composeResourceElements(element);
        if (element.hasText()) {
            this.composeNarrative("text", element.getText());
        }
        if (element.hasContained()) {
            for (Resource resource : element.getContained()) {
                this.xml.enter("http://hl7.org/fhir", "contained");
                this.composeResource(resource);
                this.xml.exit("http://hl7.org/fhir", "contained");
            }
        }
        if (element.hasExtension()) {
            for (Extension extension : element.getExtension()) {
                this.composeExtension("extension", extension);
            }
        }
        if (element.hasModifierExtension()) {
            for (Extension extension : element.getModifierExtension()) {
                this.composeExtension("modifierExtension", extension);
            }
        }
    }

    protected void composeParameters(String name, Parameters element) throws IOException {
        if (element != null) {
            this.composeResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeResourceElements(element);
            if (element.hasParameter()) {
                for (Parameters.ParametersParameterComponent e : element.getParameter()) {
                    this.composeParametersParametersParameterComponent("parameter", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeParametersParametersParameterComponent(String name, Parameters.ParametersParameterComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasValue()) {
                this.composeType("value", element.getValue());
            }
            if (element.hasResource()) {
                this.xml.enter("http://hl7.org/fhir", "resource");
                this.composeResource(element.getResource());
                this.xml.exit("http://hl7.org/fhir", "resource");
            }
            if (element.hasPart()) {
                for (Parameters.ParametersParameterComponent e : element.getPart()) {
                    this.composeParametersParametersParameterComponent("part", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeResourceAttributes(Resource element) throws IOException {
        if (this.style != IParser.OutputStyle.CANONICAL) {
            for (String comment : element.getFormatCommentsPre()) {
                this.xml.comment(comment, this.getOutputStyle() == IParser.OutputStyle.PRETTY);
            }
        }
    }

    protected void composeResourceElements(Resource element) throws IOException {
        if (element.hasIdElement()) {
            this.composeId("id", element.getIdElement());
        }
        if (element.hasMeta()) {
            this.composeMeta("meta", element.getMeta());
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUri("implicitRules", element.getImplicitRulesElement());
        }
        if (element.hasLanguageElement()) {
            this.composeCode("language", element.getLanguageElement());
        }
    }

    protected void composeAccount(String name, Account element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Account.AccountStatusEnumFactory());
            }
            if (element.hasActivePeriod()) {
                this.composePeriod("activePeriod", element.getActivePeriod());
            }
            if (element.hasCurrency()) {
                this.composeCoding("currency", element.getCurrency());
            }
            if (element.hasBalance()) {
                this.composeMoney("balance", element.getBalance());
            }
            if (element.hasCoveragePeriod()) {
                this.composePeriod("coveragePeriod", element.getCoveragePeriod());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasOwner()) {
                this.composeReference("owner", element.getOwner());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAllergyIntolerance(String name, AllergyIntolerance element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasOnsetElement()) {
                this.composeDateTime("onset", element.getOnsetElement());
            }
            if (element.hasRecordedDateElement()) {
                this.composeDateTime("recordedDate", element.getRecordedDateElement());
            }
            if (element.hasRecorder()) {
                this.composeReference("recorder", element.getRecorder());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasReporter()) {
                this.composeReference("reporter", element.getReporter());
            }
            if (element.hasSubstance()) {
                this.composeCodeableConcept("substance", element.getSubstance());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory());
            }
            if (element.hasCriticalityElement()) {
                this.composeEnumeration("criticality", element.getCriticalityElement(), new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory());
            }
            if (element.hasCategoryElement()) {
                this.composeEnumeration("category", element.getCategoryElement(), new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory());
            }
            if (element.hasLastOccurenceElement()) {
                this.composeDateTime("lastOccurence", element.getLastOccurenceElement());
            }
            if (element.hasNote()) {
                this.composeAnnotation("note", element.getNote());
            }
            if (element.hasReaction()) {
                for (AllergyIntolerance.AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : element.getReaction()) {
                    this.composeAllergyIntoleranceAllergyIntoleranceReactionComponent("reaction", allergyIntoleranceReactionComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponent(String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSubstance()) {
                this.composeCodeableConcept("substance", element.getSubstance());
            }
            if (element.hasCertaintyElement()) {
                this.composeEnumeration("certainty", element.getCertaintyElement(), new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory());
            }
            if (element.hasManifestation()) {
                for (CodeableConcept e : element.getManifestation()) {
                    this.composeCodeableConcept("manifestation", e);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasOnsetElement()) {
                this.composeDateTime("onset", element.getOnsetElement());
            }
            if (element.hasSeverityElement()) {
                this.composeEnumeration("severity", element.getSeverityElement(), new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory());
            }
            if (element.hasExposureRoute()) {
                this.composeCodeableConcept("exposureRoute", element.getExposureRoute());
            }
            if (element.hasNote()) {
                this.composeAnnotation("note", element.getNote());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAppointment(String name, Appointment element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Appointment.AppointmentStatusEnumFactory());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasReason()) {
                this.composeCodeableConcept("reason", element.getReason());
            }
            if (element.hasPriorityElement()) {
                this.composeUnsignedInt("priority", element.getPriorityElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasStartElement()) {
                this.composeInstant("start", element.getStartElement());
            }
            if (element.hasEndElement()) {
                this.composeInstant("end", element.getEndElement());
            }
            if (element.hasMinutesDurationElement()) {
                this.composePositiveInt("minutesDuration", element.getMinutesDurationElement());
            }
            if (element.hasSlot()) {
                for (Reference reference : element.getSlot()) {
                    this.composeReference("slot", reference);
                }
            }
            if (element.hasCommentElement()) {
                this.composeString("comment", element.getCommentElement());
            }
            if (element.hasParticipant()) {
                for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : element.getParticipant()) {
                    this.composeAppointmentAppointmentParticipantComponent("participant", appointmentParticipantComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAppointmentAppointmentParticipantComponent(String name, Appointment.AppointmentParticipantComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                for (CodeableConcept e : element.getType()) {
                    this.composeCodeableConcept("type", e);
                }
            }
            if (element.hasActor()) {
                this.composeReference("actor", element.getActor());
            }
            if (element.hasRequiredElement()) {
                this.composeEnumeration("required", element.getRequiredElement(), new Appointment.ParticipantRequiredEnumFactory());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Appointment.ParticipationStatusEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAppointmentResponse(String name, AppointmentResponse element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasAppointment()) {
                this.composeReference("appointment", element.getAppointment());
            }
            if (element.hasStartElement()) {
                this.composeInstant("start", element.getStartElement());
            }
            if (element.hasEndElement()) {
                this.composeInstant("end", element.getEndElement());
            }
            if (element.hasParticipantType()) {
                for (CodeableConcept codeableConcept : element.getParticipantType()) {
                    this.composeCodeableConcept("participantType", codeableConcept);
                }
            }
            if (element.hasActor()) {
                this.composeReference("actor", element.getActor());
            }
            if (element.hasParticipantStatusElement()) {
                this.composeEnumeration("participantStatus", element.getParticipantStatusElement(), new AppointmentResponse.ParticipantStatusEnumFactory());
            }
            if (element.hasCommentElement()) {
                this.composeString("comment", element.getCommentElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEvent(String name, AuditEvent element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasEvent()) {
                this.composeAuditEventAuditEventEventComponent("event", element.getEvent());
            }
            if (element.hasParticipant()) {
                for (AuditEvent.AuditEventParticipantComponent auditEventParticipantComponent : element.getParticipant()) {
                    this.composeAuditEventAuditEventParticipantComponent("participant", auditEventParticipantComponent);
                }
            }
            if (element.hasSource()) {
                this.composeAuditEventAuditEventSourceComponent("source", element.getSource());
            }
            if (element.hasObject()) {
                for (AuditEvent.AuditEventObjectComponent auditEventObjectComponent : element.getObject()) {
                    this.composeAuditEventAuditEventObjectComponent("object", auditEventObjectComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventEventComponent(String name, AuditEvent.AuditEventEventComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasSubtype()) {
                for (Coding e : element.getSubtype()) {
                    this.composeCoding("subtype", e);
                }
            }
            if (element.hasActionElement()) {
                this.composeEnumeration("action", element.getActionElement(), new AuditEvent.AuditEventActionEnumFactory());
            }
            if (element.hasDateTimeElement()) {
                this.composeInstant("dateTime", element.getDateTimeElement());
            }
            if (element.hasOutcomeElement()) {
                this.composeEnumeration("outcome", element.getOutcomeElement(), new AuditEvent.AuditEventOutcomeEnumFactory());
            }
            if (element.hasOutcomeDescElement()) {
                this.composeString("outcomeDesc", element.getOutcomeDescElement());
            }
            if (element.hasPurposeOfEvent()) {
                for (Coding e : element.getPurposeOfEvent()) {
                    this.composeCoding("purposeOfEvent", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventParticipantComponent(String name, AuditEvent.AuditEventParticipantComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasRole()) {
                for (CodeableConcept codeableConcept : element.getRole()) {
                    this.composeCodeableConcept("role", codeableConcept);
                }
            }
            if (element.hasReference()) {
                this.composeReference("reference", element.getReference());
            }
            if (element.hasUserId()) {
                this.composeIdentifier("userId", element.getUserId());
            }
            if (element.hasAltIdElement()) {
                this.composeString("altId", element.getAltIdElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasRequestorElement()) {
                this.composeBoolean("requestor", element.getRequestorElement());
            }
            if (element.hasLocation()) {
                this.composeReference("location", element.getLocation());
            }
            if (element.hasPolicy()) {
                for (UriType uriType : element.getPolicy()) {
                    this.composeUri("policy", uriType);
                }
            }
            if (element.hasMedia()) {
                this.composeCoding("media", element.getMedia());
            }
            if (element.hasNetwork()) {
                this.composeAuditEventAuditEventParticipantNetworkComponent("network", element.getNetwork());
            }
            if (element.hasPurposeOfUse()) {
                for (Coding coding : element.getPurposeOfUse()) {
                    this.composeCoding("purposeOfUse", coding);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventParticipantNetworkComponent(String name, AuditEvent.AuditEventParticipantNetworkComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasAddressElement()) {
                this.composeString("address", element.getAddressElement());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventSourceComponent(String name, AuditEvent.AuditEventSourceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSiteElement()) {
                this.composeString("site", element.getSiteElement());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasType()) {
                for (Coding e : element.getType()) {
                    this.composeCoding("type", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventObjectComponent(String name, AuditEvent.AuditEventObjectComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasReference()) {
                this.composeReference("reference", element.getReference());
            }
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasRole()) {
                this.composeCoding("role", element.getRole());
            }
            if (element.hasLifecycle()) {
                this.composeCoding("lifecycle", element.getLifecycle());
            }
            if (element.hasSecurityLabel()) {
                for (Coding coding : element.getSecurityLabel()) {
                    this.composeCoding("securityLabel", coding);
                }
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasQueryElement()) {
                this.composeBase64Binary("query", element.getQueryElement());
            }
            if (element.hasDetail()) {
                for (AuditEvent.AuditEventObjectDetailComponent auditEventObjectDetailComponent : element.getDetail()) {
                    this.composeAuditEventAuditEventObjectDetailComponent("detail", auditEventObjectDetailComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAuditEventAuditEventObjectDetailComponent(String name, AuditEvent.AuditEventObjectDetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTypeElement()) {
                this.composeString("type", element.getTypeElement());
            }
            if (element.hasValueElement()) {
                this.composeBase64Binary("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBasic(String name, Basic element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasAuthor()) {
                this.composeReference("author", element.getAuthor());
            }
            if (element.hasCreatedElement()) {
                this.composeDate("created", element.getCreatedElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBinary(String name, Binary element) throws IOException {
        if (element != null) {
            this.composeResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeResourceElements(element);
            if (element.hasContentTypeElement()) {
                this.composeCode("contentType", element.getContentTypeElement());
            }
            if (element.hasContentElement()) {
                this.composeBase64Binary("content", element.getContentElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBodySite(String name, BodySite element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasModifier()) {
                for (CodeableConcept codeableConcept : element.getModifier()) {
                    this.composeCodeableConcept("modifier", codeableConcept);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasImage()) {
                for (Attachment attachment : element.getImage()) {
                    this.composeAttachment("image", attachment);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundle(String name, Bundle element) throws IOException {
        if (element != null) {
            this.composeResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeResourceElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Bundle.BundleTypeEnumFactory());
            }
            if (element.hasTotalElement()) {
                this.composeUnsignedInt("total", element.getTotalElement());
            }
            if (element.hasLink()) {
                for (Bundle.BundleLinkComponent bundleLinkComponent : element.getLink()) {
                    this.composeBundleBundleLinkComponent("link", bundleLinkComponent);
                }
            }
            if (element.hasEntry()) {
                for (Bundle.BundleEntryComponent bundleEntryComponent : element.getEntry()) {
                    this.composeBundleBundleEntryComponent("entry", bundleEntryComponent);
                }
            }
            if (element.hasSignature()) {
                this.composeSignature("signature", element.getSignature());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleLinkComponent(String name, Bundle.BundleLinkComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasRelationElement()) {
                this.composeString("relation", element.getRelationElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntryComponent(String name, Bundle.BundleEntryComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasLink()) {
                for (Bundle.BundleLinkComponent e : element.getLink()) {
                    this.composeBundleBundleLinkComponent("link", e);
                }
            }
            if (element.hasFullUrlElement()) {
                this.composeUri("fullUrl", element.getFullUrlElement());
            }
            if (element.hasResource()) {
                this.xml.enter("http://hl7.org/fhir", "resource");
                this.composeResource(element.getResource());
                this.xml.exit("http://hl7.org/fhir", "resource");
            }
            if (element.hasSearch()) {
                this.composeBundleBundleEntrySearchComponent("search", element.getSearch());
            }
            if (element.hasRequest()) {
                this.composeBundleBundleEntryRequestComponent("request", element.getRequest());
            }
            if (element.hasResponse()) {
                this.composeBundleBundleEntryResponseComponent("response", element.getResponse());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntrySearchComponent(String name, Bundle.BundleEntrySearchComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasModeElement()) {
                this.composeEnumeration("mode", element.getModeElement(), new Bundle.SearchEntryModeEnumFactory());
            }
            if (element.hasScoreElement()) {
                this.composeDecimal("score", element.getScoreElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntryRequestComponent(String name, Bundle.BundleEntryRequestComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasMethodElement()) {
                this.composeEnumeration("method", element.getMethodElement(), new Bundle.HTTPVerbEnumFactory());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasIfNoneMatchElement()) {
                this.composeString("ifNoneMatch", element.getIfNoneMatchElement());
            }
            if (element.hasIfModifiedSinceElement()) {
                this.composeInstant("ifModifiedSince", element.getIfModifiedSinceElement());
            }
            if (element.hasIfMatchElement()) {
                this.composeString("ifMatch", element.getIfMatchElement());
            }
            if (element.hasIfNoneExistElement()) {
                this.composeString("ifNoneExist", element.getIfNoneExistElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeBundleBundleEntryResponseComponent(String name, Bundle.BundleEntryResponseComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasStatusElement()) {
                this.composeString("status", element.getStatusElement());
            }
            if (element.hasLocationElement()) {
                this.composeUri("location", element.getLocationElement());
            }
            if (element.hasEtagElement()) {
                this.composeString("etag", element.getEtagElement());
            }
            if (element.hasLastModifiedElement()) {
                this.composeInstant("lastModified", element.getLastModifiedElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCarePlan(String name, CarePlan element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new CarePlan.CarePlanStatusEnumFactory());
            }
            if (element.hasContext()) {
                this.composeReference("context", element.getContext());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasAuthor()) {
                for (Reference reference : element.getAuthor()) {
                    this.composeReference("author", reference);
                }
            }
            if (element.hasModifiedElement()) {
                this.composeDateTime("modified", element.getModifiedElement());
            }
            if (element.hasCategory()) {
                for (CodeableConcept codeableConcept : element.getCategory()) {
                    this.composeCodeableConcept("category", codeableConcept);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasAddresses()) {
                for (Reference reference : element.getAddresses()) {
                    this.composeReference("addresses", reference);
                }
            }
            if (element.hasSupport()) {
                for (Reference reference : element.getSupport()) {
                    this.composeReference("support", reference);
                }
            }
            if (element.hasRelatedPlan()) {
                for (CarePlan.CarePlanRelatedPlanComponent carePlanRelatedPlanComponent : element.getRelatedPlan()) {
                    this.composeCarePlanCarePlanRelatedPlanComponent("relatedPlan", carePlanRelatedPlanComponent);
                }
            }
            if (element.hasParticipant()) {
                for (CarePlan.CarePlanParticipantComponent carePlanParticipantComponent : element.getParticipant()) {
                    this.composeCarePlanCarePlanParticipantComponent("participant", carePlanParticipantComponent);
                }
            }
            if (element.hasGoal()) {
                for (Reference reference : element.getGoal()) {
                    this.composeReference("goal", reference);
                }
            }
            if (element.hasActivity()) {
                for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : element.getActivity()) {
                    this.composeCarePlanCarePlanActivityComponent("activity", carePlanActivityComponent);
                }
            }
            if (element.hasNote()) {
                this.composeAnnotation("note", element.getNote());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCarePlanCarePlanRelatedPlanComponent(String name, CarePlan.CarePlanRelatedPlanComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCodeElement()) {
                this.composeEnumeration("code", element.getCodeElement(), new CarePlan.CarePlanRelationshipEnumFactory());
            }
            if (element.hasPlan()) {
                this.composeReference("plan", element.getPlan());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCarePlanCarePlanParticipantComponent(String name, CarePlan.CarePlanParticipantComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasRole()) {
                this.composeCodeableConcept("role", element.getRole());
            }
            if (element.hasMember()) {
                this.composeReference("member", element.getMember());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCarePlanCarePlanActivityComponent(String name, CarePlan.CarePlanActivityComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasActionResulting()) {
                for (Reference reference : element.getActionResulting()) {
                    this.composeReference("actionResulting", reference);
                }
            }
            if (element.hasProgress()) {
                for (Annotation annotation : element.getProgress()) {
                    this.composeAnnotation("progress", annotation);
                }
            }
            if (element.hasReference()) {
                this.composeReference("reference", element.getReference());
            }
            if (element.hasDetail()) {
                this.composeCarePlanCarePlanActivityDetailComponent("detail", element.getDetail());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCarePlanCarePlanActivityDetailComponent(String name, CarePlan.CarePlanActivityDetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCategory()) {
                this.composeCodeableConcept("category", element.getCategory());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasReasonCode()) {
                for (CodeableConcept codeableConcept : element.getReasonCode()) {
                    this.composeCodeableConcept("reasonCode", codeableConcept);
                }
            }
            if (element.hasReasonReference()) {
                for (Reference reference : element.getReasonReference()) {
                    this.composeReference("reasonReference", reference);
                }
            }
            if (element.hasGoal()) {
                for (Reference reference : element.getGoal()) {
                    this.composeReference("goal", reference);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new CarePlan.CarePlanActivityStatusEnumFactory());
            }
            if (element.hasStatusReason()) {
                this.composeCodeableConcept("statusReason", element.getStatusReason());
            }
            if (element.hasProhibitedElement()) {
                this.composeBoolean("prohibited", element.getProhibitedElement());
            }
            if (element.hasScheduled()) {
                this.composeType("scheduled", element.getScheduled());
            }
            if (element.hasLocation()) {
                this.composeReference("location", element.getLocation());
            }
            if (element.hasPerformer()) {
                for (Reference reference : element.getPerformer()) {
                    this.composeReference("performer", reference);
                }
            }
            if (element.hasProduct()) {
                this.composeType("product", element.getProduct());
            }
            if (element.hasDailyAmount()) {
                this.composeSimpleQuantity("dailyAmount", element.getDailyAmount());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaim(String name, Claim element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Claim.ClaimTypeEnumFactory());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasRuleset()) {
                this.composeCoding("ruleset", element.getRuleset());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasTarget()) {
                this.composeReference("target", element.getTarget());
            }
            if (element.hasProvider()) {
                this.composeReference("provider", element.getProvider());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            if (element.hasUseElement()) {
                this.composeEnumeration("use", element.getUseElement(), new Claim.UseEnumFactory());
            }
            if (element.hasPriority()) {
                this.composeCoding("priority", element.getPriority());
            }
            if (element.hasFundsReserve()) {
                this.composeCoding("fundsReserve", element.getFundsReserve());
            }
            if (element.hasEnterer()) {
                this.composeReference("enterer", element.getEnterer());
            }
            if (element.hasFacility()) {
                this.composeReference("facility", element.getFacility());
            }
            if (element.hasPrescription()) {
                this.composeReference("prescription", element.getPrescription());
            }
            if (element.hasOriginalPrescription()) {
                this.composeReference("originalPrescription", element.getOriginalPrescription());
            }
            if (element.hasPayee()) {
                this.composeClaimPayeeComponent("payee", element.getPayee());
            }
            if (element.hasReferral()) {
                this.composeReference("referral", element.getReferral());
            }
            if (element.hasDiagnosis()) {
                for (Claim.DiagnosisComponent diagnosisComponent : element.getDiagnosis()) {
                    this.composeClaimDiagnosisComponent("diagnosis", diagnosisComponent);
                }
            }
            if (element.hasCondition()) {
                for (Coding coding : element.getCondition()) {
                    this.composeCoding("condition", coding);
                }
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasCoverage()) {
                for (Claim.CoverageComponent coverageComponent : element.getCoverage()) {
                    this.composeClaimCoverageComponent("coverage", coverageComponent);
                }
            }
            if (element.hasException()) {
                for (Coding coding : element.getException()) {
                    this.composeCoding("exception", coding);
                }
            }
            if (element.hasSchoolElement()) {
                this.composeString("school", element.getSchoolElement());
            }
            if (element.hasAccidentElement()) {
                this.composeDate("accident", element.getAccidentElement());
            }
            if (element.hasAccidentType()) {
                this.composeCoding("accidentType", element.getAccidentType());
            }
            if (element.hasInterventionException()) {
                for (Coding coding : element.getInterventionException()) {
                    this.composeCoding("interventionException", coding);
                }
            }
            if (element.hasItem()) {
                for (Claim.ItemsComponent itemsComponent : element.getItem()) {
                    this.composeClaimItemsComponent("item", itemsComponent);
                }
            }
            if (element.hasAdditionalMaterials()) {
                for (Coding coding : element.getAdditionalMaterials()) {
                    this.composeCoding("additionalMaterials", coding);
                }
            }
            if (element.hasMissingTeeth()) {
                for (Claim.MissingTeethComponent missingTeethComponent : element.getMissingTeeth()) {
                    this.composeClaimMissingTeethComponent("missingTeeth", missingTeethComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimPayeeComponent(String name, Claim.PayeeComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasProvider()) {
                this.composeReference("provider", element.getProvider());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            if (element.hasPerson()) {
                this.composeReference("person", element.getPerson());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimDiagnosisComponent(String name, Claim.DiagnosisComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceElement()) {
                this.composePositiveInt("sequence", element.getSequenceElement());
            }
            if (element.hasDiagnosis()) {
                this.composeCoding("diagnosis", element.getDiagnosis());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimCoverageComponent(String name, Claim.CoverageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceElement()) {
                this.composePositiveInt("sequence", element.getSequenceElement());
            }
            if (element.hasFocalElement()) {
                this.composeBoolean("focal", element.getFocalElement());
            }
            if (element.hasCoverage()) {
                this.composeReference("coverage", element.getCoverage());
            }
            if (element.hasBusinessArrangementElement()) {
                this.composeString("businessArrangement", element.getBusinessArrangementElement());
            }
            if (element.hasRelationship()) {
                this.composeCoding("relationship", element.getRelationship());
            }
            if (element.hasPreAuthRef()) {
                for (StringType e : element.getPreAuthRef()) {
                    this.composeString("preAuthRef", e);
                }
            }
            if (element.hasClaimResponse()) {
                this.composeReference("claimResponse", element.getClaimResponse());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimItemsComponent(String name, Claim.ItemsComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceElement()) {
                this.composePositiveInt("sequence", element.getSequenceElement());
            }
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasProvider()) {
                this.composeReference("provider", element.getProvider());
            }
            if (element.hasDiagnosisLinkId()) {
                for (PositiveIntType positiveIntType : element.getDiagnosisLinkId()) {
                    this.composePositiveInt("diagnosisLinkId", positiveIntType);
                }
            }
            if (element.hasService()) {
                this.composeCoding("service", element.getService());
            }
            if (element.hasServiceDateElement()) {
                this.composeDate("serviceDate", element.getServiceDateElement());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasUnitPrice()) {
                this.composeMoney("unitPrice", element.getUnitPrice());
            }
            if (element.hasFactorElement()) {
                this.composeDecimal("factor", element.getFactorElement());
            }
            if (element.hasPointsElement()) {
                this.composeDecimal("points", element.getPointsElement());
            }
            if (element.hasNet()) {
                this.composeMoney("net", element.getNet());
            }
            if (element.hasUdi()) {
                this.composeCoding("udi", element.getUdi());
            }
            if (element.hasBodySite()) {
                this.composeCoding("bodySite", element.getBodySite());
            }
            if (element.hasSubSite()) {
                for (Coding coding : element.getSubSite()) {
                    this.composeCoding("subSite", coding);
                }
            }
            if (element.hasModifier()) {
                for (Coding coding : element.getModifier()) {
                    this.composeCoding("modifier", coding);
                }
            }
            if (element.hasDetail()) {
                for (Claim.DetailComponent detailComponent : element.getDetail()) {
                    this.composeClaimDetailComponent("detail", detailComponent);
                }
            }
            if (element.hasProsthesis()) {
                this.composeClaimProsthesisComponent("prosthesis", element.getProsthesis());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimDetailComponent(String name, Claim.DetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceElement()) {
                this.composePositiveInt("sequence", element.getSequenceElement());
            }
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasService()) {
                this.composeCoding("service", element.getService());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasUnitPrice()) {
                this.composeMoney("unitPrice", element.getUnitPrice());
            }
            if (element.hasFactorElement()) {
                this.composeDecimal("factor", element.getFactorElement());
            }
            if (element.hasPointsElement()) {
                this.composeDecimal("points", element.getPointsElement());
            }
            if (element.hasNet()) {
                this.composeMoney("net", element.getNet());
            }
            if (element.hasUdi()) {
                this.composeCoding("udi", element.getUdi());
            }
            if (element.hasSubDetail()) {
                for (Claim.SubDetailComponent e : element.getSubDetail()) {
                    this.composeClaimSubDetailComponent("subDetail", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimSubDetailComponent(String name, Claim.SubDetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceElement()) {
                this.composePositiveInt("sequence", element.getSequenceElement());
            }
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasService()) {
                this.composeCoding("service", element.getService());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasUnitPrice()) {
                this.composeMoney("unitPrice", element.getUnitPrice());
            }
            if (element.hasFactorElement()) {
                this.composeDecimal("factor", element.getFactorElement());
            }
            if (element.hasPointsElement()) {
                this.composeDecimal("points", element.getPointsElement());
            }
            if (element.hasNet()) {
                this.composeMoney("net", element.getNet());
            }
            if (element.hasUdi()) {
                this.composeCoding("udi", element.getUdi());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimProsthesisComponent(String name, Claim.ProsthesisComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasInitialElement()) {
                this.composeBoolean("initial", element.getInitialElement());
            }
            if (element.hasPriorDateElement()) {
                this.composeDate("priorDate", element.getPriorDateElement());
            }
            if (element.hasPriorMaterial()) {
                this.composeCoding("priorMaterial", element.getPriorMaterial());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimMissingTeethComponent(String name, Claim.MissingTeethComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTooth()) {
                this.composeCoding("tooth", element.getTooth());
            }
            if (element.hasReason()) {
                this.composeCoding("reason", element.getReason());
            }
            if (element.hasExtractionDateElement()) {
                this.composeDate("extractionDate", element.getExtractionDateElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponse(String name, ClaimResponse element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasRequest()) {
                this.composeReference("request", element.getRequest());
            }
            if (element.hasRuleset()) {
                this.composeCoding("ruleset", element.getRuleset());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            if (element.hasRequestProvider()) {
                this.composeReference("requestProvider", element.getRequestProvider());
            }
            if (element.hasRequestOrganization()) {
                this.composeReference("requestOrganization", element.getRequestOrganization());
            }
            if (element.hasOutcomeElement()) {
                this.composeEnumeration("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory());
            }
            if (element.hasDispositionElement()) {
                this.composeString("disposition", element.getDispositionElement());
            }
            if (element.hasPayeeType()) {
                this.composeCoding("payeeType", element.getPayeeType());
            }
            if (element.hasItem()) {
                for (ClaimResponse.ItemsComponent itemsComponent : element.getItem()) {
                    this.composeClaimResponseItemsComponent("item", itemsComponent);
                }
            }
            if (element.hasAddItem()) {
                for (ClaimResponse.AddedItemComponent addedItemComponent : element.getAddItem()) {
                    this.composeClaimResponseAddedItemComponent("addItem", addedItemComponent);
                }
            }
            if (element.hasError()) {
                for (ClaimResponse.ErrorsComponent errorsComponent : element.getError()) {
                    this.composeClaimResponseErrorsComponent("error", errorsComponent);
                }
            }
            if (element.hasTotalCost()) {
                this.composeMoney("totalCost", element.getTotalCost());
            }
            if (element.hasUnallocDeductable()) {
                this.composeMoney("unallocDeductable", element.getUnallocDeductable());
            }
            if (element.hasTotalBenefit()) {
                this.composeMoney("totalBenefit", element.getTotalBenefit());
            }
            if (element.hasPaymentAdjustment()) {
                this.composeMoney("paymentAdjustment", element.getPaymentAdjustment());
            }
            if (element.hasPaymentAdjustmentReason()) {
                this.composeCoding("paymentAdjustmentReason", element.getPaymentAdjustmentReason());
            }
            if (element.hasPaymentDateElement()) {
                this.composeDate("paymentDate", element.getPaymentDateElement());
            }
            if (element.hasPaymentAmount()) {
                this.composeMoney("paymentAmount", element.getPaymentAmount());
            }
            if (element.hasPaymentRef()) {
                this.composeIdentifier("paymentRef", element.getPaymentRef());
            }
            if (element.hasReserved()) {
                this.composeCoding("reserved", element.getReserved());
            }
            if (element.hasForm()) {
                this.composeCoding("form", element.getForm());
            }
            if (element.hasNote()) {
                for (ClaimResponse.NotesComponent notesComponent : element.getNote()) {
                    this.composeClaimResponseNotesComponent("note", notesComponent);
                }
            }
            if (element.hasCoverage()) {
                for (ClaimResponse.CoverageComponent coverageComponent : element.getCoverage()) {
                    this.composeClaimResponseCoverageComponent("coverage", coverageComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseItemsComponent(String name, ClaimResponse.ItemsComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceLinkIdElement()) {
                this.composePositiveInt("sequenceLinkId", element.getSequenceLinkIdElement());
            }
            if (element.hasNoteNumber()) {
                for (PositiveIntType positiveIntType : element.getNoteNumber()) {
                    this.composePositiveInt("noteNumber", positiveIntType);
                }
            }
            if (element.hasAdjudication()) {
                for (ClaimResponse.ItemAdjudicationComponent itemAdjudicationComponent : element.getAdjudication()) {
                    this.composeClaimResponseItemAdjudicationComponent("adjudication", itemAdjudicationComponent);
                }
            }
            if (element.hasDetail()) {
                for (ClaimResponse.ItemDetailComponent itemDetailComponent : element.getDetail()) {
                    this.composeClaimResponseItemDetailComponent("detail", itemDetailComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseItemAdjudicationComponent(String name, ClaimResponse.ItemAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCoding("code", element.getCode());
            }
            if (element.hasAmount()) {
                this.composeMoney("amount", element.getAmount());
            }
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseItemDetailComponent(String name, ClaimResponse.ItemDetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceLinkIdElement()) {
                this.composePositiveInt("sequenceLinkId", element.getSequenceLinkIdElement());
            }
            if (element.hasAdjudication()) {
                for (ClaimResponse.DetailAdjudicationComponent detailAdjudicationComponent : element.getAdjudication()) {
                    this.composeClaimResponseDetailAdjudicationComponent("adjudication", detailAdjudicationComponent);
                }
            }
            if (element.hasSubDetail()) {
                for (ClaimResponse.SubDetailComponent subDetailComponent : element.getSubDetail()) {
                    this.composeClaimResponseSubDetailComponent("subDetail", subDetailComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseDetailAdjudicationComponent(String name, ClaimResponse.DetailAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCoding("code", element.getCode());
            }
            if (element.hasAmount()) {
                this.composeMoney("amount", element.getAmount());
            }
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseSubDetailComponent(String name, ClaimResponse.SubDetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceLinkIdElement()) {
                this.composePositiveInt("sequenceLinkId", element.getSequenceLinkIdElement());
            }
            if (element.hasAdjudication()) {
                for (ClaimResponse.SubdetailAdjudicationComponent e : element.getAdjudication()) {
                    this.composeClaimResponseSubdetailAdjudicationComponent("adjudication", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseSubdetailAdjudicationComponent(String name, ClaimResponse.SubdetailAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCoding("code", element.getCode());
            }
            if (element.hasAmount()) {
                this.composeMoney("amount", element.getAmount());
            }
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseAddedItemComponent(String name, ClaimResponse.AddedItemComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceLinkId()) {
                for (PositiveIntType positiveIntType : element.getSequenceLinkId()) {
                    this.composePositiveInt("sequenceLinkId", positiveIntType);
                }
            }
            if (element.hasService()) {
                this.composeCoding("service", element.getService());
            }
            if (element.hasFee()) {
                this.composeMoney("fee", element.getFee());
            }
            if (element.hasNoteNumberLinkId()) {
                for (PositiveIntType positiveIntType : element.getNoteNumberLinkId()) {
                    this.composePositiveInt("noteNumberLinkId", positiveIntType);
                }
            }
            if (element.hasAdjudication()) {
                for (ClaimResponse.AddedItemAdjudicationComponent addedItemAdjudicationComponent : element.getAdjudication()) {
                    this.composeClaimResponseAddedItemAdjudicationComponent("adjudication", addedItemAdjudicationComponent);
                }
            }
            if (element.hasDetail()) {
                for (ClaimResponse.AddedItemsDetailComponent addedItemsDetailComponent : element.getDetail()) {
                    this.composeClaimResponseAddedItemsDetailComponent("detail", addedItemsDetailComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseAddedItemAdjudicationComponent(String name, ClaimResponse.AddedItemAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCoding("code", element.getCode());
            }
            if (element.hasAmount()) {
                this.composeMoney("amount", element.getAmount());
            }
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseAddedItemsDetailComponent(String name, ClaimResponse.AddedItemsDetailComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasService()) {
                this.composeCoding("service", element.getService());
            }
            if (element.hasFee()) {
                this.composeMoney("fee", element.getFee());
            }
            if (element.hasAdjudication()) {
                for (ClaimResponse.AddedItemDetailAdjudicationComponent e : element.getAdjudication()) {
                    this.composeClaimResponseAddedItemDetailAdjudicationComponent("adjudication", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseAddedItemDetailAdjudicationComponent(String name, ClaimResponse.AddedItemDetailAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCoding("code", element.getCode());
            }
            if (element.hasAmount()) {
                this.composeMoney("amount", element.getAmount());
            }
            if (element.hasValueElement()) {
                this.composeDecimal("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseErrorsComponent(String name, ClaimResponse.ErrorsComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceLinkIdElement()) {
                this.composePositiveInt("sequenceLinkId", element.getSequenceLinkIdElement());
            }
            if (element.hasDetailSequenceLinkIdElement()) {
                this.composePositiveInt("detailSequenceLinkId", element.getDetailSequenceLinkIdElement());
            }
            if (element.hasSubdetailSequenceLinkIdElement()) {
                this.composePositiveInt("subdetailSequenceLinkId", element.getSubdetailSequenceLinkIdElement());
            }
            if (element.hasCode()) {
                this.composeCoding("code", element.getCode());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseNotesComponent(String name, ClaimResponse.NotesComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNumberElement()) {
                this.composePositiveInt("number", element.getNumberElement());
            }
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClaimResponseCoverageComponent(String name, ClaimResponse.CoverageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSequenceElement()) {
                this.composePositiveInt("sequence", element.getSequenceElement());
            }
            if (element.hasFocalElement()) {
                this.composeBoolean("focal", element.getFocalElement());
            }
            if (element.hasCoverage()) {
                this.composeReference("coverage", element.getCoverage());
            }
            if (element.hasBusinessArrangementElement()) {
                this.composeString("businessArrangement", element.getBusinessArrangementElement());
            }
            if (element.hasRelationship()) {
                this.composeCoding("relationship", element.getRelationship());
            }
            if (element.hasPreAuthRef()) {
                for (StringType e : element.getPreAuthRef()) {
                    this.composeString("preAuthRef", e);
                }
            }
            if (element.hasClaimResponse()) {
                this.composeReference("claimResponse", element.getClaimResponse());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClinicalImpression(String name, ClinicalImpression element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasAssessor()) {
                this.composeReference("assessor", element.getAssessor());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new ClinicalImpression.ClinicalImpressionStatusEnumFactory());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasPrevious()) {
                this.composeReference("previous", element.getPrevious());
            }
            if (element.hasProblem()) {
                for (Reference reference : element.getProblem()) {
                    this.composeReference("problem", reference);
                }
            }
            if (element.hasTrigger()) {
                this.composeType("trigger", element.getTrigger());
            }
            if (element.hasInvestigations()) {
                for (ClinicalImpression.ClinicalImpressionInvestigationsComponent clinicalImpressionInvestigationsComponent : element.getInvestigations()) {
                    this.composeClinicalImpressionClinicalImpressionInvestigationsComponent("investigations", clinicalImpressionInvestigationsComponent);
                }
            }
            if (element.hasProtocolElement()) {
                this.composeUri("protocol", element.getProtocolElement());
            }
            if (element.hasSummaryElement()) {
                this.composeString("summary", element.getSummaryElement());
            }
            if (element.hasFinding()) {
                for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : element.getFinding()) {
                    this.composeClinicalImpressionClinicalImpressionFindingComponent("finding", clinicalImpressionFindingComponent);
                }
            }
            if (element.hasResolved()) {
                for (CodeableConcept codeableConcept : element.getResolved()) {
                    this.composeCodeableConcept("resolved", codeableConcept);
                }
            }
            if (element.hasRuledOut()) {
                for (ClinicalImpression.ClinicalImpressionRuledOutComponent clinicalImpressionRuledOutComponent : element.getRuledOut()) {
                    this.composeClinicalImpressionClinicalImpressionRuledOutComponent("ruledOut", clinicalImpressionRuledOutComponent);
                }
            }
            if (element.hasPrognosisElement()) {
                this.composeString("prognosis", element.getPrognosisElement());
            }
            if (element.hasPlan()) {
                for (Reference reference : element.getPlan()) {
                    this.composeReference("plan", reference);
                }
            }
            if (element.hasAction()) {
                for (Reference reference : element.getAction()) {
                    this.composeReference("action", reference);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionInvestigationsComponent(String name, ClinicalImpression.ClinicalImpressionInvestigationsComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasItem()) {
                for (Reference e : element.getItem()) {
                    this.composeReference("item", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionFindingComponent(String name, ClinicalImpression.ClinicalImpressionFindingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasItem()) {
                this.composeCodeableConcept("item", element.getItem());
            }
            if (element.hasCauseElement()) {
                this.composeString("cause", element.getCauseElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionRuledOutComponent(String name, ClinicalImpression.ClinicalImpressionRuledOutComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasItem()) {
                this.composeCodeableConcept("item", element.getItem());
            }
            if (element.hasReasonElement()) {
                this.composeString("reason", element.getReasonElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCommunication(String name, Communication element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasCategory()) {
                this.composeCodeableConcept("category", element.getCategory());
            }
            if (element.hasSender()) {
                this.composeReference("sender", element.getSender());
            }
            if (element.hasRecipient()) {
                for (Reference reference : element.getRecipient()) {
                    this.composeReference("recipient", reference);
                }
            }
            if (element.hasPayload()) {
                for (Communication.CommunicationPayloadComponent communicationPayloadComponent : element.getPayload()) {
                    this.composeCommunicationCommunicationPayloadComponent("payload", communicationPayloadComponent);
                }
            }
            if (element.hasMedium()) {
                for (CodeableConcept codeableConcept : element.getMedium()) {
                    this.composeCodeableConcept("medium", codeableConcept);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Communication.CommunicationStatusEnumFactory());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasSentElement()) {
                this.composeDateTime("sent", element.getSentElement());
            }
            if (element.hasReceivedElement()) {
                this.composeDateTime("received", element.getReceivedElement());
            }
            if (element.hasReason()) {
                for (CodeableConcept codeableConcept : element.getReason()) {
                    this.composeCodeableConcept("reason", codeableConcept);
                }
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasRequestDetail()) {
                this.composeReference("requestDetail", element.getRequestDetail());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCommunicationCommunicationPayloadComponent(String name, Communication.CommunicationPayloadComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasContent()) {
                this.composeType("content", element.getContent());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCommunicationRequest(String name, CommunicationRequest element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasCategory()) {
                this.composeCodeableConcept("category", element.getCategory());
            }
            if (element.hasSender()) {
                this.composeReference("sender", element.getSender());
            }
            if (element.hasRecipient()) {
                for (Reference reference : element.getRecipient()) {
                    this.composeReference("recipient", reference);
                }
            }
            if (element.hasPayload()) {
                for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : element.getPayload()) {
                    this.composeCommunicationRequestCommunicationRequestPayloadComponent("payload", communicationRequestPayloadComponent);
                }
            }
            if (element.hasMedium()) {
                for (CodeableConcept codeableConcept : element.getMedium()) {
                    this.composeCodeableConcept("medium", codeableConcept);
                }
            }
            if (element.hasRequester()) {
                this.composeReference("requester", element.getRequester());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new CommunicationRequest.CommunicationRequestStatusEnumFactory());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasScheduled()) {
                this.composeType("scheduled", element.getScheduled());
            }
            if (element.hasReason()) {
                for (CodeableConcept codeableConcept : element.getReason()) {
                    this.composeCodeableConcept("reason", codeableConcept);
                }
            }
            if (element.hasRequestedOnElement()) {
                this.composeDateTime("requestedOn", element.getRequestedOnElement());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasPriority()) {
                this.composeCodeableConcept("priority", element.getPriority());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCommunicationRequestCommunicationRequestPayloadComponent(String name, CommunicationRequest.CommunicationRequestPayloadComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasContent()) {
                this.composeType("content", element.getContent());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeComposition(String name, Composition element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasClass_()) {
                this.composeCodeableConcept("class", element.getClass_());
            }
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Composition.CompositionStatusEnumFactory());
            }
            if (element.hasConfidentialityElement()) {
                this.composeCode("confidentiality", element.getConfidentialityElement());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasAuthor()) {
                for (Reference reference : element.getAuthor()) {
                    this.composeReference("author", reference);
                }
            }
            if (element.hasAttester()) {
                for (Composition.CompositionAttesterComponent compositionAttesterComponent : element.getAttester()) {
                    this.composeCompositionCompositionAttesterComponent("attester", compositionAttesterComponent);
                }
            }
            if (element.hasCustodian()) {
                this.composeReference("custodian", element.getCustodian());
            }
            if (element.hasEvent()) {
                for (Composition.CompositionEventComponent compositionEventComponent : element.getEvent()) {
                    this.composeCompositionCompositionEventComponent("event", compositionEventComponent);
                }
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasSection()) {
                for (Composition.SectionComponent sectionComponent : element.getSection()) {
                    this.composeCompositionSectionComponent("section", sectionComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCompositionCompositionAttesterComponent(String name, Composition.CompositionAttesterComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasMode()) {
                for (Enumeration<Composition.CompositionAttestationMode> e : element.getMode()) {
                    this.composeEnumeration("mode", e, new Composition.CompositionAttestationModeEnumFactory());
                }
            }
            if (element.hasTimeElement()) {
                this.composeDateTime("time", element.getTimeElement());
            }
            if (element.hasParty()) {
                this.composeReference("party", element.getParty());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCompositionCompositionEventComponent(String name, Composition.CompositionEventComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                for (CodeableConcept codeableConcept : element.getCode()) {
                    this.composeCodeableConcept("code", codeableConcept);
                }
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasDetail()) {
                for (Reference reference : element.getDetail()) {
                    this.composeReference("detail", reference);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCompositionSectionComponent(String name, Composition.SectionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasText()) {
                this.composeNarrative("text", element.getText());
            }
            if (element.hasModeElement()) {
                this.composeCode("mode", element.getModeElement());
            }
            if (element.hasOrderedBy()) {
                this.composeCodeableConcept("orderedBy", element.getOrderedBy());
            }
            if (element.hasEntry()) {
                for (Reference reference : element.getEntry()) {
                    this.composeReference("entry", reference);
                }
            }
            if (element.hasEmptyReason()) {
                this.composeCodeableConcept("emptyReason", element.getEmptyReason());
            }
            if (element.hasSection()) {
                for (Composition.SectionComponent sectionComponent : element.getSection()) {
                    this.composeCompositionSectionComponent("section", sectionComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConceptMap(String name, ConceptMap element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory());
            }
            if (element.hasExperimentalElement()) {
                this.composeBoolean("experimental", element.getExperimentalElement());
            }
            if (element.hasPublisherElement()) {
                this.composeString("publisher", element.getPublisherElement());
            }
            if (element.hasContact()) {
                for (ConceptMap.ConceptMapContactComponent conceptMapContactComponent : element.getContact()) {
                    this.composeConceptMapConceptMapContactComponent("contact", conceptMapContactComponent);
                }
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasUseContext()) {
                for (CodeableConcept codeableConcept : element.getUseContext()) {
                    this.composeCodeableConcept("useContext", codeableConcept);
                }
            }
            if (element.hasRequirementsElement()) {
                this.composeString("requirements", element.getRequirementsElement());
            }
            if (element.hasCopyrightElement()) {
                this.composeString("copyright", element.getCopyrightElement());
            }
            if (element.hasSource()) {
                this.composeType("source", element.getSource());
            }
            if (element.hasTarget()) {
                this.composeType("target", element.getTarget());
            }
            if (element.hasElement()) {
                for (ConceptMap.SourceElementComponent sourceElementComponent : element.getElement()) {
                    this.composeConceptMapSourceElementComponent("element", sourceElementComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConceptMapConceptMapContactComponent(String name, ConceptMap.ConceptMapContactComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasTelecom()) {
                for (ContactPoint e : element.getTelecom()) {
                    this.composeContactPoint("telecom", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConceptMapSourceElementComponent(String name, ConceptMap.SourceElementComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCodeSystemElement()) {
                this.composeUri("codeSystem", element.getCodeSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            if (element.hasTarget()) {
                for (ConceptMap.TargetElementComponent e : element.getTarget()) {
                    this.composeConceptMapTargetElementComponent("target", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConceptMapTargetElementComponent(String name, ConceptMap.TargetElementComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCodeSystemElement()) {
                this.composeUri("codeSystem", element.getCodeSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeCode("code", element.getCodeElement());
            }
            if (element.hasEquivalenceElement()) {
                this.composeEnumeration("equivalence", element.getEquivalenceElement(), new Enumerations.ConceptMapEquivalenceEnumFactory());
            }
            if (element.hasCommentsElement()) {
                this.composeString("comments", element.getCommentsElement());
            }
            if (element.hasDependsOn()) {
                for (ConceptMap.OtherElementComponent e : element.getDependsOn()) {
                    this.composeConceptMapOtherElementComponent("dependsOn", e);
                }
            }
            if (element.hasProduct()) {
                for (ConceptMap.OtherElementComponent e : element.getProduct()) {
                    this.composeConceptMapOtherElementComponent("product", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConceptMapOtherElementComponent(String name, ConceptMap.OtherElementComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasElementElement()) {
                this.composeUri("element", element.getElementElement());
            }
            if (element.hasCodeSystemElement()) {
                this.composeUri("codeSystem", element.getCodeSystemElement());
            }
            if (element.hasCodeElement()) {
                this.composeString("code", element.getCodeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCondition(String name, Condition element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasAsserter()) {
                this.composeReference("asserter", element.getAsserter());
            }
            if (element.hasDateRecordedElement()) {
                this.composeDate("dateRecorded", element.getDateRecordedElement());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasCategory()) {
                this.composeCodeableConcept("category", element.getCategory());
            }
            if (element.hasClinicalStatusElement()) {
                this.composeCode("clinicalStatus", element.getClinicalStatusElement());
            }
            if (element.hasVerificationStatusElement()) {
                this.composeEnumeration("verificationStatus", element.getVerificationStatusElement(), new Condition.ConditionVerificationStatusEnumFactory());
            }
            if (element.hasSeverity()) {
                this.composeCodeableConcept("severity", element.getSeverity());
            }
            if (element.hasOnset()) {
                this.composeType("onset", element.getOnset());
            }
            if (element.hasAbatement()) {
                this.composeType("abatement", element.getAbatement());
            }
            if (element.hasStage()) {
                this.composeConditionConditionStageComponent("stage", element.getStage());
            }
            if (element.hasEvidence()) {
                for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : element.getEvidence()) {
                    this.composeConditionConditionEvidenceComponent("evidence", conditionEvidenceComponent);
                }
            }
            if (element.hasBodySite()) {
                for (CodeableConcept codeableConcept : element.getBodySite()) {
                    this.composeCodeableConcept("bodySite", codeableConcept);
                }
            }
            if (element.hasNotesElement()) {
                this.composeString("notes", element.getNotesElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConditionConditionStageComponent(String name, Condition.ConditionStageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSummary()) {
                this.composeCodeableConcept("summary", element.getSummary());
            }
            if (element.hasAssessment()) {
                for (Reference e : element.getAssessment()) {
                    this.composeReference("assessment", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConditionConditionEvidenceComponent(String name, Condition.ConditionEvidenceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasDetail()) {
                for (Reference e : element.getDetail()) {
                    this.composeReference("detail", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformance(String name, Conformance element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory());
            }
            if (element.hasExperimentalElement()) {
                this.composeBoolean("experimental", element.getExperimentalElement());
            }
            if (element.hasPublisherElement()) {
                this.composeString("publisher", element.getPublisherElement());
            }
            if (element.hasContact()) {
                for (Conformance.ConformanceContactComponent conformanceContactComponent : element.getContact()) {
                    this.composeConformanceConformanceContactComponent("contact", conformanceContactComponent);
                }
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasRequirementsElement()) {
                this.composeString("requirements", element.getRequirementsElement());
            }
            if (element.hasCopyrightElement()) {
                this.composeString("copyright", element.getCopyrightElement());
            }
            if (element.hasKindElement()) {
                this.composeEnumeration("kind", element.getKindElement(), new Conformance.ConformanceStatementKindEnumFactory());
            }
            if (element.hasSoftware()) {
                this.composeConformanceConformanceSoftwareComponent("software", element.getSoftware());
            }
            if (element.hasImplementation()) {
                this.composeConformanceConformanceImplementationComponent("implementation", element.getImplementation());
            }
            if (element.hasFhirVersionElement()) {
                this.composeId("fhirVersion", element.getFhirVersionElement());
            }
            if (element.hasAcceptUnknownElement()) {
                this.composeEnumeration("acceptUnknown", element.getAcceptUnknownElement(), new Conformance.UnknownContentCodeEnumFactory());
            }
            if (element.hasFormat()) {
                for (CodeType codeType : element.getFormat()) {
                    this.composeCode("format", codeType);
                }
            }
            if (element.hasProfile()) {
                for (Reference reference : element.getProfile()) {
                    this.composeReference("profile", reference);
                }
            }
            if (element.hasRest()) {
                for (Conformance.ConformanceRestComponent conformanceRestComponent : element.getRest()) {
                    this.composeConformanceConformanceRestComponent("rest", conformanceRestComponent);
                }
            }
            if (element.hasMessaging()) {
                for (Conformance.ConformanceMessagingComponent conformanceMessagingComponent : element.getMessaging()) {
                    this.composeConformanceConformanceMessagingComponent("messaging", conformanceMessagingComponent);
                }
            }
            if (element.hasDocument()) {
                for (Conformance.ConformanceDocumentComponent conformanceDocumentComponent : element.getDocument()) {
                    this.composeConformanceConformanceDocumentComponent("document", conformanceDocumentComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceContactComponent(String name, Conformance.ConformanceContactComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasTelecom()) {
                for (ContactPoint e : element.getTelecom()) {
                    this.composeContactPoint("telecom", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceSoftwareComponent(String name, Conformance.ConformanceSoftwareComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasReleaseDateElement()) {
                this.composeDateTime("releaseDate", element.getReleaseDateElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceImplementationComponent(String name, Conformance.ConformanceImplementationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceRestComponent(String name, Conformance.ConformanceRestComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasModeElement()) {
                this.composeEnumeration("mode", element.getModeElement(), new Conformance.RestfulConformanceModeEnumFactory());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            if (element.hasSecurity()) {
                this.composeConformanceConformanceRestSecurityComponent("security", element.getSecurity());
            }
            if (element.hasResource()) {
                for (Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent : element.getResource()) {
                    this.composeConformanceConformanceRestResourceComponent("resource", conformanceRestResourceComponent);
                }
            }
            if (element.hasInteraction()) {
                for (Conformance.SystemInteractionComponent systemInteractionComponent : element.getInteraction()) {
                    this.composeConformanceSystemInteractionComponent("interaction", systemInteractionComponent);
                }
            }
            if (element.hasTransactionModeElement()) {
                this.composeEnumeration("transactionMode", element.getTransactionModeElement(), new Conformance.TransactionModeEnumFactory());
            }
            if (element.hasSearchParam()) {
                for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : element.getSearchParam()) {
                    this.composeConformanceConformanceRestResourceSearchParamComponent("searchParam", conformanceRestResourceSearchParamComponent);
                }
            }
            if (element.hasOperation()) {
                for (Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent : element.getOperation()) {
                    this.composeConformanceConformanceRestOperationComponent("operation", conformanceRestOperationComponent);
                }
            }
            if (element.hasCompartment()) {
                for (UriType uriType : element.getCompartment()) {
                    this.composeUri("compartment", uriType);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceRestSecurityComponent(String name, Conformance.ConformanceRestSecurityComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCorsElement()) {
                this.composeBoolean("cors", element.getCorsElement());
            }
            if (element.hasService()) {
                for (CodeableConcept codeableConcept : element.getService()) {
                    this.composeCodeableConcept("service", codeableConcept);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasCertificate()) {
                for (Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent : element.getCertificate()) {
                    this.composeConformanceConformanceRestSecurityCertificateComponent("certificate", conformanceRestSecurityCertificateComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceRestSecurityCertificateComponent(String name, Conformance.ConformanceRestSecurityCertificateComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTypeElement()) {
                this.composeCode("type", element.getTypeElement());
            }
            if (element.hasBlobElement()) {
                this.composeBase64Binary("blob", element.getBlobElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceRestResourceComponent(String name, Conformance.ConformanceRestResourceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTypeElement()) {
                this.composeCode("type", element.getTypeElement());
            }
            if (element.hasProfile()) {
                this.composeReference("profile", element.getProfile());
            }
            if (element.hasInteraction()) {
                for (Conformance.ResourceInteractionComponent resourceInteractionComponent : element.getInteraction()) {
                    this.composeConformanceResourceInteractionComponent("interaction", resourceInteractionComponent);
                }
            }
            if (element.hasVersioningElement()) {
                this.composeEnumeration("versioning", element.getVersioningElement(), new Conformance.ResourceVersionPolicyEnumFactory());
            }
            if (element.hasReadHistoryElement()) {
                this.composeBoolean("readHistory", element.getReadHistoryElement());
            }
            if (element.hasUpdateCreateElement()) {
                this.composeBoolean("updateCreate", element.getUpdateCreateElement());
            }
            if (element.hasConditionalCreateElement()) {
                this.composeBoolean("conditionalCreate", element.getConditionalCreateElement());
            }
            if (element.hasConditionalUpdateElement()) {
                this.composeBoolean("conditionalUpdate", element.getConditionalUpdateElement());
            }
            if (element.hasConditionalDeleteElement()) {
                this.composeEnumeration("conditionalDelete", element.getConditionalDeleteElement(), new Conformance.ConditionalDeleteStatusEnumFactory());
            }
            if (element.hasSearchInclude()) {
                for (StringType stringType : element.getSearchInclude()) {
                    this.composeString("searchInclude", stringType);
                }
            }
            if (element.hasSearchRevInclude()) {
                for (StringType stringType : element.getSearchRevInclude()) {
                    this.composeString("searchRevInclude", stringType);
                }
            }
            if (element.hasSearchParam()) {
                for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : element.getSearchParam()) {
                    this.composeConformanceConformanceRestResourceSearchParamComponent("searchParam", conformanceRestResourceSearchParamComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceResourceInteractionComponent(String name, Conformance.ResourceInteractionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCodeElement()) {
                this.composeEnumeration("code", element.getCodeElement(), new Conformance.TypeRestfulInteractionEnumFactory());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceRestResourceSearchParamComponent(String name, Conformance.ConformanceRestResourceSearchParamComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasDefinitionElement()) {
                this.composeUri("definition", element.getDefinitionElement());
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Enumerations.SearchParamTypeEnumFactory());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            if (element.hasTarget()) {
                for (CodeType codeType : element.getTarget()) {
                    this.composeCode("target", codeType);
                }
            }
            if (element.hasModifier()) {
                for (Enumeration enumeration : element.getModifier()) {
                    this.composeEnumeration("modifier", enumeration, new Conformance.SearchModifierCodeEnumFactory());
                }
            }
            if (element.hasChain()) {
                for (StringType stringType : element.getChain()) {
                    this.composeString("chain", stringType);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceSystemInteractionComponent(String name, Conformance.SystemInteractionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCodeElement()) {
                this.composeEnumeration("code", element.getCodeElement(), new Conformance.SystemRestfulInteractionEnumFactory());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceRestOperationComponent(String name, Conformance.ConformanceRestOperationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasDefinition()) {
                this.composeReference("definition", element.getDefinition());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceMessagingComponent(String name, Conformance.ConformanceMessagingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasEndpoint()) {
                for (Conformance.ConformanceMessagingEndpointComponent conformanceMessagingEndpointComponent : element.getEndpoint()) {
                    this.composeConformanceConformanceMessagingEndpointComponent("endpoint", conformanceMessagingEndpointComponent);
                }
            }
            if (element.hasReliableCacheElement()) {
                this.composeUnsignedInt("reliableCache", element.getReliableCacheElement());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            if (element.hasEvent()) {
                for (Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent : element.getEvent()) {
                    this.composeConformanceConformanceMessagingEventComponent("event", conformanceMessagingEventComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceMessagingEndpointComponent(String name, Conformance.ConformanceMessagingEndpointComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasProtocol()) {
                this.composeCoding("protocol", element.getProtocol());
            }
            if (element.hasAddressElement()) {
                this.composeUri("address", element.getAddressElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceMessagingEventComponent(String name, Conformance.ConformanceMessagingEventComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCoding("code", element.getCode());
            }
            if (element.hasCategoryElement()) {
                this.composeEnumeration("category", element.getCategoryElement(), new Conformance.MessageSignificanceCategoryEnumFactory());
            }
            if (element.hasModeElement()) {
                this.composeEnumeration("mode", element.getModeElement(), new Conformance.ConformanceEventModeEnumFactory());
            }
            if (element.hasFocusElement()) {
                this.composeCode("focus", element.getFocusElement());
            }
            if (element.hasRequest()) {
                this.composeReference("request", element.getRequest());
            }
            if (element.hasResponse()) {
                this.composeReference("response", element.getResponse());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeConformanceConformanceDocumentComponent(String name, Conformance.ConformanceDocumentComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasModeElement()) {
                this.composeEnumeration("mode", element.getModeElement(), new Conformance.DocumentModeEnumFactory());
            }
            if (element.hasDocumentationElement()) {
                this.composeString("documentation", element.getDocumentationElement());
            }
            if (element.hasProfile()) {
                this.composeReference("profile", element.getProfile());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContract(String name, Contract element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasIssuedElement()) {
                this.composeDateTime("issued", element.getIssuedElement());
            }
            if (element.hasApplies()) {
                this.composePeriod("applies", element.getApplies());
            }
            if (element.hasSubject()) {
                for (Reference reference : element.getSubject()) {
                    this.composeReference("subject", reference);
                }
            }
            if (element.hasAuthority()) {
                for (Reference reference : element.getAuthority()) {
                    this.composeReference("authority", reference);
                }
            }
            if (element.hasDomain()) {
                for (Reference reference : element.getDomain()) {
                    this.composeReference("domain", reference);
                }
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasSubType()) {
                for (CodeableConcept codeableConcept : element.getSubType()) {
                    this.composeCodeableConcept("subType", codeableConcept);
                }
            }
            if (element.hasAction()) {
                for (CodeableConcept codeableConcept : element.getAction()) {
                    this.composeCodeableConcept("action", codeableConcept);
                }
            }
            if (element.hasActionReason()) {
                for (CodeableConcept codeableConcept : element.getActionReason()) {
                    this.composeCodeableConcept("actionReason", codeableConcept);
                }
            }
            if (element.hasActor()) {
                for (Contract.ActorComponent actorComponent : element.getActor()) {
                    this.composeContractActorComponent("actor", actorComponent);
                }
            }
            if (element.hasValuedItem()) {
                for (Contract.ValuedItemComponent valuedItemComponent : element.getValuedItem()) {
                    this.composeContractValuedItemComponent("valuedItem", valuedItemComponent);
                }
            }
            if (element.hasSigner()) {
                for (Contract.SignatoryComponent signatoryComponent : element.getSigner()) {
                    this.composeContractSignatoryComponent("signer", signatoryComponent);
                }
            }
            if (element.hasTerm()) {
                for (Contract.TermComponent termComponent : element.getTerm()) {
                    this.composeContractTermComponent("term", termComponent);
                }
            }
            if (element.hasBinding()) {
                this.composeType("binding", element.getBinding());
            }
            if (element.hasFriendly()) {
                for (Contract.FriendlyLanguageComponent friendlyLanguageComponent : element.getFriendly()) {
                    this.composeContractFriendlyLanguageComponent("friendly", friendlyLanguageComponent);
                }
            }
            if (element.hasLegal()) {
                for (Contract.LegalLanguageComponent legalLanguageComponent : element.getLegal()) {
                    this.composeContractLegalLanguageComponent("legal", legalLanguageComponent);
                }
            }
            if (element.hasRule()) {
                for (Contract.ComputableLanguageComponent computableLanguageComponent : element.getRule()) {
                    this.composeContractComputableLanguageComponent("rule", computableLanguageComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractActorComponent(String name, Contract.ActorComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasEntity()) {
                this.composeReference("entity", element.getEntity());
            }
            if (element.hasRole()) {
                for (CodeableConcept e : element.getRole()) {
                    this.composeCodeableConcept("role", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractValuedItemComponent(String name, Contract.ValuedItemComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasEntity()) {
                this.composeType("entity", element.getEntity());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasEffectiveTimeElement()) {
                this.composeDateTime("effectiveTime", element.getEffectiveTimeElement());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasUnitPrice()) {
                this.composeMoney("unitPrice", element.getUnitPrice());
            }
            if (element.hasFactorElement()) {
                this.composeDecimal("factor", element.getFactorElement());
            }
            if (element.hasPointsElement()) {
                this.composeDecimal("points", element.getPointsElement());
            }
            if (element.hasNet()) {
                this.composeMoney("net", element.getNet());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractSignatoryComponent(String name, Contract.SignatoryComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasParty()) {
                this.composeReference("party", element.getParty());
            }
            if (element.hasSignatureElement()) {
                this.composeString("signature", element.getSignatureElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractTermComponent(String name, Contract.TermComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasIssuedElement()) {
                this.composeDateTime("issued", element.getIssuedElement());
            }
            if (element.hasApplies()) {
                this.composePeriod("applies", element.getApplies());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasSubType()) {
                this.composeCodeableConcept("subType", element.getSubType());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasAction()) {
                for (CodeableConcept codeableConcept : element.getAction()) {
                    this.composeCodeableConcept("action", codeableConcept);
                }
            }
            if (element.hasActionReason()) {
                for (CodeableConcept codeableConcept : element.getActionReason()) {
                    this.composeCodeableConcept("actionReason", codeableConcept);
                }
            }
            if (element.hasActor()) {
                for (Contract.TermActorComponent termActorComponent : element.getActor()) {
                    this.composeContractTermActorComponent("actor", termActorComponent);
                }
            }
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasValuedItem()) {
                for (Contract.TermValuedItemComponent termValuedItemComponent : element.getValuedItem()) {
                    this.composeContractTermValuedItemComponent("valuedItem", termValuedItemComponent);
                }
            }
            if (element.hasGroup()) {
                for (Contract.TermComponent termComponent : element.getGroup()) {
                    this.composeContractTermComponent("group", termComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractTermActorComponent(String name, Contract.TermActorComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasEntity()) {
                this.composeReference("entity", element.getEntity());
            }
            if (element.hasRole()) {
                for (CodeableConcept e : element.getRole()) {
                    this.composeCodeableConcept("role", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractTermValuedItemComponent(String name, Contract.TermValuedItemComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasEntity()) {
                this.composeType("entity", element.getEntity());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasEffectiveTimeElement()) {
                this.composeDateTime("effectiveTime", element.getEffectiveTimeElement());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasUnitPrice()) {
                this.composeMoney("unitPrice", element.getUnitPrice());
            }
            if (element.hasFactorElement()) {
                this.composeDecimal("factor", element.getFactorElement());
            }
            if (element.hasPointsElement()) {
                this.composeDecimal("points", element.getPointsElement());
            }
            if (element.hasNet()) {
                this.composeMoney("net", element.getNet());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractFriendlyLanguageComponent(String name, Contract.FriendlyLanguageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasContent()) {
                this.composeType("content", element.getContent());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractLegalLanguageComponent(String name, Contract.LegalLanguageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasContent()) {
                this.composeType("content", element.getContent());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeContractComputableLanguageComponent(String name, Contract.ComputableLanguageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasContent()) {
                this.composeType("content", element.getContent());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCoverage(String name, Coverage element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIssuer()) {
                this.composeReference("issuer", element.getIssuer());
            }
            if (element.hasBin()) {
                this.composeIdentifier("bin", element.getBin());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasType()) {
                this.composeCoding("type", element.getType());
            }
            if (element.hasSubscriberId()) {
                this.composeIdentifier("subscriberId", element.getSubscriberId());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasGroupElement()) {
                this.composeString("group", element.getGroupElement());
            }
            if (element.hasPlanElement()) {
                this.composeString("plan", element.getPlanElement());
            }
            if (element.hasSubPlanElement()) {
                this.composeString("subPlan", element.getSubPlanElement());
            }
            if (element.hasDependentElement()) {
                this.composePositiveInt("dependent", element.getDependentElement());
            }
            if (element.hasSequenceElement()) {
                this.composePositiveInt("sequence", element.getSequenceElement());
            }
            if (element.hasSubscriber()) {
                this.composeReference("subscriber", element.getSubscriber());
            }
            if (element.hasNetwork()) {
                this.composeIdentifier("network", element.getNetwork());
            }
            if (element.hasContract()) {
                for (Reference reference : element.getContract()) {
                    this.composeReference("contract", reference);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDataElement(String name, DataElement element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory());
            }
            if (element.hasExperimentalElement()) {
                this.composeBoolean("experimental", element.getExperimentalElement());
            }
            if (element.hasPublisherElement()) {
                this.composeString("publisher", element.getPublisherElement());
            }
            if (element.hasContact()) {
                for (DataElement.DataElementContactComponent dataElementContactComponent : element.getContact()) {
                    this.composeDataElementDataElementContactComponent("contact", dataElementContactComponent);
                }
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasUseContext()) {
                for (CodeableConcept codeableConcept : element.getUseContext()) {
                    this.composeCodeableConcept("useContext", codeableConcept);
                }
            }
            if (element.hasCopyrightElement()) {
                this.composeString("copyright", element.getCopyrightElement());
            }
            if (element.hasStringencyElement()) {
                this.composeEnumeration("stringency", element.getStringencyElement(), new DataElement.DataElementStringencyEnumFactory());
            }
            if (element.hasMapping()) {
                for (DataElement.DataElementMappingComponent dataElementMappingComponent : element.getMapping()) {
                    this.composeDataElementDataElementMappingComponent("mapping", dataElementMappingComponent);
                }
            }
            if (element.hasElement()) {
                for (ElementDefinition elementDefinition : element.getElement()) {
                    this.composeElementDefinition("element", elementDefinition);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDataElementDataElementContactComponent(String name, DataElement.DataElementContactComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasTelecom()) {
                for (ContactPoint e : element.getTelecom()) {
                    this.composeContactPoint("telecom", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDataElementDataElementMappingComponent(String name, DataElement.DataElementMappingComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasIdentityElement()) {
                this.composeId("identity", element.getIdentityElement());
            }
            if (element.hasUriElement()) {
                this.composeUri("uri", element.getUriElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasCommentsElement()) {
                this.composeString("comments", element.getCommentsElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDetectedIssue(String name, DetectedIssue element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasCategory()) {
                this.composeCodeableConcept("category", element.getCategory());
            }
            if (element.hasSeverityElement()) {
                this.composeEnumeration("severity", element.getSeverityElement(), new DetectedIssue.DetectedIssueSeverityEnumFactory());
            }
            if (element.hasImplicated()) {
                for (Reference reference : element.getImplicated()) {
                    this.composeReference("implicated", reference);
                }
            }
            if (element.hasDetailElement()) {
                this.composeString("detail", element.getDetailElement());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasAuthor()) {
                this.composeReference("author", element.getAuthor());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasReferenceElement()) {
                this.composeUri("reference", element.getReferenceElement());
            }
            if (element.hasMitigation()) {
                for (DetectedIssue.DetectedIssueMitigationComponent detectedIssueMitigationComponent : element.getMitigation()) {
                    this.composeDetectedIssueDetectedIssueMitigationComponent("mitigation", detectedIssueMitigationComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDetectedIssueDetectedIssueMitigationComponent(String name, DetectedIssue.DetectedIssueMitigationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasAction()) {
                this.composeCodeableConcept("action", element.getAction());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasAuthor()) {
                this.composeReference("author", element.getAuthor());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDevice(String name, Device element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasNote()) {
                for (Annotation annotation : element.getNote()) {
                    this.composeAnnotation("note", annotation);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Device.DeviceStatusEnumFactory());
            }
            if (element.hasManufacturerElement()) {
                this.composeString("manufacturer", element.getManufacturerElement());
            }
            if (element.hasModelElement()) {
                this.composeString("model", element.getModelElement());
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasManufactureDateElement()) {
                this.composeDateTime("manufactureDate", element.getManufactureDateElement());
            }
            if (element.hasExpiryElement()) {
                this.composeDateTime("expiry", element.getExpiryElement());
            }
            if (element.hasUdiElement()) {
                this.composeString("udi", element.getUdiElement());
            }
            if (element.hasLotNumberElement()) {
                this.composeString("lotNumber", element.getLotNumberElement());
            }
            if (element.hasOwner()) {
                this.composeReference("owner", element.getOwner());
            }
            if (element.hasLocation()) {
                this.composeReference("location", element.getLocation());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasContact()) {
                for (ContactPoint contactPoint : element.getContact()) {
                    this.composeContactPoint("contact", contactPoint);
                }
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDeviceComponent(String name, DeviceComponent element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasLastSystemChangeElement()) {
                this.composeInstant("lastSystemChange", element.getLastSystemChangeElement());
            }
            if (element.hasSource()) {
                this.composeReference("source", element.getSource());
            }
            if (element.hasParent()) {
                this.composeReference("parent", element.getParent());
            }
            if (element.hasOperationalStatus()) {
                for (CodeableConcept codeableConcept : element.getOperationalStatus()) {
                    this.composeCodeableConcept("operationalStatus", codeableConcept);
                }
            }
            if (element.hasParameterGroup()) {
                this.composeCodeableConcept("parameterGroup", element.getParameterGroup());
            }
            if (element.hasMeasurementPrincipleElement()) {
                this.composeEnumeration("measurementPrinciple", element.getMeasurementPrincipleElement(), new DeviceComponent.MeasmntPrincipleEnumFactory());
            }
            if (element.hasProductionSpecification()) {
                for (DeviceComponent.DeviceComponentProductionSpecificationComponent deviceComponentProductionSpecificationComponent : element.getProductionSpecification()) {
                    this.composeDeviceComponentDeviceComponentProductionSpecificationComponent("productionSpecification", deviceComponentProductionSpecificationComponent);
                }
            }
            if (element.hasLanguageCode()) {
                this.composeCodeableConcept("languageCode", element.getLanguageCode());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDeviceComponentDeviceComponentProductionSpecificationComponent(String name, DeviceComponent.DeviceComponentProductionSpecificationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSpecType()) {
                this.composeCodeableConcept("specType", element.getSpecType());
            }
            if (element.hasComponentId()) {
                this.composeIdentifier("componentId", element.getComponentId());
            }
            if (element.hasProductionSpecElement()) {
                this.composeString("productionSpec", element.getProductionSpecElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDeviceMetric(String name, DeviceMetric element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasUnit()) {
                this.composeCodeableConcept("unit", element.getUnit());
            }
            if (element.hasSource()) {
                this.composeReference("source", element.getSource());
            }
            if (element.hasParent()) {
                this.composeReference("parent", element.getParent());
            }
            if (element.hasOperationalStatusElement()) {
                this.composeEnumeration("operationalStatus", element.getOperationalStatusElement(), new DeviceMetric.DeviceMetricOperationalStatusEnumFactory());
            }
            if (element.hasColorElement()) {
                this.composeEnumeration("color", element.getColorElement(), new DeviceMetric.DeviceMetricColorEnumFactory());
            }
            if (element.hasCategoryElement()) {
                this.composeEnumeration("category", element.getCategoryElement(), new DeviceMetric.DeviceMetricCategoryEnumFactory());
            }
            if (element.hasMeasurementPeriod()) {
                this.composeTiming("measurementPeriod", element.getMeasurementPeriod());
            }
            if (element.hasCalibration()) {
                for (DeviceMetric.DeviceMetricCalibrationComponent e : element.getCalibration()) {
                    this.composeDeviceMetricDeviceMetricCalibrationComponent("calibration", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDeviceMetricDeviceMetricCalibrationComponent(String name, DeviceMetric.DeviceMetricCalibrationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory());
            }
            if (element.hasStateElement()) {
                this.composeEnumeration("state", element.getStateElement(), new DeviceMetric.DeviceMetricCalibrationStateEnumFactory());
            }
            if (element.hasTimeElement()) {
                this.composeInstant("time", element.getTimeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDeviceUseRequest(String name, DeviceUseRequest element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasBodySite()) {
                this.composeType("bodySite", element.getBodySite());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new DeviceUseRequest.DeviceUseRequestStatusEnumFactory());
            }
            if (element.hasDevice()) {
                this.composeReference("device", element.getDevice());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasIndication()) {
                for (CodeableConcept codeableConcept : element.getIndication()) {
                    this.composeCodeableConcept("indication", codeableConcept);
                }
            }
            if (element.hasNotes()) {
                for (StringType stringType : element.getNotes()) {
                    this.composeString("notes", stringType);
                }
            }
            if (element.hasPrnReason()) {
                for (CodeableConcept codeableConcept : element.getPrnReason()) {
                    this.composeCodeableConcept("prnReason", codeableConcept);
                }
            }
            if (element.hasOrderedOnElement()) {
                this.composeDateTime("orderedOn", element.getOrderedOnElement());
            }
            if (element.hasRecordedOnElement()) {
                this.composeDateTime("recordedOn", element.getRecordedOnElement());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasTiming()) {
                this.composeType("timing", element.getTiming());
            }
            if (element.hasPriorityElement()) {
                this.composeEnumeration("priority", element.getPriorityElement(), new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDeviceUseStatement(String name, DeviceUseStatement element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasBodySite()) {
                this.composeType("bodySite", element.getBodySite());
            }
            if (element.hasWhenUsed()) {
                this.composePeriod("whenUsed", element.getWhenUsed());
            }
            if (element.hasDevice()) {
                this.composeReference("device", element.getDevice());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasIndication()) {
                for (CodeableConcept codeableConcept : element.getIndication()) {
                    this.composeCodeableConcept("indication", codeableConcept);
                }
            }
            if (element.hasNotes()) {
                for (StringType stringType : element.getNotes()) {
                    this.composeString("notes", stringType);
                }
            }
            if (element.hasRecordedOnElement()) {
                this.composeDateTime("recordedOn", element.getRecordedOnElement());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasTiming()) {
                this.composeType("timing", element.getTiming());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDiagnosticOrder(String name, DiagnosticOrder element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasOrderer()) {
                this.composeReference("orderer", element.getOrderer());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasReason()) {
                for (CodeableConcept codeableConcept : element.getReason()) {
                    this.composeCodeableConcept("reason", codeableConcept);
                }
            }
            if (element.hasSupportingInformation()) {
                for (Reference reference : element.getSupportingInformation()) {
                    this.composeReference("supportingInformation", reference);
                }
            }
            if (element.hasSpecimen()) {
                for (Reference reference : element.getSpecimen()) {
                    this.composeReference("specimen", reference);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory());
            }
            if (element.hasPriorityElement()) {
                this.composeEnumeration("priority", element.getPriorityElement(), new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory());
            }
            if (element.hasEvent()) {
                for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : element.getEvent()) {
                    this.composeDiagnosticOrderDiagnosticOrderEventComponent("event", diagnosticOrderEventComponent);
                }
            }
            if (element.hasItem()) {
                for (DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent : element.getItem()) {
                    this.composeDiagnosticOrderDiagnosticOrderItemComponent("item", diagnosticOrderItemComponent);
                }
            }
            if (element.hasNote()) {
                for (Annotation annotation : element.getNote()) {
                    this.composeAnnotation("note", annotation);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderEventComponent(String name, DiagnosticOrder.DiagnosticOrderEventComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory());
            }
            if (element.hasDescription()) {
                this.composeCodeableConcept("description", element.getDescription());
            }
            if (element.hasDateTimeElement()) {
                this.composeDateTime("dateTime", element.getDateTimeElement());
            }
            if (element.hasActor()) {
                this.composeReference("actor", element.getActor());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderItemComponent(String name, DiagnosticOrder.DiagnosticOrderItemComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasSpecimen()) {
                for (Reference reference : element.getSpecimen()) {
                    this.composeReference("specimen", reference);
                }
            }
            if (element.hasBodySite()) {
                this.composeCodeableConcept("bodySite", element.getBodySite());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory());
            }
            if (element.hasEvent()) {
                for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : element.getEvent()) {
                    this.composeDiagnosticOrderDiagnosticOrderEventComponent("event", diagnosticOrderEventComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDiagnosticReport(String name, DiagnosticReport element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new DiagnosticReport.DiagnosticReportStatusEnumFactory());
            }
            if (element.hasCategory()) {
                this.composeCodeableConcept("category", element.getCategory());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasEffective()) {
                this.composeType("effective", element.getEffective());
            }
            if (element.hasIssuedElement()) {
                this.composeInstant("issued", element.getIssuedElement());
            }
            if (element.hasPerformer()) {
                this.composeReference("performer", element.getPerformer());
            }
            if (element.hasRequest()) {
                for (Reference reference : element.getRequest()) {
                    this.composeReference("request", reference);
                }
            }
            if (element.hasSpecimen()) {
                for (Reference reference : element.getSpecimen()) {
                    this.composeReference("specimen", reference);
                }
            }
            if (element.hasResult()) {
                for (Reference reference : element.getResult()) {
                    this.composeReference("result", reference);
                }
            }
            if (element.hasImagingStudy()) {
                for (Reference reference : element.getImagingStudy()) {
                    this.composeReference("imagingStudy", reference);
                }
            }
            if (element.hasImage()) {
                for (DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent : element.getImage()) {
                    this.composeDiagnosticReportDiagnosticReportImageComponent("image", diagnosticReportImageComponent);
                }
            }
            if (element.hasConclusionElement()) {
                this.composeString("conclusion", element.getConclusionElement());
            }
            if (element.hasCodedDiagnosis()) {
                for (CodeableConcept codeableConcept : element.getCodedDiagnosis()) {
                    this.composeCodeableConcept("codedDiagnosis", codeableConcept);
                }
            }
            if (element.hasPresentedForm()) {
                for (Attachment attachment : element.getPresentedForm()) {
                    this.composeAttachment("presentedForm", attachment);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDiagnosticReportDiagnosticReportImageComponent(String name, DiagnosticReport.DiagnosticReportImageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCommentElement()) {
                this.composeString("comment", element.getCommentElement());
            }
            if (element.hasLink()) {
                this.composeReference("link", element.getLink());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentManifest(String name, DocumentManifest element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasMasterIdentifier()) {
                this.composeIdentifier("masterIdentifier", element.getMasterIdentifier());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasRecipient()) {
                for (Reference reference : element.getRecipient()) {
                    this.composeReference("recipient", reference);
                }
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasAuthor()) {
                for (Reference reference : element.getAuthor()) {
                    this.composeReference("author", reference);
                }
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasSourceElement()) {
                this.composeUri("source", element.getSourceElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Enumerations.DocumentReferenceStatusEnumFactory());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasContent()) {
                for (DocumentManifest.DocumentManifestContentComponent documentManifestContentComponent : element.getContent()) {
                    this.composeDocumentManifestDocumentManifestContentComponent("content", documentManifestContentComponent);
                }
            }
            if (element.hasRelated()) {
                for (DocumentManifest.DocumentManifestRelatedComponent documentManifestRelatedComponent : element.getRelated()) {
                    this.composeDocumentManifestDocumentManifestRelatedComponent("related", documentManifestRelatedComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentManifestDocumentManifestContentComponent(String name, DocumentManifest.DocumentManifestContentComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasP()) {
                this.composeType("p", element.getP());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentManifestDocumentManifestRelatedComponent(String name, DocumentManifest.DocumentManifestRelatedComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasRef()) {
                this.composeReference("ref", element.getRef());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentReference(String name, DocumentReference element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasMasterIdentifier()) {
                this.composeIdentifier("masterIdentifier", element.getMasterIdentifier());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasClass_()) {
                this.composeCodeableConcept("class", element.getClass_());
            }
            if (element.hasAuthor()) {
                for (Reference reference : element.getAuthor()) {
                    this.composeReference("author", reference);
                }
            }
            if (element.hasCustodian()) {
                this.composeReference("custodian", element.getCustodian());
            }
            if (element.hasAuthenticator()) {
                this.composeReference("authenticator", element.getAuthenticator());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasIndexedElement()) {
                this.composeInstant("indexed", element.getIndexedElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Enumerations.DocumentReferenceStatusEnumFactory());
            }
            if (element.hasDocStatus()) {
                this.composeCodeableConcept("docStatus", element.getDocStatus());
            }
            if (element.hasRelatesTo()) {
                for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : element.getRelatesTo()) {
                    this.composeDocumentReferenceDocumentReferenceRelatesToComponent("relatesTo", documentReferenceRelatesToComponent);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasSecurityLabel()) {
                for (CodeableConcept codeableConcept : element.getSecurityLabel()) {
                    this.composeCodeableConcept("securityLabel", codeableConcept);
                }
            }
            if (element.hasContent()) {
                for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : element.getContent()) {
                    this.composeDocumentReferenceDocumentReferenceContentComponent("content", documentReferenceContentComponent);
                }
            }
            if (element.hasContext()) {
                this.composeDocumentReferenceDocumentReferenceContextComponent("context", element.getContext());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceRelatesToComponent(String name, DocumentReference.DocumentReferenceRelatesToComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCodeElement()) {
                this.composeEnumeration("code", element.getCodeElement(), new DocumentReference.DocumentRelationshipTypeEnumFactory());
            }
            if (element.hasTarget()) {
                this.composeReference("target", element.getTarget());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContentComponent(String name, DocumentReference.DocumentReferenceContentComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasAttachment()) {
                this.composeAttachment("attachment", element.getAttachment());
            }
            if (element.hasFormat()) {
                for (Coding e : element.getFormat()) {
                    this.composeCoding("format", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContextComponent(String name, DocumentReference.DocumentReferenceContextComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasEvent()) {
                for (CodeableConcept codeableConcept : element.getEvent()) {
                    this.composeCodeableConcept("event", codeableConcept);
                }
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasFacilityType()) {
                this.composeCodeableConcept("facilityType", element.getFacilityType());
            }
            if (element.hasPracticeSetting()) {
                this.composeCodeableConcept("practiceSetting", element.getPracticeSetting());
            }
            if (element.hasSourcePatientInfo()) {
                this.composeReference("sourcePatientInfo", element.getSourcePatientInfo());
            }
            if (element.hasRelated()) {
                for (DocumentReference.DocumentReferenceContextRelatedComponent documentReferenceContextRelatedComponent : element.getRelated()) {
                    this.composeDocumentReferenceDocumentReferenceContextRelatedComponent("related", documentReferenceContextRelatedComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContextRelatedComponent(String name, DocumentReference.DocumentReferenceContextRelatedComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasRef()) {
                this.composeReference("ref", element.getRef());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEligibilityRequest(String name, EligibilityRequest element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasRuleset()) {
                this.composeCoding("ruleset", element.getRuleset());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasTarget()) {
                this.composeReference("target", element.getTarget());
            }
            if (element.hasProvider()) {
                this.composeReference("provider", element.getProvider());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEligibilityResponse(String name, EligibilityResponse element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasRequest()) {
                this.composeReference("request", element.getRequest());
            }
            if (element.hasOutcomeElement()) {
                this.composeEnumeration("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory());
            }
            if (element.hasDispositionElement()) {
                this.composeString("disposition", element.getDispositionElement());
            }
            if (element.hasRuleset()) {
                this.composeCoding("ruleset", element.getRuleset());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            if (element.hasRequestProvider()) {
                this.composeReference("requestProvider", element.getRequestProvider());
            }
            if (element.hasRequestOrganization()) {
                this.composeReference("requestOrganization", element.getRequestOrganization());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEncounter(String name, Encounter element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Encounter.EncounterStateEnumFactory());
            }
            if (element.hasStatusHistory()) {
                for (Encounter.EncounterStatusHistoryComponent encounterStatusHistoryComponent : element.getStatusHistory()) {
                    this.composeEncounterEncounterStatusHistoryComponent("statusHistory", encounterStatusHistoryComponent);
                }
            }
            if (element.hasClass_Element()) {
                this.composeEnumeration("class", element.getClass_Element(), new Encounter.EncounterClassEnumFactory());
            }
            if (element.hasType()) {
                for (CodeableConcept codeableConcept : element.getType()) {
                    this.composeCodeableConcept("type", codeableConcept);
                }
            }
            if (element.hasPriority()) {
                this.composeCodeableConcept("priority", element.getPriority());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasEpisodeOfCare()) {
                for (Reference reference : element.getEpisodeOfCare()) {
                    this.composeReference("episodeOfCare", reference);
                }
            }
            if (element.hasIncomingReferral()) {
                for (Reference reference : element.getIncomingReferral()) {
                    this.composeReference("incomingReferral", reference);
                }
            }
            if (element.hasParticipant()) {
                for (Encounter.EncounterParticipantComponent encounterParticipantComponent : element.getParticipant()) {
                    this.composeEncounterEncounterParticipantComponent("participant", encounterParticipantComponent);
                }
            }
            if (element.hasAppointment()) {
                this.composeReference("appointment", element.getAppointment());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasLength()) {
                this.composeDuration("length", element.getLength());
            }
            if (element.hasReason()) {
                for (CodeableConcept codeableConcept : element.getReason()) {
                    this.composeCodeableConcept("reason", codeableConcept);
                }
            }
            if (element.hasIndication()) {
                for (Reference reference : element.getIndication()) {
                    this.composeReference("indication", reference);
                }
            }
            if (element.hasHospitalization()) {
                this.composeEncounterEncounterHospitalizationComponent("hospitalization", element.getHospitalization());
            }
            if (element.hasLocation()) {
                for (Encounter.EncounterLocationComponent encounterLocationComponent : element.getLocation()) {
                    this.composeEncounterEncounterLocationComponent("location", encounterLocationComponent);
                }
            }
            if (element.hasServiceProvider()) {
                this.composeReference("serviceProvider", element.getServiceProvider());
            }
            if (element.hasPartOf()) {
                this.composeReference("partOf", element.getPartOf());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEncounterEncounterStatusHistoryComponent(String name, Encounter.EncounterStatusHistoryComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Encounter.EncounterStateEnumFactory());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEncounterEncounterParticipantComponent(String name, Encounter.EncounterParticipantComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                for (CodeableConcept e : element.getType()) {
                    this.composeCodeableConcept("type", e);
                }
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasIndividual()) {
                this.composeReference("individual", element.getIndividual());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEncounterEncounterHospitalizationComponent(String name, Encounter.EncounterHospitalizationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasPreAdmissionIdentifier()) {
                this.composeIdentifier("preAdmissionIdentifier", element.getPreAdmissionIdentifier());
            }
            if (element.hasOrigin()) {
                this.composeReference("origin", element.getOrigin());
            }
            if (element.hasAdmitSource()) {
                this.composeCodeableConcept("admitSource", element.getAdmitSource());
            }
            if (element.hasAdmittingDiagnosis()) {
                for (Reference reference : element.getAdmittingDiagnosis()) {
                    this.composeReference("admittingDiagnosis", reference);
                }
            }
            if (element.hasReAdmission()) {
                this.composeCodeableConcept("reAdmission", element.getReAdmission());
            }
            if (element.hasDietPreference()) {
                for (CodeableConcept codeableConcept : element.getDietPreference()) {
                    this.composeCodeableConcept("dietPreference", codeableConcept);
                }
            }
            if (element.hasSpecialCourtesy()) {
                for (CodeableConcept codeableConcept : element.getSpecialCourtesy()) {
                    this.composeCodeableConcept("specialCourtesy", codeableConcept);
                }
            }
            if (element.hasSpecialArrangement()) {
                for (CodeableConcept codeableConcept : element.getSpecialArrangement()) {
                    this.composeCodeableConcept("specialArrangement", codeableConcept);
                }
            }
            if (element.hasDestination()) {
                this.composeReference("destination", element.getDestination());
            }
            if (element.hasDischargeDisposition()) {
                this.composeCodeableConcept("dischargeDisposition", element.getDischargeDisposition());
            }
            if (element.hasDischargeDiagnosis()) {
                for (Reference reference : element.getDischargeDiagnosis()) {
                    this.composeReference("dischargeDiagnosis", reference);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEncounterEncounterLocationComponent(String name, Encounter.EncounterLocationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasLocation()) {
                this.composeReference("location", element.getLocation());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Encounter.EncounterLocationStatusEnumFactory());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEnrollmentRequest(String name, EnrollmentRequest element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasRuleset()) {
                this.composeCoding("ruleset", element.getRuleset());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasTarget()) {
                this.composeReference("target", element.getTarget());
            }
            if (element.hasProvider()) {
                this.composeReference("provider", element.getProvider());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasCoverage()) {
                this.composeReference("coverage", element.getCoverage());
            }
            if (element.hasRelationship()) {
                this.composeCoding("relationship", element.getRelationship());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEnrollmentResponse(String name, EnrollmentResponse element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasRequest()) {
                this.composeReference("request", element.getRequest());
            }
            if (element.hasOutcomeElement()) {
                this.composeEnumeration("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory());
            }
            if (element.hasDispositionElement()) {
                this.composeString("disposition", element.getDispositionElement());
            }
            if (element.hasRuleset()) {
                this.composeCoding("ruleset", element.getRuleset());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            if (element.hasRequestProvider()) {
                this.composeReference("requestProvider", element.getRequestProvider());
            }
            if (element.hasRequestOrganization()) {
                this.composeReference("requestOrganization", element.getRequestOrganization());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEpisodeOfCare(String name, EpisodeOfCare element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
            }
            if (element.hasStatusHistory()) {
                for (EpisodeOfCare.EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : element.getStatusHistory()) {
                    this.composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent("statusHistory", episodeOfCareStatusHistoryComponent);
                }
            }
            if (element.hasType()) {
                for (CodeableConcept codeableConcept : element.getType()) {
                    this.composeCodeableConcept("type", codeableConcept);
                }
            }
            if (element.hasCondition()) {
                for (Reference reference : element.getCondition()) {
                    this.composeReference("condition", reference);
                }
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasManagingOrganization()) {
                this.composeReference("managingOrganization", element.getManagingOrganization());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasReferralRequest()) {
                for (Reference reference : element.getReferralRequest()) {
                    this.composeReference("referralRequest", reference);
                }
            }
            if (element.hasCareManager()) {
                this.composeReference("careManager", element.getCareManager());
            }
            if (element.hasCareTeam()) {
                for (EpisodeOfCare.EpisodeOfCareCareTeamComponent episodeOfCareCareTeamComponent : element.getCareTeam()) {
                    this.composeEpisodeOfCareEpisodeOfCareCareTeamComponent("careTeam", episodeOfCareCareTeamComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent(String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEpisodeOfCareEpisodeOfCareCareTeamComponent(String name, EpisodeOfCare.EpisodeOfCareCareTeamComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasRole()) {
                for (CodeableConcept e : element.getRole()) {
                    this.composeCodeableConcept("role", e);
                }
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasMember()) {
                this.composeReference("member", element.getMember());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeExplanationOfBenefit(String name, ExplanationOfBenefit element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasRequest()) {
                this.composeReference("request", element.getRequest());
            }
            if (element.hasOutcomeElement()) {
                this.composeEnumeration("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory());
            }
            if (element.hasDispositionElement()) {
                this.composeString("disposition", element.getDispositionElement());
            }
            if (element.hasRuleset()) {
                this.composeCoding("ruleset", element.getRuleset());
            }
            if (element.hasOriginalRuleset()) {
                this.composeCoding("originalRuleset", element.getOriginalRuleset());
            }
            if (element.hasCreatedElement()) {
                this.composeDateTime("created", element.getCreatedElement());
            }
            if (element.hasOrganization()) {
                this.composeReference("organization", element.getOrganization());
            }
            if (element.hasRequestProvider()) {
                this.composeReference("requestProvider", element.getRequestProvider());
            }
            if (element.hasRequestOrganization()) {
                this.composeReference("requestOrganization", element.getRequestOrganization());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeFamilyMemberHistory(String name, FamilyMemberHistory element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new FamilyMemberHistory.FamilyHistoryStatusEnumFactory());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasRelationship()) {
                this.composeCodeableConcept("relationship", element.getRelationship());
            }
            if (element.hasGenderElement()) {
                this.composeEnumeration("gender", element.getGenderElement(), new Enumerations.AdministrativeGenderEnumFactory());
            }
            if (element.hasBorn()) {
                this.composeType("born", element.getBorn());
            }
            if (element.hasAge()) {
                this.composeType("age", element.getAge());
            }
            if (element.hasDeceased()) {
                this.composeType("deceased", element.getDeceased());
            }
            if (element.hasNote()) {
                this.composeAnnotation("note", element.getNote());
            }
            if (element.hasCondition()) {
                for (FamilyMemberHistory.FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : element.getCondition()) {
                    this.composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent("condition", familyMemberHistoryConditionComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent(String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasOutcome()) {
                this.composeCodeableConcept("outcome", element.getOutcome());
            }
            if (element.hasOnset()) {
                this.composeType("onset", element.getOnset());
            }
            if (element.hasNote()) {
                this.composeAnnotation("note", element.getNote());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeFlag(String name, Flag element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasCategory()) {
                this.composeCodeableConcept("category", element.getCategory());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Flag.FlagStatusEnumFactory());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasAuthor()) {
                this.composeReference("author", element.getAuthor());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeGoal(String name, Goal element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasStart()) {
                this.composeType("start", element.getStart());
            }
            if (element.hasTarget()) {
                this.composeType("target", element.getTarget());
            }
            if (element.hasCategory()) {
                for (CodeableConcept codeableConcept : element.getCategory()) {
                    this.composeCodeableConcept("category", codeableConcept);
                }
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Goal.GoalStatusEnumFactory());
            }
            if (element.hasStatusDateElement()) {
                this.composeDate("statusDate", element.getStatusDateElement());
            }
            if (element.hasStatusReason()) {
                this.composeCodeableConcept("statusReason", element.getStatusReason());
            }
            if (element.hasAuthor()) {
                this.composeReference("author", element.getAuthor());
            }
            if (element.hasPriority()) {
                this.composeCodeableConcept("priority", element.getPriority());
            }
            if (element.hasAddresses()) {
                for (Reference reference : element.getAddresses()) {
                    this.composeReference("addresses", reference);
                }
            }
            if (element.hasNote()) {
                for (Annotation annotation : element.getNote()) {
                    this.composeAnnotation("note", annotation);
                }
            }
            if (element.hasOutcome()) {
                for (Goal.GoalOutcomeComponent goalOutcomeComponent : element.getOutcome()) {
                    this.composeGoalGoalOutcomeComponent("outcome", goalOutcomeComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeGoalGoalOutcomeComponent(String name, Goal.GoalOutcomeComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasResult()) {
                this.composeType("result", element.getResult());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeGroup(String name, Group element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Group.GroupTypeEnumFactory());
            }
            if (element.hasActualElement()) {
                this.composeBoolean("actual", element.getActualElement());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasQuantityElement()) {
                this.composeUnsignedInt("quantity", element.getQuantityElement());
            }
            if (element.hasCharacteristic()) {
                for (Group.GroupCharacteristicComponent groupCharacteristicComponent : element.getCharacteristic()) {
                    this.composeGroupGroupCharacteristicComponent("characteristic", groupCharacteristicComponent);
                }
            }
            if (element.hasMember()) {
                for (Group.GroupMemberComponent groupMemberComponent : element.getMember()) {
                    this.composeGroupGroupMemberComponent("member", groupMemberComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeGroupGroupCharacteristicComponent(String name, Group.GroupCharacteristicComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasValue()) {
                this.composeType("value", element.getValue());
            }
            if (element.hasExcludeElement()) {
                this.composeBoolean("exclude", element.getExcludeElement());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeGroupGroupMemberComponent(String name, Group.GroupMemberComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasEntity()) {
                this.composeReference("entity", element.getEntity());
            }
            if (element.hasPeriod()) {
                this.composePeriod("period", element.getPeriod());
            }
            if (element.hasInactiveElement()) {
                this.composeBoolean("inactive", element.getInactiveElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHealthcareService(String name, HealthcareService element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasProvidedBy()) {
                this.composeReference("providedBy", element.getProvidedBy());
            }
            if (element.hasServiceCategory()) {
                this.composeCodeableConcept("serviceCategory", element.getServiceCategory());
            }
            if (element.hasServiceType()) {
                for (HealthcareService.ServiceTypeComponent serviceTypeComponent : element.getServiceType()) {
                    this.composeHealthcareServiceServiceTypeComponent("serviceType", serviceTypeComponent);
                }
            }
            if (element.hasLocation()) {
                this.composeReference("location", element.getLocation());
            }
            if (element.hasServiceNameElement()) {
                this.composeString("serviceName", element.getServiceNameElement());
            }
            if (element.hasCommentElement()) {
                this.composeString("comment", element.getCommentElement());
            }
            if (element.hasExtraDetailsElement()) {
                this.composeString("extraDetails", element.getExtraDetailsElement());
            }
            if (element.hasPhoto()) {
                this.composeAttachment("photo", element.getPhoto());
            }
            if (element.hasTelecom()) {
                for (ContactPoint contactPoint : element.getTelecom()) {
                    this.composeContactPoint("telecom", contactPoint);
                }
            }
            if (element.hasCoverageArea()) {
                for (Reference reference : element.getCoverageArea()) {
                    this.composeReference("coverageArea", reference);
                }
            }
            if (element.hasServiceProvisionCode()) {
                for (CodeableConcept codeableConcept : element.getServiceProvisionCode()) {
                    this.composeCodeableConcept("serviceProvisionCode", codeableConcept);
                }
            }
            if (element.hasEligibility()) {
                this.composeCodeableConcept("eligibility", element.getEligibility());
            }
            if (element.hasEligibilityNoteElement()) {
                this.composeString("eligibilityNote", element.getEligibilityNoteElement());
            }
            if (element.hasProgramName()) {
                for (StringType stringType : element.getProgramName()) {
                    this.composeString("programName", stringType);
                }
            }
            if (element.hasCharacteristic()) {
                for (CodeableConcept codeableConcept : element.getCharacteristic()) {
                    this.composeCodeableConcept("characteristic", codeableConcept);
                }
            }
            if (element.hasReferralMethod()) {
                for (CodeableConcept codeableConcept : element.getReferralMethod()) {
                    this.composeCodeableConcept("referralMethod", codeableConcept);
                }
            }
            if (element.hasPublicKeyElement()) {
                this.composeString("publicKey", element.getPublicKeyElement());
            }
            if (element.hasAppointmentRequiredElement()) {
                this.composeBoolean("appointmentRequired", element.getAppointmentRequiredElement());
            }
            if (element.hasAvailableTime()) {
                for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : element.getAvailableTime()) {
                    this.composeHealthcareServiceHealthcareServiceAvailableTimeComponent("availableTime", healthcareServiceAvailableTimeComponent);
                }
            }
            if (element.hasNotAvailable()) {
                for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : element.getNotAvailable()) {
                    this.composeHealthcareServiceHealthcareServiceNotAvailableComponent("notAvailable", healthcareServiceNotAvailableComponent);
                }
            }
            if (element.hasAvailabilityExceptionsElement()) {
                this.composeString("availabilityExceptions", element.getAvailabilityExceptionsElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHealthcareServiceServiceTypeComponent(String name, HealthcareService.ServiceTypeComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasSpecialty()) {
                for (CodeableConcept e : element.getSpecialty()) {
                    this.composeCodeableConcept("specialty", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceAvailableTimeComponent(String name, HealthcareService.HealthcareServiceAvailableTimeComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasDaysOfWeek()) {
                for (Enumeration<HealthcareService.DaysOfWeek> e : element.getDaysOfWeek()) {
                    this.composeEnumeration("daysOfWeek", e, new HealthcareService.DaysOfWeekEnumFactory());
                }
            }
            if (element.hasAllDayElement()) {
                this.composeBoolean("allDay", element.getAllDayElement());
            }
            if (element.hasAvailableStartTimeElement()) {
                this.composeTime("availableStartTime", element.getAvailableStartTimeElement());
            }
            if (element.hasAvailableEndTimeElement()) {
                this.composeTime("availableEndTime", element.getAvailableEndTimeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceNotAvailableComponent(String name, HealthcareService.HealthcareServiceNotAvailableComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasDuring()) {
                this.composePeriod("during", element.getDuring());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingObjectSelection(String name, ImagingObjectSelection element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasUidElement()) {
                this.composeOid("uid", element.getUidElement());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasTitle()) {
                this.composeCodeableConcept("title", element.getTitle());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasAuthor()) {
                this.composeReference("author", element.getAuthor());
            }
            if (element.hasAuthoringTimeElement()) {
                this.composeDateTime("authoringTime", element.getAuthoringTimeElement());
            }
            if (element.hasStudy()) {
                for (ImagingObjectSelection.StudyComponent e : element.getStudy()) {
                    this.composeImagingObjectSelectionStudyComponent("study", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingObjectSelectionStudyComponent(String name, ImagingObjectSelection.StudyComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasUidElement()) {
                this.composeOid("uid", element.getUidElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasImagingStudy()) {
                this.composeReference("imagingStudy", element.getImagingStudy());
            }
            if (element.hasSeries()) {
                for (ImagingObjectSelection.SeriesComponent e : element.getSeries()) {
                    this.composeImagingObjectSelectionSeriesComponent("series", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingObjectSelectionSeriesComponent(String name, ImagingObjectSelection.SeriesComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasUidElement()) {
                this.composeOid("uid", element.getUidElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasInstance()) {
                for (ImagingObjectSelection.InstanceComponent e : element.getInstance()) {
                    this.composeImagingObjectSelectionInstanceComponent("instance", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingObjectSelectionInstanceComponent(String name, ImagingObjectSelection.InstanceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSopClassElement()) {
                this.composeOid("sopClass", element.getSopClassElement());
            }
            if (element.hasUidElement()) {
                this.composeOid("uid", element.getUidElement());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasFrames()) {
                for (ImagingObjectSelection.FramesComponent e : element.getFrames()) {
                    this.composeImagingObjectSelectionFramesComponent("frames", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingObjectSelectionFramesComponent(String name, ImagingObjectSelection.FramesComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasFrameNumbers()) {
                for (UnsignedIntType e : element.getFrameNumbers()) {
                    this.composeUnsignedInt("frameNumbers", e);
                }
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingStudy(String name, ImagingStudy element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasStartedElement()) {
                this.composeDateTime("started", element.getStartedElement());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasUidElement()) {
                this.composeOid("uid", element.getUidElement());
            }
            if (element.hasAccession()) {
                this.composeIdentifier("accession", element.getAccession());
            }
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasOrder()) {
                for (Reference reference : element.getOrder()) {
                    this.composeReference("order", reference);
                }
            }
            if (element.hasModalityList()) {
                for (Coding coding : element.getModalityList()) {
                    this.composeCoding("modalityList", coding);
                }
            }
            if (element.hasReferrer()) {
                this.composeReference("referrer", element.getReferrer());
            }
            if (element.hasAvailabilityElement()) {
                this.composeEnumeration("availability", element.getAvailabilityElement(), new ImagingStudy.InstanceAvailabilityEnumFactory());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasNumberOfSeriesElement()) {
                this.composeUnsignedInt("numberOfSeries", element.getNumberOfSeriesElement());
            }
            if (element.hasNumberOfInstancesElement()) {
                this.composeUnsignedInt("numberOfInstances", element.getNumberOfInstancesElement());
            }
            if (element.hasProcedure()) {
                for (Reference reference : element.getProcedure()) {
                    this.composeReference("procedure", reference);
                }
            }
            if (element.hasInterpreter()) {
                this.composeReference("interpreter", element.getInterpreter());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasSeries()) {
                for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : element.getSeries()) {
                    this.composeImagingStudyImagingStudySeriesComponent("series", imagingStudySeriesComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingStudyImagingStudySeriesComponent(String name, ImagingStudy.ImagingStudySeriesComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNumberElement()) {
                this.composeUnsignedInt("number", element.getNumberElement());
            }
            if (element.hasModality()) {
                this.composeCoding("modality", element.getModality());
            }
            if (element.hasUidElement()) {
                this.composeOid("uid", element.getUidElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasNumberOfInstancesElement()) {
                this.composeUnsignedInt("numberOfInstances", element.getNumberOfInstancesElement());
            }
            if (element.hasAvailabilityElement()) {
                this.composeEnumeration("availability", element.getAvailabilityElement(), new ImagingStudy.InstanceAvailabilityEnumFactory());
            }
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasBodySite()) {
                this.composeCoding("bodySite", element.getBodySite());
            }
            if (element.hasLaterality()) {
                this.composeCoding("laterality", element.getLaterality());
            }
            if (element.hasStartedElement()) {
                this.composeDateTime("started", element.getStartedElement());
            }
            if (element.hasInstance()) {
                for (ImagingStudy.ImagingStudySeriesInstanceComponent e : element.getInstance()) {
                    this.composeImagingStudyImagingStudySeriesInstanceComponent("instance", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImagingStudyImagingStudySeriesInstanceComponent(String name, ImagingStudy.ImagingStudySeriesInstanceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNumberElement()) {
                this.composeUnsignedInt("number", element.getNumberElement());
            }
            if (element.hasUidElement()) {
                this.composeOid("uid", element.getUidElement());
            }
            if (element.hasSopClassElement()) {
                this.composeOid("sopClass", element.getSopClassElement());
            }
            if (element.hasTypeElement()) {
                this.composeString("type", element.getTypeElement());
            }
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasContent()) {
                for (Attachment e : element.getContent()) {
                    this.composeAttachment("content", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunization(String name, Immunization element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeCode("status", element.getStatusElement());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasVaccineCode()) {
                this.composeCodeableConcept("vaccineCode", element.getVaccineCode());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasWasNotGivenElement()) {
                this.composeBoolean("wasNotGiven", element.getWasNotGivenElement());
            }
            if (element.hasReportedElement()) {
                this.composeBoolean("reported", element.getReportedElement());
            }
            if (element.hasPerformer()) {
                this.composeReference("performer", element.getPerformer());
            }
            if (element.hasRequester()) {
                this.composeReference("requester", element.getRequester());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasManufacturer()) {
                this.composeReference("manufacturer", element.getManufacturer());
            }
            if (element.hasLocation()) {
                this.composeReference("location", element.getLocation());
            }
            if (element.hasLotNumberElement()) {
                this.composeString("lotNumber", element.getLotNumberElement());
            }
            if (element.hasExpirationDateElement()) {
                this.composeDate("expirationDate", element.getExpirationDateElement());
            }
            if (element.hasSite()) {
                this.composeCodeableConcept("site", element.getSite());
            }
            if (element.hasRoute()) {
                this.composeCodeableConcept("route", element.getRoute());
            }
            if (element.hasDoseQuantity()) {
                this.composeSimpleQuantity("doseQuantity", element.getDoseQuantity());
            }
            if (element.hasNote()) {
                for (Annotation annotation : element.getNote()) {
                    this.composeAnnotation("note", annotation);
                }
            }
            if (element.hasExplanation()) {
                this.composeImmunizationImmunizationExplanationComponent("explanation", element.getExplanation());
            }
            if (element.hasReaction()) {
                for (Immunization.ImmunizationReactionComponent immunizationReactionComponent : element.getReaction()) {
                    this.composeImmunizationImmunizationReactionComponent("reaction", immunizationReactionComponent);
                }
            }
            if (element.hasVaccinationProtocol()) {
                for (Immunization.ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent : element.getVaccinationProtocol()) {
                    this.composeImmunizationImmunizationVaccinationProtocolComponent("vaccinationProtocol", immunizationVaccinationProtocolComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunizationImmunizationExplanationComponent(String name, Immunization.ImmunizationExplanationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasReason()) {
                for (CodeableConcept e : element.getReason()) {
                    this.composeCodeableConcept("reason", e);
                }
            }
            if (element.hasReasonNotGiven()) {
                for (CodeableConcept e : element.getReasonNotGiven()) {
                    this.composeCodeableConcept("reasonNotGiven", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunizationImmunizationReactionComponent(String name, Immunization.ImmunizationReactionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasDetail()) {
                this.composeReference("detail", element.getDetail());
            }
            if (element.hasReportedElement()) {
                this.composeBoolean("reported", element.getReportedElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunizationImmunizationVaccinationProtocolComponent(String name, Immunization.ImmunizationVaccinationProtocolComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasDoseSequenceElement()) {
                this.composePositiveInt("doseSequence", element.getDoseSequenceElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasAuthority()) {
                this.composeReference("authority", element.getAuthority());
            }
            if (element.hasSeriesElement()) {
                this.composeString("series", element.getSeriesElement());
            }
            if (element.hasSeriesDosesElement()) {
                this.composePositiveInt("seriesDoses", element.getSeriesDosesElement());
            }
            if (element.hasTargetDisease()) {
                for (CodeableConcept e : element.getTargetDisease()) {
                    this.composeCodeableConcept("targetDisease", e);
                }
            }
            if (element.hasDoseStatus()) {
                this.composeCodeableConcept("doseStatus", element.getDoseStatus());
            }
            if (element.hasDoseStatusReason()) {
                this.composeCodeableConcept("doseStatusReason", element.getDoseStatusReason());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunizationRecommendation(String name, ImmunizationRecommendation element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasRecommendation()) {
                for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : element.getRecommendation()) {
                    this.composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent("recommendation", immunizationRecommendationRecommendationComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasVaccineCode()) {
                this.composeCodeableConcept("vaccineCode", element.getVaccineCode());
            }
            if (element.hasDoseNumberElement()) {
                this.composePositiveInt("doseNumber", element.getDoseNumberElement());
            }
            if (element.hasForecastStatus()) {
                this.composeCodeableConcept("forecastStatus", element.getForecastStatus());
            }
            if (element.hasDateCriterion()) {
                for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent : element.getDateCriterion()) {
                    this.composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent("dateCriterion", immunizationRecommendationRecommendationDateCriterionComponent);
                }
            }
            if (element.hasProtocol()) {
                this.composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent("protocol", element.getProtocol());
            }
            if (element.hasSupportingImmunization()) {
                for (Reference reference : element.getSupportingImmunization()) {
                    this.composeReference("supportingImmunization", reference);
                }
            }
            if (element.hasSupportingPatientInformation()) {
                for (Reference reference : element.getSupportingPatientInformation()) {
                    this.composeReference("supportingPatientInformation", reference);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasValueElement()) {
                this.composeDateTime("value", element.getValueElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasDoseSequenceElement()) {
                this.composeInteger("doseSequence", element.getDoseSequenceElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasAuthority()) {
                this.composeReference("authority", element.getAuthority());
            }
            if (element.hasSeriesElement()) {
                this.composeString("series", element.getSeriesElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImplementationGuide(String name, ImplementationGuide element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasUrlElement()) {
                this.composeUri("url", element.getUrlElement());
            }
            if (element.hasVersionElement()) {
                this.composeString("version", element.getVersionElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory());
            }
            if (element.hasExperimentalElement()) {
                this.composeBoolean("experimental", element.getExperimentalElement());
            }
            if (element.hasPublisherElement()) {
                this.composeString("publisher", element.getPublisherElement());
            }
            if (element.hasContact()) {
                for (ImplementationGuide.ImplementationGuideContactComponent implementationGuideContactComponent : element.getContact()) {
                    this.composeImplementationGuideImplementationGuideContactComponent("contact", implementationGuideContactComponent);
                }
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasUseContext()) {
                for (CodeableConcept codeableConcept : element.getUseContext()) {
                    this.composeCodeableConcept("useContext", codeableConcept);
                }
            }
            if (element.hasCopyrightElement()) {
                this.composeString("copyright", element.getCopyrightElement());
            }
            if (element.hasFhirVersionElement()) {
                this.composeId("fhirVersion", element.getFhirVersionElement());
            }
            if (element.hasDependency()) {
                for (ImplementationGuide.ImplementationGuideDependencyComponent implementationGuideDependencyComponent : element.getDependency()) {
                    this.composeImplementationGuideImplementationGuideDependencyComponent("dependency", implementationGuideDependencyComponent);
                }
            }
            if (element.hasPackage()) {
                for (ImplementationGuide.ImplementationGuidePackageComponent implementationGuidePackageComponent : element.getPackage()) {
                    this.composeImplementationGuideImplementationGuidePackageComponent("package", implementationGuidePackageComponent);
                }
            }
            if (element.hasGlobal()) {
                for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : element.getGlobal()) {
                    this.composeImplementationGuideImplementationGuideGlobalComponent("global", implementationGuideGlobalComponent);
                }
            }
            if (element.hasBinary()) {
                for (UriType uriType : element.getBinary()) {
                    this.composeUri("binary", uriType);
                }
            }
            if (element.hasPage()) {
                this.composeImplementationGuideImplementationGuidePageComponent("page", element.getPage());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImplementationGuideImplementationGuideContactComponent(String name, ImplementationGuide.ImplementationGuideContactComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasTelecom()) {
                for (ContactPoint e : element.getTelecom()) {
                    this.composeContactPoint("telecom", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImplementationGuideImplementationGuideDependencyComponent(String name, ImplementationGuide.ImplementationGuideDependencyComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new ImplementationGuide.GuideDependencyTypeEnumFactory());
            }
            if (element.hasUriElement()) {
                this.composeUri("uri", element.getUriElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImplementationGuideImplementationGuidePackageComponent(String name, ImplementationGuide.ImplementationGuidePackageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasResource()) {
                for (ImplementationGuide.ImplementationGuidePackageResourceComponent e : element.getResource()) {
                    this.composeImplementationGuideImplementationGuidePackageResourceComponent("resource", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImplementationGuideImplementationGuidePackageResourceComponent(String name, ImplementationGuide.ImplementationGuidePackageResourceComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasPurposeElement()) {
                this.composeEnumeration("purpose", element.getPurposeElement(), new ImplementationGuide.GuideResourcePurposeEnumFactory());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasAcronymElement()) {
                this.composeString("acronym", element.getAcronymElement());
            }
            if (element.hasSource()) {
                this.composeType("source", element.getSource());
            }
            if (element.hasExampleFor()) {
                this.composeReference("exampleFor", element.getExampleFor());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImplementationGuideImplementationGuideGlobalComponent(String name, ImplementationGuide.ImplementationGuideGlobalComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTypeElement()) {
                this.composeCode("type", element.getTypeElement());
            }
            if (element.hasProfile()) {
                this.composeReference("profile", element.getProfile());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeImplementationGuideImplementationGuidePageComponent(String name, ImplementationGuide.ImplementationGuidePageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasSourceElement()) {
                this.composeUri("source", element.getSourceElement());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasKindElement()) {
                this.composeEnumeration("kind", element.getKindElement(), new ImplementationGuide.GuidePageKindEnumFactory());
            }
            if (element.hasType()) {
                for (CodeType codeType : element.getType()) {
                    this.composeCode("type", codeType);
                }
            }
            if (element.hasPackage()) {
                for (StringType stringType : element.getPackage()) {
                    this.composeString("package", stringType);
                }
            }
            if (element.hasFormatElement()) {
                this.composeCode("format", element.getFormatElement());
            }
            if (element.hasPage()) {
                for (ImplementationGuide.ImplementationGuidePageComponent implementationGuidePageComponent : element.getPage()) {
                    this.composeImplementationGuideImplementationGuidePageComponent("page", implementationGuidePageComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeList_(String name, List_ element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasTitleElement()) {
                this.composeString("title", element.getTitleElement());
            }
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasSource()) {
                this.composeReference("source", element.getSource());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new List_.ListStatusEnumFactory());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasOrderedBy()) {
                this.composeCodeableConcept("orderedBy", element.getOrderedBy());
            }
            if (element.hasModeElement()) {
                this.composeEnumeration("mode", element.getModeElement(), new List_.ListModeEnumFactory());
            }
            if (element.hasNoteElement()) {
                this.composeString("note", element.getNoteElement());
            }
            if (element.hasEntry()) {
                for (List_.ListEntryComponent listEntryComponent : element.getEntry()) {
                    this.composeList_ListEntryComponent("entry", listEntryComponent);
                }
            }
            if (element.hasEmptyReason()) {
                this.composeCodeableConcept("emptyReason", element.getEmptyReason());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeList_ListEntryComponent(String name, List_.ListEntryComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasFlag()) {
                this.composeCodeableConcept("flag", element.getFlag());
            }
            if (element.hasDeletedElement()) {
                this.composeBoolean("deleted", element.getDeletedElement());
            }
            if (element.hasDateElement()) {
                this.composeDateTime("date", element.getDateElement());
            }
            if (element.hasItem()) {
                this.composeReference("item", element.getItem());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeLocation(String name, Location element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new Location.LocationStatusEnumFactory());
            }
            if (element.hasNameElement()) {
                this.composeString("name", element.getNameElement());
            }
            if (element.hasDescriptionElement()) {
                this.composeString("description", element.getDescriptionElement());
            }
            if (element.hasModeElement()) {
                this.composeEnumeration("mode", element.getModeElement(), new Location.LocationModeEnumFactory());
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasTelecom()) {
                for (ContactPoint contactPoint : element.getTelecom()) {
                    this.composeContactPoint("telecom", contactPoint);
                }
            }
            if (element.hasAddress()) {
                this.composeAddress("address", element.getAddress());
            }
            if (element.hasPhysicalType()) {
                this.composeCodeableConcept("physicalType", element.getPhysicalType());
            }
            if (element.hasPosition()) {
                this.composeLocationLocationPositionComponent("position", element.getPosition());
            }
            if (element.hasManagingOrganization()) {
                this.composeReference("managingOrganization", element.getManagingOrganization());
            }
            if (element.hasPartOf()) {
                this.composeReference("partOf", element.getPartOf());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeLocationLocationPositionComponent(String name, Location.LocationPositionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasLongitudeElement()) {
                this.composeDecimal("longitude", element.getLongitudeElement());
            }
            if (element.hasLatitudeElement()) {
                this.composeDecimal("latitude", element.getLatitudeElement());
            }
            if (element.hasAltitudeElement()) {
                this.composeDecimal("altitude", element.getAltitudeElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedia(String name, Media element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasTypeElement()) {
                this.composeEnumeration("type", element.getTypeElement(), new Media.DigitalMediaTypeEnumFactory());
            }
            if (element.hasSubtype()) {
                this.composeCodeableConcept("subtype", element.getSubtype());
            }
            if (element.hasIdentifier()) {
                for (Identifier e : element.getIdentifier()) {
                    this.composeIdentifier("identifier", e);
                }
            }
            if (element.hasSubject()) {
                this.composeReference("subject", element.getSubject());
            }
            if (element.hasOperator()) {
                this.composeReference("operator", element.getOperator());
            }
            if (element.hasView()) {
                this.composeCodeableConcept("view", element.getView());
            }
            if (element.hasDeviceNameElement()) {
                this.composeString("deviceName", element.getDeviceNameElement());
            }
            if (element.hasHeightElement()) {
                this.composePositiveInt("height", element.getHeightElement());
            }
            if (element.hasWidthElement()) {
                this.composePositiveInt("width", element.getWidthElement());
            }
            if (element.hasFramesElement()) {
                this.composePositiveInt("frames", element.getFramesElement());
            }
            if (element.hasDurationElement()) {
                this.composeUnsignedInt("duration", element.getDurationElement());
            }
            if (element.hasContent()) {
                this.composeAttachment("content", element.getContent());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedication(String name, Medication element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasCode()) {
                this.composeCodeableConcept("code", element.getCode());
            }
            if (element.hasIsBrandElement()) {
                this.composeBoolean("isBrand", element.getIsBrandElement());
            }
            if (element.hasManufacturer()) {
                this.composeReference("manufacturer", element.getManufacturer());
            }
            if (element.hasProduct()) {
                this.composeMedicationMedicationProductComponent("product", element.getProduct());
            }
            if (element.hasPackage()) {
                this.composeMedicationMedicationPackageComponent("package", element.getPackage());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationMedicationProductComponent(String name, Medication.MedicationProductComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasForm()) {
                this.composeCodeableConcept("form", element.getForm());
            }
            if (element.hasIngredient()) {
                for (Medication.MedicationProductIngredientComponent medicationProductIngredientComponent : element.getIngredient()) {
                    this.composeMedicationMedicationProductIngredientComponent("ingredient", medicationProductIngredientComponent);
                }
            }
            if (element.hasBatch()) {
                for (Medication.MedicationProductBatchComponent medicationProductBatchComponent : element.getBatch()) {
                    this.composeMedicationMedicationProductBatchComponent("batch", medicationProductBatchComponent);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationMedicationProductIngredientComponent(String name, Medication.MedicationProductIngredientComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasItem()) {
                this.composeReference("item", element.getItem());
            }
            if (element.hasAmount()) {
                this.composeRatio("amount", element.getAmount());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationMedicationProductBatchComponent(String name, Medication.MedicationProductBatchComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasLotNumberElement()) {
                this.composeString("lotNumber", element.getLotNumberElement());
            }
            if (element.hasExpirationDateElement()) {
                this.composeDateTime("expirationDate", element.getExpirationDateElement());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationMedicationPackageComponent(String name, Medication.MedicationPackageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasContainer()) {
                this.composeCodeableConcept("container", element.getContainer());
            }
            if (element.hasContent()) {
                for (Medication.MedicationPackageContentComponent e : element.getContent()) {
                    this.composeMedicationMedicationPackageContentComponent("content", e);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationMedicationPackageContentComponent(String name, Medication.MedicationPackageContentComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasItem()) {
                this.composeReference("item", element.getItem());
            }
            if (element.hasAmount()) {
                this.composeSimpleQuantity("amount", element.getAmount());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationAdministration(String name, MedicationAdministration element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new MedicationAdministration.MedicationAdministrationStatusEnumFactory());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasPractitioner()) {
                this.composeReference("practitioner", element.getPractitioner());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasPrescription()) {
                this.composeReference("prescription", element.getPrescription());
            }
            if (element.hasWasNotGivenElement()) {
                this.composeBoolean("wasNotGiven", element.getWasNotGivenElement());
            }
            if (element.hasReasonNotGiven()) {
                for (CodeableConcept codeableConcept : element.getReasonNotGiven()) {
                    this.composeCodeableConcept("reasonNotGiven", codeableConcept);
                }
            }
            if (element.hasReasonGiven()) {
                for (CodeableConcept codeableConcept : element.getReasonGiven()) {
                    this.composeCodeableConcept("reasonGiven", codeableConcept);
                }
            }
            if (element.hasEffectiveTime()) {
                this.composeType("effectiveTime", element.getEffectiveTime());
            }
            if (element.hasMedication()) {
                this.composeType("medication", element.getMedication());
            }
            if (element.hasDevice()) {
                for (Reference reference : element.getDevice()) {
                    this.composeReference("device", reference);
                }
            }
            if (element.hasNoteElement()) {
                this.composeString("note", element.getNoteElement());
            }
            if (element.hasDosage()) {
                this.composeMedicationAdministrationMedicationAdministrationDosageComponent("dosage", element.getDosage());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationAdministrationMedicationAdministrationDosageComponent(String name, MedicationAdministration.MedicationAdministrationDosageComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasSite()) {
                this.composeType("site", element.getSite());
            }
            if (element.hasRoute()) {
                this.composeCodeableConcept("route", element.getRoute());
            }
            if (element.hasMethod()) {
                this.composeCodeableConcept("method", element.getMethod());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasRate()) {
                this.composeType("rate", element.getRate());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationDispense(String name, MedicationDispense element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                this.composeIdentifier("identifier", element.getIdentifier());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new MedicationDispense.MedicationDispenseStatusEnumFactory());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasDispenser()) {
                this.composeReference("dispenser", element.getDispenser());
            }
            if (element.hasAuthorizingPrescription()) {
                for (Reference reference : element.getAuthorizingPrescription()) {
                    this.composeReference("authorizingPrescription", reference);
                }
            }
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasDaysSupply()) {
                this.composeSimpleQuantity("daysSupply", element.getDaysSupply());
            }
            if (element.hasMedication()) {
                this.composeType("medication", element.getMedication());
            }
            if (element.hasWhenPreparedElement()) {
                this.composeDateTime("whenPrepared", element.getWhenPreparedElement());
            }
            if (element.hasWhenHandedOverElement()) {
                this.composeDateTime("whenHandedOver", element.getWhenHandedOverElement());
            }
            if (element.hasDestination()) {
                this.composeReference("destination", element.getDestination());
            }
            if (element.hasReceiver()) {
                for (Reference reference : element.getReceiver()) {
                    this.composeReference("receiver", reference);
                }
            }
            if (element.hasNoteElement()) {
                this.composeString("note", element.getNoteElement());
            }
            if (element.hasDosageInstruction()) {
                for (MedicationDispense.MedicationDispenseDosageInstructionComponent medicationDispenseDosageInstructionComponent : element.getDosageInstruction()) {
                    this.composeMedicationDispenseMedicationDispenseDosageInstructionComponent("dosageInstruction", medicationDispenseDosageInstructionComponent);
                }
            }
            if (element.hasSubstitution()) {
                this.composeMedicationDispenseMedicationDispenseSubstitutionComponent("substitution", element.getSubstitution());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationDispenseMedicationDispenseDosageInstructionComponent(String name, MedicationDispense.MedicationDispenseDosageInstructionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasAdditionalInstructions()) {
                this.composeCodeableConcept("additionalInstructions", element.getAdditionalInstructions());
            }
            if (element.hasTiming()) {
                this.composeTiming("timing", element.getTiming());
            }
            if (element.hasAsNeeded()) {
                this.composeType("asNeeded", element.getAsNeeded());
            }
            if (element.hasSite()) {
                this.composeType("site", element.getSite());
            }
            if (element.hasRoute()) {
                this.composeCodeableConcept("route", element.getRoute());
            }
            if (element.hasMethod()) {
                this.composeCodeableConcept("method", element.getMethod());
            }
            if (element.hasDose()) {
                this.composeType("dose", element.getDose());
            }
            if (element.hasRate()) {
                this.composeType("rate", element.getRate());
            }
            if (element.hasMaxDosePerPeriod()) {
                this.composeRatio("maxDosePerPeriod", element.getMaxDosePerPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationDispenseMedicationDispenseSubstitutionComponent(String name, MedicationDispense.MedicationDispenseSubstitutionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasReason()) {
                for (CodeableConcept codeableConcept : element.getReason()) {
                    this.composeCodeableConcept("reason", codeableConcept);
                }
            }
            if (element.hasResponsibleParty()) {
                for (Reference reference : element.getResponsibleParty()) {
                    this.composeReference("responsibleParty", reference);
                }
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationOrder(String name, MedicationOrder element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasDateWrittenElement()) {
                this.composeDateTime("dateWritten", element.getDateWrittenElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new MedicationOrder.MedicationOrderStatusEnumFactory());
            }
            if (element.hasDateEndedElement()) {
                this.composeDateTime("dateEnded", element.getDateEndedElement());
            }
            if (element.hasReasonEnded()) {
                this.composeCodeableConcept("reasonEnded", element.getReasonEnded());
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasPrescriber()) {
                this.composeReference("prescriber", element.getPrescriber());
            }
            if (element.hasEncounter()) {
                this.composeReference("encounter", element.getEncounter());
            }
            if (element.hasReason()) {
                this.composeType("reason", element.getReason());
            }
            if (element.hasNoteElement()) {
                this.composeString("note", element.getNoteElement());
            }
            if (element.hasMedication()) {
                this.composeType("medication", element.getMedication());
            }
            if (element.hasDosageInstruction()) {
                for (MedicationOrder.MedicationOrderDosageInstructionComponent medicationOrderDosageInstructionComponent : element.getDosageInstruction()) {
                    this.composeMedicationOrderMedicationOrderDosageInstructionComponent("dosageInstruction", medicationOrderDosageInstructionComponent);
                }
            }
            if (element.hasDispenseRequest()) {
                this.composeMedicationOrderMedicationOrderDispenseRequestComponent("dispenseRequest", element.getDispenseRequest());
            }
            if (element.hasSubstitution()) {
                this.composeMedicationOrderMedicationOrderSubstitutionComponent("substitution", element.getSubstitution());
            }
            if (element.hasPriorPrescription()) {
                this.composeReference("priorPrescription", element.getPriorPrescription());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationOrderMedicationOrderDosageInstructionComponent(String name, MedicationOrder.MedicationOrderDosageInstructionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasTextElement()) {
                this.composeString("text", element.getTextElement());
            }
            if (element.hasAdditionalInstructions()) {
                this.composeCodeableConcept("additionalInstructions", element.getAdditionalInstructions());
            }
            if (element.hasTiming()) {
                this.composeTiming("timing", element.getTiming());
            }
            if (element.hasAsNeeded()) {
                this.composeType("asNeeded", element.getAsNeeded());
            }
            if (element.hasSite()) {
                this.composeType("site", element.getSite());
            }
            if (element.hasRoute()) {
                this.composeCodeableConcept("route", element.getRoute());
            }
            if (element.hasMethod()) {
                this.composeCodeableConcept("method", element.getMethod());
            }
            if (element.hasDose()) {
                this.composeType("dose", element.getDose());
            }
            if (element.hasRate()) {
                this.composeType("rate", element.getRate());
            }
            if (element.hasMaxDosePerPeriod()) {
                this.composeRatio("maxDosePerPeriod", element.getMaxDosePerPeriod());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationOrderMedicationOrderDispenseRequestComponent(String name, MedicationOrder.MedicationOrderDispenseRequestComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasMedication()) {
                this.composeType("medication", element.getMedication());
            }
            if (element.hasValidityPeriod()) {
                this.composePeriod("validityPeriod", element.getValidityPeriod());
            }
            if (element.hasNumberOfRepeatsAllowedElement()) {
                this.composePositiveInt("numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement());
            }
            if (element.hasQuantity()) {
                this.composeSimpleQuantity("quantity", element.getQuantity());
            }
            if (element.hasExpectedSupplyDuration()) {
                this.composeDuration("expectedSupplyDuration", element.getExpectedSupplyDuration());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationOrderMedicationOrderSubstitutionComponent(String name, MedicationOrder.MedicationOrderSubstitutionComponent element) throws IOException {
        if (element != null) {
            this.composeElementAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeBackboneElements(element);
            if (element.hasType()) {
                this.composeCodeableConcept("type", element.getType());
            }
            if (element.hasReason()) {
                this.composeCodeableConcept("reason", element.getReason());
            }
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeMedicationStatement(String name, MedicationStatement element) throws IOException {
        if (element != null) {
            this.composeDomainResourceAttributes(element);
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDomainResourceElements(element);
            if (element.hasIdentifier()) {
                for (Identifier identifier : element.getIdentifier()) {
                    this.composeIdentifier("identifier", identifier);
                }
            }
            if (element.hasPatient()) {
                this.composeReference("patient", element.getPatient());
            }
            if (element.hasInformationSource()) {
                this.composeReference("informationSource", element.getInformationSource());
            }
            if (element.hasDateAssertedElement()) {
                this.composeDateTime("dateAsserted", element.getDateAssertedElement());
            }
            if (element.hasStatusElement()) {
                this.composeEnumeration("status", element.getStatusElement(), new MedicationStatement.MedicationStatementStatusEnumFactory());
            }
            if (element.hasWasNotTakenElement()) {
                this.composeBoolean("wasNotTaken", element.getWasNotTakenElement());
            }
            if (element.hasReasonNotTaken()) {
                for (CodeableConcept codeableConcept : element.getReasonNotTaken()) {
                    this.composeCodeableConcept("reasonNotTaken", codeableConcept);
                }
            }
            i