/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.fhir.ucum.UcumEssenceService;
import org.hl7.fhir.convertors.misc.CCDAConverter;
import org.hl7.fhir.dstu3.context.SimpleWorkerContext;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.utilities.Utilities;

public class Test {
    public static final String DEF_TS_SERVER = "http://fhir-dev.healthintersections.com.au/open";
    public static final String DEV_TS_SERVER = "http://local.fhir.org:960/open";
    public static final String DEF_PATH = "c:\\work\\org.hl7.fhir\\build\\implementations\\java\\org.hl7.fhir.convertors\\samples\\";
    public static final String UCUM_PATH = "c:\\work\\org.hl7.fhir\\build\\implementations\\java\\org.hl7.fhir.convertors\\samples\\ucum-essence.xml";
    public static final String SRC_PATH = "c:\\work\\org.hl7.fhir\\build\\publish\\";

    public static void main(String[] args) {
        try {
            CCDAConverter c = new CCDAConverter(new UcumEssenceService(UCUM_PATH), SimpleWorkerContext.fromPack(Utilities.path(SRC_PATH, "validation.zip")));
            Bundle a = c.convert(new FileInputStream("c:\\work\\org.hl7.fhir\\build\\implementations\\java\\org.hl7.fhir.convertors\\samples\\ccda.xml"));
            String fx = "c:\\work\\org.hl7.fhir\\build\\implementations\\java\\org.hl7.fhir.convertors\\samples\\output.xml";
            IParser x = new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY);
            x.compose(new FileOutputStream(fx), a);
            String fj = "c:\\work\\org.hl7.fhir\\build\\implementations\\java\\org.hl7.fhir.convertors\\samples\\output.json";
            IParser j = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY);
            j.compose(new FileOutputStream(fj), a);
            System.out.println("done. save as " + fx + " and " + fj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

