/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.Utilities;

public class SearchParameterProcessor {
    private static final String ROOT = "C:\\work\\org.hl7.fhir\\org.fhir.interversion\\package";
    private List<SPRelationship> list = new ArrayList<SPRelationship>();
    private List<String> list4 = new ArrayList<String>();
    private List<String> list3 = new ArrayList<String>();
    private List<String> list2 = new ArrayList<String>();
    private List<String> list2b = new ArrayList<String>();

    private void load() throws FileNotFoundException, IOException, FHIRException {
        this.load4();
        this.load3();
        this.load2b();
        this.load2();
        this.loadCsv();
        this.check4();
        this.check3();
        this.check2b();
        this.check2();
        this.generate("R3", "R4", "STU3", "R4");
        this.generate("R4", "R3", "R4", "STU3");
        this.generate("R2", "R4", "DSTU2", "R4");
        this.generate("R4", "R2", "R4", "DSTU2");
        this.generate("R2", "R3", "DSTU2", "STU3");
        this.generate("R3", "R2", "STU3", "DSTU2");
    }

    private void generate(String src, String dst, String srcURL, String tgtURL) throws FileNotFoundException, IOException {
        ConceptMap map = new ConceptMap();
        map.setId("search-parameters-" + src + "-to-" + dst);
        map.setUrl("http://hl7.org/fhir/interversion/ConceptMap/" + map.getId());
        map.setName("SearchParameterMap" + src + dst);
        map.setTitle("Search Parameter Map - " + src + " to " + dst);
        map.setStatus(Enumerations.PublicationStatus.DRAFT);
        map.setDate(new Date());
        map.setExperimental(false);
        map.setPublisher("HL7");
        ConceptMap.ConceptMapGroupComponent group = map.addGroup();
        group.setSource("http://hl7.org/fhir/" + srcURL);
        group.setTarget("http://hl7.org/fhir/" + tgtURL);
        for (SPRelationship sp : this.list) {
            String s2 = sp.getByCode(src);
            String d = sp.getByCode(dst);
            if (Utilities.noString(s2) || Utilities.noString(d)) continue;
            ConceptMap.SourceElementComponent e = this.makeElement(s2, group);
            e.addTarget().setCode(d).setRelationship(Enumerations.ConceptMapRelationship.RELATEDTO);
        }
        new org.hl7.fhir.r5.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(ROOT, "ConceptMap-" + map.getId() + ".json")), map);
    }

    private ConceptMap.SourceElementComponent makeElement(String code, ConceptMap.ConceptMapGroupComponent group) {
        for (ConceptMap.SourceElementComponent e : group.getElement()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return group.addElement().setCode(code);
    }

    private void check4() {
        boolean ok;
        for (String s2 : this.list4) {
            ok = false;
            for (SPRelationship t : this.list) {
                if (!s2.equals(t.r4)) continue;
                ok = true;
            }
            if (ok) continue;
            System.out.println("R4 missing : " + s2);
        }
        for (SPRelationship sp : this.list) {
            if (Utilities.noString(sp.r4) || (ok = this.list4.contains(sp.r4))) continue;
            System.out.println("R4 extra : " + sp.r4);
        }
    }

    private void check3() {
        boolean ok;
        for (String s2 : this.list3) {
            ok = false;
            for (SPRelationship t : this.list) {
                if (!s2.equals(t.r3)) continue;
                ok = true;
            }
            if (ok) continue;
            System.out.println("R3 : " + s2);
        }
        for (SPRelationship sp : this.list) {
            if (Utilities.noString(sp.r3) || (ok = this.list3.contains(sp.r3))) continue;
            System.out.println("R3 extra : " + sp.r3);
        }
    }

    private void check2b() {
        boolean ok;
        for (String s2 : this.list2b) {
            ok = false;
            for (SPRelationship t : this.list) {
                if (!s2.equals(t.r2b)) continue;
                ok = true;
            }
            if (ok) continue;
            System.out.println("R2b : " + s2);
        }
        for (SPRelationship sp : this.list) {
            if (Utilities.noString(sp.r2b) || (ok = this.list2b.contains(sp.r2b))) continue;
            System.out.println("R2b extra : " + sp.r2b);
        }
    }

    private void check2() {
        boolean ok;
        for (String s2 : this.list2) {
            ok = false;
            for (SPRelationship t : this.list) {
                if (!s2.equals(t.r2)) continue;
                ok = true;
            }
            if (ok) continue;
            System.out.println("R2 : " + s2);
        }
        for (SPRelationship sp : this.list) {
            if (Utilities.noString(sp.r2) || (ok = this.list2.contains(sp.r2))) continue;
            System.out.println("R2 extra : " + sp.r2);
        }
    }

    private void load4() throws FHIRFormatError, FileNotFoundException, IOException {
        Bundle bundle = (Bundle)new JsonParser().parse(new FileInputStream("c:\\temp\\sp4.json"));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            SearchParameter sp = (SearchParameter)be.getResource();
            for (CodeType br : sp.getBase()) {
                if (Utilities.existsInList(br.asStringValue(), "DomainResource", "Resource")) continue;
                this.list4.add(br.asStringValue() + "." + sp.getCode());
            }
        }
        Collections.sort(this.list4);
        System.out.println("R4 loaded - " + this.list4.size() + " parameters");
    }

    private void load3() throws FHIRFormatError, FileNotFoundException, IOException {
        org.hl7.fhir.dstu3.model.Bundle bundle = (org.hl7.fhir.dstu3.model.Bundle)new org.hl7.fhir.dstu3.formats.JsonParser().parse(new FileInputStream("c:\\temp\\sp3.json"));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            org.hl7.fhir.dstu3.model.SearchParameter sp = (org.hl7.fhir.dstu3.model.SearchParameter)be.getResource();
            for (org.hl7.fhir.dstu3.model.CodeType br : sp.getBase()) {
                if (Utilities.existsInList(br.asStringValue(), "DomainResource", "Resource")) continue;
                this.list3.add(br.asStringValue() + "." + sp.getCode());
            }
        }
        Collections.sort(this.list3);
        System.out.println("R3 loaded - " + this.list3.size() + " parameters");
    }

    private void load2() throws FHIRFormatError, FileNotFoundException, IOException {
        org.hl7.fhir.dstu2.model.Bundle bundle = (org.hl7.fhir.dstu2.model.Bundle)new org.hl7.fhir.dstu2.formats.JsonParser().parse(new FileInputStream("c:\\temp\\sp2.json"));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            org.hl7.fhir.dstu2.model.SearchParameter sp = (org.hl7.fhir.dstu2.model.SearchParameter)be.getResource();
            String br = sp.getBase();
            if (Utilities.existsInList(br, "DomainResource", "Resource")) continue;
            this.list2.add(br + "." + sp.getCode());
        }
        Collections.sort(this.list2);
        System.out.println("R2 loaded - " + this.list2.size() + " parameters");
    }

    private void load2b() throws FHIRFormatError, FileNotFoundException, IOException {
        org.hl7.fhir.dstu2016may.model.Bundle bundle = (org.hl7.fhir.dstu2016may.model.Bundle)new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(new FileInputStream("c:\\temp\\sp2b.json"));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            org.hl7.fhir.dstu2016may.model.SearchParameter sp = (org.hl7.fhir.dstu2016may.model.SearchParameter)be.getResource();
            String br = sp.getBase();
            if (Utilities.existsInList(br, "DomainResource", "Resource")) continue;
            this.list2b.add(br + "." + sp.getCode());
        }
        Collections.sort(this.list2b);
        System.out.println("R2b loaded - " + this.list2b.size() + " parameters");
    }

    private void loadCsv() throws IOException, FHIRException {
        CSVReader csv = new CSVReader(new FileInputStream("C:\\work\\org.hl7.fhir\\org.fhir.interversion\\work\\search-params.csv"));
        csv.readHeaders();
        while (csv.line()) {
            boolean ok;
            String r4 = csv.cell("R4");
            String r3 = csv.cell("R3");
            String r2b = csv.cell("R2b");
            String r2 = csv.cell("R2");
            if (Utilities.noString(r4) && Utilities.noString(r3) && Utilities.noString(r2b) && Utilities.noString(r2) || !(ok = !Utilities.noString(r4) && r4.contains(".") || !Utilities.noString(r3) && r3.contains(".") || !Utilities.noString(r2b) && r2b.contains(".") || !Utilities.noString(r2) && r2.contains("."))) continue;
            this.list.add(new SPRelationship(r4, r3, r2b, r2));
        }
        System.out.println("Map loaded - " + this.list.size() + " entries");
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, FHIRException {
        new SearchParameterProcessor().load();
    }

    public class SPRelationship {
        private String r4;
        private String r3;
        private String r2b;
        private String r2;

        public SPRelationship(String r4, String r3, String r2b, String r2) {
            this.r4 = r4;
            this.r3 = r3;
            this.r2b = r2b;
            this.r2 = r2;
        }

        public String getR4() {
            return this.r4;
        }

        public String getR3() {
            return this.r3;
        }

        public String getR2b() {
            return this.r2b;
        }

        public String getR2() {
            return this.r2;
        }

        public String getByCode(String code) {
            if ("R4".equals(code)) {
                return this.r4;
            }
            if ("R3".equals(code)) {
                return this.r3;
            }
            if ("R2b".equals(code)) {
                return this.r2b;
            }
            if ("R2".equals(code)) {
                return this.r2;
            }
            return null;
        }
    }
}

