/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.terminologies.CodeSystemUtilities;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.Utilities;

public class NUCCConvertor {
    private String[] last = new String[2];
    private CodeSystem.ConceptDefinitionComponent[] concepts = new CodeSystem.ConceptDefinitionComponent[2];

    public static void main(String[] args) throws Exception {
        new NUCCConvertor().execute();
    }

    public void execute() throws IOException, FHIRException {
        CSVReader csv = new CSVReader(new FileInputStream("c:\\temp\\nucc.csv"));
        CodeSystem cs = new CodeSystem();
        cs.setId("nucc-provider-taxonomy");
        cs.setUrl("http://nucc.org/provider-taxonomy");
        cs.setName("NUCC Provider Taxonomy");
        cs.setDateElement(new DateTimeType());
        cs.setDescription("The Health Care Provider Taxonomy code is a unique alphanumeric code, ten characters in length. The code set is structured into three distinct 'Levels' including Provider Type, Classification, and Area of Specialization");
        cs.setCopyright("See NUCC copyright statement");
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        cs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
        cs.setExperimental(false);
        cs.setValueSet("http://hl7.org/fhir/ValueSet/nucc-provider-taxonomy");
        cs.setHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
        csv.parseLine();
        while (csv.ready()) {
            String[] values = csv.parseLine();
            this.processLine(cs, values);
        }
        csv.close();
        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream("c:\\temp\\nucc.xml"), cs);
    }

    private void processLine(CodeSystem cs, String[] values) throws FHIRFormatError {
        if (!values[1].equals(this.last[0])) {
            this.last[1] = "";
            this.last[0] = values[1];
            this.concepts[0] = new CodeSystem.ConceptDefinitionComponent();
            cs.getConcept().add(this.concepts[0]);
            this.concepts[0].setDisplay(values[1]);
            this.concepts[0].setCode("base-" + Integer.toString(cs.getConcept().size()));
            CodeSystemUtilities.setNotSelectable(cs, this.concepts[0]);
        }
        if (!values[2].equals(this.last[1])) {
            this.last[1] = values[2];
            this.concepts[1] = new CodeSystem.ConceptDefinitionComponent();
            this.concepts[0].getConcept().add(this.concepts[1]);
            this.concepts[1].setCode(values[0]);
            this.concepts[1].setDisplay(values[2]);
            this.concepts[1].setDefinition(values[4]);
            if (values.length > 5 && !Utilities.noString(values[5])) {
                ToolingExtensions.addCSComment(this.concepts[1], values[5]);
            }
        } else if (!Utilities.noString(values[3])) {
            CodeSystem.ConceptDefinitionComponent cc = new CodeSystem.ConceptDefinitionComponent();
            this.concepts[1].getConcept().add(cc);
            cc.setCode(values[0]);
            cc.setDisplay(values[3]);
            cc.setDefinition(values[4]);
            if (values.length > 5 && !Utilities.noString(values[5])) {
                ToolingExtensions.addCSComment(cc, values[5]);
            }
        }
    }
}

