/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

public class IEEE11073Convertor {
    public static final String UCUM_PATH = "c:\\work\\org.hl7.fhir\\build\\implementations\\java\\org.hl7.fhir.convertors\\samples\\ucum-essence.xml";
    private static final String MDC_ALL_VALUES = "http://????";

    public static void main(String[] args) throws Exception {
        UcumEssenceService ucum = new UcumEssenceService(UCUM_PATH);
        CodeSystem mdc = IEEE11073Convertor.generateMDC(args[0], args[1], ucum);
        ConceptMap loinc = IEEE11073Convertor.generateLoincMdcMap(mdc, args[1], args[2]);
    }

    private static ConceptMap generateLoincMdcMap(CodeSystem mdc, String dst, String src) throws IOException, FHIRException {
        ConceptMap cm = new ConceptMap();
        cm.setId("loinc-mdc");
        cm.setUrl("http:/???/fhir/ConceptMap/loinc-mdc");
        cm.setVersion("[todo]");
        cm.setName("LoincMdcCrossMap");
        cm.setTitle("Cross Map between LOINC and MDC");
        cm.setStatus(Enumerations.PublicationStatus.DRAFT);
        cm.setExperimental(true);
        cm.setDateElement(new DateTimeType());
        cm.setPublisher("HL7, Inc");
        ContactDetail cd2 = cm.addContact();
        cd2.setName("LOINC + IEEE");
        ContactPoint cp = cd2.addTelecom();
        cp.setSystem(ContactPoint.ContactPointSystem.URL);
        cp.setValue("http://loinc.org");
        cm.setDescription("A Cross Map between the LOINC and MDC Code systems");
        cm.setPurpose("To implementers map between medical device codes and LOINC codes");
        cm.setCopyright("This content LOINC \u00ae is copyright \u00a9 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use");
        cm.setSource(new UriType("http://loinc.org/vs"));
        cm.setTarget(new UriType(MDC_ALL_VALUES));
        ConceptMap.ConceptMapGroupComponent g2 = cm.addGroup();
        g2.setSource("urn:iso:std:iso:11073:10101");
        g2.setTarget("http://loinc.org");
        CSVReader csv = new CSVReader(new FileInputStream(src));
        csv.readHeaders();
        while (csv.line()) {
            ConceptMap.SourceElementComponent e = g2.addElement();
            e.setCode(csv.cell("IEEE_CF_CODE10"));
            e.setDisplay(csv.cell("IEEE_DESCRIPTION"));
            ConceptMap.TargetElementComponent t = e.addTarget();
            t.setEquivalence(Enumerations.ConceptMapEquivalence.EQUIVALENT);
            t.setCode(csv.cell("LOINC_NUM"));
            t.setDisplay(csv.cell("LOINC_LONG_COMMON_NAME"));
        }
        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(dst, "conceptmap-" + cm.getId() + ".xml")), cm);
        System.out.println("Done");
        return cm;
    }

    public static CodeSystem generateMDC(String src, String dst, UcumService ucum) throws UnsupportedEncodingException, FileNotFoundException, IOException, FHIRException {
        CSVReader csv = new CSVReader(new FileInputStream(src));
        csv.readHeaders();
        CodeSystem cs = new CodeSystem();
        HashMap<String, String> ucumIssues = new HashMap<String, String>();
        int errorCount = 0;
        cs.setId("MDC");
        cs.setUrl("urn:iso:std:iso:11073:10101");
        cs.setVersion("[todo]");
        cs.setName("11073:10101 codes for the FHIR community");
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        cs.setExperimental(false);
        cs.setDateElement(new DateTimeType());
        cs.setPublisher("HL7 (FHIR Project)");
        ContactDetail cd2 = cs.addContact();
        ContactPoint cp = cd2.addTelecom();
        cp.setSystem(ContactPoint.ContactPointSystem.URL);
        cp.setValue("http://ieee?");
        cs.setDescription("1073 Codes for the FHIR community (generated from the Rosetta data");
        Identifier i = new Identifier();
        cs.setIdentifier(i);
        i.setSystem("urn:ietf:rfc:3986");
        i.setValue("urn:oid:2.16.840.1.113883.6.24");
        cs.setCaseSensitive(false);
        cs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
        cs.addProperty().setCode("ucum").setDescription("UCUM units associated with Concept").setType(CodeSystem.PropertyType.STRING);
        cs.addProperty().setCode("unit").setDescription("MDC units associated with Concept").setType(CodeSystem.PropertyType.STRING);
        cs.addProperty().setCode("refid").setDescription("MDC Reference Id for Concept").setType(CodeSystem.PropertyType.CODE);
        HashSet<String> codes = new HashSet<String>();
        while (csv.line()) {
            if (!csv.has("CF_CODE10")) continue;
            String code = csv.cell("CF_CODE10");
            if (codes.contains(code)) {
                System.out.println("Duplicate Code " + code);
                continue;
            }
            codes.add(code);
            CodeSystem.ConceptDefinitionComponent c = cs.addConcept();
            c.setCode(code);
            c.setDisplay(csv.cell("Common Term"));
            c.setDefinition(csv.cell("Term Description"));
            String vd = csv.cell("Vendor_Description");
            if (!c.hasDefinition()) {
                c.setDefinition(vd);
            }
            if (!c.hasDisplay()) {
                c.setDisplay(vd);
            }
            String refid = csv.cell("REFID");
            c.addProperty().setCode("refid").setValue((Type)((Object)new CodeType().setValue(refid)));
            if (csv.has("Synonym")) {
                c.addDesignation().setValue(csv.cell("Synonym")).setUse(new Coding().setSystem("http://hl7.org/fhir/designation-use").setCode("synonym"));
            }
            if (csv.has("Acronym")) {
                c.addDesignation().setValue(csv.cell("Acronym")).setUse(new Coding().setSystem("http://hl7.org/fhir/designation-use").setDisplay("acronym"));
            }
            if (csv.has("Systematic Name")) {
                String sysName = csv.cell("Systematic Name");
                if (!c.hasDefinition()) {
                    c.setDefinition(sysName);
                }
                c.addDesignation().setValue(sysName).setUse(new Coding().setSystem("http://hl7.org/fhir/designation-use").setCode("structured-name"));
            }
            if (csv.has("UOM_MDC")) {
                c.addProperty().setCode("unit").setValue((Type)((Object)new StringType().setValue(csv.cell("UOM_MDC"))));
            }
            if (!csv.has("UOM_UCUM")) continue;
            CommaSeparatedStringBuilder ul = new CommaSeparatedStringBuilder();
            for (String u : csv.cell("UOM_UCUM").split(" ")) {
                String msg = ucum.validate(u);
                if (msg != null) {
                    ++errorCount;
                    ucumIssues.put(u, msg);
                    continue;
                }
                ul.append(u);
            }
            if (ul.length() <= 0) continue;
            c.addProperty().setCode("ucum").setValue((Type)((Object)new StringType().setValue(ul.toString())));
        }
        csv.close();
        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(dst, "codesystem-" + cs.getId() + ".xml")), cs);
        System.out.println(Integer.toString(errorCount) + "UCUM errors");
        for (String u : IEEE11073Convertor.sorted(ucumIssues.keySet())) {
            System.out.println("Invalid UCUM code: " + u + " because " + (String)ucumIssues.get(u));
        }
        return cs;
    }

    private static List<String> sorted(Set<String> keySet) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(keySet);
        Collections.sort(names);
        return names;
    }
}

