/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.convertors.misc.CDAUtilities;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Factory;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.OIDUtils;
import org.hl7.fhir.utilities.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Convert {
    private CDAUtilities cda;
    private UcumService ucumSvc;
    private Set<String> oids = new HashSet<String>();
    private String defaultTimezone;
    private boolean generateMissingExtensions;

    public Convert(CDAUtilities cda, UcumService ucumSvc, String defaultTimezone) {
        this.cda = cda;
        this.ucumSvc = ucumSvc;
        this.defaultTimezone = defaultTimezone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Identifier makeIdentifierFromII(Element e) throws Exception {
        String ex;
        Identifier id = new Identifier();
        String r = e.getAttribute("root");
        if (e.hasAttribute("extension") && Utilities.noString(e.getAttribute("extension"))) {
            if (!this.generateMissingExtensions) throw new Exception("Broken identifier - extension is blank");
            ex = UUID.randomUUID().toString();
        } else {
            ex = e.getAttribute("extension");
        }
        if (Utilities.noString(ex)) {
            id.setSystem("urn:ietf:rfc:3986");
            if (this.isGuid(r)) {
                id.setValue("urn:uuid:" + r);
                return id;
            } else if (this.UriForOid(r) != null) {
                id.setValue(this.UriForOid(r));
                return id;
            } else {
                id.setValue(this.UriForOid(r));
            }
            return id;
        } else {
            if (this.isGuid(r)) {
                id.setSystem("urn:uuid:" + r);
            } else if (this.UriForOid(r) != null) {
                id.setSystem(this.UriForOid(r));
            } else {
                id.setSystem("urn:oid:" + r);
            }
            id.setValue(ex);
        }
        return id;
    }

    public String makeURIfromII(Element e) {
        String r = e.getAttribute("root");
        if (Utilities.noString(e.getAttribute("extension"))) {
            if (this.isGuid(r)) {
                return "urn:uuid:" + r;
            }
            if (this.UriForOid(r) != null) {
                return this.UriForOid(r);
            }
            return this.UriForOid(r);
        }
        if (this.isGuid(r)) {
            return "urn:uuid:" + r + "::" + e.getAttribute("extension");
        }
        if (this.UriForOid(r) != null) {
            return this.UriForOid(r) + "::" + e.getAttribute("extension");
        }
        return "urn:oid:" + r + "::" + e.getAttribute("extension");
    }

    private String UriForOid(String r) {
        String uri = OIDUtils.getUriForOid(r);
        if (uri != null) {
            return uri;
        }
        this.oids.add(r);
        return "urn:oid:" + r;
    }

    public boolean isGuid(String r) {
        return r.matches("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}");
    }

    public InstantType makeInstantFromTS(Element child) throws Exception {
        InstantType i = InstantType.parseV3(child.getAttribute("value"));
        return i;
    }

    public CodeableConcept makeCodeableConceptFromCD(Element cv) throws Exception {
        if (cv == null) {
            return null;
        }
        CodeableConcept cc = new CodeableConcept();
        cc.addCoding(this.makeCodingFromCV(cv));
        for (Element e : this.cda.getChildren(cv, "translation")) {
            cc.addCoding(this.makeCodingFromCV(e));
        }
        if (this.cda.getChild(cv, "originalText") != null) {
            Element ote = this.cda.getChild(cv, "originalText");
            String ot = ote.getTextContent().trim();
            cc.setText(Utilities.noString(ot) ? null : ot);
        }
        return cc;
    }

    public Coding makeCodingFromCV(Element cd2) throws Exception {
        if (cd2 == null || Utilities.noString(cd2.getAttribute("code"))) {
            return null;
        }
        Coding c = new Coding();
        c.setCode(cd2.getAttribute("code"));
        c.setDisplay(cd2.getAttribute("displayName"));
        String r = cd2.getAttribute("codeSystem");
        String uri = this.getUriForOID(r);
        if (uri != null) {
            c.setSystem(uri);
        } else if (this.isGuid(r)) {
            c.setSystem("urn:uuid:" + r);
        } else if (this.UriForOid(r) != null) {
            c.setSystem(this.UriForOid(r));
        } else {
            c.setSystem("urn:oid:" + r);
        }
        return c;
    }

    private String getUriForOID(String r) {
        if (r.equals("2.16.840.1.113883.6.1")) {
            return "http://loinc.org";
        }
        if (r.equals("2.16.840.1.113883.6.96")) {
            return "http://snomed.info/sct";
        }
        return null;
    }

    public Address makeAddressFromAD(Element e) {
        if (e == null) {
            return null;
        }
        Address a = new Address();
        String use = e.getAttribute("use");
        if (use != null) {
            if (use.equals("H") || use.equals("HP") || use.equals("HV")) {
                a.setUse(Address.AddressUse.HOME);
            } else if (use.equals("WP") || use.equals("DIR") || use.equals("PUB")) {
                a.setUse(Address.AddressUse.WORK);
            } else if (use.equals("TMP")) {
                a.setUse(Address.AddressUse.TEMP);
            } else if (use.equals("BAD")) {
                a.setUse(Address.AddressUse.OLD);
            }
        }
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            String v = n.getTextContent();
            if (n.getLocalName().equals("additionalLocator")) {
                a.getLine().add(this.makeString(v));
                continue;
            }
            if (n.getLocalName().equals("deliveryAddressLine")) {
                a.getLine().add(this.makeString(v));
                continue;
            }
            if (n.getLocalName().equals("streetAddressLine")) {
                a.getLine().add(this.makeString(v));
                continue;
            }
            if (n.getLocalName().equals("direction")) {
                a.getLine().add(this.makeString(v));
                continue;
            }
            if (n.getLocalName().equals("careOf")) {
                a.getLine().add(this.makeString(v));
                continue;
            }
            if (n.getLocalName().equals("country")) {
                a.setCountry(v);
                continue;
            }
            if (n.getLocalName().equals("city")) {
                a.setCity(v);
                continue;
            }
            if (n.getLocalName().equals("state")) {
                a.setState(v);
                continue;
            }
            if (!n.getLocalName().equals("postalCode")) continue;
            a.setPostalCode(v);
        }
        return a;
    }

    public StringType makeString(String v) {
        StringType s2 = new StringType();
        s2.setValue(v);
        return s2;
    }

    public ContactPoint makeContactFromTEL(Element e) throws Exception {
        if (e == null) {
            return null;
        }
        if (e.hasAttribute("nullFlavor")) {
            return null;
        }
        ContactPoint c = new ContactPoint();
        String use = e.getAttribute("use");
        if (use != null) {
            if (use.equals("H") || use.equals("HP") || use.equals("HV")) {
                c.setUse(ContactPoint.ContactPointUse.HOME);
            } else if (use.equals("WP") || use.equals("DIR") || use.equals("PUB")) {
                c.setUse(ContactPoint.ContactPointUse.WORK);
            } else if (use.equals("TMP")) {
                c.setUse(ContactPoint.ContactPointUse.TEMP);
            } else if (use.equals("BAD")) {
                c.setUse(ContactPoint.ContactPointUse.OLD);
            }
        }
        if (e.getAttribute("value") != null) {
            String[] url = e.getAttribute("value").split(":");
            if (url.length == 1) {
                c.setValue(url[0].trim());
                c.setSystem(ContactPoint.ContactPointSystem.PHONE);
            } else {
                if (url[0].equals("tel")) {
                    c.setSystem(ContactPoint.ContactPointSystem.PHONE);
                } else if (url[0].equals("mailto")) {
                    c.setSystem(ContactPoint.ContactPointSystem.EMAIL);
                } else if (e.getAttribute("value").contains(":")) {
                    c.setSystem(ContactPoint.ContactPointSystem.OTHER);
                } else {
                    c.setSystem(ContactPoint.ContactPointSystem.PHONE);
                }
                c.setValue(url[1].trim());
            }
        }
        return c;
    }

    public HumanName makeNameFromEN(Element e) {
        if (e == null) {
            return null;
        }
        HumanName hn = new HumanName();
        String use = e.getAttribute("use");
        if (use != null) {
            if (use.equals("L")) {
                hn.setUse(HumanName.NameUse.USUAL);
            } else if (use.equals("C")) {
                hn.setUse(HumanName.NameUse.OFFICIAL);
            } else if (use.equals("P") || use.equals("A")) {
                hn.setUse(HumanName.NameUse.ANONYMOUS);
            } else if (use.equals("TMP")) {
                hn.setUse(HumanName.NameUse.TEMP);
            } else if (use.equals("BAD")) {
                hn.setUse(HumanName.NameUse.OLD);
            }
        }
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            String v = n.getTextContent();
            if (n.getLocalName().equals("family")) {
                hn.setFamilyElement(this.makeString(v));
                continue;
            }
            if (n.getLocalName().equals("given")) {
                hn.getGiven().add(this.makeString(v));
                continue;
            }
            if (n.getLocalName().equals("prefix")) {
                hn.getPrefix().add(this.makeString(v));
                continue;
            }
            if (!n.getLocalName().equals("suffix")) continue;
            hn.getSuffix().add(this.makeString(v));
        }
        return hn;
    }

    public DateTimeType makeDateTimeFromTS(Element ts) throws Exception {
        if (ts == null) {
            return null;
        }
        String v = ts.getAttribute("value");
        if (Utilities.noString(v)) {
            return null;
        }
        if (v.length() > 8 && !this.hasTimezone(v)) {
            v = v + this.defaultTimezone;
        }
        DateTimeType d = DateTimeType.parseV3(v);
        return d;
    }

    private boolean hasTimezone(String v) {
        return v.contains("+") || v.contains("-") || v.endsWith("Z");
    }

    public DateType makeDateFromTS(Element ts) throws Exception {
        if (ts == null) {
            return null;
        }
        String v = ts.getAttribute("value");
        if (Utilities.noString(v)) {
            return null;
        }
        DateType d = DateType.parseV3(v);
        return d;
    }

    public Period makePeriodFromIVL(Element ivl) throws Exception {
        Element high;
        if (ivl == null) {
            return null;
        }
        Period p = new Period();
        Element low = this.cda.getChild(ivl, "low");
        if (low != null) {
            p.setStartElement(this.makeDateTimeFromTS(low));
        }
        if ((high = this.cda.getChild(ivl, "high")) != null) {
            p.setEndElement(this.makeDateTimeFromTS(high));
        }
        if (p.getStartElement() != null || p.getEndElement() != null) {
            return p;
        }
        return null;
    }

    public DateTimeType makeDateTimeFromIVL(Element ivl) throws Exception {
        if (ivl == null) {
            return null;
        }
        if (ivl.hasAttribute("value")) {
            return this.makeDateTimeFromTS(ivl);
        }
        Element high = this.cda.getChild(ivl, "high");
        if (high != null) {
            return this.makeDateTimeFromTS(high);
        }
        Element low = this.cda.getChild(ivl, "low");
        if (low != null) {
            return this.makeDateTimeFromTS(low);
        }
        return null;
    }

    public Type makeStringFromED(Element e) throws Exception {
        if (e == null) {
            return null;
        }
        if (this.cda.getChild(e, "reference") != null) {
            if (this.cda.getChild(e, "reference").getAttribute("value").startsWith("#")) {
                Element t = this.cda.getByXmlId(this.cda.getChild(e, "reference").getAttribute("value").substring(1));
                String ot = t.getTextContent().trim();
                return Utilities.noString(ot) ? null : Factory.newString_(ot);
            }
            throw new Exception("external references not handled yet " + this.cda.getChild(e, "reference").getAttribute("value"));
        }
        return Factory.newString_(e.getTextContent());
    }

    public Type makeTypeFromANY(Element e) throws Exception {
        if (e == null) {
            return null;
        }
        String t = e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (Utilities.noString(t)) {
            throw new Exception("Missing type on RIM attribute with type any");
        }
        if (t.equals("CD") || t.equals("CE")) {
            return this.makeCodeableConceptFromCD(e);
        }
        if (t.equals("ST")) {
            return this.makeStringFromED(e);
        }
        throw new Exception("Not done yet (type = " + t + ")");
    }

    public Type makeMatchingTypeFromIVL(Element ivl) throws Exception {
        if (ivl == null) {
            return null;
        }
        if (ivl.getAttribute("value") != null) {
            return this.makeDateTimeFromIVL(ivl);
        }
        if (this.cda.getChild(ivl, "low") != null || this.cda.getChild(ivl, "high") != null) {
            return this.makePeriodFromIVL(ivl);
        }
        throw new Exception("not handled yet");
    }

    public Type makeCodeableConceptFromNullFlavor(String nf) throws Exception {
        if (nf == null || "".equals(nf)) {
            return null;
        }
        if ("NI".equals(nf)) {
            return null;
        }
        if ("NA".equals(nf)) {
            return Factory.newCodeableConcept("unsupported", "http://hl7.org/fhir/data-absent-reason", "Unsupported");
        }
        if ("UNK".equals(nf)) {
            return Factory.newCodeableConcept("unknown", "http://hl7.org/fhir/data-absent-reason", "Unknown");
        }
        if ("ASKU".equals(nf)) {
            return Factory.newCodeableConcept("asked", "http://hl7.org/fhir/data-absent-reason", "Asked/Unknown");
        }
        if ("NAV".equals(nf)) {
            return Factory.newCodeableConcept("temp", "http://hl7.org/fhir/data-absent-reason", "Temporarily Unavailable");
        }
        if ("NASK".equals(nf)) {
            return Factory.newCodeableConcept("notasked", "http://hl7.org/fhir/data-absent-reason", "Not Asked");
        }
        if ("MSK".equals(nf)) {
            return Factory.newCodeableConcept("masked", "http://hl7.org/fhir/data-absent-reason", "Masked");
        }
        if ("OTH".equals(nf)) {
            return null;
        }
        return null;
    }

    public Range makeRangeFromIVLPQ(Element ivlpq) throws Exception {
        if (ivlpq == null) {
            return null;
        }
        Element low = this.cda.getChild(ivlpq, "low");
        Element high = this.cda.getChild(ivlpq, "high");
        if (low == null && high == null) {
            return null;
        }
        Range r = new Range();
        r.setLow(this.makeSimpleQuantityFromPQ(low, ivlpq.getAttribute("unit")));
        r.setHigh(this.makeSimpleQuantityFromPQ(high, ivlpq.getAttribute("unit")));
        return r;
    }

    public Quantity makeQuantityFromPQ(Element pq) throws Exception {
        return this.makeQuantityFromPQ(pq, null);
    }

    public Quantity makeQuantityFromPQ(Element pq, String units) throws Exception {
        if (pq == null) {
            return null;
        }
        Quantity qty = new Quantity();
        String n = pq.getAttribute("value").replace(",", "").trim();
        try {
            qty.setValue(new BigDecimal(n));
        }
        catch (Exception e) {
            throw new Exception("Unable to process value '" + n + "'", e);
        }
        String string = units = Utilities.noString(pq.getAttribute("unit")) ? units : pq.getAttribute("unit");
        if (!Utilities.noString(units)) {
            if (this.ucumSvc == null || this.ucumSvc.validate(units) != null) {
                qty.setUnit(units);
            } else {
                qty.setCode(units);
                qty.setSystem("http://unitsofmeasure.org");
                qty.setUnit(this.ucumSvc.getCommonDisplay(units));
            }
        }
        return qty;
    }

    public SimpleQuantity makeSimpleQuantityFromPQ(Element pq, String units) throws Exception {
        if (pq == null) {
            return null;
        }
        SimpleQuantity qty = new SimpleQuantity();
        String n = pq.getAttribute("value").replace(",", "").trim();
        try {
            qty.setValue(new BigDecimal(n));
        }
        catch (Exception e) {
            throw new Exception("Unable to process value '" + n + "'", e);
        }
        String string = units = Utilities.noString(pq.getAttribute("unit")) ? units : pq.getAttribute("unit");
        if (!Utilities.noString(units)) {
            if (this.ucumSvc == null || this.ucumSvc.validate(units) != null) {
                qty.setUnit(units);
            } else {
                qty.setCode(units);
                qty.setSystem("http://unitsofmeasure.org");
                qty.setUnit(this.ucumSvc.getCommonDisplay(units));
            }
        }
        return qty;
    }

    public Enumerations.AdministrativeGender makeGenderFromCD(Element cd2) throws Exception {
        String code = cd2.getAttribute("code");
        String system = cd2.getAttribute("codeSystem");
        if ("2.16.840.1.113883.5.1".equals(system)) {
            if ("F".equals(code)) {
                return Enumerations.AdministrativeGender.FEMALE;
            }
            if ("M".equals(code)) {
                return Enumerations.AdministrativeGender.MALE;
            }
        }
        throw new Exception("Unable to read Gender " + system + "::" + code);
    }

    public Type makeSomethingFromGTS(List<Element> children) throws Exception {
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() == 1) {
            String type = children.get(0).getAttribute("xsi:type");
            if (type.equals("IVL_TS")) {
                return this.makePeriodFromIVL(children.get(0));
            }
            throw new Exception("Unknown GTS type '" + type + "'");
        }
        CommaSeparatedStringBuilder t = new CommaSeparatedStringBuilder();
        for (Element c : children) {
            t.append(c.getAttribute("xsi:type"));
        }
        if (t.toString().equals("IVL_TS, PIVL_TS")) {
            return this.makeTimingFromBoundedPIVL(children.get(0), children.get(1));
        }
        if (t.toString().equals("IVL_TS, EIVL_TS")) {
            return this.makeTimingFromBoundedEIVL(children.get(0), children.get(1));
        }
        throw new Exception("Unknown GTS pattern '" + t.toString() + "'");
    }

    private Type makeTimingFromBoundedEIVL(Element ivl, Element eivl) throws Exception {
        Timing t = new Timing();
        t.setRepeat(new Timing.TimingRepeatComponent());
        Element e = this.cda.getChild(eivl, "event");
        t.getRepeat().setBounds(this.makePeriodFromIVL(ivl));
        t.getRepeat().addWhen(this.convertEventTiming(e.getAttribute("code")));
        return t;
    }

    private Timing.EventTiming convertEventTiming(String e) throws Exception {
        if ("HS".equals(e)) {
            return Timing.EventTiming.HS;
        }
        throw new Exception("Unknown event " + e);
    }

    private Timing makeTimingFromBoundedPIVL(Element ivl, Element pivl) throws Exception {
        Timing t = new Timing();
        t.setRepeat(new Timing.TimingRepeatComponent());
        Element p = this.cda.getChild(pivl, "period");
        t.getRepeat().setBounds(this.makePeriodFromIVL(ivl));
        t.getRepeat().setPeriod(new BigDecimal(p.getAttribute("value")));
        t.getRepeat().setPeriodUnit(this.convertTimeUnit(p.getAttribute("unit")));
        return t;
    }

    private Timing.UnitsOfTime convertTimeUnit(String u) throws Exception {
        if ("h".equals(u)) {
            return Timing.UnitsOfTime.H;
        }
        if ("d".equals(u)) {
            return Timing.UnitsOfTime.D;
        }
        if ("w".equals(u)) {
            return Timing.UnitsOfTime.WK;
        }
        throw new Exception("Unknown unit of time " + u);
    }

    public Set<String> getOids() {
        return this.oids;
    }

    public boolean isGenerateMissingExtensions() {
        return this.generateMissingExtensions;
    }

    public void setGenerateMissingExtensions(boolean generateMissingExtensions) {
        this.generateMissingExtensions = generateMissingExtensions;
    }
}

