/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CDAUtilities {
    private Document doc;

    public CDAUtilities(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.parse(stream);
        this.basicChecks();
    }

    private void basicChecks() throws Exception {
        Element e = this.doc.getDocumentElement();
        this.rule(e.getNamespaceURI().equals("urn:hl7-org:v3"), "CDA namespace must be ");
        this.rule(e.getNodeName().equals("ClinicalDocument"), "CDA root name must be ClinicalDocument");
    }

    private void rule(boolean test, String message) throws Exception {
        if (!test) {
            throw new Exception(message);
        }
    }

    public Element getElement() {
        return this.doc.getDocumentElement();
    }

    public void checkTemplateId(Element e, String templateId) throws Exception {
        this.rule(this.hasTemplateId(e, templateId), "Template Id '" + templateId + "' not found");
    }

    public Element getChild(Element e, String[] names) throws Exception {
        for (String n : names) {
            if (e == null) {
                return null;
            }
            e = this.getChild(e, n);
        }
        return e;
    }

    public Element getChild(Element element, String name) throws Exception {
        if (element == null) {
            return null;
        }
        Element e = null;
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !n.getNodeName().equals(name)) continue;
            if (e == null) {
                e = (Element)n;
                continue;
            }
            throw new Exception("multiple matches found for " + name);
        }
        return e;
    }

    public Element getChildByAttribute(Element element, String name, String attrname, String value) throws Exception {
        if (element == null) {
            return null;
        }
        Element e = null;
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !n.getNodeName().equals(name) || !value.equals(((Element)n).getAttribute(attrname))) continue;
            if (e == null) {
                e = (Element)n;
                continue;
            }
            throw new Exception("multiple matches found for " + name);
        }
        return e;
    }

    public List<Element> getChildren(Element element, String name) {
        ArrayList<Element> l = new ArrayList<Element>();
        if (element != null) {
            for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals(name)) continue;
                l.add((Element)n);
            }
        }
        return l;
    }

    public Element getDescendent(Element element, String path) throws Exception {
        String[] p = path.split("\\/");
        return this.getDescendent(element, p);
    }

    public Element getDescendent(Element e, String[] path) throws Exception {
        for (String n : path) {
            if (e == null) {
                return e;
            }
            e = this.getChild(e, n);
        }
        return e;
    }

    public boolean hasTemplateId(Element e, String tid) {
        if (e == null) {
            return false;
        }
        boolean found = false;
        for (Node n = e.getFirstChild(); n != null && !found; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !n.getNodeName().equals("templateId") || !tid.equals(((Element)n).getAttribute("root"))) continue;
            found = true;
        }
        return found;
    }

    public String getStatus(Element act) throws Exception {
        if (act == null) {
            return null;
        }
        Element sc = this.getChild(act, "statusCode");
        if (sc == null) {
            return null;
        }
        return sc.getAttribute("code");
    }

    public String getSeverity(Element observation) throws Exception {
        for (Element e : this.getChildren(observation, "entryRelationship")) {
            Element child = this.getChild(e, "observation");
            if (!this.hasTemplateId(child, "2.16.840.1.113883.10.20.22.4.8")) continue;
            return this.getChild(child, "value").getAttribute("code");
        }
        return null;
    }

    public String showTemplateIds(Element element) {
        List<Element> list = this.getChildren(element, "templateId");
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Element e : list) {
            if (e.hasAttribute("extension")) {
                b.append(e.getAttribute("root") + "::" + e.getAttribute("extension"));
                continue;
            }
            b.append(e.getAttribute("root"));
        }
        return b.toString();
    }

    public Element getlastChild(Element e) {
        Node n;
        for (n = e.getLastChild(); n != null && n.getNodeType() != 1; n = n.getPreviousSibling()) {
        }
        return n == null ? null : (Element)n;
    }

    public Element getById(Element id, String childName) throws Exception {
        return this.getById(this.doc.getDocumentElement(), id, childName);
    }

    private Element getById(Element e, Element id, String childName) throws Exception {
        Element c = XMLUtil.getFirstChild(e);
        while (c != null) {
            Element i = this.getChild(c, "id");
            if (i != null && this.matchesAsId(i, id) && this.getChild(c, childName) != null) {
                return c;
            }
            Element m3 = this.getById(c, id, childName);
            if (m3 != null) {
                return m3;
            }
            c = XMLUtil.getNextSibling(c);
        }
        return null;
    }

    private boolean matchesAsId(Element i1, Element i2) {
        String r1 = i1.getAttribute("root");
        String r2 = i2.getAttribute("root");
        String e1 = i1.getAttribute("extension");
        String e2 = i2.getAttribute("extension");
        return r1 != null && r1.equals(r2) && (e1 == null && e2 == null || e1 != null && e1.equals(e2));
    }

    public Element getByXmlId(String id) {
        return this.getByXmlId(this.doc.getDocumentElement(), id);
    }

    private Element getByXmlId(Element e, String value) {
        Element c = XMLUtil.getFirstChild(e);
        while (c != null) {
            String id = c.getAttribute("ID");
            if (id != null && id.equals(value)) {
                return c;
            }
            Element m3 = this.getByXmlId(c, value);
            if (m3 != null) {
                return m3;
            }
            c = XMLUtil.getNextSibling(c);
        }
        return null;
    }
}

