/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.convertors.misc.CDAUtilities;
import org.hl7.fhir.convertors.misc.Convert;
import org.hl7.fhir.convertors.misc.ConverterBase;
import org.hl7.fhir.dstu3.context.SimpleWorkerContext;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Factory;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.utils.NarrativeGenerator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ZipGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class ArgonautConverter
extends ConverterBase {
    public static final String DEV_TS_SERVER = "http://local.fhir.org:960/open";
    public static final String UCUM_PATH = "c:\\work\\org.hl7.fhir\\build\\implementations\\java\\org.hl7.fhir.convertors\\samples\\ucum-essence.xml";
    public static final String SRC_PATH = "c:\\work\\org.hl7.fhir\\build\\publish\\";
    private static final String DEFAULT_ID_SPACE = "urn:uuid:e8e06b15-0f74-4b8e-b5e2-609dae7119dc";
    private static final boolean WANT_SAVE = true;
    private static final boolean WANT_VALIDATE = false;
    private String destFolder;
    private UcumService ucumSvc;
    private SimpleWorkerContext context;
    private Map<String, Map<String, Integer>> sections = new HashMap<String, Map<String, Integer>>();
    private Map<String, Practitioner> practitionerCache = new HashMap<String, Practitioner>();
    public int perfCount;
    private Set<String> oids = new HashSet<String>();
    private Map<String, ZipGenerator> zipsX = new HashMap<String, ZipGenerator>();
    private Map<String, ZipGenerator> zipsJ = new HashMap<String, ZipGenerator>();
    private Map<String, Stats> stats = new HashMap<String, Stats>();
    private ZipGenerator zipJ;
    private ZipGenerator zipX;
    int errors = 0;
    int warnings = 0;
    Map<String, Integer> procCodes = new HashMap<String, Integer>();
    Map<String, Integer> condCodes = new HashMap<String, Integer>();
    Map<String, Integer> allergyCodes = new HashMap<String, Integer>();

    public static void main(String[] args) {
        try {
            ArgonautConverter c = new ArgonautConverter(new UcumEssenceService(UCUM_PATH), Utilities.path(SRC_PATH, "validation.xml.zip"));
            c.destFolder = "C:\\work\\com.healthintersections.fhir\\argonaut\\fhir";
            c.convert("C:\\work\\com.healthintersections.fhir\\argonaut\\cda\\file_emergency", new Coding().setSystem("http://hl7.org/fhir/v3/ActCode").setCode("EMER"));
            c.convert("C:\\work\\com.healthintersections.fhir\\argonaut\\cda\\file_ed", new Coding().setSystem("http://hl7.org/fhir/v3/ActCode").setCode("IMP"));
            c.convert("C:\\work\\com.healthintersections.fhir\\argonaut\\cda\\fileX", new Coding().setSystem("http://hl7.org/fhir/v3/ActCode").setCode("AMB"));
            c.printSectionSummaries();
            c.closeZips();
            System.out.println("All done. " + Integer.toString(c.getErrors()) + " errors, " + Integer.toString(c.getWarnings()) + " warnings");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArgonautConverter(UcumService ucumSvc, String path) throws Exception {
        this.ucumSvc = ucumSvc;
        this.context = SimpleWorkerContext.fromPack(path);
    }

    public int getErrors() {
        return this.errors;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void convert(String sourceFolder, Coding clss) throws Exception {
        File source = new File(sourceFolder);
        for (String f : source.list()) {
            this.convert(sourceFolder, f, clss);
        }
    }

    private void closeZips() throws Exception {
        for (ZipGenerator z : this.zipsJ.values()) {
            z.close();
        }
        for (ZipGenerator z : this.zipsX.values()) {
            z.close();
        }
    }

    public void printSectionSummaries() {
        Object s2;
        System.out.println("Statistics:");
        for (String n : this.sorted(this.stats.keySet())) {
            s2 = this.stats.get(n);
            System.out.println("  " + n + ": generated " + Integer.toString(((Stats)s2).instances) + ", errors " + Integer.toString(((Stats)s2).errors) + ", warnings " + Integer.toString(((Stats)s2).warnings));
        }
        System.out.println("OIDs:");
        for (String n : this.sorted(this.oids)) {
            System.out.println("  " + n);
        }
        for (String n : this.sections.keySet()) {
            System.out.println(n + " Analysis");
            s2 = this.sections.get(n);
            for (String p : this.sorted(s2.keySet())) {
                System.out.println("  " + p + ": " + s2.get(p));
            }
        }
        this.dumpCodes();
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(keys);
        Collections.sort(names);
        return names;
    }

    private void convert(String sourceFolder, String filename, Coding clss) throws IOException {
        if (new File(Utilities.path(sourceFolder, filename)).length() == 0L) {
            return;
        }
        try {
            System.out.println("Process " + Utilities.path(sourceFolder, filename));
            CDAUtilities cda = new CDAUtilities(new FileInputStream(Utilities.path(sourceFolder, filename)));
            this.zipJ = new ZipGenerator(Utilities.path(this.destFolder, "json/doc", Utilities.changeFileExt(filename, ".json.zip")));
            this.zipX = new ZipGenerator(Utilities.path(this.destFolder, "xml/doc", Utilities.changeFileExt(filename, ".xml.zip")));
            Element doc = cda.getElement();
            Convert convert = new Convert(cda, this.ucumSvc, "-0400");
            convert.setGenerateMissingExtensions(true);
            Context context = new Context();
            context.baseId = Utilities.changeFileExt(filename, "");
            context.encClass = clss;
            this.makeSubject(cda, convert, doc, context, context.baseId + "-patient");
            this.makeAuthor(cda, convert, doc, context, context.baseId + "-author");
            this.makeEncounter(cda, convert, doc, context, context.baseId + "-encounter");
            Element body = cda.getDescendent(doc, "component/structuredBody");
            for (Element c : cda.getChildren(body, "component")) {
                this.processSection(cda, convert, context, cda.getChild(c, "section"));
            }
            this.oids.addAll(convert.getOids());
            this.saveResource(context.encounter);
            this.makeBinary(sourceFolder, filename, context);
            this.makeDocumentReference(cda, convert, doc, context);
            this.zipJ.close();
            this.zipX.close();
        }
        catch (Exception e) {
            throw new Error("Unable to process " + Utilities.path(sourceFolder, filename) + ": " + e.getMessage(), e);
        }
    }

    private void processSection(CDAUtilities cda, Convert convert, Context context, Element section) throws Exception {
        this.checkNoSubject(cda, section, "Section");
        if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.11") || cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.5.1")) {
            this.processProblemsSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.12") || cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.7.1")) {
            this.processProcedureSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.3") || cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.22.1")) {
            this.processEncountersSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.6.1")) {
            this.processAllergiesSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.2.1") || cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.6")) {
            this.processImmunizationsSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "1.3.6.1.4.1.19376.1.5.3.1.3.1")) {
            this.processReasonForEncounter(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.3.1") || cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.14")) {
            this.processResultsSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.4.1") || cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.16")) {
            this.processVitalSignsSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.1.1") || cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.8")) {
            this.processMedicationsSection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.17") || cda.hasTemplateId(section, "2.16.840.1.113883.3.88.11.83.126")) {
            this.processSocialHistorySection(cda, convert, section, context);
        } else if (cda.hasTemplateId(section, "2.16.840.1.113883.10.20.1.9")) {
            this.scanSection("Payers", section);
        } else {
            throw new Exception("Unprocessed section " + cda.getChild(section, "title").getTextContent());
        }
    }

    private void checkNoSubject(CDAUtilities cda, Element act, String path) throws Exception {
        if (cda.getChild(act, "subject") != null) {
            throw new Exception("The conversion program cannot accept a subject at the location " + path);
        }
    }

    private void scanSection(String name, Element child) {
        HashMap<String, Integer> section;
        if (this.sections.containsKey(name)) {
            section = this.sections.get(name);
        } else {
            section = new HashMap();
            this.sections.put(name, section);
        }
        this.iterateChildren(section, "/", child);
    }

    private void iterateChildren(Map<String, Integer> section, String path, Element element) {
        Element child = XMLUtil.getFirstChild(element);
        while (child != null) {
            String pathC = path + child.getNodeName() + this.attributes(child);
            if (section.containsKey(pathC)) {
                section.put(pathC, section.get(pathC) + 1);
            } else {
                section.put(pathC, 1);
            }
            this.iterateChildren(section, pathC + "/", child);
            child = XMLUtil.getNextSibling(child);
        }
    }

    private String attributes(Element child) {
        String s2 = ",";
        if (child.hasAttribute("inversionInd")) {
            s2 = s2 + "inversionInd:" + child.getAttribute("inversionInd") + ",";
        }
        if (child.hasAttribute("negationInd")) {
            s2 = s2 + "negationInd:" + child.getAttribute("negationInd") + ",";
        }
        if (child.hasAttribute("nullFlavor")) {
            s2 = s2 + "nullFlavor:" + child.getAttribute("nullFlavor") + ",";
        }
        if (child.hasAttribute("xsi:type")) {
            s2 = s2 + "type:" + child.getAttribute("xsi:type") + ",";
        }
        s2 = s2.substring(0, s2.length() - 1);
        if (child.getNodeName().equals("statusCode")) {
            return "[code:" + child.getAttribute("code") + "]";
        }
        if (child.getNodeName().equals("temnplateId")) {
            return "[id:" + child.getAttribute("root") + "]";
        }
        if (child.hasAttribute("moodCode")) {
            return "[" + child.getAttribute("classCode") + "," + child.getAttribute("moodCode") + s2 + "]";
        }
        if (child.hasAttribute("classCode")) {
            return "[" + child.getAttribute("classCode") + s2 + "]";
        }
        if (child.hasAttribute("typeCode")) {
            return "[" + child.getAttribute("typeCode") + s2 + "]";
        }
        if (Utilities.noString(s2)) {
            return "";
        }
        return "[" + s2.substring(1) + "]";
    }

    private void saveResource(Resource resource) throws Exception {
        this.saveResource(resource, null);
    }

    private void saveResource(Resource resource, String extraType) throws Exception {
        DomainResource dr = null;
        if (resource instanceof DomainResource && !(dr = (DomainResource)resource).hasText()) {
            NarrativeGenerator generator = new NarrativeGenerator("", "", this.context);
            generator.generate(dr);
        }
        XmlParser xparser = new XmlParser();
        xparser.setOutputStyle(IParser.OutputStyle.PRETTY);
        JsonParser jparser = new JsonParser();
        jparser.setOutputStyle(IParser.OutputStyle.PRETTY);
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        xparser.compose(ba, resource);
        ba.close();
        byte[] srcX = ba.toByteArray();
        ba = new ByteArrayOutputStream();
        jparser.compose(ba, resource);
        ba.close();
        byte[] srcJ = ba.toByteArray();
        String rn = resource.getResourceType().toString();
        if (extraType != null) {
            rn = rn + extraType;
        }
        this.zipX.addBytes(resource.getId() + ".xml", srcX, false);
        this.zipJ.addBytes(resource.getId() + ".json", srcJ, false);
        if (!this.zipsX.containsKey(rn)) {
            this.zipsX.put(rn, new ZipGenerator(Utilities.path(this.destFolder, "xml/type", rn + ".xml.zip")));
            this.zipsJ.put(rn, new ZipGenerator(Utilities.path(this.destFolder, "json/type", rn + ".json.zip")));
            this.stats.put(rn, new Stats());
        }
        this.zipsJ.get(rn).addBytes(resource.getId() + ".json", srcJ, false);
        this.zipsX.get(rn).addBytes(resource.getId() + ".xml", srcX, false);
        Stats ss = this.stats.get(rn);
        ++ss.instances;
        String profile = resource.getUserString("profile");
        this.validate(srcX, profile, resource, ss);
    }

    private void validate(byte[] src, String url, Resource resource, Stats stats) throws Exception {
    }

    private boolean msgOk(String message) {
        return message.equals("Invalid Resource target type. Found Observation, but expected one of (DiagnosticReport)");
    }

    private void checkGenerateIdentifier(List<Identifier> ids, DomainResource resource) {
        if (ids.isEmpty()) {
            ids.add(new Identifier().setSystem(DEFAULT_ID_SPACE).setValue(resource.getClass().getName().toLowerCase() + "-" + resource.getId()));
        }
    }

    private void makeSubject(CDAUtilities cda, Convert convert, Element doc, Context context, String id) throws Exception {
        Element rt = cda.getChild(doc, "recordTarget");
        this.scanSection("Patient", rt);
        Element pr = cda.getChild(rt, "patientRole");
        Element p = cda.getChild(pr, "patient");
        Patient pat = new Patient();
        pat.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/patient-daf-dafpatient");
        StringBuilder b = new StringBuilder();
        pat.setId(id);
        for (Element e : cda.getChildren(p, "name")) {
            HumanName name = convert.makeNameFromEN(e);
            pat.getName().add(name);
            b.append(NarrativeGenerator.displayHumanName(name));
            b.append(" ");
        }
        b.append("(");
        for (Element e : cda.getChildren(pr, "id")) {
            Iterator<Element> identifier = convert.makeIdentifierFromII(e);
            pat.getIdentifier().add((Identifier)((Object)identifier));
            b.append(((Identifier)((Object)identifier)).getValue());
            b.append(", ");
        }
        for (Element e : cda.getChildren(pr, "addr")) {
            pat.getAddress().add(this.makeDefaultAddress(convert.makeAddressFromAD(e)));
        }
        for (Element e : cda.getChildren(pr, "telecom")) {
            pat.getTelecom().add(convert.makeContactFromTEL(e));
        }
        pat.setGender(convert.makeGenderFromCD(cda.getChild(p, "administrativeGenderCode")));
        b.append(pat.getGender().getDisplay());
        b.append(", ");
        pat.setBirthDateElement(convert.makeDateFromTS(cda.getChild(p, "birthTime")));
        b.append("DOB: ");
        b.append(pat.getBirthDateElement().toHumanDisplay());
        b.append(")");
        pat.setMaritalStatus(convert.makeCodeableConceptFromCD(cda.getChild(p, "maritalStatusCode")));
        pat.addExtension(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/us-core-race", convert.makeCodeableConceptFromCD(cda.getChild(p, "raceCode")), false));
        pat.addExtension(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/us-core-ethnicity", convert.makeCodeableConceptFromCD(cda.getChild(p, "ethnicGroupCode")), false));
        pat.addExtension(Factory.newExtension("http://hl7.org/ccda/religious-affiliation", convert.makeCodeableConceptFromCD(cda.getChild(p, "religiousAffiliationCode")), false));
        pat.addExtension(Factory.newExtension("http://hl7.org/ccdabirthplace", convert.makeAddressFromAD(cda.getChild(p, new String[]{"birthplace", "place", "addr"})), false));
        Element g2 = cda.getChild(p, "guardian");
        if (g2 != null) {
            Patient.ContactComponent guardian = new Patient.ContactComponent();
            pat.getContact().add(guardian);
            guardian.getRelationship().add(Factory.newCodeableConcept("GUARD", "urn:oid:2.16.840.1.113883.5.110", "guardian"));
            for (Element e : cda.getChildren(g2, "addr")) {
                if (guardian.getAddress() != null) continue;
                guardian.setAddress(this.makeDefaultAddress(convert.makeAddressFromAD(e)));
            }
            for (Element e : cda.getChildren(g2, "telecom")) {
                guardian.getTelecom().add(convert.makeContactFromTEL(e));
            }
            g2 = cda.getChild(g2, "guardianPerson");
            for (Element e : cda.getChildren(g2, "name")) {
                if (guardian.getName() != null) continue;
                guardian.setName(convert.makeNameFromEN(e));
            }
        }
        Element l = cda.getChild(p, "languageCommunication");
        CodeableConcept cc = new CodeableConcept();
        Coding c = new Coding();
        c.setSystem("urn:ietf:bcp:47");
        c.setCode(this.patchLanguage(cda.getChild(l, "languageCode").getAttribute("code")));
        cc.getCoding().add(c);
        pat.addCommunication().setLanguage(cc);
        Element prv = cda.getChild(pr, "providerOrganization");
        if (prv != null) {
            pat.setManagingOrganization(new Reference().setReference("Organization/" + this.processOrganization(prv, cda, convert, context).getId()));
        }
        context.subjectRef = new Reference().setDisplay(b.toString()).setReference("Patient/" + pat.getId());
        this.saveResource(pat);
    }

    private Organization processOrganization(Element oo, CDAUtilities cda, Convert convert, Context context) throws Exception {
        Organization org = new Organization();
        org.setId(context.baseId + "-organization-" + Integer.toString(context.orgId));
        org.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/org-daf-daforganization");
        ++context.orgId;
        for (Element e : cda.getChildren(oo, "id")) {
            org.getIdentifier().add(convert.makeIdentifierFromII(e));
        }
        for (Element e : cda.getChildren(oo, "addr")) {
            org.getAddress().add(this.makeDefaultAddress(convert.makeAddressFromAD(e)));
        }
        for (Element e : cda.getChildren(oo, "telecom")) {
            ContactPoint cp = convert.makeContactFromTEL(e);
            if (Utilities.noString(cp.getValue())) {
                cp.setValue("1 (555) 555 5555");
            }
            org.getTelecom().add(cp);
        }
        for (Element e : cda.getChildren(oo, "name")) {
            org.setName(e.getTextContent());
        }
        this.saveResource(org);
        return org;
    }

    private Address makeDefaultAddress(Address ad) {
        if (ad == null || ad.isEmpty()) {
            ad = new Address();
            ad.addLine("21 Doar road");
            ad.setCity("Erewhon");
            ad.setState("CA");
            ad.setPostalCode("31233");
        }
        return ad;
    }

    private String patchLanguage(String lang) {
        if (lang.equals("spa")) {
            return "es";
        }
        if (lang.equals("eng")) {
            return "en";
        }
        return lang;
    }

    private Practitioner makeAuthor(CDAUtilities cda, Convert convert, Element doc, Context context, String id) throws Exception {
        Element a = cda.getChild(doc, "author");
        this.scanSection("Author", a);
        Practitioner author = this.processPerformer(cda, convert, context, a, "assignedAuthor", "assignedPerson");
        context.authorRef = new Reference().setDisplay(author.getUserString("display")).setReference("Practitioner/" + author.getId());
        return author;
    }

    private Practitioner makePerformer(CDAUtilities cda, Convert convert, Context context, Element eperf, String roleName, String entityName) throws Exception {
        Element ae = cda.getChild(eperf, roleName);
        Element ap = cda.getChild(ae, entityName);
        StringBuilder b = new StringBuilder();
        Practitioner perf = new Practitioner();
        perf.setId("performer-" + Integer.toString(this.perfCount));
        perf.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/pract-daf-dafpract");
        ++this.perfCount;
        for (Element e : cda.getChildren(ae, "id")) {
            Identifier id = convert.makeIdentifierFromII(e);
            perf.getIdentifier().add(id);
        }
        for (Element e : cda.getChildren(ap, "name")) {
            HumanName name = convert.makeNameFromEN(e);
            perf.addName(name);
            b.append(NarrativeGenerator.displayHumanName(name));
            b.append(" ");
        }
        for (Element e : cda.getChildren(ae, "addr")) {
            perf.getAddress().add(this.makeDefaultAddress(convert.makeAddressFromAD(e)));
        }
        boolean first = true;
        for (Element e : cda.getChildren(ae, "telecom")) {
            ContactPoint contact = convert.makeContactFromTEL(e);
            perf.getTelecom().add(contact);
            if (Utilities.noString(contact.getValue())) continue;
            if (first) {
                b.append("(");
                first = false;
            } else {
                b.append(" ");
            }
            b.append(NarrativeGenerator.displayContactPoint(contact));
        }
        if (!first) {
            b.append(")");
        }
        perf.setUserData("display", b.toString());
        return perf;
    }

    private Encounter makeEncounter(CDAUtilities cda, Convert convert, Element doc, Context context, String id) throws Exception {
        Element co = cda.getChild(doc, "componentOf");
        Element ee = cda.getChild(co, "encompassingEncounter");
        this.scanSection("Encounter", co);
        Element of = cda.getChild(doc, "documentationOf");
        Element se = cda.getChild(of, "serviceEvent");
        this.scanSection("Encounter", of);
        Encounter enc = new Encounter();
        enc.setId(id);
        enc.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/encounter-daf-dafencounter");
        context.encounter = enc;
        enc.setSubject(context.subjectRef);
        for (Element e : cda.getChildren(ee, "id")) {
            enc.getIdentifier().add(convert.makeIdentifierFromII(e));
        }
        this.checkGenerateIdentifier(enc.getIdentifier(), enc);
        Period p1 = convert.makePeriodFromIVL(cda.getChild(ee, "effectiveTime"));
        enc.setPeriod(p1);
        if (p1.hasEnd()) {
            enc.setStatus(Encounter.EncounterStatus.FINISHED);
        } else {
            enc.setStatus(Encounter.EncounterStatus.INPROGRESS);
        }
        enc.setClass_(context.encClass);
        Element dd = cda.getChild(ee, "dischargeDispositionCode");
        if (dd != null) {
            enc.setHospitalization(new Encounter.EncounterHospitalizationComponent());
            enc.getHospitalization().setDischargeDisposition(convert.makeCodeableConceptFromCD(dd));
        }
        for (Element e : cda.getChildren(se, "performer")) {
            Practitioner p = this.processPerformer(cda, convert, context, e, "assignedEntity", "assignedPerson");
            Reference ref = new Reference().setReference("Practitioner/" + p.getId()).setDisplay(p.getUserString("display"));
            if (ref == null) continue;
            enc.addParticipant().setIndividual(ref);
        }
        return enc;
    }

    private Practitioner processPerformer(CDAUtilities cda, Convert convert, Context context, Element e, String roleName, String entityName) throws Exception {
        String key;
        Practitioner perf = this.makePerformer(cda, convert, context, e, roleName, entityName);
        if (perf == null) {
            return null;
        }
        Object ref = null;
        for (Identifier identifier : perf.getIdentifier()) {
            key = this.keyFor(identifier);
            if (!this.practitionerCache.containsKey(key)) continue;
            return this.practitionerCache.get(key);
        }
        this.saveResource(perf);
        for (Identifier identifier : perf.getIdentifier()) {
            key = "Practitioner-" + this.keyFor(identifier);
            this.practitionerCache.put(key, perf);
        }
        return perf;
    }

    private String keyFor(Identifier identifier) {
        return identifier.getSystem() + "||" + identifier.getValue();
    }

    private void buildNarrative(DomainResource resource, Element child) {
        if (!Utilities.noString(child.getTextContent())) {
            XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
            String s2 = child.getTextContent().trim();
            if (Utilities.noString(s2)) {
                div.addText("No Narrative provided in the source CDA document");
            } else {
                div.addText(s2);
            }
            resource.setText(new Narrative().setStatus(Narrative.NarrativeStatus.ADDITIONAL).setDiv(div));
        }
    }

    private void processProcedureSection(CDAUtilities cda, Convert convert, Element sect, Context context) throws DOMException, Exception {
        this.scanSection("Procedures", sect);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-procedures");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(sect, "code")), null));
        list.setTitle(cda.getChild(sect, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        this.buildNarrative(list, cda.getChild(sect, "text"));
        int i = 0;
        for (Element c : cda.getChildren(sect, "entry")) {
            Element p = cda.getChild(c, "procedure");
            Procedure proc = new Procedure();
            proc.setId(context.baseId + "-procedure-" + Integer.toString(i));
            proc.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/procedure-daf-dafprocedure");
            ++i;
            proc.setSubject(context.subjectRef);
            proc.setContext(new Reference().setReference("Encounter/" + context.encounter.getId()));
            list.addEntry().setItem(new Reference().setReference("Procedure/" + proc.getId()));
            proc.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(p, "code")), null));
            this.recordProcedureCode(proc.getCode());
            for (Element e : cda.getChildren(p, "id")) {
                proc.getIdentifier().add(convert.makeIdentifierFromII(e));
            }
            proc.setStatus(this.determineProcedureStatus(cda.getChild(p, "statusCode")));
            this.buildNarrative(proc, cda.getChild(p, "text"));
            proc.setPerformed(convert.makeDateTimeFromTS(cda.getChild(p, "effectiveTime")));
            for (Element e : cda.getChildren(p, "performer")) {
                Procedure.ProcedurePerformerComponent part = proc.addPerformer();
                Practitioner pp = this.processPerformer(cda, convert, context, e, "assignedEntity", "assignedPerson");
                Reference ref = new Reference().setReference("Practitioner/" + pp.getId()).setDisplay(pp.getUserString("display"));
                part.setActor(ref);
            }
            this.saveResource(proc);
        }
        this.saveResource(list);
    }

    private CodeableConcept inspectCode(CodeableConcept cc, Coding def) {
        if (cc != null) {
            for (Coding c : cc.getCoding()) {
                if ("http://snomed.info/sct".equals(c.getSystem()) && "ASSERTION".equals(c.getCode())) {
                    c.setSystem("http://hl7.org/fhir/v3/ActCode");
                }
                if (!"http://hl7.org/fhir/v3/ActCode".equals(c.getSystem()) || !"ASSERTION".equals(c.getCode())) continue;
                if (def == null) {
                    throw new Error("need a default code");
                }
                c.setSystem(def.getSystem());
                c.setVersion(def.getVersion());
                c.setCode(def.getCode());
                c.setDisplay(def.getDisplay());
            }
        }
        return cc;
    }

    private Procedure.ProcedureStatus determineProcedureStatus(Element child) {
        if ("completed".equals(child.getAttribute("code"))) {
            return Procedure.ProcedureStatus.COMPLETED;
        }
        throw new Error("not done yet: " + child.getAttribute("code"));
    }

    private void processReasonForEncounter(CDAUtilities cda, Convert convert, Element sect, Context context) throws DOMException, Exception {
        this.scanSection("Reason", sect);
        context.encounter.addReason().setText(cda.getChild(sect, "text").getTextContent());
    }

    private void processProblemsSection(CDAUtilities cda, Convert convert, Element sect, Context context) throws DOMException, Exception {
        this.scanSection("Problems", sect);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-problems");
        list.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/list-daf-dafproblemlist");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(sect, "code")), null));
        list.setTitle(cda.getChild(sect, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        this.buildNarrative(list, cda.getChild(sect, "text"));
        int i = 0;
        for (Element c : cda.getChildren(sect, "entry")) {
            Element pca = cda.getChild(c, "act");
            Condition cond = new Condition();
            cond.setId(context.baseId + "-problem-" + Integer.toString(i));
            cond.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/condition-daf-dafcondition");
            ++i;
            cond.setSubject(context.subjectRef);
            cond.setContext(new Reference().setReference("Encounter/" + context.encounter.getId()));
            cond.setVerificationStatus(this.getVerificationStatusFromAct(cda.getChild(pca, "statusCode")));
            cond.setAssertedDateElement(convert.makeDateTimeFromTS(cda.getChild(cda.getChild(pca, "effectiveTime"), "low")));
            boolean found = false;
            for (Element e : cda.getChildren(pca, "id")) {
                Identifier id = convert.makeIdentifierFromII(e);
                cond.getIdentifier().add(id);
            }
            if (found) continue;
            list.addEntry().setItem(new Reference().setReference("Condition/" + cond.getId()));
            for (Element e : cda.getChildren(pca, "performer")) {
                if (cond.hasAsserter()) {
                    throw new Error("additional asserter discovered");
                }
                Practitioner p = this.processPerformer(cda, convert, context, e, "assignedEntity", "assignedPerson");
                Reference ref = new Reference().setReference("Practitioner/" + p.getId()).setDisplay(p.getUserString("display"));
                cond.setAsserter(ref);
            }
            Element po = cda.getChild(cda.getChild(pca, "entryRelationship"), "observation");
            cond.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(po, "value")), null));
            this.recordConditionCode(cond.getCode());
            cond.setOnset(convert.makeDateTimeFromTS(cda.getChild(cda.getChild(po, "effectiveTime"), "low")));
            Element pso = cda.getChild(cda.getChild(po, "entryRelationship"), "observation");
            String status = cda.getChild(pso, "value").getAttribute("code");
            if (!status.equals("55561003")) {
                throw new Error("unknown status code " + status);
            }
            cond.setAbatement(new BooleanType("false"));
            this.saveResource(cond);
        }
        this.saveResource(list);
    }

    private Condition.ConditionVerificationStatus getVerificationStatusFromAct(Element child) {
        String s2 = child.getAttribute("code");
        if (!"active".equals(s2)) {
            System.out.println(s2);
        }
        return Condition.ConditionVerificationStatus.CONFIRMED;
    }

    private void processAllergiesSection(CDAUtilities cda, Convert convert, Element section, Context context) throws Exception {
        this.scanSection("Allergies", section);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-allergies");
        list.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/list-daf-dafallergylist");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(section, "code")), null));
        list.setTitle(cda.getChild(section, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        this.buildNarrative(list, cda.getChild(section, "text"));
        int i = 0;
        for (Element c : cda.getChildren(section, "entry")) {
            Element apa = cda.getChild(c, "act");
            AllergyIntolerance ai = new AllergyIntolerance();
            ai.setId(context.baseId + "-allergy-" + Integer.toString(i));
            ai.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/allergyintolerance-daf-dafallergyintolerance");
            ++i;
            ai.setPatient(context.subjectRef);
            ai.setAssertedDateElement(convert.makeDateTimeFromTS(cda.getChild(cda.getChild(apa, "effectiveTime"), "low")));
            boolean found = false;
            for (Element e : cda.getChildren(apa, "id")) {
                Identifier id = convert.makeIdentifierFromII(e);
                ai.getIdentifier().add(id);
            }
            if (found) continue;
            list.addEntry().setItem(new Reference().setReference("AllergyIntolerance/" + ai.getId()));
            Element ao = cda.getChild(cda.getChild(apa, "entryRelationship"), "observation");
            if (!cda.getChild(ao, "value").getAttribute("code").equals("419511003")) {
                throw new Error("unexpected code");
            }
            List<Element> reactions = cda.getChildren(ao, "entryRelationship");
            Element pe = cda.getChild(cda.getChild(cda.getChild(ao, "participant"), "participantRole"), "playingEntity");
            Element pec = cda.getChild(pe, "code");
            if (pec == null || !Utilities.noString(pec.getAttribute("nullFlavor"))) {
                String n = cda.getChild(pe, "name").getTextContent();
                ai.setCode(new CodeableConcept().setText(n));
            } else {
                ai.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(pec), null));
            }
            this.recordAllergyCode(ai.getCode());
            if (!reactions.isEmpty()) {
                AllergyIntolerance.AllergyIntoleranceReactionComponent aie = ai.addReaction();
                for (Element er : reactions) {
                    Element ro = cda.getChild(er, "observation");
                    aie.addManifestation(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(ro, "value")), null));
                }
            }
            this.saveResource(ai);
        }
        this.saveResource(list);
    }

    private void processVitalSignsSection(CDAUtilities cda, Convert convert, Element section, Context context) throws Exception {
        this.scanSection("Vital Signs", section);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-vitalsigns");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(section, "code")), null));
        list.setTitle(cda.getChild(section, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        this.buildNarrative(list, cda.getChild(section, "text"));
        int i = 0;
        for (Element c : cda.getChildren(section, "entry")) {
            Element org = cda.getChild(c, "organizer");
            for (Element oc : cda.getChildren(org, "component")) {
                Element o = cda.getChild(oc, "observation");
                Observation obs = new Observation();
                obs.setId(context.baseId + "-vitals-" + Integer.toString(i));
                obs.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/observation-daf-vitalsigns-dafvitalsigns");
                ++i;
                obs.setSubject(context.subjectRef);
                obs.setContext(new Reference().setReference("Encounter/" + context.encounter.getId()));
                obs.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(o, "code")), null));
                boolean found = false;
                for (Element e : cda.getChildren(o, "id")) {
                    Identifier id = convert.makeIdentifierFromII(e);
                    obs.getIdentifier().add(id);
                }
                if (found) continue;
                list.addEntry().setItem(new Reference().setReference("Observation/" + obs.getId()));
                obs.setStatus(Observation.ObservationStatus.FINAL);
                obs.setEffective(convert.makeDateTimeFromTS(cda.getChild(o, "effectiveTime")));
                String v = cda.getChild(o, "value").getAttribute("value");
                if (!Utilities.isDecimal(v, true)) {
                    obs.setDataAbsentReason(this.inspectCode(new CodeableConcept().setText(v), null));
                } else {
                    obs.setValue(convert.makeQuantityFromPQ(cda.getChild(o, "value")));
                }
                this.saveResource(obs, "-vs");
            }
        }
        this.saveResource(list, "-vs");
    }

    private void processResultsSection(CDAUtilities cda, Convert convert, Element section, Context context) throws Exception {
        this.scanSection("Results", section);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-results");
        list.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/list-daf-dafresultlist");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(section, "code")), null));
        list.setTitle(cda.getChild(section, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        this.buildNarrative(list, cda.getChild(section, "text"));
        context.obsId = 0;
        for (Element c : cda.getChildren(section, "entry")) {
            Element o;
            Element org = cda.getChild(c, "organizer");
            if (org != null) {
                Observation panel = new Observation();
                panel.setId(context.baseId + "-results-" + Integer.toString(context.obsId));
                panel.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/observation-daf-results-dafresultobspanel");
                ++context.obsId;
                panel.setSubject(context.subjectRef);
                panel.setContext(new Reference().setReference("Encounter/" + context.encounter.getId()));
                panel.setStatus(Observation.ObservationStatus.FINAL);
                boolean found = false;
                for (Element e : cda.getChildren(org, "id")) {
                    Identifier id = convert.makeIdentifierFromII(e);
                    panel.getIdentifier().add(id);
                }
                if (!found) {
                    list.addEntry().setItem(new Reference().setReference("Observation/" + panel.getId()));
                    panel.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(org, "code")), null));
                    for (Element comp : cda.getChildren(org, "component")) {
                        Period p;
                        Observation obs = this.processObservation(cda, convert, context, cda.getChild(comp, "observation"));
                        panel.addRelated().setType(Observation.ObservationRelationshipType.HASMEMBER).setTarget(new Reference().setReference("Observation/" + obs.getId()));
                        if (!panel.hasEffective()) {
                            panel.setEffective(obs.getEffective());
                            continue;
                        }
                        if (Base.compareDeep(panel.getEffective(), obs.getEffective(), false)) continue;
                        Period period = p = panel.getEffective() instanceof Period ? panel.getEffectivePeriod() : new Period().setStartElement(panel.getEffectiveDateTimeType()).setEndElement(panel.getEffectiveDateTimeType());
                        if (p.getStartElement().after(obs.getEffectiveDateTimeType())) {
                            p.setStartElement(obs.getEffectiveDateTimeType());
                        }
                        if (p.getEndElement().before(obs.getEffectiveDateTimeType())) {
                            p.setEndElement(obs.getEffectiveDateTimeType());
                        }
                        panel.setEffective(p);
                    }
                    this.saveResource(panel, "-res");
                }
            }
            if ((o = cda.getChild(c, "observation")) == null) continue;
            Observation obs = this.processObservation(cda, convert, context, o);
            list.addEntry().setItem(new Reference().setReference("Observation/" + obs.getId()));
        }
        this.saveResource(list, "-res");
    }

    private Observation processObservation(CDAUtilities cda, Convert convert, Context context, Element o) throws Exception {
        Element v;
        String type;
        Observation obs = new Observation();
        obs.setId(context.baseId + "-results-" + Integer.toString(context.obsId));
        ++context.obsId;
        obs.setSubject(context.subjectRef);
        obs.setContext(new Reference().setReference("Encounter/" + context.encounter.getId()));
        obs.setStatus(Observation.ObservationStatus.FINAL);
        obs.setEffective(convert.makeDateTimeFromTS(cda.getChild(o, "effectiveTime")));
        obs.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(o, "code")), null));
        obs.setInterpretation(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(o, "interpretationCode")), null));
        Element rr = cda.getChild(o, "referenceRange");
        if (rr != null) {
            obs.addReferenceRange().setText(cda.getChild(cda.getChild(rr, "observationRange"), "text").getTextContent());
        }
        if ("ST".equals(type = (v = cda.getChild(o, "value")).getAttribute("xsi:type"))) {
            obs.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/observation-daf-results-dafresultobsother");
            obs.setValue(new StringType(v.getTextContent()));
        } else if ("CD".equals(type)) {
            obs.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/observation-daf-results-dafresultobscode");
            obs.setValue(this.inspectCode(convert.makeCodeableConceptFromCD(v), null));
        } else if ("PQ".equals(type)) {
            obs.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/observation-daf-results-dafresultobsquantity");
            String va = cda.getChild(o, "value").getAttribute("value");
            if (!Utilities.isDecimal(va, true)) {
                obs.setDataAbsentReason(this.inspectCode(new CodeableConcept().setText(va), null));
            } else {
                obs.setValue(convert.makeQuantityFromPQ(cda.getChild(o, "value"), null));
            }
        } else {
            throw new Exception("Unknown type '" + type + "'");
        }
        for (Element e : cda.getChildren(o, "id")) {
            Identifier id = convert.makeIdentifierFromII(e);
            obs.getIdentifier().add(id);
        }
        this.saveResource(obs, "-gen");
        return obs;
    }

    private void processSocialHistorySection(CDAUtilities cda, Convert convert, Element section, Context context) throws Exception {
        this.scanSection("Social History", section);
        int i = 0;
        for (Element c : cda.getChildren(section, "entry")) {
            Element o = cda.getChild(c, "observation");
            Observation obs = new Observation();
            obs.setId(context.baseId + "-smoking-" + (i == 0 ? "" : Integer.toString(i)));
            obs.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/observation-daf-smokingstatus-dafsmokingstatus");
            ++i;
            obs.setSubject(context.subjectRef);
            obs.setContext(new Reference().setReference("Encounter/" + context.encounter.getId()));
            obs.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(o, "code")), new Coding().setSystem("http://loinc.org").setCode("72166-2")));
            boolean found = false;
            for (Element e : cda.getChildren(o, "id")) {
                Identifier id = convert.makeIdentifierFromII(e);
                obs.getIdentifier().add(convert.makeIdentifierFromII(e));
            }
            if (found) continue;
            obs.setStatus(Observation.ObservationStatus.FINAL);
            obs.setEffective(convert.makeDateTimeFromTS(cda.getChild(o, "effectiveTime")));
            obs.setValue(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(o, "value")), null));
            this.saveResource(obs, "-sh");
        }
    }

    private void processMedicationsSection(CDAUtilities cda, Convert convert, Element section, Context context) throws Exception {
        this.scanSection("Medications", section);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-medications");
        list.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/list-daf-dafmedicationlist");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(section, "code")), null));
        list.setTitle(cda.getChild(section, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        this.buildNarrative(list, cda.getChild(section, "text"));
        int i = 0;
        for (Element c : cda.getChildren(section, "entry")) {
            Element sa = cda.getChild(c, "substanceAdministration");
            MedicationStatement ms = new MedicationStatement();
            ms.setId(context.baseId + "-medication-" + Integer.toString(i));
            ms.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/medicationstatement-daf-dafmedicationstatement");
            ++i;
            ms.setSubject(context.subjectRef);
            boolean found = false;
            for (Element e : cda.getChildren(sa, "id")) {
                Identifier id = convert.makeIdentifierFromII(e);
                ms.getIdentifier().add(id);
            }
            if (found) continue;
            ms.setStatus(MedicationStatement.MedicationStatementStatus.COMPLETED);
            list.addEntry().setItem(new Reference().setReference("MedicationStatement/" + ms.getId()));
            Element mm3 = cda.getChild(cda.getChild(cda.getChild(sa, "consumable"), "manufacturedProduct"), "manufacturedMaterial");
            ms.setMedication(new Reference().setReference("#med"));
            Medication med = new Medication();
            med.setId("med");
            med.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(mm3, "code")), null));
            ms.getContained().add(med);
            Dosage dosage = ms.addDosage();
            Element qty = cda.getChild(sa, "doseQuantity");
            try {
                if (cda.getChild(qty, "low") != null) {
                    dosage.getExtension().add(new Extension().setUrl("http://healthintersections.com.au/fhir/extensions/medication-statement-range").setValue(convert.makeRangeFromIVLPQ(qty)));
                } else {
                    dosage.setDose(convert.makeQuantityFromPQ(qty));
                }
            }
            catch (Exception e) {
                System.out.println("  invalid dose quantity '" + qty.getAttribute("value") + " " + qty.getAttribute("unit") + "' (" + e.getClass().getName() + ") in " + context.baseId);
            }
            dosage.setRoute(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(sa, "routeCode")), null));
            Type t = convert.makeSomethingFromGTS(cda.getChildren(sa, "effectiveTime"));
            if (t instanceof Timing) {
                dosage.setTiming((Timing)t);
                if (dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasBounds()) {
                    ms.setEffective(dosage.getTiming().getRepeat().getBounds());
                }
            } else if (t instanceof Period) {
                ms.setEffective(t);
            } else {
                throw new Exception("Undecided how to handle " + t.getClass().getName());
            }
            for (Element e : cda.getChildren(sa, "author")) {
                if (ms.hasInformationSource()) {
                    throw new Error("additional author discovered");
                }
                Practitioner p = this.processPerformer(cda, convert, context, e, "assignedAuthor", "assignedPerson");
                Reference ref = new Reference().setReference("Practitioner/" + p.getId()).setDisplay(p.getUserString("display"));
                ms.setInformationSource(ref);
                ms.setDateAssertedElement(convert.makeDateTimeFromTS(cda.getChild(e, "time")));
            }
            this.saveResource(ms);
        }
        this.saveResource(list);
    }

    private void processEncountersSection(CDAUtilities cda, Convert convert, Element section, Context context) throws Exception {
        this.scanSection("Encounters", section);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-encounters");
        list.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/list-daf-dafencounterlist");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(section, "code")), null));
        list.setTitle(cda.getChild(section, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        this.buildNarrative(list, cda.getChild(section, "text"));
        int i = 0;
        for (Element c : cda.getChildren(section, "entry")) {
            Element ee = cda.getChild(c, "encounter");
            Encounter enc = new Encounter();
            enc.setId(context.baseId + "-encounter-" + Integer.toString(i));
            enc.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/encounter-daf-dafencounter");
            ++i;
            enc.setSubject(context.subjectRef);
            list.addEntry().setItem(new Reference().setReference("Encounter/" + enc.getId()));
            for (Element element : cda.getChildren(ee, "id")) {
                enc.getIdentifier().add(convert.makeIdentifierFromII(element));
            }
            this.checkGenerateIdentifier(enc.getIdentifier(), enc);
            enc.setPeriod(convert.makePeriodFromIVL(cda.getChild(ee, "effectiveTime")));
            if (enc.getPeriod().hasEnd()) {
                enc.setStatus(Encounter.EncounterStatus.FINISHED);
            } else {
                enc.setStatus(Encounter.EncounterStatus.INPROGRESS);
            }
            if (cda.getChild(ee, "text") != null) {
                enc.setClass_(this.convertTextToCoding(cda.getChild(ee, "text").getTextContent().trim()));
            } else {
                enc.setClass_(null);
            }
            CodeableConcept type = this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(ee, "code")), null);
            enc.addType(type);
            for (Element e3 : cda.getChildren(ee, "performer")) {
                Practitioner p = this.processPerformer(cda, convert, context, e3, "assignedEntity", "assignedPerson");
                Reference ref = new Reference().setReference("Practitioner/" + p.getId()).setDisplay(p.getUserString("display"));
                enc.addParticipant().setIndividual(ref).setPeriod(convert.makePeriodFromIVL(cda.getChild(e3, "time")));
            }
            enc.addLocation().setLocation(new Reference().setReference("#loc"));
            Location location = new Location();
            location.setId("loc");
            Element pr = cda.getChild(cda.getChild(ee, "participant"), "participantRole");
            location.setName(cda.getChild(cda.getChild(pr, "playingEntity"), "name").getTextContent());
            location.setType(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(pr, "code")), null));
            enc.getContained().add(location);
            this.saveResource(enc);
        }
        this.saveResource(list);
    }

    private Coding convertTextToCoding(String v) {
        if ((v = v.toLowerCase()).equals("inpatient")) {
            return new Coding().setSystem("http://hl7.org/fhir/v3/ActCode").setCode("IMP");
        }
        if (v.equals("emergency department") || v.equals("emergency department admit decision")) {
            return new Coding().setSystem("http://hl7.org/fhir/v3/ActCode").setCode("EMER");
        }
        if (v.equals("x-ray exam")) {
            return new Coding().setSystem("http://hl7.org/fhir/v3/ActCode").setCode("AMB");
        }
        if (v.equals("outpatient")) {
            return new Coding().setSystem("http://hl7.org/fhir/v3/ActCode").setCode("AMB");
        }
        throw new Error("unknown encounter type " + v);
    }

    private void processImmunizationsSection(CDAUtilities cda, Convert convert, Element section, Context context) throws Exception {
        this.scanSection("Immunizations", section);
        ListResource list = new ListResource();
        list.setId(context.baseId + "-list-immunizations");
        list.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/list-daf-dafimmunizationlist");
        list.setSubject(context.subjectRef);
        list.setCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(section, "code")), null));
        list.setTitle(cda.getChild(section, "title").getTextContent());
        list.setStatus(ListResource.ListStatus.CURRENT);
        list.setMode(ListResource.ListMode.SNAPSHOT);
        list.setDateElement(context.now);
        list.setSource(context.authorRef);
        this.buildNarrative(list, cda.getChild(section, "text"));
        int i = 0;
        for (Element c : cda.getChildren(section, "entry")) {
            Element mr;
            Element sa = cda.getChild(c, "substanceAdministration");
            Immunization imm = new Immunization();
            imm.setId(context.baseId + "-immunization-" + Integer.toString(i));
            imm.setUserData("profile", "http://hl7.org/fhir/StructureDefinition/immunization-daf-dafimmunization");
            ++i;
            imm.setPatient(context.subjectRef);
            imm.setEncounter(new Reference().setReference("Encounter/" + context.encounter.getId()));
            imm.setNotGiven("true".equals(sa.getAttribute("negationInd")));
            imm.setStatus(this.convertImmunizationStatus(cda.getChild(sa, "statusCode")));
            boolean found = false;
            for (Element e : cda.getChildren(sa, "id")) {
                Identifier id = convert.makeIdentifierFromII(e);
                imm.getIdentifier().add(id);
            }
            if (found) continue;
            list.addEntry().setItem(new Reference().setReference("Immunization/" + imm.getId()));
            imm.setDateElement(convert.makeDateTimeFromTS(cda.getChild(cda.getChild(sa, "effectiveTime"), "low")));
            if (imm.getNotGiven()) {
                Element reason = cda.getChild(cda.getChildByAttribute(sa, "entryRelationship", "typeCode", "RSON"), "observation");
                imm.setExplanation(new Immunization.ImmunizationExplanationComponent());
                imm.getExplanation().addReasonNotGiven(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(reason, "code")), null));
            }
            Element mm3 = cda.getChild(cda.getChild(cda.getChild(sa, "consumable"), "manufacturedProduct"), "manufacturedMaterial");
            imm.setVaccineCode(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(mm3, "code")), null));
            imm.setRoute(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(sa, "routeCode")), null));
            if (cda.getChild(mm3, "lotNumberText") != null) {
                imm.setLotNumber(cda.getChild(mm3, "lotNumberText").getTextContent());
            }
            if ((mr = cda.getChild(cda.getChild(cda.getChild(sa, "consumable"), "manufacturedProduct"), "manufacturerOrganization")) != null) {
                imm.setManufacturer(new Reference().setDisplay(cda.getChild(mr, "name").getTextContent()));
            }
            boolean hasprf = false;
            for (Element e : cda.getChildren(sa, "performer")) {
                if (imm.hasPractitioner()) {
                    throw new Error("additional performer discovered");
                }
                Practitioner p = this.processPerformer(cda, convert, context, e, "assignedEntity", "assignedPerson");
                Reference ref = new Reference().setReference("Practitioner/" + p.getId()).setDisplay(p.getUserString("display"));
                imm.addPractitioner().setActor(ref).setRole(new CodeableConcept().addCoding(new Coding().setSystem("http://hl7.org/fhir/v2/0443").setCode("AP")));
                hasprf = true;
            }
            imm.setPrimarySource(hasprf);
            this.saveResource(imm);
        }
        this.saveResource(list);
    }

    private Immunization.ImmunizationStatus convertImmunizationStatus(Element child) {
        String s2 = child.getAttribute("code");
        if (s2.equals("completed")) {
            return Immunization.ImmunizationStatus.COMPLETED;
        }
        throw new Error("Unexpected status " + s2);
    }

    private void makeBinary(String sourceFolder, String filename, Context context) throws Exception {
        Binary binary = new Binary();
        binary.setId(context.baseId + "-binary");
        binary.setContentType("application/hl7-v3+xml");
        binary.setContent(IOUtils.toByteArray(new FileInputStream(Utilities.path(sourceFolder, filename))));
        this.saveResource(binary);
    }

    private void makeDocumentReference(CDAUtilities cda, Convert convert, Element doc, Context context) throws Exception {
        this.scanSection("document", doc);
        DocumentReference ref = new DocumentReference();
        ref.setId(context.baseId + "-document");
        ref.setMasterIdentifier(convert.makeIdentifierFromII(cda.getChild(doc, "id")));
        ref.setSubject(context.subjectRef);
        ref.setType(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(doc, "code")), null));
        ref.addAuthor(context.authorRef);
        ref.setCreatedElement(convert.makeDateTimeFromTS(cda.getChild(doc, "effectiveTime")));
        ref.setIndexedElement(InstantType.now());
        ref.setStatus(Enumerations.DocumentReferenceStatus.CURRENT);
        ref.addSecurityLabel(this.inspectCode(convert.makeCodeableConceptFromCD(cda.getChild(doc, "confidentialityCode")), null));
        DocumentReference.DocumentReferenceContentComponent cnt = ref.addContent();
        cnt.getAttachment().setContentType("application/hl7-v3+xml").setUrl("Binary/" + context.baseId).setLanguage(this.convertLanguage(cda.getChild(doc, "language")));
        ref.setContext(new DocumentReference.DocumentReferenceContextComponent());
        ref.getContext().setPeriod(convert.makePeriodFromIVL(cda.getChild(cda.getChild(doc, "serviceEvent"), "effectiveTime")));
        for (CodeableConcept cc : context.encounter.getType()) {
            ref.getContext().addEvent(cc);
        }
        ref.setDescription(cda.getChild(doc, "title").getTextContent());
        ref.setCustodian(new Reference().setReference("Organization/" + this.processOrganization(cda.getDescendent(doc, "custodian/assignedCustodian/representedCustodianOrganization"), cda, convert, context).getId()));
        Practitioner p = this.processPerformer(cda, convert, context, cda.getChild(doc, "legalAuthenticator"), "assignedEntity", "assignedPerson");
        ref.setAuthenticator(new Reference().setReference("Practitioner/" + p.getId()).setDisplay(p.getUserString("display")));
        this.saveResource(ref);
    }

    private String convertLanguage(Element child) {
        if (child == null) {
            return null;
        }
        return child.getAttribute("code");
    }

    private CodeableConcept makeClassCode(CodeableConcept type, DocumentReference ref) throws Exception {
        CodeableConcept res = new CodeableConcept();
        String cs = type.getCoding().get(0).getCode();
        if (cs.equals("18842-5") || cs.equals("34133-9")) {
            return type;
        }
        if (!cs.equals("34111-5")) {
            throw new Exception("Uncategorised document type code: " + cs + ": " + type.getCoding().get(0).getDisplay());
        }
        ref.getFormatCommentsPre().add("The underlying CDA document has the code '34111-5: Evaluation and Management Note' which is incorrect (wrong display/code combination). The type has been preserved even though it's wrong");
        res.addCoding().setSystem("http://loinc.org").setCode("34109-9").setDisplay("Evaluation and management note");
        return res;
    }

    private void recordProcedureCode(CodeableConcept code) {
        for (Coding c : code.getCoding()) {
            this.count(c, this.procCodes);
        }
    }

    private void count(Coding c, Map<String, Integer> map) {
        String s2 = c.getSystem() + "::" + c.getCode();
        if (map.containsKey(s2)) {
            map.put(s2, map.get(s2) + 1);
        } else {
            map.put(s2, 1);
        }
    }

    private void recordConditionCode(CodeableConcept code) {
        for (Coding c : code.getCoding()) {
            this.count(c, this.condCodes);
        }
    }

    private void recordAllergyCode(CodeableConcept code) {
        for (Coding c : code.getCoding()) {
            this.count(c, this.allergyCodes);
        }
    }

    private void dumpCodes() {
        this.dump("Procedure Codes", this.procCodes);
        this.dump("Condition Codes", this.condCodes);
        this.dump("Allergy Codes", this.allergyCodes);
    }

    private void dump(String string, Map<String, Integer> map) {
        System.out.println(string);
        System.out.println("");
        for (String s2 : map.keySet()) {
            System.out.println(s2 + ": " + map.get(s2));
        }
        System.out.println("");
        System.out.println("");
    }

    public class Stats {
        public int instances;
        public int errors;
        public int warnings;
    }

    public class Context {
        public String baseId;
        public Reference authorRef;
        public Encounter encounter;
        public Coding encClass;
        public int obsId;
        public DateTimeType now = DateTimeType.now();
        public int orgId;
        public Reference subjectRef;
    }
}

