/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.VerificationResult;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.VerificationResult;

public class VerificationResult40_50
extends VersionConvertor_40_50 {
    public static VerificationResult convertVerificationResult(org.hl7.fhir.r4.model.VerificationResult src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VerificationResult tgt = new VerificationResult();
        VerificationResult40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Reference reference : src.getTarget()) {
            tgt.addTarget(VerificationResult40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getTargetLocation()) {
            tgt.getTargetLocation().add(VerificationResult40_50.convertString(stringType));
        }
        if (src.hasNeed()) {
            tgt.setNeed(VerificationResult40_50.convertCodeableConcept(src.getNeed()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VerificationResult40_50.convertStatus(src.getStatusElement()));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDateElement(VerificationResult40_50.convertDateTime(src.getStatusDateElement()));
        }
        if (src.hasValidationType()) {
            tgt.setValidationType(VerificationResult40_50.convertCodeableConcept(src.getValidationType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getValidationProcess()) {
            tgt.addValidationProcess(VerificationResult40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(VerificationResult40_50.convertTiming(src.getFrequency()));
        }
        if (src.hasLastPerformed()) {
            tgt.setLastPerformedElement(VerificationResult40_50.convertDateTime(src.getLastPerformedElement()));
        }
        if (src.hasNextScheduled()) {
            tgt.setNextScheduledElement(VerificationResult40_50.convertDate(src.getNextScheduledElement()));
        }
        if (src.hasFailureAction()) {
            tgt.setFailureAction(VerificationResult40_50.convertCodeableConcept(src.getFailureAction()));
        }
        for (VerificationResult.VerificationResultPrimarySourceComponent verificationResultPrimarySourceComponent : src.getPrimarySource()) {
            tgt.addPrimarySource(VerificationResult40_50.convertVerificationResultPrimarySourceComponent(verificationResultPrimarySourceComponent));
        }
        if (src.hasAttestation()) {
            tgt.setAttestation(VerificationResult40_50.convertVerificationResultAttestationComponent(src.getAttestation()));
        }
        for (VerificationResult.VerificationResultValidatorComponent verificationResultValidatorComponent : src.getValidator()) {
            tgt.addValidator(VerificationResult40_50.convertVerificationResultValidatorComponent(verificationResultValidatorComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.VerificationResult convertVerificationResult(VerificationResult src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.VerificationResult tgt = new org.hl7.fhir.r4.model.VerificationResult();
        VerificationResult40_50.copyDomainResource(src, tgt);
        for (Reference reference : src.getTarget()) {
            tgt.addTarget(VerificationResult40_50.convertReference(reference));
        }
        for (StringType stringType : src.getTargetLocation()) {
            tgt.getTargetLocation().add(VerificationResult40_50.convertString(stringType));
        }
        if (src.hasNeed()) {
            tgt.setNeed(VerificationResult40_50.convertCodeableConcept(src.getNeed()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VerificationResult40_50.convertStatus(src.getStatusElement()));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDateElement(VerificationResult40_50.convertDateTime(src.getStatusDateElement()));
        }
        if (src.hasValidationType()) {
            tgt.setValidationType(VerificationResult40_50.convertCodeableConcept(src.getValidationType()));
        }
        for (CodeableConcept codeableConcept : src.getValidationProcess()) {
            tgt.addValidationProcess(VerificationResult40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(VerificationResult40_50.convertTiming(src.getFrequency()));
        }
        if (src.hasLastPerformed()) {
            tgt.setLastPerformedElement(VerificationResult40_50.convertDateTime(src.getLastPerformedElement()));
        }
        if (src.hasNextScheduled()) {
            tgt.setNextScheduledElement(VerificationResult40_50.convertDate(src.getNextScheduledElement()));
        }
        if (src.hasFailureAction()) {
            tgt.setFailureAction(VerificationResult40_50.convertCodeableConcept(src.getFailureAction()));
        }
        for (VerificationResult.VerificationResultPrimarySourceComponent verificationResultPrimarySourceComponent : src.getPrimarySource()) {
            tgt.addPrimarySource(VerificationResult40_50.convertVerificationResultPrimarySourceComponent(verificationResultPrimarySourceComponent));
        }
        if (src.hasAttestation()) {
            tgt.setAttestation(VerificationResult40_50.convertVerificationResultAttestationComponent(src.getAttestation()));
        }
        for (VerificationResult.VerificationResultValidatorComponent verificationResultValidatorComponent : src.getValidator()) {
            tgt.addValidator(VerificationResult40_50.convertVerificationResultValidatorComponent(verificationResultValidatorComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<VerificationResult.Status> convertStatus(Enumeration<VerificationResult.Status> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<VerificationResult.Status> tgt = new org.hl7.fhir.r5.model.Enumeration<VerificationResult.Status>(new VerificationResult.StatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((VerificationResult.Status)((Object)src.getValue())) {
            case ATTESTED: {
                tgt.setValue((Object)VerificationResult.Status.ATTESTED);
                break;
            }
            case VALIDATED: {
                tgt.setValue((Object)VerificationResult.Status.VALIDATED);
                break;
            }
            case INPROCESS: {
                tgt.setValue((Object)VerificationResult.Status.INPROCESS);
                break;
            }
            case REQREVALID: {
                tgt.setValue((Object)VerificationResult.Status.REQREVALID);
                break;
            }
            case VALFAIL: {
                tgt.setValue((Object)VerificationResult.Status.VALFAIL);
                break;
            }
            case REVALFAIL: {
                tgt.setValue((Object)VerificationResult.Status.REVALFAIL);
                break;
            }
            default: {
                tgt.setValue((Object)VerificationResult.Status.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<VerificationResult.Status> convertStatus(org.hl7.fhir.r5.model.Enumeration<VerificationResult.Status> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<VerificationResult.Status> tgt = new Enumeration<VerificationResult.Status>(new VerificationResult.StatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((VerificationResult.Status)((Object)src.getValue())) {
            case ATTESTED: {
                tgt.setValue((Object)VerificationResult.Status.ATTESTED);
                break;
            }
            case VALIDATED: {
                tgt.setValue((Object)VerificationResult.Status.VALIDATED);
                break;
            }
            case INPROCESS: {
                tgt.setValue((Object)VerificationResult.Status.INPROCESS);
                break;
            }
            case REQREVALID: {
                tgt.setValue((Object)VerificationResult.Status.REQREVALID);
                break;
            }
            case VALFAIL: {
                tgt.setValue((Object)VerificationResult.Status.VALFAIL);
                break;
            }
            case REVALFAIL: {
                tgt.setValue((Object)VerificationResult.Status.REVALFAIL);
                break;
            }
            default: {
                tgt.setValue((Object)VerificationResult.Status.NULL);
            }
        }
        return tgt;
    }

    public static VerificationResult.VerificationResultPrimarySourceComponent convertVerificationResultPrimarySourceComponent(VerificationResult.VerificationResultPrimarySourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VerificationResult.VerificationResultPrimarySourceComponent tgt = new VerificationResult.VerificationResultPrimarySourceComponent();
        VerificationResult40_50.copyElement(src, tgt, new String[0]);
        if (src.hasWho()) {
            tgt.setWho(VerificationResult40_50.convertReference(src.getWho()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(VerificationResult40_50.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getCommunicationMethod()) {
            tgt.addCommunicationMethod(VerificationResult40_50.convertCodeableConcept(t));
        }
        if (src.hasValidationStatus()) {
            tgt.setValidationStatus(VerificationResult40_50.convertCodeableConcept(src.getValidationStatus()));
        }
        if (src.hasValidationDate()) {
            tgt.setValidationDateElement(VerificationResult40_50.convertDateTime(src.getValidationDateElement()));
        }
        if (src.hasCanPushUpdates()) {
            tgt.setCanPushUpdates(VerificationResult40_50.convertCodeableConcept(src.getCanPushUpdates()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getPushTypeAvailable()) {
            tgt.addPushTypeAvailable(VerificationResult40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static VerificationResult.VerificationResultPrimarySourceComponent convertVerificationResultPrimarySourceComponent(VerificationResult.VerificationResultPrimarySourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VerificationResult.VerificationResultPrimarySourceComponent tgt = new VerificationResult.VerificationResultPrimarySourceComponent();
        VerificationResult40_50.copyElement(src, tgt, new String[0]);
        if (src.hasWho()) {
            tgt.setWho(VerificationResult40_50.convertReference(src.getWho()));
        }
        for (CodeableConcept t : src.getType()) {
            tgt.addType(VerificationResult40_50.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getCommunicationMethod()) {
            tgt.addCommunicationMethod(VerificationResult40_50.convertCodeableConcept(t));
        }
        if (src.hasValidationStatus()) {
            tgt.setValidationStatus(VerificationResult40_50.convertCodeableConcept(src.getValidationStatus()));
        }
        if (src.hasValidationDate()) {
            tgt.setValidationDateElement(VerificationResult40_50.convertDateTime(src.getValidationDateElement()));
        }
        if (src.hasCanPushUpdates()) {
            tgt.setCanPushUpdates(VerificationResult40_50.convertCodeableConcept(src.getCanPushUpdates()));
        }
        for (CodeableConcept t : src.getPushTypeAvailable()) {
            tgt.addPushTypeAvailable(VerificationResult40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static VerificationResult.VerificationResultAttestationComponent convertVerificationResultAttestationComponent(VerificationResult.VerificationResultAttestationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VerificationResult.VerificationResultAttestationComponent tgt = new VerificationResult.VerificationResultAttestationComponent();
        VerificationResult40_50.copyElement(src, tgt, new String[0]);
        if (src.hasWho()) {
            tgt.setWho(VerificationResult40_50.convertReference(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VerificationResult40_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasCommunicationMethod()) {
            tgt.setCommunicationMethod(VerificationResult40_50.convertCodeableConcept(src.getCommunicationMethod()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VerificationResult40_50.convertDate(src.getDateElement()));
        }
        if (src.hasSourceIdentityCertificate()) {
            tgt.setSourceIdentityCertificateElement(VerificationResult40_50.convertString(src.getSourceIdentityCertificateElement()));
        }
        if (src.hasProxyIdentityCertificate()) {
            tgt.setProxyIdentityCertificateElement(VerificationResult40_50.convertString(src.getProxyIdentityCertificateElement()));
        }
        if (src.hasProxySignature()) {
            tgt.setProxySignature(VerificationResult40_50.convertSignature(src.getProxySignature()));
        }
        if (src.hasSourceSignature()) {
            tgt.setSourceSignature(VerificationResult40_50.convertSignature(src.getSourceSignature()));
        }
        return tgt;
    }

    public static VerificationResult.VerificationResultAttestationComponent convertVerificationResultAttestationComponent(VerificationResult.VerificationResultAttestationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VerificationResult.VerificationResultAttestationComponent tgt = new VerificationResult.VerificationResultAttestationComponent();
        VerificationResult40_50.copyElement(src, tgt, new String[0]);
        if (src.hasWho()) {
            tgt.setWho(VerificationResult40_50.convertReference(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VerificationResult40_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasCommunicationMethod()) {
            tgt.setCommunicationMethod(VerificationResult40_50.convertCodeableConcept(src.getCommunicationMethod()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VerificationResult40_50.convertDate(src.getDateElement()));
        }
        if (src.hasSourceIdentityCertificate()) {
            tgt.setSourceIdentityCertificateElement(VerificationResult40_50.convertString(src.getSourceIdentityCertificateElement()));
        }
        if (src.hasProxyIdentityCertificate()) {
            tgt.setProxyIdentityCertificateElement(VerificationResult40_50.convertString(src.getProxyIdentityCertificateElement()));
        }
        if (src.hasProxySignature()) {
            tgt.setProxySignature(VerificationResult40_50.convertSignature(src.getProxySignature()));
        }
        if (src.hasSourceSignature()) {
            tgt.setSourceSignature(VerificationResult40_50.convertSignature(src.getSourceSignature()));
        }
        return tgt;
    }

    public static VerificationResult.VerificationResultValidatorComponent convertVerificationResultValidatorComponent(VerificationResult.VerificationResultValidatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VerificationResult.VerificationResultValidatorComponent tgt = new VerificationResult.VerificationResultValidatorComponent();
        VerificationResult40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOrganization()) {
            tgt.setOrganization(VerificationResult40_50.convertReference(src.getOrganization()));
        }
        if (src.hasIdentityCertificate()) {
            tgt.setIdentityCertificateElement(VerificationResult40_50.convertString(src.getIdentityCertificateElement()));
        }
        if (src.hasAttestationSignature()) {
            tgt.setAttestationSignature(VerificationResult40_50.convertSignature(src.getAttestationSignature()));
        }
        return tgt;
    }

    public static VerificationResult.VerificationResultValidatorComponent convertVerificationResultValidatorComponent(VerificationResult.VerificationResultValidatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VerificationResult.VerificationResultValidatorComponent tgt = new VerificationResult.VerificationResultValidatorComponent();
        VerificationResult40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOrganization()) {
            tgt.setOrganization(VerificationResult40_50.convertReference(src.getOrganization()));
        }
        if (src.hasIdentityCertificate()) {
            tgt.setIdentityCertificateElement(VerificationResult40_50.convertString(src.getIdentityCertificateElement()));
        }
        if (src.hasAttestationSignature()) {
            tgt.setAttestationSignature(VerificationResult40_50.convertSignature(src.getAttestationSignature()));
        }
        return tgt;
    }
}

