/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.TestReport;
import org.hl7.fhir.r5.model.TestReport;

public class TestReport40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.TestReport convertTestReport(TestReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.TestReport tgt = new org.hl7.fhir.r5.model.TestReport();
        TestReport40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(TestReport40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasName()) {
            tgt.setNameElement(TestReport40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(TestReport40_50.convertTestReportStatus(src.getStatusElement()));
        }
        if (src.hasTestScript()) {
            tgt.setTestScript(TestReport40_50.convertReference(src.getTestScript()));
        }
        if (src.hasResult()) {
            tgt.setResultElement(TestReport40_50.convertTestReportResult(src.getResultElement()));
        }
        if (src.hasScore()) {
            tgt.setScoreElement(TestReport40_50.convertDecimal(src.getScoreElement()));
        }
        if (src.hasTester()) {
            tgt.setTesterElement(TestReport40_50.convertString(src.getTesterElement()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(TestReport40_50.convertDateTime(src.getIssuedElement()));
        }
        for (TestReport.TestReportParticipantComponent testReportParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(TestReport40_50.convertTestReportParticipantComponent(testReportParticipantComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestReport40_50.convertTestReportSetupComponent(src.getSetup()));
        }
        for (TestReport.TestReportTestComponent testReportTestComponent : src.getTest()) {
            tgt.addTest(TestReport40_50.convertTestReportTestComponent(testReportTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestReport40_50.convertTestReportTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static TestReport convertTestReport(org.hl7.fhir.r5.model.TestReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport tgt = new TestReport();
        TestReport40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(TestReport40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasName()) {
            tgt.setNameElement(TestReport40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(TestReport40_50.convertTestReportStatus(src.getStatusElement()));
        }
        if (src.hasTestScript()) {
            tgt.setTestScript(TestReport40_50.convertReference(src.getTestScript()));
        }
        if (src.hasResult()) {
            tgt.setResultElement(TestReport40_50.convertTestReportResult(src.getResultElement()));
        }
        if (src.hasScore()) {
            tgt.setScoreElement(TestReport40_50.convertDecimal(src.getScoreElement()));
        }
        if (src.hasTester()) {
            tgt.setTesterElement(TestReport40_50.convertString(src.getTesterElement()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(TestReport40_50.convertDateTime(src.getIssuedElement()));
        }
        for (TestReport.TestReportParticipantComponent testReportParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(TestReport40_50.convertTestReportParticipantComponent(testReportParticipantComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestReport40_50.convertTestReportSetupComponent(src.getSetup()));
        }
        for (TestReport.TestReportTestComponent testReportTestComponent : src.getTest()) {
            tgt.addTest(TestReport40_50.convertTestReportTestComponent(testReportTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestReport40_50.convertTestReportTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportStatus> convertTestReportStatus(Enumeration<TestReport.TestReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportStatus>(new TestReport.TestReportStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)TestReport.TestReportStatus.COMPLETED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)TestReport.TestReportStatus.INPROGRESS);
                break;
            }
            case WAITING: {
                tgt.setValue((Object)TestReport.TestReportStatus.WAITING);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)TestReport.TestReportStatus.STOPPED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)TestReport.TestReportStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportStatus> convertTestReportStatus(org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportStatus> tgt = new Enumeration<TestReport.TestReportStatus>(new TestReport.TestReportStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)TestReport.TestReportStatus.COMPLETED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)TestReport.TestReportStatus.INPROGRESS);
                break;
            }
            case WAITING: {
                tgt.setValue((Object)TestReport.TestReportStatus.WAITING);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)TestReport.TestReportStatus.STOPPED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)TestReport.TestReportStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportResult> convertTestReportResult(Enumeration<TestReport.TestReportResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportResult> tgt = new org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportResult>(new TestReport.TestReportResultEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportResult.PASS);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportResult.FAIL);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)TestReport.TestReportResult.PENDING);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportResult.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportResult> convertTestReportResult(org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportResult> tgt = new Enumeration<TestReport.TestReportResult>(new TestReport.TestReportResultEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportResult.PASS);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportResult.FAIL);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)TestReport.TestReportResult.PENDING);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportResult.NULL);
            }
        }
        return tgt;
    }

    public static TestReport.TestReportParticipantComponent convertTestReportParticipantComponent(TestReport.TestReportParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportParticipantComponent tgt = new TestReport.TestReportParticipantComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(TestReport40_50.convertTestReportParticipantType(src.getTypeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(TestReport40_50.convertUri(src.getUriElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(TestReport40_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static TestReport.TestReportParticipantComponent convertTestReportParticipantComponent(TestReport.TestReportParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportParticipantComponent tgt = new TestReport.TestReportParticipantComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(TestReport40_50.convertTestReportParticipantType(src.getTypeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(TestReport40_50.convertUri(src.getUriElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(TestReport40_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportParticipantType> convertTestReportParticipantType(Enumeration<TestReport.TestReportParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportParticipantType> tgt = new org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportParticipantType>(new TestReport.TestReportParticipantTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportParticipantType)((Object)src.getValue())) {
            case TESTENGINE: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.TESTENGINE);
                break;
            }
            case CLIENT: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportParticipantType> convertTestReportParticipantType(org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportParticipantType> tgt = new Enumeration<TestReport.TestReportParticipantType>(new TestReport.TestReportParticipantTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportParticipantType)((Object)src.getValue())) {
            case TESTENGINE: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.TESTENGINE);
                break;
            }
            case CLIENT: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static TestReport.TestReportSetupComponent convertTestReportSetupComponent(TestReport.TestReportSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportSetupComponent tgt = new TestReport.TestReportSetupComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        for (TestReport.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestReport40_50.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestReportSetupComponent convertTestReportSetupComponent(TestReport.TestReportSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportSetupComponent tgt = new TestReport.TestReportSetupComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        for (TestReport.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestReport40_50.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.SetupActionComponent convertSetupActionComponent(TestReport.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionComponent tgt = new TestReport.SetupActionComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestReport40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestReport40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.SetupActionComponent convertSetupActionComponent(TestReport.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionComponent tgt = new TestReport.SetupActionComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestReport40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestReport40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.SetupActionOperationComponent convertSetupActionOperationComponent(TestReport.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionOperationComponent tgt = new TestReport.SetupActionOperationComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(TestReport40_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(TestReport40_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(TestReport40_50.convertUri(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.SetupActionOperationComponent convertSetupActionOperationComponent(TestReport.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionOperationComponent tgt = new TestReport.SetupActionOperationComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(TestReport40_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(TestReport40_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(TestReport40_50.convertUri(src.getDetailElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult> convertTestReportActionResult(Enumeration<TestReport.TestReportActionResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult> tgt = new org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult>(new TestReport.TestReportActionResultEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportActionResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportActionResult.PASS);
                break;
            }
            case SKIP: {
                tgt.setValue((Object)TestReport.TestReportActionResult.SKIP);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportActionResult.FAIL);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)TestReport.TestReportActionResult.WARNING);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)TestReport.TestReportActionResult.ERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportActionResult> convertTestReportActionResult(org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportActionResult> tgt = new Enumeration<TestReport.TestReportActionResult>(new TestReport.TestReportActionResultEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportActionResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportActionResult.PASS);
                break;
            }
            case SKIP: {
                tgt.setValue((Object)TestReport.TestReportActionResult.SKIP);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportActionResult.FAIL);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)TestReport.TestReportActionResult.WARNING);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)TestReport.TestReportActionResult.ERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
            }
        }
        return tgt;
    }

    public static TestReport.SetupActionAssertComponent convertSetupActionAssertComponent(TestReport.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionAssertComponent tgt = new TestReport.SetupActionAssertComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(TestReport40_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(TestReport40_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(TestReport40_50.convertString(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.SetupActionAssertComponent convertSetupActionAssertComponent(TestReport.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionAssertComponent tgt = new TestReport.SetupActionAssertComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(TestReport40_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(TestReport40_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(TestReport40_50.convertString(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.TestReportTestComponent convertTestReportTestComponent(TestReport.TestReportTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTestComponent tgt = new TestReport.TestReportTestComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TestReport40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestReport40_50.convertString(src.getDescriptionElement()));
        }
        for (TestReport.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestReport40_50.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestReportTestComponent convertTestReportTestComponent(TestReport.TestReportTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTestComponent tgt = new TestReport.TestReportTestComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TestReport40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestReport40_50.convertString(src.getDescriptionElement()));
        }
        for (TestReport.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestReport40_50.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestActionComponent convertTestActionComponent(TestReport.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestActionComponent tgt = new TestReport.TestActionComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestReport40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestReport40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.TestActionComponent convertTestActionComponent(TestReport.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestActionComponent tgt = new TestReport.TestActionComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestReport40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestReport40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.TestReportTeardownComponent convertTestReportTeardownComponent(TestReport.TestReportTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTeardownComponent tgt = new TestReport.TestReportTeardownComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        for (TestReport.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestReport40_50.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestReportTeardownComponent convertTestReportTeardownComponent(TestReport.TestReportTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTeardownComponent tgt = new TestReport.TestReportTeardownComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        for (TestReport.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestReport40_50.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TeardownActionComponent convertTeardownActionComponent(TestReport.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TeardownActionComponent tgt = new TestReport.TeardownActionComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestReport40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestReport.TeardownActionComponent convertTeardownActionComponent(TestReport.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TeardownActionComponent tgt = new TestReport.TeardownActionComponent();
        TestReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestReport40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }
}

