/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Task;

public class Task40_50
extends VersionConvertor_40_50 {
    public static Task convertTask(org.hl7.fhir.r4.model.Task src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Task tgt = new Task();
        Task40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Task40_50.convertIdentifier(identifier));
        }
        if (src.hasInstantiatesCanonical()) {
            tgt.setInstantiatesCanonicalElement(Task40_50.convertCanonical(src.getInstantiatesCanonicalElement()));
        }
        if (src.hasInstantiatesUri()) {
            tgt.setInstantiatesUriElement(Task40_50.convertUri(src.getInstantiatesUriElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Task40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(Task40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(Task40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Task40_50.convertTaskStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Task40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasBusinessStatus()) {
            tgt.setBusinessStatus(Task40_50.convertCodeableConcept(src.getBusinessStatus()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(Task40_50.convertTaskIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Task40_50.convertTaskPriority(src.getPriorityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(Task40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Task40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasFocus()) {
            tgt.setFocus(Task40_50.convertReference(src.getFocus()));
        }
        if (src.hasFor()) {
            tgt.setFor(Task40_50.convertReference(src.getFor()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Task40_50.convertReference(src.getEncounter()));
        }
        if (src.hasExecutionPeriod()) {
            tgt.setExecutionPeriod(Task40_50.convertPeriod(src.getExecutionPeriod()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(Task40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasLastModified()) {
            tgt.setLastModifiedElement(Task40_50.convertDateTime(src.getLastModifiedElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(Task40_50.convertReference(src.getRequester()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getPerformerType()) {
            tgt.addPerformerType(Task40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Task40_50.convertReference(src.getOwner()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Task40_50.convertReference(src.getLocation()));
        }
        if (src.hasReasonCode()) {
            tgt.setReasonCode(Task40_50.convertCodeableConcept(src.getReasonCode()));
        }
        if (src.hasReasonReference()) {
            tgt.setReasonReference(Task40_50.convertReference(src.getReasonReference()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getInsurance()) {
            tgt.addInsurance(Task40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Task40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(Task40_50.convertReference(reference));
        }
        if (src.hasRestriction()) {
            tgt.setRestriction(Task40_50.convertTaskRestrictionComponent(src.getRestriction()));
        }
        for (Task.ParameterComponent parameterComponent : src.getInput()) {
            tgt.addInput(Task40_50.convertParameterComponent(parameterComponent));
        }
        for (Task.TaskOutputComponent taskOutputComponent : src.getOutput()) {
            tgt.addOutput(Task40_50.convertTaskOutputComponent(taskOutputComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Task convertTask(Task src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Task tgt = new org.hl7.fhir.r4.model.Task();
        Task40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Task40_50.convertIdentifier(identifier));
        }
        if (src.hasInstantiatesCanonical()) {
            tgt.setInstantiatesCanonicalElement(Task40_50.convertCanonical(src.getInstantiatesCanonicalElement()));
        }
        if (src.hasInstantiatesUri()) {
            tgt.setInstantiatesUriElement(Task40_50.convertUri(src.getInstantiatesUriElement()));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Task40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(Task40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(Task40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Task40_50.convertTaskStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Task40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasBusinessStatus()) {
            tgt.setBusinessStatus(Task40_50.convertCodeableConcept(src.getBusinessStatus()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(Task40_50.convertTaskIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Task40_50.convertTaskPriority(src.getPriorityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(Task40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Task40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasFocus()) {
            tgt.setFocus(Task40_50.convertReference(src.getFocus()));
        }
        if (src.hasFor()) {
            tgt.setFor(Task40_50.convertReference(src.getFor()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Task40_50.convertReference(src.getEncounter()));
        }
        if (src.hasExecutionPeriod()) {
            tgt.setExecutionPeriod(Task40_50.convertPeriod(src.getExecutionPeriod()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(Task40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasLastModified()) {
            tgt.setLastModifiedElement(Task40_50.convertDateTime(src.getLastModifiedElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(Task40_50.convertReference(src.getRequester()));
        }
        for (CodeableConcept codeableConcept : src.getPerformerType()) {
            tgt.addPerformerType(Task40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Task40_50.convertReference(src.getOwner()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Task40_50.convertReference(src.getLocation()));
        }
        if (src.hasReasonCode()) {
            tgt.setReasonCode(Task40_50.convertCodeableConcept(src.getReasonCode()));
        }
        if (src.hasReasonReference()) {
            tgt.setReasonReference(Task40_50.convertReference(src.getReasonReference()));
        }
        for (Reference reference : src.getInsurance()) {
            tgt.addInsurance(Task40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Task40_50.convertAnnotation(annotation));
        }
        for (Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(Task40_50.convertReference(reference));
        }
        if (src.hasRestriction()) {
            tgt.setRestriction(Task40_50.convertTaskRestrictionComponent(src.getRestriction()));
        }
        for (Task.ParameterComponent parameterComponent : src.getInput()) {
            tgt.addInput(Task40_50.convertParameterComponent(parameterComponent));
        }
        for (Task.TaskOutputComponent taskOutputComponent : src.getOutput()) {
            tgt.addOutput(Task40_50.convertTaskOutputComponent(taskOutputComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Task.TaskStatus> convertTaskStatus(Enumeration<Task.TaskStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Task.TaskStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Task.TaskStatus>(new Task.TaskStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Task.TaskStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Task.TaskStatus.DRAFT);
                break;
            }
            case REQUESTED: {
                tgt.setValue((Object)Task.TaskStatus.REQUESTED);
                break;
            }
            case RECEIVED: {
                tgt.setValue((Object)Task.TaskStatus.RECEIVED);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)Task.TaskStatus.ACCEPTED);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Task.TaskStatus.REJECTED);
                break;
            }
            case READY: {
                tgt.setValue((Object)Task.TaskStatus.READY);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Task.TaskStatus.CANCELLED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Task.TaskStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Task.TaskStatus.ONHOLD);
                break;
            }
            case FAILED: {
                tgt.setValue((Object)Task.TaskStatus.FAILED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Task.TaskStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Task.TaskStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Task.TaskStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Task.TaskStatus> convertTaskStatus(org.hl7.fhir.r5.model.Enumeration<Task.TaskStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Task.TaskStatus> tgt = new Enumeration<Task.TaskStatus>(new Task.TaskStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Task.TaskStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Task.TaskStatus.DRAFT);
                break;
            }
            case REQUESTED: {
                tgt.setValue((Object)Task.TaskStatus.REQUESTED);
                break;
            }
            case RECEIVED: {
                tgt.setValue((Object)Task.TaskStatus.RECEIVED);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)Task.TaskStatus.ACCEPTED);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Task.TaskStatus.REJECTED);
                break;
            }
            case READY: {
                tgt.setValue((Object)Task.TaskStatus.READY);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Task.TaskStatus.CANCELLED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Task.TaskStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Task.TaskStatus.ONHOLD);
                break;
            }
            case FAILED: {
                tgt.setValue((Object)Task.TaskStatus.FAILED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Task.TaskStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Task.TaskStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Task.TaskStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Task.TaskIntent> convertTaskIntent(Enumeration<Task.TaskIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Task.TaskIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<Task.TaskIntent>(new Task.TaskIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Task.TaskIntent)((Object)src.getValue())) {
            case UNKNOWN: {
                tgt.setValue((Object)Task.TaskIntent.UNKNOWN);
                break;
            }
            case PROPOSAL: {
                tgt.setValue((Object)Task.TaskIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)Task.TaskIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)Task.TaskIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)Task.TaskIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)Task.TaskIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)Task.TaskIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)Task.TaskIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)Task.TaskIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)Task.TaskIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Task.TaskIntent> convertTaskIntent(org.hl7.fhir.r5.model.Enumeration<Task.TaskIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Task.TaskIntent> tgt = new Enumeration<Task.TaskIntent>(new Task.TaskIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Task.TaskIntent)((Object)src.getValue())) {
            case UNKNOWN: {
                tgt.setValue((Object)Task.TaskIntent.UNKNOWN);
                break;
            }
            case PROPOSAL: {
                tgt.setValue((Object)Task.TaskIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)Task.TaskIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)Task.TaskIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)Task.TaskIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)Task.TaskIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)Task.TaskIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)Task.TaskIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)Task.TaskIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)Task.TaskIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertTaskPriority(Enumeration<Task.TaskPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Task.TaskPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Task.TaskPriority> convertTaskPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Task.TaskPriority> tgt = new Enumeration<Task.TaskPriority>(new Task.TaskPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Task.TaskPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Task.TaskPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Task.TaskPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Task.TaskPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Task.TaskPriority.NULL);
            }
        }
        return tgt;
    }

    public static Task.TaskRestrictionComponent convertTaskRestrictionComponent(Task.TaskRestrictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Task.TaskRestrictionComponent tgt = new Task.TaskRestrictionComponent();
        Task40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRepetitions()) {
            tgt.setRepetitionsElement(Task40_50.convertPositiveInt(src.getRepetitionsElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Task40_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getRecipient()) {
            tgt.addRecipient(Task40_50.convertReference(t));
        }
        return tgt;
    }

    public static Task.TaskRestrictionComponent convertTaskRestrictionComponent(Task.TaskRestrictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Task.TaskRestrictionComponent tgt = new Task.TaskRestrictionComponent();
        Task40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRepetitions()) {
            tgt.setRepetitionsElement(Task40_50.convertPositiveInt(src.getRepetitionsElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Task40_50.convertPeriod(src.getPeriod()));
        }
        for (Reference t : src.getRecipient()) {
            tgt.addRecipient(Task40_50.convertReference(t));
        }
        return tgt;
    }

    public static Task.ParameterComponent convertParameterComponent(Task.ParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Task.ParameterComponent tgt = new Task.ParameterComponent();
        Task40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Task40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(Task40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Task.ParameterComponent convertParameterComponent(Task.ParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Task.ParameterComponent tgt = new Task.ParameterComponent();
        Task40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Task40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(Task40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Task.TaskOutputComponent convertTaskOutputComponent(Task.TaskOutputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Task.TaskOutputComponent tgt = new Task.TaskOutputComponent();
        Task40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Task40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(Task40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Task.TaskOutputComponent convertTaskOutputComponent(Task.TaskOutputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Task.TaskOutputComponent tgt = new Task.TaskOutputComponent();
        Task40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Task40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(Task40_50.convertType(src.getValue()));
        }
        return tgt;
    }
}

