/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.SupplyRequest;

public class SupplyRequest40_50
extends VersionConvertor_40_50 {
    public static SupplyRequest convertSupplyRequest(org.hl7.fhir.r4.model.SupplyRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyRequest tgt = new SupplyRequest();
        SupplyRequest40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(SupplyRequest40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyRequest40_50.convertSupplyRequestStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(SupplyRequest40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(SupplyRequest40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.hasItem()) {
            if (src.hasItemCodeableConcept()) {
                tgt.getItem().setConcept(SupplyRequest40_50.convertCodeableConcept(src.getItemCodeableConcept()));
            } else {
                tgt.getItem().setReference(SupplyRequest40_50.convertReference(src.getItemReference()));
            }
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(SupplyRequest40_50.convertQuantity(src.getQuantity()));
        }
        for (SupplyRequest.SupplyRequestParameterComponent supplyRequestParameterComponent : src.getParameter()) {
            tgt.addParameter(SupplyRequest40_50.convertSupplyRequestParameterComponent(supplyRequestParameterComponent));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(SupplyRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(SupplyRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(SupplyRequest40_50.convertReference(src.getRequester()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupplier()) {
            tgt.addSupplier(SupplyRequest40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(SupplyRequest40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(SupplyRequest40_50.convertReferenceToCodeableReference(reference));
        }
        if (src.hasDeliverFrom()) {
            tgt.setDeliverFrom(SupplyRequest40_50.convertReference(src.getDeliverFrom()));
        }
        if (src.hasDeliverTo()) {
            tgt.setDeliverTo(SupplyRequest40_50.convertReference(src.getDeliverTo()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.SupplyRequest convertSupplyRequest(SupplyRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.SupplyRequest tgt = new org.hl7.fhir.r4.model.SupplyRequest();
        SupplyRequest40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(SupplyRequest40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyRequest40_50.convertSupplyRequestStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(SupplyRequest40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(SupplyRequest40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.hasItem()) {
            if (src.getItem().hasReference()) {
                tgt.setItem(SupplyRequest40_50.convertType(src.getItem().getReference()));
            } else {
                tgt.setItem(SupplyRequest40_50.convertType(src.getItem().getConcept()));
            }
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(SupplyRequest40_50.convertQuantity(src.getQuantity()));
        }
        for (SupplyRequest.SupplyRequestParameterComponent supplyRequestParameterComponent : src.getParameter()) {
            tgt.addParameter(SupplyRequest40_50.convertSupplyRequestParameterComponent(supplyRequestParameterComponent));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(SupplyRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(SupplyRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(SupplyRequest40_50.convertReference(src.getRequester()));
        }
        for (Reference reference : src.getSupplier()) {
            tgt.addSupplier(SupplyRequest40_50.convertReference(reference));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(SupplyRequest40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(SupplyRequest40_50.convertReference(codeableReference.getReference()));
        }
        if (src.hasDeliverFrom()) {
            tgt.setDeliverFrom(SupplyRequest40_50.convertReference(src.getDeliverFrom()));
        }
        if (src.hasDeliverTo()) {
            tgt.setDeliverTo(SupplyRequest40_50.convertReference(src.getDeliverTo()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus> convertSupplyRequestStatus(Enumeration<SupplyRequest.SupplyRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus>(new SupplyRequest.SupplyRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyRequest.SupplyRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.SUSPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SupplyRequest.SupplyRequestStatus> convertSupplyRequestStatus(org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SupplyRequest.SupplyRequestStatus> tgt = new Enumeration<SupplyRequest.SupplyRequestStatus>(new SupplyRequest.SupplyRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyRequest.SupplyRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.SUSPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertRequestPriority(Enumeration<SupplyRequest.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyRequest.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SupplyRequest.RequestPriority> convertRequestPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SupplyRequest.RequestPriority> tgt = new Enumeration<SupplyRequest.RequestPriority>(new SupplyRequest.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)SupplyRequest.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)SupplyRequest.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)SupplyRequest.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)SupplyRequest.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyRequest.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static SupplyRequest.SupplyRequestParameterComponent convertSupplyRequestParameterComponent(SupplyRequest.SupplyRequestParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyRequest.SupplyRequestParameterComponent tgt = new SupplyRequest.SupplyRequestParameterComponent();
        SupplyRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(SupplyRequest40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(SupplyRequest40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static SupplyRequest.SupplyRequestParameterComponent convertSupplyRequestParameterComponent(SupplyRequest.SupplyRequestParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyRequest.SupplyRequestParameterComponent tgt = new SupplyRequest.SupplyRequestParameterComponent();
        SupplyRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(SupplyRequest40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(SupplyRequest40_50.convertType(src.getValue()));
        }
        return tgt;
    }
}

