/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyDelivery;

public class SupplyDelivery40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.SupplyDelivery convertSupplyDelivery(SupplyDelivery src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.SupplyDelivery tgt = new org.hl7.fhir.r5.model.SupplyDelivery();
        SupplyDelivery40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(SupplyDelivery40_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(SupplyDelivery40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(SupplyDelivery40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyDelivery40_50.convertSupplyDeliveryStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(SupplyDelivery40_50.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(SupplyDelivery40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSuppliedItem()) {
            tgt.setSuppliedItem(SupplyDelivery40_50.convertSupplyDeliverySuppliedItemComponent(src.getSuppliedItem()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(SupplyDelivery40_50.convertType(src.getOccurrence()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(SupplyDelivery40_50.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(SupplyDelivery40_50.convertReference(src.getDestination()));
        }
        for (Reference reference : src.getReceiver()) {
            tgt.addReceiver(SupplyDelivery40_50.convertReference(reference));
        }
        return tgt;
    }

    public static SupplyDelivery convertSupplyDelivery(org.hl7.fhir.r5.model.SupplyDelivery src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery tgt = new SupplyDelivery();
        SupplyDelivery40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(SupplyDelivery40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(SupplyDelivery40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(SupplyDelivery40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyDelivery40_50.convertSupplyDeliveryStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(SupplyDelivery40_50.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(SupplyDelivery40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSuppliedItem()) {
            tgt.setSuppliedItem(SupplyDelivery40_50.convertSupplyDeliverySuppliedItemComponent(src.getSuppliedItem()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(SupplyDelivery40_50.convertType(src.getOccurrence()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(SupplyDelivery40_50.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(SupplyDelivery40_50.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getReceiver()) {
            tgt.addReceiver(SupplyDelivery40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> convertSupplyDeliveryStatus(Enumeration<SupplyDelivery.SupplyDeliveryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus>(new SupplyDelivery.SupplyDeliveryStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyDelivery.SupplyDeliveryStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.COMPLETED);
                break;
            }
            case ABANDONED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ABANDONED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SupplyDelivery.SupplyDeliveryStatus> convertSupplyDeliveryStatus(org.hl7.fhir.r5.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SupplyDelivery.SupplyDeliveryStatus> tgt = new Enumeration<SupplyDelivery.SupplyDeliveryStatus>(new SupplyDelivery.SupplyDeliveryStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyDelivery.SupplyDeliveryStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.COMPLETED);
                break;
            }
            case ABANDONED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ABANDONED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.NULL);
            }
        }
        return tgt;
    }

    public static SupplyDelivery.SupplyDeliverySuppliedItemComponent convertSupplyDeliverySuppliedItemComponent(SupplyDelivery.SupplyDeliverySuppliedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery.SupplyDeliverySuppliedItemComponent tgt = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
        SupplyDelivery40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(SupplyDelivery40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasItem()) {
            tgt.setItem(SupplyDelivery40_50.convertType(src.getItem()));
        }
        return tgt;
    }

    public static SupplyDelivery.SupplyDeliverySuppliedItemComponent convertSupplyDeliverySuppliedItemComponent(SupplyDelivery.SupplyDeliverySuppliedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery.SupplyDeliverySuppliedItemComponent tgt = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
        SupplyDelivery40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(SupplyDelivery40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasItem()) {
            tgt.setItem(SupplyDelivery40_50.convertType(src.getItem()));
        }
        return tgt;
    }
}

