/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;

public class SubstanceSourceMaterial40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.SubstanceSourceMaterial convertSubstanceSourceMaterial(SubstanceSourceMaterial src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.SubstanceSourceMaterial tgt = new org.hl7.fhir.r5.model.SubstanceSourceMaterial();
        SubstanceSourceMaterial40_50.copyDomainResource(src, tgt);
        if (src.hasSourceMaterialClass()) {
            tgt.setSourceMaterialClass(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSourceMaterialClass()));
        }
        if (src.hasSourceMaterialType()) {
            tgt.setSourceMaterialType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSourceMaterialType()));
        }
        if (src.hasSourceMaterialState()) {
            tgt.setSourceMaterialState(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSourceMaterialState()));
        }
        if (src.hasOrganismId()) {
            tgt.setOrganismId(SubstanceSourceMaterial40_50.convertIdentifier(src.getOrganismId()));
        }
        if (src.hasOrganismName()) {
            tgt.setOrganismNameElement(SubstanceSourceMaterial40_50.convertString(src.getOrganismNameElement()));
        }
        for (Identifier identifier : src.getParentSubstanceId()) {
            tgt.addParentSubstanceId(SubstanceSourceMaterial40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getParentSubstanceName()) {
            tgt.getParentSubstanceName().add(SubstanceSourceMaterial40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCountryOfOrigin()) {
            tgt.addCountryOfOrigin(SubstanceSourceMaterial40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getGeographicalLocation()) {
            tgt.getGeographicalLocation().add(SubstanceSourceMaterial40_50.convertString(stringType));
        }
        if (src.hasDevelopmentStage()) {
            tgt.setDevelopmentStage(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getDevelopmentStage()));
        }
        for (SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent substanceSourceMaterialFractionDescriptionComponent : src.getFractionDescription()) {
            tgt.addFractionDescription(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialFractionDescriptionComponent(substanceSourceMaterialFractionDescriptionComponent));
        }
        if (src.hasOrganism()) {
            tgt.setOrganism(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismComponent(src.getOrganism()));
        }
        for (SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent substanceSourceMaterialPartDescriptionComponent : src.getPartDescription()) {
            tgt.addPartDescription(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialPartDescriptionComponent(substanceSourceMaterialPartDescriptionComponent));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial convertSubstanceSourceMaterial(org.hl7.fhir.r5.model.SubstanceSourceMaterial src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial tgt = new SubstanceSourceMaterial();
        SubstanceSourceMaterial40_50.copyDomainResource(src, tgt);
        if (src.hasSourceMaterialClass()) {
            tgt.setSourceMaterialClass(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSourceMaterialClass()));
        }
        if (src.hasSourceMaterialType()) {
            tgt.setSourceMaterialType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSourceMaterialType()));
        }
        if (src.hasSourceMaterialState()) {
            tgt.setSourceMaterialState(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSourceMaterialState()));
        }
        if (src.hasOrganismId()) {
            tgt.setOrganismId(SubstanceSourceMaterial40_50.convertIdentifier(src.getOrganismId()));
        }
        if (src.hasOrganismName()) {
            tgt.setOrganismNameElement(SubstanceSourceMaterial40_50.convertString(src.getOrganismNameElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getParentSubstanceId()) {
            tgt.addParentSubstanceId(SubstanceSourceMaterial40_50.convertIdentifier(identifier));
        }
        for (StringType stringType : src.getParentSubstanceName()) {
            tgt.getParentSubstanceName().add(SubstanceSourceMaterial40_50.convertString(stringType));
        }
        for (CodeableConcept codeableConcept : src.getCountryOfOrigin()) {
            tgt.addCountryOfOrigin(SubstanceSourceMaterial40_50.convertCodeableConcept(codeableConcept));
        }
        for (StringType stringType : src.getGeographicalLocation()) {
            tgt.getGeographicalLocation().add(SubstanceSourceMaterial40_50.convertString(stringType));
        }
        if (src.hasDevelopmentStage()) {
            tgt.setDevelopmentStage(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getDevelopmentStage()));
        }
        for (SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent substanceSourceMaterialFractionDescriptionComponent : src.getFractionDescription()) {
            tgt.addFractionDescription(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialFractionDescriptionComponent(substanceSourceMaterialFractionDescriptionComponent));
        }
        if (src.hasOrganism()) {
            tgt.setOrganism(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismComponent(src.getOrganism()));
        }
        for (SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent substanceSourceMaterialPartDescriptionComponent : src.getPartDescription()) {
            tgt.addPartDescription(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialPartDescriptionComponent(substanceSourceMaterialPartDescriptionComponent));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent convertSubstanceSourceMaterialFractionDescriptionComponent(SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFraction()) {
            tgt.setFractionElement(SubstanceSourceMaterial40_50.convertString(src.getFractionElement()));
        }
        if (src.hasMaterialType()) {
            tgt.setMaterialType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getMaterialType()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent convertSubstanceSourceMaterialFractionDescriptionComponent(SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFraction()) {
            tgt.setFractionElement(SubstanceSourceMaterial40_50.convertString(src.getFractionElement()));
        }
        if (src.hasMaterialType()) {
            tgt.setMaterialType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getMaterialType()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent convertSubstanceSourceMaterialOrganismComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFamily()) {
            tgt.setFamily(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getFamily()));
        }
        if (src.hasGenus()) {
            tgt.setGenus(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getGenus()));
        }
        if (src.hasSpecies()) {
            tgt.setSpecies(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSpecies()));
        }
        if (src.hasIntraspecificType()) {
            tgt.setIntraspecificType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getIntraspecificType()));
        }
        if (src.hasIntraspecificDescription()) {
            tgt.setIntraspecificDescriptionElement(SubstanceSourceMaterial40_50.convertString(src.getIntraspecificDescriptionElement()));
        }
        for (SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent t : src.getAuthor()) {
            tgt.addAuthor(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismAuthorComponent(t));
        }
        if (src.hasHybrid()) {
            tgt.setHybrid(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismHybridComponent(src.getHybrid()));
        }
        if (src.hasOrganismGeneral()) {
            tgt.setOrganismGeneral(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismOrganismGeneralComponent(src.getOrganismGeneral()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent convertSubstanceSourceMaterialOrganismComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFamily()) {
            tgt.setFamily(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getFamily()));
        }
        if (src.hasGenus()) {
            tgt.setGenus(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getGenus()));
        }
        if (src.hasSpecies()) {
            tgt.setSpecies(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getSpecies()));
        }
        if (src.hasIntraspecificType()) {
            tgt.setIntraspecificType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getIntraspecificType()));
        }
        if (src.hasIntraspecificDescription()) {
            tgt.setIntraspecificDescriptionElement(SubstanceSourceMaterial40_50.convertString(src.getIntraspecificDescriptionElement()));
        }
        for (SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent t : src.getAuthor()) {
            tgt.addAuthor(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismAuthorComponent(t));
        }
        if (src.hasHybrid()) {
            tgt.setHybrid(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismHybridComponent(src.getHybrid()));
        }
        if (src.hasOrganismGeneral()) {
            tgt.setOrganismGeneral(SubstanceSourceMaterial40_50.convertSubstanceSourceMaterialOrganismOrganismGeneralComponent(src.getOrganismGeneral()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent convertSubstanceSourceMaterialOrganismAuthorComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthorType()) {
            tgt.setAuthorType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getAuthorType()));
        }
        if (src.hasAuthorDescription()) {
            tgt.setAuthorDescriptionElement(SubstanceSourceMaterial40_50.convertString(src.getAuthorDescriptionElement()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent convertSubstanceSourceMaterialOrganismAuthorComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthorType()) {
            tgt.setAuthorType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getAuthorType()));
        }
        if (src.hasAuthorDescription()) {
            tgt.setAuthorDescriptionElement(SubstanceSourceMaterial40_50.convertString(src.getAuthorDescriptionElement()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent convertSubstanceSourceMaterialOrganismHybridComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMaternalOrganismId()) {
            tgt.setMaternalOrganismIdElement(SubstanceSourceMaterial40_50.convertString(src.getMaternalOrganismIdElement()));
        }
        if (src.hasMaternalOrganismName()) {
            tgt.setMaternalOrganismNameElement(SubstanceSourceMaterial40_50.convertString(src.getMaternalOrganismNameElement()));
        }
        if (src.hasPaternalOrganismId()) {
            tgt.setPaternalOrganismIdElement(SubstanceSourceMaterial40_50.convertString(src.getPaternalOrganismIdElement()));
        }
        if (src.hasPaternalOrganismName()) {
            tgt.setPaternalOrganismNameElement(SubstanceSourceMaterial40_50.convertString(src.getPaternalOrganismNameElement()));
        }
        if (src.hasHybridType()) {
            tgt.setHybridType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getHybridType()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent convertSubstanceSourceMaterialOrganismHybridComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMaternalOrganismId()) {
            tgt.setMaternalOrganismIdElement(SubstanceSourceMaterial40_50.convertString(src.getMaternalOrganismIdElement()));
        }
        if (src.hasMaternalOrganismName()) {
            tgt.setMaternalOrganismNameElement(SubstanceSourceMaterial40_50.convertString(src.getMaternalOrganismNameElement()));
        }
        if (src.hasPaternalOrganismId()) {
            tgt.setPaternalOrganismIdElement(SubstanceSourceMaterial40_50.convertString(src.getPaternalOrganismIdElement()));
        }
        if (src.hasPaternalOrganismName()) {
            tgt.setPaternalOrganismNameElement(SubstanceSourceMaterial40_50.convertString(src.getPaternalOrganismNameElement()));
        }
        if (src.hasHybridType()) {
            tgt.setHybridType(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getHybridType()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent convertSubstanceSourceMaterialOrganismOrganismGeneralComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKingdom()) {
            tgt.setKingdom(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getKingdom()));
        }
        if (src.hasPhylum()) {
            tgt.setPhylum(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getPhylum()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasOrder()) {
            tgt.setOrder(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getOrder()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent convertSubstanceSourceMaterialOrganismOrganismGeneralComponent(SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKingdom()) {
            tgt.setKingdom(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getKingdom()));
        }
        if (src.hasPhylum()) {
            tgt.setPhylum(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getPhylum()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasOrder()) {
            tgt.setOrder(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getOrder()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent convertSubstanceSourceMaterialPartDescriptionComponent(SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPart()) {
            tgt.setPart(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getPart()));
        }
        if (src.hasPartLocation()) {
            tgt.setPartLocation(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getPartLocation()));
        }
        return tgt;
    }

    public static SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent convertSubstanceSourceMaterialPartDescriptionComponent(SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent tgt = new SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent();
        SubstanceSourceMaterial40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPart()) {
            tgt.setPart(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getPart()));
        }
        if (src.hasPartLocation()) {
            tgt.setPartLocation(SubstanceSourceMaterial40_50.convertCodeableConcept(src.getPartLocation()));
        }
        return tgt;
    }
}

