/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;

public class StructureDefinition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.StructureDefinition tgt = new org.hl7.fhir.r5.model.StructureDefinition();
        StructureDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(StructureDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(StructureDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(StructureDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(StructureDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(StructureDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(StructureDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(StructureDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(StructureDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(StructureDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(StructureDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(StructureDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(StructureDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(StructureDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getKeyword()) {
            tgt.addKeyword(StructureDefinition40_50.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(Enumerations40_50.convertFHIRVersion(src.getFhirVersionElement()));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition40_50.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition40_50.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(StructureDefinition40_50.convertBoolean(src.getAbstractElement()));
        }
        for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : src.getContext()) {
            tgt.addContext(StructureDefinition40_50.convertStructureDefinitionContextComponent(structureDefinitionContextComponent));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getContextInvariant()) {
            tgt.getContextInvariant().add(StructureDefinition40_50.convertString(stringType));
        }
        if (src.hasType()) {
            tgt.setTypeElement(StructureDefinition40_50.convertUri(src.getTypeElement()));
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinitionElement(StructureDefinition40_50.convertCanonical(src.getBaseDefinitionElement()));
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition40_50.convertTypeDerivationRule(src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition40_50.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition40_50.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.r5.model.StructureDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        StructureDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(StructureDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(StructureDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(StructureDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(StructureDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(StructureDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(StructureDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(StructureDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(StructureDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(StructureDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(StructureDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(StructureDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(StructureDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(StructureDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (Coding coding : src.getKeyword()) {
            tgt.addKeyword(StructureDefinition40_50.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(Enumerations40_50.convertFHIRVersion(src.getFhirVersionElement()));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition40_50.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition40_50.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(StructureDefinition40_50.convertBoolean(src.getAbstractElement()));
        }
        for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : src.getContext()) {
            tgt.addContext(StructureDefinition40_50.convertStructureDefinitionContextComponent(structureDefinitionContextComponent));
        }
        for (StringType stringType : src.getContextInvariant()) {
            tgt.getContextInvariant().add(StructureDefinition40_50.convertString(stringType));
        }
        if (src.hasType()) {
            tgt.setTypeElement(StructureDefinition40_50.convertUri(src.getTypeElement()));
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinitionElement(StructureDefinition40_50.convertCanonical(src.getBaseDefinitionElement()));
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition40_50.convertTypeDerivationRule(src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition40_50.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition40_50.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(org.hl7.fhir.r5.model.Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureDefinition.TypeDerivationRule> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureDefinition.TypeDerivationRule>(new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)((Object)src.getValue())) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(org.hl7.fhir.r5.model.Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.TypeDerivationRule> tgt = new Enumeration<StructureDefinition.TypeDerivationRule>(new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)((Object)src.getValue())) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(StructureDefinition40_50.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(StructureDefinition40_50.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(StructureDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(StructureDefinition40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(StructureDefinition40_50.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(StructureDefinition40_50.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(StructureDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(StructureDefinition40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionContextComponent convertStructureDefinitionContextComponent(StructureDefinition.StructureDefinitionContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionContextComponent tgt = new StructureDefinition.StructureDefinitionContextComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(StructureDefinition40_50.convertExtensionContextType(src.getTypeElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(StructureDefinition40_50.convertString(src.getExpressionElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionContextComponent convertStructureDefinitionContextComponent(StructureDefinition.StructureDefinitionContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionContextComponent tgt = new StructureDefinition.StructureDefinitionContextComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(StructureDefinition40_50.convertExtensionContextType(src.getTypeElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(StructureDefinition40_50.convertString(src.getExpressionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureDefinition.ExtensionContextType> convertExtensionContextType(Enumeration<StructureDefinition.ExtensionContextType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureDefinition.ExtensionContextType> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureDefinition.ExtensionContextType>(new StructureDefinition.ExtensionContextTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContextType)((Object)src.getValue())) {
            case FHIRPATH: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.FHIRPATH);
                break;
            }
            case ELEMENT: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.ExtensionContextType> convertExtensionContextType(org.hl7.fhir.r5.model.Enumeration<StructureDefinition.ExtensionContextType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.ExtensionContextType> tgt = new Enumeration<StructureDefinition.ExtensionContextType>(new StructureDefinition.ExtensionContextTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContextType)((Object)src.getValue())) {
            case FHIRPATH: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.FHIRPATH);
                break;
            }
            case ELEMENT: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(StructureDefinition40_50.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(StructureDefinition40_50.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(StructureDefinition40_50.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        StructureDefinition40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(StructureDefinition40_50.convertElementDefinition(t));
        }
        return tgt;
    }
}

