/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Specimen;

public class Specimen40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Specimen convertSpecimen(Specimen src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Specimen tgt = new org.hl7.fhir.r5.model.Specimen();
        Specimen40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Specimen40_50.convertIdentifier(identifier));
        }
        if (src.hasAccessionIdentifier()) {
            tgt.setAccessionIdentifier(Specimen40_50.convertIdentifier(src.getAccessionIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Specimen40_50.convertSpecimenStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Specimen40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Specimen40_50.convertReference(src.getSubject()));
        }
        if (src.hasReceivedTime()) {
            tgt.setReceivedTimeElement(Specimen40_50.convertDateTime(src.getReceivedTimeElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getParent()) {
            tgt.addParent(Specimen40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRequest()) {
            tgt.addRequest(Specimen40_50.convertReference(reference));
        }
        if (src.hasCollection()) {
            tgt.setCollection(Specimen40_50.convertSpecimenCollectionComponent(src.getCollection()));
        }
        for (Specimen.SpecimenProcessingComponent specimenProcessingComponent : src.getProcessing()) {
            tgt.addProcessing(Specimen40_50.convertSpecimenProcessingComponent(specimenProcessingComponent));
        }
        for (Specimen.SpecimenContainerComponent specimenContainerComponent : src.getContainer()) {
            tgt.addContainer(Specimen40_50.convertSpecimenContainerComponent(specimenContainerComponent));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCondition()) {
            tgt.addCondition(Specimen40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Specimen40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static Specimen convertSpecimen(org.hl7.fhir.r5.model.Specimen src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen tgt = new Specimen();
        Specimen40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Specimen40_50.convertIdentifier(identifier));
        }
        if (src.hasAccessionIdentifier()) {
            tgt.setAccessionIdentifier(Specimen40_50.convertIdentifier(src.getAccessionIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Specimen40_50.convertSpecimenStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Specimen40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Specimen40_50.convertReference(src.getSubject()));
        }
        if (src.hasReceivedTime()) {
            tgt.setReceivedTimeElement(Specimen40_50.convertDateTime(src.getReceivedTimeElement()));
        }
        for (Reference reference : src.getParent()) {
            tgt.addParent(Specimen40_50.convertReference(reference));
        }
        for (Reference reference : src.getRequest()) {
            tgt.addRequest(Specimen40_50.convertReference(reference));
        }
        if (src.hasCollection()) {
            tgt.setCollection(Specimen40_50.convertSpecimenCollectionComponent(src.getCollection()));
        }
        for (Specimen.SpecimenProcessingComponent specimenProcessingComponent : src.getProcessing()) {
            tgt.addProcessing(Specimen40_50.convertSpecimenProcessingComponent(specimenProcessingComponent));
        }
        for (Specimen.SpecimenContainerComponent specimenContainerComponent : src.getContainer()) {
            tgt.addContainer(Specimen40_50.convertSpecimenContainerComponent(specimenContainerComponent));
        }
        for (CodeableConcept codeableConcept : src.getCondition()) {
            tgt.addCondition(Specimen40_50.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Specimen40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Specimen.SpecimenStatus> convertSpecimenStatus(Enumeration<Specimen.SpecimenStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Specimen.SpecimenStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Specimen.SpecimenStatus>(new Specimen.SpecimenStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Specimen.SpecimenStatus)((Object)src.getValue())) {
            case AVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.AVAILABLE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNAVAILABLE);
                break;
            }
            case UNSATISFACTORY: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNSATISFACTORY);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Specimen.SpecimenStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Specimen.SpecimenStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Specimen.SpecimenStatus> convertSpecimenStatus(org.hl7.fhir.r5.model.Enumeration<Specimen.SpecimenStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Specimen.SpecimenStatus> tgt = new Enumeration<Specimen.SpecimenStatus>(new Specimen.SpecimenStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Specimen.SpecimenStatus)((Object)src.getValue())) {
            case AVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.AVAILABLE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNAVAILABLE);
                break;
            }
            case UNSATISFACTORY: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNSATISFACTORY);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Specimen.SpecimenStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Specimen.SpecimenStatus.NULL);
            }
        }
        return tgt;
    }

    public static Specimen.SpecimenCollectionComponent convertSpecimenCollectionComponent(Specimen.SpecimenCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenCollectionComponent tgt = new Specimen.SpecimenCollectionComponent();
        Specimen40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCollector()) {
            tgt.setCollector(Specimen40_50.convertReference(src.getCollector()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(Specimen40_50.convertType(src.getCollected()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(Specimen40_50.convertDuration(src.getDuration()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Specimen40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(Specimen40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(Specimen40_50.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasFastingStatus()) {
            tgt.setFastingStatus(Specimen40_50.convertType(src.getFastingStatus()));
        }
        return tgt;
    }

    public static Specimen.SpecimenCollectionComponent convertSpecimenCollectionComponent(Specimen.SpecimenCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenCollectionComponent tgt = new Specimen.SpecimenCollectionComponent();
        Specimen40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCollector()) {
            tgt.setCollector(Specimen40_50.convertReference(src.getCollector()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(Specimen40_50.convertType(src.getCollected()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(Specimen40_50.convertDuration(src.getDuration()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Specimen40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(Specimen40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(Specimen40_50.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasFastingStatus()) {
            tgt.setFastingStatus(Specimen40_50.convertType(src.getFastingStatus()));
        }
        return tgt;
    }

    public static Specimen.SpecimenProcessingComponent convertSpecimenProcessingComponent(Specimen.SpecimenProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenProcessingComponent tgt = new Specimen.SpecimenProcessingComponent();
        Specimen40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Specimen40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(Specimen40_50.convertCodeableConcept(src.getProcedure()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAdditive()) {
            tgt.addAdditive(Specimen40_50.convertReference(t));
        }
        if (src.hasTime()) {
            tgt.setTime(Specimen40_50.convertType(src.getTime()));
        }
        return tgt;
    }

    public static Specimen.SpecimenProcessingComponent convertSpecimenProcessingComponent(Specimen.SpecimenProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenProcessingComponent tgt = new Specimen.SpecimenProcessingComponent();
        Specimen40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Specimen40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(Specimen40_50.convertCodeableConcept(src.getProcedure()));
        }
        for (Reference t : src.getAdditive()) {
            tgt.addAdditive(Specimen40_50.convertReference(t));
        }
        if (src.hasTime()) {
            tgt.setTime(Specimen40_50.convertType(src.getTime()));
        }
        return tgt;
    }

    public static Specimen.SpecimenContainerComponent convertSpecimenContainerComponent(Specimen.SpecimenContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenContainerComponent tgt = new Specimen.SpecimenContainerComponent();
        Specimen40_50.copyElement(src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(Specimen40_50.convertIdentifier(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Specimen40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setType(Specimen40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(Specimen40_50.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasSpecimenQuantity()) {
            tgt.setSpecimenQuantity(Specimen40_50.convertSimpleQuantity(src.getSpecimenQuantity()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(Specimen40_50.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static Specimen.SpecimenContainerComponent convertSpecimenContainerComponent(Specimen.SpecimenContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenContainerComponent tgt = new Specimen.SpecimenContainerComponent();
        Specimen40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(Specimen40_50.convertIdentifier(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Specimen40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setType(Specimen40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(Specimen40_50.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasSpecimenQuantity()) {
            tgt.setSpecimenQuantity(Specimen40_50.convertSimpleQuantity(src.getSpecimenQuantity()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(Specimen40_50.convertType(src.getAdditive()));
        }
        return tgt;
    }
}

