/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ServiceRequest;

public class ServiceRequest40_50
extends VersionConvertor_40_50 {
    public static ServiceRequest convertServiceRequest(org.hl7.fhir.r4.model.ServiceRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ServiceRequest tgt = new ServiceRequest();
        ServiceRequest40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ServiceRequest40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(ServiceRequest40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(ServiceRequest40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(ServiceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReplaces()) {
            tgt.addReplaces(ServiceRequest40_50.convertReference(reference));
        }
        if (src.hasRequisition()) {
            tgt.setRequisition(ServiceRequest40_50.convertIdentifier(src.getRequisition()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ServiceRequest40_50.convertServiceRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(ServiceRequest40_50.convertServiceRequestIntent(src.getIntentElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(ServiceRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(ServiceRequest40_50.convertServiceRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(ServiceRequest40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ServiceRequest40_50.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getOrderDetail()) {
            tgt.addOrderDetail(ServiceRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ServiceRequest40_50.convertType(src.getQuantity()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ServiceRequest40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ServiceRequest40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(ServiceRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(ServiceRequest40_50.convertType(src.getAsNeeded()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(ServiceRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(ServiceRequest40_50.convertReference(src.getRequester()));
        }
        if (src.hasPerformerType()) {
            tgt.setPerformerType(ServiceRequest40_50.convertCodeableConcept(src.getPerformerType()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(ServiceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getLocationCode()) {
            tgt.addLocation(ServiceRequest40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getLocationReference()) {
            tgt.addLocation(ServiceRequest40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(ServiceRequest40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(ServiceRequest40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getInsurance()) {
            tgt.addInsurance(ServiceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(ServiceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(ServiceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(ServiceRequest40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(ServiceRequest40_50.convertAnnotation(annotation));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(ServiceRequest40_50.convertString(src.getPatientInstructionElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(ServiceRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ServiceRequest convertServiceRequest(ServiceRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ServiceRequest tgt = new org.hl7.fhir.r4.model.ServiceRequest();
        ServiceRequest40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ServiceRequest40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(ServiceRequest40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(ServiceRequest40_50.convertUri(uriType));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(ServiceRequest40_50.convertReference(reference));
        }
        for (Reference reference : src.getReplaces()) {
            tgt.addReplaces(ServiceRequest40_50.convertReference(reference));
        }
        if (src.hasRequisition()) {
            tgt.setRequisition(ServiceRequest40_50.convertIdentifier(src.getRequisition()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ServiceRequest40_50.convertServiceRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(ServiceRequest40_50.convertServiceRequestIntent(src.getIntentElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(ServiceRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(ServiceRequest40_50.convertServiceRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(ServiceRequest40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ServiceRequest40_50.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept codeableConcept : src.getOrderDetail()) {
            tgt.addOrderDetail(ServiceRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ServiceRequest40_50.convertType(src.getQuantity()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ServiceRequest40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ServiceRequest40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(ServiceRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(ServiceRequest40_50.convertType(src.getAsNeeded()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(ServiceRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(ServiceRequest40_50.convertReference(src.getRequester()));
        }
        if (src.hasPerformerType()) {
            tgt.setPerformerType(ServiceRequest40_50.convertCodeableConcept(src.getPerformerType()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(ServiceRequest40_50.convertReference(reference));
        }
        for (CodeableReference codeableReference : src.getLocation()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addLocationCode(ServiceRequest40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getLocation()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addLocationReference(ServiceRequest40_50.convertReference(codeableReference.getReference()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(ServiceRequest40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(ServiceRequest40_50.convertReference(codeableReference.getReference()));
        }
        for (Reference reference : src.getInsurance()) {
            tgt.addInsurance(ServiceRequest40_50.convertReference(reference));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(ServiceRequest40_50.convertReference(reference));
        }
        for (Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(ServiceRequest40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(ServiceRequest40_50.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(ServiceRequest40_50.convertAnnotation(annotation));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(ServiceRequest40_50.convertString(src.getPatientInstructionElement()));
        }
        for (Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(ServiceRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertServiceRequestStatus(Enumeration<ServiceRequest.ServiceRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ServiceRequest.ServiceRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.RequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Enumerations.RequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.RequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.RequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ServiceRequest.ServiceRequestStatus> convertServiceRequestStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ServiceRequest.ServiceRequestStatus> tgt = new Enumeration<ServiceRequest.ServiceRequestStatus>(new ServiceRequest.ServiceRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> convertServiceRequestIntent(Enumeration<ServiceRequest.ServiceRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ServiceRequest.ServiceRequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)Enumerations.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)Enumerations.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)Enumerations.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)Enumerations.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ServiceRequest.ServiceRequestIntent> convertServiceRequestIntent(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ServiceRequest.ServiceRequestIntent> tgt = new Enumeration<ServiceRequest.ServiceRequestIntent>(new ServiceRequest.ServiceRequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertServiceRequestPriority(Enumeration<ServiceRequest.ServiceRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ServiceRequest.ServiceRequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ServiceRequest.ServiceRequestPriority> convertServiceRequestPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ServiceRequest.ServiceRequestPriority> tgt = new Enumeration<ServiceRequest.ServiceRequestPriority>(new ServiceRequest.ServiceRequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.NULL);
            }
        }
        return tgt;
    }
}

