/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Schedule;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Identifier;

public class Schedule40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Schedule convertSchedule(Schedule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Schedule tgt = new org.hl7.fhir.r5.model.Schedule();
        Schedule40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Schedule40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Schedule40_50.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getServiceCategory()) {
            tgt.addServiceCategory(Schedule40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(Schedule40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(Schedule40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getActor()) {
            tgt.addActor(Schedule40_50.convertReference(reference));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(Schedule40_50.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(Schedule40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static Schedule convertSchedule(org.hl7.fhir.r5.model.Schedule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Schedule tgt = new Schedule();
        Schedule40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Schedule40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Schedule40_50.convertBoolean(src.getActiveElement()));
        }
        for (CodeableConcept codeableConcept : src.getServiceCategory()) {
            tgt.addServiceCategory(Schedule40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(Schedule40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(Schedule40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getActor()) {
            tgt.addActor(Schedule40_50.convertReference(reference));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(Schedule40_50.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(Schedule40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

