/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResearchSubject;

public class ResearchSubject40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ResearchSubject convertResearchSubject(ResearchSubject src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ResearchSubject tgt = new org.hl7.fhir.r5.model.ResearchSubject();
        ResearchSubject40_50.copyDomainResource(src, tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(ResearchSubject40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ResearchSubject40_50.convertResearchSubjectStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(ResearchSubject40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasStudy()) {
            tgt.setStudy(ResearchSubject40_50.convertReference(src.getStudy()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(ResearchSubject40_50.convertReference(src.getIndividual()));
        }
        if (src.hasAssignedArm()) {
            tgt.setAssignedArmElement(ResearchSubject40_50.convertString(src.getAssignedArmElement()));
        }
        if (src.hasActualArm()) {
            tgt.setActualArmElement(ResearchSubject40_50.convertString(src.getActualArmElement()));
        }
        if (src.hasConsent()) {
            tgt.setConsent(ResearchSubject40_50.convertReference(src.getConsent()));
        }
        return tgt;
    }

    public static ResearchSubject convertResearchSubject(org.hl7.fhir.r5.model.ResearchSubject src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ResearchSubject tgt = new ResearchSubject();
        ResearchSubject40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(ResearchSubject40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ResearchSubject40_50.convertResearchSubjectStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(ResearchSubject40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasStudy()) {
            tgt.setStudy(ResearchSubject40_50.convertReference(src.getStudy()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(ResearchSubject40_50.convertReference(src.getIndividual()));
        }
        if (src.hasAssignedArm()) {
            tgt.setAssignedArmElement(ResearchSubject40_50.convertString(src.getAssignedArmElement()));
        }
        if (src.hasActualArm()) {
            tgt.setActualArmElement(ResearchSubject40_50.convertString(src.getActualArmElement()));
        }
        if (src.hasConsent()) {
            tgt.setConsent(ResearchSubject40_50.convertReference(src.getConsent()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ResearchSubject.ResearchSubjectStatus> convertResearchSubjectStatus(Enumeration<ResearchSubject.ResearchSubjectStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ResearchSubject.ResearchSubjectStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<ResearchSubject.ResearchSubjectStatus>(new ResearchSubject.ResearchSubjectStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ResearchSubject.ResearchSubjectStatus)((Object)src.getValue())) {
            case CANDIDATE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.CANDIDATE);
                break;
            }
            case ELIGIBLE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ELIGIBLE);
                break;
            }
            case FOLLOWUP: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.FOLLOWUP);
                break;
            }
            case INELIGIBLE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.INELIGIBLE);
                break;
            }
            case NOTREGISTERED: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.NOTREGISTERED);
                break;
            }
            case OFFSTUDY: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.OFFSTUDY);
                break;
            }
            case ONSTUDY: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ONSTUDY);
                break;
            }
            case ONSTUDYINTERVENTION: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ONSTUDYINTERVENTION);
                break;
            }
            case ONSTUDYOBSERVATION: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ONSTUDYOBSERVATION);
                break;
            }
            case PENDINGONSTUDY: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.PENDINGONSTUDY);
                break;
            }
            case POTENTIALCANDIDATE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.POTENTIALCANDIDATE);
                break;
            }
            case SCREENING: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.SCREENING);
                break;
            }
            case WITHDRAWN: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.WITHDRAWN);
                break;
            }
            default: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ResearchSubject.ResearchSubjectStatus> convertResearchSubjectStatus(org.hl7.fhir.r5.model.Enumeration<ResearchSubject.ResearchSubjectStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ResearchSubject.ResearchSubjectStatus> tgt = new Enumeration<ResearchSubject.ResearchSubjectStatus>(new ResearchSubject.ResearchSubjectStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ResearchSubject.ResearchSubjectStatus)((Object)src.getValue())) {
            case CANDIDATE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.CANDIDATE);
                break;
            }
            case ELIGIBLE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ELIGIBLE);
                break;
            }
            case FOLLOWUP: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.FOLLOWUP);
                break;
            }
            case INELIGIBLE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.INELIGIBLE);
                break;
            }
            case NOTREGISTERED: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.NOTREGISTERED);
                break;
            }
            case OFFSTUDY: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.OFFSTUDY);
                break;
            }
            case ONSTUDY: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ONSTUDY);
                break;
            }
            case ONSTUDYINTERVENTION: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ONSTUDYINTERVENTION);
                break;
            }
            case ONSTUDYOBSERVATION: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.ONSTUDYOBSERVATION);
                break;
            }
            case PENDINGONSTUDY: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.PENDINGONSTUDY);
                break;
            }
            case POTENTIALCANDIDATE: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.POTENTIALCANDIDATE);
                break;
            }
            case SCREENING: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.SCREENING);
                break;
            }
            case WITHDRAWN: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.WITHDRAWN);
                break;
            }
            default: {
                tgt.setValue((Object)ResearchSubject.ResearchSubjectStatus.NULL);
            }
        }
        return tgt;
    }
}

