/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RequestGroup;

public class RequestGroup40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.RequestGroup convertRequestGroup(RequestGroup src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.RequestGroup tgt = new org.hl7.fhir.r5.model.RequestGroup();
        RequestGroup40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(RequestGroup40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(RequestGroup40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(RequestGroup40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(RequestGroup40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReplaces()) {
            tgt.addReplaces(RequestGroup40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(RequestGroup40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RequestGroup40_50.convertRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(RequestGroup40_50.convertRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(RequestGroup40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(RequestGroup40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(RequestGroup40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(RequestGroup40_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(RequestGroup40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(RequestGroup40_50.convertReference(src.getAuthor()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(RequestGroup40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(RequestGroup40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(RequestGroup40_50.convertAnnotation(annotation));
        }
        for (RequestGroup.RequestGroupActionComponent requestGroupActionComponent : src.getAction()) {
            tgt.addAction(RequestGroup40_50.convertRequestGroupActionComponent(requestGroupActionComponent));
        }
        return tgt;
    }

    public static RequestGroup convertRequestGroup(org.hl7.fhir.r5.model.RequestGroup src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RequestGroup tgt = new RequestGroup();
        RequestGroup40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(RequestGroup40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(RequestGroup40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(RequestGroup40_50.convertUri(uriType));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(RequestGroup40_50.convertReference(reference));
        }
        for (Reference reference : src.getReplaces()) {
            tgt.addReplaces(RequestGroup40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(RequestGroup40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RequestGroup40_50.convertRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(RequestGroup40_50.convertRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(RequestGroup40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(RequestGroup40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(RequestGroup40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(RequestGroup40_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(RequestGroup40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(RequestGroup40_50.convertReference(src.getAuthor()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(RequestGroup40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(RequestGroup40_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(RequestGroup40_50.convertAnnotation(annotation));
        }
        for (RequestGroup.RequestGroupActionComponent requestGroupActionComponent : src.getAction()) {
            tgt.addAction(RequestGroup40_50.convertRequestGroupActionComponent(requestGroupActionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertRequestStatus(Enumeration<RequestGroup.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.RequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Enumerations.RequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.RequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.RequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.RequestStatus> convertRequestStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.RequestStatus> tgt = new Enumeration<RequestGroup.RequestStatus>(new RequestGroup.RequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)RequestGroup.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)RequestGroup.RequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)RequestGroup.RequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)RequestGroup.RequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)RequestGroup.RequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)RequestGroup.RequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)RequestGroup.RequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> convertRequestIntent(Enumeration<RequestGroup.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)Enumerations.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)Enumerations.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)Enumerations.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)Enumerations.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.RequestIntent> convertRequestIntent(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.RequestIntent> tgt = new Enumeration<RequestGroup.RequestIntent>(new RequestGroup.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)RequestGroup.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)RequestGroup.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)RequestGroup.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)RequestGroup.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)RequestGroup.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)RequestGroup.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)RequestGroup.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)RequestGroup.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)RequestGroup.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertRequestPriority(Enumeration<RequestGroup.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.RequestPriority> convertRequestPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.RequestPriority> tgt = new Enumeration<RequestGroup.RequestPriority>(new RequestGroup.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)RequestGroup.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)RequestGroup.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)RequestGroup.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)RequestGroup.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static RequestGroup.RequestGroupActionComponent convertRequestGroupActionComponent(RequestGroup.RequestGroupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RequestGroup.RequestGroupActionComponent tgt = new RequestGroup.RequestGroupActionComponent();
        RequestGroup40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPrefix()) {
            tgt.setPrefixElement(RequestGroup40_50.convertString(src.getPrefixElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(RequestGroup40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(RequestGroup40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTextEquivalent()) {
            tgt.setTextEquivalentElement(RequestGroup40_50.convertString(src.getTextEquivalentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(RequestGroup40_50.convertRequestPriority(src.getPriorityElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(RequestGroup40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(RequestGroup40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (RequestGroup.RequestGroupActionConditionComponent requestGroupActionConditionComponent : src.getCondition()) {
            tgt.addCondition(RequestGroup40_50.convertRequestGroupActionConditionComponent(requestGroupActionConditionComponent));
        }
        for (RequestGroup.RequestGroupActionRelatedActionComponent requestGroupActionRelatedActionComponent : src.getRelatedAction()) {
            tgt.addRelatedAction(RequestGroup40_50.convertRequestGroupActionRelatedActionComponent(requestGroupActionRelatedActionComponent));
        }
        if (src.hasTiming()) {
            tgt.setTiming(RequestGroup40_50.convertType(src.getTiming()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getParticipant()) {
            tgt.addParticipant(RequestGroup40_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(RequestGroup40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasGroupingBehavior()) {
            tgt.setGroupingBehaviorElement(RequestGroup40_50.convertActionGroupingBehavior(src.getGroupingBehaviorElement()));
        }
        if (src.hasSelectionBehavior()) {
            tgt.setSelectionBehaviorElement(RequestGroup40_50.convertActionSelectionBehavior(src.getSelectionBehaviorElement()));
        }
        if (src.hasRequiredBehavior()) {
            tgt.setRequiredBehaviorElement(RequestGroup40_50.convertActionRequiredBehavior(src.getRequiredBehaviorElement()));
        }
        if (src.hasPrecheckBehavior()) {
            tgt.setPrecheckBehaviorElement(RequestGroup40_50.convertActionPrecheckBehavior(src.getPrecheckBehaviorElement()));
        }
        if (src.hasCardinalityBehavior()) {
            tgt.setCardinalityBehaviorElement(RequestGroup40_50.convertActionCardinalityBehavior(src.getCardinalityBehaviorElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(RequestGroup40_50.convertReference(src.getResource()));
        }
        for (RequestGroup.RequestGroupActionComponent requestGroupActionComponent : src.getAction()) {
            tgt.addAction(RequestGroup40_50.convertRequestGroupActionComponent(requestGroupActionComponent));
        }
        return tgt;
    }

    public static RequestGroup.RequestGroupActionComponent convertRequestGroupActionComponent(RequestGroup.RequestGroupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RequestGroup.RequestGroupActionComponent tgt = new RequestGroup.RequestGroupActionComponent();
        RequestGroup40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPrefix()) {
            tgt.setPrefixElement(RequestGroup40_50.convertString(src.getPrefixElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(RequestGroup40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(RequestGroup40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTextEquivalent()) {
            tgt.setTextEquivalentElement(RequestGroup40_50.convertString(src.getTextEquivalentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(RequestGroup40_50.convertRequestPriority(src.getPriorityElement()));
        }
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(RequestGroup40_50.convertCodeableConcept(codeableConcept));
        }
        for (RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(RequestGroup40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (RequestGroup.RequestGroupActionConditionComponent requestGroupActionConditionComponent : src.getCondition()) {
            tgt.addCondition(RequestGroup40_50.convertRequestGroupActionConditionComponent(requestGroupActionConditionComponent));
        }
        for (RequestGroup.RequestGroupActionRelatedActionComponent requestGroupActionRelatedActionComponent : src.getRelatedAction()) {
            tgt.addRelatedAction(RequestGroup40_50.convertRequestGroupActionRelatedActionComponent(requestGroupActionRelatedActionComponent));
        }
        if (src.hasTiming()) {
            tgt.setTiming(RequestGroup40_50.convertType(src.getTiming()));
        }
        for (Reference reference : src.getParticipant()) {
            tgt.addParticipant(RequestGroup40_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(RequestGroup40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasGroupingBehavior()) {
            tgt.setGroupingBehaviorElement(RequestGroup40_50.convertActionGroupingBehavior(src.getGroupingBehaviorElement()));
        }
        if (src.hasSelectionBehavior()) {
            tgt.setSelectionBehaviorElement(RequestGroup40_50.convertActionSelectionBehavior(src.getSelectionBehaviorElement()));
        }
        if (src.hasRequiredBehavior()) {
            tgt.setRequiredBehaviorElement(RequestGroup40_50.convertActionRequiredBehavior(src.getRequiredBehaviorElement()));
        }
        if (src.hasPrecheckBehavior()) {
            tgt.setPrecheckBehaviorElement(RequestGroup40_50.convertActionPrecheckBehavior(src.getPrecheckBehaviorElement()));
        }
        if (src.hasCardinalityBehavior()) {
            tgt.setCardinalityBehaviorElement(RequestGroup40_50.convertActionCardinalityBehavior(src.getCardinalityBehaviorElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(RequestGroup40_50.convertReference(src.getResource()));
        }
        for (RequestGroup.RequestGroupActionComponent requestGroupActionComponent : src.getAction()) {
            tgt.addAction(RequestGroup40_50.convertRequestGroupActionComponent(requestGroupActionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior> convertActionGroupingBehavior(Enumeration<RequestGroup.ActionGroupingBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior>(new Enumerations.ActionGroupingBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.ActionGroupingBehavior)((Object)src.getValue())) {
            case VISUALGROUP: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.VISUALGROUP);
                break;
            }
            case LOGICALGROUP: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.LOGICALGROUP);
                break;
            }
            case SENTENCEGROUP: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.SENTENCEGROUP);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.ActionGroupingBehavior> convertActionGroupingBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.ActionGroupingBehavior> tgt = new Enumeration<RequestGroup.ActionGroupingBehavior>(new RequestGroup.ActionGroupingBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionGroupingBehavior)((Object)src.getValue())) {
            case VISUALGROUP: {
                tgt.setValue((Object)RequestGroup.ActionGroupingBehavior.VISUALGROUP);
                break;
            }
            case LOGICALGROUP: {
                tgt.setValue((Object)RequestGroup.ActionGroupingBehavior.LOGICALGROUP);
                break;
            }
            case SENTENCEGROUP: {
                tgt.setValue((Object)RequestGroup.ActionGroupingBehavior.SENTENCEGROUP);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.ActionGroupingBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior> convertActionSelectionBehavior(Enumeration<RequestGroup.ActionSelectionBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior>(new Enumerations.ActionSelectionBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.ActionSelectionBehavior)((Object)src.getValue())) {
            case ANY: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ANY);
                break;
            }
            case ALL: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ALL);
                break;
            }
            case ALLORNONE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ALLORNONE);
                break;
            }
            case EXACTLYONE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.EXACTLYONE);
                break;
            }
            case ATMOSTONE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ATMOSTONE);
                break;
            }
            case ONEORMORE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ONEORMORE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.ActionSelectionBehavior> convertActionSelectionBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.ActionSelectionBehavior> tgt = new Enumeration<RequestGroup.ActionSelectionBehavior>(new RequestGroup.ActionSelectionBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionSelectionBehavior)((Object)src.getValue())) {
            case ANY: {
                tgt.setValue((Object)RequestGroup.ActionSelectionBehavior.ANY);
                break;
            }
            case ALL: {
                tgt.setValue((Object)RequestGroup.ActionSelectionBehavior.ALL);
                break;
            }
            case ALLORNONE: {
                tgt.setValue((Object)RequestGroup.ActionSelectionBehavior.ALLORNONE);
                break;
            }
            case EXACTLYONE: {
                tgt.setValue((Object)RequestGroup.ActionSelectionBehavior.EXACTLYONE);
                break;
            }
            case ATMOSTONE: {
                tgt.setValue((Object)RequestGroup.ActionSelectionBehavior.ATMOSTONE);
                break;
            }
            case ONEORMORE: {
                tgt.setValue((Object)RequestGroup.ActionSelectionBehavior.ONEORMORE);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.ActionSelectionBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior> convertActionRequiredBehavior(Enumeration<RequestGroup.ActionRequiredBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior>(new Enumerations.ActionRequiredBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.ActionRequiredBehavior)((Object)src.getValue())) {
            case MUST: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.MUST);
                break;
            }
            case COULD: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.COULD);
                break;
            }
            case MUSTUNLESSDOCUMENTED: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.ActionRequiredBehavior> convertActionRequiredBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.ActionRequiredBehavior> tgt = new Enumeration<RequestGroup.ActionRequiredBehavior>(new RequestGroup.ActionRequiredBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionRequiredBehavior)((Object)src.getValue())) {
            case MUST: {
                tgt.setValue((Object)RequestGroup.ActionRequiredBehavior.MUST);
                break;
            }
            case COULD: {
                tgt.setValue((Object)RequestGroup.ActionRequiredBehavior.COULD);
                break;
            }
            case MUSTUNLESSDOCUMENTED: {
                tgt.setValue((Object)RequestGroup.ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.ActionRequiredBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior> convertActionPrecheckBehavior(Enumeration<RequestGroup.ActionPrecheckBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior>(new Enumerations.ActionPrecheckBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.ActionPrecheckBehavior)((Object)src.getValue())) {
            case YES: {
                tgt.setValue((Object)Enumerations.ActionPrecheckBehavior.YES);
                break;
            }
            case NO: {
                tgt.setValue((Object)Enumerations.ActionPrecheckBehavior.NO);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionPrecheckBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.ActionPrecheckBehavior> convertActionPrecheckBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.ActionPrecheckBehavior> tgt = new Enumeration<RequestGroup.ActionPrecheckBehavior>(new RequestGroup.ActionPrecheckBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionPrecheckBehavior)((Object)src.getValue())) {
            case YES: {
                tgt.setValue((Object)RequestGroup.ActionPrecheckBehavior.YES);
                break;
            }
            case NO: {
                tgt.setValue((Object)RequestGroup.ActionPrecheckBehavior.NO);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.ActionPrecheckBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior> convertActionCardinalityBehavior(Enumeration<RequestGroup.ActionCardinalityBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior>(new Enumerations.ActionCardinalityBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.ActionCardinalityBehavior)((Object)src.getValue())) {
            case SINGLE: {
                tgt.setValue((Object)Enumerations.ActionCardinalityBehavior.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)Enumerations.ActionCardinalityBehavior.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionCardinalityBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.ActionCardinalityBehavior> convertActionCardinalityBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.ActionCardinalityBehavior> tgt = new Enumeration<RequestGroup.ActionCardinalityBehavior>(new RequestGroup.ActionCardinalityBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionCardinalityBehavior)((Object)src.getValue())) {
            case SINGLE: {
                tgt.setValue((Object)RequestGroup.ActionCardinalityBehavior.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)RequestGroup.ActionCardinalityBehavior.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.ActionCardinalityBehavior.NULL);
            }
        }
        return tgt;
    }

    public static RequestGroup.RequestGroupActionConditionComponent convertRequestGroupActionConditionComponent(RequestGroup.RequestGroupActionConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RequestGroup.RequestGroupActionConditionComponent tgt = new RequestGroup.RequestGroupActionConditionComponent();
        RequestGroup40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(RequestGroup40_50.convertActionConditionKind(src.getKindElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(RequestGroup40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }

    public static RequestGroup.RequestGroupActionConditionComponent convertRequestGroupActionConditionComponent(RequestGroup.RequestGroupActionConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RequestGroup.RequestGroupActionConditionComponent tgt = new RequestGroup.RequestGroupActionConditionComponent();
        RequestGroup40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(RequestGroup40_50.convertActionConditionKind(src.getKindElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(RequestGroup40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind> convertActionConditionKind(Enumeration<RequestGroup.ActionConditionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind>(new Enumerations.ActionConditionKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.ActionConditionKind)((Object)src.getValue())) {
            case APPLICABILITY: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.APPLICABILITY);
                break;
            }
            case START: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.START);
                break;
            }
            case STOP: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.STOP);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.ActionConditionKind> convertActionConditionKind(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.ActionConditionKind> tgt = new Enumeration<RequestGroup.ActionConditionKind>(new RequestGroup.ActionConditionKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionConditionKind)((Object)src.getValue())) {
            case APPLICABILITY: {
                tgt.setValue((Object)RequestGroup.ActionConditionKind.APPLICABILITY);
                break;
            }
            case START: {
                tgt.setValue((Object)RequestGroup.ActionConditionKind.START);
                break;
            }
            case STOP: {
                tgt.setValue((Object)RequestGroup.ActionConditionKind.STOP);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.ActionConditionKind.NULL);
            }
        }
        return tgt;
    }

    public static RequestGroup.RequestGroupActionRelatedActionComponent convertRequestGroupActionRelatedActionComponent(RequestGroup.RequestGroupActionRelatedActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RequestGroup.RequestGroupActionRelatedActionComponent tgt = new RequestGroup.RequestGroupActionRelatedActionComponent();
        RequestGroup40_50.copyElement(src, tgt, new String[0]);
        if (src.hasActionId()) {
            tgt.setActionIdElement(RequestGroup40_50.convertId(src.getActionIdElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationshipElement(RequestGroup40_50.convertActionRelationshipType(src.getRelationshipElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(RequestGroup40_50.convertType(src.getOffset()));
        }
        return tgt;
    }

    public static RequestGroup.RequestGroupActionRelatedActionComponent convertRequestGroupActionRelatedActionComponent(RequestGroup.RequestGroupActionRelatedActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RequestGroup.RequestGroupActionRelatedActionComponent tgt = new RequestGroup.RequestGroupActionRelatedActionComponent();
        RequestGroup40_50.copyElement(src, tgt, new String[0]);
        if (src.hasActionId()) {
            tgt.setActionIdElement(RequestGroup40_50.convertId(src.getActionIdElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationshipElement(RequestGroup40_50.convertActionRelationshipType(src.getRelationshipElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(RequestGroup40_50.convertType(src.getOffset()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType> convertActionRelationshipType(Enumeration<RequestGroup.ActionRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RequestGroup.ActionRelationshipType)((Object)src.getValue())) {
            case BEFORESTART: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.BEFORESTART);
                break;
            }
            case BEFORE: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.BEFORE);
                break;
            }
            case BEFOREEND: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.BEFOREEND);
                break;
            }
            case CONCURRENTWITHSTART: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.CONCURRENTWITHSTART);
                break;
            }
            case CONCURRENT: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.CONCURRENT);
                break;
            }
            case CONCURRENTWITHEND: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.CONCURRENTWITHEND);
                break;
            }
            case AFTERSTART: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.AFTERSTART);
                break;
            }
            case AFTER: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.AFTER);
                break;
            }
            case AFTEREND: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.AFTEREND);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RequestGroup.ActionRelationshipType> convertActionRelationshipType(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RequestGroup.ActionRelationshipType> tgt = new Enumeration<RequestGroup.ActionRelationshipType>(new RequestGroup.ActionRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionRelationshipType)((Object)src.getValue())) {
            case BEFORESTART: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.BEFORESTART);
                break;
            }
            case BEFORE: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.BEFORE);
                break;
            }
            case BEFOREEND: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.BEFOREEND);
                break;
            }
            case CONCURRENTWITHSTART: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.CONCURRENTWITHSTART);
                break;
            }
            case CONCURRENT: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.CONCURRENT);
                break;
            }
            case CONCURRENTWITHEND: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.CONCURRENTWITHEND);
                break;
            }
            case AFTERSTART: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.AFTERSTART);
                break;
            }
            case AFTER: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.AFTER);
                break;
            }
            case AFTEREND: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.AFTEREND);
                break;
            }
            default: {
                tgt.setValue((Object)RequestGroup.ActionRelationshipType.NULL);
            }
        }
        return tgt;
    }
}

