/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.QuestionnaireResponse;

public class QuestionnaireResponse40_50
extends VersionConvertor_40_50 {
    public static QuestionnaireResponse convertQuestionnaireResponse(org.hl7.fhir.r4.model.QuestionnaireResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse tgt = new QuestionnaireResponse();
        QuestionnaireResponse40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(QuestionnaireResponse40_50.convertIdentifier(src.getIdentifier()));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(QuestionnaireResponse40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(QuestionnaireResponse40_50.convertReference(reference));
        }
        if (src.hasQuestionnaire()) {
            tgt.setQuestionnaireElement(QuestionnaireResponse40_50.convertCanonical(src.getQuestionnaireElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(QuestionnaireResponse40_50.convertQuestionnaireResponseStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(QuestionnaireResponse40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(QuestionnaireResponse40_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthored()) {
            tgt.setAuthoredElement(QuestionnaireResponse40_50.convertDateTime(src.getAuthoredElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(QuestionnaireResponse40_50.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(QuestionnaireResponse40_50.convertReference(src.getSource()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent questionnaireResponseItemComponent : src.getItem()) {
            tgt.addItem(QuestionnaireResponse40_50.convertQuestionnaireResponseItemComponent(questionnaireResponseItemComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.QuestionnaireResponse convertQuestionnaireResponse(QuestionnaireResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.QuestionnaireResponse tgt = new org.hl7.fhir.r4.model.QuestionnaireResponse();
        QuestionnaireResponse40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(QuestionnaireResponse40_50.convertIdentifier(src.getIdentifier()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(QuestionnaireResponse40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(QuestionnaireResponse40_50.convertReference(reference));
        }
        if (src.hasQuestionnaire()) {
            tgt.setQuestionnaireElement(QuestionnaireResponse40_50.convertCanonical(src.getQuestionnaireElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(QuestionnaireResponse40_50.convertQuestionnaireResponseStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(QuestionnaireResponse40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(QuestionnaireResponse40_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthored()) {
            tgt.setAuthoredElement(QuestionnaireResponse40_50.convertDateTime(src.getAuthoredElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(QuestionnaireResponse40_50.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(QuestionnaireResponse40_50.convertReference(src.getSource()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent questionnaireResponseItemComponent : src.getItem()) {
            tgt.addItem(QuestionnaireResponse40_50.convertQuestionnaireResponseItemComponent(questionnaireResponseItemComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> convertQuestionnaireResponseStatus(Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus>(new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((QuestionnaireResponse.QuestionnaireResponseStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.STOPPED);
                break;
            }
            default: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> convertQuestionnaireResponseStatus(org.hl7.fhir.r5.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> tgt = new Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus>(new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((QuestionnaireResponse.QuestionnaireResponseStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.STOPPED);
                break;
            }
            default: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        QuestionnaireResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(QuestionnaireResponse40_50.convertString(src.getLinkIdElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(QuestionnaireResponse40_50.convertUri(src.getDefinitionElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(QuestionnaireResponse40_50.convertString(src.getTextElement()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent questionnaireResponseItemAnswerComponent : src.getAnswer()) {
            tgt.addAnswer(QuestionnaireResponse40_50.convertQuestionnaireResponseItemAnswerComponent(questionnaireResponseItemAnswerComponent));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent questionnaireResponseItemComponent : src.getItem()) {
            tgt.addItem(QuestionnaireResponse40_50.convertQuestionnaireResponseItemComponent(questionnaireResponseItemComponent));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        QuestionnaireResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(QuestionnaireResponse40_50.convertString(src.getLinkIdElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(QuestionnaireResponse40_50.convertUri(src.getDefinitionElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(QuestionnaireResponse40_50.convertString(src.getTextElement()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent questionnaireResponseItemAnswerComponent : src.getAnswer()) {
            tgt.addAnswer(QuestionnaireResponse40_50.convertQuestionnaireResponseItemAnswerComponent(questionnaireResponseItemAnswerComponent));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent questionnaireResponseItemComponent : src.getItem()) {
            tgt.addItem(QuestionnaireResponse40_50.convertQuestionnaireResponseItemComponent(questionnaireResponseItemComponent));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        QuestionnaireResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(QuestionnaireResponse40_50.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(QuestionnaireResponse40_50.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        QuestionnaireResponse40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(QuestionnaireResponse40_50.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(QuestionnaireResponse40_50.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }
}

