/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Practitioner;

public class Practitioner40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Practitioner convertPractitioner(Practitioner src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Practitioner tgt = new org.hl7.fhir.r5.model.Practitioner();
        Practitioner40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Practitioner40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Practitioner40_50.convertBoolean(src.getActiveElement()));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(Practitioner40_50.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Practitioner40_50.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r4.model.Address address : src.getAddress()) {
            tgt.addAddress(Practitioner40_50.convertAddress(address));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(Practitioner40_50.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.r4.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(Practitioner40_50.convertAttachment(attachment));
        }
        for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : src.getQualification()) {
            tgt.addQualification(Practitioner40_50.convertPractitionerQualificationComponent(practitionerQualificationComponent));
        }
        for (CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(Practitioner40_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Practitioner convertPractitioner(org.hl7.fhir.r5.model.Practitioner src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner tgt = new Practitioner();
        Practitioner40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Practitioner40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Practitioner40_50.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.r5.model.HumanName humanName : src.getName()) {
            tgt.addName(Practitioner40_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Practitioner40_50.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(Practitioner40_50.convertAddress(address));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(Practitioner40_50.convertDate(src.getBirthDateElement()));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(Practitioner40_50.convertAttachment(attachment));
        }
        for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : src.getQualification()) {
            tgt.addQualification(Practitioner40_50.convertPractitionerQualificationComponent(practitionerQualificationComponent));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(Practitioner40_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        Practitioner40_50.copyElement(src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(Practitioner40_50.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(Practitioner40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Practitioner40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(Practitioner40_50.convertReference(src.getIssuer()));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        Practitioner40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(Practitioner40_50.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(Practitioner40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Practitioner40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(Practitioner40_50.convertReference(src.getIssuer()));
        }
        return tgt;
    }
}

