/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.RelatedArtifact;

public class PlanDefinition40_50
extends VersionConvertor_40_50 {
    public static PlanDefinition convertPlanDefinition(org.hl7.fhir.r4.model.PlanDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition tgt = new PlanDefinition();
        PlanDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(PlanDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(PlanDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(PlanDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(PlanDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(PlanDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(PlanDefinition40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasType()) {
            tgt.setType(PlanDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(PlanDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(PlanDefinition40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(PlanDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(PlanDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(PlanDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(PlanDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(PlanDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(PlanDefinition40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(PlanDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(PlanDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(PlanDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(PlanDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(PlanDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getLibrary()) {
            tgt.getLibrary().add(PlanDefinition40_50.convertCanonical(canonicalType));
        }
        for (PlanDefinition.PlanDefinitionGoalComponent planDefinitionGoalComponent : src.getGoal()) {
            tgt.addGoal(PlanDefinition40_50.convertPlanDefinitionGoalComponent(planDefinitionGoalComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition40_50.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.PlanDefinition convertPlanDefinition(PlanDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.PlanDefinition tgt = new org.hl7.fhir.r4.model.PlanDefinition();
        PlanDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(PlanDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(PlanDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(PlanDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(PlanDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(PlanDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(PlanDefinition40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasType()) {
            tgt.setType(PlanDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(PlanDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(PlanDefinition40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(PlanDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(PlanDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(PlanDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(PlanDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(PlanDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(PlanDefinition40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(PlanDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(PlanDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(PlanDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(PlanDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(PlanDefinition40_50.convertContactDetail(contactDetail));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(PlanDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (CanonicalType canonicalType : src.getLibrary()) {
            tgt.getLibrary().add(PlanDefinition40_50.convertCanonical(canonicalType));
        }
        for (PlanDefinition.PlanDefinitionGoalComponent planDefinitionGoalComponent : src.getGoal()) {
            tgt.addGoal(PlanDefinition40_50.convertPlanDefinitionGoalComponent(planDefinitionGoalComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition40_50.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalComponent convertPlanDefinitionGoalComponent(PlanDefinition.PlanDefinitionGoalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalComponent tgt = new PlanDefinition.PlanDefinitionGoalComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(PlanDefinition40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(PlanDefinition40_50.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(PlanDefinition40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasStart()) {
            tgt.setStart(PlanDefinition40_50.convertCodeableConcept(src.getStart()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getAddresses()) {
            tgt.addAddresses(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(PlanDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (PlanDefinition.PlanDefinitionGoalTargetComponent planDefinitionGoalTargetComponent : src.getTarget()) {
            tgt.addTarget(PlanDefinition40_50.convertPlanDefinitionGoalTargetComponent(planDefinitionGoalTargetComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalComponent convertPlanDefinitionGoalComponent(PlanDefinition.PlanDefinitionGoalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalComponent tgt = new PlanDefinition.PlanDefinitionGoalComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(PlanDefinition40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(PlanDefinition40_50.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(PlanDefinition40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasStart()) {
            tgt.setStart(PlanDefinition40_50.convertCodeableConcept(src.getStart()));
        }
        for (CodeableConcept codeableConcept : src.getAddresses()) {
            tgt.addAddresses(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(PlanDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (PlanDefinition.PlanDefinitionGoalTargetComponent planDefinitionGoalTargetComponent : src.getTarget()) {
            tgt.addTarget(PlanDefinition40_50.convertPlanDefinitionGoalTargetComponent(planDefinitionGoalTargetComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalTargetComponent convertPlanDefinitionGoalTargetComponent(PlanDefinition.PlanDefinitionGoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalTargetComponent tgt = new PlanDefinition.PlanDefinitionGoalTargetComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(PlanDefinition40_50.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(PlanDefinition40_50.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(PlanDefinition40_50.convertDuration(src.getDue()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionGoalTargetComponent convertPlanDefinitionGoalTargetComponent(PlanDefinition.PlanDefinitionGoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionGoalTargetComponent tgt = new PlanDefinition.PlanDefinitionGoalTargetComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(PlanDefinition40_50.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(PlanDefinition40_50.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(PlanDefinition40_50.convertDuration(src.getDue()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionComponent convertPlanDefinitionActionComponent(PlanDefinition.PlanDefinitionActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionComponent tgt = new PlanDefinition.PlanDefinitionActionComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPrefix()) {
            tgt.setPrefixElement(PlanDefinition40_50.convertString(src.getPrefixElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(PlanDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(PlanDefinition40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTextEquivalent()) {
            tgt.setTextEquivalentElement(PlanDefinition40_50.convertString(src.getTextEquivalentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(PlanDefinition40_50.convertRequestPriority(src.getPriorityElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(PlanDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r4.model.IdType idType : src.getGoalId()) {
            tgt.getGoalId().add(PlanDefinition40_50.convertId(idType));
        }
        if (src.hasSubject()) {
            tgt.setSubject(PlanDefinition40_50.convertType(src.getSubject()));
        }
        for (TriggerDefinition triggerDefinition : src.getTrigger()) {
            tgt.addTrigger(PlanDefinition40_50.convertTriggerDefinition(triggerDefinition));
        }
        for (PlanDefinition.PlanDefinitionActionConditionComponent planDefinitionActionConditionComponent : src.getCondition()) {
            tgt.addCondition(PlanDefinition40_50.convertPlanDefinitionActionConditionComponent(planDefinitionActionConditionComponent));
        }
        for (org.hl7.fhir.r4.model.DataRequirement dataRequirement : src.getInput()) {
            tgt.addInput(PlanDefinition40_50.convertDataRequirement(dataRequirement));
        }
        for (org.hl7.fhir.r4.model.DataRequirement dataRequirement : src.getOutput()) {
            tgt.addOutput(PlanDefinition40_50.convertDataRequirement(dataRequirement));
        }
        for (PlanDefinition.PlanDefinitionActionRelatedActionComponent planDefinitionActionRelatedActionComponent : src.getRelatedAction()) {
            tgt.addRelatedAction(PlanDefinition40_50.convertPlanDefinitionActionRelatedActionComponent(planDefinitionActionRelatedActionComponent));
        }
        if (src.hasTiming()) {
            tgt.setTiming(PlanDefinition40_50.convertType(src.getTiming()));
        }
        for (PlanDefinition.PlanDefinitionActionParticipantComponent planDefinitionActionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(PlanDefinition40_50.convertPlanDefinitionActionParticipantComponent(planDefinitionActionParticipantComponent));
        }
        if (src.hasType()) {
            tgt.setType(PlanDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasGroupingBehavior()) {
            tgt.setGroupingBehaviorElement(PlanDefinition40_50.convertActionGroupingBehavior(src.getGroupingBehaviorElement()));
        }
        if (src.hasSelectionBehavior()) {
            tgt.setSelectionBehaviorElement(PlanDefinition40_50.convertActionSelectionBehavior(src.getSelectionBehaviorElement()));
        }
        if (src.hasRequiredBehavior()) {
            tgt.setRequiredBehaviorElement(PlanDefinition40_50.convertActionRequiredBehavior(src.getRequiredBehaviorElement()));
        }
        if (src.hasPrecheckBehavior()) {
            tgt.setPrecheckBehaviorElement(PlanDefinition40_50.convertActionPrecheckBehavior(src.getPrecheckBehaviorElement()));
        }
        if (src.hasCardinalityBehavior()) {
            tgt.setCardinalityBehaviorElement(PlanDefinition40_50.convertActionCardinalityBehavior(src.getCardinalityBehaviorElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(PlanDefinition40_50.convertType(src.getDefinition()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(PlanDefinition40_50.convertCanonical(src.getTransformElement()));
        }
        for (PlanDefinition.PlanDefinitionActionDynamicValueComponent planDefinitionActionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(PlanDefinition40_50.convertPlanDefinitionActionDynamicValueComponent(planDefinitionActionDynamicValueComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition40_50.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionComponent convertPlanDefinitionActionComponent(PlanDefinition.PlanDefinitionActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionComponent tgt = new PlanDefinition.PlanDefinitionActionComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPrefix()) {
            tgt.setPrefixElement(PlanDefinition40_50.convertString(src.getPrefixElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(PlanDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(PlanDefinition40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTextEquivalent()) {
            tgt.setTextEquivalentElement(PlanDefinition40_50.convertString(src.getTextEquivalentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(PlanDefinition40_50.convertRequestPriority(src.getPriorityElement()));
        }
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(PlanDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (RelatedArtifact relatedArtifact : src.getDocumentation()) {
            tgt.addDocumentation(PlanDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (IdType idType : src.getGoalId()) {
            tgt.getGoalId().add(PlanDefinition40_50.convertId(idType));
        }
        if (src.hasSubject()) {
            tgt.setSubject(PlanDefinition40_50.convertType(src.getSubject()));
        }
        for (org.hl7.fhir.r5.model.TriggerDefinition triggerDefinition : src.getTrigger()) {
            tgt.addTrigger(PlanDefinition40_50.convertTriggerDefinition(triggerDefinition));
        }
        for (PlanDefinition.PlanDefinitionActionConditionComponent planDefinitionActionConditionComponent : src.getCondition()) {
            tgt.addCondition(PlanDefinition40_50.convertPlanDefinitionActionConditionComponent(planDefinitionActionConditionComponent));
        }
        for (DataRequirement dataRequirement : src.getInput()) {
            tgt.addInput(PlanDefinition40_50.convertDataRequirement(dataRequirement));
        }
        for (DataRequirement dataRequirement : src.getOutput()) {
            tgt.addOutput(PlanDefinition40_50.convertDataRequirement(dataRequirement));
        }
        for (PlanDefinition.PlanDefinitionActionRelatedActionComponent planDefinitionActionRelatedActionComponent : src.getRelatedAction()) {
            tgt.addRelatedAction(PlanDefinition40_50.convertPlanDefinitionActionRelatedActionComponent(planDefinitionActionRelatedActionComponent));
        }
        if (src.hasTiming()) {
            tgt.setTiming(PlanDefinition40_50.convertType(src.getTiming()));
        }
        for (PlanDefinition.PlanDefinitionActionParticipantComponent planDefinitionActionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(PlanDefinition40_50.convertPlanDefinitionActionParticipantComponent(planDefinitionActionParticipantComponent));
        }
        if (src.hasType()) {
            tgt.setType(PlanDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasGroupingBehavior()) {
            tgt.setGroupingBehaviorElement(PlanDefinition40_50.convertActionGroupingBehavior(src.getGroupingBehaviorElement()));
        }
        if (src.hasSelectionBehavior()) {
            tgt.setSelectionBehaviorElement(PlanDefinition40_50.convertActionSelectionBehavior(src.getSelectionBehaviorElement()));
        }
        if (src.hasRequiredBehavior()) {
            tgt.setRequiredBehaviorElement(PlanDefinition40_50.convertActionRequiredBehavior(src.getRequiredBehaviorElement()));
        }
        if (src.hasPrecheckBehavior()) {
            tgt.setPrecheckBehaviorElement(PlanDefinition40_50.convertActionPrecheckBehavior(src.getPrecheckBehaviorElement()));
        }
        if (src.hasCardinalityBehavior()) {
            tgt.setCardinalityBehaviorElement(PlanDefinition40_50.convertActionCardinalityBehavior(src.getCardinalityBehaviorElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(PlanDefinition40_50.convertType(src.getDefinition()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(PlanDefinition40_50.convertCanonical(src.getTransformElement()));
        }
        for (PlanDefinition.PlanDefinitionActionDynamicValueComponent planDefinitionActionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(PlanDefinition40_50.convertPlanDefinitionActionDynamicValueComponent(planDefinitionActionDynamicValueComponent));
        }
        for (PlanDefinition.PlanDefinitionActionComponent planDefinitionActionComponent : src.getAction()) {
            tgt.addAction(PlanDefinition40_50.convertPlanDefinitionActionComponent(planDefinitionActionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertRequestPriority(Enumeration<PlanDefinition.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.RequestPriority> convertRequestPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.RequestPriority> tgt = new Enumeration<PlanDefinition.RequestPriority>(new PlanDefinition.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)PlanDefinition.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)PlanDefinition.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)PlanDefinition.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)PlanDefinition.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior> convertActionGroupingBehavior(Enumeration<PlanDefinition.ActionGroupingBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior>(new Enumerations.ActionGroupingBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionGroupingBehavior)((Object)src.getValue())) {
            case VISUALGROUP: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.VISUALGROUP);
                break;
            }
            case LOGICALGROUP: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.LOGICALGROUP);
                break;
            }
            case SENTENCEGROUP: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.SENTENCEGROUP);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionGroupingBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionGroupingBehavior> convertActionGroupingBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionGroupingBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionGroupingBehavior> tgt = new Enumeration<PlanDefinition.ActionGroupingBehavior>(new PlanDefinition.ActionGroupingBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionGroupingBehavior)((Object)src.getValue())) {
            case VISUALGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.VISUALGROUP);
                break;
            }
            case LOGICALGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.LOGICALGROUP);
                break;
            }
            case SENTENCEGROUP: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.SENTENCEGROUP);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionGroupingBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior> convertActionSelectionBehavior(Enumeration<PlanDefinition.ActionSelectionBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior>(new Enumerations.ActionSelectionBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionSelectionBehavior)((Object)src.getValue())) {
            case ANY: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ANY);
                break;
            }
            case ALL: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ALL);
                break;
            }
            case ALLORNONE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ALLORNONE);
                break;
            }
            case EXACTLYONE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.EXACTLYONE);
                break;
            }
            case ATMOSTONE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ATMOSTONE);
                break;
            }
            case ONEORMORE: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.ONEORMORE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionSelectionBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionSelectionBehavior> convertActionSelectionBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionSelectionBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionSelectionBehavior> tgt = new Enumeration<PlanDefinition.ActionSelectionBehavior>(new PlanDefinition.ActionSelectionBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionSelectionBehavior)((Object)src.getValue())) {
            case ANY: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ANY);
                break;
            }
            case ALL: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ALL);
                break;
            }
            case ALLORNONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ALLORNONE);
                break;
            }
            case EXACTLYONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.EXACTLYONE);
                break;
            }
            case ATMOSTONE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ATMOSTONE);
                break;
            }
            case ONEORMORE: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.ONEORMORE);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionSelectionBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior> convertActionRequiredBehavior(Enumeration<PlanDefinition.ActionRequiredBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior>(new Enumerations.ActionRequiredBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionRequiredBehavior)((Object)src.getValue())) {
            case MUST: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.MUST);
                break;
            }
            case COULD: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.COULD);
                break;
            }
            case MUSTUNLESSDOCUMENTED: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionRequiredBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionRequiredBehavior> convertActionRequiredBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRequiredBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionRequiredBehavior> tgt = new Enumeration<PlanDefinition.ActionRequiredBehavior>(new PlanDefinition.ActionRequiredBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionRequiredBehavior)((Object)src.getValue())) {
            case MUST: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.MUST);
                break;
            }
            case COULD: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.COULD);
                break;
            }
            case MUSTUNLESSDOCUMENTED: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionRequiredBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior> convertActionPrecheckBehavior(Enumeration<PlanDefinition.ActionPrecheckBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior>(new Enumerations.ActionPrecheckBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionPrecheckBehavior)((Object)src.getValue())) {
            case YES: {
                tgt.setValue((Object)Enumerations.ActionPrecheckBehavior.YES);
                break;
            }
            case NO: {
                tgt.setValue((Object)Enumerations.ActionPrecheckBehavior.NO);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionPrecheckBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionPrecheckBehavior> convertActionPrecheckBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionPrecheckBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionPrecheckBehavior> tgt = new Enumeration<PlanDefinition.ActionPrecheckBehavior>(new PlanDefinition.ActionPrecheckBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionPrecheckBehavior)((Object)src.getValue())) {
            case YES: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.YES);
                break;
            }
            case NO: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.NO);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionPrecheckBehavior.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior> convertActionCardinalityBehavior(Enumeration<PlanDefinition.ActionCardinalityBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior>(new Enumerations.ActionCardinalityBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionCardinalityBehavior)((Object)src.getValue())) {
            case SINGLE: {
                tgt.setValue((Object)Enumerations.ActionCardinalityBehavior.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)Enumerations.ActionCardinalityBehavior.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionCardinalityBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionCardinalityBehavior> convertActionCardinalityBehavior(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionCardinalityBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionCardinalityBehavior> tgt = new Enumeration<PlanDefinition.ActionCardinalityBehavior>(new PlanDefinition.ActionCardinalityBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionCardinalityBehavior)((Object)src.getValue())) {
            case SINGLE: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionCardinalityBehavior.NULL);
            }
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionConditionComponent convertPlanDefinitionActionConditionComponent(PlanDefinition.PlanDefinitionActionConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionConditionComponent tgt = new PlanDefinition.PlanDefinitionActionConditionComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(PlanDefinition40_50.convertActionConditionKind(src.getKindElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(PlanDefinition40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionConditionComponent convertPlanDefinitionActionConditionComponent(PlanDefinition.PlanDefinitionActionConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionConditionComponent tgt = new PlanDefinition.PlanDefinitionActionConditionComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(PlanDefinition40_50.convertActionConditionKind(src.getKindElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(PlanDefinition40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind> convertActionConditionKind(Enumeration<PlanDefinition.ActionConditionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind>(new Enumerations.ActionConditionKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionConditionKind)((Object)src.getValue())) {
            case APPLICABILITY: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.APPLICABILITY);
                break;
            }
            case START: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.START);
                break;
            }
            case STOP: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.STOP);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionConditionKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionConditionKind> convertActionConditionKind(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionConditionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionConditionKind> tgt = new Enumeration<PlanDefinition.ActionConditionKind>(new PlanDefinition.ActionConditionKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionConditionKind)((Object)src.getValue())) {
            case APPLICABILITY: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.APPLICABILITY);
                break;
            }
            case START: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.START);
                break;
            }
            case STOP: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.STOP);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionConditionKind.NULL);
            }
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionRelatedActionComponent convertPlanDefinitionActionRelatedActionComponent(PlanDefinition.PlanDefinitionActionRelatedActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionRelatedActionComponent tgt = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasActionId()) {
            tgt.setActionIdElement(PlanDefinition40_50.convertId(src.getActionIdElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationshipElement(PlanDefinition40_50.convertActionRelationshipType(src.getRelationshipElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(PlanDefinition40_50.convertType(src.getOffset()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionRelatedActionComponent convertPlanDefinitionActionRelatedActionComponent(PlanDefinition.PlanDefinitionActionRelatedActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionRelatedActionComponent tgt = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasActionId()) {
            tgt.setActionIdElement(PlanDefinition40_50.convertId(src.getActionIdElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationshipElement(PlanDefinition40_50.convertActionRelationshipType(src.getRelationshipElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(PlanDefinition40_50.convertType(src.getOffset()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType> convertActionRelationshipType(Enumeration<PlanDefinition.ActionRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionRelationshipType)((Object)src.getValue())) {
            case BEFORESTART: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.BEFORESTART);
                break;
            }
            case BEFORE: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.BEFORE);
                break;
            }
            case BEFOREEND: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.BEFOREEND);
                break;
            }
            case CONCURRENTWITHSTART: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.CONCURRENTWITHSTART);
                break;
            }
            case CONCURRENT: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.CONCURRENT);
                break;
            }
            case CONCURRENTWITHEND: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.CONCURRENTWITHEND);
                break;
            }
            case AFTERSTART: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.AFTERSTART);
                break;
            }
            case AFTER: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.AFTER);
                break;
            }
            case AFTEREND: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.AFTEREND);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionRelationshipType> convertActionRelationshipType(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionRelationshipType> tgt = new Enumeration<PlanDefinition.ActionRelationshipType>(new PlanDefinition.ActionRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionRelationshipType)((Object)src.getValue())) {
            case BEFORESTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFORESTART);
                break;
            }
            case BEFORE: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFORE);
                break;
            }
            case BEFOREEND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.BEFOREEND);
                break;
            }
            case CONCURRENTWITHSTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENTWITHSTART);
                break;
            }
            case CONCURRENT: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENT);
                break;
            }
            case CONCURRENTWITHEND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.CONCURRENTWITHEND);
                break;
            }
            case AFTERSTART: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTERSTART);
                break;
            }
            case AFTER: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTER);
                break;
            }
            case AFTEREND: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.AFTEREND);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionParticipantComponent convertPlanDefinitionActionParticipantComponent(PlanDefinition.PlanDefinitionActionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionParticipantComponent tgt = new PlanDefinition.PlanDefinitionActionParticipantComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(PlanDefinition40_50.convertActionParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(PlanDefinition40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionParticipantComponent convertPlanDefinitionActionParticipantComponent(PlanDefinition.PlanDefinitionActionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionParticipantComponent tgt = new PlanDefinition.PlanDefinitionActionParticipantComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(PlanDefinition40_50.convertActionParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(PlanDefinition40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType> convertActionParticipantType(Enumeration<PlanDefinition.ActionParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PlanDefinition.ActionParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.RELATEDPERSON);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PlanDefinition.ActionParticipantType> convertActionParticipantType(org.hl7.fhir.r5.model.Enumeration<Enumerations.ActionParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PlanDefinition.ActionParticipantType> tgt = new Enumeration<PlanDefinition.ActionParticipantType>(new PlanDefinition.ActionParticipantTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.RELATEDPERSON);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)PlanDefinition.ActionParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionDynamicValueComponent convertPlanDefinitionActionDynamicValueComponent(PlanDefinition.PlanDefinitionActionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionDynamicValueComponent tgt = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(PlanDefinition40_50.convertString(src.getPathElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(PlanDefinition40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }

    public static PlanDefinition.PlanDefinitionActionDynamicValueComponent convertPlanDefinitionActionDynamicValueComponent(PlanDefinition.PlanDefinitionActionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PlanDefinition.PlanDefinitionActionDynamicValueComponent tgt = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
        PlanDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(PlanDefinition40_50.convertString(src.getPathElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(PlanDefinition40_50.convertExpression(src.getExpression()));
        }
        return tgt;
    }
}

