/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PaymentNotice;

public class PaymentNotice40_50
extends VersionConvertor_40_50 {
    public static PaymentNotice convertPaymentNotice(org.hl7.fhir.r4.model.PaymentNotice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentNotice tgt = new PaymentNotice();
        PaymentNotice40_50.copyDomainResource(src, tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(PaymentNotice40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(PaymentNotice40_50.convertPaymentNoticeStatus(src.getStatusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(PaymentNotice40_50.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(PaymentNotice40_50.convertReference(src.getResponse()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(PaymentNotice40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(PaymentNotice40_50.convertReference(src.getProvider()));
        }
        if (src.hasPayment()) {
            tgt.setPayment(PaymentNotice40_50.convertReference(src.getPayment()));
        }
        if (src.hasPaymentDate()) {
            tgt.setPaymentDateElement(PaymentNotice40_50.convertDate(src.getPaymentDateElement()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(PaymentNotice40_50.convertReference(src.getPayee()));
        }
        if (src.hasRecipient()) {
            tgt.setRecipient(PaymentNotice40_50.convertReference(src.getRecipient()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(PaymentNotice40_50.convertMoney(src.getAmount()));
        }
        if (src.hasPaymentStatus()) {
            tgt.setPaymentStatus(PaymentNotice40_50.convertCodeableConcept(src.getPaymentStatus()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.PaymentNotice convertPaymentNotice(PaymentNotice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.PaymentNotice tgt = new org.hl7.fhir.r4.model.PaymentNotice();
        PaymentNotice40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(PaymentNotice40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(PaymentNotice40_50.convertPaymentNoticeStatus(src.getStatusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(PaymentNotice40_50.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(PaymentNotice40_50.convertReference(src.getResponse()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(PaymentNotice40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(PaymentNotice40_50.convertReference(src.getProvider()));
        }
        if (src.hasPayment()) {
            tgt.setPayment(PaymentNotice40_50.convertReference(src.getPayment()));
        }
        if (src.hasPaymentDate()) {
            tgt.setPaymentDateElement(PaymentNotice40_50.convertDate(src.getPaymentDateElement()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(PaymentNotice40_50.convertReference(src.getPayee()));
        }
        if (src.hasRecipient()) {
            tgt.setRecipient(PaymentNotice40_50.convertReference(src.getRecipient()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(PaymentNotice40_50.convertMoney(src.getAmount()));
        }
        if (src.hasPaymentStatus()) {
            tgt.setPaymentStatus(PaymentNotice40_50.convertCodeableConcept(src.getPaymentStatus()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertPaymentNoticeStatus(Enumeration<PaymentNotice.PaymentNoticeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PaymentNotice.PaymentNoticeStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PaymentNotice.PaymentNoticeStatus> convertPaymentNoticeStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PaymentNotice.PaymentNoticeStatus> tgt = new Enumeration<PaymentNotice.PaymentNoticeStatus>(new PaymentNotice.PaymentNoticeStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.NULL);
            }
        }
        return tgt;
    }
}

