/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Reference;

public class Patient40_50
extends VersionConvertor_40_50 {
    public static Patient convertPatient(org.hl7.fhir.r4.model.Patient src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient tgt = new Patient();
        Patient40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Patient40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Patient40_50.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.r4.model.HumanName humanName : src.getName()) {
            tgt.addName(Patient40_50.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Patient40_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(Patient40_50.convertDate(src.getBirthDateElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(Patient40_50.convertType(src.getDeceased()));
        }
        for (org.hl7.fhir.r4.model.Address address : src.getAddress()) {
            tgt.addAddress(Patient40_50.convertAddress(address));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(Patient40_50.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(Patient40_50.convertType(src.getMultipleBirth()));
        }
        for (org.hl7.fhir.r4.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(Patient40_50.convertAttachment(attachment));
        }
        for (Patient.ContactComponent contactComponent : src.getContact()) {
            tgt.addContact(Patient40_50.convertContactComponent(contactComponent));
        }
        for (Patient.PatientCommunicationComponent patientCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(Patient40_50.convertPatientCommunicationComponent(patientCommunicationComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getGeneralPractitioner()) {
            tgt.addGeneralPractitioner(Patient40_50.convertReference(reference));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(Patient40_50.convertReference(src.getManagingOrganization()));
        }
        for (Patient.PatientLinkComponent patientLinkComponent : src.getLink()) {
            tgt.addLink(Patient40_50.convertPatientLinkComponent(patientLinkComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Patient convertPatient(Patient src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Patient tgt = new org.hl7.fhir.r4.model.Patient();
        Patient40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Patient40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Patient40_50.convertBoolean(src.getActiveElement()));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(Patient40_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Patient40_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(Patient40_50.convertDate(src.getBirthDateElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(Patient40_50.convertType(src.getDeceased()));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(Patient40_50.convertAddress(address));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(Patient40_50.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(Patient40_50.convertType(src.getMultipleBirth()));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(Patient40_50.convertAttachment(attachment));
        }
        for (Patient.ContactComponent contactComponent : src.getContact()) {
            tgt.addContact(Patient40_50.convertContactComponent(contactComponent));
        }
        for (Patient.PatientCommunicationComponent patientCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(Patient40_50.convertPatientCommunicationComponent(patientCommunicationComponent));
        }
        for (Reference reference : src.getGeneralPractitioner()) {
            tgt.addGeneralPractitioner(Patient40_50.convertReference(reference));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(Patient40_50.convertReference(src.getManagingOrganization()));
        }
        for (Patient.PatientLinkComponent patientLinkComponent : src.getLink()) {
            tgt.addLink(Patient40_50.convertPatientLinkComponent(patientLinkComponent));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        Patient40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(Patient40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setName(Patient40_50.convertHumanName(src.getName()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Patient40_50.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(Patient40_50.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(Patient40_50.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Patient40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        Patient40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(Patient40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setName(Patient40_50.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Patient40_50.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(Patient40_50.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(Patient40_50.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Patient40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        Patient40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguage(Patient40_50.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(Patient40_50.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        Patient40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguage(Patient40_50.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(Patient40_50.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        Patient40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOther()) {
            tgt.setOther(Patient40_50.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Patient40_50.convertLinkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        Patient40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOther()) {
            tgt.setOther(Patient40_50.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Patient40_50.convertLinkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Patient.LinkType> convertLinkType(Enumeration<Patient.LinkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Patient.LinkType> tgt = new org.hl7.fhir.r5.model.Enumeration<Patient.LinkType>(new Patient.LinkTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Patient.LinkType)((Object)src.getValue())) {
            case REPLACEDBY: {
                tgt.setValue((Object)Patient.LinkType.REPLACEDBY);
                break;
            }
            case REPLACES: {
                tgt.setValue((Object)Patient.LinkType.REPLACES);
                break;
            }
            case REFER: {
                tgt.setValue((Object)Patient.LinkType.REFER);
                break;
            }
            case SEEALSO: {
                tgt.setValue((Object)Patient.LinkType.SEEALSO);
                break;
            }
            default: {
                tgt.setValue((Object)Patient.LinkType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Patient.LinkType> convertLinkType(org.hl7.fhir.r5.model.Enumeration<Patient.LinkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Patient.LinkType> tgt = new Enumeration<Patient.LinkType>(new Patient.LinkTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Patient.LinkType)((Object)src.getValue())) {
            case REPLACEDBY: {
                tgt.setValue((Object)Patient.LinkType.REPLACEDBY);
                break;
            }
            case REPLACES: {
                tgt.setValue((Object)Patient.LinkType.REPLACES);
                break;
            }
            case REFER: {
                tgt.setValue((Object)Patient.LinkType.REFER);
                break;
            }
            case SEEALSO: {
                tgt.setValue((Object)Patient.LinkType.SEEALSO);
                break;
            }
            default: {
                tgt.setValue((Object)Patient.LinkType.NULL);
            }
        }
        return tgt;
    }
}

