/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.StringType;

public class Organization40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Organization convertOrganization(Organization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Organization tgt = new org.hl7.fhir.r5.model.Organization();
        Organization40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Organization40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Organization40_50.convertBoolean(src.getActiveElement()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Organization40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(Organization40_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getAlias()) {
            tgt.getAlias().add(Organization40_50.convertString(stringType));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Organization40_50.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r4.model.Address address : src.getAddress()) {
            tgt.addAddress(Organization40_50.convertAddress(address));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(Organization40_50.convertReference(src.getPartOf()));
        }
        for (Organization.OrganizationContactComponent organizationContactComponent : src.getContact()) {
            tgt.addContact(Organization40_50.convertOrganizationContactComponent(organizationContactComponent));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(Organization40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Organization convertOrganization(org.hl7.fhir.r5.model.Organization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization tgt = new Organization();
        Organization40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Organization40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(Organization40_50.convertBoolean(src.getActiveElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Organization40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(Organization40_50.convertString(src.getNameElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.getAlias().add(Organization40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Organization40_50.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(Organization40_50.convertAddress(address));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(Organization40_50.convertReference(src.getPartOf()));
        }
        for (Organization.OrganizationContactComponent organizationContactComponent : src.getContact()) {
            tgt.addContact(Organization40_50.convertOrganizationContactComponent(organizationContactComponent));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(Organization40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        Organization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(Organization40_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(Organization40_50.convertHumanName(src.getName()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(Organization40_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(Organization40_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        Organization40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(Organization40_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(Organization40_50.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(Organization40_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(Organization40_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }
}

